//import processing.sound.*;

class SensorAdv implements SensorBase
{
  public float x;
  public float y;
  public float r;
  
  public float xo;
  public float yo;
  
  public float R,B,G;
  
  private float amp;
  
//  public Pulse snd;
  
  FloatList ampHis;
  
  float varMax = 0;
  
  PImage img;
  
  private boolean isClicked = false;
  
  public boolean click(float _x, float _y)
  {
    if(sqrt((x-_x)*(x-_x) + (y-_y)*(y-_y)) < r)
    {
      isClicked = true;
      xo = x - _x;
      yo = y - _y;
      return true;
    }
    else return false;
  }
  
  public void move(float _x, float _y)
  {
    if(isClicked) 
    {
      x = _x+xo;
      y = _y+yo;
    }
  }
  
  public void unclick()
  {
    isClicked = false;
  }
  
  public void displayAREA()
  {
//    snd.amp(amp);
    fill(R,G,B);
    //ellipse(x,y,r,r);
    
    pushMatrix();
    translate(x,y);
    image(img, -img.width/2, -img.width/2);
    popMatrix();
  }
  
  public void tick()
  {
    color col = get((int)x,(int)y);
    /*
    color col;
    {
    float tx = x / RegionScaleFactor;
    float ty = y / RegionScaleFactor;
    
    float val = CalculateAmplitude(tx,ty);
    val = ( val = ( 127 + val * 127) ) > 255.0 ? 255.0 : val < 0 ? 0.0 : val;
    
    col = color(val);
    }
    */
    advancedSensorHistory = (2/maxFreq)/dt;
    
    while(ampHis.size() > advancedSensorHistory)
    {
      ampHis.remove(0);
    }
    
    float avg =0;
    for(int i = 0; i < ampHis.size(); ++i)
    {
      avg += ampHis.get(i);
    }
    avg /= ampHis.size();
    
    float variance = 0;
    float tmp = 0;
    for(int i = 0; i < ampHis.size(); ++i)
    {
      variance += (tmp = ampHis.get(i) - avg) * tmp;
    }
    
    variance /= ampHis.size();
    variance = sqrt(variance);
    
    if(variance > varMax) varMax = variance;
    
    float val = ( green(col) + blue(col) + red(col) ) / 3;
    
    ampHis.append(abs(val));
    
    val = (val + avg)/2;
    
//    println("Average = "+avg+" Variance = "+variance+" Value = "+val+" Var Max = "+varMax);
    
    R = ( R = 255-(val)) > 255 ? 255 : R;
    G = (G = val) > 255 ? 255 : G;
    B = ( (B = (val > 127 ? 255 - val : val ) )*1) > 255 ? 255 : B;
    
    amp = variance / varMax;
    amp = amp > ampThreshold ? amp : 0;
    
    //snd.amp(amp);
    
    amp *= 2.; // Max should be 2.0, not 1.0
    
    println("Amplitude = "+round(100*amp)*1.0/100.);
    
    //println("R:"+R+" G:"+G+" B:"+B);    
  }
  
  public void display()
  {
    if(WaveMode == WAVE_MODE.WAVE_AREA && sensorActive) displayAREA();
  }
  
  SensorAdv(float _x, float _y, float _r, SoundLab lb)
  {
    img = loadImage(earIcon);
    //snd = new Pulse(lb);
    ampHis = new FloatList();
    x = _x;
    y = _y;
    r = _r;
    varMax = 50 / speakers.size();
    //snd.amp(0);
    //snd.freq(1200);
    
    ampHis.append(0);
  }
  
  public void enableSound()
  {
//    snd.play();
  }
  
  public void stopSound()
  {
//    snd.stop();
  }
};