float CalculateAmplitude(float x, float y)
{
  float amp = 0;   
  for (int i = 0; i < speakers.size(); ++i)
  {
    float sx = sizeScale*speakers.get(i).x/RegionScaleFactor; // This is the x-coordinate of this speaker. 
    float sy = sizeScale*speakers.get(i).y/RegionScaleFactor; // This is the y-coordinate of this speaker.

    // The distance between the sensor and the speaker. 
    float dist = sqrt((x-sx)*(x-sx) + (y-sy)*(y-sy))/sizeScale;
    //float dist = sqrt(x*x+y*y);

    if (dist<20*sizeScale) return 0;
    //if(dist>300) continue;

    float f = speakers.get(i).frequency; // The frequency of the speaker.
    float L = speakers.get(i).getWavelength(); // The wavelength of the waves. 

    float k = PI2/L;
    float omega = PI2*f;


    // Calculate the amplitude (and interference for speaker #i)
    // Student Code Goes Here
    // Either have the waveSine function or the heavySide function. 
    amp += waveSine(omega*time - k*dist);
    
  }
  return amp/speakers.size();
}



class Wave
{
  private float r;
  
  public float speed = SpeedOfSound;
  
  public float x;
  public float y;
  
  public float amplitude;
  
  float getRadius(){ return r; }
  
  void tick(float _dt)
  {
    if(_dt > 0) 
      r += speed * _dt;
  }
  
  void display()
  {
    {
      noFill();
      ellipse(x,y,r,r);
    }
  }
  
  Wave(float _x, float _y, float _dt)
  {
    x = _x;
    y = _y;
    tick(_dt);
  }
}


// -------------------------------------------------------------------------------------------------------------
//                    Speaker
// -------------------------------------------------------------------------------------------------------------
// Speaker icon from: http://www.iconarchive.com/show/speaker-icons-by-carvetia/Speaker-Black-Plastic-icon.html
// Free for non commercial usage. 
class Speaker
{
  public ArrayList<Wave> waves;
  
  private float tickTime;
  private float frequency;
  private float period;
  
  private float maxR;
  
  public float x;
  public float y;
  
  private PImage img;
  
  Speaker(float _x, float _y, float _f)
  {
     waves = new ArrayList<Wave>();
     img = loadImage(speakIcon);
     
     x = _x;
     y = _y;
     period = 1/_f;
     frequency = _f;
     
     maxR = sqrt(width*width + height*height)*2;
  }
  
  void newWave(float _dt)
  {
    waves.add(new Wave(x, y, _dt));
  }
  
  float getWavelength()
  {
    return SpeedOfSound / frequency;
  }
  
  void tickLine(float _dt)
  {
    // 
    tickTime += _dt;
    
    // If necessary, spawn more waves. 
    while(tickTime > period) { 
      newWave(tickTime - period);
      tickTime -= period;
    }
    
    for(int i = 0; i < waves.size(); ++i)
    {
      if(waves.get(i).getRadius() > maxR)
      {
        waves.remove(i);
        continue;
      }
      
      waves.get(i).tick(_dt);
    }
  }
  
  void tick(float _dt)
  {
    if(WaveMode==WAVE_MODE.WAVE_LINE) tickLine(_dt);
  }
  
  
  /*
  
  // Function retired. Now draws wave in global function. 
  
  void drawAreaWave()
  {
    loadPixels();
      float w = width/RegionScaleFactor;         // 2D space width
      float h = height/RegionScaleFactor;         // 2D space height
      float diag = sqrt(w*w+h*h);
      float dx = w / width;    // Increment x this amount per pixel
      float dy = h / height;   // Increment y this amount per pixel
      //float tx = x / width * 0.5;
      float tx = -x/width*w;
      
      float k = (1/getWavelength())*((2*PI));
      float omega = 2*PI*frequency;
      //println("omega = "+omega+" k = "+k);
      
      for (int i = 0; i < width; i++) {
        float ty = -y / height * h;
        for (int j = 0; j < height; j++) {
          float r = sqrt((tx*tx) + (ty*ty));    // Convert cartesian to polar
          float rWorld = sqrt((w*w) + (h*h));
          if(omega*time - k * r<0) continue;
          //if(r>time*SpeedOfSound/frequency) continue;
          float theta = atan2(ty,tx);         // Convert cartesian to polar
          // Compute 2D polar coordinate function
          //float val = sin(omega*time - k * r);           // Results in a value between -1 and 1
          float val = CalculateAmplitude(tx,ty);
          // Map resulting vale to grayscale value
          
          float mult = 2.0 * speakers.size();
          
          val = (val =  ( (val + 1.0) * 255.0/mult ) ) <= 255 ? val : 255;
          
          color c = color(val);
          pixels[i+j*width] += c;     // Scale to between 0 and 255
          ty += dy;                // Increment y
        }
        tx += dx;                  // Increment x
      }
    updatePixels();
  }*/
  
  void displayWave()
  {
    pushMatrix();
    //translate(x,y);
    if(WaveMode == WAVE_MODE.WAVE_LINE)
    {
      for(int i = 0; i < waves.size(); ++i)
      {
        waves.get(i).display();
      }
    }
    else if(WaveMode == WAVE_MODE.WAVE_AREA)
    {
      //drawAreaWave();
    }
    popMatrix();
  }
  
  void displaySpeak()
  {
    pushMatrix();
    translate(x,y);
    image(img, -img.width/2, -img.width/2);
    popMatrix();
  }
  
    public float xo;
  public float yo;
  
  private boolean isClicked = false;
  
  boolean click(float _x, float _y)
  {
    float r = sqrt(img.width*img.width+img.height*img.height)/2;
    if(sqrt((x-_x)*(x-_x) + (y-_y)*(y-_y)) < r)
    {
      isClicked = true;
      xo = x - _x;
      yo = y - _y;
      return true;
    }
    else return false;
  }
  
  void move(float _x, float _y)
  {
    if(isClicked) 
    {
      x = _x+xo;
//      y = _y+yo;
      y = _y; //hack to make the speakers stay on the same line
    }
  }
  
  void unclick()
  {
    isClicked = false;
  }
  
  void clearWaves()
  {
    waves.clear();
  }
}

void initAllSpeakers(){
  maxFreq = 1;
  for (int i = 0; i < speakers.size(); ++i)
  {
    if (speakers.get(i).frequency>maxFreq) maxFreq = speakers.get(i).frequency;
  }
}