
void drawPoint(float _x, float _y){
  stroke(255,0,0);
  strokeWeight(5);
  point(_x,  - ( _y - 0.5*(speaker1y+speaker2y)) +0.5*(speaker1y+speaker2y));
  stroke(0); 
}


// Functions for drawing the wave. 
float waveSine(float x)
{
  sensorActive = true;
  if(x>0){
    x = (x + 3.141592654)%6.283185308;
    if(x<0) x+= 6.283185308;
    x -= 3.141592654;
    float x2 = x*x;
    
    return ((((x-(x*=x2)/6.0)+(x*=x2)/120.0)-(x*=x2)/5040.0)+(x*=x2)/362880.0);
  }
  
  else return 0;
}

float heavySide(float x)
{
  sensorActive = false;
  if (abs(x%(PI2)) < 0.1) return -1; 
  else return 1;
}



void drawAreaWave()
{
  //loadPixels();
    if(autoSizeScale) autoOptimize();
    updateFrameSize();
    float w = frame.width/RegionScaleFactor;         // 2D space width
    float h = frame.height/RegionScaleFactor;         // 2D space height
    //float diag = sqrt(w*w+h*h);
    float dx = 1 / RegionScaleFactor;    // Increment x this amount per pixel
    float dy = 1 / RegionScaleFactor;   // Increment y this amount per pixel
    //float tx = x / width * 0.5;
    float tx = 0;
    
    int i = 0, j = 0; // Loop iterators
    
    float val, ty;// Temp values used in processing. 
    
    //println("omega = "+omega+" k = "+k);
//    println("Frame Size = ("+frame.width+", "+frame.height+"). ");
    
    // Do this if no dampening
    //if(!dampening){
      for (i = 0; i < frame.width; i+=1) {
        ty = 0;
        for (j = 0; j < frame.height; j+=1) {
  
          val = CalculateAmplitude(tx,ty);
          //if(WaveMode == WAVE_MODE.WAVE_HEAVY){
          //  val = heavyside(val);
          //}
          // Map resulting vale to grayscale value
          
          //val = (val =  ( (val + 1.0) * 255.0/mult ) ) <= 255 ? val : 255;
          val = ( val = ( 127 + val * 127) ) > 255.0 ? 255.0 : val < 0 ? 0.0 : val;
          
          frame.pixels[i+j*frame.width] = color(val);     // Scale to between 0 and 255
          ty += dy;                // Increment y
        }
        tx += dx;                  // Increment x
      }
    //}
    //else { //Dampening enabled
    //  for (int i = 0; i < width; i++) {
    //    float ty = 0 / RegionScaleFactor;
    //    for (int j = 0; j < height; j++) {
  
    //      float val = CalculateAmplitude(tx,ty);
    //      // Map resulting vale to grayscale value
          
    //      //val = (val =  ( (val + 1.0) * 255.0/mult ) ) <= 255 ? val : 255;
    //      val = ( val = ( 127 + val * 127) ) > 255.0 ? 255.0 : val < 0 ? 0.0 : val;
          
    //      color c = color(val);
    //      pixels[i+j*width] = c;     // Scale to between 0 and 255
    //      ty += dy;                // Increment y
    //    }
    //    tx += dx;                  // Increment x
    //  }
    //}
  //updatePixels();
  frame.updatePixels();
  if(sizeScale<1) 
  {
    frame.resize(width,height);
  }
  image(frame,0,0);
}

int SINE_SIZE = 10;


float fast_sin(float x)
{
  if(x>0){
    x = (x + 3.141592654)%6.283185308;
    if(x<0) x+= 6.283185308;
    x -= 3.141592654;
    
    float sum = 0;
    float power = x;
    float sign = 1.0;
    float x2 = x*x;
    float fact = 1;
    
    for(int i = 1; i < SINE_SIZE; i+=2)
    {
      sum += sign*power/fact;
      power *= x2;
      sign *= -1.0;
      fact *= (i+1)*(i+2);
    }
    
    return sum;
  }
  else return 0;
}

void updateFrameSize()
{
  int w = int(width*sizeScale);
  int h = int(height*sizeScale);
  frame.resize(w,h);
  frame.loadPixels();

  DiagonalLength = sqrt(width*width+height*height);
}

void autoOptimize()
{
  if(frameRate<frameRateThreshMIN){
    sizeScale *= frameRateScaleMod;
  }
  else if(frameRate>frameRateThreshMAX){
    sizeScale /= frameRateScaleMod;
  }
  if(sizeScale>1) sizeScale = 1;
  
  if(sizeScale<0.1)
  {
    sizeScale = 0.1;
    if(aggressiveOptimization) SINE_SIZE = 8;
  }
  else
  {
    SINE_SIZE = 10;
  }
}

void display(){
  time += dt;
  if (autoAdjustTime) autoTimeAdjust();
  
  
  for (int i = 0; i < sensors.size(); ++i)
  {
    if(sensorActive) sensors.get(i).enableSound();
    else sensors.get(i).stopSound();
  }
  
  if (WaveMode==WAVE_MODE.WAVE_LINE) background(255);
  else background(0);

  for (int i = 0; i < sensors.size() && clicked; ++i)
  {
    sensors.get(i).move(mouseX, mouseY);
  }

  for (int i = 0; i < speakers.size() && clicked; ++i)
  {
    speakers.get(i).move(mouseX, speakery);
  }

  for (int i = 0; i < speakers.size(); ++i)
  {
    speakers.get(i).tick(dt);
  }

  if (WaveMode==WAVE_MODE.WAVE_AREA)drawAreaWave();
  else
  {
    for (int i = 0; i < speakers.size(); ++i)
    {
      for (int w = 0; w < speakers.get(i).waves.size(); ++w)
      {
        speakers.get(i).waves.get(w).display();
      }
    }
  }

  for (int i = 0; i < sensors.size(); ++i)
  {
    sensors.get(i).tick();
  }

  for (int i = 0; i < speakers.size(); ++i)
  {
    speakers.get(i).displaySpeak();
  }

  for (int i = 0; i < sensors.size(); ++i)
  {
    sensors.get(i).display();
  }
}


float lastTime = 0;

void autoTimeAdjust()
{
  float tickTime = millis() - lastTime;
  lastTime = millis();
  dt = tickTime / 1000;
//  println("Time = "+tickTime+"       dt = "+dt+"         frame rate = "+frameRate+"           Size Scale = "+sizeScale);
}