VERSION 6
BEGIN SCHEMATIC
    BEGIN ATTR DeviceFamilyName "virtex2p"
        DELETE all:0
        EDITNAME all:0
        EDITTRAIT all:0
    END ATTR
    BEGIN NETLIST
        SIGNAL RXUSRCLK2
        SIGNAL RECEIVE(15:0)
        SIGNAL RXDATA(15:0)
        SIGNAL RXRESET
        SIGNAL SOP
        SIGNAL TX_ADDR(1:0)
        SIGNAL TX_MAC(15:0)
        SIGNAL DFLT_MAC(15:0)
        SIGNAL PROMISC
        SIGNAL STATE_ERR(3:0)
        SIGNAL UPD_FRAME_STATS
        SIGNAL XLXN_1691
        SIGNAL XLXN_1692
        SIGNAL XLXN_1693
        SIGNAL LEN_OK
        SIGNAL XLXN_1695
        SIGNAL RX_ERR
        SIGNAL FF_MAC_PUSH
        SIGNAL XLXN_1845
        SIGNAL PASS_THRU
        SIGNAL EOP
        SIGNAL CAR_XTEND
        SIGNAL ERR_PROP
        SIGNAL RCV_ADDR(1:0)
        SIGNAL MACBUS(15:0)
        SIGNAL WADDR_TYPE(4:0)
        SIGNAL MWE
        SIGNAL ALL_MACS(63:0)
        SIGNAL RXCHARISK(1:0)
        SIGNAL RXVALDAT
        SIGNAL PKT_DATA(15:0)
        SIGNAL FRAME_REQ
        SIGNAL FF_RDY
        SIGNAL FRAME_LENGTH(12:0)
        SIGNAL PKT_FF_DATA(15:0)
        SIGNAL RCTRL(2:0)
        SIGNAL RXRUNDISP(1:0)
        SIGNAL RXNOTINTABLE(1:0)
        SIGNAL RXLOSSOFSYNC(1:0)
        SIGNAL RXDISPERR(1:0)
        SIGNAL RXCLKCORCNT(2:0)
        SIGNAL RXCHARISCOMMA(1:0)
        SIGNAL RXBUFSTATUS(1:0)
        SIGNAL RXCOMMADET
        SIGNAL RXREALIGN
        SIGNAL RXCHECKINGCRC
        SIGNAL RXCRCERR
        SIGNAL DRPD_CNT(31:0)
        SIGNAL RCVD_CNT(31:0)
        SIGNAL TXKERR(1:0)
        SIGNAL TXBUFERR
        SIGNAL TXRUNDISP(1:0)
        SIGNAL TXSTATUS(15:0)
        SIGNAL XMIT_CNT(31:0)
        SIGNAL XERR_CNT(31:0)
        SIGNAL NORM_PB_MT
        SIGNAL NORM_PB_AF
        SIGNAL NORM_PB_FULL
        SIGNAL PRIO_PB_FULL
        SIGNAL PRIO_PB_AF
        SIGNAL PRIO_PB_MT
        SIGNAL TXUSRCLK2
        SIGNAL TXRESET
        SIGNAL TX_PROC_S
        SIGNAL PROT_ENA
        SIGNAL XTEND
        SIGNAL SPONT_PB_MT
        SIGNAL SPONT_PB_AF
        SIGNAL SPONT_PB_FULL
        SIGNAL SPONT_PKT_ENA
        SIGNAL PRIO_PKT_ENA
        SIGNAL NORM_PKT_ENA
        SIGNAL ETHER_CNFG(15:0)
        SIGNAL TX_INPRGS
        SIGNAL TX_UPDT
        SIGNAL TX_ERR
        SIGNAL TX_ERR_RST
        SIGNAL TX_MAC_DEST_ERR
        SIGNAL TX_PROC_N
        SIGNAL TX_PROC_P
        SIGNAL FRC_RLD_CMD
        SIGNAL RST_CMDS
        SIGNAL FORCE_RELOAD
        SIGNAL RXSTATUS(15:0)
        SIGNAL GOOD_FRAME
        SIGNAL ACTIVE
        SIGNAL FF_MT
        SIGNAL FF_FULL
        SIGNAL FF_AF
        SIGNAL TXDATA(15:0)
        SIGNAL TXCHARISK(1:0)
        SIGNAL PRIO_VALID
        SIGNAL NORM_VALID
        SIGNAL SPONT_VALID
        SIGNAL TXCAT(1:0)
        SIGNAL SPONT_RDY
        SIGNAL SPONT_FRAG_NUM(31:0)
        SIGNAL SPONT_FRAG
        SIGNAL SPONT_NEW
        SIGNAL SPONT_TYPE_STAT(11:0)
        SIGNAL SPONT_LEN(12:0)
        SIGNAL SPONT_DATA(15:0)
        SIGNAL SPONT_POP
        SIGNAL PRIO_FRAG_NUM(31:0)
        SIGNAL PRIO_FRAG
        SIGNAL PRIO_NEW
        SIGNAL PRIO_TYPE_STAT(11:0)
        SIGNAL PRIO_LEN(12:0)
        SIGNAL PRIO_RDY
        SIGNAL PRIO_POP
        SIGNAL PRIO_DATA(15:0)
        SIGNAL NORM_RDY
        SIGNAL NORM_FRAG_NUM(31:0)
        SIGNAL NORM_NEW
        SIGNAL NORM_FRAG
        SIGNAL NORM_LEN(12:0)
        SIGNAL NORM_TYPE_STAT(11:0)
        SIGNAL NORM_DATA(15:0)
        SIGNAL NORM_POP
        SIGNAL NORM_POPMH
        SIGNAL NORM_MAC_HDR(15:0)
        SIGNAL PRIO_MAC_HDR(15:0)
        SIGNAL SPONT_MAC_HDR(15:0)
        SIGNAL PRIO_POPMH
        SIGNAL SPONT_POPMH
        SIGNAL DFLT_ADDR(1:0)
        SIGNAL TRANSMIT(15:0)
        SIGNAL TXINSTR(2:0)
        SIGNAL NORM_MHBITS(1:0)
        SIGNAL PRIO_MHBITS(1:0)
        SIGNAL SPONT_MHBITS(1:0)
        SIGNAL FRAME_STAT_VALID
        SIGNAL NORM_MH_MT
        SIGNAL PRIO_MH_MT
        SIGNAL SPONT_MH_MT
        SIGNAL MOD_ENA(5:0)
        SIGNAL MOD_ENA(5)
        SIGNAL RST_SEQ
        SIGNAL MAC_REQ
        SIGNAL FF_READ
        SIGNAL MAC_SRC(15:0)
        SIGNAL FF_MAC_POP
        SIGNAL RXF_BUSY
        SIGNAL CP_RST
        SIGNAL ETH_RCV_BR
        SIGNAL ETH_RCV_BG
        SIGNAL PREP4SHTDWN
        SIGNAL RDY4SHTDWN
        SIGNAL USR_LED_REG(31:0)
        SIGNAL SW2(3:0)
        SIGNAL TX_TEST_A(15:0)
        SIGNAL TX_TEST_B(15:0)
        SIGNAL NPB_TEST(15:0)
        SIGNAL PPB_TEST(15:0)
        SIGNAL SPB_TEST(15:0)
        SIGNAL PRIO
        SIGNAL SPONT
        SIGNAL TX_TEST_C(15:0)
        SIGNAL RESET_CNFG(9:8)
        PORT Input RXUSRCLK2
        PORT Output RECEIVE(15:0)
        PORT Input RXDATA(15:0)
        PORT Input RXRESET
        PORT Output RX_ERR
        PORT BiDirectional MACBUS(15:0)
        PORT Input WADDR_TYPE(4:0)
        PORT Input MWE
        PORT Input RXCHARISK(1:0)
        PORT BiDirectional FRAME_REQ
        PORT Output RCTRL(2:0)
        PORT Input RXRUNDISP(1:0)
        PORT Input RXNOTINTABLE(1:0)
        PORT Input RXLOSSOFSYNC(1:0)
        PORT Input RXDISPERR(1:0)
        PORT Input RXCLKCORCNT(2:0)
        PORT Input RXCHARISCOMMA(1:0)
        PORT Input RXBUFSTATUS(1:0)
        PORT Input RXCOMMADET
        PORT Input RXREALIGN
        PORT Input RXCHECKINGCRC
        PORT Input RXCRCERR
        PORT Output DRPD_CNT(31:0)
        PORT Output RCVD_CNT(31:0)
        PORT Input TXKERR(1:0)
        PORT Input TXBUFERR
        PORT Input TXRUNDISP(1:0)
        PORT Output TXSTATUS(15:0)
        PORT Output XMIT_CNT(31:0)
        PORT Output XERR_CNT(31:0)
        PORT Input TXUSRCLK2
        PORT Input TXRESET
        PORT Input ETHER_CNFG(15:0)
        PORT Output TX_INPRGS
        PORT Output TX_UPDT
        PORT Output TX_ERR
        PORT Output FORCE_RELOAD
        PORT Output RXSTATUS(15:0)
        PORT Output GOOD_FRAME
        PORT Output ACTIVE
        PORT Output TXDATA(15:0)
        PORT Output TXCHARISK(1:0)
        PORT BiDirectional TXCAT(1:0)
        PORT BiDirectional TRANSMIT(15:0)
        PORT BiDirectional TXINSTR(2:0)
        PORT Output MOD_ENA(5:0)
        PORT BiDirectional MAC_REQ
        PORT Input CP_RST
        PORT Output ETH_RCV_BR
        PORT Input ETH_RCV_BG
        PORT Input PREP4SHTDWN
        PORT Output RDY4SHTDWN
        PORT Output USR_LED_REG(31:0)
        PORT Input SW2(3:0)
        PORT Output TX_TEST_A(15:0)
        PORT Output TX_TEST_B(15:0)
        PORT Output TX_TEST_C(15:0)
        PORT Input RESET_CNFG(9:8)
        BEGIN BLOCKDEF osu_title
            TIMESTAMP 2006 3 8 17 49 56
            BEGIN LINE W -1056 -336 0 -336 
                LINECOLOR 0 0 0
            END LINE
            BEGIN LINE W 0 0 0 -336 
                LINECOLOR 0 0 0
            END LINE
            BEGIN LINE W -1056 0 0 0 
                LINECOLOR 0 0 0
            END LINE
            BEGIN LINE W -1056 0 -1056 -336 
                LINECOLOR 0 0 0
            END LINE
            BEGIN LINE W -720 0 -720 -336 
                LINECOLOR 0 0 0
            END LINE
            BEGIN LINE N 0 -96 -720 -96 
                LINECOLOR 0 0 0
            END LINE
            BEGIN LINE N 0 -144 -720 -144 
                LINECOLOR 0 0 0
            END LINE
            BEGIN LINE N -4 -192 -724 -192 
                LINECOLOR 0 0 0
            END LINE
            BEGIN LINE N -4 -240 -724 -240 
                LINECOLOR 0 0 0
            END LINE
            BEGIN LINE N 0 -48 -720 -48 
                LINECOLOR 0 0 0
            END LINE
            BEGIN RECTANGLE N -1024 -304 -752 -32 
                LINECOLOR 0 0 0
            END RECTANGLE
            BEGIN CIRCLE N -932 -284 -924 -276 
                LINECOLOR 255 0 0
                FILLCOLOR 255 0 0
                FILLSTYLE Solid
            END CIRCLE
            BEGIN CIRCLE N -844 -284 -836 -276 
                LINECOLOR 255 0 0
                FILLCOLOR 255 0 0
                FILLSTYLE Solid
            END CIRCLE
            BEGIN CIRCLE W -1020 -252 -944 -176 
                LINECOLOR 255 0 0
            END CIRCLE
            BEGIN CIRCLE W -844 -252 -768 -176 
                LINECOLOR 255 0 0
            END CIRCLE
            BEGIN LINE W -864 -180 -864 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -884 -180 -884 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -932 -216 -884 -216 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -932 -180 -932 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -928 -84 -892 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -892 -164 -860 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -912 -116 -872 -116 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -840 -164 -840 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -868 -164 -772 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -816 -164 -816 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -816 -84 -772 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -816 -124 -784 -124 
                LINECOLOR 255 0 0
            END LINE
            BEGIN ARC W -1024 -124 -980 -80 -1020 -88 -1000 -124 
                LINECOLOR 255 0 0
            END ARC
            BEGIN ARC W -1020 -164 -980 -124 -996 -164 -996 -124 
                LINECOLOR 255 0 0
            END ARC
            BEGIN LINE W -996 -164 -916 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -952 -164 -952 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN CIRCLE W -840 -252 -764 -176 
                LINECOLOR 255 0 0
            END CIRCLE
            BEGIN LINE W -860 -180 -860 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -880 -180 -880 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -928 -216 -880 -216 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -928 -180 -928 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -924 -84 -888 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -888 -164 -856 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -908 -116 -868 -116 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -836 -164 -836 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -864 -164 -768 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -812 -164 -812 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -812 -84 -768 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -812 -124 -780 -124 
                LINECOLOR 255 0 0
            END LINE
            BEGIN ARC W -1020 -124 -976 -80 -1016 -88 -996 -124 
                LINECOLOR 255 0 0
            END ARC
            BEGIN ARC W -1016 -164 -976 -124 -992 -164 -992 -124 
                LINECOLOR 255 0 0
            END ARC
            BEGIN LINE W -992 -164 -912 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -948 -164 -948 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN CIRCLE W -1016 -252 -940 -176 
                LINECOLOR 255 0 0
            END CIRCLE
            BEGIN CIRCLE W -836 -252 -760 -176 
                LINECOLOR 255 0 0
            END CIRCLE
            BEGIN LINE W -856 -180 -856 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -876 -180 -876 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -924 -216 -876 -216 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -924 -180 -924 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -920 -84 -884 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -884 -164 -852 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -904 -116 -864 -116 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -832 -164 -832 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -860 -164 -764 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -808 -164 -808 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -808 -84 -764 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -808 -124 -776 -124 
                LINECOLOR 255 0 0
            END LINE
            BEGIN ARC W -1016 -124 -972 -80 -1012 -88 -992 -124 
                LINECOLOR 255 0 0
            END ARC
            BEGIN ARC W -1012 -164 -972 -124 -988 -164 -988 -124 
                LINECOLOR 255 0 0
            END ARC
            BEGIN LINE W -988 -164 -908 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -944 -164 -944 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN CIRCLE W -1012 -252 -936 -176 
                LINECOLOR 255 0 0
            END CIRCLE
            BEGIN CIRCLE W -1008 -252 -932 -176 
                LINECOLOR 255 0 0
            END CIRCLE
            BEGIN CIRCLE W -832 -252 -756 -176 
                LINECOLOR 255 0 0
            END CIRCLE
            BEGIN LINE W -852 -180 -852 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -872 -180 -872 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -920 -216 -872 -216 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -920 -180 -920 -252 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -916 -84 -880 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -880 -164 -848 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -900 -116 -860 -116 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -828 -164 -828 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -856 -164 -760 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -804 -164 -804 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -804 -84 -760 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -804 -124 -772 -124 
                LINECOLOR 255 0 0
            END LINE
            BEGIN ARC W -1012 -124 -968 -80 -1008 -88 -988 -124 
                LINECOLOR 255 0 0
            END ARC
            BEGIN ARC W -1008 -164 -968 -124 -984 -164 -984 -124 
                LINECOLOR 255 0 0
            END ARC
            BEGIN LINE W -984 -164 -904 -164 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE W -940 -164 -940 -84 
                LINECOLOR 255 0 0
            END LINE
            BEGIN LINE N -288 -48 -288 0 
                LINECOLOR 0 0 0
            END LINE
            BEGIN LINE N -288 -96 -288 -144 
                LINECOLOR 0 0 0
            END LINE
        END BLOCKDEF
        BEGIN BLOCKDEF rx_mac_processor
            TIMESTAMP 2007 2 2 16 51 30
            RECTANGLE N 32 -800 512 -32 
            LINE N 0 -64 32 -64 
            LINE N 0 -96 32 -96 
            LINE N 512 -480 544 -480 
            LINE N 0 -448 32 -448 
            LINE N 0 -384 32 -384 
            LINE N 0 -352 32 -352 
            LINE N 0 -320 32 -320 
            LINE N 0 -288 32 -288 
            LINE N 0 -256 32 -256 
            LINE N 0 -224 32 -224 
            BEGIN LINE W 0 -416 32 -416 
            END LINE
            LINE N 0 -128 32 -128 
            LINE N 0 -160 32 -160 
            BEGIN LINE W 256 0 256 -32 
            END LINE
            LINE N 0 -192 32 -192 
            LINE N 0 -544 32 -544 
            LINE N 0 -512 32 -512 
            LINE N 0 -480 32 -480 
            BEGIN LINE W 320 0 320 -32 
            END LINE
            BEGIN LINE W 0 -736 32 -736 
            END LINE
            BEGIN LINE W 0 -704 32 -704 
            END LINE
            BEGIN LINE W 512 -736 544 -736 
            END LINE
            LINE N 512 -704 544 -704 
            LINE N 0 -576 32 -576 
            LINE N 0 -608 32 -608 
            LINE N 384 0 384 -32 
        END BLOCKDEF
        BEGIN BLOCKDEF rxstat_err_mon
            TIMESTAMP 2007 2 6 22 35 1
            RECTANGLE N 32 -1056 576 -32 
            LINE N 0 -800 32 -800 
            LINE N 0 -768 32 -768 
            LINE N 0 -736 32 -736 
            LINE N 0 -704 32 -704 
            BEGIN LINE W 32 -672 0 -672 
            END LINE
            BEGIN LINE W 32 -640 0 -640 
            END LINE
            BEGIN LINE W 32 -608 0 -608 
            END LINE
            BEGIN LINE W 32 -576 0 -576 
            END LINE
            BEGIN LINE W 32 -544 0 -544 
            END LINE
            BEGIN LINE W 32 -512 0 -512 
            END LINE
            BEGIN LINE W 32 -480 0 -480 
            END LINE
            LINE N 0 -96 32 -96 
            LINE N 0 -128 32 -128 
            LINE N 0 -256 32 -256 
            LINE N 0 -224 32 -224 
            BEGIN LINE W 224 0 224 -32 
            END LINE
            BEGIN LINE W 256 0 256 -32 
            END LINE
            LINE N 576 -736 608 -736 
            BEGIN LINE W 608 -768 576 -768 
            END LINE
            LINE N 576 -480 608 -480 
            LINE N 576 -704 608 -704 
            LINE N 576 -672 608 -672 
            LINE N 576 -640 608 -640 
            LINE N 576 -608 608 -608 
            LINE N 576 -576 608 -576 
            LINE N 576 -544 608 -544 
            LINE N 576 -800 608 -800 
            LINE N 576 -832 608 -832 
            LINE N 576 -864 608 -864 
            LINE N 576 -896 608 -896 
            BEGIN LINE W 608 -1024 576 -1024 
            END LINE
            LINE N 576 -928 608 -928 
            LINE N 576 -960 608 -960 
            LINE N 192 -32 192 0 
            LINE N 0 -352 32 -352 
            LINE N 0 -320 32 -320 
            LINE N 0 -288 32 -288 
            LINE N 576 -288 608 -288 
            LINE N 576 -256 608 -256 
            BEGIN LINE W 608 -64 576 -64 
            END LINE
        END BLOCKDEF
        BEGIN BLOCKDEF tx_mac_frame
            TIMESTAMP 2007 8 24 21 37 53
            RECTANGLE N 32 -1856 752 -32 
            BEGIN LINE W 752 -352 784 -352 
            END LINE
            LINE N 752 -128 784 -128 
            LINE N 0 -64 32 -64 
            LINE N 0 -96 32 -96 
            LINE N 0 -128 32 -128 
            BEGIN LINE W 64 -1856 64 -1888 
            END LINE
            BEGIN LINE W 128 -1856 128 -1888 
            END LINE
            BEGIN LINE W 0 -864 32 -864 
            END LINE
            BEGIN LINE W 0 -832 32 -832 
            END LINE
            LINE N 0 -800 32 -800 
            LINE N 0 -768 32 -768 
            LINE N 0 -224 32 -224 
            LINE N 0 -256 32 -256 
            LINE N 0 -320 32 -320 
            LINE N 0 -288 32 -288 
            LINE N 0 -192 32 -192 
            LINE N 0 -160 32 -160 
            LINE N 752 -64 784 -64 
            BEGIN LINE W 752 -320 784 -320 
            END LINE
            BEGIN LINE W 752 -288 784 -288 
            END LINE
            LINE N 752 -160 784 -160 
            LINE N 752 -192 784 -192 
            BEGIN LINE W 752 -224 784 -224 
            END LINE
            BEGIN LINE W 752 -256 784 -256 
            END LINE
            LINE N 752 -96 784 -96 
            BEGIN LINE W 752 -1056 784 -1056 
            END LINE
            LINE N 752 -832 784 -832 
            LINE N 752 -768 784 -768 
            LINE N 752 -800 784 -800 
            LINE N 752 -896 784 -896 
            LINE N 752 -864 784 -864 
            BEGIN LINE W 752 -928 784 -928 
            END LINE
            BEGIN LINE W 752 -1024 784 -1024 
            END LINE
            BEGIN LINE W 752 -992 784 -992 
            END LINE
            BEGIN LINE W 752 -960 784 -960 
            END LINE
            LINE N 752 -1504 784 -1504 
            BEGIN LINE W 752 -1632 784 -1632 
            END LINE
            BEGIN LINE W 752 -1664 784 -1664 
            END LINE
            BEGIN LINE W 752 -1696 784 -1696 
            END LINE
            BEGIN LINE W 752 -1728 784 -1728 
            END LINE
            BEGIN LINE W 752 -1760 784 -1760 
            END LINE
            LINE N 752 -1600 784 -1600 
            LINE N 752 -1568 784 -1568 
            LINE N 752 -1536 784 -1536 
            LINE N 752 -1472 784 -1472 
            BEGIN LINE W 752 -384 784 -384 
            END LINE
            BEGIN LINE W 752 -1088 784 -1088 
            END LINE
            BEGIN LINE W 752 -1792 784 -1792 
            END LINE
            LINE N 752 -1312 784 -1312 
            LINE N 752 -608 784 -608 
            LINE N 416 0 416 -32 
            BEGIN LINE W 320 0 320 -32 
            END LINE
            BEGIN LINE W 352 0 352 -32 
            END LINE
            BEGIN LINE W 0 -576 32 -576 
            END LINE
            LINE N 224 0 224 -32 
            LINE N 256 0 256 -32 
        END BLOCKDEF
        BEGIN BLOCKDEF txstat_err_mon
            TIMESTAMP 2006 5 2 20 43 43
            RECTANGLE N 32 -768 560 -32 
            LINE N 0 -64 32 -64 
            BEGIN LINE W 32 -352 0 -352 
            END LINE
            BEGIN LINE W 32 -384 0 -384 
            END LINE
            LINE N 32 -416 0 -416 
            BEGIN LINE W 592 -64 560 -64 
            END LINE
            LINE N 592 -544 560 -544 
            LINE N 0 -96 32 -96 
            BEGIN LINE W 592 -96 560 -96 
            END LINE
            BEGIN LINE W 592 -128 560 -128 
            END LINE
            LINE N 592 -416 560 -416 
            LINE N 592 -384 560 -384 
            LINE N 592 -352 560 -352 
            LINE N 592 -320 560 -320 
            LINE N 592 -288 560 -288 
            LINE N 592 -256 560 -256 
            LINE N 592 -160 560 -160 
            LINE N 592 -192 560 -192 
            LINE N 592 -224 560 -224 
            LINE N 592 -448 560 -448 
            LINE N 592 -576 560 -576 
            LINE N 592 -608 560 -608 
            LINE N 592 -672 560 -672 
            LINE N 592 -640 560 -640 
            LINE N 592 -736 560 -736 
            LINE N 592 -704 560 -704 
        END BLOCKDEF
        BEGIN BLOCKDEF pkt_rcv_fifo
            TIMESTAMP 2007 5 22 16 19 21
            RECTANGLE N 32 -624 528 -32 
            LINE N 0 -288 32 -288 
            LINE N 0 -160 32 -160 
            LINE N 0 -128 32 -128 
            LINE N 0 -96 32 -96 
            LINE N 0 -64 32 -64 
            LINE N 528 -224 560 -224 
            BEGIN LINE W 0 -544 32 -544 
            END LINE
            LINE N 0 -512 32 -512 
            BEGIN LINE W 528 -544 560 -544 
            END LINE
            BEGIN LINE W 528 -512 560 -512 
            END LINE
            LINE N 528 -352 560 -352 
            LINE N 528 -192 560 -192 
            LINE N 528 -160 560 -160 
            LINE N 528 -128 560 -128 
            BEGIN LINE W 528 -256 560 -256 
            END LINE
            LINE N 528 -320 560 -320 
            LINE N 528 -384 560 -384 
        END BLOCKDEF
        BEGIN BLOCKDEF pkt_bldr
            TIMESTAMP 2007 8 24 21 20 44
            LINE N 0 -64 32 -64 
            LINE N 192 0 192 -32 
            LINE N 224 0 224 -32 
            LINE N 256 0 256 -32 
            LINE N 0 -96 32 -96 
            LINE N 0 -128 32 -128 
            BEGIN LINE W 0 -448 32 -448 
            END LINE
            BEGIN LINE W 0 -416 32 -416 
            END LINE
            BEGIN LINE W 0 -384 32 -384 
            END LINE
            BEGIN LINE W 0 -352 32 -352 
            END LINE
            BEGIN LINE W 0 -320 32 -320 
            END LINE
            LINE N 0 -256 32 -256 
            LINE N 0 -288 32 -288 
            LINE N 0 -224 32 -224 
            LINE N 0 -160 32 -160 
            RECTANGLE N 32 -528 400 -32 
            LINE N 0 -192 32 -192 
            LINE N 432 -288 400 -288 
            BEGIN LINE W 432 -160 400 -160 
            END LINE
            BEGIN LINE W 432 -128 400 -128 
            END LINE
            BEGIN LINE W 432 -192 400 -192 
            END LINE
            BEGIN LINE W 432 -224 400 -224 
            END LINE
            BEGIN LINE W 0 -480 32 -480 
            END LINE
            LINE N 160 0 160 -32 
            BEGIN LINE W 0 -512 32 -512 
            END LINE
            BEGIN LINE W 432 -256 400 -256 
            END LINE
        END BLOCKDEF
        BEGIN BLOCKDEF mac_mem
            TIMESTAMP 2007 2 5 18 54 50
            RECTANGLE N 32 -400 544 -32 
            LINE N 0 -96 32 -96 
            LINE N 0 -160 32 -160 
            BEGIN LINE W 0 -224 32 -224 
            END LINE
            BEGIN LINE W 0 -192 32 -192 
            END LINE
            BEGIN LINE W 320 0 320 -32 
            END LINE
            BEGIN LINE W 256 0 256 -32 
            END LINE
            BEGIN LINE W 288 -432 288 -400 
            END LINE
            BEGIN LINE W 224 -432 224 -400 
            END LINE
            BEGIN LINE W 448 0 448 -32 
            END LINE
            BEGIN LINE W 384 0 384 -32 
            END LINE
        END BLOCKDEF
        BEGIN BLOCKDEF ether_ctrl
            TIMESTAMP 2006 2 21 20 17 14
            RECTANGLE N 32 -448 464 -32 
            BEGIN LINE W 0 -256 32 -256 
            END LINE
            LINE N 464 -352 496 -352 
            LINE N 464 -320 496 -320 
            LINE N 464 -288 496 -288 
            LINE N 464 -256 496 -256 
            LINE N 464 -224 496 -224 
            LINE N 464 -192 496 -192 
            LINE N 464 -160 496 -160 
        END BLOCKDEF
        BEGIN BLOCKDEF tx_decoder
            TIMESTAMP 2007 8 29 19 28 40
            RECTANGLE N 32 -208 384 -32 
            BEGIN LINE W 416 -128 384 -128 
            END LINE
            LINE N 32 -176 0 -176 
            LINE N 32 -144 0 -144 
            LINE N 32 -112 0 -112 
            LINE N 32 -64 0 -64 
            LINE N 128 0 128 -32 
            LINE N 224 0 224 -32 
            LINE N 320 0 320 -32 
            BEGIN LINE W 160 0 160 -32 
            END LINE
        END BLOCKDEF
        BEGIN BLOCKDEF rx_frame_intf
            TIMESTAMP 2007 9 4 16 30 14
            RECTANGLE N 32 -624 432 256 
            LINE N 0 -64 32 -64 
            LINE N 0 -96 32 -96 
            LINE N 432 -192 464 -192 
            LINE N 0 -224 32 -224 
            BEGIN LINE W 0 -512 32 -512 
            END LINE
            BEGIN LINE W 0 -544 32 -544 
            END LINE
            BEGIN LINE W 432 -544 464 -544 
            END LINE
            BEGIN LINE W 432 -512 464 -512 
            END LINE
            LINE N 0 -128 32 -128 
            BEGIN LINE W 432 -288 464 -288 
            END LINE
            LINE N 432 -128 464 -128 
            LINE N 432 -160 464 -160 
            LINE N 0 -352 32 -352 
            LINE N 0 -320 32 -320 
            LINE N 0 -192 32 -192 
            BEGIN LINE W 0 -256 32 -256 
            END LINE
            LINE N 0 -384 32 -384 
        END BLOCKDEF
        BEGIN BLOCKDEF eth_cp
            TIMESTAMP 2008 1 4 18 58 42
            LINE N 0 -192 32 -192 
            RECTANGLE N 32 -656 464 -32 
            LINE N 192 -688 192 -656 
            BEGIN LINE W 256 -688 256 -656 
            END LINE
            BEGIN LINE W 320 -688 320 -656 
            END LINE
            BEGIN LINE W 320 -32 320 0 
            END LINE
            BEGIN LINE W 256 -32 256 0 
            END LINE
            BEGIN LINE W 192 -32 192 0 
            END LINE
            LINE N 0 -64 32 -64 
            LINE N 0 -96 32 -96 
            LINE N 0 -128 32 -128 
            LINE N 0 -512 32 -512 
            LINE N 0 -544 32 -544 
            LINE N 0 -576 32 -576 
            LINE N 464 -384 496 -384 
            LINE N 464 -352 496 -352 
            LINE N 464 -320 496 -320 
            LINE N 464 -416 496 -416 
            LINE N 0 -256 32 -256 
            LINE N 464 -256 496 -256 
            BEGIN LINE W 464 -224 496 -224 
            END LINE
            BEGIN LINE W 0 -320 32 -320 
            END LINE
        END BLOCKDEF
        BEGIN BLOCKDEF eth_tsm
            TIMESTAMP 2007 8 24 21 36 57
            LINE N 32 -32 352 -192 
            LINE N 32 -32 32 -800 
            LINE N 352 -192 352 -640 
            BEGIN LINE W 0 -576 32 -576 
            END LINE
            BEGIN LINE W 352 -416 384 -416 
            END LINE
            LINE N 32 -800 352 -640 
            BEGIN LINE W 0 -256 32 -256 
            END LINE
            BEGIN LINE W 0 -416 32 -416 
            END LINE
            LINE N 176 -104 176 0 
            LINE N 240 0 240 -136 
        END BLOCKDEF
        BEGIN BLOCK XLXI_2 osu_title
            ATTR TitleFieldText "Ethernet"
            ATTR RevFieldText "4.29"
            ATTR ProjectFieldText "D783C"
            ATTR NameFieldText "Gigabit Ethernet VME Controller"
            ATTR DateFieldText "15-JUN-04"
            ATTR SubtitleFieldText "Logic Analyzer"
        END BLOCK
        BEGIN BLOCK XLXI_6 osu_title
            ATTR TitleFieldText "Ethernet"
            ATTR RevFieldText "4.29"
            ATTR ProjectFieldText "D783C"
            ATTR NameFieldText "Gigabit Ethernet VME Controller"
            ATTR DateFieldText "12-MAY-04"
            ATTR SubtitleFieldText "Transmit Packet Building"
        END BLOCK
        BEGIN BLOCK XLXI_1 osu_title
            ATTR TitleFieldText "Ethernet"
            ATTR RevFieldText "4.29"
            ATTR ProjectFieldText "D783C"
            ATTR NameFieldText "Gigabit Ethernet VME Controller"
            ATTR DateFieldText "12-MAY-04"
            ATTR SubtitleFieldText "Receiv Packet Processing"
        END BLOCK
        BEGIN BLOCK RXMAC1 rx_mac_processor
            PIN CLK RXUSRCLK2
            PIN RXRESET RXRESET
            PIN SOP SOP
            PIN STATE_ERR(3:0) STATE_ERR(3:0)
            PIN UPD_FRAM_STATS UPD_FRAME_STATS
            PIN STORE_MAC FF_MAC_PUSH
            PIN BCAST_MTCH XLXN_1692
            PIN MCAST_MTCH XLXN_1693
            PIN LEN_OK LEN_OK
            PIN OVR_MAX XLXN_1695
            PIN LOCAL_MTCH XLXN_1691
            PIN RX_ERR RX_ERR
            PIN PROMISC PROMISC
            PIN RCV_ADDR(1:0) RCV_ADDR(1:0)
            PIN WRNG_SOP XLXN_1845
            PIN EOP EOP
            PIN CAR_XTEND CAR_XTEND
            PIN ERR_PROP ERR_PROP
            PIN ALL_MACS(63:0) ALL_MACS(63:0)
            PIN RXDATA(15:0) RXDATA(15:0)
            PIN RXCHARISK(1:0) RXCHARISK(1:0)
            PIN DATA(15:0) PKT_DATA(15:0)
            PIN RXVALDAT RXVALDAT
            PIN FRC_RLD_CMD FRC_RLD_CMD
            PIN RST_CMDS RST_CMDS
            PIN ACTIVE ACTIVE
        END BLOCK
        BEGIN BLOCK MCM1 mac_mem
            PIN CLK RXUSRCLK2
            PIN MWE MWE
            PIN MACBUS(15:0) MACBUS(15:0)
            PIN WA_TP(4:0) WADDR_TYPE(4:0)
            PIN TX_MAC(15:0) TX_MAC(15:0)
            PIN TX_ADDR(1:0) TX_ADDR(1:0)
            PIN ALL_MACS(63:0) ALL_MACS(63:0)
            PIN RCV_ADDR(1:0) RCV_ADDR(1:0)
            PIN DFLT_MAC(15:0) DFLT_MAC(15:0)
            PIN DFLT_ADDR(1:0) DFLT_ADDR(1:0)
        END BLOCK
        BEGIN BLOCK FF1 pkt_rcv_fifo
            PIN GOOD_FRAME GOOD_FRAME
            PIN FRAME_STAT_VALID FRAME_STAT_VALID
            PIN CLK RXUSRCLK2
            PIN MAC_PUSH FF_MAC_PUSH
            PIN RXRESET RXRESET
            PIN FRAME_READY FF_RDY
            PIN FF_IN(15:0) PKT_DATA(15:0)
            PIN RXVALDAT RXVALDAT
            PIN FF_OUT(15:0) PKT_FF_DATA(15:0)
            PIN FRAME_LEN(12:0) FRAME_LENGTH(12:0)
            PIN READ FF_READ
            PIN MT FF_MT
            PIN FULL FF_FULL
            PIN AF FF_AF
            PIN MAC_OUT(15:0) MAC_SRC(15:0)
            PIN MAC_POP FF_MAC_POP
            PIN RXF_BUSY RXF_BUSY
        END BLOCK
        BEGIN BLOCK RXMON1 rxstat_err_mon
            PIN RXCRCERR RXCRCERR
            PIN RXCHECKINGCRC RXCHECKINGCRC
            PIN RXREALIGN RXREALIGN
            PIN RXCOMMADET RXCOMMADET
            PIN RXBUFSTATUS(1:0) RXBUFSTATUS(1:0)
            PIN RXCHARISCOMMA(1:0) RXCHARISCOMMA(1:0)
            PIN RXCLKCORCNT(2:0) RXCLKCORCNT(2:0)
            PIN RXDISPERR(1:0) RXDISPERR(1:0)
            PIN RXLOSSOFSYNC(1:0) RXLOSSOFSYNC(1:0)
            PIN RXNOTINTABLE(1:0) RXNOTINTABLE(1:0)
            PIN RXRUNDISP(1:0) RXRUNDISP(1:0)
            PIN CLK RXUSRCLK2
            PIN RXRESET RXRESET
            PIN PROMISC PROMISC
            PIN PASS_THRU PASS_THRU
            PIN RCVD_CNT(31:0) RCVD_CNT(31:0)
            PIN DRPD_CNT(31:0) DRPD_CNT(31:0)
            PIN UPD_FRAM_STATS UPD_FRAME_STATS
            PIN STATE_ERR(3:0) STATE_ERR(3:0)
            PIN SOP SOP
            PIN RX_ERR RX_ERR
            PIN OVR_MAX XLXN_1695
            PIN LEN_OK LEN_OK
            PIN MCAST_MTCH XLXN_1693
            PIN BCAST_MTCH XLXN_1692
            PIN LOCAL_MTCH XLXN_1691
            PIN WRNG_SOP XLXN_1845
            PIN ERR_PROP ERR_PROP
            PIN CAR_XTEND CAR_XTEND
            PIN EOP EOP
            PIN RXCHARISK(1:0) RXCHARISK(1:0)
            PIN FRC_RLD_CMD FRC_RLD_CMD
            PIN RST_CMDS RST_CMDS
            PIN FORCE_RELOAD FORCE_RELOAD
            PIN FF_AF FF_AF
            PIN FF_FULL FF_FULL
            PIN FF_MT FF_MT
            PIN FRAME_STAT_VALID FRAME_STAT_VALID
            PIN GOOD_FRAME GOOD_FRAME
            PIN RXSTATUS(15:0) RXSTATUS(15:0)
        END BLOCK
        BEGIN BLOCK TXMON txstat_err_mon
            PIN CLK TXUSRCLK2
            PIN TXRUNDISP(1:0) TXRUNDISP(1:0)
            PIN TXKERR(1:0) TXKERR(1:0)
            PIN TXBUFFERR TXBUFERR
            PIN TXSTATUS(15:0) TXSTATUS(15:0)
            PIN TX_PROC_S TX_PROC_S
            PIN TXRESET TXRESET
            PIN XMIT_CNT(31:0) XMIT_CNT(31:0)
            PIN XERR_CNT(31:0) XERR_CNT(31:0)
            PIN NORM_PB_MT NORM_PB_MT
            PIN NORM_PB_AF NORM_PB_AF
            PIN NORM_PB_FULL NORM_PB_FULL
            PIN PRIO_PB_FULL PRIO_PB_FULL
            PIN PRIO_PB_MT PRIO_PB_MT
            PIN PRIO_PB_AF PRIO_PB_AF
            PIN SPONT_PB_MT SPONT_PB_MT
            PIN SPONT_PB_AF SPONT_PB_AF
            PIN SPONT_PB_FULL SPONT_PB_FULL
            PIN TX_INPRGS TX_INPRGS
            PIN TX_PROC_N TX_PROC_N
            PIN TX_PROC_P TX_PROC_P
            PIN TX_ERR_RST TX_ERR_RST
            PIN UPD_STATS TX_UPDT
            PIN TX_ERR TX_ERR
            PIN TX_MAC_DEST_ERR TX_MAC_DEST_ERR
        END BLOCK
        BEGIN BLOCK eth_c1 ether_ctrl
            PIN ETHER_CNFG(15:0) ETHER_CNFG(15:0)
            PIN PASS_THRU PASS_THRU
            PIN PROMISC PROMISC
            PIN PROT_ENA PROT_ENA
            PIN XTEND XTEND
            PIN SPONT_PKT_ENA SPONT_PKT_ENA
            PIN PRIO_PKT_ENA PRIO_PKT_ENA
            PIN NORM_PKT_ENA NORM_PKT_ENA
        END BLOCK
        BEGIN BLOCK TXMAC tx_mac_frame
            PIN CLK TXUSRCLK2
            PIN TXRESET TXRESET
            PIN TX_PROC_S TX_PROC_S
            PIN TX_ADDR(1:0) TX_ADDR(1:0)
            PIN TX_MAC(15:0) TX_MAC(15:0)
            PIN SPONT_DATAIN(15:0) SPONT_DATA(15:0)
            PIN SPONT_RDY SPONT_RDY
            PIN TXDATA(15:0) TXDATA(15:0)
            PIN TXCHARISK(1:0) TXCHARISK(1:0)
            PIN XTEND XTEND
            PIN PROT_ENA PROT_ENA
            PIN UPD_STATS TX_UPDT
            PIN TX_ERR_RST TX_ERR_RST
            PIN TX_ERR TX_ERR
            PIN TX_MAC_DEST_ERR TX_MAC_DEST_ERR
            PIN TX_PROC_P TX_PROC_P
            PIN TX_PROC_N TX_PROC_N
            PIN SPONT_POP SPONT_POP
            PIN SPONT_LEN(12:0) SPONT_LEN(12:0)
            PIN SPONT_TYPE_STAT(11:0) SPONT_TYPE_STAT(11:0)
            PIN SPONT_NEW SPONT_NEW
            PIN SPONT_FRAG SPONT_FRAG
            PIN SPONT_FRAG_NUM(31:0) SPONT_FRAG_NUM(31:0)
            PIN SPONT_MAC_HDR(15:0) SPONT_MAC_HDR(15:0)
            PIN SPONT_POPMH SPONT_POPMH
            PIN PRIO_DATAIN(15:0) PRIO_DATA(15:0)
            PIN PRIO_RDY PRIO_RDY
            PIN PRIO_POP PRIO_POP
            PIN PRIO_POPMH PRIO_POPMH
            PIN PRIO_FRAG PRIO_FRAG
            PIN PRIO_NEW PRIO_NEW
            PIN PRIO_FRAG_NUM(31:0) PRIO_FRAG_NUM(31:0)
            PIN PRIO_LEN(12:0) PRIO_LEN(12:0)
            PIN PRIO_TYPE_STAT(11:0) PRIO_TYPE_STAT(11:0)
            PIN PRIO_MAC_HDR(15:0) PRIO_MAC_HDR(15:0)
            PIN NORM_DATAIN(15:0) NORM_DATA(15:0)
            PIN NORM_RDY NORM_RDY
            PIN NORM_POP NORM_POP
            PIN NORM_POPMH NORM_POPMH
            PIN NORM_NEW NORM_NEW
            PIN NORM_FRAG NORM_FRAG
            PIN NORM_FRAG_NUM(31:0) NORM_FRAG_NUM(31:0)
            PIN NORM_LEN(12:0) NORM_LEN(12:0)
            PIN NORM_TYPE_STAT(11:0) NORM_TYPE_STAT(11:0)
            PIN NORM_MAC_HDR(15:0) NORM_MAC_HDR(15:0)
            PIN NORM_MHBITS(1:0) NORM_MHBITS(1:0)
            PIN PRIO_MHBITS(1:0) PRIO_MHBITS(1:0)
            PIN SPONT_MHBITS(1:0) SPONT_MHBITS(1:0)
            PIN NORM_MH_MT NORM_MH_MT
            PIN PRIO_MH_MT PRIO_MH_MT
            PIN SPONT_MH_MT SPONT_MH_MT
            PIN TEST_A(15:0) TX_TEST_A(15:0)
            PIN TEST_B(15:0) TX_TEST_B(15:0)
            PIN SW2(3:0) SW2(3:0)
            PIN SPONT SPONT
            PIN PRIO PRIO
        END BLOCK
        BEGIN BLOCK SPONT_PB pkt_bldr
            PIN CLK TXUSRCLK2
            PIN MT SPONT_PB_MT
            PIN AF SPONT_PB_AF
            PIN FULL SPONT_PB_FULL
            PIN TXRESET TXRESET
            PIN PB_ENA SPONT_PKT_ENA
            PIN DATAOUT(15:0) SPONT_DATA(15:0)
            PIN DATA_LEN(12:0) SPONT_LEN(12:0)
            PIN TYPE_STAT(11:0) SPONT_TYPE_STAT(11:0)
            PIN MAC_HDR(15:0) SPONT_MAC_HDR(15:0)
            PIN NEW_PKT SPONT_NEW
            PIN FRAG SPONT_FRAG
            PIN SEND SPONT_RDY
            PIN POP SPONT_POP
            PIN FRAG_NUM(31:0) SPONT_FRAG_NUM(31:0)
            PIN POPMH SPONT_POPMH
            PIN ACTIVE SPONT_VALID
            PIN DATAIN(15:0) TRANSMIT(15:0)
            PIN TXINSTR(2:0) TXINSTR(2:0)
            PIN DFLT_ADDR(1:0) DFLT_ADDR(1:0)
            PIN DFLT_MAC(15:0) DFLT_MAC(15:0)
            PIN MHBITS(1:0) SPONT_MHBITS(1:0)
            PIN MH_MT SPONT_MH_MT
            PIN SW2(3:0) SW2(3:0)
            PIN TEST(15:0) SPB_TEST(15:0)
        END BLOCK
        BEGIN BLOCK PRIO_PB pkt_bldr
            PIN CLK TXUSRCLK2
            PIN MT PRIO_PB_MT
            PIN AF PRIO_PB_AF
            PIN FULL PRIO_PB_FULL
            PIN TXRESET TXRESET
            PIN PB_ENA PRIO_PKT_ENA
            PIN DATAOUT(15:0) PRIO_DATA(15:0)
            PIN DATA_LEN(12:0) PRIO_LEN(12:0)
            PIN TYPE_STAT(11:0) PRIO_TYPE_STAT(11:0)
            PIN MAC_HDR(15:0) PRIO_MAC_HDR(15:0)
            PIN NEW_PKT PRIO_NEW
            PIN FRAG PRIO_FRAG
            PIN SEND PRIO_RDY
            PIN POP PRIO_POP
            PIN FRAG_NUM(31:0) PRIO_FRAG_NUM(31:0)
            PIN POPMH PRIO_POPMH
            PIN ACTIVE PRIO_VALID
            PIN DATAIN(15:0) TRANSMIT(15:0)
            PIN TXINSTR(2:0) TXINSTR(2:0)
            PIN DFLT_ADDR(1:0) DFLT_ADDR(1:0)
            PIN DFLT_MAC(15:0) DFLT_MAC(15:0)
            PIN MHBITS(1:0) PRIO_MHBITS(1:0)
            PIN MH_MT PRIO_MH_MT
            PIN SW2(3:0) SW2(3:0)
            PIN TEST(15:0) PPB_TEST(15:0)
        END BLOCK
        BEGIN BLOCK NORM_PB pkt_bldr
            PIN CLK TXUSRCLK2
            PIN MT NORM_PB_MT
            PIN AF NORM_PB_AF
            PIN FULL NORM_PB_FULL
            PIN TXRESET TXRESET
            PIN PB_ENA NORM_PKT_ENA
            PIN DATAOUT(15:0) NORM_DATA(15:0)
            PIN DATA_LEN(12:0) NORM_LEN(12:0)
            PIN TYPE_STAT(11:0) NORM_TYPE_STAT(11:0)
            PIN MAC_HDR(15:0) NORM_MAC_HDR(15:0)
            PIN NEW_PKT NORM_NEW
            PIN FRAG NORM_FRAG
            PIN SEND NORM_RDY
            PIN POP NORM_POP
            PIN FRAG_NUM(31:0) NORM_FRAG_NUM(31:0)
            PIN POPMH NORM_POPMH
            PIN ACTIVE NORM_VALID
            PIN DATAIN(15:0) TRANSMIT(15:0)
            PIN TXINSTR(2:0) TXINSTR(2:0)
            PIN DFLT_ADDR(1:0) DFLT_ADDR(1:0)
            PIN DFLT_MAC(15:0) DFLT_MAC(15:0)
            PIN MHBITS(1:0) NORM_MHBITS(1:0)
            PIN MH_MT NORM_MH_MT
            PIN SW2(3:0) SW2(3:0)
            PIN TEST(15:0) NPB_TEST(15:0)
        END BLOCK
        BEGIN BLOCK RXFI rx_frame_intf
            PIN CLK RXUSRCLK2
            PIN RXRESET RXRESET
            PIN FRAME_REQ FRAME_REQ
            PIN FF_RDY FF_RDY
            PIN FRAME_LEN(12:0) FRAME_LENGTH(12:0)
            PIN DATAIN(15:0) PKT_FF_DATA(15:0)
            PIN DATAOUT(15:0) RECEIVE(15:0)
            PIN RCTRL(2:0) RCTRL(2:0)
            PIN PASS_THRU PASS_THRU
            PIN MOD_ENA(5:0) MOD_ENA(5:0)
            PIN RST_SEQ RST_SEQ
            PIN MAC_REQ MAC_REQ
            PIN READ FF_READ
            PIN MAC_POP FF_MAC_POP
            PIN MT FF_MT
            PIN MAC(15:0) MAC_SRC(15:0)
            PIN BUSY RXF_BUSY
        END BLOCK
        BEGIN BLOCK ETH_CP1 eth_cp
            PIN PASS_THRU PASS_THRU
            PIN SEL MOD_ENA(5)
            PIN RCTRL(2:0) RCTRL(2:0)
            PIN RCVDATA(15:0) RECEIVE(15:0)
            PIN TXDATA(15:0) TRANSMIT(15:0)
            PIN TXINSTR(2:0) TXINSTR(2:0)
            PIN TXCAT(1:0) TXCAT(1:0)
            PIN CLK RXUSRCLK2
            PIN RST RXRESET
            PIN CP_RST CP_RST
            PIN PRIO_AF PRIO_PB_AF
            PIN NORM_AF NORM_PB_AF
            PIN BG ETH_RCV_BG
            PIN FRAME_REQ FRAME_REQ
            PIN BR ETH_RCV_BR
            PIN RST_SEQ RST_SEQ
            PIN MAC_REQ MAC_REQ
            PIN RDY4SHTDWN RDY4SHTDWN
            PIN PREP4SHTDWN PREP4SHTDWN
            PIN USR_LED_REG(31:0) USR_LED_REG(31:0)
            PIN MSG_LVL(1:0) RESET_CNFG(9:8)
        END BLOCK
        BEGIN BLOCK ETSM1 eth_tsm
            PIN NPB(15:0) NPB_TEST(15:0)
            PIN TEST(15:0) TX_TEST_C(15:0)
            PIN SPB(15:0) SPB_TEST(15:0)
            PIN PPB(15:0) PPB_TEST(15:0)
            PIN SPONT SPONT
            PIN PRIO PRIO
        END BLOCK
        BEGIN BLOCK TXD1 tx_decoder
            PIN CAT(1:0) TXCAT(1:0)
            PIN NE NORM_PKT_ENA
            PIN PE PRIO_PKT_ENA
            PIN SE SPONT_PKT_ENA
            PIN CLK TXUSRCLK2
            PIN NV NORM_VALID
            PIN PV PRIO_VALID
            PIN SV SPONT_VALID
            PIN ADDR(1:0) DFLT_ADDR(1:0)
        END BLOCK
    END NETLIST
    BEGIN SHEET 1 3520 2720
        BEGIN BRANCH SOP
            WIRE 960 816 1104 816
        END BRANCH
        BEGIN BRANCH STATE_ERR(3:0)
            WIRE 960 848 1104 848
        END BRANCH
        BEGIN BRANCH UPD_FRAME_STATS
            WIRE 960 880 1104 880
        END BRANCH
        BEGIN BRANCH XLXN_1691
            WIRE 960 912 1104 912
        END BRANCH
        BEGIN BRANCH XLXN_1692
            WIRE 960 944 1104 944
        END BRANCH
        BEGIN BRANCH XLXN_1693
            WIRE 960 976 1104 976
        END BRANCH
        BEGIN BRANCH LEN_OK
            WIRE 960 1008 1104 1008
        END BRANCH
        BEGIN BRANCH XLXN_1695
            WIRE 960 1040 1104 1040
        END BRANCH
        BEGIN BRANCH FF_MAC_PUSH
            WIRE 1648 784 1840 784
        END BRANCH
        BEGIN BRANCH XLXN_1845
            WIRE 960 1072 1104 1072
        END BRANCH
        BEGIN BRANCH EOP
            WIRE 960 720 1104 720
        END BRANCH
        BEGIN BRANCH CAR_XTEND
            WIRE 960 752 1104 752
        END BRANCH
        BEGIN BRANCH ERR_PROP
            WIRE 960 784 1104 784
        END BRANCH
        BEGIN BRANCH RCV_ADDR(1:0)
            WIRE 1360 1264 1360 1888
        END BRANCH
        BEGIN BRANCH MACBUS(15:0)
            WIRE 912 2096 1136 2096
        END BRANCH
        BEGIN BRANCH WADDR_TYPE(4:0)
            WIRE 912 2128 1136 2128
        END BRANCH
        BEGIN BRANCH MWE
            WIRE 912 2160 1136 2160
        END BRANCH
        BEGIN BRANCH TX_ADDR(1:0)
            WIRE 1392 2320 1392 2416
            BEGIN DISPLAY 1392 2416 ATTR Name
                ALIGNMENT SOFT-VRIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TX_MAC(15:0)
            WIRE 1456 2320 1456 2416
            BEGIN DISPLAY 1456 2416 ATTR Name
                ALIGNMENT SOFT-VRIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ALL_MACS(63:0)
            WIRE 1424 1264 1424 1888
        END BRANCH
        BEGIN BRANCH RXDATA(15:0)
            WIRE 928 480 1072 480
            WIRE 1072 480 1072 528
            WIRE 1072 528 1104 528
        END BRANCH
        BEGIN BRANCH RXVALDAT
            WIRE 1648 560 1840 560
        END BRANCH
        BEGIN BRANCH PKT_DATA(15:0)
            WIRE 1648 528 1840 528
        END BRANCH
        BEGIN BRANCH FRAME_REQ
            WIRE 3200 880 3248 880
        END BRANCH
        BEGIN BRANCH FF_RDY
            WIRE 2400 848 2736 848
        END BRANCH
        BEGIN BRANCH FRAME_LENGTH(12:0)
            WIRE 2400 560 2736 560
        END BRANCH
        BEGIN BRANCH PKT_FF_DATA(15:0)
            WIRE 2400 528 2736 528
        END BRANCH
        BEGIN BRANCH RECEIVE(15:0)
            WIRE 3200 528 3248 528
        END BRANCH
        BEGIN BRANCH RCTRL(2:0)
            WIRE 3200 560 3248 560
        END BRANCH
        IOMARKER 3248 880 FRAME_REQ R0 28
        IOMARKER 3248 528 RECEIVE(15:0) R0 28
        IOMARKER 3248 560 RCTRL(2:0) R0 28
        BEGIN INSTANCE RXMON1 352 1616 R0
        END INSTANCE
        BEGIN BRANCH PASS_THRU
            WIRE 224 1392 352 1392
            BEGIN DISPLAY 224 1392 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PROMISC
            WIRE 160 1360 352 1360
            BEGIN DISPLAY 160 1360 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH RXRUNDISP(1:0)
            WIRE 320 1136 352 1136
        END BRANCH
        BEGIN BRANCH RXNOTINTABLE(1:0)
            WIRE 320 1104 352 1104
        END BRANCH
        BEGIN BRANCH RXLOSSOFSYNC(1:0)
            WIRE 320 1072 352 1072
        END BRANCH
        BEGIN BRANCH RXDISPERR(1:0)
            WIRE 320 1040 352 1040
        END BRANCH
        BEGIN BRANCH RXCLKCORCNT(2:0)
            WIRE 320 1008 352 1008
        END BRANCH
        BEGIN BRANCH RXCHARISCOMMA(1:0)
            WIRE 320 976 352 976
        END BRANCH
        BEGIN BRANCH RXBUFSTATUS(1:0)
            WIRE 320 944 352 944
        END BRANCH
        BEGIN BRANCH RXCOMMADET
            WIRE 320 912 352 912
        END BRANCH
        BEGIN BRANCH RXREALIGN
            WIRE 320 880 352 880
        END BRANCH
        BEGIN BRANCH RXCHECKINGCRC
            WIRE 320 848 352 848
        END BRANCH
        BEGIN BRANCH RXCRCERR
            WIRE 320 816 352 816
        END BRANCH
        IOMARKER 320 1136 RXRUNDISP(1:0) R180 28
        IOMARKER 320 1104 RXNOTINTABLE(1:0) R180 28
        IOMARKER 320 1072 RXLOSSOFSYNC(1:0) R180 28
        IOMARKER 320 1040 RXDISPERR(1:0) R180 28
        IOMARKER 320 1008 RXCLKCORCNT(2:0) R180 28
        IOMARKER 320 976 RXCHARISCOMMA(1:0) R180 28
        IOMARKER 320 944 RXBUFSTATUS(1:0) R180 28
        IOMARKER 320 912 RXCOMMADET R180 28
        IOMARKER 320 880 RXREALIGN R180 28
        IOMARKER 320 848 RXCHECKINGCRC R180 28
        IOMARKER 320 816 RXCRCERR R180 28
        IOMARKER 288 1520 RXUSRCLK2 R180 28
        IOMARKER 288 1488 RXRESET R180 28
        BEGIN BRANCH DRPD_CNT(31:0)
            WIRE 608 1616 608 1744
        END BRANCH
        BEGIN BRANCH RCVD_CNT(31:0)
            WIRE 576 1616 576 1744
        END BRANCH
        IOMARKER 608 1744 DRPD_CNT(31:0) R90 28
        IOMARKER 576 1744 RCVD_CNT(31:0) R90 28
        BEGIN BRANCH RXRESET
            WIRE 288 1488 352 1488
        END BRANCH
        BEGIN BRANCH RXUSRCLK2
            WIRE 288 1520 352 1520
        END BRANCH
        BEGIN BRANCH FRC_RLD_CMD
            WIRE 960 656 1104 656
        END BRANCH
        BEGIN BRANCH RST_CMDS
            WIRE 960 688 1104 688
        END BRANCH
        BEGIN BRANCH FORCE_RELOAD
            WIRE 544 1616 544 1744
        END BRANCH
        IOMARKER 544 1744 FORCE_RELOAD R90 28
        BEGIN INSTANCE XLXI_1 3520 2720 R0
        END INSTANCE
        IOMARKER 928 480 RXDATA(15:0) R180 28
        IOMARKER 928 512 RXCHARISK(1:0) R180 28
        BEGIN BRANCH RXCHARISK(1:0)
            WIRE 928 512 992 512
            WIRE 992 512 992 560
            WIRE 992 560 992 592
            WIRE 992 560 1104 560
            WIRE 960 592 992 592
        END BRANCH
        BEGIN INSTANCE RXMAC1 1104 1264 R0
        END INSTANCE
        BEGIN BRANCH RXSTATUS(15:0)
            WIRE 960 1552 2048 1552
        END BRANCH
        BEGIN BRANCH RXUSRCLK2
            WIRE 1072 1200 1072 2224
            WIRE 1072 2224 1136 2224
            WIRE 1072 1200 1104 1200
        END BRANCH
        IOMARKER 912 2160 MWE R180 28
        IOMARKER 912 2128 WADDR_TYPE(4:0) R180 28
        IOMARKER 912 2096 MACBUS(15:0) R180 28
        BEGIN INSTANCE MCM1 1136 2320 R0
        END INSTANCE
        IOMARKER 2048 1552 RXSTATUS(15:0) R0 28
        BEGIN INSTANCE FF1 1840 1072 R0
        END INSTANCE
        BEGIN BRANCH RX_ERR
            WIRE 960 1136 976 1136
            WIRE 976 1136 1104 1136
            WIRE 976 1136 976 1520
            WIRE 976 1520 2048 1520
        END BRANCH
        BEGIN BRANCH GOOD_FRAME
            WIRE 960 1328 1680 1328
            WIRE 1680 1328 1984 1328
            WIRE 1680 912 1840 912
            WIRE 1680 912 1680 1328
        END BRANCH
        BEGIN BRANCH FRAME_STAT_VALID
            WIRE 960 1360 1712 1360
            WIRE 1712 944 1840 944
            WIRE 1712 944 1712 1360
        END BRANCH
        BEGIN BRANCH ACTIVE
            WIRE 1488 1264 1488 1488
            WIRE 1488 1488 2048 1488
        END BRANCH
        IOMARKER 2048 1520 RX_ERR R0 28
        IOMARKER 2048 1488 ACTIVE R0 28
        BEGIN BRANCH PROMISC
            WIRE 976 1104 1024 1104
            WIRE 1024 1104 1104 1104
            BEGIN DISPLAY 1024 1104 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 20 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH FF_MT
            WIRE 320 1264 352 1264
            BEGIN DISPLAY 320 1264 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH FF_FULL
            WIRE 320 1296 352 1296
            BEGIN DISPLAY 320 1296 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH FF_AF
            WIRE 320 1328 352 1328
            BEGIN DISPLAY 320 1328 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PASS_THRU
            WIRE 2720 944 2736 944
            BEGIN DISPLAY 2720 944 ATTR Name
                ALIGNMENT SOFT-RIGHT
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH DFLT_MAC(15:0)
            WIRE 1584 2320 1584 2416
            BEGIN DISPLAY 1584 2416 ATTR Name
                ALIGNMENT SOFT-VRIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH DFLT_ADDR(1:0)
            WIRE 1520 2320 1520 2416
            BEGIN DISPLAY 1520 2416 ATTR Name
                ALIGNMENT SOFT-VRIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH RXRESET
            WIRE 2688 976 2736 976
        END BRANCH
        BEGIN BRANCH RXRESET
            WIRE 1024 1168 1104 1168
            WIRE 1024 1168 1024 1392
            WIRE 1024 1392 1744 1392
            WIRE 1744 1392 1984 1392
            WIRE 1744 976 1840 976
            WIRE 1744 976 1744 1392
        END BRANCH
        BEGIN BRANCH RXUSRCLK2
            WIRE 2688 1008 2736 1008
        END BRANCH
        BEGIN BRANCH RXUSRCLK2
            WIRE 1792 1008 1840 1008
            WIRE 1792 1008 1792 1360
            WIRE 1792 1360 1984 1360
        END BRANCH
        IOMARKER 1984 1392 RXRESET R0 28
        IOMARKER 1984 1360 RXUSRCLK2 R0 28
        IOMARKER 2688 976 RXRESET R180 24
        IOMARKER 2688 1008 RXUSRCLK2 R180 24
        IOMARKER 1984 1328 GOOD_FRAME R0 28
        BEGIN BRANCH MOD_ENA(5:0)
            WIRE 3200 784 3248 784
        END BRANCH
        IOMARKER 3248 784 MOD_ENA(5:0) R0 28
        BEGIN INSTANCE RXFI 2736 1072 R0
        END INSTANCE
        BEGIN BRANCH RST_SEQ
            WIRE 3200 944 3376 944
            BEGIN DISPLAY 3376 944 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH MAC_REQ
            WIRE 3200 912 3248 912
        END BRANCH
        IOMARKER 3248 912 MAC_REQ R0 28
        BEGIN BRANCH FF_READ
            WIRE 2400 720 2736 720
        END BRANCH
        BEGIN BRANCH MAC_SRC(15:0)
            WIRE 2400 816 2560 816
            WIRE 2560 816 2736 816
            BEGIN DISPLAY 2560 816 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH FF_MAC_POP
            WIRE 2400 752 2736 752
        END BRANCH
        BEGIN BRANCH FF_MT
            WIRE 2400 880 2464 880
            WIRE 2464 880 2736 880
            BEGIN DISPLAY 2464 880 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 20 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH FF_FULL
            WIRE 2400 912 2432 912
            BEGIN DISPLAY 2432 912 ATTR Name
                ALIGNMENT SOFT-LEFT
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH FF_AF
            WIRE 2400 944 2432 944
            BEGIN DISPLAY 2432 944 ATTR Name
                ALIGNMENT SOFT-LEFT
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH RXF_BUSY
            WIRE 2400 688 2576 688
            WIRE 2576 688 2736 688
            BEGIN DISPLAY 2576 688 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
    END SHEET
    BEGIN SHEET 2 3520 2720
        BEGIN INSTANCE XLXI_6 3520 2720 R0
        END INSTANCE
        BEGIN BRANCH TXKERR(1:0)
            WIRE 272 2208 352 2208
        END BRANCH
        BEGIN BRANCH TXBUFERR
            WIRE 272 2176 352 2176
        END BRANCH
        BEGIN BRANCH TXRUNDISP(1:0)
            WIRE 272 2240 352 2240
        END BRANCH
        BEGIN BRANCH TXSTATUS(15:0)
            WIRE 944 2528 1040 2528
        END BRANCH
        BEGIN INSTANCE TXMON 352 2592 R0
        END INSTANCE
        BEGIN BRANCH XMIT_CNT(31:0)
            WIRE 944 2464 1040 2464
        END BRANCH
        BEGIN BRANCH XERR_CNT(31:0)
            WIRE 944 2496 1040 2496
        END BRANCH
        BEGIN BRANCH TX_PROC_S
            WIRE 944 2048 1024 2048
            WIRE 1024 2048 1232 2048
            BEGIN DISPLAY 1024 2048 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        IOMARKER 272 2208 TXKERR(1:0) R180 28
        IOMARKER 272 2176 TXBUFERR R180 28
        IOMARKER 272 2240 TXRUNDISP(1:0) R180 28
        IOMARKER 1040 2528 TXSTATUS(15:0) R0 28
        IOMARKER 1040 2496 XERR_CNT(31:0) R0 28
        IOMARKER 1040 2464 XMIT_CNT(31:0) R0 28
        BEGIN BRANCH TXUSRCLK2
            WIRE 272 2528 352 2528
        END BRANCH
        BEGIN BRANCH TXRESET
            WIRE 272 2496 352 2496
        END BRANCH
        IOMARKER 272 2528 TXUSRCLK2 R180 28
        IOMARKER 272 2496 TXRESET R180 28
        BEGIN BRANCH NORM_PB_MT
            WIRE 944 2176 1056 2176
            BEGIN DISPLAY 1056 2176 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_PB_AF
            WIRE 944 2208 1056 2208
            BEGIN DISPLAY 1056 2208 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_PB_FULL
            WIRE 944 2240 1056 2240
            BEGIN DISPLAY 1056 2240 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_PB_FULL
            WIRE 944 2336 1056 2336
            BEGIN DISPLAY 1056 2336 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_PB_AF
            WIRE 944 2304 1056 2304
            BEGIN DISPLAY 1056 2304 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_PB_MT
            WIRE 944 2272 1056 2272
            BEGIN DISPLAY 1056 2272 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_PB_MT
            WIRE 944 2368 1056 2368
            BEGIN DISPLAY 1056 2368 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_PB_AF
            WIRE 944 2400 1056 2400
            BEGIN DISPLAY 1056 2400 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_PB_FULL
            WIRE 944 2432 1056 2432
            BEGIN DISPLAY 1056 2432 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TX_INPRGS
            WIRE 944 2144 1072 2144
        END BRANCH
        IOMARKER 1072 2144 TX_INPRGS R0 28
        BEGIN BRANCH TX_UPDT
            WIRE 944 1952 1008 1952
            WIRE 1008 1952 1232 1952
            WIRE 1008 1824 1040 1824
            WIRE 1008 1824 1008 1952
        END BRANCH
        BEGIN BRANCH TX_ERR
            WIRE 944 1856 976 1856
            WIRE 976 1856 1232 1856
            WIRE 976 1760 1024 1760
            WIRE 976 1760 976 1856
        END BRANCH
        BEGIN BRANCH TX_ERR_RST
            WIRE 944 1920 1024 1920
            WIRE 1024 1920 1232 1920
            BEGIN DISPLAY 1024 1920 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TX_MAC_DEST_ERR
            WIRE 944 1888 1072 1888
            WIRE 1072 1888 1232 1888
            BEGIN DISPLAY 1072 1888 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        IOMARKER 1024 1760 TX_ERR R0 28
        IOMARKER 1040 1824 TX_UPDT R0 28
        BEGIN BRANCH TX_PROC_N
            WIRE 944 1984 1024 1984
            WIRE 1024 1984 1232 1984
            BEGIN DISPLAY 1024 1984 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TX_PROC_P
            WIRE 944 2016 1024 2016
            WIRE 1024 2016 1232 2016
            BEGIN DISPLAY 1024 2016 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TXUSRCLK2
            WIRE 1168 2112 1232 2112
        END BRANCH
        BEGIN BRANCH TXRESET
            WIRE 1168 2080 1232 2080
        END BRANCH
        BEGIN BRANCH TX_ADDR(1:0)
            WIRE 1296 224 1296 288
            BEGIN DISPLAY 1296 224 ATTR Name
                ALIGNMENT SOFT-VLEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TX_MAC(15:0)
            WIRE 1360 224 1360 288
            BEGIN DISPLAY 1360 224 ATTR Name
                ALIGNMENT SOFT-VLEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PROT_ENA
            WIRE 1184 1408 1232 1408
            BEGIN DISPLAY 1184 1408 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TXDATA(15:0)
            WIRE 1168 1312 1232 1312
        END BRANCH
        BEGIN BRANCH XTEND
            WIRE 1184 1376 1232 1376
            BEGIN DISPLAY 1184 1376 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TXCHARISK(1:0)
            WIRE 1168 1344 1232 1344
        END BRANCH
        IOMARKER 1168 2080 TXRESET R180 28
        IOMARKER 1168 2112 TXUSRCLK2 R180 28
        IOMARKER 1168 1312 TXDATA(15:0) R180 28
        IOMARKER 1168 1344 TXCHARISK(1:0) R180 28
        BEGIN INSTANCE SPONT_PB 2432 2272 R0
        END INSTANCE
        BEGIN BRANCH SPONT_PB_FULL
            WIRE 2464 2368 2688 2368
            WIRE 2688 2272 2688 2368
            BEGIN DISPLAY 2464 2368 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_PB_AF
            WIRE 2464 2336 2656 2336
            WIRE 2656 2272 2656 2336
            BEGIN DISPLAY 2464 2336 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_PB_MT
            WIRE 2464 2304 2624 2304
            WIRE 2624 2272 2624 2304
            BEGIN DISPLAY 2464 2304 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE PRIO_PB 2432 1568 R0
        END INSTANCE
        BEGIN BRANCH PRIO_PB_FULL
            WIRE 2464 1664 2688 1664
            WIRE 2688 1568 2688 1664
            BEGIN DISPLAY 2464 1664 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_PB_AF
            WIRE 2464 1632 2656 1632
            WIRE 2656 1568 2656 1632
            BEGIN DISPLAY 2464 1632 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_PB_MT
            WIRE 2464 1600 2624 1600
            WIRE 2624 1568 2624 1600
            BEGIN DISPLAY 2464 1600 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_PB_MT
            WIRE 2464 896 2624 896
            WIRE 2624 864 2624 896
            BEGIN DISPLAY 2464 896 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_PB_AF
            WIRE 2464 928 2656 928
            WIRE 2656 864 2656 928
            BEGIN DISPLAY 2464 928 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_PB_FULL
            WIRE 2464 960 2688 960
            WIRE 2688 864 2688 960
            BEGIN DISPLAY 2464 960 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE NORM_PB 2432 864 R0
        END INSTANCE
        BEGIN BRANCH TXUSRCLK2
            WIRE 2368 2208 2432 2208
        END BRANCH
        BEGIN BRANCH TXRESET
            WIRE 2368 2176 2432 2176
        END BRANCH
        BEGIN BRANCH SPONT_PKT_ENA
            WIRE 2368 2144 2432 2144
            BEGIN DISPLAY 2368 2144 ATTR Name
                ALIGNMENT SOFT-RIGHT
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        IOMARKER 2368 2208 TXUSRCLK2 R180 24
        IOMARKER 2368 2176 TXRESET R180 24
        BEGIN BRANCH SPONT_RDY
            WIRE 2016 2048 2160 2048
            WIRE 2160 2048 2432 2048
            BEGIN DISPLAY 2160 2048 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_FRAG_NUM(31:0)
            WIRE 2016 1952 2240 1952
            WIRE 2240 1952 2432 1952
            BEGIN DISPLAY 2240 1952 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_FRAG
            WIRE 2016 2016 2176 2016
            WIRE 2176 2016 2432 2016
            BEGIN DISPLAY 2176 2016 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_NEW
            WIRE 2016 1984 2176 1984
            WIRE 2176 1984 2432 1984
            BEGIN DISPLAY 2176 1984 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_TYPE_STAT(11:0)
            WIRE 2016 1888 2256 1888
            WIRE 2256 1888 2432 1888
            BEGIN DISPLAY 2256 1888 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_LEN(12:0)
            WIRE 2016 1856 2208 1856
            WIRE 2208 1856 2432 1856
            BEGIN DISPLAY 2208 1856 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_DATA(15:0)
            WIRE 2016 1824 2208 1824
            WIRE 2208 1824 2432 1824
            BEGIN DISPLAY 2208 1824 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_POP
            WIRE 2016 2112 2160 2112
            WIRE 2160 2112 2432 2112
            BEGIN DISPLAY 2160 2112 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TXUSRCLK2
            WIRE 2368 1504 2432 1504
        END BRANCH
        BEGIN BRANCH TXRESET
            WIRE 2368 1472 2432 1472
        END BRANCH
        BEGIN BRANCH PRIO_PKT_ENA
            WIRE 2368 1440 2432 1440
            BEGIN DISPLAY 2368 1440 ATTR Name
                ALIGNMENT SOFT-RIGHT
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        IOMARKER 2368 1504 TXUSRCLK2 R180 24
        IOMARKER 2368 1472 TXRESET R180 24
        BEGIN BRANCH PRIO_FRAG_NUM(31:0)
            WIRE 2016 1248 2224 1248
            WIRE 2224 1248 2432 1248
            BEGIN DISPLAY 2224 1248 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_FRAG
            WIRE 2016 1312 2160 1312
            WIRE 2160 1312 2432 1312
            BEGIN DISPLAY 2160 1312 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_NEW
            WIRE 2016 1280 2160 1280
            WIRE 2160 1280 2432 1280
            BEGIN DISPLAY 2160 1280 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_TYPE_STAT(11:0)
            WIRE 2016 1184 2192 1184
            WIRE 2192 1184 2432 1184
            BEGIN DISPLAY 2192 1184 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_LEN(12:0)
            WIRE 2016 1152 2192 1152
            WIRE 2192 1152 2432 1152
            BEGIN DISPLAY 2192 1152 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_RDY
            WIRE 2016 1344 2160 1344
            WIRE 2160 1344 2432 1344
            BEGIN DISPLAY 2160 1344 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_POP
            WIRE 2016 1408 2160 1408
            WIRE 2160 1408 2432 1408
            BEGIN DISPLAY 2160 1408 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_DATA(15:0)
            WIRE 2016 1120 2192 1120
            WIRE 2192 1120 2432 1120
            BEGIN DISPLAY 2192 1120 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TXRESET
            WIRE 2384 768 2432 768
        END BRANCH
        BEGIN BRANCH TXUSRCLK2
            WIRE 2384 800 2432 800
        END BRANCH
        BEGIN BRANCH NORM_PKT_ENA
            WIRE 2384 736 2432 736
            BEGIN DISPLAY 2384 736 ATTR Name
                ALIGNMENT SOFT-RIGHT
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        IOMARKER 2384 800 TXUSRCLK2 R180 24
        IOMARKER 2384 768 TXRESET R180 24
        BEGIN BRANCH NORM_RDY
            WIRE 2016 640 2176 640
            WIRE 2176 640 2432 640
            BEGIN DISPLAY 2176 640 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_FRAG_NUM(31:0)
            WIRE 2016 544 2240 544
            WIRE 2240 544 2432 544
            BEGIN DISPLAY 2240 544 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE TXMAC 1232 2176 R0
        END INSTANCE
        BEGIN BRANCH NORM_NEW
            WIRE 2016 576 2176 576
            WIRE 2176 576 2432 576
            BEGIN DISPLAY 2176 576 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_FRAG
            WIRE 2016 608 2192 608
            WIRE 2192 608 2432 608
            BEGIN DISPLAY 2192 608 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_LEN(12:0)
            WIRE 2016 448 2208 448
            WIRE 2208 448 2432 448
            BEGIN DISPLAY 2208 448 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_TYPE_STAT(11:0)
            WIRE 2016 480 2208 480
            WIRE 2208 480 2432 480
            BEGIN DISPLAY 2208 480 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_DATA(15:0)
            WIRE 2016 416 2192 416
            WIRE 2192 416 2432 416
            BEGIN DISPLAY 2192 416 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_POP
            WIRE 2016 704 2160 704
            WIRE 2160 704 2432 704
            BEGIN DISPLAY 2160 704 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_POPMH
            WIRE 2016 672 2176 672
            WIRE 2176 672 2432 672
            BEGIN DISPLAY 2176 672 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_MAC_HDR(15:0)
            WIRE 2016 512 2240 512
            WIRE 2240 512 2432 512
            BEGIN DISPLAY 2240 512 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_MAC_HDR(15:0)
            WIRE 2016 1216 2224 1216
            WIRE 2224 1216 2432 1216
            BEGIN DISPLAY 2224 1216 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_MAC_HDR(15:0)
            WIRE 2016 1920 2224 1920
            WIRE 2224 1920 2432 1920
            BEGIN DISPLAY 2224 1920 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_POPMH
            WIRE 2016 1376 2160 1376
            WIRE 2160 1376 2432 1376
            BEGIN DISPLAY 2160 1376 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_POPMH
            WIRE 2016 2080 2160 2080
            WIRE 2160 2080 2432 2080
            BEGIN DISPLAY 2160 2080 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_VALID
            WIRE 2864 576 2976 576
            WIRE 2976 304 2976 464
            WIRE 2976 464 2976 576
            BEGIN DISPLAY 2976 464 ATTR Name
                ALIGNMENT HARD-BVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_VALID
            WIRE 2864 1280 3072 1280
            WIRE 3072 304 3072 1152
            WIRE 3072 1152 3072 1280
            BEGIN DISPLAY 3072 1152 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_VALID
            WIRE 2864 1984 3168 1984
            WIRE 3168 304 3168 1808
            WIRE 3168 1808 3168 1984
            BEGIN DISPLAY 3168 1808 ATTR Name
                ALIGNMENT SOFT-TVCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TRANSMIT(15:0)
            WIRE 2864 704 2944 704
            WIRE 2944 704 2944 1408
            WIRE 2944 1408 2944 2112
            WIRE 2944 2112 3232 2112
            WIRE 2864 1408 2944 1408
            WIRE 2864 2112 2944 2112
        END BRANCH
        BEGIN BRANCH TXINSTR(2:0)
            WIRE 2864 736 2912 736
            WIRE 2912 736 2912 1440
            WIRE 2912 1440 2912 2144
            WIRE 2912 2144 3232 2144
            WIRE 2864 1440 2912 1440
            WIRE 2864 2144 2912 2144
        END BRANCH
        BEGIN BRANCH DFLT_MAC(15:0)
            WIRE 2864 672 2976 672
            WIRE 2976 672 2976 1376
            WIRE 2976 1376 2976 2080
            WIRE 2976 2080 3232 2080
            WIRE 2864 1376 2976 1376
            WIRE 2864 2080 2976 2080
            BEGIN DISPLAY 3232 2080 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH DFLT_ADDR(1:0)
            WIRE 2864 640 3008 640
            WIRE 3008 640 3008 1344
            WIRE 3008 1344 3008 2048
            WIRE 3008 2048 3248 2048
            WIRE 2864 1344 3008 1344
            WIRE 2864 2048 3008 2048
            WIRE 3008 304 3008 640
            BEGIN DISPLAY 3248 2048 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        IOMARKER 3232 2144 TXINSTR(2:0) R0 28
        IOMARKER 3232 2112 TRANSMIT(15:0) R0 28
        BEGIN BRANCH NORM_MHBITS(1:0)
            WIRE 2016 384 2208 384
            WIRE 2208 384 2432 384
            BEGIN DISPLAY 2208 384 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_MHBITS(1:0)
            WIRE 2016 1088 2208 1088
            WIRE 2208 1088 2432 1088
            BEGIN DISPLAY 2208 1088 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_MHBITS(1:0)
            WIRE 2016 1792 2208 1792
            WIRE 2208 1792 2432 1792
            BEGIN DISPLAY 2208 1792 ATTR Name
                ALIGNMENT SOFT-BCENTER
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_MH_MT
            WIRE 2016 864 2240 864
            WIRE 2240 864 2592 864
            BEGIN DISPLAY 2240 864 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_MH_MT
            WIRE 2016 1568 2240 1568
            WIRE 2240 1568 2592 1568
            BEGIN DISPLAY 2240 1568 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_MH_MT
            WIRE 1648 2176 1648 2272
            WIRE 1648 2272 2256 2272
            WIRE 2256 2272 2592 2272
            BEGIN DISPLAY 2256 2272 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SW2(3:0)
            WIRE 1120 1600 1232 1600
        END BRANCH
        BEGIN BRANCH TX_TEST_A(15:0)
            WIRE 1552 2176 1552 2304
            WIRE 1552 2304 1552 2464
            WIRE 1552 2464 1696 2464
        END BRANCH
        BEGIN BRANCH TX_TEST_B(15:0)
            WIRE 1584 2176 1584 2432
            WIRE 1584 2432 1696 2432
        END BRANCH
        BEGIN BRANCH SW2(3:0)
            WIRE 2400 352 2432 352
            BEGIN DISPLAY 2400 352 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SW2(3:0)
            WIRE 2384 1760 2432 1760
            BEGIN DISPLAY 2384 1760 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NPB_TEST(15:0)
            WIRE 2864 608 3216 608
            BEGIN DISPLAY 3216 608 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PPB_TEST(15:0)
            WIRE 2864 1312 3216 1312
            BEGIN DISPLAY 3216 1312 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPB_TEST(15:0)
            WIRE 2864 2016 3216 2016
            BEGIN DISPLAY 3216 2016 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO
            WIRE 1488 2176 1488 2528
            WIRE 1488 2528 1712 2528
            BEGIN DISPLAY 1712 2528 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT
            WIRE 1456 2176 1456 2560
            WIRE 1456 2560 1712 2560
            BEGIN DISPLAY 1712 2560 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        IOMARKER 1696 2432 TX_TEST_B(15:0) R0 28
        IOMARKER 1696 2464 TX_TEST_A(15:0) R0 28
        IOMARKER 1120 1600 SW2(3:0) R180 28
        BEGIN BRANCH SW2(3:0)
            WIRE 2400 1056 2432 1056
            BEGIN DISPLAY 2400 1056 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TXCAT(1:0)
            WIRE 3264 176 3344 176
        END BRANCH
        BEGIN INSTANCE TXD1 2848 304 R0
        END INSTANCE
        BEGIN BRANCH NORM_PKT_ENA
            WIRE 2800 128 2848 128
            BEGIN DISPLAY 2800 128 ATTR Name
                ALIGNMENT SOFT-RIGHT
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_PKT_ENA
            WIRE 2784 160 2848 160
            BEGIN DISPLAY 2784 160 ATTR Name
                ALIGNMENT SOFT-RIGHT
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_PKT_ENA
            WIRE 2784 192 2848 192
            BEGIN DISPLAY 2784 192 ATTR Name
                ALIGNMENT SOFT-RIGHT
                FONT 24 "Arial"
            END DISPLAY
        END BRANCH
        IOMARKER 3344 176 TXCAT(1:0) R0 28
        BEGIN BRANCH TXUSRCLK2
            WIRE 2800 240 2848 240
        END BRANCH
        IOMARKER 2800 240 TXUSRCLK2 R180 24
    END SHEET
    BEGIN SHEET 3 3520 2720
        BEGIN INSTANCE XLXI_2 3520 2720 R0
        END INSTANCE
        BEGIN BRANCH ETHER_CNFG(15:0)
            WIRE 544 1968 720 1968
        END BRANCH
        IOMARKER 544 1968 ETHER_CNFG(15:0) R180 28
        BEGIN INSTANCE eth_c1 720 2224 R0
        END INSTANCE
        BEGIN BRANCH PASS_THRU
            WIRE 1216 1872 1328 1872
            WIRE 1328 1872 1424 1872
            WIRE 1424 1168 1424 1872
            WIRE 1424 1168 1744 1168
            BEGIN DISPLAY 1328 1872 ATTR Name
                ALIGNMENT SOFT-BCENTER
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PROMISC
            WIRE 1216 1904 1424 1904
            BEGIN DISPLAY 1424 1904 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PROT_ENA
            WIRE 1216 1936 1424 1936
            BEGIN DISPLAY 1424 1936 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH XTEND
            WIRE 1216 1968 1424 1968
            BEGIN DISPLAY 1424 1968 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT_PKT_ENA
            WIRE 1216 2000 1424 2000
            BEGIN DISPLAY 1424 2000 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO_PKT_ENA
            WIRE 1216 2032 1424 2032
            BEGIN DISPLAY 1424 2032 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_PKT_ENA
            WIRE 1216 2064 1424 2064
            BEGIN DISPLAY 1424 2064 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN INSTANCE ETH_CP1 1744 1360 R0
        END INSTANCE
        BEGIN BRANCH MOD_ENA(5)
            WIRE 1936 560 1936 672
            BEGIN DISPLAY 1936 560 ATTR Name
                ALIGNMENT SOFT-VLEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TRANSMIT(15:0)
            WIRE 2064 1360 2064 1488
            BEGIN DISPLAY 2064 1488 ATTR Name
                ALIGNMENT SOFT-VRIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TXINSTR(2:0)
            WIRE 2000 1360 2000 1488
            BEGIN DISPLAY 2000 1488 ATTR Name
                ALIGNMENT SOFT-VRIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TXCAT(1:0)
            WIRE 1936 1360 1936 1488
            BEGIN DISPLAY 1936 1488 ATTR Name
                ALIGNMENT SOFT-VRIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH RCTRL(2:0)
            WIRE 2000 560 2000 672
            BEGIN DISPLAY 2000 560 ATTR Name
                ALIGNMENT SOFT-VLEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH RECEIVE(15:0)
            WIRE 2064 560 2064 672
            BEGIN DISPLAY 2064 560 ATTR Name
                ALIGNMENT SOFT-VLEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH RXUSRCLK2
            WIRE 1664 1296 1744 1296
            BEGIN DISPLAY 1664 1296 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH RXRESET
            WIRE 1664 1264 1744 1264
            BEGIN DISPLAY 1664 1264 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH CP_RST
            WIRE 1664 1232 1744 1232
        END BRANCH
        IOMARKER 1664 1232 CP_RST R180 28
        BEGIN BRANCH FRAME_REQ
            WIRE 2240 976 2352 976
            BEGIN DISPLAY 2352 976 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ETH_RCV_BR
            WIRE 2240 1008 2352 1008
        END BRANCH
        BEGIN BRANCH RST_SEQ
            WIRE 2240 1040 2352 1040
            BEGIN DISPLAY 2352 1040 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH MAC_REQ
            WIRE 2240 944 2368 944
            BEGIN DISPLAY 2368 944 ATTR Name
                ALIGNMENT SOFT-LEFT
            END DISPLAY
        END BRANCH
        IOMARKER 2352 1008 ETH_RCV_BR R0 28
        BEGIN BRANCH PRIO_PB_AF
            WIRE 1584 848 1744 848
            BEGIN DISPLAY 1584 848 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH NORM_PB_AF
            WIRE 1584 816 1744 816
            BEGIN DISPLAY 1584 816 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH ETH_RCV_BG
            WIRE 1584 784 1744 784
        END BRANCH
        IOMARKER 1584 784 ETH_RCV_BG R180 28
        BEGIN BRANCH PREP4SHTDWN
            WIRE 1664 1104 1744 1104
        END BRANCH
        BEGIN BRANCH RDY4SHTDWN
            WIRE 2240 1104 2352 1104
        END BRANCH
        IOMARKER 1664 1104 PREP4SHTDWN R180 28
        IOMARKER 2352 1104 RDY4SHTDWN R0 28
        BEGIN BRANCH USR_LED_REG(31:0)
            WIRE 2240 1136 2336 1136
        END BRANCH
        IOMARKER 2336 1136 USR_LED_REG(31:0) R0 28
        BEGIN INSTANCE ETSM1 496 992 R0
        END INSTANCE
        BEGIN BRANCH NPB_TEST(15:0)
            WIRE 400 416 496 416
            BEGIN DISPLAY 400 416 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PPB_TEST(15:0)
            WIRE 400 576 496 576
            BEGIN DISPLAY 400 576 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPB_TEST(15:0)
            WIRE 400 736 496 736
            BEGIN DISPLAY 400 736 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH PRIO
            WIRE 400 1056 672 1056
            WIRE 672 992 672 1056
            BEGIN DISPLAY 400 1056 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH SPONT
            WIRE 400 1120 736 1120
            WIRE 736 992 736 1120
            BEGIN DISPLAY 400 1120 ATTR Name
                ALIGNMENT SOFT-RIGHT
            END DISPLAY
        END BRANCH
        BEGIN BRANCH TX_TEST_C(15:0)
            WIRE 880 576 1040 576
        END BRANCH
        IOMARKER 1040 576 TX_TEST_C(15:0) R0 28
        BEGIN BRANCH RESET_CNFG(9:8)
            WIRE 1664 1040 1744 1040
        END BRANCH
        IOMARKER 1664 1040 RESET_CNFG(9:8) R180 28
    END SHEET
END SCHEMATIC
