`timescale 1ns / 1ps

`ifndef HEADER
`include "header.v"
`endif


module Clock_Man(EXTCLK, POW_ON_RST, VME_OSC, VMECE,
                 RW_INI, RAWCLK, BRAWCLK, USRCLK,
                 SYSCLK, SER_CLK, VME_SYSCLK, DV1024CLK, CK_3P9MS,
                 DCM_RST, DCM_LCK, DCM_RDY, INC_LC, RST_TMO, TMO_RST, TMO, RST_DONE);


     input EXTCLK;
     input POW_ON_RST;
     input VME_OSC;
     input VMECE;
    output RW_INI;
    output RAWCLK;
    output BRAWCLK;
    output USRCLK;
    output SYSCLK;
    output SER_CLK;
    output VME_SYSCLK;
    output DV1024CLK;
    output CK_3P9MS;
    output DCM_RST;
    output DCM_LCK;
    output DCM_RDY;
    output INC_LC;
    output RST_TMO;
    output TMO_RST;
    output TMO;
    output RST_DONE;

wire RW_INI;
wire RAWCLK;
wire BRAWCLK;
wire USRCLK;
wire SYSCLK;
wire SER_CLK;
wire VME_SYSCLK;
wire DV1024CLK;
wire CK_3P9MS;
wire DCM_RST;
wire DCM_LCK;
wire DCM_RDY;
wire INC_LC;
wire RST_TMO;
wire TMO_RST;
wire TMO;
wire RST_DONE;

reg [2:0] DCM_ST;
reg [3:0] LLC;
reg [5:0] TMO_CNT;

wire clk1x_u1;
wire clk2x_u1;
wire serclk_w;
wire clk180;
wire clk270;
wire clk2x180;
wire clk90;
wire clkfx;
wire clkfx180;
wire psdone;
wire [7:0] status;


wire DSTRT;
wire DV32C;
wire DV1024C;
wire IMC;
wire MSC;
wire DV32R;


assign RW_INI = !DSTRT;
assign DCM_RST = (DCM_ST == `RST_DCM);
assign DCM_RDY = (DCM_ST == `Clk_Rdy);
assign INC_LC  = (DCM_ST == `Inc_Lost);
assign RST_TMO = (DCM_ST == `RST_TMO) || (DCM_ST == `Inc_Lost);
assign TMO_RST = DCM_RST || RST_TMO;
assign TMO = (TMO_CNT == `DCM_TMO);


IBUFG INCLKBUF (.I(EXTCLK),.O(RAWCLK));
BUFG REFBUF (.I(RAWCLK),.O(BRAWCLK));



    // Instantiate the DCM primitive//
   DCM #(
      .CLKDV_DIVIDE(8.0), // Divide by: 1.5,2.0,2.5,3.0,3.5,4.0,4.5,5.0,5.5,6.0,6.5
                          //   7.0,7.5,8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0 or 16.0
      .CLKFX_DIVIDE(1),   // Can be any integer from 1 to 32
      .CLKFX_MULTIPLY(4), // Can be any integer from 2 to 32
      .CLKIN_DIVIDE_BY_2("FALSE"), // TRUE/FALSE to enable CLKIN divide by two feature
      .CLKIN_PERIOD(16.0),  // Specify period of input clock
      .CLKOUT_PHASE_SHIFT("NONE"), // Specify phase shift of NONE, FIXED or VARIABLE
      .CLK_FEEDBACK("1X"),  // Specify clock feedback of NONE, 1X or 2X
      .DESKEW_ADJUST("SYSTEM_SYNCHRONOUS"), // SOURCE_SYNCHRONOUS, SYSTEM_SYNCHRONOUS or
                                            //   an integer from 0 to 15
      .DFS_FREQUENCY_MODE("LOW"),  // HIGH or LOW frequency mode for frequency synthesis
      .DLL_FREQUENCY_MODE("LOW"),  // HIGH or LOW frequency mode for DLL
      .DUTY_CYCLE_CORRECTION("TRUE"), // Duty cycle correction, TRUE or FALSE
      .FACTORY_JF(16'hC080),   // FACTORY JF values
      .PHASE_SHIFT(0),     // Amount of fixed phase shift from -255 to 255
      .STARTUP_WAIT("FALSE")   // Delay configuration DONE until DCM LOCK, TRUE/FALSE
   ) USR_DCM (
      .CLK0(clk1x_u1),     // 0 degree DCM CLK output
      .CLK180(clk180), // 180 degree DCM CLK output
      .CLK270(clk270), // 270 degree DCM CLK output
      .CLK2X(clk2x_u1),   // 2X DCM CLK output
      .CLK2X180(clk2x180), // 2X, 180 degree DCM CLK out
      .CLK90(clk90),   // 90 degree DCM CLK output
      .CLKDV(serclk_w),   // Divided DCM CLK out (CLKDV_DIVIDE)
      .CLKFX(clkfx),   // DCM CLK synthesis out (M/D)
      .CLKFX180(clkfx180), // 180 degree CLK synthesis out
      .DSSEN(1'b0), 
      .LOCKED(DCM_LCK), // DCM LOCK status output
      .PSDONE(psdone), // Dynamic phase adjust done output
      .STATUS(status), // 8-bit DCM status bits output
      .CLKFB(USRCLK),   // DCM clock feedback
      .CLKIN(RAWCLK),   // Clock input (from IBUFG, BUFG or DCM)
      .PSCLK(1'b0),   // Dynamic phase adjust clock input
      .PSEN(1'b0),     // Dynamic phase adjust enable input
      .PSINCDEC(1'b0), // Dynamic phase adjust increment/decrement
      .RST(DCM_RST)        // DCM asynchronous reset input
   );

BUFG USRBUF  (.I(clk1x_u1),.O(USRCLK));
BUFG SYSBUF   (.I(clk2x_u1),.O(SYSCLK));

SRL16  DLY_STRT(.CLK(BRAWCLK),.D(1'b1),.Q(DSTRT),.A3(1'b0),.A2(1'b1),.A1(1'b0),.A0(1'b0)); // Hold off start up 4 clocks


///////////////////////////////////
//                               //
// VME System clock              //
//                               //
///////////////////////////////////

BUFGCE VMEBUF (.I(VME_OSC),.CE(VMECE),.O(VME_SYSCLK));


///////////////////////////////////
//                               //
// Serial Clock                  //
//                               //
///////////////////////////////////

BUFG SERBUF   (.I(serclk_w),.O(SER_CLK));

///////////////////////////////////
//                               //
// Divide by 1024 clock          //
//     (16.384 uS period)        //
///////////////////////////////////

SRL16E  DV32_CLK    (.CLK(USRCLK),.CE(!POW_ON_RST),.D(!DV32C),.Q(DV32C),.A3(1'b1),.A2(1'b1),.A1(1'b1),.A0(1'b1)); // 16 bits divide by 32
SRL16E  DV1024_CLK  (.CLK(DV32C), .CE(!POW_ON_RST),.D(!DV1024C),.Q(DV1024C),.A3(1'b1),.A2(1'b1),.A1(1'b1),.A0(1'b1));// 16 bits divide by 32
BUFG DV1024_CLK_BUF (.I(DV1024C),.O(DV1024CLK));

///////////////////////////////////
//                               //
// 3.9 mS Clock                  //
//                               //
///////////////////////////////////

SRL16E  IM_CLK (.CLK(DV1024CLK),.CE(!POW_ON_RST),.D(!IMC),.Q(IMC),.A3(1'b0),.A2(1'b1),.A1(1'b1),.A0(1'b0));   // 6 bits divide by 12
SRL16E  MS_CLK (.CLK(IMC),.CE(!POW_ON_RST),.D(!MSC),.Q(MSC),.A3(1'b1),.A2(1'b0),.A1(1'b1),.A0(1'b0));   // 10 bits divide by 20
BUF MS_CLK_BUF (.I(MSC),.O(CK_3P9MS));

///////////////////////////////////////////////
//                                           //
// DCM Control Module                        //
// Resets DCM on power up and loss of lock   //
//                                           //
///////////////////////////////////////////////

always @(posedge BRAWCLK or posedge RW_INI)
begin: DCM_Control_FSM
   if(RW_INI)
      DCM_ST <= `RST_DCM;
   else
      case(DCM_ST)
         `RST_DCM:
            if(RST_DONE)
               DCM_ST <= `W4Lock;
            else
               DCM_ST <= `RST_DCM;
         `W4Lock:
            if(TMO)
               DCM_ST <= `RST_DCM;
            else if(DCM_LCK)
               DCM_ST <= `RST_TMO;
            else
               DCM_ST <= `W4Lock;
         `RST_TMO:
            DCM_ST <= `W4TMO;
         `W4TMO:
            if(!DCM_LCK)
               DCM_ST <= `Inc_Lost;
            else if(TMO)
               DCM_ST <= `Clk_Rdy;
            else
               DCM_ST <= `W4TMO;
         `Clk_Rdy:
            if(!DCM_LCK)
               DCM_ST <= `Inc_Lost;
            else
               DCM_ST <= `Clk_Rdy;
         `Inc_Lost:
            DCM_ST <= `W4Retry;
         `W4Retry:
            if(TMO && !DCM_LCK)
               DCM_ST <= `RST_DCM;
            else if(TMO && DCM_LCK)
               DCM_ST <= `RST_TMO;
            else
               DCM_ST <= `W4Retry;
         default:
            DCM_ST <= `RST_DCM;
      endcase
end

always @(posedge BRAWCLK or posedge RW_INI)
begin: Lock_Lost_Counter
   if(RW_INI)
      LLC <= 4'h0;
   else
      if(INC_LC)
         LLC <= LLC+1;
      else
         LLC <= LLC;
end



SRL16  RSTD(.CLK(BRAWCLK),.D(DCM_RST),.Q(RST_DONE),.A3(1'b1),.A2(1'b1),.A1(1'b1),.A0(1'b1)); // Hold DCM reset for 16 clock cycles
SRL16  DV32_RAW(.CLK(BRAWCLK),.D(!DV32R),.Q(DV32R),.A3(1'b1),.A2(1'b1),.A1(1'b1),.A0(1'b1)); // 16 bits divide by 32

always @(posedge DV32R or posedge TMO_RST)
begin:  DCM_Lock_Time_Out_Counter
   if (TMO_RST)
      TMO_CNT <= 6'h00;
   else
      if(TMO)
         TMO_CNT <= TMO_CNT;
      else
         TMO_CNT <= TMO_CNT + 1;
end

endmodule

