`timescale 1ns / 1ps

module rxstat_err_mon(CLK, RXRESET, RXBUFSTATUS, RXCHARISCOMMA, RXCHECKINGCRC,
      RXCLKCORCNT, RXCOMMADET, RXCRCERR, RXDISPERR, RXLOSSOFSYNC, RXNOTINTABLE,
      RXREALIGN, RXRUNDISP, RXCHARISK,
      SOP, ERR_PROP, CAR_XTEND, EOP, UPD_FRAM_STATS, FRAME_STAT_VALID, GOOD_FRAME, FORCE_RELOAD, RST_CMDS,
      RX_ERR, RXSTATUS, FF_MT, FF_FULL, FF_AF,
      LOCAL_MTCH, BCAST_MTCH, MCAST_MTCH, PASS_THRU, PROMISC, LEN_OK, FRC_RLD_CMD, OVR_MAX, WRNG_SOP,
      STATE_ERR, RCVD_CNT, DRPD_CNT);
//      RAW_STATS);

    input CLK;
    input RXRESET;
    input [1:0] RXBUFSTATUS;
    input [1:0] RXCHARISCOMMA;
    input RXCHECKINGCRC;
    input [2:0] RXCLKCORCNT;
    input RXCOMMADET;
    input RXCRCERR;
    input [1:0] RXDISPERR;
    input [1:0] RXLOSSOFSYNC;
    input [1:0] RXNOTINTABLE;
    input RXREALIGN;
    input [1:0] RXRUNDISP;
    input [1:0] RXCHARISK;
    input SOP;
    input ERR_PROP;
    input CAR_XTEND;
    input EOP;
    input UPD_FRAM_STATS;
    input FF_MT;
    input FF_FULL;
    input FF_AF;
    input LOCAL_MTCH;
    input BCAST_MTCH;
    input MCAST_MTCH;
    input PASS_THRU;
    input PROMISC;
    input LEN_OK;
    input FRC_RLD_CMD;
    input OVR_MAX;
    input WRNG_SOP;
    input [3:0] STATE_ERR;
//   output [15:0] RAW_STATS;
   output FRAME_STAT_VALID;
   output GOOD_FRAME;
   output FORCE_RELOAD;
   output RST_CMDS;
   output RX_ERR;
   output [15:0] RXSTATUS;
   output [31:0] RCVD_CNT;
   output [31:0] DRPD_CNT;

reg [2:0] CRC_ST;
reg RST_TIMER;
reg ENA_TIMER;
reg FRAME_STAT_VALID;
reg GOOD_FRAME;
reg NO_CHECK;
reg NO_CRC_CHECK;
reg BAD_CHECK;
reg BAD_CRC_CHECK;
reg CRC_OK;
reg GOOD_CRC_CHECK;
reg GOOD_FRAME_CHECK;
reg LOAD_STATS;
reg ENA_IN_ERRS;
reg ENA_OUT_ERRS;
reg [15:0] RXSTATUS;
reg [3:0] ERROR_REG;
reg LOCAL_MTCH_REG;
reg BCAST_MTCH_REG;
reg MCAST_MTCH_REG;
reg LEN_OK_REG;
reg OVR_MAX_REG;
reg SOPR;
reg RST_SOPR;
reg FORCE_RELOAD;
reg SET_FORCE_RELOAD;
reg RST_CMDS;

wire [2:0] CRC_TIME;
wire TIMEOUT;
wire IN_ERR;
wire OUT_ERR;
wire RCV_INC;
wire DRP_INC;
wire NOT4ME;
wire SOP_AF_INC;
wire [31:0] RCVD_CNT;
wire [31:0] DRPD_CNT;
//wire [15:0] IN_PKT_ERRS;
//wire [15:0] OUT_of_PKT_ERRS;
//wire [15:0] WSOP_CNT;
//wire [15:0] SOP_AF_CNT;

`ifdef HEADER
`else
`include "header.v"
`endif


defparam  timer.width = 3;
//defparam  in_pkt_cnt.width = 16;
//defparam  out_of_pkt_cnt.width = 16;
defparam  rcvd_pkt_cntr.width = 32;
defparam  dropped_pkt_cntr.width = 32;
//defparam  wrong_sop_cntr.width = 16;
//defparam  sop_af_cntr.width = 16;

cnt_up  timer (.clk(CLK),.inc(ENA_TIMER),.r(RST_TIMER),.count(CRC_TIME));
//cnt_up  in_pkt_cnt (.clk(CLK),.inc(IN_ERR),.r(RXRESET),.count(IN_PKT_ERRS));
//cnt_up  out_of_pkt_cnt (.clk(CLK),.inc(OUT_ERR),.r(RXRESET),.count(OUT_of_PKT_ERRS));
cnt_up  rcvd_pkt_cntr (.clk(CLK),.inc(RCV_INC),.r(RXRESET),.count(RCVD_CNT));
cnt_up  dropped_pkt_cntr (.clk(CLK),.inc(DRP_INC),.r(RXRESET),.count(DRPD_CNT));
//cnt_up  wrong_sop_cntr (.clk(CLK),.inc(WRNG_SOP),.r(RXRESET),.count(WSOP_CNT));
//cnt_up  sop_af_cntr (.clk(CLK),.inc(SOP_AF_INC),.r(RXRESET),.count(SOP_AF_CNT));

assign TIMEOUT = (CRC_TIME == `Time_Limit);
assign IN_ERR =        ENA_IN_ERRS && ((RXDISPERR != 2'b00) || (RXLOSSOFSYNC != 2'b00) || (RXNOTINTABLE != 2'b00));
assign OUT_ERR = ENA_OUT_ERRS && ((RXDISPERR != 2'b00) || (RXLOSSOFSYNC != 2'b00) || (RXNOTINTABLE != 2'b00));
assign RX_ERR = IN_ERR || (SOP && (FF_FULL || FF_AF)) || WRNG_SOP;

assign NOT4ME = !LOCAL_MTCH_REG && !BCAST_MTCH_REG && !MCAST_MTCH_REG;

assign RCV_INC = (FRAME_STAT_VALID && GOOD_FRAME);
assign DRP_INC = LOAD_STATS && (BAD_CRC_CHECK || NO_CRC_CHECK || FF_FULL || (NOT4ME && !PROMISC) || !LEN_OK_REG || OVR_MAX_REG || ERROR_REG[3]);
assign SOP_AF_INC = SOP && FF_AF;
//assign RAW_STATS = {GOOD_FRAME, CRC_OK, BAD_CHECK, NO_CHECK, FF_FULL, EOP, LEN_OK, OVR_MAX, RXCHARISK,  CAR_XTEND, ERR_PROP, STATE_ERR};

always @(posedge CLK)
begin
   RXSTATUS[11:10] <= {FF_FULL, FF_MT};
   if(LOAD_STATS)
      begin
         RXSTATUS[15:12] <= {GOOD_FRAME_CHECK, GOOD_CRC_CHECK, BAD_CRC_CHECK, NO_CRC_CHECK};
         RXSTATUS[9:0] <= {LEN_OK_REG, OVR_MAX_REG, LOCAL_MTCH_REG, BCAST_MTCH_REG, MCAST_MTCH_REG, 1'b0, ERROR_REG};
      end
//   else if(WRNG_SOP)
//      RXSTATUS <= { RXREALIGN, RXCLKCORCNT, RXCOMMADET, 1'b0, RXBUFSTATUS, RXCHARISCOMMA, RXDISPERR, RXLOSSOFSYNC, RXNOTINTABLE };
   else
      begin
         RXSTATUS[15:12] <= RXSTATUS[15:12];
         RXSTATUS[9:0] <= RXSTATUS[9:0];
      end
end

///////////////////////////////////////////////////////////////////////////
// SOPR is a latched SOP.                                                //
// It is required so the the CRC checking state machine does not miss    //
// the SOP of the next packet while waiting for the CRC signal of the    //
// last packet.  SOPR is reset in the Wait_for_Update state which is     //
// after the SOPR has been seen in state "Wait_for_SOP".                 //
///////////////////////////////////////////////////////////////////////////
always @(posedge CLK)
begin: SOP_REG
   if (SOP)
      SOPR <= 1;
   else if (RST_SOPR)
      SOPR <= 0;
   else
      SOPR <= SOPR;
end
always @(posedge CLK or posedge RXRESET)
begin
   if (RXRESET)
      FORCE_RELOAD <= 0;
   else
      if (SET_FORCE_RELOAD)
         FORCE_RELOAD <= 1;
      else
         FORCE_RELOAD <= FORCE_RELOAD;
end


always @(posedge CLK)
begin
   if(UPD_FRAM_STATS)
      begin
         ERROR_REG <= STATE_ERR;
         LOCAL_MTCH_REG <= LOCAL_MTCH;
         BCAST_MTCH_REG <= BCAST_MTCH;
         MCAST_MTCH_REG <= MCAST_MTCH;
         LEN_OK_REG <= LEN_OK;
         OVR_MAX_REG <= OVR_MAX;
      end
   else
      begin
         ERROR_REG <= ERROR_REG;
         LOCAL_MTCH_REG <= LOCAL_MTCH_REG;
         BCAST_MTCH_REG <= BCAST_MTCH_REG;
         MCAST_MTCH_REG <= MCAST_MTCH_REG;
         LEN_OK_REG <= LEN_OK_REG;
         OVR_MAX_REG <= OVR_MAX_REG;
      end
end
   
always @(posedge CLK)
begin
   NO_CRC_CHECK <= NO_CHECK;
   BAD_CRC_CHECK <= BAD_CHECK;
   GOOD_CRC_CHECK <= CRC_OK;
   GOOD_FRAME_CHECK <= GOOD_FRAME;
end

always @(posedge CLK or posedge RXRESET)
begin
   if (RXRESET)
      CRC_ST <= `Wait_for_SOP;
   else
      case (CRC_ST)
         `Wait_for_SOP:
            if(SOP || SOPR)
               CRC_ST <= `Wait_for_Update;
            else
               CRC_ST <= `Wait_for_SOP;
         `Wait_for_Update:
            if(UPD_FRAM_STATS && !STATE_ERR[3])
               CRC_ST <= `Wait_for_CRC_Check;
            else if(UPD_FRAM_STATS && STATE_ERR[3])
               CRC_ST <= `Record_Stats;
            else
               CRC_ST <= `Wait_for_Update;
         `Wait_for_CRC_Check:
            casex ({TIMEOUT,RXCHECKINGCRC,RXCRCERR})
               3'bx10:
                  CRC_ST <= `Good_CRC;
               3'bx11:
                  CRC_ST <= `Bad_CRC;
               3'b10x:
                  CRC_ST <= `No_CRC_Check;
               3'b00x:
                  CRC_ST <= `Wait_for_CRC_Check;
               default:
                  CRC_ST <= `Wait_for_CRC_Check;
             endcase
         `Good_CRC:
            CRC_ST <= `Record_Stats;
         `Bad_CRC:
            CRC_ST <= `Record_Stats;
         `No_CRC_Check:
            CRC_ST <= `Record_Stats;
         `Record_Stats:
            CRC_ST <= `Wait_for_SOP;
         default:
            CRC_ST <= `Wait_for_SOP;
      endcase
end

always @(CRC_ST or LEN_OK_REG or PASS_THRU or ERROR_REG or FRC_RLD_CMD)
begin
   case (CRC_ST)
      `Wait_for_SOP:
         begin
            RST_TIMER <= 1;
            RST_SOPR <= 0;
            ENA_TIMER <= 0;
            ENA_IN_ERRS <= 0;
            ENA_OUT_ERRS <= 1;
            FRAME_STAT_VALID <= 0;
            GOOD_FRAME <= 0;
            SET_FORCE_RELOAD <= 0;
            LOAD_STATS <= 0;
            RST_CMDS <= 0;
            NO_CHECK <= 0;
            BAD_CHECK <= 0;
            CRC_OK <= 0;
         end
      `Wait_for_Update:
         begin
            RST_TIMER <= 0;
            RST_SOPR <= 1;
            ENA_TIMER <= 0;
            ENA_IN_ERRS <= 1;
            ENA_OUT_ERRS <= 0;
            FRAME_STAT_VALID <= 0;
            GOOD_FRAME <= 0;
            SET_FORCE_RELOAD <= 0;
            LOAD_STATS <= 0;
            RST_CMDS <= 0;
            NO_CHECK <= 0;
            BAD_CHECK <= 0;
            CRC_OK <= 0;
         end
      `Wait_for_CRC_Check:
         begin
            RST_TIMER <= 0;
            RST_SOPR <= 0;
            ENA_TIMER <= 1;
            ENA_IN_ERRS <= 0;
            ENA_OUT_ERRS <= 1;
            FRAME_STAT_VALID <= 0;
            GOOD_FRAME <= 0;
            SET_FORCE_RELOAD <= 0;
            LOAD_STATS <= 0;
            RST_CMDS <= 0;
            NO_CHECK <= 0;
            BAD_CHECK <= 0;
            CRC_OK <= 0;
         end
      `Good_CRC:
         begin
            RST_TIMER <= 0;
            RST_SOPR <= 0;
            ENA_TIMER <= 0;
            ENA_IN_ERRS <= 0;
            ENA_OUT_ERRS <= 1;
            FRAME_STAT_VALID <= 1;
            GOOD_FRAME <= (LEN_OK_REG || PASS_THRU) && !ERROR_REG[3] && !FRC_RLD_CMD;
            SET_FORCE_RELOAD <= LEN_OK_REG && !ERROR_REG[3] && FRC_RLD_CMD;
            LOAD_STATS <= 0;
            RST_CMDS <= 0;
            NO_CHECK <= 0;
            BAD_CHECK <= 0;
            CRC_OK <= 1;
         end
      `Bad_CRC:
         begin
            RST_TIMER <= 0;
            RST_SOPR <= 0;
            ENA_TIMER <= 0;
            ENA_IN_ERRS <= 0;
            ENA_OUT_ERRS <= 1;
            FRAME_STAT_VALID <= 1;
            GOOD_FRAME <= 0;
            SET_FORCE_RELOAD <= 0;
            LOAD_STATS <= 0;
            RST_CMDS <= 0;
            NO_CHECK <= 0;
            BAD_CHECK <= 1;
            CRC_OK <= 0;
         end
      `No_CRC_Check:
         begin
            RST_TIMER <= 0;
            RST_SOPR <= 0;
            ENA_TIMER <= 0;
            ENA_IN_ERRS <= 0;
            ENA_OUT_ERRS <= 1;
            FRAME_STAT_VALID <= 1;
            GOOD_FRAME <= 0;
            SET_FORCE_RELOAD <= 0;
            LOAD_STATS <= 0;
            RST_CMDS <= 0;
            NO_CHECK <= 1;
            BAD_CHECK <= 0;
            CRC_OK <= 0;
         end
      `Record_Stats:
         begin
            RST_TIMER <= 0;
            RST_SOPR <= 0;
            ENA_TIMER <= 0;
            ENA_IN_ERRS <= 0;
            ENA_OUT_ERRS <= 1;
            FRAME_STAT_VALID <= 0;
            GOOD_FRAME <= 0;
            SET_FORCE_RELOAD <= 0;
            LOAD_STATS <= 1;
            RST_CMDS <= 1;
            NO_CHECK <= 0;
            BAD_CHECK <= 0;
            CRC_OK <= 0;
         end
      default:
         begin
            RST_TIMER <= 0;
            RST_SOPR <= 0;
            ENA_TIMER <= 0;
            ENA_IN_ERRS <= 0;
            ENA_OUT_ERRS <= 1;
            FRAME_STAT_VALID <= 0;
            GOOD_FRAME <= 0;
            SET_FORCE_RELOAD <= 0;
            LOAD_STATS <= 0;
            RST_CMDS <= 0;
            NO_CHECK <= 0;
            BAD_CHECK <= 0;
            CRC_OK <= 0;
         end
   endcase
end

   
endmodule
