`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"
`endif

module rx_mac_processor(CLK, RXCHARISK, RXDATA, RX_ERR, RXRESET, RST_CMDS, PROMISC,
      ALL_MACS, RCV_ADDR, DATA, RXVALDAT, STORE_MAC, SOP, WRNG_SOP,
      EOP, FRC_RLD_CMD, CAR_XTEND, ERR_PROP,
      UPD_FRAM_STATS, LOCAL_MTCH, BCAST_MTCH, MCAST_MTCH, LEN_OK, OVR_MAX, ACTIVE, STATE_ERR);

    input CLK;
    input [1:0] RXCHARISK;
    input [15:0] RXDATA;
    input RX_ERR;
    input RXRESET;
    input RST_CMDS;
    input PROMISC;
    input [63:0] ALL_MACS;
   output [1:0] RCV_ADDR;
   output [15:0] DATA;
   output RXVALDAT;
   output STORE_MAC;
   output SOP;
   output WRNG_SOP;
   output EOP;
   output FRC_RLD_CMD;
   output CAR_XTEND;
   output ERR_PROP;
   output UPD_FRAM_STATS;
   output LOCAL_MTCH;
   output BCAST_MTCH;
   output MCAST_MTCH;
   output LEN_OK;
   output OVR_MAX;
   output ACTIVE;
   output [3:0] STATE_ERR;




reg ERR;
reg RXVALDAT,STORE_MAC,UPD_FRAM_STATS;

reg [2:0]  STATE;
reg [2:0] MACD;
reg [1:0] MACS;
reg [2:0] LMATCHD,BMATCHD,M1MATCHD,M2MATCHD,M3MATCHD;
reg [15:0] DATA_LEN,LEN_COUNT;
reg [15:0] TIMER;
reg [3:0] STATE_ERR;
reg [15:0] DATA,DATAR,DATA1,DATA2;
reg DL_EQ_LC,DL_LT_MP,LC_EQ_MP;
reg EOP_ODD_REG;
reg SOP,SOF,PRE,EOP_EVEN,EOP_ODD,NOK;
reg WRNG_SOP,IDLE,CAR_XTEND,ERR_PROP;
reg ACTIVE;
reg CAP_CMD;
reg FRC_RLD_CMD;

wire EOP,ERROR,MATCH;
wire D_STORED,S_STORED;
wire [1:0] RCV_ADDR;
wire [15:0] MCAST3_MAC,MCAST2_MAC,MCAST1_MAC,RCV_MAC;

assign MCAST3_MAC = ALL_MACS[63:48];
assign MCAST2_MAC = ALL_MACS[47:32];
assign MCAST1_MAC = ALL_MACS[31:16];
assign    RCV_MAC = ALL_MACS[15:0];

assign        EOP = EOP_EVEN || EOP_ODD;
assign      ERROR = RX_ERR || ERR;
assign LOCAL_MTCH = &LMATCHD;
assign BCAST_MTCH = &BMATCHD;
assign MCAST_MTCH = &M1MATCHD || &M2MATCHD || &M3MATCHD;
assign      MATCH = LOCAL_MTCH || BCAST_MTCH || MCAST_MTCH;
assign   RCV_ADDR = MACD[1:0];
assign   D_STORED = (MACD == 3'd4);
assign   S_STORED = (MACS == 2'd2);
assign     LEN_OK = (DL_EQ_LC || (DL_LT_MP && LC_EQ_MP));   
assign    OVR_MAX = (DATA_LEN > `MAX_BYTE);   

always @ (posedge CLK)
begin
      IDLE <= (RXCHARISK == 2'b10) && ((RXDATA[15:0] == `IDLE1) || (RXDATA[15:0] == `IDLE2));
 CAR_XTEND <= (RXCHARISK[1] == 1'b1) && (RXDATA[15:8] == `K23_7) || (RXCHARISK[0] == 1'b1) && (RXDATA[7:0] == `K23_7);
  ERR_PROP <= (RXCHARISK[1] == 1'b1) && (RXDATA[15:8] == `K30_7) || (RXCHARISK[0] == 1'b1) && (RXDATA[7:0] == `K30_7);
       SOP <= (RXCHARISK[1] == 1'b1) && (RXDATA[15:8] == `K27_7);
  WRNG_SOP <= (RXCHARISK[0] == 1'b1) && (RXDATA[7:0] == `K27_7);
  EOP_EVEN <= (RXCHARISK[1] == 1'b1) && (RXDATA[15:8] == `K29_7);
   EOP_ODD <= (RXCHARISK[0] == 1'b1) && (RXDATA[7:0] == `K29_7);
       PRE <= (RXDATA[15:8] == `PRMBL) || (RXDATA[7:0] == `PRMBL);
       SOF <= (RXDATA[7:0] == `SOF_BYTE);
       NOK <= (RXCHARISK == 2'b00);
end
     
always @ (posedge CLK)
begin
   LC_EQ_MP <= ((EOP_EVEN || EOP_ODD_REG) && (LEN_COUNT == `Min_Pkt));
   DL_LT_MP <= ((EOP_EVEN || EOP_ODD_REG) && (DATA_LEN < `Min_Pkt));
   DL_EQ_LC <= ((EOP_EVEN || EOP_ODD_REG) && (DATA_LEN == LEN_COUNT));
   EOP_ODD_REG <= EOP_ODD;
end

always @ (posedge CLK)
begin
   DATA2 <= RXDATA;
   DATA1 <= DATA2;
   DATAR <= DATA1;
end

always @ (EOP_ODD or DATAR)
begin
   if(EOP_ODD)
      DATA <= {DATAR[15:8],8'h00};
   else
      DATA <= DATAR;
end
always @ (posedge CLK or posedge RXRESET)
begin
   if (RXRESET)
      FRC_RLD_CMD <= 0;
   else
      if(CAP_CMD)
         FRC_RLD_CMD <= (DATA[7:0] == `Force_Reload);
      else if(RST_CMDS)
         FRC_RLD_CMD <= 0;
      else
         FRC_RLD_CMD <= FRC_RLD_CMD;
end

      
    always @ (posedge CLK or posedge RXRESET)
    begin: RX_MAC_FSM
       if (RXRESET)
          STATE <= `Wait_for_packet;
       else
          case (STATE)
             `Wait_for_packet: 
                casex ({ERROR,SOF,SOP})
                   3'b001:
                      STATE <= `Preamble;
                   3'b011: 
                      STATE <= `MAC_Dest;
                   3'b0x0: 
                      STATE <= `Wait_for_packet;
                   3'b1xx: 
                      STATE <= `Update_Stats;
                   default:
                      STATE <= `Update_Stats;
                endcase
             `Preamble:
                casex ({ERROR,PRE,SOF})
                   3'b0x1:
                      STATE <= `MAC_Dest;
                   3'b010: 
                      STATE <= `Preamble;
                   3'b000,3'b1xx: 
                      STATE <= `Update_Stats;
                   default:
                      STATE <= `Update_Stats;
                endcase
             `MAC_Dest: 
                casex ({ERROR,PROMISC,D_STORED,MATCH})
                   4'b0011,4'b011x:
                      STATE <= `MAC_Source;
                   4'b0010,4'b1xxx: 
                      STATE <= `Update_Stats;
                   4'b0x0x: 
                      STATE <= `MAC_Dest;
                   default:
                      STATE <= `Update_Stats;
                endcase
             `MAC_Source: 
                casex ({ERROR,S_STORED})
                   2'b01:
                      STATE <= `Store_LEN;
                   2'b1x: 
                      STATE <= `Update_Stats;
                   2'b00: 
                      STATE <= `MAC_Source;
                   default:
                      STATE <= `Update_Stats;
                endcase
             `Store_LEN: 
                if (ERROR)
                   STATE <= `Update_Stats;
                else
                   STATE <= `Payload;
             `Payload: 
                casex ({ERROR,EOP_EVEN,EOP_ODD_REG})
                   3'b01x,3'b0x1,3'b1xx:
                      STATE <= `Update_Stats;
                   3'b000: 
                      STATE <= `Payload;
                   default:
                      STATE <= `Update_Stats;
                endcase
             `Update_Stats: 
                STATE <= `Wait_for_Idle;
             `Wait_for_Idle:
                if (IDLE)
                   STATE <= `Wait_for_packet;
                else
                   STATE <= `Wait_for_Idle;
             default: 
                STATE <= `Wait_for_packet;
          endcase
    end

    always @(posedge CLK or posedge RXRESET)
    begin: MAC_STORE_CNT
       if (RXRESET)
          begin
             MACD  <= 3'd0;
             MACS  <= 2'd0;
          end
       else
         case (STATE)
            `Wait_for_packet:
               begin
                  MACD  <= 3'd0;
                  MACS  <= 2'd0;
               end
            `MAC_Dest:
                begin
                  MACD <= MACD + 1;
                  MACS <= MACS;
               end
            `MAC_Source:
               begin
                  MACD <= MACD;
                  MACS <= MACS + 1;
               end
            default:
               begin
                  MACD <= MACD;
                  MACS <= MACS;
               end
         endcase
    end


    always @(posedge CLK or posedge RXRESET)
    begin: MAC_MATCH
       if (RXRESET)
          begin
             LMATCHD  <= 3'd0;
             BMATCHD  <= 3'd0;
             M1MATCHD <= 3'd0;
             M2MATCHD <= 3'd0;
             M3MATCHD <= 3'd0;
          end
       else
       case (STATE)
          `Wait_for_packet:
             begin
                LMATCHD  <= 3'd0;
                BMATCHD  <= 3'd0;
                M1MATCHD <= 3'd0;
                M2MATCHD <= 3'd0;
                M3MATCHD <= 3'd0;
             end
          `MAC_Dest:
             case (MACD)
                3'd1:
                   begin
                      LMATCHD[0] <= (DATA1 == RCV_MAC);
                      LMATCHD[2:1] <= LMATCHD[2:1];
                      BMATCHD[0] <= (DATA1 == `MAC_BCAST);
                      BMATCHD[2:1] <= BMATCHD[2:1];
                      M1MATCHD[0] <= (DATA1 == MCAST1_MAC);
                      M1MATCHD[2:1] <= M1MATCHD[2:1];
                      M2MATCHD[0] <= (DATA1 == MCAST2_MAC);
                      M2MATCHD[2:1] <= M2MATCHD[2:1];
                      M3MATCHD[0] <= (DATA1 == MCAST3_MAC);
                      M3MATCHD[2:1] <= M3MATCHD[2:1];
                   end
                3'd2:
                   begin
                      LMATCHD[0] <= LMATCHD[0];
                      LMATCHD[1] <= (DATA1 == RCV_MAC);
                      LMATCHD[2] <= LMATCHD[2];
                      BMATCHD[0] <= BMATCHD[0];
                      BMATCHD[1] <= (DATA1 == `MAC_BCAST);
                      BMATCHD[2] <= BMATCHD[2];
                      M1MATCHD[0] <= M1MATCHD[0];
                      M1MATCHD[1] <= (DATA1 == MCAST1_MAC);
                      M1MATCHD[2] <= M1MATCHD[2];
                      M2MATCHD[0] <= M2MATCHD[0];
                      M2MATCHD[1] <= (DATA1 == MCAST2_MAC);
                      M2MATCHD[2] <= M2MATCHD[2];
                      M3MATCHD[0] <= M3MATCHD[0];
                      M3MATCHD[1] <= (DATA1 == MCAST3_MAC);
                      M3MATCHD[2] <= M3MATCHD[2];
                   end
                3'd3:
                   begin
                      LMATCHD[1:0] <= LMATCHD[1:0];
                      LMATCHD[2] <= (DATA1 == RCV_MAC);
                      BMATCHD[1:0] <= BMATCHD[1:0];
                      BMATCHD[2] <= (DATA1 == `MAC_BCAST);
                      M1MATCHD[1:0] <= M1MATCHD[1:0];
                      M1MATCHD[2] <= (DATA1 == MCAST1_MAC);
                      M2MATCHD[1:0] <= M2MATCHD[1:0];
                      M2MATCHD[2] <= (DATA1 == MCAST2_MAC);
                      M3MATCHD[1:0] <= M3MATCHD[1:0];
                      M3MATCHD[2] <= (DATA1 == MCAST3_MAC);
                   end
                default:
                   begin
                      LMATCHD  <= LMATCHD;
                      BMATCHD  <= BMATCHD;
                      M1MATCHD <= M1MATCHD;
                      M2MATCHD <= M2MATCHD;
                      M3MATCHD <= M3MATCHD;
                   end
             endcase
          default:
             begin
                LMATCHD <= LMATCHD;
                BMATCHD <= BMATCHD;
                M1MATCHD <= M1MATCHD;
                M2MATCHD <= M2MATCHD;
                M3MATCHD <= M3MATCHD;
             end
       endcase
    end
    always @(posedge CLK)
    begin
       case (STATE)
          `Store_LEN:
             CAP_CMD <= 1;
          default:
             CAP_CMD <= 0;
       endcase
    end

    always @(posedge CLK)
    begin: DATA_LEN_REG
       case (STATE)
          `Wait_for_packet:
             begin
                DATA_LEN  <= 16'h0000;
                LEN_COUNT <= 16'h0000;
             end
          `Store_LEN:
             begin
                DATA_LEN <= DATA;
                LEN_COUNT <= LEN_COUNT;
             end
          `Payload:
             begin
                DATA_LEN <= DATA_LEN;
                if (!EOP_EVEN && !EOP_ODD && !EOP_ODD_REG)
                  LEN_COUNT <= LEN_COUNT + 2;
                else if (EOP_ODD)
                  LEN_COUNT <= LEN_COUNT + 1;
                else
                  LEN_COUNT <= LEN_COUNT;
             end
          default:
             begin
                DATA_LEN <= DATA_LEN;
                LEN_COUNT <= LEN_COUNT;
             end
       endcase
    end

    always @(posedge CLK)
    begin: TIMER_REG
       case (STATE)
          `Wait_for_packet: TIMER <= 16'h0000;
          default:   TIMER <= TIMER +1;
       endcase
    end

    always @(posedge CLK or posedge RXRESET)
    begin: STATE_ERR_REG
       if (RXRESET) STATE_ERR <= 0;
       else
           STATE_ERR <= {ERROR,STATE};
    end

always @(STATE)
begin
   case(STATE)
      `Wait_for_packet:
         ACTIVE <= 0;
      default:
         ACTIVE <= 1;
   endcase
end

    always @ (STATE or TIMER or DATA or EOP or EOP_EVEN or EOP_ODD_REG or PRE or SOF or D_STORED or MATCH or PROMISC or NOK or CAR_XTEND or ERR_PROP or LEN_COUNT or DATA_LEN)
    begin:  RX_MAC_OUT
       case (STATE) 
          `Wait_for_packet:
             begin
                UPD_FRAM_STATS <= 0;
                STORE_MAC <= 0;
                RXVALDAT <= 0;
                ERR <= NOK || EOP || CAR_XTEND || ERR_PROP;
             end
          `Preamble:
             begin
                UPD_FRAM_STATS <= 0;
                STORE_MAC <= 0;
                RXVALDAT <= 0;
                ERR <= (!PRE && !SOF) || (TIMER > `PRMB_TIMEOUT);
             end
          `MAC_Dest:
             begin
                UPD_FRAM_STATS <= 0;
                STORE_MAC <= 0;
                RXVALDAT <= 0;
                ERR <= (D_STORED && !MATCH && !PROMISC) || (TIMER > (`PRMB_TIMEOUT + 5));
             end
          `MAC_Source:
             begin
                UPD_FRAM_STATS <= 0;
                STORE_MAC <= 1;
                RXVALDAT <= 0;
                ERR <= (TIMER > (`PRMB_TIMEOUT + 8));
             end
          `Store_LEN:
             begin
                UPD_FRAM_STATS <= 0;
                STORE_MAC <= 0;
                RXVALDAT <= 0;
                ERR <= (DATA > `MAX_BYTE);
             end
          `Payload:
             begin
                UPD_FRAM_STATS <= 0;
                STORE_MAC <= 0;
                RXVALDAT <= !EOP_EVEN && !EOP_ODD_REG && (LEN_COUNT < DATA_LEN);
                ERR <= (TIMER > `PACKET_TIMEOUT);
             end
          `Update_Stats:
             begin
                UPD_FRAM_STATS <= 1;
                STORE_MAC <= 0;
                RXVALDAT <= 0;
                ERR <= 0;
             end
          `Wait_for_Idle:
             begin
                UPD_FRAM_STATS <= 0;
                STORE_MAC <= 0;
                RXVALDAT <= 0;
                ERR <= 0;
             end
          default:
             begin
                UPD_FRAM_STATS <= 0;
                STORE_MAC <= 0;
                RXVALDAT <= 0;
                ERR <= 0;
             end
      endcase
    end
endmodule
