`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"
`endif
// synthesis attribute rom_style of cnfg_mod is distributed

module cnfg_mod(CLK, DV1024CLK, RST, CP_RST, PU_RSTR_MACS, PU_RSTR_DFLT, PU_RSTR_CNFG, HRDW_INI,
                SEL, RCTRL, RCVDATA, BG, FL_HOLD, FROM_FLASH, FL_CNFG_ODV, FL_CNFG_NOW_DONE, FL_ERRS, PREP4SHTDWN,
                MACBUS,
                BR, FRAME_REQ, MAC_REQ, PH2_DONE, HRDW_INI_DONE, VALID_CNUM,
                ETHER_CNFG, EXT_FIFO_CNFG, RESET_CNFG, VME_BGTO, VME_BTO, VME_CNFG, 
                WADDR_TYPE, MWE, CNFG_SND_REQ, TO_FLASH, FL_VALDAT,
                TXCTRL, TXDATA, RDY4SHTDWN);
                
    input CLK;
    input DV1024CLK;
    input RST;
    input CP_RST;
    input PU_RSTR_MACS;
    input PU_RSTR_DFLT;
    input PU_RSTR_CNFG;
    input HRDW_INI;
    input SEL;
    input [2:0] RCTRL;
    input [15:0] RCVDATA;
    input BG;
    input FL_HOLD;
    input [15:0] FROM_FLASH;
    input FL_CNFG_ODV;
    input FL_CNFG_NOW_DONE;
    input [7:0] FL_ERRS;
    input PREP4SHTDWN;
    inout [15:0] MACBUS;
   output BR;
   output FRAME_REQ;
   output MAC_REQ;
   output PH2_DONE;
   output HRDW_INI_DONE;
   output VALID_CNUM;
   output [15:0] ETHER_CNFG;
   output [15:0] EXT_FIFO_CNFG;
   output [15:0] RESET_CNFG;
   output [15:0] VME_BGTO;
   output [15:0] VME_BTO;
   output [31:0] VME_CNFG;
   output [4:0] WADDR_TYPE;
   output MWE;
   output CNFG_SND_REQ;
   output [15:0] TO_FLASH;
   output FL_VALDAT;
   output [4:0] TXCTRL;
   output [15:0] TXDATA;
   output RDY4SHTDWN;


wire [15:0] MACBUS;

wire BR;
reg FRAME_REQ;
reg MAC_REQ;
wire HRDW_INI_DONE;
wire VALID_CNUM;
reg [15:0] ETHER_CNFG;
reg [15:0] EXT_FIFO_CNFG;
reg [15:0] RESET_CNFG;
reg [15:0] VME_BGTO;
reg [15:0] VME_BTO;
reg [31:0] VME_CNFG;
reg [4:0] WADDR_TYPE;
reg MWE;
reg CNFG_SND_REQ;
reg [15:0] TO_FLASH;
reg FL_VALDAT;
reg  [4:0] TXCTRL;
reg [15:0] TXDATA;
wire RDY4SHTDWN;


reg [15:0] MACBUS_IN_REG;
reg [15:0] MACBUS_OUT_REG;

reg [4:0] CFR;
reg [1:0] CAT;
reg [15:0]FL_FR_DATA;
reg FL_CND;
reg FL_CDV;


reg CMPLTD;
reg PUSH_RAW;
reg READ_RAW;
wire RAW_MT;   
wire RAW_FULL;   
wire RAW_AMT;   
wire RAW_AF;   
wire RAW_WTERR;   
wire RAW_RDERR;
wire [11:0] RWD1,RWD2,RWP1,RWP2;
wire [3:0] RAW_CNT;
wire [11:0] DCD_PAR1,DCD_PAR2;
wire [23:0] DCD_DATA;

reg [1:0] F2C_ST;
reg [6:0] AD_CNT;
reg LD_AC;
reg DO_DCD;
reg SHIFT;
reg [23:0] PARITY;
reg [23:0] DATA;
reg  BT0_DLY;
reg  [2:0] SIXB_PHASE;

reg  ST_CLR;
reg  [3:0] CR_ID;
reg  [31:0] BMASK;
reg  [2:0] SEL_CR;
reg  [3:0] CCP_ST;
reg  [5:0] CNFG_ST;
wire [3:0] C_TXP_ST;
reg  [4:0] CNFG_NUM;
reg  [23:0] SERIAL_NUM;
reg  [1:0] ACNT;
reg  [3:0] MAC_ID;
reg  [47:0] MAC_REG;
reg  [11:0] ECC_MUXH, ECC_MUXL;
reg  [11:0] ECC_MUXH1, ECC_MUXL1;
reg  [47:0] FL_TO_DATA;
wire [11:0] ECC_PARH, ECC_PARL;
reg  [5:0] M_OFFSET;
reg  [5:0] RELADDR;
reg  [15:0] HDR_REG;
reg  [6:0] ST_PG;
reg  [2:0] RND;
reg  [7:0] FL_ERRS_R;
reg  RST_DCD_CNTR;
reg  RA_ENA;
reg  MAC1,MAC2;
reg  LD1_H,LD1_M,LD1_L;
reg  LD2_H,LD2_M,LD2_L;
reg  LD3_H,LD3_M,LD3_L;
reg  LD_H,LD_M,LD_L;
reg  LD_CNFG_NUM_DFLT;
reg  DCD_CNTR_ENA;
reg  [3:0] DCD_CNTR;
reg  LD_MAC_DONE;
reg  S2,S3;
reg  LP;
reg  [47:0] CNFG_DCD_REG;
reg  LD_DCD_A,LD_DCD_B;
reg  RD_RW1; 

reg  HEAD_OUT;

reg  [3:0] SM1_ST;
reg  SH_FL_DATA_MAC;
reg  DV_MAC;
reg  HOLD1;
reg  HOLD2;
reg  HOLD3;
reg  HOLD4;
reg  SHIFT_DONE;

reg  [2:0] SD1_ST;
reg  DV_DFLT;

reg [2:0] SSN1_ST;
reg DV_SER_NUM;

reg  [3:0] SC1_ST;
reg  ENA_CNFG;
reg  RA_ENA_CNFG;
reg  DV_CNFG;

reg  RST_IRQ_UPD;
reg  [7:0]SYSRST_TIMER;
reg  CLR_SYSRST;

reg HRDW_INI_1;
reg [20:0] MAC_INI;
reg  [3:0] MAC_INI_CNT;

reg ACK_NOOP;
reg LOCAL_WRT;
reg TOFLASH_RD;
reg TOFLASH_WRT;

wire VP1,VP2,BTX1,BTX2;    //VP = Valid Parity, BTX = Bad Transmision, CRPTD = Corrupted.

wire LOCAL_RD;
wire TOFLASH_RSTR;
wire READ_DIR;

wire LOCAL;
wire TOFLASH;
wire WRITE_ACK;
wire WRITE_NO_ACK;
wire READ;
wire RESTORE;
wire FL2DCD;


wire TX_SND_DAT;

wire [15:0] HDR1;
wire [15:0] HDR2A;
wire [15:0] HDR2B;
wire [15:0] HDR2C;
wire [15:0] HDR2D;


wire MASK_LD_RCV1;
wire MASK_LD_RCV2;
wire SET_TST_FF;
wire CLR_TST_FF;
wire SET_ECC_ENA;
wire CLR_ECC_ENA;
wire SET_INJ_ERR;
wire CLR_INJ_ERR;
wire SET_WARNSHD;
wire CLR_WARNSHD;
wire SET_STRTPKT;
wire CLR_STRTPKT;

wire     LD_CNFG_NUM;
wire LD_SERIAL_NUM_H;
wire LD_SERIAL_NUM_L;
wire      SET_MAC_ID;
wire       LD_MAC_ID;


wire         MID_ENA;
wire        ACNT_ENA;
wire          MAC_WE;
wire         MID_INC;
wire         MAC_WE2;
wire        SND_DFLT;
wire     SND_SER_NUM;
wire              S1;
wire       SND_CNFGA;
wire       SND_CNFGB;
wire         SND_MAC;
wire        SEND_DIR;
wire       CNFG_IDLE;
wire         RST_SEQ;
wire          RST_LP;
wire          RST_RA;
wire        RST_ACNT;
wire      RST_MAC_ID;


wire         INCR_LP;
wire     SND_MAC_ENA;
wire    SND_CNFG_ENA;
wire    SND_DFLT_ENA;
wire SND_SER_NUM_ENA;
wire      ENA_RD_SEQ;
wire     ENA_WRT_SEQ;
wire      FUNCT_DONE;
wire        PH2_DONE;
wire             CDD;
wire        CONTINUE;

wire        ET_FL_LD;
wire        EF_FL_LD;
wire       RST_FL_LD;
wire       VME_FL_LD;
wire       BTO_FL_LD;
wire      BGTO_FL_LD;
wire          LD_CR1;
wire          LD_CR2;
wire        LD_CR_ID;
wire      LOAD_MASK1;
wire      LOAD_MASK2;
wire    SET_CLR_BITS;

wire SC_CMD;
wire ET_BSET;
wire ET_BCLR;
wire EF_BSET;
wire EF_BCLR;
wire RST_BSET;
wire RST_BCLR;
wire VME_BSET;
wire VME_BCLR;

wire ET_DIR_LD;
wire EF_DIR_LD;
wire RST_DIR_LD;
wire VME_DIR_LD_H;
wire VME_DIR_LD_L;
wire BTO_DIR_LD;
wire BGTO_DIR_LD;

wire LAST_CR;
wire LAST_MAC;
wire [5:0] BA;
wire ALL_MAC;

wire FILL;
wire BT0;
wire CRPTD;    // CRPTD = Corrupted.
wire BIT_ERR;

wire LD_FIRST;
wire LD_LAST;
wire LD_DCD_DONE;
wire VLD_OUT;
wire LONG_REG;

wire SEL_CR_RST;
wire RND_RST;
wire RA_RST;
wire LP_RST;
wire FSM_RST;
wire ACNT_RST;
wire DCD_CNTR_RST;
wire ERR_RST;

wire LD_HDR1;
wire LD_HDR2A;
wire HEAD_OUT_MAC;
wire SM1_SD1;
wire LD_FL_DATA_MAC;
wire SND_MAC_DONE;

wire DFLT;
wire LD_HDR2B;
wire HEAD_OUT_DFLT;
wire LD_FL_DATA_DFLT;
wire SH_FL_DATA_DFLT;
wire RA_ENA_DFLT;
wire SND_DFLT_DONE;

wire SER_NUM;
wire LD_HDR2D;
wire HEAD_OUT_SER_NUM;
wire LD_FL_DATA_SER_NUM;
wire SH_FL_DATA_SER_NUM;
wire RA_ENA_SER_NUM;
wire SND_SER_NUM_DONE;

wire RST_RND;
wire SC1_LD_HDR1;
wire LD_HDR2C;
wire HEAD_OUT_CNFG;
wire SC1_SD1;
wire INC_RND;
wire LD_FL_DATA_CNFG;
wire SH_FL_DATA_CNFG;
wire SND_CNFG_DONE;

// I/O Signals
assign MACBUS = MWE ? MACBUS_OUT_REG : 16'hZZZZ;
assign HRDW_INI_DONE = (MAC_INI_CNT == 4'hE);
assign VALID_CNUM = (CNFG_NUM <= 5'd20);

//**************************************************************************************
reg [7:0] FUNCT;
reg ACK;
reg PRIO;
reg CNFG_DEF;
reg [1:0] CAT_MUX;
reg [2:0] INSTR_MUX;
reg [15:0] DATA_MUX;
reg [2:0]  CTRL;
reg [15:0] RXDATA;
reg [15:0] OUTDATA;
reg [15:0] MAC_HDR_SRL_R;
reg H_BIT;
reg [15:0] SRL_IN_DAT;
reg [1:0]  SRL_IN_BITS;
reg HDR_DN;
reg [7:0] TYPE;
reg [3:0] STATUS;
reg [11:0] ST_TY;
reg [15:0] RCV_ERR_WRD1,RCV_ERR_WRD2;
reg [15:0] ERR_HDR;
reg MSRL2,MSRL3,MSRL4,MAC_DONE;
reg BC1,BUS_CLR;
reg DATA_DONE;
reg RCV_ERR;
reg INTR_ERR,MID_ERR,FATAL_ERR;
reg SEL_ERR_R;
reg SE1,SE2,SE3;
reg DATA_FLAG;
reg TXP_DATA_R;
reg STAT_R;
reg SND_PKT_R;
reg GET_FRAME_R;
reg CNFG_ERR;
reg CNFG_WRN;
reg NO_MAC;

wire [15:0] MAC_HDR_SRL;
wire [1:0]  MHBITS_SRL;
wire SRL_CE;
wire RD_SRL;
wire MBIT;
wire HBIT;
wire RST_INTR_ERR;
wire CLR_INTR_ERR;
wire RCV_ERR1,RCV_ERR2;
wire CVD;
wire OPCODE;
wire EOP;
wire GET_FUNCT;
wire GET_MAC;
wire GET_FRAME;
wire LD_CFR;
wire TXP_INI_STAT;
wire TXP_MID_STAT;
wire TXP_INC_STAT;
wire TXP_FIN_STAT;
wire TXP_DATA;
wire STAT;
wire TXP_SND_PKT;
wire DONE;
wire MSRL1;
wire FLUSH;
wire S_DATA, S_ACK, S_ERR, S_WARN, S_ERWRN;
wire ERR;
wire SEL_ERR;
wire SE0;
wire HND_SHK;
wire MOMENTARY_ERR_CNDT;
wire FATAL_ERR_CNDT;
wire WARN;
wire FL_ERR;
wire START_TXP;
wire CNFG_EXEC; 
wire [1:0] MSG_LVL; 


assign MSG_LVL = RESET_CNFG[9:8];
assign MOMENTARY_ERR_CNDT = 0;
assign FATAL_ERR_CNDT = 0;
assign WARN = CNFG_WRN && (MSG_LVL > 2'h1);
assign FL_ERR = |(FL_ERRS_R);
assign S_ERWRN = S_ERR || S_WARN;
assign ERR = (RCV_ERR || FL_ERR || MID_ERR || FATAL_ERR || CNFG_ERR) && (MSG_LVL > 2'h0);
assign SEL_ERR = (C_TXP_ST == `TxP_Data) && (S_ERR || S_WARN);
assign SE0 = SEL_ERR && !SEL_ERR_R;

assign CVD        = (CTRL == `Rx_Data);
assign OPCODE     = (CTRL == `Rx_OpCode);
assign EOP        = (CTRL == `Rx_EOP);
assign MBIT       = (CTRL == `Rx_MAC);
assign HBIT       = (CTRL == `Rx_HDR);
assign RCV_ERR1   = (CTRL == `Rx_ErrWrd1);
assign RCV_ERR2   = (CTRL == `Rx_ErrWrd2);
assign IDLE         = (CCP_ST  == `CCP_Idle);
assign GET_FUNCT    = (CCP_ST  == `CCP_Get_Funct);
assign GET_MAC      = (CCP_ST  == `CCP_Get_MAC);
assign LD_CFR       = (CCP_ST  == `CCP_Ld_CFR);
assign GET_FRAME    = (CCP_ST  == `CCP_Get_Frame);
assign CNFG_EXEC    = (CCP_ST  == `CCP_Exec);
assign S_DATA       = (CCP_ST  == `CCP_Send_Data);
assign S_ACK        = (CCP_ST  == `CCP_Send_Ack);
assign S_ERR        = (CCP_ST  == `CCP_Send_Err) && ERR;
assign S_WARN       = (CCP_ST  == `CCP_Send_Err) && WARN;
assign ABORT        = (CCP_ST  == `CCP_Abort);
assign CLR_CFR      = (CCP_ST  == `CCP_Clr_CFR);
assign RDY4SHTDWN   = (CCP_ST  == `CCP_Rdy4Shtdwn);

assign MSRL1        = (C_TXP_ST == `TxP_MAC);
assign TXP_INI_STAT = (C_TXP_ST == `TxP_Ini_Stat);
assign TXP_MID_STAT = (C_TXP_ST == `TxP_Mid_Stat);
assign TXP_INC_STAT = (C_TXP_ST == `TxP_Inc_Stat);
assign TXP_FIN_STAT = (C_TXP_ST == `TxP_Fin_Stat);
assign TXP_SND_PKT  = (C_TXP_ST == `TxP_Send_Pkt);
assign TXP_DATA     = (C_TXP_ST == `TxP_Data);
assign FLUSH        = (C_TXP_ST == `TxP_Flush);
assign DONE         = (C_TXP_ST == `TxP_Done);
assign CLR_INTR_ERR = (C_TXP_ST == `TxP_Clr_Intr);

assign START_TXP = S_DATA || S_ACK || S_ERR || S_WARN;
assign HND_SHK = !START_TXP;
assign STAT = TXP_INI_STAT || TXP_MID_STAT || TXP_INC_STAT || TXP_FIN_STAT;
assign RD_SRL = MSRL1; 
assign SRL_CE = MBIT || HBIT || RD_SRL; 
assign RST_INTR_ERR = CLR_INTR_ERR || RST;

//***********************************************************************************************
assign LOCAL_RD     = (CFR==`Read_CRs);
assign TOFLASH_RSTR = (CFR==`Rstr_Cnfg_Num);
assign READ_DIR     = (CFR==`Read_Cnfg_Num_Dir) || (CFR==`Read_MACs_Dir);

assign LOCAL        = LOCAL_RD || LOCAL_WRT;
assign TOFLASH      = TOFLASH_RD || TOFLASH_WRT || TOFLASH_RSTR;
assign WRITE_ACK    =  ACK && (LOCAL_WRT || TOFLASH_WRT);
assign WRITE_NO_ACK = !ACK && (LOCAL_WRT || TOFLASH_WRT);
assign READ         = LOCAL_RD || TOFLASH_RD;
assign RESTORE      = TOFLASH_RSTR || PU_RSTR_MACS || PU_RSTR_DFLT || PU_RSTR_CNFG;
assign FL2DCD       = (TOFLASH_RD || RESTORE) && !READ_DIR;


assign TX_SND_DAT = ENA_RD_SEQ || SND_DFLT || SND_SER_NUM || SND_CNFGA || SND_CNFGB || SND_MAC;

assign HDR1   = 16'h0001; 
assign HDR2A  = ALL_MAC ? {TOFLASH_WRT,7'h00,FL2DCD,7'h3C} : {TOFLASH_WRT,7'h00,FL2DCD,7'h0C};
assign HDR2B  = {TOFLASH_WRT,7'h00,FL2DCD,7'h04};
assign HDR2C  = {TOFLASH_WRT,ST_PG,FL2DCD,7'h1E};
assign HDR2D  = {TOFLASH_WRT,7'h7F,FL2DCD,7'h06};

assign MASK_LD_RCV1 = LOAD_MASK1 && (CFR==`Set_Clr_CRs);
assign MASK_LD_RCV2 = LOAD_MASK2 && (CFR==`Set_Clr_CRs);
assign SET_TST_FF  = LOAD_MASK1 && (CFR==`Set_FF_Test);
assign CLR_TST_FF  = LOAD_MASK1 && (CFR==`Set_FF_VME);
assign SET_ECC_ENA = LOAD_MASK1 && (CFR==`ECC_enable);
assign CLR_ECC_ENA = LOAD_MASK1 && (CFR==`ECC_disable);
assign SET_INJ_ERR = LOAD_MASK1 && (CFR==`Set_Inj_Err);
assign CLR_INJ_ERR = LOAD_MASK1 && (CFR==`Rst_Inj_Err);
assign SET_WARNSHD = LOAD_MASK1 && (CFR==`Warn_On_Shdwn);
assign CLR_WARNSHD = LOAD_MASK1 && (CFR==`No_Warn_On_Shdwn);
assign SET_STRTPKT = LOAD_MASK1 && (CFR==`Snd_Startup_Pkt);
assign CLR_STRTPKT = LOAD_MASK1 && (CFR==`No_Startup_Pkt);

assign     LD_CNFG_NUM = (CNFG_ST == `Get_Cnfg_Num);
assign LD_SERIAL_NUM_H = (CNFG_ST == `Get_Ser_Num_H);
assign LD_SERIAL_NUM_L = (CNFG_ST == `Get_Ser_Num_L);
assign      SET_MAC_ID = (CNFG_ST == `Set_MAC_ID);
assign       LD_MAC_ID = (CNFG_ST == `Get_MAC_ID);

assign         MID_ENA = (CNFG_ST == `Wrt_MAC_Seq);
assign        ACNT_ENA = (CNFG_ST == `Wrt_MAC_Seq) || (CNFG_ST == `Get_MAC_Seq) || (CNFG_ST == `Wrt_MAC_Seq2) || (CNFG_ST == `Send_MAC);
assign          MAC_WE = (CNFG_ST == `Wrt_MAC_Seq);
assign         MID_INC = (CNFG_ST == `Incr_MAC_ID) || (CNFG_ST == `Incr_MAC_ID2);
assign         MAC_WE2 = (CNFG_ST == `Wrt_MAC_Seq2);
assign        SND_DFLT = (CNFG_ST == `Send_Dflt);
assign     SND_SER_NUM = (CNFG_ST == `Send_SerNum);
assign              S1 = (CNFG_ST == `Send_SerNum) || (CNFG_ST == `Send_CnfgA);
assign       SND_CNFGA = (CNFG_ST == `Send_CnfgA);
assign       SND_CNFGB = (CNFG_ST == `Send_CnfgB);
assign         SND_MAC = (CNFG_ST == `Send_MAC);
assign        SEND_DIR = (CNFG_ST == `Send_Dir);
assign       CNFG_IDLE = (CNFG_ST == `Cnfg_Idle);
assign         RST_SEQ = (CNFG_ST == `Cnfg_Idle) || (CNFG_ST == `W4Exec);
assign          RST_LP = (CNFG_ST == `Cnfg_Idle) || (CNFG_ST == `W4Exec);
assign          RST_RA = (CNFG_ST == `Cnfg_Idle) || (CNFG_ST == `W4Exec);
assign        RST_ACNT = (CNFG_ST == `Cnfg_Idle) || (CNFG_ST == `W4Exec) || (CNFG_ST == `Rcv_From_FL);
assign      RST_MAC_ID = (CNFG_ST == `Cnfg_Idle) || (CNFG_ST == `W4Exec) || (CNFG_ST == `Rcv_From_FL);

assign         INCR_LP = (CNFG_ST == `Incr_Lp);
assign     SND_MAC_ENA = (CNFG_ST == `Snd_MAC_Seq);
assign    SND_CNFG_ENA = (CNFG_ST == `Snd_Cnfg_Seq);
assign    SND_DFLT_ENA = (CNFG_ST == `Snd_Dflt_Seq);
assign SND_SER_NUM_ENA = (CNFG_ST == `Snd_SerNum_Seq);
assign      ENA_RD_SEQ = (CNFG_ST == `Ena_Rd_Seq);
assign      FUNCT_DONE = (CNFG_ST == `Funct_Done) || (CNFG_ST == `PH1Done);
assign        PH2_DONE = (CNFG_ST == `PH2_Done);
assign             CDD = (CNFG_ST == `Cnfg_Data_Done);
assign        CONTINUE = S_DATA || S_ACK || (CCP_ST == `CCP_W4Data);
assign        ET_FL_LD = !LP && (CNFG_ST == `Load_CRsA);
assign        EF_FL_LD = !LP && (CNFG_ST == `Load_CRsA);
assign       RST_FL_LD = !LP && (CNFG_ST == `Load_CRsA);
assign       VME_FL_LD =  LP && (CNFG_ST == `Load_CRsA);
assign       BTO_FL_LD =  LP && (CNFG_ST == `Load_CRsA);
assign      BGTO_FL_LD =        (CNFG_ST == `Load_CRsB);
assign     ENA_WRT_SEQ = CVD && (CNFG_ST == `W4ValDat_All);
assign          LD_CR1 = CVD && (CNFG_ST == `W4ValDat_Wrt);
assign          LD_CR2 = CVD && (CNFG_ST == `Wrt_VME_L);
assign        LD_CR_ID = CVD && ((CNFG_ST == `W4ValDat_SC) || (CNFG_ST == `W4ValDat_CR));
assign      LOAD_MASK1 =        (CNFG_ST == `Mask_LD1);
assign      LOAD_MASK2 =        (CNFG_ST == `Mask_LD2);
assign    SET_CLR_BITS =        (CNFG_ST == `Set_Clr_Bits);



assign SC_CMD     = (CFR==`Set_FF_Test) || (CFR==`Set_FF_VME) ||
                    (CFR==`ECC_enable) || (CFR==`ECC_disable) ||
                    (CFR==`Set_Inj_Err) || (CFR==`Rst_Inj_Err) ||
                    (CFR==`Warn_On_Shdwn) || (CFR==`No_Warn_On_Shdwn) ||
                    (CFR==`Snd_Startup_Pkt) || (CFR==`No_Startup_Pkt);

assign ET_BSET    = SET_CLR_BITS && (ST_CLR==1) && (CR_ID==`Eth_CR) && (CFR==`Set_Clr_CRs);
assign ET_BCLR    = SET_CLR_BITS && (ST_CLR==0) && (CR_ID==`Eth_CR) && (CFR==`Set_Clr_CRs);
assign EF_BSET    = SET_CLR_BITS && ((CFR==`Set_FF_Test) || (CFR==`ECC_enable) || (CFR==`Set_Inj_Err) || ((ST_CLR==1) && (CR_ID==`Ext_FF_CR) && (CFR==`Set_Clr_CRs)));
assign EF_BCLR    = SET_CLR_BITS && ((CFR==`Set_FF_VME) || (CFR==`ECC_disable) || (CFR==`Rst_Inj_Err) || ((ST_CLR==0) && (CR_ID==`Ext_FF_CR) && (CFR==`Set_Clr_CRs)));
assign RST_BSET    = SET_CLR_BITS && ((CFR==`Warn_On_Shdwn) || (CFR==`Snd_Startup_Pkt) || ((ST_CLR==1) && (CR_ID==`Rst_Ena_CR) && (CFR==`Set_Clr_CRs)));
assign RST_BCLR    = SET_CLR_BITS && ((CFR==`No_Warn_On_Shdwn) || (CFR==`No_Startup_Pkt) || ((ST_CLR==0) && (CR_ID==`Rst_Ena_CR) && (CFR==`Set_Clr_CRs)));
assign VME_BSET    = SET_CLR_BITS && (ST_CLR==1) && (CR_ID==`VME_CR) && (CFR==`Set_Clr_CRs);
assign VME_BCLR    = SET_CLR_BITS && (ST_CLR==0) && (CR_ID==`VME_CR) && (CFR==`Set_Clr_CRs);

assign ET_DIR_LD    = (LD_CR1 && (CFR==`Wrt_Eth_CR))  || (LD_CR1 && (CR_ID==`Eth_CR)     && (CFR==`Wrt_CR_ID)) || (ENA_WRT_SEQ && (SEL_CR == `Sel_Eth_CR));
assign EF_DIR_LD    = (LD_CR1 && (CFR==`Wrt_Ext_CR))  || (LD_CR1 && (CR_ID==`Ext_FF_CR)  && (CFR==`Wrt_CR_ID)) || (ENA_WRT_SEQ && (SEL_CR == `Sel_Ext_CR));
assign RST_DIR_LD   = (LD_CR1 && (CFR==`Wrt_Rst_CR))  || (LD_CR1 && (CR_ID==`Rst_Ena_CR) && (CFR==`Wrt_CR_ID)) || (ENA_WRT_SEQ && (SEL_CR == `Sel_Rst_CR));
assign VME_DIR_LD_H = (LD_CR1 && (CFR==`Wrt_VME_CR))  || (LD_CR1 && (CR_ID==`VME_CR)     && (CFR==`Wrt_CR_ID)) || (ENA_WRT_SEQ && (SEL_CR == `Sel_VMEh_CR));
assign VME_DIR_LD_L = (LD_CR2 && (CFR==`Wrt_VME_CR))  || (LD_CR2 && (CR_ID==`VME_CR)     && (CFR==`Wrt_CR_ID)) || (ENA_WRT_SEQ && (SEL_CR == `Sel_VMEl_CR));
assign BTO_DIR_LD   = (LD_CR1 && (CFR==`Wrt_BTO_CR))  || (LD_CR1 && (CR_ID==`BTO_CR)     && (CFR==`Wrt_CR_ID)) || (ENA_WRT_SEQ && (SEL_CR == `Sel_BTO_CR));
assign BGTO_DIR_LD  = (LD_CR1 && (CFR==`Wrt_BGTO_CR)) || (LD_CR1 && (CR_ID==`BGTO_CR)    && (CFR==`Wrt_CR_ID)) || (ENA_WRT_SEQ && (SEL_CR == `Sel_BGTO_CR));

assign LAST_CR  = (SEL_CR == 3'd6);
assign LAST_MAC = ((MAC_ID < 4'h8) && (ACNT == 2'd2)) || ({MAC_ID,ACNT} == 6'b110010);
assign BA = M_OFFSET + RELADDR;
assign ALL_MAC = MAC_ID[3];

assign FILL = FL_CDV && (FL_FR_DATA[13:8] == 6'd63);  // Address is last byte in page
assign BT0 = (SIXB_PHASE == 3'd0);
assign CRPTD = (!VP1 || !VP2) && VLD_OUT;   
assign BIT_ERR = (VP1 && VP2) && (BTX1 || BTX2) && VLD_OUT;   


assign LD_FIRST = (DCD_CNTR == 4'd5);
assign LD_LAST = (DCD_CNTR == 4'd6);
assign LD_DCD_DONE = (DCD_CNTR == 4'd6);
assign VLD_OUT = (DCD_CNTR == 4'd5) || (DCD_CNTR == 4'd6);
assign LONG_REG = (CFR==`Wrt_VME_CR) || ((CR_ID==`VME_CR) && ((CFR==`Set_Clr_CRs) || (CFR==`Wrt_CR_ID)));

assign SEL_CR_RST = RST_SEQ || RST;
assign RND_RST = RST_RND || RST;
assign RA_RST = RST_RA || RST;
assign LP_RST = RST_LP || RST;
assign FSM_RST = ABORT || RST;
assign ACNT_RST = RST_ACNT || RST;
assign DCD_CNTR_RST = RST_DCD_CNTR || RST;
assign ERR_RST = CLR_CFR || RST;

assign         LD_HDR1 = (SM1_ST == `SM1_Hdr1);
assign        LD_HDR2A = (SM1_ST == `SM1_Hdr2a);
assign    HEAD_OUT_MAC = (SM1_ST == `SM1_Hdr1) || (SM1_ST == `SM1_Hdr2a);
assign         SM1_SD1 = (SM1_ST == `SM1_MC2_ShiftA) || (SM1_ST == `SM1_Shift);
assign  LD_FL_DATA_MAC = (SM1_ST == `SM1_MC1_Load) || (SM1_ST == `SM1_MC2_Load);
assign    SND_MAC_DONE = (SM1_ST == `SM1_Done);

assign            DFLT = (SD1_ST == `SD1_Hdr1);
assign        LD_HDR2B = (SD1_ST == `SD1_Hdr2b);
assign   HEAD_OUT_DFLT = (SD1_ST == `SD1_Hdr1) || (SD1_ST == `SD1_Hdr2b);
assign LD_FL_DATA_DFLT = (SD1_ST == `SD1_Dflt_Load);
assign SH_FL_DATA_DFLT = (SD1_ST == `SD1_Dflt_Shift);
assign     RA_ENA_DFLT = (SD1_ST == `SD1_Dflt_Shift) || (SD1_ST == `SD1_Pipe);
assign   SND_DFLT_DONE = (SD1_ST == `SD1_Done);

assign            SER_NUM = (SSN1_ST == `SSN1_Hdr1);
assign           LD_HDR2D = (SSN1_ST == `SSN1_Hdr2d);
assign   HEAD_OUT_SER_NUM = (SSN1_ST == `SSN1_Hdr1) || (SSN1_ST == `SSN1_Hdr2d);
assign LD_FL_DATA_SER_NUM = (SSN1_ST == `SSN1_SerNum_Load);
assign SH_FL_DATA_SER_NUM = (SSN1_ST == `SSN1_Shift);
assign     RA_ENA_SER_NUM = (SSN1_ST == `SSN1_Shift) || (SSN1_ST == `SSN1_Pipe);
assign   SND_SER_NUM_DONE = (SSN1_ST == `SSN1_Done);

assign         RST_RND =          (SC1_ST == `SC1_Idle);
assign     SC1_LD_HDR1 =          (SC1_ST == `SC1_Hdr1);
assign        LD_HDR2C =          (SC1_ST == `SC1_Hdr2c);
assign   HEAD_OUT_CNFG =          (SC1_ST == `SC1_Hdr1) || (SC1_ST == `SC1_Hdr2c);
assign         SC1_SD1 =          (SC1_ST == `SC1_Cnfg_ShiftB) || (SC1_ST == `SC1_Cnfg_ShiftC);
assign         INC_RND = HOLD3 && (SC1_ST == `SC1_Cnfg_ShiftA);
assign LD_FL_DATA_CNFG =          (SC1_ST == `SC1_Cnfg_LoadA) || (SC1_ST == `SC1_Cnfg_LoadB);
assign SH_FL_DATA_CNFG =          (SC1_ST == `SC1_Cnfg_ShiftA) || (SC1_ST == `SC1_Cnfg_ShiftB) || (SC1_ST == `SC1_Cnfg_ShiftC);
assign   SND_CNFG_DONE =          (SC1_ST == `SC1_Done);


/////////////////////////////
// Command Processing      //
/////////////////////////////

always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         FUNCT <= 8'h00;
         ACK   <= 0;
         PRIO  <= 0;
      end
   else
      if(SEL && (RCTRL == `Rx_OpCode) && GET_FUNCT) // this is RCTRL not CTRL
         begin
            FUNCT <= RCVDATA[7:0];
            ACK   <= RCVDATA[13];
            PRIO  <= RCVDATA[14];
         end
      else
         begin
            FUNCT <= FUNCT;
            ACK   <= ACK;
            PRIO  <= PRIO;
         end
end
always @(FUNCT)
begin
   casex(FUNCT)
      8'h0X,8'h1X:
         CNFG_DEF <= 1;
      default:
         CNFG_DEF <= 0;
   endcase
end
always @(posedge CLK)
begin
   RXDATA <= RCVDATA;
   CTRL <= RCTRL;
   HDR_DN <= HBIT;
   ST_TY <= {STATUS,TYPE};
   H_BIT <= MHBITS_SRL[0];
   MSRL2 <= MSRL1;
   MSRL3 <= MSRL2;
   MSRL4 <= MSRL3;
   MAC_DONE <= MSRL4;
   MAC_HDR_SRL_R <= MAC_HDR_SRL;
   GET_FRAME_R <= GET_FRAME;
   TXP_DATA_R <= DATA_FLAG;
   BC1 <= FLUSH;
   BUS_CLR <= BC1;
   SEL_ERR_R <= SEL_ERR;
   SE1 <= SE0;
   SE2 <= SE1;
   SE3 <= SE2;
   STAT_R <= STAT;
   SND_PKT_R <= TXP_SND_PKT;
end


always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      begin
         RCV_ERR_WRD1 <= 16'h0000;
         RCV_ERR_WRD2 <= 16'h0000;
         RCV_ERR <= 0;
      end
   else
      if(RCV_ERR1 && CNFG_DEF)
         begin
            RCV_ERR_WRD1 <= RXDATA;
            RCV_ERR_WRD2 <= RCV_ERR_WRD2;
            RCV_ERR <= 1;
         end
      else if(RCV_ERR2 && CNFG_DEF)
         begin
            RCV_ERR_WRD1 <= RCV_ERR_WRD1;
            RCV_ERR_WRD2 <= RXDATA;
            RCV_ERR <= 1;
         end
      else
         begin
            RCV_ERR_WRD1 <= RCV_ERR_WRD1;
            RCV_ERR_WRD2 <= RCV_ERR_WRD2;
            RCV_ERR <= RCV_ERR;
         end
end
always @(RCV_ERR or CNFG_DEF or FL_ERR or CNFG_ERR or CNFG_WRN)
begin
   if(RCV_ERR)
      ERR_HDR <= {`Config_mod,`HDR_Error,`ER_Rcv_Err};
   else if(!CNFG_DEF)
      ERR_HDR <= {`Config_mod,`HDR_Error,`CP_Not_Def};
   else if(FL_ERR)
      case(FL_ERRS_R)
         8'h01:
            ERR_HDR <= {`Config_mod,`HDR_Error,`FL_In_WtErr};
         8'h02:
            ERR_HDR <= {`Config_mod,`HDR_Error,`FL_In_RdErr};
         8'h04:
            ERR_HDR <= {`Config_mod,`HDR_Error,`FL_TRDS_WtErr};
         8'h08:
            ERR_HDR <= {`Config_mod,`HDR_Error,`FL_TRDS_RdErr};
         8'h10:
            ERR_HDR <= {`Config_mod,`HDR_Error,`FL_PgRd_WtErr};
         8'h20:
            ERR_HDR <= {`Config_mod,`HDR_Error,`FL_PgRd_RdErr};
         8'h40:
            ERR_HDR <= {`Config_mod,`HDR_Error,`FL_ADFF_WtErr};
         8'h80:
            ERR_HDR <= {`Config_mod,`HDR_Error,`FL_ADFF_RdErr};
         default:
            ERR_HDR <= {`Config_mod,`HDR_Error,`CF_Mltp_Flsh};
      endcase
   else if(CNFG_ERR)
      ERR_HDR <= {`Config_mod,`HDR_Error,`CF_Crptd_Dat};
   else if(CNFG_WRN)
      ERR_HDR <= {`Config_mod,`HDR_Warn,`CF_Bit_Errs};
   else
      ERR_HDR <= {`Config_mod,`HDR_Info,`G_No_Info};
end
always @(posedge CLK or posedge RST_INTR_ERR)
begin
   if(RST_INTR_ERR)
      INTR_ERR <= 0;
   else
      if(MOMENTARY_ERR_CNDT)
         INTR_ERR <= 1;
      else
         INTR_ERR <= INTR_ERR;
end
always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      MID_ERR <= 0;
   else
      if(INTR_ERR)
         MID_ERR <= 1;
      else
         MID_ERR <= MID_ERR;
end
always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      FATAL_ERR <= 0;
   else
      if(FATAL_ERR_CNDT)
         FATAL_ERR <= 1;
      else
         FATAL_ERR <= FATAL_ERR;
end
always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      FL_ERRS_R    <= 8'h00;
   else
      begin
         FL_ERRS_R[0]  <= FL_ERRS[0] ? 1 : FL_ERRS_R[0];
         FL_ERRS_R[1]  <= FL_ERRS[1] ? 1 : FL_ERRS_R[1];
         FL_ERRS_R[2]  <= FL_ERRS[2] ? 1 : FL_ERRS_R[2];
         FL_ERRS_R[3]  <= FL_ERRS[3] ? 1 : FL_ERRS_R[3];
         FL_ERRS_R[4]  <= FL_ERRS[4] ? 1 : FL_ERRS_R[4];
         FL_ERRS_R[5]  <= FL_ERRS[5] ? 1 : FL_ERRS_R[5];
         FL_ERRS_R[6]  <= FL_ERRS[6] ? 1 : FL_ERRS_R[6];
         FL_ERRS_R[7]  <= FL_ERRS[7] ? 1 : FL_ERRS_R[7];
      end
end
always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      begin
         CNFG_ERR <= 0;
         CNFG_WRN <= 0;
         NO_MAC   <= 0;
      end
   else
      begin
         CNFG_ERR <= (CRPTD) ? 1 : CNFG_ERR;
         CNFG_WRN <= (BIT_ERR) ? 1 : CNFG_WRN;
         NO_MAC   <= (IDLE && (CRPTD || BIT_ERR)) ? 1 : NO_MAC;
      end
end

always @(RXDATA or MBIT or HBIT or MAC_HDR_SRL or MHBITS_SRL)
begin  // mux for SRL input
   if(MBIT || HBIT)
      begin
         SRL_IN_DAT <= RXDATA;
         SRL_IN_BITS <= {MBIT,HBIT};
      end
   else
      begin
         SRL_IN_DAT <= MAC_HDR_SRL;
         SRL_IN_BITS <= MHBITS_SRL;
      end
end

macsrl  mh_srl(.clk(CLK),.ce(SRL_CE),.mhin(SRL_IN_BITS),.din(SRL_IN_DAT),.mhout(MHBITS_SRL),.dout(MAC_HDR_SRL));


////////////////////////////////////////////////////////////////////
//                                                                //
// State Machine Command Processing                               //
//                                                                //
////////////////////////////////////////////////////////////////////
always @(posedge CLK or posedge CP_RST)
begin: CCP_FSM
   if(CP_RST)
      CCP_ST <= `CCP_Idle;
   else
      case(CCP_ST)
         `CCP_Idle:
            if(ERR || WARN)
               CCP_ST <= `CCP_Send_Err;
            else if(SEL)
               CCP_ST <= `CCP_Get_Funct;
            else if(PREP4SHTDWN)
               CCP_ST <= `CCP_Rdy4Shtdwn;
            else
               CCP_ST <= `CCP_Idle;
         `CCP_Get_Funct:
            if(OPCODE)
               CCP_ST <= `CCP_Get_MAC;
            else
               CCP_ST <= `CCP_Get_Funct;
         `CCP_Get_MAC:
            if(HDR_DN)
               CCP_ST <= `CCP_Cnfg_Rdy;
            else
               CCP_ST <= `CCP_Get_MAC;
         `CCP_Cnfg_Rdy:
            if(CNFG_IDLE)
               CCP_ST <= `CCP_Ld_CFR;
            else
               CCP_ST <= `CCP_Cnfg_Rdy;
         `CCP_Ld_CFR:
            CCP_ST <= `CCP_Get_Frame;
         `CCP_Get_Frame:
            if(ERR)
               CCP_ST <= `CCP_Abort;
            else
               if(EOP)
                  if(TOFLASH)
                     CCP_ST <= `CCP_Exec;
                  else if(LOCAL)
                     CCP_ST <= `CCP_W4FD;
                  else if(ACK_NOOP)
                     CCP_ST <= `CCP_Send_Ack;
                  else
                     CCP_ST <= `CCP_Idle;
               else
                  CCP_ST <= `CCP_Get_Frame;
         `CCP_Exec:
            if(CNFG_SND_REQ)
               CCP_ST <= `CCP_W4FD;
            else
               CCP_ST <= `CCP_Exec;
         `CCP_W4FD:
            if(FUNCT_DONE)
               if(TOFLASH_RSTR)
                  CCP_ST <= `CCP_W4Data;
               else if(READ)
                  CCP_ST <= `CCP_Send_Data;
               else if(WRITE_ACK)
                  CCP_ST <= `CCP_Send_Ack;
               else
                  CCP_ST <= `CCP_Clr_CFR;
            else
               CCP_ST <= `CCP_W4FD;
         `CCP_Send_Data:
            if(DONE)
               if(ERR)
                  CCP_ST <= `CCP_Rel_Snd;
               else
                  CCP_ST <= `CCP_Clr_CFR;
            else
               CCP_ST <= `CCP_Send_Data;
         `CCP_Send_Ack:
            if(DONE)
               if(ERR)
                  CCP_ST <= `CCP_Rel_Snd;
               else
                  CCP_ST <= `CCP_Clr_CFR;
            else
               CCP_ST <= `CCP_Send_Ack;
         `CCP_W4Data:
            if(PH2_DONE)
               if(ACK)
                  CCP_ST <= `CCP_Send_Ack;
               else
                  CCP_ST <= `CCP_Clr_CFR;
            else
               CCP_ST <= `CCP_W4Data;
         `CCP_Rel_Snd:
            if(!DONE)
               CCP_ST <= `CCP_Send_Err;
            else
               CCP_ST <= `CCP_Rel_Snd;
         `CCP_Abort:
            if(EOP)
               CCP_ST <= `CCP_Send_Err;
            else
               CCP_ST <= `CCP_Abort;
         `CCP_Send_Err:
            if(DONE)
               CCP_ST <= `CCP_Clr_CFR;
            else
               CCP_ST <= `CCP_Send_Err;
         `CCP_Clr_CFR:
            CCP_ST <= `CCP_Idle;
         `CCP_Rdy4Shtdwn:
            CCP_ST <= `CCP_Rdy4Shtdwn;
         default:
            CCP_ST <= `CCP_Idle;
      endcase
end



/////////////////////////////////////////
// Transmit Processor State Machine    //
/////////////////////////////////////////

trans_proc CNFG_Txp_FSM(.clk(CLK), .rst(RST), .start(START_TXP), .bg(BG), .mac_done(MAC_DONE),
           .intr_err(INTR_ERR), .fatal_err(FATAL_ERR), .s_err(S_ERWRN), .data_done(DATA_DONE),
           .bus_clr(BUS_CLR), .hndshk(HND_SHK), .txp_st(C_TXP_ST), .br(BR));


always @(C_TXP_ST or S_ERR or S_WARN or S_ACK or S_DATA or SEND_DIR or CDD or FL_CDV or TX_SND_DAT or RCV_ERR or SE0 or SE2)
begin
   case(C_TXP_ST)
      `TxP_Data:
         begin
            if(S_DATA)
               begin
                  DATA_DONE <= CDD;
                  if(SEND_DIR)
                     DATA_FLAG <= FL_CDV;
                  else
                     DATA_FLAG <= TX_SND_DAT;
               end
            else if(S_ACK)
               begin
                  DATA_DONE <= 1;
                  DATA_FLAG <= 0;
               end
            else if(S_ERR || S_WARN)
               begin
                  DATA_DONE <= RCV_ERR ? SE2 : SE0;
                  DATA_FLAG <= 1;
               end
            else
               begin
                  DATA_DONE <= 0;
                  DATA_FLAG <= 0;
               end
         end
      default:
         begin
            DATA_DONE <= 0;
            DATA_FLAG <= 0;
         end
   endcase
end

always @(S_ERR or S_WARN or S_ACK)
begin
   if (S_ACK) //Acknowledge packets with no data
      TYPE <= `Rtn_NoDat_Pkt;
   else if(S_ERR)
      TYPE <= `Rtn_Err_Pkt;
   else if(S_WARN)
      TYPE <= `Rtn_Warn_Pkt;
   else
      TYPE <= `Rtn_CNFG_Pkt; // Default Config module return type;
end


always @(TXP_INI_STAT or TXP_MID_STAT or TXP_INC_STAT or TXP_FIN_STAT or ERR or WARN or S_ACK or S_DATA)
begin
   if(TXP_INI_STAT)
      STATUS <= `CiP;
   else if (TXP_MID_STAT)
      if(ERR)
         STATUS <= `CiP_E;
      else if(WARN)
         STATUS <= `CiP_W;
      else
         STATUS <= `CiP;
   else if (TXP_INC_STAT)
      STATUS <= `CE_I;
   else if (TXP_FIN_STAT)
      if(ERR && (S_ACK || S_DATA))
         STATUS <= `CC_E;
      else if(WARN && (S_ACK || S_DATA))
         STATUS <= `CC_W;
      else if(S_ACK || S_DATA)
         STATUS <= `CC_S;
      else
         STATUS <= `No_Ack;
   else
      STATUS <= `No_Ack;
end


always @(STAT_R or MSRL2 or TXP_DATA_R or NO_MAC or
         ST_TY or MAC_HDR_SRL_R or
         SE1 or SE2 or SE3 or ERR_HDR or
         RCV_ERR or RCV_ERR_WRD1 or RCV_ERR_WRD2 or
         FL_ERR or FL_ERRS_R or OUTDATA)
begin
   if(STAT_R)
      DATA_MUX <= {4'h0,ST_TY};
   else if (MSRL2 && NO_MAC)
      DATA_MUX <= 16'h0000;
   else if (MSRL2)
      DATA_MUX <= MAC_HDR_SRL_R;
   else if (TXP_DATA_R && SE1)
      DATA_MUX <= ERR_HDR;
   else if (TXP_DATA_R && SE2)
      if(RCV_ERR)
         DATA_MUX <= RCV_ERR_WRD1;
      else if (FL_ERR)
         DATA_MUX <= {8'h00,FL_ERRS_R};
      else
         DATA_MUX <= 16'h0000;
   else if (TXP_DATA_R && SE3)
      DATA_MUX <= RCV_ERR ? RCV_ERR_WRD2 : 16'h0000;
   else
      DATA_MUX <= OUTDATA;
end


always @(STAT_R or MSRL2 or MAC_DONE or H_BIT or TXP_DATA_R or SND_PKT_R or NO_MAC)
begin
   if(STAT_R)
      INSTR_MUX <= `Tx_AST;
   else if (MSRL2 && NO_MAC)
      if(MSRL2 && !MAC_DONE)
         INSTR_MUX <= `Tx_NoMAC;
      else
         INSTR_MUX <= `Tx_NoHead;
   else if (MSRL2)
      if(H_BIT)
         INSTR_MUX <= `Tx_Head;
      else
         INSTR_MUX <= `Tx_MAC;
   else if (TXP_DATA_R)
      INSTR_MUX <= `Tx_Data;
   else if (SND_PKT_R)
      INSTR_MUX <= `Tx_Send;
   else
      INSTR_MUX <= `Tx_NoData;
end

always @(S_ERR or S_WARN or PRIO)
begin
   if(S_ERR || S_WARN)
      CAT_MUX <= `Tx_Spont_Cat;
   else if (PRIO)
      CAT_MUX <= `Tx_Prio_Cat;
   else
      CAT_MUX <= `Tx_Norm_Cat;
end

/////////////////////////
// Output Registers    //
/////////////////////////

always @(posedge CLK)
begin
   if(SEL)
      begin
         MAC_REQ   = GET_MAC;
         FRAME_REQ = GET_FRAME;
      end
   else
      begin
         MAC_REQ   = 1'bZ;
         FRAME_REQ = 1'bZ;
      end
end

always @(posedge CLK)
begin
   if(BG)
      begin
         TXDATA  <= DATA_MUX;
         TXCTRL  <= {CAT_MUX,INSTR_MUX};
      end
   else
      begin
         TXDATA  <= 16'hZZZZ;
         TXCTRL  <= 5'hZZ;
      end
end
////////////////////////////////////////////////////////////////////////////////////////////////////////////

always @(CFR)
begin
   case(CFR)
      `Set_FF_Test,`Set_FF_VME,`ECC_enable,`ECC_disable, 
      `Wrt_Eth_CR,`Wrt_Ext_CR,`Wrt_Rst_CR,`Wrt_VME_CR, 
      `Wrt_BTO_CR,`Wrt_BGTO_CR,`Wrt_All_CRs,
      `Set_Clr_CRs,`Set_Inj_Err,`Rst_Inj_Err,
      `Warn_On_Shdwn, `No_Warn_On_Shdwn,
      `Snd_Startup_Pkt, `No_Startup_Pkt,
      `Wrt_CR_ID:
         LOCAL_WRT <= 1;
      default:
         LOCAL_WRT <= 0;
   endcase
end
always @(CFR)
begin
   case(CFR)
      `Read_Cnfg_Num_Dir,`Read_Cnfg_Num_Dcd, 
      `Read_Cnfg_Dflt, 
      `Read_MACs_Dir,`Read_MACs_Dcd, 
      `Rd_Ser_Num:
         TOFLASH_RD <= 1;
      default:
         TOFLASH_RD <= 0;
   endcase
end
always @(CFR)
begin
   case(CFR)
      `Save_Cnfg_Num, 
      `Set_Cnfg_Dflt, 
      `Set_MACs,
      `Wrt_Ser_Num:
         TOFLASH_WRT <= 1;
      default:
         TOFLASH_WRT <= 0;
   endcase
end

// Input registers //
always @(posedge CLK)
begin
   MACBUS_IN_REG <= MACBUS;
   FL_FR_DATA <= FROM_FLASH;
   FL_CND <= FL_CNFG_NOW_DONE;
   FL_CDV <= FL_CNFG_ODV;
end
// Output registers //
always @(posedge CLK)
begin
   HRDW_INI_1 <= HRDW_INI;
   MWE <= MAC_WE || MAC_WE2 || HRDW_INI_1;
   if(HRDW_INI_1)
      WADDR_TYPE <= MAC_INI[20:16];
   else
      WADDR_TYPE <= {MAC_ID[2:0],ACNT};
end
always @(posedge CLK)
begin
   if(RST)
      MACBUS_OUT_REG <= 16'h0000;
   else
      if(MAC_WE)
         MACBUS_OUT_REG <= RXDATA;
      else if(HRDW_INI_1)
         MACBUS_OUT_REG <= MAC_INI[15:0];
      else if(MAC_WE2)
         case(ACNT)
            3'd0:
               MACBUS_OUT_REG <= CNFG_DCD_REG[47:32];
            3'd1:
               MACBUS_OUT_REG <= CNFG_DCD_REG[31:16];
            3'd2:
               MACBUS_OUT_REG <= CNFG_DCD_REG[15:0];
            default:
               MACBUS_OUT_REG <= CNFG_DCD_REG[47:32];
         endcase
      else
         MACBUS_OUT_REG <= 16'h0000;
end


// Configuration Function Register
always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         CFR <= 5'h00;
         ACK_NOOP <= 0;
      end
   else
      if(LD_CFR)
         begin
            CFR <= FUNCT[4:0];
            ACK_NOOP <= ACK && (FUNCT == `Funct_NoOp);
         end
      else if(CLR_CFR)
         begin
            CFR <= 5'h00;
            ACK_NOOP <= 0;
         end
      else
         begin
            CFR <= CFR;
            ACK_NOOP <= ACK_NOOP;
         end
end

// Register for storing Configuration Number
always @(posedge CLK or posedge RST)
begin
   if(RST)
      CNFG_NUM <= 5'hFF;
   else
      if(LD_CNFG_NUM)
         CNFG_NUM <= RXDATA[4:0];
      else if(LD_CNFG_NUM_DFLT)
         CNFG_NUM <= DCD_DATA[4:0];
      else
         CNFG_NUM <= CNFG_NUM;
end
// Register for storing Serial Number
always @(posedge CLK or posedge RST)
begin
   if(RST)
      SERIAL_NUM <= 24'h000000;
   else
      if(LD_SERIAL_NUM_H)
         SERIAL_NUM <= {RXDATA[7:0],SERIAL_NUM[15:0]};
      else if(LD_SERIAL_NUM_L)
         SERIAL_NUM <= {SERIAL_NUM[23:16],RXDATA[15:0]};
      else
         SERIAL_NUM <= SERIAL_NUM;
end


always @(posedge CLK)
begin
   RD_RW1 <= READ_RAW;
   S2 <= S1;
   S3 <= S2;
end

always @(posedge CLK or posedge DCD_CNTR_RST)
begin
   if(DCD_CNTR_RST)
      DCD_CNTR <= 4'd0;
   else
      if(DCD_CNTR_ENA)
         DCD_CNTR <= DCD_CNTR + 1;
      else
         DCD_CNTR <= DCD_CNTR;
end

always @(posedge CLK or posedge LP_RST)
begin
   if(LP_RST)
      LP <= 0;
   else
      if(INCR_LP)
         LP <= LP + 1;
      else
         LP <= LP;
end



////////////////////////////////////////////////////////////////////
//                                                                //
// State Machine for controlling Configuration Register Functions //
//                                                                //
////////////////////////////////////////////////////////////////////
always @(posedge CLK or posedge FSM_RST)
begin: Cnfg_FSM
   if(FSM_RST)
      CNFG_ST <= `Cnfg_Idle;
   else
      case(CNFG_ST)
         `Cnfg_Idle:
            if(PU_RSTR_DFLT || PU_RSTR_CNFG)
               CNFG_ST <= `W4Exec;
            else if(PU_RSTR_MACS)
               CNFG_ST <= `Set_MAC_ID;
            else if(SC_CMD)
               CNFG_ST <= `Mask_LD1;
            else
               case(CFR)
                  `Read_CRs:
                     CNFG_ST <= `PH1Done;
                  `Wrt_CR_ID:
                     CNFG_ST <= `W4ValDat_CR;
                  `Wrt_Eth_CR,`Wrt_Ext_CR,`Wrt_Rst_CR,`Wrt_VME_CR,`Wrt_BTO_CR,`Wrt_BGTO_CR:
                     CNFG_ST <= `W4ValDat_Wrt;
                  `Wrt_All_CRs:
                     CNFG_ST <= `W4ValDat_All;
                  `Set_Clr_CRs:
                     CNFG_ST <= `W4ValDat_SC;
                  `Save_Cnfg_Num,`Read_Cnfg_Num_Dir,`Read_Cnfg_Num_Dcd,`Rstr_Cnfg_Num,`Set_Cnfg_Dflt:
                     CNFG_ST <= `Get_Cnfg_Num;
                  `Set_MACs:
                     CNFG_ST <= `Get_MAC_ID;
                  `Read_MACs_Dir,`Read_MACs_Dcd:
                     CNFG_ST <= `Set_MAC_ID;
                  `Wrt_Ser_Num:
                     CNFG_ST <= `Get_Ser_Num_H;
                  `Read_Cnfg_Dflt,`Rd_Ser_Num:
                     CNFG_ST <= `W4Exec;
                  default:
                     CNFG_ST <= `Cnfg_Idle;
               endcase
         `W4ValDat_CR:
            if(CVD && (RXDATA[3:0] == `ALL_CR))
               CNFG_ST <= `W4ValDat_All;
            else if(CVD)
               CNFG_ST <= `W4ValDat_Wrt;
            else
               CNFG_ST <= `W4ValDat_CR;
         `W4ValDat_Wrt:
            if(CVD && !LONG_REG)
               CNFG_ST <= `Funct_Done;
            else if(CVD && LONG_REG)
               CNFG_ST <= `Wrt_VME_L;
            else
               CNFG_ST <= `W4ValDat_Wrt;
         `Wrt_VME_L:
            CNFG_ST <= `Funct_Done;
         `W4ValDat_All:
            if(LAST_CR)
               CNFG_ST <= `Funct_Done;
            else
               CNFG_ST <= `W4ValDat_All;
         `W4ValDat_SC:
            if(CVD)
               CNFG_ST <= `Mask_LD1;
            else
               CNFG_ST <= `W4ValDat_SC;
         `Mask_LD1:
            if(LONG_REG)
               CNFG_ST <= `Mask_LD2;
            else
               CNFG_ST <= `Set_Clr_Bits;
         `Mask_LD2:
            CNFG_ST <= `Set_Clr_Bits;
         `Set_Clr_Bits:
            CNFG_ST <= `Funct_Done;
         `Funct_Done:
            if(CFR == `Funct_NoOp)
               CNFG_ST <= `Cnfg_Idle;
            else
               CNFG_ST <= `Funct_Done;
         `Get_Cnfg_Num:
            if(CVD)
               CNFG_ST <= `W4Exec;
            else
               CNFG_ST <= `Get_Cnfg_Num;
         `Get_Ser_Num_H:
            if(CVD)
               CNFG_ST <= `Get_Ser_Num_L;
            else
               CNFG_ST <= `Get_Ser_Num_H;
         `Get_Ser_Num_L:
            CNFG_ST <= `W4Exec;
         `Get_MAC_ID:
            if(CVD)
               CNFG_ST <= `Wrt_MAC_Seq;
            else
               CNFG_ST <= `Get_MAC_ID;
         `Wrt_MAC_Seq:
            if(LAST_MAC)
               CNFG_ST <= `W4Exec;
            else
               CNFG_ST <= `Wrt_MAC_Seq;
         `Set_MAC_ID:
            CNFG_ST <= `W4Exec;
         `W4Exec:
            if(PU_RSTR_MACS)
               CNFG_ST <= `Snd_MAC_Seq;
            else if(PU_RSTR_DFLT)
               CNFG_ST <= `Snd_Dflt_Seq;
            else if(PU_RSTR_CNFG)
               CNFG_ST <= `Snd_Cnfg_Seq;
            else
               if(CNFG_EXEC)
                  case(CFR)
                     `Save_Cnfg_Num,`Read_Cnfg_Num_Dir,`Read_Cnfg_Num_Dcd,`Rstr_Cnfg_Num:
                        CNFG_ST <= `Snd_Cnfg_Seq;
                     `Set_MACs:
                        CNFG_ST <= `Get_MAC_Seq;
                     `Read_MACs_Dir,`Read_MACs_Dcd:
                        CNFG_ST <= `Snd_MAC_Seq;
                     `Set_Cnfg_Dflt,`Read_Cnfg_Dflt:
                        CNFG_ST <= `Snd_Dflt_Seq;
                     `Wrt_Ser_Num,`Rd_Ser_Num:
                        CNFG_ST <= `Snd_SerNum_Seq;
                     default:
                        CNFG_ST <= `W4Exec;
                  endcase
               else
                  CNFG_ST <= `W4Exec;
         `Get_MAC_Seq:
            if(ACNT == 2'd2)
               CNFG_ST <= `Ld_MAC_Reg;
            else
               CNFG_ST <= `Get_MAC_Seq;
         `Ld_MAC_Reg:
            if(LD_MAC_DONE)
               CNFG_ST <= `Snd_MAC_Seq;
            else
               CNFG_ST <= `Ld_MAC_Reg;
         `Snd_MAC_Seq:
            if(SND_MAC_DONE)
               if(ALL_MAC && (MAC_ID[2:0] != 3'h4))
                  CNFG_ST <= `Incr_MAC_ID;
               else if(PU_RSTR_MACS)
                  CNFG_ST <= `Rcv_From_FL;
               else if(TOFLASH_WRT)
                  CNFG_ST <= `Funct_Done;
               else
                  CNFG_ST <= `PH1Done;
            else
               CNFG_ST <= `Snd_MAC_Seq;
         `Incr_MAC_ID:
            if(TOFLASH_WRT)
               CNFG_ST <= `Get_MAC_Seq;
            else
               CNFG_ST <= `Snd_MAC_Seq;
         `Snd_Cnfg_Seq:
            if(SND_CNFG_DONE)
               if(PU_RSTR_CNFG)
                  CNFG_ST <= `Rcv_From_FL;
               else if(TOFLASH_WRT)
                  CNFG_ST <= `Funct_Done;
               else
                  CNFG_ST <= `PH1Done;
            else
               CNFG_ST <= `Snd_Cnfg_Seq;
         `Snd_Dflt_Seq:
            if(SND_DFLT_DONE)
               if(PU_RSTR_DFLT)
                  CNFG_ST <= `Rcv_From_FL;
               else if(TOFLASH_WRT)
                  CNFG_ST <= `Funct_Done;
               else
                  CNFG_ST <= `PH1Done;
            else
               CNFG_ST <= `Snd_Dflt_Seq;
         `Snd_SerNum_Seq:
            if(SND_SER_NUM_DONE)
               if(TOFLASH_WRT)
                  CNFG_ST <= `Funct_Done;
               else
                  CNFG_ST <= `PH1Done;
            else
               CNFG_ST <= `Snd_SerNum_Seq;
         `PH1Done:
            if(CONTINUE)
               if(RESTORE)
                  CNFG_ST <= `Rcv_From_FL;
               else
                  CNFG_ST <= `Cnfg_Snd_Data;
            else
               CNFG_ST <= `PH1Done;
         `Rcv_From_FL:
            if(CMPLTD)
               if(PU_RSTR_MACS || (CFR == `Read_MACs_Dcd))
                  CNFG_ST <= `Read_2_MAC;
               else if(PU_RSTR_CNFG || (CFR == `Rstr_Cnfg_Num) || (CFR == `Read_Cnfg_Num_Dcd))
                  CNFG_ST <= `Read_2_Cnfg;
               else if(PU_RSTR_DFLT || (CFR == `Read_Cnfg_Dflt))
                  CNFG_ST <= `Read_1_Dflt;
               else //(CFR == `Rd_Ser_Num)
                  CNFG_ST <= `Read_1_SerNum;
            else
               CNFG_ST <= `Rcv_From_FL;
         `Read_2_MAC:
            if(RD_RW1)
               CNFG_ST <= `Load_2_MAC;
            else
               CNFG_ST <= `Read_2_MAC;
         `Load_2_MAC:
            if(LD_DCD_DONE)
               if(PU_RSTR_MACS)
                  CNFG_ST <= `Wrt_MAC_Seq2;
               else
                  CNFG_ST <= `Send_MAC;
            else
               CNFG_ST <= `Load_2_MAC;
         `Send_MAC:
            if(LAST_MAC)
               CNFG_ST <= `Cnfg_Data_Done;
            else
               if(ACNT == 2'd2)
                  CNFG_ST <= `Incr_MAC_ID2;
               else
                  CNFG_ST <= `Send_MAC;
         `Wrt_MAC_Seq2:
            if(LAST_MAC)
               CNFG_ST <= `PH2_Done;
            else
               if(ACNT == 2'd2)
                  CNFG_ST <= `Incr_MAC_ID2;
               else
                  CNFG_ST <= `Wrt_MAC_Seq2;
         `Incr_MAC_ID2:
            CNFG_ST <= `Read_2_MAC;
         `Read_2_Cnfg:
            if(RD_RW1)
               CNFG_ST <= `Load_2_Cnfg;
            else
               CNFG_ST <= `Read_2_Cnfg;
         `Load_2_Cnfg:
            if(LD_DCD_DONE)
               if(PU_RSTR_CNFG || (CFR == `Rstr_Cnfg_Num))
                  CNFG_ST <= `Load_CRsA;
               else
                  CNFG_ST <= `Send_CnfgA;
            else
               CNFG_ST <= `Load_2_Cnfg;
         `Send_CnfgA:
            if(S3)
               if(LP == 1)
                  CNFG_ST <= `Read_1_Cnfg;
               else
                  CNFG_ST <= `Incr_Lp;
            else
               CNFG_ST <= `Send_CnfgA;
         `Load_CRsA:
            if(LP == 1)
               CNFG_ST <= `Read_1_Cnfg;
            else
               CNFG_ST <= `Incr_Lp;
         `Incr_Lp:
            CNFG_ST <= `Read_2_Cnfg;
         `Read_1_Cnfg:
            CNFG_ST <= `Load_1_Cnfg;
         `Load_1_Cnfg:
            if(LD_DCD_DONE)
               if(PU_RSTR_CNFG || (CFR == `Rstr_Cnfg_Num))
                  CNFG_ST <= `Load_CRsB;
               else
                  CNFG_ST <= `Send_CnfgB;
            else
               CNFG_ST <= `Load_1_Cnfg;
         `Send_CnfgB:
            CNFG_ST <= `Cnfg_Data_Done;
         `Load_CRsB:
            CNFG_ST <= `PH2_Done;
         `Read_1_Dflt:
            CNFG_ST <= `Load_Dflt;
         `Load_Dflt:
            if(LD_DCD_DONE)
               if(PU_RSTR_DFLT)
                  CNFG_ST <= `PH2_Done;
               else
                  CNFG_ST <= `Send_Dflt;
            else
               CNFG_ST <= `Load_Dflt;
         `Send_Dflt:
            CNFG_ST <= `Cnfg_Data_Done;
         `Read_1_SerNum:
            CNFG_ST <= `Load_SerNum;
         `Load_SerNum:
            if(LD_DCD_DONE)
               CNFG_ST <= `Send_SerNum;
            else
               CNFG_ST <= `Load_SerNum;
         `Send_SerNum:
            if(S2)
               CNFG_ST <= `Cnfg_Data_Done;
            else
               CNFG_ST <= `Send_SerNum;
         `Ena_Rd_Seq:
            if(LAST_CR)
               CNFG_ST <= `Cnfg_Data_Done;
            else
               CNFG_ST <= `Ena_Rd_Seq;
         `Cnfg_Snd_Data:
            if(TXP_DATA)
               if(CFR == `Read_CRs)
                  CNFG_ST <= `Ena_Rd_Seq;
               else if(READ_DIR)
                  CNFG_ST <= `Send_Dir;
               else
                  CNFG_ST <= `Rcv_From_FL;
            else
               CNFG_ST <= `Cnfg_Snd_Data;
         `Send_Dir:
            if(CMPLTD)
               CNFG_ST <= `Cnfg_Data_Done;
            else
               CNFG_ST <= `Send_Dir;
         `Cnfg_Data_Done:
            if(!TXP_DATA)
               CNFG_ST <= `Cnfg_W4TXDN;
            else
               CNFG_ST <= `Cnfg_Data_Done;
         `Cnfg_W4TXDN:
            if(DONE)
               CNFG_ST <= `PH2_Done;
            else
               CNFG_ST <= `Cnfg_W4TXDN;
         `PH2_Done:
            if(CFR == `Funct_NoOp)
               CNFG_ST <= `Cnfg_Idle;
            else
               CNFG_ST <= `PH2_Done;
         default:
            CNFG_ST <= `Cnfg_Idle;
      endcase
end


always @(CNFG_ST)
begin
   case(CNFG_ST)
      `Get_MAC_Seq,`Ld_MAC_Reg,`Snd_MAC_Seq,`Incr_MAC_ID,
      `Snd_Cnfg_Seq,`Snd_SerNum_Seq,`Snd_Dflt_Seq:
         CNFG_SND_REQ <= 1;
      default:
         CNFG_SND_REQ <= 0;
   endcase
end

always @(CNFG_ST)
begin
   case(CNFG_ST)
      `Read_1_Dflt,`Read_1_SerNum,`Read_1_Cnfg,`Read_2_MAC,`Read_2_Cnfg:
         READ_RAW <= 1;
      default:
         READ_RAW <= 0;
   endcase
end
always @(CNFG_ST)
begin
   case(CNFG_ST)
      `Cnfg_Idle,`W4Exec,`Read_1_Dflt,`Read_1_SerNum,`Read_1_Cnfg,`Read_2_MAC,`Read_2_Cnfg:
         RST_DCD_CNTR <= 1;
      default:
         RST_DCD_CNTR <= 0;
   endcase
end


always @(CNFG_ST or LD_FIRST or LD_LAST or PU_RSTR_DFLT)
begin
   case(CNFG_ST)
      `Load_2_Cnfg,`Load_2_MAC:
         begin
            LD_DCD_A <= LD_FIRST;
            LD_DCD_B <= LD_LAST;
            LD_CNFG_NUM_DFLT <= 0;
            DCD_CNTR_ENA <= 1;
         end
      `Load_1_Cnfg,`Load_Dflt,`Load_SerNum:
         begin
            LD_DCD_A <= LD_LAST;
            LD_DCD_B <= 0;
            LD_CNFG_NUM_DFLT <= LD_LAST && PU_RSTR_DFLT;
            DCD_CNTR_ENA <= 1;
         end
      default:
         begin
            LD_DCD_A <= 0;
            LD_DCD_B <= 0;
            LD_CNFG_NUM_DFLT <= 0;
            DCD_CNTR_ENA <= 0;
         end
   endcase
end




//////////////////////////////////////////////////////////////////
//                                                              //
// Configuration registers for Ethernet, External FIFO,         //
// Reset Enables, and VME.                                      //
// (Functions are Reset, Load, Hold, BitSet, and BitClr)        //
// Also Bus Time Out and Bus Grant Time Out                     //
// (Functions are Reset, Load, and Hold)                        //
//                                                              //
//////////////////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin
   if(RST)
      BMASK <= 32'h00000000;
   else
      if(MASK_LD_RCV1)
         if(CR_ID==`VME_CR)
            BMASK <= {RXDATA,BMASK[15:0]};
         else
            BMASK <= {BMASK[31:16],RXDATA};
      else if(MASK_LD_RCV2)
         if(CR_ID==`VME_CR)
            BMASK <= {BMASK[31:16],RXDATA};
         else
            BMASK <= BMASK;
      else if(SET_TST_FF)
         BMASK <= `Test_FF_Mode_msk;
      else if(CLR_TST_FF)
         BMASK <= `VME_FF_Mode_msk;
      else if(SET_ECC_ENA)
         BMASK <= `ECC_Enable_msk;
      else if(CLR_ECC_ENA)
         BMASK <= `ECC_Disable_msk;
      else if(SET_INJ_ERR)
         BMASK <= `Set_Inj_Err_msk;
      else if(CLR_INJ_ERR)
         BMASK <= `Rst_Inj_Err_msk;
      else if(SET_WARNSHD)
         BMASK <= `Warn_On_Shdwn_msk;
      else if(CLR_WARNSHD)
         BMASK <= `No_Warn_On_Shdwn_msk;
      else if(SET_STRTPKT)
         BMASK <= `Snd_Startup_Pkt_msk;
      else if(CLR_STRTPKT)
         BMASK <= `No_Startup_Pkt_msk;
      else
         BMASK <= BMASK;
end

// Configure Register ID and Set/Clr register
always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         CR_ID <= 4'b00;
         ST_CLR <= 0;
      end
   else
      if(LD_CR_ID && (CFR==`Wrt_CR_ID))
         begin
            CR_ID <= RXDATA[3:0];
            ST_CLR <= 0;
         end
      else if(LD_CR_ID && (CFR==`Set_Clr_CRs))
         begin
            CR_ID <= {2'b00,RXDATA[1:0]};
            ST_CLR <= RXDATA[8];
         end
      else
         begin
            CR_ID <= CR_ID;
            ST_CLR <= ST_CLR;
         end
end

// Register to hold Decoded register data
always @(posedge CLK or posedge RST)
begin
   if(RST)
      CNFG_DCD_REG <= 48'h000000000000;
   else
      if(LD_DCD_A)
         CNFG_DCD_REG <= {DCD_DATA,CNFG_DCD_REG[23:0]};
      else if(LD_DCD_B)
         CNFG_DCD_REG <= {CNFG_DCD_REG[47:24],DCD_DATA};
      else
         CNFG_DCD_REG <= CNFG_DCD_REG;
end


always @(posedge CLK or posedge RST)
begin
   if(RST)
      ETHER_CNFG <= `Ether_Cnfg_Dflt;  // default value
   else
      if(ET_DIR_LD)
         ETHER_CNFG <= RXDATA;
      else if(ET_FL_LD)
         ETHER_CNFG <= CNFG_DCD_REG[47:32];
      else if(ET_BSET)
         ETHER_CNFG <= BMASK[15:0] | ETHER_CNFG;
      else if(ET_BCLR)
         ETHER_CNFG <= BMASK[15:0] & ETHER_CNFG;
      else
         ETHER_CNFG <= ETHER_CNFG;
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      EXT_FIFO_CNFG <= `Ext_FIFO_Cnfg_Dflt;  // default value
   else
      if(EF_DIR_LD)
         EXT_FIFO_CNFG <= RXDATA;
      else if(EF_FL_LD)
         EXT_FIFO_CNFG <= CNFG_DCD_REG[31:16];
      else if(EF_BSET)
         EXT_FIFO_CNFG <= BMASK[15:0] | EXT_FIFO_CNFG;
      else if(EF_BCLR)
         EXT_FIFO_CNFG <= BMASK[15:0] & EXT_FIFO_CNFG;
      else
         EXT_FIFO_CNFG <= EXT_FIFO_CNFG;
end


always @(posedge CLK or posedge RST)
begin
   if(RST)
      RESET_CNFG <= `Reset_Cnfg_Dflt;  // default value
   else
      if(RST_DIR_LD)
         RESET_CNFG <= RXDATA;
      else if(RST_FL_LD)
         RESET_CNFG <= CNFG_DCD_REG[15:0];
      else if(RST_BSET)
         RESET_CNFG <= BMASK[15:0] | RESET_CNFG;
      else if(RST_BCLR)
         RESET_CNFG <= BMASK[15:0] & RESET_CNFG;
      else
         RESET_CNFG <= RESET_CNFG;
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      VME_CNFG <= `VME_Cnfg_Dflt;
   else
      if(VME_DIR_LD_H)
         VME_CNFG <= {RXDATA,VME_CNFG[15:0]};
      else if(VME_DIR_LD_L)
         VME_CNFG <= {VME_CNFG[31:24],1'b1,VME_CNFG[22:16],RXDATA};
      else if(VME_FL_LD)
         VME_CNFG <= {CNFG_DCD_REG[47:40],1'b1,CNFG_DCD_REG[38:16]};
      else if(VME_BSET)
         VME_CNFG <= BMASK | VME_CNFG;
      else if(VME_BCLR)
         VME_CNFG <= BMASK & VME_CNFG;
      else if(RST_IRQ_UPD)
         VME_CNFG <= 32'hFF7FFFFF & VME_CNFG;
      else if(CLR_SYSRST)
         VME_CNFG <= 32'hFFFF7FFF & VME_CNFG;
      else
         VME_CNFG <= VME_CNFG;
end
always @ (posedge DV1024CLK or negedge VME_CNFG[15])
begin
   if(!VME_CNFG[15]) 
     SYSRST_TIMER <= 8'hFF;
   else
     SYSRST_TIMER <= SYSRST_TIMER-1;
end
always @(posedge CLK)
begin
   RST_IRQ_UPD <= VME_CNFG[23];
   CLR_SYSRST <= (SYSRST_TIMER == 8'h00);
end

// VME Bus TimeOut Register
always @(posedge CLK or posedge RST)
begin
   if(RST)
      VME_BTO <= `VME_BTO_Dflt;
   else
      if(BTO_DIR_LD)
         VME_BTO <= RXDATA;
      else if(BTO_FL_LD)
         VME_BTO <= CNFG_DCD_REG[15:0];
      else
         VME_BTO <= VME_BTO;
end

// VME BusGrant TimeOut Register
always @(posedge CLK or posedge RST)
begin
   if(RST)
      VME_BGTO <= `VME_BGTO_Dflt;
   else
      if(BGTO_DIR_LD)
         VME_BGTO <= RXDATA;
      else if(BGTO_FL_LD)
         VME_BGTO <= CNFG_DCD_REG[47:32];
      else
         VME_BGTO <= VME_BGTO;
end

//////////////////////////////////////////////////////////////////
//                                                              //
// Output MUX for configuration registers                       //
//                                                              //
//////////////////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin
   if(RST)
      OUTDATA <= 16'h0000;
   else
      if(ENA_RD_SEQ)
         case(SEL_CR)
            `Sel_Eth_CR:
               OUTDATA <= ETHER_CNFG;
            `Sel_Ext_CR:
               OUTDATA <= EXT_FIFO_CNFG;
            `Sel_Rst_CR:
               OUTDATA <= RESET_CNFG;
            `Sel_VMEh_CR:
               OUTDATA <= VME_CNFG[31:16];
            `Sel_VMEl_CR:
               OUTDATA <= VME_CNFG[15:0];
            `Sel_BTO_CR:
               OUTDATA <= VME_BTO;
            `Sel_BGTO_CR:
               OUTDATA <= VME_BGTO;
            default:
               OUTDATA <= ETHER_CNFG;
         endcase
      else if(SND_DFLT)
         OUTDATA <= {11'h000,CNFG_DCD_REG[28:24]};
      else if(SND_SER_NUM)
         if(S1 && !S2)
            OUTDATA <= {8'h00,CNFG_DCD_REG[47:40]};
         else
            OUTDATA <= CNFG_DCD_REG[39:24];
      else if(SND_CNFGA)
         case({S3,S2,S1})
            3'b001:
               OUTDATA <= CNFG_DCD_REG[47:32];
            3'b011:
               OUTDATA <= CNFG_DCD_REG[31:16];
            3'b111:
               OUTDATA <= CNFG_DCD_REG[15:0];
            default:
               OUTDATA <= CNFG_DCD_REG[47:32];
         endcase
      else if(SND_CNFGB)
         OUTDATA <= CNFG_DCD_REG[47:32];
      else if(SND_MAC)
         case(ACNT)
            3'd0:
               OUTDATA <= CNFG_DCD_REG[47:32];
            3'd1:
               OUTDATA <= CNFG_DCD_REG[31:16];
            3'd2:
               OUTDATA <= CNFG_DCD_REG[15:0];
            default:
               OUTDATA <= CNFG_DCD_REG[47:32];
         endcase
      else if(SEND_DIR)
         OUTDATA <= FL_FR_DATA;
      else
         OUTDATA <= 16'h0000;
end

// Selection sequence counter
always @(posedge CLK or posedge SEL_CR_RST)
begin
   if(SEL_CR_RST)
      SEL_CR <= 3'd0;
   else
      if(ENA_RD_SEQ || ENA_WRT_SEQ)
         SEL_CR <= SEL_CR + 1;
      else
         SEL_CR <= SEL_CR;
end



// counter for one page of configuration memory //
always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         AD_CNT <= 7'h00;
         DO_DCD <= 0;
      end
   else
      if(LD_AC)
         begin
            AD_CNT <= FL_FR_DATA[6:0];
            DO_DCD <= FL_FR_DATA[15];
         end
      else if(SHIFT)
         begin
            AD_CNT <= AD_CNT -1;
            DO_DCD <= DO_DCD;
         end
      else
         begin
            AD_CNT <= AD_CNT;
            DO_DCD <= DO_DCD;
         end
end

// input pipeline to collect 2 ECC pairs //
always @(posedge CLK)
begin
   if(SHIFT && FILL)
      begin
         PARITY[7:0] <= FL_FR_DATA[7:0];
         PARITY[15:8] <= PARITY[7:0];
         PARITY[23:16] <= PARITY[15:8];
         DATA[7:0] <= PARITY[23:16];
         DATA[23:8] <= 16'h0000;
      end
   else if(SHIFT)
      begin
         PARITY[7:0] <= FL_FR_DATA[7:0];
         PARITY[15:8] <= PARITY[7:0];
         PARITY[23:16] <= PARITY[15:8];
         DATA[7:0] <= PARITY[23:16];
         DATA[15:8] <= DATA[7:0];
         DATA[23:16] <= DATA[15:8];
      end
   else
      begin
         PARITY <= PARITY;
         DATA <= DATA;
      end
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      SIXB_PHASE <= 3'd0;
   else
      if(SHIFT)
         if(FILL || (SIXB_PHASE == 3'd5))
            SIXB_PHASE <= 3'd0;
         else
            SIXB_PHASE <= SIXB_PHASE+1;
      else
         SIXB_PHASE <= SIXB_PHASE;
end

always @(posedge CLK)
begin
   BT0_DLY <= BT0;
end

// State machine for converting FLASH format to FIFO width //
always @(posedge CLK or posedge RST)
begin: F2C_FSM
   if(RST)
      F2C_ST <= `F2C_Idle;
   else
      case(F2C_ST)
         `F2C_Idle:
            if(FL_CDV)
               F2C_ST <= `F2C_Shift;
            else
               F2C_ST <= `F2C_Idle;
         `F2C_Shift:
            if(AD_CNT == 7'h01)
               F2C_ST <= `F2C_Load_AC;
            else
               F2C_ST <= `F2C_Shift;
         `F2C_Load_AC:
            if(FL_CDV)
               F2C_ST <= `F2C_Shift;
            else if(FL_CND)
               F2C_ST <= `F2C_Complete;
            else
               F2C_ST <= `F2C_Load_AC;
         `F2C_Complete:
            F2C_ST <= `F2C_Idle;
         default:
            F2C_ST <= `F2C_Idle;
      endcase      
end

always @(F2C_ST or BT0 or BT0_DLY or FL_CDV or DO_DCD)
begin
   case(F2C_ST)
      `F2C_Idle:
         begin
            SHIFT <= 0;
            LD_AC <= FL_CDV;
            PUSH_RAW <= 0;
            CMPLTD <= 0;
         end
      `F2C_Shift:
         begin
            SHIFT <= FL_CDV;
            LD_AC <= 0;
            PUSH_RAW <= DO_DCD && BT0 && !BT0_DLY;
            CMPLTD <= 0;
         end
      `F2C_Load_AC:
         begin
            SHIFT <= 0;
            LD_AC <= FL_CDV;
            PUSH_RAW <= DO_DCD && BT0 && !BT0_DLY;
            CMPLTD <= 0;
         end
      `F2C_Complete:
         begin
            SHIFT <= 0;
            LD_AC <= 0;
            PUSH_RAW <= 0;
            CMPLTD <= 1;
         end
      default:
         begin
            SHIFT <= 0;
            LD_AC <= 0;
            PUSH_RAW <= 0;
            CMPLTD <= 0;
         end
   endcase
end

//////////////////////////////////////////////////////////////////
//                                                              //
// Input FIFO for data coming from the Flash memory             //
// (FR_FL_FF : FRom_FLash_FiFo)                                 //
//                                                              //
//////////////////////////////////////////////////////////////////

parameter FR_FL_FF_p2depth = 4;
defparam FR_FL_FF.p2depth = FR_FL_FF_p2depth;
defparam FR_FL_FF.width = 48;
defparam FR_FL_FF.almostmt = 2;
defparam FR_FL_FF.almostfull = (1<<FR_FL_FF_p2depth) - 2;
fifo_dpXn_blk  FR_FL_FF(.clk(CLK),.rst(RST),.push(PUSH_RAW),.pop(READ_RAW),
                       .mt(RAW_MT),.full(RAW_FULL),.amt(RAW_AMT),.af(RAW_AF),.wterr(RAW_WTERR),.rderr(RAW_RDERR),
             .din({DATA[23:0],PARITY[23:0]}),.dout({RWD1,RWD2,RWP1,RWP2}),.cnt(RAW_CNT));

ecc_decode ecc_decode_CNFG1(.CLK(CLK),.RCV_DATA(RWD1),.RCV_PARITY(RWP1),.GOOD_WORD(VP1),
              .DCD_DATA(DCD_DATA[23:12]),.DCD_PARITY(DCD_PAR1),.BAD_TX(BTX1));
ecc_decode ecc_decode_CNFG2(.CLK(CLK),.RCV_DATA(RWD2),.RCV_PARITY(RWP2),.GOOD_WORD(VP2),
              .DCD_DATA(DCD_DATA[11:0]),.DCD_PARITY(DCD_PAR2),.BAD_TX(BTX2));

// Counter for MAC memory addresses
always @(posedge CLK or posedge ACNT_RST)
begin
   if(ACNT_RST)
      ACNT <= 2'd0;
   else
      if(ACNT_ENA)
         if(ACNT == 2'd2)
            ACNT <= 2'd0;
         else
            ACNT <= ACNT + 1;
      else
         ACNT <= ACNT;
end

// Register/counter for MAC ID (MAC type)
always @(posedge CLK or posedge RST)
begin
   if(RST)
      MAC_ID <= 4'h0;
   else
      if(LD_MAC_ID)
         MAC_ID <= RXDATA[3:0];
      else if((ALL_MAC && RST_MAC_ID) || SET_MAC_ID)
         MAC_ID <= 4'h8;
      else if(MID_ENA && ALL_MAC && (ACNT == 2'd2))
         MAC_ID <= MAC_ID + 1;
      else if(MID_INC)
         MAC_ID <= MAC_ID + 1;
      else
         MAC_ID <= MAC_ID;
end

always @(SND_MAC_ENA or MAC_ID or SND_DFLT_ENA or SND_SER_NUM_ENA or SND_CNFG_ENA)
begin
   if(SND_MAC_ENA)
      case(MAC_ID)
         4'h0,4'h8:
            M_OFFSET <= 6'h00;
         4'h1,4'h9:
            M_OFFSET <= 6'h0C;
         4'h2,4'hA:
            M_OFFSET <= 6'h18;
         4'h3,4'hB:
            M_OFFSET <= 6'h24;
         4'h4,4'hC:
            M_OFFSET <= 6'h30;
         default:
            M_OFFSET <= 6'h00;
      endcase
   else if(SND_DFLT_ENA)
      M_OFFSET <= 6'h3C;
   else if(SND_CNFG_ENA || SND_SER_NUM_ENA)
      M_OFFSET <= 6'h00;
   else
      M_OFFSET <= 6'h00;
end

always @(posedge CLK or posedge RA_RST)
begin
   if(RA_RST)
      RELADDR <= 6'h00;
   else
      if(RA_ENA || RA_ENA_DFLT || RA_ENA_CNFG || RA_ENA_SER_NUM )
         if(RA_ENA && (RELADDR == 6'h0B))
            RELADDR <= 6'h00;
         else
            RELADDR <= RELADDR + 1;
      else
         RELADDR <= RELADDR;
end

always @(posedge CLK)
begin
   LD1_H <= ACNT_ENA && !MAC_WE && !MAC_WE2 && (ACNT == 2'd0);
   LD1_M <= ACNT_ENA && !MAC_WE && !MAC_WE2 && (ACNT == 2'd1);
   LD1_L <= ACNT_ENA && !MAC_WE && !MAC_WE2 && (ACNT == 2'd2);
   LD2_H <= LD1_H;
   LD2_M <= LD1_M;
   LD2_L <= LD1_L;
   LD3_H <= LD2_H;
   LD3_M <= LD2_M;
   LD3_L <= LD2_L;
   LD_H <= LD3_H;
   LD_M <= LD3_M;
   LD_L <= LD3_L;
   LD_MAC_DONE <= LD3_L;
end

// Scratch register for MAC addresses
always @(posedge CLK or posedge RST)
begin
   if(RST)
      MAC_REG <= 48'h000000000000;
   else
      if(LD_H)
         MAC_REG <= {MACBUS_IN_REG,MAC_REG[31:0]};
      else if(LD_M)
         MAC_REG <= {MAC_REG[47:32],MACBUS_IN_REG,MAC_REG[15:0]};
      else if(LD_L)
         MAC_REG <= {MAC_REG[47:16],MACBUS_IN_REG};
      else
         MAC_REG <= MAC_REG;
end

// ECC Encoder Mux
always @(posedge CLK)
begin
   if(MAC1)
      begin
         ECC_MUXH <= MAC_REG[47:36];
         ECC_MUXL <= MAC_REG[36:24];
      end
   else if(MAC2)
      begin
         ECC_MUXH <= MAC_REG[23:12];
         ECC_MUXL <= MAC_REG[11:0];
      end
   else if(DFLT)
      begin
         ECC_MUXH <= 12'h000;
         ECC_MUXL <= {7'h00,CNFG_NUM};
      end
   else if(SER_NUM)
      begin
         ECC_MUXH <= SERIAL_NUM[23:12];
         ECC_MUXL <= SERIAL_NUM[11:0];
      end
   else if(ENA_CNFG && (RND == 3'h0))//Ethernet CR
      begin
         ECC_MUXH <= ETHER_CNFG[15:4];
         ECC_MUXL <= {ETHER_CNFG[3:0],EXT_FIFO_CNFG[15:8]};
      end
   else if(ENA_CNFG && (RND == 3'h1))//External FIFO CR and Reset Enables CR
      begin
         ECC_MUXH <= {EXT_FIFO_CNFG[7:0],RESET_CNFG[15:12]};
         ECC_MUXL <= {RESET_CNFG[11:0]};
      end
   else if(ENA_CNFG && (RND == 3'h2))//VME CR
      begin
         ECC_MUXH <= VME_CNFG[31:20];
         ECC_MUXL <= VME_CNFG[19:8];
      end
   else if(ENA_CNFG && (RND == 3'h3))//VME CR and Bus TimeOut
      begin
         ECC_MUXH <= {VME_CNFG[7:0],VME_BTO[15:12]};
         ECC_MUXL <= VME_BTO[11:0];
      end
   else if(ENA_CNFG && (RND == 3'h4))//Bus Grant TimeOut
      begin
         ECC_MUXH <= VME_BGTO[15:4];
         ECC_MUXL <= {VME_BGTO[3:0],8'h00};
      end
   else
      begin
         ECC_MUXH <= 12'h000;
         ECC_MUXL <= 12'h000;
      end
end



// ECC Encoders
ecc_encode ecc_encode_CNFG1(.CLK(CLK),.DATA(ECC_MUXH),.PARITY(ECC_PARH));
ecc_encode ecc_encode_CNFG2(.CLK(CLK),.DATA(ECC_MUXL),.PARITY(ECC_PARL));

always @(posedge CLK)
begin
   ECC_MUXH1 <= ECC_MUXH;
   ECC_MUXL1 <= ECC_MUXL;
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      HDR_REG <= 16'h0000;
   else
      if(LD_HDR1 || DFLT || SER_NUM || SC1_LD_HDR1)
         HDR_REG <= HDR1;
      else if(LD_HDR2A)
         HDR_REG <= HDR2A;
      else if(LD_HDR2B)
         HDR_REG <= HDR2B;
      else if(LD_HDR2C)
         HDR_REG <= HDR2C;
      else if(LD_HDR2D)
         HDR_REG <= HDR2D;
      else
         HDR_REG <= HDR_REG;
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      FL_TO_DATA <= 48'h000000000000;
   else
      if(LD_FL_DATA_MAC || LD_FL_DATA_CNFG || LD_FL_DATA_SER_NUM)
         if(TOFLASH_WRT)
            FL_TO_DATA <= {ECC_MUXH1,ECC_MUXL1,ECC_PARH,ECC_PARL};
         else
            FL_TO_DATA <= 48'h000000000000;
      else if(LD_FL_DATA_DFLT)
         if(TOFLASH_WRT)
            FL_TO_DATA <= {ECC_MUXL1[7:0],ECC_PARH,ECC_PARL,16'h0000};
         else
            FL_TO_DATA <= 48'h000000000000;
      else if(SH_FL_DATA_MAC || SH_FL_DATA_DFLT || SH_FL_DATA_CNFG || SH_FL_DATA_SER_NUM)
         begin
            FL_TO_DATA[47:40] <= FL_TO_DATA[39:32];
            FL_TO_DATA[39:32] <= FL_TO_DATA[31:24];
            FL_TO_DATA[31:24] <= FL_TO_DATA[23:16];
            FL_TO_DATA[23:16] <= FL_TO_DATA[15:8];
            FL_TO_DATA[15:8] <= FL_TO_DATA[7:0];
            FL_TO_DATA[7:0] <= FL_TO_DATA[7:0];
         end
      else
         FL_TO_DATA <= FL_TO_DATA;
end

always @(posedge CLK)
begin
   HEAD_OUT <= HEAD_OUT_MAC || HEAD_OUT_DFLT || HEAD_OUT_CNFG || HEAD_OUT_SER_NUM;
end

always @(posedge CLK)
begin
   if(HEAD_OUT)
      TO_FLASH <= HDR_REG;
   else
      TO_FLASH <= {2'b00,BA,FL_TO_DATA[47:40]};
end
always @(posedge CLK)
begin
   FL_VALDAT <= DV_MAC || DV_DFLT || DV_CNFG || DV_SER_NUM;
end






// State machine for sending MAC address to the Flash //
always @(posedge CLK or posedge RST)
begin: SM1_FSM     // Send MAC Sequence for sending MAC info to Flash controller
   if(RST)
      SM1_ST <= `SM1_Idle;
   else
      case(SM1_ST)
         `SM1_Idle:
            if(SND_MAC_ENA)
               SM1_ST <= `SM1_Req_Snd;
            else
               SM1_ST <= `SM1_Idle;
         `SM1_Req_Snd:
            if(!FL_HOLD)
               if((MAC_ID <= 4'h8))
                  SM1_ST <= `SM1_Hdr1;
               else
                  SM1_ST <= `SM1_NoHdr1;
            else
               SM1_ST <= `SM1_Req_Snd;
         `SM1_Hdr1:
            SM1_ST <= `SM1_Hdr2a;
         `SM1_Hdr2a:
            SM1_ST <= `SM1_MC1_Load;
         `SM1_NoHdr1:
            SM1_ST <= `SM1_NoHdr2;
         `SM1_NoHdr2:
            SM1_ST <= `SM1_MC1_Load;
         `SM1_MC1_Load:
            SM1_ST <= `SM1_MC1_Shift;
         `SM1_MC1_Shift:
            if(HOLD3)
               SM1_ST <= `SM1_MC2_ShiftA;
            else
               SM1_ST <= `SM1_MC1_Shift;
         `SM1_MC2_ShiftA:
            if(SHIFT_DONE)
               SM1_ST <= `SM1_MC2_Load;
            else
               SM1_ST <= `SM1_MC2_ShiftA;
         `SM1_MC2_Load:
            SM1_ST <= `SM1_MC2_ShiftB;
         `SM1_MC2_ShiftB:
            if(HOLD3)
               SM1_ST <= `SM1_Shift;
            else
               SM1_ST <= `SM1_MC2_ShiftB;
         `SM1_Shift:
            if(SHIFT_DONE)
               SM1_ST <= `SM1_Pipe;
            else
               SM1_ST <= `SM1_Shift;
         `SM1_Pipe:
            SM1_ST <= `SM1_Done;
         `SM1_Done:
            SM1_ST <= `SM1_Idle;
         default:
            SM1_ST <= `SM1_Idle;
      endcase      
end

always @(SM1_ST)
begin
   case(SM1_ST)
      `SM1_MC1_Shift,
      `SM1_MC2_ShiftA,
      `SM1_MC2_ShiftB,`SM1_Shift:
         SH_FL_DATA_MAC <= 1;
      default:
         SH_FL_DATA_MAC <= 0;
   endcase
end

always @(SM1_ST)
begin
   case(SM1_ST)
      `SM1_Hdr1,`SM1_Hdr2a,
      `SM1_NoHdr1,`SM1_NoHdr2,
      `SM1_MC1_Load,`SM1_MC1_Shift:
         begin
            MAC1 <= 1;
            MAC2 <= 0;
         end
      `SM1_MC2_ShiftA,`SM1_MC2_Load,
      `SM1_MC2_ShiftB:
         begin
            MAC1 <= 0;
            MAC2 <= 1;
         end
      default:
         begin
            MAC1 <= 0;
            MAC2 <= 0;
         end
   endcase
end

always @(SM1_ST)
begin
   case(SM1_ST)
      `SM1_MC1_Shift,
      `SM1_MC2_ShiftA,`SM1_MC2_Load,
      `SM1_MC2_ShiftB,`SM1_Shift,`SM1_Pipe:
         RA_ENA <= 1;
      default:
         RA_ENA <= 0;
   endcase
end


always @(SM1_ST or MAC_ID)
begin
   case(SM1_ST)
      `SM1_Hdr2a,`SM1_MC1_Shift,
      `SM1_MC2_ShiftA,`SM1_MC2_Load,
      `SM1_MC2_ShiftB,`SM1_Shift,`SM1_Pipe:
         DV_MAC <= 1;
      `SM1_MC1_Load:
         DV_MAC <= (MAC_ID <= 4'h8);
      default:
         DV_MAC <= 0;
   endcase
end


always @(posedge CLK)
begin
   HOLD1 <= LD_FL_DATA_MAC || LD_FL_DATA_DFLT || LD_FL_DATA_CNFG || LD_FL_DATA_SER_NUM;
   HOLD2 <= HOLD1;
   HOLD3 <= HOLD2;
   HOLD4 <= HOLD3;
   SHIFT_DONE <= SM1_SD1 || SC1_SD1 || (HOLD4 && SH_FL_DATA_SER_NUM);
end
         
// State machine for sending Default configuration number to the Flash //
always @(posedge CLK or posedge RST)
begin: SD1_FSM     // Send Default num; Sequence for sending Default info to Flash controller
   if(RST)
      SD1_ST <= `SD1_Idle;
   else
      case(SD1_ST)
         `SD1_Idle:
            if(SND_DFLT_ENA)
               SD1_ST <= `SD1_Req_Snd;
            else
               SD1_ST <= `SD1_Idle;
         `SD1_Req_Snd:
            if(FL_HOLD)
               SD1_ST <= `SD1_Req_Snd;
            else
               SD1_ST <= `SD1_Hdr1;
         `SD1_Hdr1:
            SD1_ST <= `SD1_Hdr2b;
         `SD1_Hdr2b:
            SD1_ST <= `SD1_Dflt_Load;
         `SD1_Dflt_Load:
            SD1_ST <= `SD1_Dflt_Shift;
         `SD1_Dflt_Shift:
            if(HOLD3)
               SD1_ST <= `SD1_Pipe;
            else
               SD1_ST <= `SD1_Dflt_Shift;
         `SD1_Pipe:
            SD1_ST <= `SD1_Done;
         `SD1_Done:
            SD1_ST <= `SD1_Idle;
         default:
            SD1_ST <= `SD1_Idle;
      endcase      
end


always @(SD1_ST)
begin
   case(SD1_ST)
      `SD1_Hdr2b,
      `SD1_Dflt_Load,
      `SD1_Dflt_Shift,
      `SD1_Pipe:
         DV_DFLT <= 1;
      default:
         DV_DFLT <= 0;
   endcase
end


// State machine for sending Serial number to the Flash //
always @(posedge CLK or posedge RST)
begin: SSN1_FSM     // Send Serial Num; Sequence for sending Serial Number to Flash controller
   if(RST)
      SSN1_ST <= `SSN1_Idle;
   else
      case(SSN1_ST)
         `SSN1_Idle:
            if(SND_SER_NUM_ENA)
               SSN1_ST <= `SSN1_Req_Snd;
            else
               SSN1_ST <= `SSN1_Idle;
         `SSN1_Req_Snd:
            if(FL_HOLD)
               SSN1_ST <= `SSN1_Req_Snd;
            else
               SSN1_ST <= `SSN1_Hdr1;
         `SSN1_Hdr1:
            SSN1_ST <= `SSN1_Hdr2d;
         `SSN1_Hdr2d:
            SSN1_ST <= `SSN1_SerNum_Load;
         `SSN1_SerNum_Load:
            SSN1_ST <= `SSN1_Shift;
         `SSN1_Shift:
            if(SHIFT_DONE)
               SSN1_ST <= `SSN1_Pipe;
            else
               SSN1_ST <= `SSN1_Shift;
         `SSN1_Pipe:
            SSN1_ST <= `SSN1_Done;
         `SSN1_Done:
            SSN1_ST <= `SSN1_Idle;
         default:
            SSN1_ST <= `SSN1_Idle;
      endcase      
end

always @(SSN1_ST)
begin
   case(SSN1_ST)
      `SSN1_Hdr2d,
      `SSN1_SerNum_Load,
      `SSN1_Shift,
      `SSN1_Pipe:
         DV_SER_NUM <= 1;
      default:
         DV_SER_NUM <= 0;
   endcase
end


// ROM for Config Num to Start Page Map
always @(posedge CLK)
begin: Strt_Pg_ROM
   case(CNFG_NUM)
      5'd00: ST_PG <= 7'h01;  //   1
      5'd01: ST_PG <= 7'h07;  //   7
      5'd02: ST_PG <= 7'h0D;  //  13
      5'd03: ST_PG <= 7'h13;  //  19
      5'd04: ST_PG <= 7'h19;  //  25
      5'd05: ST_PG <= 7'h1F;  //  31
      5'd06: ST_PG <= 7'h25;  //  37
      5'd07: ST_PG <= 7'h2B;  //  43
      5'd08: ST_PG <= 7'h31;  //  49
      5'd09: ST_PG <= 7'h37;  //  55
      5'd10: ST_PG <= 7'h3D;  //  61
      5'd11: ST_PG <= 7'h43;  //  67
      5'd12: ST_PG <= 7'h49;  //  73
      5'd13: ST_PG <= 7'h4F;  //  79
      5'd14: ST_PG <= 7'h55;  //  85
      5'd15: ST_PG <= 7'h5B;  //  91
      5'd16: ST_PG <= 7'h61;  //  97
      5'd17: ST_PG <= 7'h67;  // 103
      5'd18: ST_PG <= 7'h6D;  // 109
      5'd19: ST_PG <= 7'h73;  // 115
      5'd20: ST_PG <= 7'h79;  // 121
      default: ST_PG <= 7'h7F;
   endcase
end

// State machine for sending Configuration Registers to the Flash //
always @(posedge CLK or posedge RST)
begin: SC1_FSM     // Send Cnfg; Sequence for sending Configuration info to Flash controller
   if(RST)
      SC1_ST <= `SC1_Idle;
   else
      case(SC1_ST)
         `SC1_Idle:
            if(SND_CNFG_ENA)
               SC1_ST <= `SC1_Req_Snd;
            else
               SC1_ST <= `SC1_Idle;
         `SC1_Req_Snd:
            if(FL_HOLD)
               SC1_ST <= `SC1_Req_Snd;
            else
               SC1_ST <= `SC1_Hdr1;
         `SC1_Hdr1:
            SC1_ST <= `SC1_Hdr2c;
         `SC1_Hdr2c:
            SC1_ST <= `SC1_Cnfg_LoadA;
         `SC1_Cnfg_LoadA:
            SC1_ST <= `SC1_Cnfg_ShiftA;
         `SC1_Cnfg_ShiftA:
            if(HOLD3)
               if(RND == 4)
                  SC1_ST <= `SC1_Cnfg_ShiftC;
               else
                  SC1_ST <= `SC1_Cnfg_ShiftB;
            else
               SC1_ST <= `SC1_Cnfg_ShiftA;
         `SC1_Cnfg_ShiftB:
            if(SHIFT_DONE)
               SC1_ST <= `SC1_Cnfg_LoadB;
            else
               SC1_ST <= `SC1_Cnfg_ShiftB;
         `SC1_Cnfg_LoadB:
            SC1_ST <= `SC1_Cnfg_ShiftA;
         `SC1_Cnfg_ShiftC:
            if(SHIFT_DONE)
               SC1_ST <= `SC1_Pipe;
            else
               SC1_ST <= `SC1_Cnfg_ShiftC;
         `SC1_Pipe:
            SC1_ST <= `SC1_Done;
         `SC1_Done:
            SC1_ST <= `SC1_Idle;
         default:
            SC1_ST <= `SC1_Idle;
      endcase      
end



always @(SC1_ST)
begin
   case(SC1_ST)
      `SC1_Hdr1,
      `SC1_Hdr2c,
      `SC1_Cnfg_LoadA,
      `SC1_Cnfg_LoadB,
      `SC1_Cnfg_ShiftA,
      `SC1_Cnfg_ShiftB:
         ENA_CNFG <= 1;
      default:
         ENA_CNFG <= 0;
   endcase
end
always @(SC1_ST)
begin
   case(SC1_ST)
      `SC1_Cnfg_ShiftA,
      `SC1_Cnfg_ShiftB,
      `SC1_Cnfg_ShiftC,
      `SC1_Cnfg_LoadB,
      `SC1_Pipe:
         RA_ENA_CNFG <= 1;
      default:
         RA_ENA_CNFG <= 0;
   endcase
end


always @(SC1_ST)
begin
   case(SC1_ST)
      `SC1_Hdr2c,
      `SC1_Cnfg_LoadA,
      `SC1_Cnfg_LoadB,
      `SC1_Cnfg_ShiftA,
      `SC1_Cnfg_ShiftB,
      `SC1_Cnfg_ShiftC,
      `SC1_Pipe:
         DV_CNFG <= 1;
      default:
         DV_CNFG <= 0;
   endcase
end


always @(posedge CLK or posedge RND_RST)
begin
   if(RND_RST)
      RND <= 3'h0;
   else
      if(INC_RND)
         RND <= RND + 1;
      else
         RND <= RND;
end



//////////////////////////////////////////////////////////////
//                                                          //
// ROM for initializing MAC memories when there is no       //
// valid default configuration in the Flash memory          //
//                                                          //
//////////////////////////////////////////////////////////////

always @(posedge CLK)
begin: MAC_defaults
   case(MAC_INI_CNT)
      4'h0: MAC_INI <= `Dflt_MAC0;
      4'h1: MAC_INI <= `Dflt_MAC1;
      4'h2: MAC_INI <= `Dflt_MAC2;
      4'h3: MAC_INI <= `Dflt_MAC3;
      4'h4: MAC_INI <= `Dflt_MAC4;
      4'h5: MAC_INI <= `Dflt_MAC5;
      4'h6: MAC_INI <= `Dflt_MAC6;
      4'h7: MAC_INI <= `Dflt_MAC7;
      4'h8: MAC_INI <= `Dflt_MAC8;
      4'h9: MAC_INI <= `Dflt_MAC9;
      4'hA: MAC_INI <= `Dflt_MACA;
      4'hB: MAC_INI <= `Dflt_MACB;
      4'hC: MAC_INI <= `Dflt_MACC;
      4'hD: MAC_INI <= `Dflt_MACD;
      4'hE: MAC_INI <= `Dflt_MACE;
      4'hF: MAC_INI <= 21'h12FFFF;
      default: MAC_INI <= 21'h12FFFF;
   endcase
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      MAC_INI_CNT <= 4'h0;
   else
      if(HRDW_INI && HRDW_INI_DONE)
         MAC_INI_CNT <= 4'h0;
      else if(HRDW_INI)
         MAC_INI_CNT <= MAC_INI_CNT + 1;
      else 
         MAC_INI_CNT <= MAC_INI_CNT;
end

endmodule
