`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"
`endif

module eth_cp(CLK, RST, CP_RST, SEL, PASS_THRU, MSG_LVL, 
              RCTRL, RCVDATA, BG, NORM_AF, PRIO_AF, PREP4SHTDWN,
              MAC_REQ, FRAME_REQ, BR, RST_SEQ, TXCAT, TXINSTR, TXDATA, RDY4SHTDWN,
              USR_LED_REG);

   input CLK;
   input RST;
   input CP_RST;
   input SEL;
   input PASS_THRU;
   input [1:0] MSG_LVL;
   input [2:0] RCTRL;
   input [15:0] RCVDATA;
   input BG;
   input NORM_AF;//TXSTATUS[9]
   input PRIO_AF;//TXSTATUS[5]
   input PREP4SHTDWN;
   
   output MAC_REQ;
   output FRAME_REQ;
   output BR;
   output RST_SEQ;
   output [1:0] TXCAT;
   output [2:0] TXINSTR;
   output [15:0] TXDATA;
   output RDY4SHTDWN;
   output [31:0] USR_LED_REG;
   
reg MAC_REQ;
reg FRAME_REQ;
wire BR;
reg RST_SEQ;
reg [1:0] TXCAT;
reg [2:0] TXINSTR;
reg [15:0] TXDATA;
wire RDY4SHTDWN;
reg [31:0] USR_LED_REG;


reg [7:0] FUNCT;
reg ACK;
reg PRIO;
reg ETH_RNG;
reg ETH_DEF;
reg [3:0] ETH_CP_ST;
wire [3:0] ETH_TXP_ST;
reg [1:0] CAT_MUX;
reg [2:0] INSTR_MUX;
reg [15:0] DATA_MUX;
reg [2:0]  CTRL,CTRL_R;
reg [15:0] DATA,DATA_R;
reg [15:0] NWRD_CNT_R;
reg [15:0] MAC_HDR_SRL_R;
reg [15:0] SRL_IN_DAT;
reg [1:0]  SRL_IN_BITS;
reg M_BIT;
reg H_BIT;
reg VALDAT_R;
reg D2;
reg CP_BR;
wire TXP_BR;
reg [7:0] TYPE;
reg [3:0] STATUS;
reg [11:0] ST_TY;
reg [15:0] RCV_ERR_WRD1,RCV_ERR_WRD2;
reg [15:0] ERR_HDR;
reg MSRL2,MSRL3,MSRL4,MAC_DONE;
reg BC1,BUS_CLR;
reg NWRD_CNT_ENA;
reg DATA_DONE;
reg RCV_ERR;
reg INTR_ERR,MID_ERR,FATAL_ERR;
reg UNASSIGNED;
reg NOT_DEFINED;
reg SEL_ERR;
reg SEL_ERR_R;
reg SE1,SE2,SE3;
reg DATA_FLAG;
reg TXP_DATA_R;
reg STAT_R;
reg SND_PKT_R;
reg GET_FRAME_R;

wire [15:0] MAC_HDR_SRL;
wire [1:0]  MHBITS_SRL;
wire [31:0] NWRD_REG;
wire [15:0] NWRD_CNT;
wire PMHSRL;
wire RD_SRL;
wire MBIT;
wire HBIT;
wire RST_SEQ_ID;
wire LOAD_USR_LED_HIGH;
wire LOAD_USR_LED_LOW;
wire LOAD_NWRD_REG_HIGH;
wire LOAD_NWRD_REG_LOW;
wire RST_NWRD;
wire RST_ERR_WRD;
wire RST_INTR_ERR;
wire CLR_INTR_ERR;
wire RCV_ERR1,RCV_ERR2;
wire NWRD_CNT_ENA_HIGH;
wire NWRD_DONE;
wire RTN_DATA;
wire VALDAT;
wire D1;
wire OPCODE;
wire EOP;
wire LPBCK;
wire SND_N;
wire GET_FUNCT;
wire GET_FRAME;
wire CP_INI_STAT;
wire CP_FIN_STAT;
wire TXP_INI_STAT;
wire TXP_MID_STAT;
wire TXP_INC_STAT;
wire TXP_FIN_STAT;
wire STAT;
wire CP_SND_PKT;
wire TXP_SND_PKT;
wire SND_PKT;
wire DONE;
wire MSRL1;
wire FLUSH;
wire S_DATA, S_ACK, S_ERR;
wire ERR;
wire SE0;
wire MOMENTARY_ERR_CNDT;
wire FATAL_ERR_CNDT;
wire WARN;
wire START_TXP;

assign MOMENTARY_ERR_CNDT = 0;
assign FATAL_ERR_CNDT = 0;
assign WARN = 0;
assign ERR = (RCV_ERR || MID_ERR || FATAL_ERR || UNASSIGNED || NOT_DEFINED) && (MSG_LVL > 2'h0);
assign SE0 = SEL_ERR && !SEL_ERR_R;

assign VALDAT     = (CTRL == `Rx_Data);
assign OPCODE     = (CTRL == `Rx_OpCode);
assign EOP        = (CTRL == `Rx_EOP);
assign MBIT       = (CTRL == `Rx_MAC);
assign HBIT       = (CTRL == `Rx_HDR);
assign RCV_ERR1   = (CTRL == `Rx_ErrWrd1);
assign RCV_ERR2   = (CTRL == `Rx_ErrWrd2);
assign LPBCK      = (FUNCT == `Loopback);
assign RST_SEQ_ID = (FUNCT == `Rst_Seq_ID);
assign SND_N      = (FUNCT == `Send_N_Words);
assign RTN_DATA   = (FUNCT == `Send_N_Words); // || (other commands with data expected)

assign IDLE         = (ETH_CP_ST  == `Eth_CP_Idle);
assign GET_FUNCT    = (ETH_CP_ST  == `Eth_CP_Get_Funct);
assign GET_FRAME    = (ETH_CP_ST  == `Eth_CP_Get_Frame);
assign S_DATA       = (ETH_CP_ST  == `Eth_CP_Send_Data);
assign S_ACK        = (ETH_CP_ST  == `Eth_CP_Send_Ack);
assign S_ERR        = (ETH_CP_ST  == `Eth_CP_Gen_Err_Pkt);
assign CP_INI_STAT  = (ETH_CP_ST  == `Eth_CP_Ini_Stat);
assign CP_FIN_STAT  = (ETH_CP_ST  == `Eth_CP_Fin_Stat);
assign CP_SND_PKT   = (ETH_CP_ST  == `Eth_CP_Send_Pkt);
assign RDY4SHTDWN   = (ETH_CP_ST  == `Eth_CP_Rdy4Shtdwn);

assign MSRL1        = (ETH_TXP_ST == `TxP_MAC);
assign TXP_INI_STAT = (ETH_TXP_ST == `TxP_Ini_Stat);
assign TXP_MID_STAT = (ETH_TXP_ST == `TxP_Mid_Stat);
assign TXP_INC_STAT = (ETH_TXP_ST == `TxP_Inc_Stat);
assign TXP_FIN_STAT = (ETH_TXP_ST == `TxP_Fin_Stat);
assign TXP_SND_PKT  = (ETH_TXP_ST == `TxP_Send_Pkt);
assign FLUSH        = (ETH_TXP_ST == `TxP_Flush);
assign DONE         = (ETH_TXP_ST == `TxP_Done);

assign START_TXP = S_DATA || S_ACK || S_ERR;
assign STAT = CP_INI_STAT || CP_FIN_STAT || TXP_INI_STAT || TXP_MID_STAT || TXP_INC_STAT || TXP_FIN_STAT;
assign BR  = CP_BR || TXP_BR;
assign SND_PKT  = CP_SND_PKT || TXP_SND_PKT;
assign RD_SRL = MSRL1; 
assign PMHSRL = MBIT || HBIT || RD_SRL; 
assign D1 = VALDAT && !VALDAT_R;
assign LOAD_USR_LED_HIGH  = D1 && (FUNCT == `Load_User_Reg);
assign LOAD_USR_LED_LOW   = D2 && (FUNCT == `Load_User_Reg);
assign LOAD_NWRD_REG_HIGH = D1 && (FUNCT == `Send_N_Words);
assign LOAD_NWRD_REG_LOW  = D2 && (FUNCT == `Send_N_Words);
assign RST_NWRD = LOAD_NWRD_REG_HIGH || RST;
assign RST_ERR_WRD = IDLE || RST;
assign CLR_INTR_ERR = (ETH_TXP_ST == `TxP_Clr_Intr);
assign RST_INTR_ERR = CLR_INTR_ERR || RST;
assign NWRD_CNT_ENA_HIGH = NWRD_CNT_ENA && (NWRD_REG[15:0] == 16'h0000);
assign NWRD_DONE    = (NWRD_REG == 32'h00000000);

/////////////////////////
// Input Registers     //
/////////////////////////

always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         FUNCT <= 8'h00;
         ACK   <= 0;
         PRIO  <= 0;
      end
   else
      if(SEL && (RCTRL == `Rx_OpCode) && GET_FUNCT) // this is RCTRL not CTRL
         begin
            FUNCT <= RCVDATA[7:0];
            ACK   <= RCVDATA[13];
            PRIO  <= RCVDATA[14];
         end
      else
         begin
            FUNCT <= FUNCT;
            ACK   <= ACK;
            PRIO  <= PRIO;
         end
end
always @(FUNCT)
begin
   casex(FUNCT)
      8'hFX:
         ETH_RNG <= 1;
      default:
         ETH_RNG <= 0;
   endcase
   case(FUNCT)
      `Rst_Seq_ID,`Force_Reload,`Send_N_Words,`Load_User_Reg,`Loopback:
         ETH_DEF <= 1;
      default:
         ETH_DEF <= 0;
   endcase
end

always @(posedge CLK)
begin
   DATA <= RCVDATA;
   DATA_R <= DATA;
   CTRL <= RCTRL;
   CTRL_R <= CTRL;
   VALDAT_R <= VALDAT;
   D2 <= D1;
   ST_TY <= {STATUS,TYPE};
   M_BIT <= MHBITS_SRL[1];
   H_BIT <= MHBITS_SRL[0];
   MSRL2 <= MSRL1;
   MSRL3 <= MSRL2;
   MSRL4 <= MSRL3;
   MAC_DONE <= MSRL4;
   MAC_HDR_SRL_R <= MAC_HDR_SRL;
   NWRD_CNT_R <= NWRD_CNT;
   BC1 <= FLUSH;
   BUS_CLR <= BC1;
   SEL_ERR_R <= SEL_ERR;
   SE1 <= SE0;
   SE2 <= SE1;
   SE3 <= SE2;
   TXP_DATA_R <= DATA_FLAG;
   RST_SEQ <= EOP && RST_SEQ_ID && !PASS_THRU;
   STAT_R <= STAT;
   SND_PKT_R <= SND_PKT;
   GET_FRAME_R <= GET_FRAME;
end

always @(posedge CLK or posedge RST_ERR_WRD)
begin
   if(RST_ERR_WRD)
      begin
         RCV_ERR_WRD1 <= 16'h0000;
         RCV_ERR_WRD2 <= 16'h0000;
         RCV_ERR <= 0;
      end
   else
      if(RCV_ERR1 && !PASS_THRU)
         begin
            RCV_ERR_WRD1 <= DATA;
            RCV_ERR_WRD2 <= RCV_ERR_WRD2;
            RCV_ERR <= 1;
         end
      else if(RCV_ERR2 && !PASS_THRU)
         begin
            RCV_ERR_WRD1 <= RCV_ERR_WRD1;
            RCV_ERR_WRD2 <= DATA;
            RCV_ERR <= 1;
         end
      else
         begin
            RCV_ERR_WRD1 <= RCV_ERR_WRD1;
            RCV_ERR_WRD2 <= RCV_ERR_WRD2;
            RCV_ERR <= RCV_ERR;
         end
end

always @(posedge CLK or posedge RST_ERR_WRD)
begin
   if(RST_ERR_WRD)
      begin
         UNASSIGNED <= 0;
         NOT_DEFINED <= 0;
      end
   else
      if(SEL && OPCODE && !PASS_THRU)
         case({ETH_RNG,ETH_DEF})
            2'b00:
               begin
                  UNASSIGNED <= 1;
                  NOT_DEFINED <= 0;
               end
            2'b10:
               begin
                  UNASSIGNED <= 0;
                  NOT_DEFINED <= 1;
               end
            default:
               begin
                  UNASSIGNED <= 0;
                  NOT_DEFINED <= 0;
               end
         endcase
      else
         begin
            UNASSIGNED <= UNASSIGNED;
            NOT_DEFINED <= NOT_DEFINED;
         end
end
always @(RCV_ERR or UNASSIGNED or NOT_DEFINED)
begin
   if(RCV_ERR)
      ERR_HDR <= {`Eth_Rcv,`HDR_Error,`ER_Rcv_Err};
   else if(UNASSIGNED)
      ERR_HDR <= {`Eth_Rcv,`HDR_Error,`CP_Un_Asgn};
   else if(NOT_DEFINED)
      ERR_HDR <= {`Eth_Rcv,`HDR_Error,`CP_Not_Def};
   else
      ERR_HDR <= {`Eth_Rcv,`HDR_Info,`G_No_Info};
end


always @(posedge CLK or posedge RST_INTR_ERR)
begin
   if(RST_INTR_ERR)
      INTR_ERR <= 0;
   else
      if(MOMENTARY_ERR_CNDT)
         INTR_ERR <= 1;
      else
         INTR_ERR <= INTR_ERR;
end
always @(posedge CLK or posedge RST_ERR_WRD)
begin
   if(RST_ERR_WRD)
      MID_ERR <= 0;
   else
      if(INTR_ERR)
         MID_ERR <= 1;
      else
         MID_ERR <= MID_ERR;
end
always @(posedge CLK or posedge RST_ERR_WRD)
begin
   if(RST_ERR_WRD)
      FATAL_ERR <= 0;
   else
      if(FATAL_ERR_CNDT)
         FATAL_ERR <= 1;
      else
         FATAL_ERR <= FATAL_ERR;
end

always @(posedge CLK)
begin
   if(RST)
     USR_LED_REG <= 32'h00000000;
   else if(LOAD_USR_LED_HIGH)
     USR_LED_REG <= {DATA,USR_LED_REG[15:0]};
   else if(LOAD_USR_LED_LOW)
     USR_LED_REG <= {USR_LED_REG[31:16],DATA};
   else
     USR_LED_REG <= USR_LED_REG;
end
always @(DATA or MBIT or HBIT or MAC_HDR_SRL or MHBITS_SRL)
begin  // mux for SRL input
   if(MBIT || HBIT)
      begin
         SRL_IN_DAT <= DATA;
         SRL_IN_BITS <= {MBIT,HBIT};
      end
   else
      begin
         SRL_IN_DAT <= MAC_HDR_SRL;
         SRL_IN_BITS <= MHBITS_SRL;
      end
end

macsrl  mh_srl(.clk(CLK),.ce(PMHSRL),.mhin(SRL_IN_BITS),.din(SRL_IN_DAT),.mhout(MHBITS_SRL),.dout(MAC_HDR_SRL));

defparam Send_N_Reg_Low.width = 16;
defparam Send_N_Reg_High.width = 16;
defparam N_word_cnt.width = 16;

cnt_dn_l  Send_N_Reg_Low (.clk(CLK),.dec(NWRD_CNT_ENA),.r(RST),.l(LOAD_NWRD_REG_LOW),.din(DATA),.count(NWRD_REG[15:0]));
cnt_dn_l  Send_N_Reg_High (.clk(CLK),.dec(NWRD_CNT_ENA_HIGH),.r(RST),.l(LOAD_NWRD_REG_HIGH),.din(DATA),.count(NWRD_REG[31:16]));
cnt_up    N_word_cnt (.clk(CLK),.inc(NWRD_CNT_ENA),.r(RST_NWRD),.count(NWRD_CNT));


/////////////////////////////////////////
// Command Processor State Machines    //
/////////////////////////////////////////
always @(posedge CLK or posedge CP_RST)
begin: Eth_CP_FSM
   if(CP_RST)
      ETH_CP_ST <= `Eth_CP_Idle;
   else
      case(ETH_CP_ST)
         `Eth_CP_Idle:
            if(SEL)
               ETH_CP_ST<= `Eth_CP_Get_Funct;
            else if(PREP4SHTDWN)
               ETH_CP_ST <= `Eth_CP_Rdy4Shtdwn;
            else
               ETH_CP_ST <= `Eth_CP_Idle;
         `Eth_CP_Get_Funct:
            if(OPCODE)
               ETH_CP_ST<= `Eth_CP_Need_Bus;
            else
               ETH_CP_ST <= `Eth_CP_Get_Funct;
         `Eth_CP_Need_Bus:
            if(PASS_THRU || LPBCK)
               ETH_CP_ST<= `Eth_CP_Req_Bus;
            else
               ETH_CP_ST <= `Eth_CP_Get_Frame;
         `Eth_CP_Req_Bus:
            if(BG)
               ETH_CP_ST<= `Eth_CP_Ini_Stat;
            else
               ETH_CP_ST <= `Eth_CP_Req_Bus;
         `Eth_CP_Ini_Stat:
            ETH_CP_ST <= `Eth_CP_Get_Frame;
         `Eth_CP_Get_Frame:
            if(EOP)
               if(PASS_THRU || LPBCK)
                  ETH_CP_ST<= `Eth_CP_Fin_Stat;
               else if(ERR)
                  ETH_CP_ST <= `Eth_CP_Gen_Err_Pkt;
               else if(RTN_DATA)
                  ETH_CP_ST <= `Eth_CP_Send_Data;
               else if(ACK)
                  ETH_CP_ST <= `Eth_CP_Send_Ack;
               else
                  ETH_CP_ST <= `Eth_CP_Idle;
            else
               ETH_CP_ST <= `Eth_CP_Get_Frame;
         `Eth_CP_Fin_Stat:
            ETH_CP_ST <= `Eth_CP_Send_Pkt;
         `Eth_CP_Send_Pkt:
            ETH_CP_ST <= `Eth_CP_Rel_Bus;
         `Eth_CP_Rel_Bus:
            if(!BG && !ERR)
               ETH_CP_ST<= `Eth_CP_Idle;
            else if(!BG && ERR)
               ETH_CP_ST<= `Eth_CP_Gen_Err_Pkt;
            else
               ETH_CP_ST <= `Eth_CP_Rel_Bus;
         `Eth_CP_Send_Data:
            if(DONE && !ERR)
               ETH_CP_ST<= `Eth_CP_Idle;
            else if(DONE && ERR)
               ETH_CP_ST<= `Eth_CP_Rel_Snd;
            else
               ETH_CP_ST <= `Eth_CP_Send_Data;
         `Eth_CP_Send_Ack:
            if(DONE && !ERR)
               ETH_CP_ST<= `Eth_CP_Idle;
            else if(DONE && ERR)
               ETH_CP_ST<= `Eth_CP_Rel_Snd;
            else
               ETH_CP_ST <= `Eth_CP_Send_Ack;
         `Eth_CP_Rel_Snd:
            if(!DONE)
               ETH_CP_ST<= `Eth_CP_Gen_Err_Pkt;
            else
               ETH_CP_ST <= `Eth_CP_Rel_Snd;
         `Eth_CP_Gen_Err_Pkt:
            if(DONE)
               ETH_CP_ST<= `Eth_CP_Idle;
            else
               ETH_CP_ST <= `Eth_CP_Gen_Err_Pkt;
         `Eth_CP_Rdy4Shtdwn:
            ETH_CP_ST <= `Eth_CP_Rdy4Shtdwn;
         default:
            ETH_CP_ST <= `Eth_CP_Idle;
      endcase
end

always @(ETH_CP_ST or PASS_THRU or LPBCK)
begin
   case(ETH_CP_ST)
      `Eth_CP_Req_Bus,`Eth_CP_Ini_Stat,`Eth_CP_Fin_Stat,`Eth_CP_Send_Pkt:
         CP_BR <= 1;
      `Eth_CP_Get_Frame:
         CP_BR <= PASS_THRU || LPBCK;
      default:
         CP_BR <= 0;
   endcase
end

/////////////////////////////////////////
// Transmit Processor State Machine    //
/////////////////////////////////////////

trans_proc Eth_Txp_FSM(.clk(CLK), .rst(RST), .start(START_TXP), .bg(BG), .mac_done(MAC_DONE),
           .intr_err(INTR_ERR), .fatal_err(FATAL_ERR), .s_err(S_ERR), .data_done(DATA_DONE),
           .bus_clr(BUS_CLR), .hndshk(!START_TXP), .txp_st(ETH_TXP_ST), .br(TXP_BR));

always @(ETH_TXP_ST or S_ERR or S_ACK or S_DATA or SND_N or NWRD_DONE or NWRD_CNT_ENA or
         PRIO or PRIO_AF or NORM_AF or INTR_ERR or RCV_ERR or SE0 or SE2)
begin
   case(ETH_TXP_ST)
      `TxP_Data:
         begin
            if(S_DATA && SND_N)
               begin
                  SEL_ERR <= 0;
                  DATA_DONE <= NWRD_DONE;
                  DATA_FLAG <= NWRD_CNT_ENA;
                  if(PRIO)
                     NWRD_CNT_ENA <= !(NWRD_DONE || PRIO_AF || INTR_ERR);
                  else
                     NWRD_CNT_ENA <= !(NWRD_DONE || NORM_AF || INTR_ERR);
               end
//            else if(S_DATA && ...) //additional FUNCTIONS.
//               begin
//                  SEL_ERR <= 0;
//                  DATA_DONE <= 0;
//                  DATA_FLAG <= 0;
//                  NWRD_CNT_ENA <= 0;
//               end
            else if(S_ACK)
               begin
                  SEL_ERR <= 0;
                  DATA_DONE <= 1;
                  DATA_FLAG <= 0;
                  NWRD_CNT_ENA <= 0;
               end
            else if(S_ERR)
               begin
                  SEL_ERR <= 1;
                  DATA_DONE <= RCV_ERR ? SE2 : SE0;
                  DATA_FLAG <= 1;
                  NWRD_CNT_ENA <= 0;
               end
            else
               begin
                  SEL_ERR <= 0;
                  DATA_DONE <= 0;
                  DATA_FLAG <= 0;
                  NWRD_CNT_ENA <= 0;
               end
         end
      default:
         begin
            SEL_ERR <= 0;
            DATA_DONE <= 0;
            DATA_FLAG <= 0;
            NWRD_CNT_ENA <= 0;
         end
   endcase
end

always @(S_ERR or PASS_THRU or LPBCK or FUNCT or RTN_DATA)
begin
   if(S_ERR)
      TYPE <= `Rtn_Err_Pkt;
   else if(PASS_THRU || LPBCK)
      TYPE <= `Rtn_LpBck_Pkt;
   else if (FUNCT == `Send_N_Words)
      TYPE <= `Rtn_TXNW_Pkt;
   else if (!RTN_DATA) //Acknowledge packets with no data
      TYPE <= `Rtn_NoDat_Pkt;
   else
      TYPE <= `Rtn_EthNet_Pkt; // Default Ethernet module return type;
end

always @(CP_INI_STAT or CP_FIN_STAT or TXP_INI_STAT or TXP_MID_STAT or TXP_INC_STAT or TXP_FIN_STAT or ERR or WARN or S_ERR)
begin
   if(CP_INI_STAT || TXP_INI_STAT)
      STATUS <= `CiP;
   else if (TXP_MID_STAT)
      if(ERR)
         STATUS <= `CiP_E;
      else if(WARN)
         STATUS <= `CiP_W;
      else
         STATUS <= `CiP;
   else if (TXP_INC_STAT)
      STATUS <= `CE_I;
   else if (CP_FIN_STAT || TXP_FIN_STAT)
      if(S_ERR)
         STATUS <= `No_Ack;
      else 
         if(ERR)
            STATUS <= `CC_E;
         else if(WARN)
            STATUS <= `CC_W;
         else
            STATUS <= `CC_S;
   else
      STATUS <= `No_Ack;
end


always @(DATA_R or STAT_R or ST_TY or MSRL2 or NWRD_CNT_R or TXP_DATA_R or MAC_HDR_SRL_R or
         PASS_THRU or LPBCK or SND_N or S_DATA or S_ERR or SE1 or SE2 or SE3 or ERR_HDR or
         RCV_ERR or RCV_ERR_WRD1 or RCV_ERR_WRD2)
begin
   if(STAT_R)
      DATA_MUX <= {4'h0,ST_TY};
   else if (PASS_THRU || LPBCK)
      DATA_MUX <= DATA_R;
   else if (MSRL2)
      DATA_MUX <= MAC_HDR_SRL_R;
   else if (TXP_DATA_R && S_DATA && SND_N)
      DATA_MUX <= NWRD_CNT_R;
   else if (TXP_DATA_R && S_ERR && SE1)
      DATA_MUX <= ERR_HDR;
   else if (TXP_DATA_R && S_ERR && SE2)
      DATA_MUX <= RCV_ERR ? RCV_ERR_WRD1 : 16'h0000;
   else if (TXP_DATA_R && S_ERR && SE3)
      DATA_MUX <= RCV_ERR ? RCV_ERR_WRD2 : 16'h0000;
   else
      DATA_MUX <= DATA_R;
end


always @(STAT_R or MSRL2 or H_BIT or GET_FRAME_R or CTRL_R or TXP_DATA_R or PASS_THRU or LPBCK or SND_PKT_R)
begin
   if(STAT_R)
      INSTR_MUX <= `Tx_AST;
   else if (MSRL2)
      if(H_BIT)
         INSTR_MUX <= `Tx_Head;
      else
         INSTR_MUX <= `Tx_MAC;
   else if (GET_FRAME_R)
      if (PASS_THRU || LPBCK)
         case(CTRL_R)
            `Rx_Data:
               INSTR_MUX <= `Tx_Data;
            `Rx_MAC:
               INSTR_MUX <= `Tx_MAC;
            `Rx_HDR:
               INSTR_MUX <= `Tx_Head;
            default:
               INSTR_MUX <= `Tx_NoData;
         endcase
      else
         INSTR_MUX <= `Tx_NoData;
   else if (TXP_DATA_R)
      INSTR_MUX <= `Tx_Data;
   else if (SND_PKT_R)
      INSTR_MUX <= `Tx_Send;
   else
      INSTR_MUX <= `Tx_NoData;
end

always @(S_ERR or PRIO)
begin
   if(S_ERR)
      CAT_MUX <= `Tx_Spont_Cat;
   else if (PRIO)
      CAT_MUX <= `Tx_Prio_Cat;
   else
      CAT_MUX <= `Tx_Norm_Cat;
end

/////////////////////////
// Output Registers    //
/////////////////////////

always @(posedge CLK)
begin
   if(SEL)
      begin
         MAC_REQ   = GET_FRAME;
         FRAME_REQ = GET_FRAME;
      end
   else
      begin
         MAC_REQ   = 1'bZ;
         FRAME_REQ = 1'bZ;
      end
end
always @(posedge CLK)
begin
   if(BG)
      begin
         TXDATA  <= DATA_MUX;
         TXINSTR <= INSTR_MUX;
         TXCAT   <= CAT_MUX;
      end
   else
      begin
         TXDATA  <= 16'hZZZZ;
         TXINSTR <= 3'oZ;
         TXCAT   <= 2'bZZ;
      end
end

endmodule
