`timescale 1ns / 1ps

`ifndef HEADER
`include "header.v"
`endif

module ext_fifo_intrf(CLK, RST, FF_RST, CP_RST, INJ_ERRS, ECC_ENA, TEST_MODE, SW2, MSG_LVL,
      SEL, RCTRL, RCVDATA, BG, VREAD, VRFUNCT, PREP4SHTDWN,
      FROM_FIFO, FF_IN_RDY_B, FF_PAF_B, FF_HF_B, FF_PAE_B, FF_OUT_RDY_B,
//
      FRAME_REQ, MAC_REQ, BR, TXDATA, TXCTRL,
      TO_VME, F2V_ODV, F2V_RHOLD, F2V_OUT_RDY, FLSHD, F2V_RD_ERR, RDY4SHTDWN, MRSTDONE,
//
      FF_MRS_B, FF_PRS_B, FF_TRESET, TO_FIFO,
      FF_WCLK, FF_WEN_B, FF_WCS_B,
      FF_RCLK, FF_REN_B, FF_RCS_B, FF_OE_B, FF_MARK, FF_RT_B,
      FF_SCLK, FF_SEN_B, FF_FWFT_SI,  FF_LD_B, 
//      
      TEST_A, TEST_B, TEST_C);

    input CLK;
    input RST;
    input FF_RST;
    input CP_RST;
    input INJ_ERRS;
    input ECC_ENA;
    input TEST_MODE;
    input [3:0] SW2;
    input [1:0] MSG_LVL;
    input SEL;
    input [2:0] RCTRL;
    input [15:0] RCVDATA;
    input BG;
    input VREAD;
    input [3:0]VRFUNCT;
    input PREP4SHTDWN;
//
    input [35:0] FROM_FIFO;
    input FF_IN_RDY_B;
    input FF_PAF_B;
    input FF_HF_B;
    input FF_PAE_B;
    input FF_OUT_RDY_B;
//
   output FRAME_REQ;
   output MAC_REQ;
   output BR;
   output [15:0] TXDATA;
   output [4:0] TXCTRL;
   output [17:0] TO_VME;
   output F2V_ODV;
   output F2V_RHOLD;
   output F2V_OUT_RDY;
   output FLSHD;
   output F2V_RD_ERR;
   output RDY4SHTDWN;
   output MRSTDONE;
//
   output FF_MRS_B;
   output FF_PRS_B;
   output FF_TRESET;
   output [35:0] TO_FIFO;
   output FF_WCLK;
   output FF_WEN_B;
   output FF_WCS_B;
   output FF_RCLK;
   output FF_REN_B;
   output FF_RCS_B;
   output FF_OE_B;
   output FF_MARK;
   output FF_RT_B;
   output FF_SCLK;
   output FF_SEN_B;
   output FF_FWFT_SI;
   output FF_LD_B;
   output [15:0] TEST_A;
   output [15:0] TEST_B;
   output [15:0] TEST_C;
   

reg  FRAME_REQ;
reg  MAC_REQ;
wire BR;
reg  [15:0] TXDATA;
reg  [4:0] TXCTRL;
reg  [17:0] TO_VME;
reg  F2V_ODV;
wire F2V_RHOLD;
reg  F2V_OUT_RDY;
wire FLSHD;
wire F2V_RD_ERR;
wire RDY4SHTDWN;
wire MRSTDONE;

wire FF_MRS_B;
wire FF_PRS_B;
wire FF_TRESET;
reg  [35:0] TO_FIFO;
wire FF_WCLK;
reg  FF_WEN_B;
wire FF_WCS_B;
wire FF_RCLK;
reg  FF_REN_B;
wire FF_RCS_B;
wire FF_OE_B;
reg  FF_MARK;
reg  FF_RT_B;
wire FF_SCLK;
wire FF_SEN_B;
wire FF_FWFT_SI;
wire FF_LD_B;

reg  [15:0] TEST_A;
reg  [15:0] TEST_B;
reg  [15:0] TEST_C;

//////////////////////////////////////////////////////////////////////////////


reg [4:0] FCP_ST;
reg [4:0] EXFF_WR_ST;
reg [4:0] EXFF_RD_ST;
reg [35:0] OFFSET;
reg [11:0] RD_TMR;
reg [15:0] DATA_IN1;
reg [15:0] DATA_IN2;
reg [15:0] DAT_BOD;
reg [35:0] FROM_FIFO1;
reg [31:0] UN_COR_ERR_REG;
reg [31:0] COR_ERR_REG;
reg [3:0] FF_MJ_DCD;
reg [9:0] INJ_CNT;
reg [3:0] FFH1,FFH2,FFH3,FFH4,FFH5,FFH6;
reg [2:0] WFUNCT;
reg [3:0] LRFUNCT;

reg RDE1,RDE2,RDE3,RDE4,RDE5,RDE6;
reg ODV1,ODV2,ODV3,ODV4,ODV5,ODV6,ODV7;
reg FDV1,FDV2,FDV3,FDV4,FDV5,FDV6,FDV7;
reg ORH0,ORH1,ORH2,ORH3,ORH4,ORH5,ORH6;
reg MTCH1,MTCH2,MTCH3,MTCH4,MTCH5,MTCH6;
reg NE1,NE2,NE3,NE4,NE5,NE6;
reg MRST1,MRST2,MRST3;
reg PRST1,PRST2,PRST3;
reg PPMHVF1,PPMHVF2,PPMHVF3,PPMHVF4;
reg MHVF_DONE;
reg RD_END1,RD_END2,RD_END3,RD_END4,RD_END5,RD_END6,RD_END7;
reg L2,L3,L4;

reg DCD_DAT_VALID;
reg DRP_DAT_VALID;
reg OUT_DAT_VALID;
reg WEN1;
reg MARK;
reg INT_OUT_RDY;
reg OUT_RDY;
reg BEG_O_DATA;
reg MTCH2_OUT_OF_3;
reg NE3_OUT_OF_3;
reg WLOAD;
reg RLOAD;
reg CAP_OFF1;
reg CAP_OFF2;

reg [7:0] FUNCT;
reg [1:0] CAT_MUX;
reg [2:0] INSTR_MUX;
reg [15:0] DATA_MUX;
reg [2:0]  CTRL;
reg [15:0] RXDATA;
reg [15:0] DATA_OUT;
reg [15:0] MAC_HDR_SRL_R;
reg [15:0] SRL_IN_DAT;
reg [1:0]  SRL_IN_BITS;
reg [7:0] TYPE;
reg [3:0] STATUS;
reg [11:0] ST_TY;
reg [15:0] RCV_ERR_WRD1,RCV_ERR_WRD2;
reg [15:0] ERR_HDR;
reg [31:0] RCNT;

reg ACK;
reg PRIO;
reg FF_DEF;
reg RCV_ERR;
reg RF;
reg WF;
reg H_BIT;
reg HDR_DN;
reg MSRL2,MSRL3,MSRL4,MAC_DONE;
reg BC1,BUS_CLR;
reg DATA_DONE;
reg INTR_ERR,MID_ERR,FATAL_ERR;
reg SEL_ERR_R;
reg SE1,SE2,SE3;
reg DATA_FLAG;
reg TXP_DATA_R;
reg STAT_R;
reg SND_PKT_R;
reg GET_FRAME_R;
reg SRL2FF1,SRL2FF2,SRL2FF3,SRL2FF4,SRLDONE;
reg FFVD_R;
reg D2;

///////////////////////////////////////////
wire [3:0] FF_TXP_ST;
wire [15:0] MAC_HDR_SRL;
wire [1:0]  MHBITS_SRL;
wire [11:0] ECC_PARITY;
wire [11:0] DCD_DATA;
wire [11:0] DCD_PARITY;
wire GOOD_WORD;
wire BAD_TX;
wire MHVF_MT;
wire MHVF_FULL;
wire MHVF_AMT;
wire MHVF_AF;
wire MHVF_WTERR;
wire MHVF_RDERR;
wire [17:0] MHVF_OUT;
wire [9:0] MHVF_CNT;
///////////////////////////////////////////
wire IN_RDY;
wire FF_OUT_RDY;
wire PAE;
wire PAF;
wire HF;
wire RD_TMOUT;
wire CLRL;
wire ERR_CNT_RST;
wire INJ_TYP1_NOW;
wire INJ_TYP2_NOW;
wire FUNCT_DONE;
///////////////////////////////////////////

wire MOMENTARY_ERR_CNDT;
wire FATAL_ERR_CNDT;
wire VME_WARN;
wire WRT_WARN;
wire WARN;
wire VME_ERR;
wire ERR;
wire SEL_ERR;
wire SE0;
wire FFVD;
wire OPCODE;
wire EOP;
wire MBIT;
wire HBIT;
wire RCV_ERR1,RCV_ERR2;
wire D1;
wire RD_DATA_VALID;
wire RD_DONE;

wire GET_FUNCT;
wire GET_MAC;
wire DMY_GET;
wire LDRF;
wire LDWF;
wire GET_FRAME;
wire S_DATA;
wire S_ACK;
wire S_WARN;
wire S_ERR;
wire SRL2FF;
wire CLR_RWF;
wire LREAD;

wire MSRL1;
wire TXP_INI_STAT;
wire TXP_MID_STAT;
wire TXP_INC_STAT;
wire TXP_FIN_STAT;
wire TXP_DATA;
wire TXP_SND_PKT;
wire FLUSH;
wire DONE;
wire CLR_INTR_ERR;

wire START_TXP;
wire HND_SHK;
wire STAT;
wire RD_SRL;
wire SRL_CE;
wire ERWRAP;
wire [17:0]MHVF_IN;
wire RST_INTR_ERR;
wire ERR_RST;
wire RD_END;
///////////////////////////////////////////
wire FFW_IDLE;
wire SEL_BOD;
wire LOAD_BOD;
wire WEN;
wire WRT_ERR;
wire WHOLD;
wire L1_TO;
wire CLRL_TO;
wire LOAD1;
wire LOAD2;
wire PRGDONE;
wire PRSTDONE;
wire PU_RSM;
wire FWFT;
wire TRESET;
wire MRST;
wire PRST;
wire RST_ERR_CNT;
///////////////////////////////////////////
wire FFR_IDLE;
wire RD_ERR;
wire RT_ERR;
wire MT_ERR;
wire MK_ERR;
wire STM;
wire RSM;
wire SDV;
wire L1_FR;
wire CLRL_FR;
wire RBKDONE;
wire ERCNT;
wire RDOFF;
wire UPDTOFF1;
wire UPDTOFF2;
wire ENATMR;
wire REN;
wire RHOLD;
wire DRP;
wire RT;
wire POP_MHVF;

///////////////////////////////////////////
wire VME_CMD;
wire RD_FF;
wire RT_FF;
wire WRT_FF;
wire RD_BK;
wire LD_RCNT_HI;
wire LD_RCNT_LO;
wire RD_MHVF;

///////////////////////////////////////////
wire [3:0] RFUNCT;
wire READ;


// Assignments for output signals to FIFO ////////////////////////////////////////////////////////
   
assign  F2V_RHOLD = TEST_MODE ? 1'b1 : RHOLD;
assign      FLSHD = (EXFF_RD_ST == `Flush_Done);
assign F2V_RD_ERR = TEST_MODE ? 1'b0 : RD_ERR || MT_ERR;

assign   FF_MRS_B = !MRST;
assign   FF_PRS_B = !PRST;
assign  FF_TRESET = TRESET;
assign   FF_WCS_B = 0;
assign   FF_RCS_B = 0;
assign   FF_OE_B  = 0;
assign    FF_SCLK = 0;   
assign   FF_SEN_B = 1;
assign FF_FWFT_SI = FWFT;
assign    FF_LD_B =  !FWFT && !WLOAD && !RLOAD;

// Assignments for internal signals ////////////////////////////////////////////////////////

assign       IN_RDY = !FF_IN_RDY_B;
assign   FF_OUT_RDY = !FF_OUT_RDY_B;
assign          PAE = !FF_PAE_B;
assign          PAF = !FF_PAF_B;
assign           HF = !FF_HF_B;
assign     RD_TMOUT = (RD_TMR == `Ex_FF_Rd_TmOut);
assign         CLRL = CLRL_TO || CLRL_FR;
assign  ERR_CNT_RST = RST_ERR_CNT || RST;
assign INJ_TYP1_NOW = INJ_ERRS && ((INJ_CNT%128) == 10'h07F);
assign INJ_TYP2_NOW = INJ_ERRS && (INJ_CNT == 10'h3FF);
assign   FUNCT_DONE = PRGDONE || RBKDONE || MRSTDONE || PRSTDONE || RST_ERR_CNT ||
                      FLSHD || STM || RSM && (RFUNCT == `RST_MK_FF) || MK_ERR;

// Command Processor state signals /////////////////////////////////////////////////////////////////////

assign MOMENTARY_ERR_CNDT = 0;
assign FATAL_ERR_CNDT = RT_ERR || MT_ERR || RD_ERR;
assign VME_WARN = (VME_CMD && TEST_MODE) && (MSG_LVL > 2'h1);
assign WRT_WARN = (WRT_FF && !VME_CMD && !TEST_MODE) && (MSG_LVL > 2'h1);
assign WARN = (PAF || VME_WARN || WRT_WARN) && (MSG_LVL > 2'h1);
assign VME_ERR = (RF && !TEST_MODE);
assign ERR = (RCV_ERR || WRT_ERR || MK_ERR || MID_ERR || FATAL_ERR || VME_ERR || !FF_DEF) && (MSG_LVL > 2'h0);
assign SEL_ERR = (FF_TXP_ST == `TxP_Data) && S_ERR;
assign SE0 = SEL_ERR && !SEL_ERR_R;

assign FFVD       = (CTRL == `Rx_Data);
assign OPCODE     = (CTRL == `Rx_OpCode);
assign EOP        = (CTRL == `Rx_EOP);
assign MBIT       = (CTRL == `Rx_MAC);
assign HBIT       = (CTRL == `Rx_HDR);
assign RCV_ERR1   = (CTRL == `Rx_ErrWrd1);
assign RCV_ERR2   = (CTRL == `Rx_ErrWrd2);
assign D1         = FFVD && !FFVD_R;
assign RD_DATA_VALID = ECC_ENA ? (ODV7 && !RDE6) || SDV : (ODV1 && !RD_ERR) || SDV;
assign RD_DONE    = ECC_ENA ? RD_END7 : RD_END1;

assign GET_FUNCT    = (FCP_ST  == `FCP_Get_Funct);
assign GET_MAC      = (FCP_ST  == `FCP_Get_MAC);
assign DMY_GET      = (FCP_ST  == `FCP_Dmy_Get);
assign LDRF         = (FCP_ST  == `FCP_Ld_RFunct);
assign LDWF         = (FCP_ST  == `FCP_Ld_WFunct);
assign GET_FRAME    = (FCP_ST  == `FCP_Get_Frame);
assign S_DATA       = (FCP_ST  == `FCP_Send_Data) || (FCP_ST  == `FCP_W4Hld) || (FCP_ST  == `FCP_ReadFF) || (FCP_ST  == `FCP_W4Done);
assign S_ACK        = (FCP_ST  == `FCP_Send_Ack);
assign S_WARN       = (FCP_ST  == `FCP_Send_Wrn);
assign S_ERR        = (FCP_ST  == `FCP_Send_Err) || S_WARN;
assign SRL2FF       = (FCP_ST  == `FCP_SRL2FF);
assign CLR_RWF      = (FCP_ST  == `FCP_Clr_RWF);
assign READFF       = (FCP_ST  == `FCP_ReadFF);
assign LREAD        = (FCP_ST  == `FCP_ReadFF) && !RD_END;
assign RDY4SHTDWN   = (FCP_ST  == `FCP_Rdy4Shtdwn);

assign MSRL1        = (FF_TXP_ST == `TxP_MAC);
assign TXP_INI_STAT = (FF_TXP_ST == `TxP_Ini_Stat);
assign TXP_MID_STAT = (FF_TXP_ST == `TxP_Mid_Stat);
assign TXP_INC_STAT = (FF_TXP_ST == `TxP_Inc_Stat);
assign TXP_FIN_STAT = (FF_TXP_ST == `TxP_Fin_Stat);
assign TXP_DATA     = (FF_TXP_ST == `TxP_Data);
assign TXP_SND_PKT  = (FF_TXP_ST == `TxP_Send_Pkt);
assign FLUSH        = (FF_TXP_ST == `TxP_Flush);
assign DONE         = (FF_TXP_ST == `TxP_Done);
assign CLR_INTR_ERR = (FF_TXP_ST == `TxP_Clr_Intr);

assign START_TXP = S_DATA || S_ACK || S_ERR;
assign HND_SHK = !START_TXP;
assign STAT = TXP_INI_STAT || TXP_MID_STAT || TXP_INC_STAT || TXP_FIN_STAT;
assign RD_SRL = MSRL1; 
assign SRL_CE = MBIT || HBIT || (SRL2FF && !ERWRAP) || RD_SRL; 
assign ERWRAP = SRL2FF && !SRL2FF1;
assign MHVF_IN = ERWRAP ? {14'h0000,ERR,WARN,ACK,PRIO} : {MHBITS_SRL,MAC_HDR_SRL};
assign RST_INTR_ERR = CLR_INTR_ERR || RST;
assign ERR_RST  = CLR_RWF || RST;
assign RD_END   = READFF && (RCNT == 31'h00000000);

// Write state signals /////////////////////////////////////////////////////////////////////
assign    FFW_IDLE = (EXFF_WR_ST == `FFW_Idle);
assign     SEL_BOD = (EXFF_WR_ST == `Enc_BOD);
assign    LOAD_BOD = (EXFF_WR_ST == `Load_BOD);
assign         WEN = (EXFF_WR_ST == `Write_FF);
assign     WRT_ERR = (EXFF_WR_ST == `Wrt_Err);
assign       WHOLD = !((EXFF_WR_ST == `W_Valdat1) || (EXFF_WR_ST == `Write_FF));
assign       L1_TO = (EXFF_WR_ST == `Load_Offsets);
assign     CLRL_TO = (EXFF_WR_ST == `Wrt_Off_to_1);
assign       LOAD1 = (EXFF_WR_ST == `Wrt_Off_to_1);
assign       LOAD2 = (EXFF_WR_ST == `Wrt_Off_to_2);
assign     PRGDONE = (EXFF_WR_ST == `Prg_Done);
assign    MRSTDONE = (EXFF_WR_ST == `MRst_Done);
assign    PRSTDONE = (EXFF_WR_ST == `PRst_Done);
assign      PU_RSM = (EXFF_WR_ST == `FFW_Rst_Mark);
assign        FWFT = (EXFF_WR_ST == `Set_FWFT) || (EXFF_WR_ST == `MRst_St) || (EXFF_WR_ST == `Hold_FWFT);
assign      TRESET = (EXFF_WR_ST == `FFW_Rst_Mark) || (EXFF_WR_ST == `Set_FWFT) || (EXFF_WR_ST == `MRst_St) || (EXFF_WR_ST == `Hold_FWFT);
assign        MRST = (EXFF_WR_ST == `MRst_St);
assign        PRST = (EXFF_WR_ST == `PRst_St);
assign RST_ERR_CNT = (EXFF_WR_ST == `Rst_Err_Cnt_St);

// Read state signals /////////////////////////////////////////////////////////////////////////////

assign FFR_IDLE = (EXFF_RD_ST == `FFR_Idle);
assign   RD_ERR = (EXFF_RD_ST == `FF_Rd_Err);
assign   RT_ERR = (EXFF_RD_ST == `ReTrans_Err);
assign   MT_ERR = (EXFF_RD_ST == `FF_MT_Err);
assign   MK_ERR = (EXFF_RD_ST == `FF_MK_Err);
assign      STM = (EXFF_RD_ST == `Set_Mark);
assign      RSM = (EXFF_RD_ST == `RST_Mark);
assign      SDV = (EXFF_RD_ST == `Send_Offsets) || (EXFF_RD_ST == `Send_Err_Cnts);
assign    L1_FR = (EXFF_RD_ST == `Send_Offsets) || (EXFF_RD_ST == `Send_Err_Cnts);
assign  CLRL_FR = (EXFF_RD_ST == `Rbk_Done);
assign  RBKDONE = (EXFF_RD_ST == `Rbk_Done);
assign    ERCNT = (EXFF_RD_ST == `Send_Err_Cnts);
assign    RDOFF = (EXFF_RD_ST == `Rd_Off) || (EXFF_RD_ST == `Rd_Off_Upd);
assign UPDTOFF1 = (EXFF_RD_ST == `Rd_Off_Upd);
assign UPDTOFF2 = (EXFF_RD_ST == `Update_Off);
assign   ENATMR = (EXFF_RD_ST == `Pause);
assign      REN = (EXFF_RD_ST == `Read_FF);
assign    RHOLD = !((EXFF_RD_ST == `Wait_for_Read) || (EXFF_RD_ST == `Read_FF));
assign      DRP = (EXFF_RD_ST == `Drop_Wrd) || (EXFF_RD_ST == `Flush_BOD);
assign       RT = (EXFF_RD_ST == `ReTrans);
assign POP_MHVF = (EXFF_RD_ST == `PoP_MHVF);

// Function Decodes /////////////////////////////////////////////////////////////////////////////

assign VME_CMD    = (FUNCT == `VME_Cmds);
assign RD_FF      = (LRFUNCT == `Rd_FF);
assign RT_FF      = (LRFUNCT == `RT_FF);
assign WRT_FF     = (WFUNCT == `Wrt_FF);
assign RD_BK      = (LRFUNCT == `Rdbk_Offsets) || (LRFUNCT == `Rd_Err_Cnts);
assign LD_RCNT_HI = D1 & (RD_FF || RT_FF);
assign LD_RCNT_LO = D2 & (RD_FF || RT_FF);
assign RD_MHVF    = (RFUNCT == `Read_MHVF);

// Multiplexers for VME or Test Mode ////////////////////////////////////////////////////////////////

assign   RFUNCT = TEST_MODE ? LRFUNCT : VRFUNCT;
assign   READ   = TEST_MODE ? LREAD : VREAD;


// Test point signals /////////////////////////////////////////////////////////////////////////////
always @(posedge CLK)
begin
   case (SW2)
      4'hA:
         begin
            TEST_A <= TO_FIFO[15:0];
            TEST_B <= TO_FIFO[31:16];
            TEST_C[3:0] <= TO_FIFO[35:32];
            TEST_C[4] <= FF_WEN_B;
            TEST_C[5] <= WRT_ERR;
            TEST_C[6] <= FF_REN_B;
            TEST_C[7] <= RD_ERR;
            TEST_C[10:8] <= WFUNCT[2:0];
            TEST_C[11] <= FF_IN_RDY_B;
            TEST_C[14:12] <= RFUNCT[2:0];
            TEST_C[15] <= FF_OUT_RDY_B;
         end
      4'hB:
         begin
            TEST_A <= FROM_FIFO[15:0];
            TEST_B <= FROM_FIFO[31:16];
            TEST_C[3:0] <= FROM_FIFO[35:32];
            TEST_C[4] <= FF_WEN_B;
            TEST_C[5] <= WRT_ERR;
            TEST_C[6] <= FF_REN_B;
            TEST_C[7] <= RD_ERR;
            TEST_C[10:8] <= WFUNCT[2:0];
            TEST_C[11] <= FF_IN_RDY_B;
            TEST_C[14:12] <= RFUNCT[2:0];
            TEST_C[15] <= FF_OUT_RDY_B;
         end
      4'hC, 4'hD:
         begin
            TEST_A <= DATA_OUT;
            TEST_B[4:0] <= EXFF_RD_ST;
            TEST_B[5] <= ECC_ENA;
            TEST_B[6] <= TEST_MODE;
            TEST_B[7] <= INJ_ERRS;
            TEST_B[10:8] <= 3'h0; // V_RFUNCT[2:0]
            TEST_B[11] <= 1'b0;   // V_FF_READ
            TEST_B[14:12] <= RFUNCT[2:0];
            TEST_B[15] <= READ;
            TEST_C[0] <= REN;
            TEST_C[1] <= DRP;
            TEST_C[2] <= RHOLD;
            TEST_C[3] <= RD_ERR;
            TEST_C[4] <= BG;
            TEST_C[5] <= FF_OUT_RDY;
            TEST_C[6] <= INT_OUT_RDY;
            TEST_C[7] <= OUT_RDY;
            TEST_C[8] <= OUT_DAT_VALID;
            TEST_C[9] <= FLSHD;
            TEST_C[10] <= BEG_O_DATA;
            TEST_C[11] <= NE3_OUT_OF_3;
            TEST_C[12] <= MTCH2_OUT_OF_3;
            TEST_C[13] <= NE6;
            TEST_C[14] <= MTCH6;
            TEST_C[15] <= FUNCT_DONE;
         end
      default: 
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
            TEST_C <= 16'h0000;
         end
   endcase
end

/////////////////////////
// Input Registers     //
/////////////////////////

always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         FUNCT <= 8'h00;
         ACK   <= 0;
         PRIO  <= 0;
      end
   else
      if(SEL && (RCTRL == `Rx_OpCode) && GET_FUNCT) // this is RCTRL not CTRL
         begin
            FUNCT <= RCVDATA[7:0];
            ACK   <= RCVDATA[13];
            PRIO  <= RCVDATA[14];
         end
      else
         begin
            FUNCT <= FUNCT;
            ACK   <= ACK;
            PRIO  <= PRIO;
         end
end
always @(FUNCT)
begin
   case(FUNCT)
      `VME_Cmds,`Wrt_Ext_FF,`Prg_Ext_Off,`Rdbk_Ext_Off,
      `MRst_Ext_FF,`PRst_Ext_FF,`Rd_Ext_FF,`RT_Ext_FF,
      `ST_MK_Ext_FF,`RST_MK_Ext_FF,`Rst_Ext_Err_Cnt,`Rd_Ext_Err_Cnts,`Flush_2_BOD:
         FF_DEF <= 1;
      default:
         FF_DEF <= 0;
   endcase
   case(FUNCT)
      `VME_Cmds,`Wrt_Ext_FF,`Prg_Ext_Off,
      `MRst_Ext_FF,`PRst_Ext_FF,
      `Rst_Ext_Err_Cnt:
         WF <= 1;
      default:
         WF <= 0;
   endcase
   case(FUNCT)
      `Rdbk_Ext_Off,`Rd_Ext_FF,`RT_Ext_FF,
      `ST_MK_Ext_FF,`RST_MK_Ext_FF,
      `Rd_Ext_Err_Cnts,`Flush_2_BOD:
         RF <= 1;
      default:
         RF <= 0;
   endcase
end
always @(posedge CLK or posedge RST)
begin
   if(RST)
      WFUNCT <= 3'h0;
   else
      if(LDWF)
         case(FUNCT)
            `VME_Cmds,`Wrt_Ext_FF:
               WFUNCT <= `Wrt_FF;
            `Prg_Ext_Off:
               WFUNCT <= `Prg_Offsets;
            `MRst_Ext_FF:
               WFUNCT <= `MRst_FF;
            `PRst_Ext_FF:
               WFUNCT <= `PRst_FF;
            `Rst_Ext_Err_Cnt:
               WFUNCT <= `Rst_Err_Cnts;
            default:
               WFUNCT <= `WNoOp;
         endcase
      else if(CLR_RWF)
         WFUNCT <= `WNoOp;
      else
         WFUNCT <= WFUNCT;
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      LRFUNCT <= 3'h0;
   else
      if(LDRF)
         case(FUNCT)
            `Rdbk_Ext_Off:
               LRFUNCT <= `Rdbk_Offsets;
            `Rd_Ext_FF:
               LRFUNCT <= `Rd_FF;
            `RT_Ext_FF:
               LRFUNCT <= `RT_FF;
            `ST_MK_Ext_FF:
               LRFUNCT <= `SET_MK_FF;
            `RST_MK_Ext_FF:
               LRFUNCT <= `RST_MK_FF;
            `Rd_Ext_Err_Cnts:
               LRFUNCT <= `Rd_Err_Cnts;
            `Flush_2_BOD:
               LRFUNCT <= `Flush_FF;
            default:
               LRFUNCT <= `RNoOp;
         endcase
      else  if(CLR_RWF)
         LRFUNCT <= `RNoOp;
      else
         LRFUNCT <= LRFUNCT;
end

always @(posedge CLK)
begin
   RXDATA <= RCVDATA;
   CTRL <= RCTRL;
   HDR_DN <= HBIT;
   ST_TY <= {STATUS,TYPE};
   H_BIT <= MHBITS_SRL[0];
   SRL2FF1 <= SRL2FF;
   SRL2FF2 <= SRL2FF1;
   SRL2FF3 <= SRL2FF2;
   SRL2FF4 <= SRL2FF3;
   SRLDONE <= SRL2FF4;
   MSRL2 <= MSRL1;
   MSRL3 <= MSRL2;
   MSRL4 <= MSRL3;
   MAC_DONE <= MSRL4;
   MAC_HDR_SRL_R <= MAC_HDR_SRL;
   GET_FRAME_R <= GET_FRAME;
   TXP_DATA_R <= DATA_FLAG;
   BC1 <= FLUSH;
   BUS_CLR <= BC1;
   SEL_ERR_R <= SEL_ERR;
   SE1 <= SE0;
   SE2 <= SE1;
   SE3 <= SE2;
   STAT_R <= STAT;
   SND_PKT_R <= TXP_SND_PKT;
   FFVD_R <= FFVD;
   D2 <= D1;
end
always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      begin
         RCV_ERR_WRD1 <= 16'h0000;
         RCV_ERR_WRD2 <= 16'h0000;
         RCV_ERR <= 0;
      end
   else
      if(RCV_ERR1 && FF_DEF)
         begin
            RCV_ERR_WRD1 <= RXDATA;
            RCV_ERR_WRD2 <= RCV_ERR_WRD2;
            RCV_ERR <= 1;
         end
      else if(RCV_ERR2 && FF_DEF)
         begin
            RCV_ERR_WRD1 <= RCV_ERR_WRD1;
            RCV_ERR_WRD2 <= RXDATA;
            RCV_ERR <= 1;
         end
      else
         begin
            RCV_ERR_WRD1 <= RCV_ERR_WRD1;
            RCV_ERR_WRD2 <= RCV_ERR_WRD2;
            RCV_ERR <= RCV_ERR;
         end
end

always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      RCNT <= 32'h00000000;
   else
      if(LD_RCNT_HI)
         RCNT <= {RXDATA,RCNT[15:0]};
      else if(LD_RCNT_LO)
         RCNT <= {RCNT[31:16],RXDATA};
      else if(LREAD)
         RCNT <= RCNT-1;
      else
         RCNT <= RCNT;
end

always @(posedge CLK or posedge RST_INTR_ERR)
begin
   if(RST_INTR_ERR)
      INTR_ERR <= 0;
   else
      if(MOMENTARY_ERR_CNDT)
         INTR_ERR <= 1;
      else
         INTR_ERR <= INTR_ERR;
end
always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      MID_ERR <= 0;
   else
      if(INTR_ERR)
         MID_ERR <= 1;
      else
         MID_ERR <= MID_ERR;
end
always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      FATAL_ERR <= 0;
   else
      if(FATAL_ERR_CNDT)
         FATAL_ERR <= 1;
      else
         FATAL_ERR <= FATAL_ERR;
end

always @(RXDATA or MBIT or HBIT or MAC_HDR_SRL or MHBITS_SRL)
begin  // mux for SRL input
   if(MBIT || HBIT)
      begin
         SRL_IN_DAT <= RXDATA;
         SRL_IN_BITS <= {MBIT,HBIT};
      end
   else
      begin
         SRL_IN_DAT <= MAC_HDR_SRL;
         SRL_IN_BITS <= MHBITS_SRL;
      end
end

macsrl  mh_srl(.clk(CLK),.ce(SRL_CE),.mhin(SRL_IN_BITS),.din(SRL_IN_DAT),.mhout(MHBITS_SRL),.dout(MAC_HDR_SRL));


///////////////////////////////////////////////////////////////
//                                                           //
// External FIFO Command Processor State Machine             //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or posedge CP_RST)
begin: EXFF_CP_FSM
   if(CP_RST)
      FCP_ST <= `FCP_Idle;
   else
      case(FCP_ST)
         `FCP_Idle:
            if(SEL)
               FCP_ST <= `FCP_Get_Funct;
            else if(PREP4SHTDWN)
               FCP_ST <= `FCP_Rdy4Shtdwn;
            else 
               FCP_ST <= `FCP_Idle;
         `FCP_Get_Funct:
            if(OPCODE)
               FCP_ST <= `FCP_Get_MAC;
            else 
               FCP_ST <= `FCP_Get_Funct;
         `FCP_Get_MAC:
            if(HDR_DN)
               if((RF && !TEST_MODE) || !FF_DEF)
                  FCP_ST <= `FCP_Dmy_Get;
               else if(WF)
                  FCP_ST <= `FCP_FFW_Rdy;
               else
                  FCP_ST <= `FCP_FFR_Rdy;
            else 
               FCP_ST <= `FCP_Get_MAC;
         `FCP_FFR_Rdy:
            if(FFR_IDLE)
               FCP_ST <= `FCP_Ld_RFunct;
            else 
               FCP_ST <= `FCP_FFR_Rdy;
         `FCP_Ld_RFunct:
            FCP_ST <= `FCP_Get_Frame;
         `FCP_FFW_Rdy:
            if(WARN)
               FCP_ST <= `FCP_Send_Wrn;
            else if(FFW_IDLE)
               FCP_ST <= `FCP_Ld_WFunct;
            else 
               FCP_ST <= `FCP_FFW_Rdy;
         `FCP_Ld_WFunct:
            FCP_ST <= `FCP_Get_Frame;
         `FCP_Get_Frame:
            if(EOP)
               if(RD_FF || RT_FF)
                  FCP_ST <= `FCP_W4Hld;
               else if(RD_BK)
                  FCP_ST <= `FCP_Send_Data;
               else if(VME_CMD && !TEST_MODE)
                  FCP_ST <= `FCP_SRL2FF;
               else if(ACK)
                  FCP_ST <= `FCP_Send_Ack;
               else if(WRT_FF && (ERR || WARN))
                  FCP_ST <= `FCP_Send_Err;
               else if(WRT_FF)
                  FCP_ST <= `FCP_Clr_RWF;
               else
                  FCP_ST <= `FCP_W4FD;
            else 
               FCP_ST <= `FCP_Get_Frame;
         `FCP_Send_Wrn:
            if(DONE)
               FCP_ST <= `FCP_PAE;
            else 
               FCP_ST <= `FCP_Send_Wrn;
         `FCP_PAE:
            if(PAE)
               FCP_ST <= `FCP_FFW_Rdy;
            else 
               FCP_ST <= `FCP_PAE;
         `FCP_Dmy_Get:
            if(EOP)
               if(MSG_LVL > 2'h0)
                 FCP_ST <= `FCP_Send_Err;
               else
                 FCP_ST <= `FCP_Clr_RWF;
            else 
               FCP_ST <= `FCP_Dmy_Get;
         `FCP_W4Hld:
            if(FATAL_ERR)
               FCP_ST <= `FCP_W4Done;
            else if(TXP_DATA && !RHOLD)
               FCP_ST <= `FCP_ReadFF;
            else 
               FCP_ST <= `FCP_W4Hld;
         `FCP_ReadFF:
            if(RD_END || FATAL_ERR)
               FCP_ST <= `FCP_W4Done;
            else 
               FCP_ST <= `FCP_ReadFF;
         `FCP_W4Done:
            if(DONE && (ERR || WARN))
               FCP_ST <= `FCP_Rel_Snd;
            else if(DONE)
               FCP_ST <= `FCP_Clr_RWF;
            else 
               FCP_ST <= `FCP_W4Done;
         `FCP_Rel_Snd:
            if(!DONE)
               FCP_ST <= `FCP_Send_Err;
            else 
               FCP_ST <= `FCP_Rel_Snd;
         `FCP_Send_Err:
            if(DONE)
               FCP_ST <= `FCP_Clr_RWF;
            else 
               FCP_ST <= `FCP_Send_Err;
         `FCP_Send_Data:
            if(DONE && (ERR || WARN))
               FCP_ST <= `FCP_Rel_Snd;
            else if(DONE)
               FCP_ST <= `FCP_Clr_RWF;
            else 
               FCP_ST <= `FCP_Send_Data;
         `FCP_Send_Ack:
            if(DONE && (ERR || WARN))
               FCP_ST <= `FCP_Rel_Snd;
            else if(DONE)
               FCP_ST <= `FCP_Clr_RWF;
            else 
               FCP_ST <= `FCP_Send_Ack;
         `FCP_W4FD:
            if(FUNCT_DONE && (ERR || WARN))
               FCP_ST <= `FCP_Send_Err;
            else if(FUNCT_DONE)
               FCP_ST <= `FCP_Clr_RWF;
            else 
               FCP_ST <= `FCP_W4FD;
         `FCP_SRL2FF:
            if(SRLDONE && (ERR || WARN))
               FCP_ST <= `FCP_Send_Err;
            else if(SRLDONE)
               FCP_ST <= `FCP_Clr_RWF;
            else 
               FCP_ST <= `FCP_SRL2FF;
         `FCP_Clr_RWF:
            FCP_ST <= `FCP_Idle;
         `FCP_Rdy4Shtdwn:
            FCP_ST <= `FCP_Rdy4Shtdwn;
         default:
            FCP_ST <= `FCP_Idle;
      endcase
end

//////////////////////////////////////////////////////////////////
// MAC/Header FIFO for passing packet info to VME controller    //
//////////////////////////////////////////////////////////////////
parameter MH_VME_FF_p2depth = 10;
defparam MH_VME_FF.p2depth = MH_VME_FF_p2depth;
defparam MH_VME_FF.width = 18;
defparam MH_VME_FF.almostmt = 32;
defparam MH_VME_FF.almostfull = (1<<MH_VME_FF_p2depth) - 32;
fifo_dpXn_blk  MH_VME_FF(.clk(CLK),.rst(RST),.push(SRL2FF),.pop(POP_MHVF),
               .mt(MHVF_MT),.full(MHVF_FULL),.amt(MHVF_AMT),.af(MHVF_AF),.wterr(MHVF_WTERR),.rderr(MHVF_RDERR),
               .din(MHVF_IN),.dout(MHVF_OUT),.cnt(MHVF_CNT));
/////////////////////////////////////////
// Transmit Processor State Machine    //
/////////////////////////////////////////

trans_proc EFF_Txp_FSM(.clk(CLK), .rst(RST), .start(START_TXP), .bg(BG), .mac_done(MAC_DONE),
           .intr_err(INTR_ERR), .fatal_err(FATAL_ERR), .s_err(S_ERR), .data_done(DATA_DONE),
           .bus_clr(BUS_CLR), .hndshk(HND_SHK), .txp_st(FF_TXP_ST), .br(BR));


always @(FF_TXP_ST or S_ERR or S_ACK or S_DATA or RD_DONE or RBKDONE or RD_DATA_VALID or RCV_ERR or SE0 or SE2)
begin
   case(FF_TXP_ST)
      `TxP_Data:
         begin
            if(S_DATA)
               begin
                  DATA_DONE <= RD_DONE || RBKDONE;
                  DATA_FLAG <= RD_DATA_VALID;
               end
            else if(S_ACK)
               begin
                  DATA_DONE <= 1;
                  DATA_FLAG <= 0;
               end
            else if(S_ERR)
               begin
                  DATA_DONE <= RCV_ERR ? SE2 : SE0;
                  DATA_FLAG <= 1;
               end
            else
               begin
                  DATA_DONE <= 0;
                  DATA_FLAG <= 0;
               end
         end
      default:
         begin
            DATA_DONE <= 0;
            DATA_FLAG <= 0;
         end
   endcase
end

always @(ERR or WARN or S_ACK)
begin
   if (S_ACK) //Acknowledge packets with no data
      TYPE <= `Rtn_NoDat_Pkt;
   else if(ERR)
      TYPE <= `Rtn_Err_Pkt;
   else if(WARN)
      TYPE <= `Rtn_Warn_Pkt;
   else
      TYPE <= `Rtn_ExFF_Pkt; // Default Config module return type;
end

always @(RCV_ERR or FF_DEF or VME_ERR or VME_WARN or WRT_WARN or S_WARN or WRT_ERR or MK_ERR or RT_ERR or MT_ERR or RD_ERR)
begin
   if(RCV_ERR)
      ERR_HDR <= {`Ext_FIFO_mod,`HDR_Error,`ER_Rcv_Err};
   else if(!FF_DEF)
      ERR_HDR <= {`Ext_FIFO_mod,`HDR_Error,`CP_Not_Def};
   else if(VME_ERR)
      ERR_HDR <= {`Ext_FIFO_mod,`HDR_Error,`EF_Rd_V_Err};
   else if(VME_WARN)
      ERR_HDR <= {`Ext_FIFO_mod,`HDR_Warn,`EF_V_wrt_Wrn};
   else if(WRT_WARN)
      ERR_HDR <= {`Ext_FIFO_mod,`HDR_Warn,`EF_Wrt_Wrn};
   else if(S_WARN)
      ERR_HDR <= {`Ext_FIFO_mod,`HDR_Warn,`EF_FF_PAF};
   else if(|{WRT_ERR, MK_ERR, RT_ERR, MT_ERR, RD_ERR})
      case({WRT_ERR, MK_ERR, RT_ERR, MT_ERR, RD_ERR})
         5'h01:
            ERR_HDR <= {`Ext_FIFO_mod,`HDR_Error,`EF_Rd_Err};
         5'h02:
            ERR_HDR <= {`Ext_FIFO_mod,`HDR_Error,`EF_MT_Err};
         5'h04:
            ERR_HDR <= {`Ext_FIFO_mod,`HDR_Error,`EF_Rt_Err};
         5'h08:
            ERR_HDR <= {`Ext_FIFO_mod,`HDR_Error,`EF_Mk_Err};
         5'h10:
            ERR_HDR <= {`Ext_FIFO_mod,`HDR_Error,`EF_Wrt_Err};
         default:
            ERR_HDR <= {`Ext_FIFO_mod,`HDR_Error,`EF_Mltp_Err};
      endcase
   else
      ERR_HDR <= {`Ext_FIFO_mod,`HDR_Info,`G_No_Info};
end

always @(TXP_INI_STAT or TXP_MID_STAT or TXP_INC_STAT or TXP_FIN_STAT or ERR or WARN or S_ACK or S_DATA)
begin
   if(TXP_INI_STAT)
      STATUS <= `CiP;
   else if (TXP_MID_STAT)
      if(ERR)
         STATUS <= `CiP_E;
      else if(WARN)
         STATUS <= `CiP_W;
      else
         STATUS <= `CiP;
   else if (TXP_INC_STAT)
      STATUS <= `CE_I;
   else if (TXP_FIN_STAT)
      if(ERR && (S_ACK || S_DATA))
         STATUS <= `CC_E;
      else if(WARN && (S_ACK || S_DATA))
         STATUS <= `CC_W;
      else if(S_ACK || S_DATA)
         STATUS <= `CC_S;
      else
         STATUS <= `No_Ack;
   else
      STATUS <= `No_Ack;
end


always @(STAT_R or MSRL2 or TXP_DATA_R or 
         ST_TY or MAC_HDR_SRL_R or
         SE1 or SE2 or SE3 or ERR_HDR or
         RCV_ERR or RCV_ERR_WRD1 or RCV_ERR_WRD2 or
         DATA_OUT)
begin
   if(STAT_R)
      DATA_MUX <= {4'h0,ST_TY};
   else if (MSRL2)
      DATA_MUX <= MAC_HDR_SRL_R;
   else if (TXP_DATA_R && SE1)
      DATA_MUX <= ERR_HDR;
   else if (TXP_DATA_R && SE2)
      DATA_MUX <= RCV_ERR ? RCV_ERR_WRD1 : 16'h0000;
   else if (TXP_DATA_R && SE3)
      DATA_MUX <= RCV_ERR ? RCV_ERR_WRD2 : 16'h0000;
   else
      DATA_MUX <= DATA_OUT;
end


always @(STAT_R or MSRL2 or H_BIT or TXP_DATA_R or SND_PKT_R)
begin
   if(STAT_R)
      INSTR_MUX <= `Tx_AST;
   else if (MSRL2)
      if(H_BIT)
         INSTR_MUX <= `Tx_Head;
      else
         INSTR_MUX <= `Tx_MAC;
   else if (TXP_DATA_R)
      INSTR_MUX <= `Tx_Data;
   else if (SND_PKT_R)
      INSTR_MUX <= `Tx_Send;
   else
      INSTR_MUX <= `Tx_NoData;
end

always @(S_ERR or PRIO)
begin
   if(S_ERR)
      CAT_MUX <= `Tx_Spont_Cat;
   else if (PRIO)
      CAT_MUX <= `Tx_Prio_Cat;
   else
      CAT_MUX <= `Tx_Norm_Cat;
end

/////////////////////////
// Output Registers    //
/////////////////////////

always @(posedge CLK)
begin
   if(SEL)
      begin
         MAC_REQ   <= GET_MAC;
         FRAME_REQ <= WRT_FF ? !WHOLD && GET_FRAME : GET_FRAME || DMY_GET;
      end
   else
      begin
         MAC_REQ   <= 1'bZ;
         FRAME_REQ <= 1'bZ;
      end
end

always @(posedge CLK)
begin
   if(BG)
      begin
         TXDATA  <= DATA_MUX;
         TXCTRL  <= {CAT_MUX,INSTR_MUX};
      end
   else
      begin
         TXDATA  <= 16'hZZZZ;
         TXCTRL  <= 5'hZZ;
      end
end


////////////////////////////////////////////////////////////////////////////////////////////////////////
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //
// ======================== Original External FIFO Module =========================================== //
// -------------------------------------------------------------------------------------------------- //
////////////////////////////////////////////////////////////////////////////////////////////////////////


always @(posedge CLK or posedge RST)
begin
   if(RST)
      INJ_CNT <= 10'h000;
   else
      if(WEN)
         INJ_CNT <= INJ_CNT + 1;
      else
         INJ_CNT <= INJ_CNT;
end
// Input registers

// Begining of Data Mux
always @(DATA_IN1 or SEL_BOD)
begin
   if(SEL_BOD)
      DAT_BOD <= 16'hDB0D;
   else
      DAT_BOD <= DATA_IN1;
end
always @(posedge CLK)
begin
   DATA_IN1 <= RXDATA;
   if(INJ_TYP2_NOW && !SEL_BOD)
      DATA_IN2 <= DAT_BOD^16'h01C8;
   else if(INJ_TYP1_NOW && !SEL_BOD)
      DATA_IN2 <= DAT_BOD^16'h0402;
   else
      DATA_IN2 <= DAT_BOD;
   FROM_FIFO1 <= FROM_FIFO;
   FFH1 <= FF_MJ_DCD;
   FFH2 <= FFH1;
   FFH3 <= FFH2;
   FFH4 <= FFH3;
   FFH5 <= FFH4;
   FFH6 <= FFH5;
   ORH0 <= FF_OUT_RDY;
   ORH1 <= ORH0;
   ORH2 <= ORH1;
   ORH3 <= ORH2;
   ORH4 <= ORH3;
   ORH5 <= ORH4;
   ORH6 <= ORH5;
   MTCH1 <= MTCH2_OUT_OF_3;
   MTCH2 <= MTCH1;
   MTCH3 <= MTCH2;
   MTCH4 <= MTCH3;
   MTCH5 <= MTCH4;
   MTCH6 <= MTCH5;
   NE1 <= NE3_OUT_OF_3;
   NE2 <= NE1;
   NE3 <= NE2;
   NE4 <= NE3;
   NE5 <= NE4;
   NE6 <= NE5;
   MRST1 <= MRST;
   MRST2 <= MRST1;
   MRST3 <= MRST2;
   PRST1 <= PRST;
   PRST2 <= PRST1;
   PRST3 <= PRST2;
   PPMHVF1 <= POP_MHVF;
   PPMHVF2 <= PPMHVF1;
   PPMHVF3 <= PPMHVF2;
   PPMHVF4 <= PPMHVF3;
   MHVF_DONE <= PPMHVF4;
end


///////////////////////////////////////////////////////////////
//                                                           //
// ENCODER for Golay(24,12) ECC code                         //
//                                                           //
///////////////////////////////////////////////////////////////

ecc_encode ecc_encode_1(.CLK(CLK),.DATA(DAT_BOD[11:0]),.PARITY(ECC_PARITY));

///////////////////////////////////////////////////////////////
//                                                           //
// Majority logic for controls and address                   //
//                                                           //
///////////////////////////////////////////////////////////////
always @(FROM_FIFO1)
begin
   FF_MJ_DCD <= (FROM_FIFO1[15:12] & FROM_FIFO1[31:28]) | (FROM_FIFO1[15:12] & FROM_FIFO1[35:32]) | (FROM_FIFO1[35:32] & FROM_FIFO1[31:28]);
   MTCH2_OUT_OF_3 <= (((FROM_FIFO1[35:32] == 4'hB) && (FROM_FIFO1[31:28] == 4'h0)) || ((FROM_FIFO1[35:32] == 4'hB) && (FROM_FIFO1[15:12] == 4'hD)) || ((FROM_FIFO1[31:28] == 4'h0) && (FROM_FIFO1[15:12] == 4'hD))); 
   NE3_OUT_OF_3 <= (FROM_FIFO1[15:12] != FROM_FIFO1[31:28]) && (FROM_FIFO1[15:12] != FROM_FIFO1[35:32]) && (FROM_FIFO1[31:28] != FROM_FIFO1[35:32]); 
end


// Instansiate the external clock drivers as double data rate output flip flops.

// WCLK in phase with CLK
//OFDDRRSE Ext_Wclk (.Q(FF_WCLK),.C0(CLK),.C1(!CLK),.CE(1'b1),.D0(1'b1),.D1(1'b0),.R(1'b0),.S(1'b0));
//
// WCLK out of phase with CLK
OFDDRRSE Ext_Wclk (.Q(FF_WCLK),.C0(CLK),.C1(!CLK),.CE(1'b1),.D0(1'b0),.D1(1'b1),.R(1'b0),.S(1'b0));

// RCLK in phase with CLK
OFDDRRSE Ext_Rclk (.Q(FF_RCLK),.C0(CLK),.C1(!CLK),.CE(1'b1),.D0(1'b1),.D1(1'b0),.R(1'b0),.S(1'b0));
// RCLK out of phase with CLK
//OFDDRRSE Ext_Rclk (.Q(FF_RCLK),.C0(CLK),.C1(!CLK),.CE(1'b1),.D0(1'b0),.D1(1'b1),.R(1'b0),.S(1'b0));

// SCLK is no longer used
//OFDDRRSE Ext_Sclk (.Q(FF_SCLK),.C0(SER_CLK),.C1(!SER_CLK),.CE(1'b1),.D0(1'b0),.D1(1'b1),.R(1'b0),.S(1'b0));

// OUTPUT REGISTERS
always @(posedge CLK)
begin
   WEN1 <= WEN;
   FF_WEN_B <= !WEN1 && !LOAD1 && !LOAD2 && !LOAD_BOD;
   WLOAD <= LOAD1 || LOAD2;
   FF_MARK  <= MARK;
   CAP_OFF1 <= UPDTOFF1;
   CAP_OFF2 <= UPDTOFF2;
   if(LOAD1)
      TO_FIFO <= {16'h0000,OFFSET[17:16],1'b0,OFFSET[15:8],1'b0,OFFSET[7:0]};
   else if(LOAD2) 
      TO_FIFO <= {16'h0000,OFFSET[35:34],1'b0,OFFSET[33:26],1'b0,OFFSET[25:18]};
   else  if(LOAD_BOD)
      TO_FIFO <= {8'hB0,ECC_PARITY,DATA_IN2}; 
   else 
      TO_FIFO <= {DATA_IN2[15:12],DATA_IN2[15:12],ECC_PARITY,DATA_IN2}; 
end
always @(negedge CLK)
begin
   FF_REN_B <= !REN && !RDOFF && !DRP;
   RLOAD <= RDOFF;
   FF_RT_B  <= !RT;
end

///////////////////////////////////////////////////////////////
//                                                           //
// DECODER for Golay(24,12) ECC code                         //
//                                                           //
///////////////////////////////////////////////////////////////

ecc_decode ecc_decode_FF1(.CLK(CLK),.RCV_DATA(FROM_FIFO1[11:0]),.RCV_PARITY(FROM_FIFO1[27:16]),.GOOD_WORD(GOOD_WORD),
              .DCD_DATA(DCD_DATA),.DCD_PARITY(DCD_PARITY),.BAD_TX(BAD_TX));

always @(posedge CLK or posedge ERR_CNT_RST)
begin
   if(ERR_CNT_RST)
      begin
         UN_COR_ERR_REG <= 32'h00000000;
         COR_ERR_REG <= 32'h00000000;
      end
   else
      if(DCD_DAT_VALID && !GOOD_WORD && BAD_TX)
         begin
            UN_COR_ERR_REG <= UN_COR_ERR_REG + 1;
            COR_ERR_REG <= COR_ERR_REG;
         end
      else if(DCD_DAT_VALID && GOOD_WORD && BAD_TX) 
         begin
            UN_COR_ERR_REG <= UN_COR_ERR_REG;
            COR_ERR_REG <= COR_ERR_REG + 1;
         end
      else 
         begin
            UN_COR_ERR_REG <= UN_COR_ERR_REG;
            COR_ERR_REG <= COR_ERR_REG;
         end
end

always @(posedge CLK)
begin
   case ({ERCNT,L4,L3,L2,L1_FR})
      `Hi_Full_Off:
         DATA_OUT <= {14'h0000,OFFSET[35:34]};
      `Lo_Full_Off:
         DATA_OUT <= OFFSET[33:18];
      `Hi_Empt_Off:
         DATA_OUT <= {14'h0000,OFFSET[17:16]};
      `Lo_Empt_Off:
         DATA_OUT <= OFFSET[15:0];
      `Hi_Un_Cor_Err_Cnt:
         DATA_OUT <= UN_COR_ERR_REG[31:16];
      `Lo_Un_Cor_Err_Cnt:
         DATA_OUT <= UN_COR_ERR_REG[15:0];
      `Hi_Cor_Err_Cnt:
         DATA_OUT <= COR_ERR_REG[31:16];
      `Lo_Cor_Err_Cnt:
         DATA_OUT <= COR_ERR_REG[15:0];
      default:
         if(ECC_ENA)
            DATA_OUT <= {FFH6,DCD_DATA};
         else
            DATA_OUT <= FROM_FIFO1[15:0];
   endcase
end

always @(posedge CLK)
begin
   if(ECC_ENA)
      begin
         BEG_O_DATA <= (DCD_DATA == 12'hB0D) && NE6 && MTCH6;
         INT_OUT_RDY <= ORH6;
      end
   else
      begin
         BEG_O_DATA <= (FROM_FIFO1[11:0] == 12'hB0D) && NE3_OUT_OF_3 && MTCH2_OUT_OF_3;
         INT_OUT_RDY <= ORH0;
      end
end

always @(posedge CLK)
begin
   if(TEST_MODE)
      begin
         TO_VME <= 16'h0000;
         F2V_ODV <= 1'b0;
         F2V_OUT_RDY <= 1'b0;
         OUT_RDY <= INT_OUT_RDY && FF_OUT_RDY;
      end
   else
      begin
         TO_VME <= RD_MHVF ? MHVF_OUT : {2'b00,DATA_OUT};
         F2V_ODV <= RD_MHVF ? PPMHVF1 : OUT_DAT_VALID;
         F2V_OUT_RDY <= INT_OUT_RDY && FF_OUT_RDY && !BEG_O_DATA && !MHVF_MT;
         OUT_RDY <= INT_OUT_RDY && FF_OUT_RDY && !BEG_O_DATA;
      end
end


/////////////////////////////////////////////////////
//                                                 //
//  FIFO Write related processes                   //
//                                                 //
/////////////////////////////////////////////////////



always @(posedge CLK or posedge FF_RST)
begin: Ext_FF_WR_FSM
   if (FF_RST)
      EXFF_WR_ST <= `FFW_Rst;
   else
      case (EXFF_WR_ST)
         `FFW_Rst:
            EXFF_WR_ST <= `FFW_Rst_Mark;
         `FFW_Rst_Mark:
            EXFF_WR_ST <= `Set_FWFT;
         `Set_FWFT:
            EXFF_WR_ST <= `MRst_St;
         `MRst_St:
            if (MRST3)
               EXFF_WR_ST <= `Hold_FWFT;
            else
               EXFF_WR_ST <= `MRst_St;
         `Hold_FWFT:
            EXFF_WR_ST <= `MRst_Done;
         `MRst_Done:
            if (WFUNCT != `MRst_FF)
               EXFF_WR_ST <= `FFW_Idle;
            else
               EXFF_WR_ST <= `MRst_Done;
         `FFW_Idle:
            if (WFUNCT == `Wrt_FF)
               EXFF_WR_ST <= `Input_Rdy;
            else if (WFUNCT == `Prg_Offsets)
               EXFF_WR_ST <= `W_Valdat2;
            else if (WFUNCT == `MRst_FF)
               EXFF_WR_ST <= `FFW_Rst_Mark;
            else if (WFUNCT == `PRst_FF)
               EXFF_WR_ST <= `PRst_St;
            else if (WFUNCT == `Rst_Err_Cnts)
               EXFF_WR_ST <= `Rst_Err_Cnt_St;
            else
               EXFF_WR_ST <= `FFW_Idle;
         `Input_Rdy:
            if (WFUNCT != `Wrt_FF)
               EXFF_WR_ST <= `FFW_Idle;
            else if (!PAF && TEST_MODE)
               EXFF_WR_ST <= `W_Valdat1;
            else if (!PAF && !TEST_MODE)
               EXFF_WR_ST <= `Enc_BOD;
            else
               EXFF_WR_ST <= `Input_Rdy;
         `Enc_BOD:
            EXFF_WR_ST <= `Load_BOD;
         `Load_BOD:
            EXFF_WR_ST <= `W_Valdat1;
         `W_Valdat1:
            if ((WFUNCT == `Wrt_FF) && FFVD)
               EXFF_WR_ST <= `Write_FF;
            else if (WFUNCT != `Wrt_FF)
               EXFF_WR_ST <= `FFW_Idle;
            else
               EXFF_WR_ST <= `W_Valdat1;
         `Write_FF:
            if (!IN_RDY)
               EXFF_WR_ST <= `Wrt_Err;
            else if ((WFUNCT == `Wrt_FF) && !FFVD)
               EXFF_WR_ST <= `W_Valdat1;
            else if (WFUNCT != `Wrt_FF)
               EXFF_WR_ST <= `FFW_Idle;
            else
               EXFF_WR_ST <= `Write_FF;
         `Wrt_Err:
            if (WFUNCT != `Wrt_FF)
               EXFF_WR_ST <= `FFW_Idle;
            else
               EXFF_WR_ST <= `Wrt_Err;
         `W_Valdat2:
            if (FFVD)
               EXFF_WR_ST <= `Load_Offsets;
            else
               EXFF_WR_ST <= `W_Valdat2;
         `Load_Offsets:
            if(L4) 
               EXFF_WR_ST <= `Wrt_Off_to_1;
            else
               EXFF_WR_ST <= `Load_Offsets;
         `Wrt_Off_to_1:
            EXFF_WR_ST <= `Wrt_Off_to_2;
         `Wrt_Off_to_2:
            EXFF_WR_ST <= `Prg_Done;
         `Prg_Done:
            if (WFUNCT != `Prg_Offsets)
               EXFF_WR_ST <= `FFW_Idle;
            else
               EXFF_WR_ST <= `Prg_Done;
         `PRst_St:
            if (PRST3)
               EXFF_WR_ST <= `PRst_Done;
            else
               EXFF_WR_ST <= `PRst_St;
         `PRst_Done:
            if (WFUNCT != `PRst_FF)
               EXFF_WR_ST <= `FFW_Idle;
            else
               EXFF_WR_ST <= `PRst_Done;
         `Rst_Err_Cnt_St:
            if (WFUNCT != `Rst_Err_Cnts)
               EXFF_WR_ST <= `FFW_Idle;
            else
               EXFF_WR_ST <= `Rst_Err_Cnt_St;
         default:
            EXFF_WR_ST <= `FFW_Idle;
      endcase
end


always @(posedge CLK or posedge CLRL)
begin
   if (CLRL)
      begin
         L2 <= 0;
         L3 <= 0;
         L4 <= 0;
      end
   else
      begin
         L2 <= L1_TO || L1_FR;
         L3 <= L2;
         L4 <= L3;
      end
end

always @ (posedge CLK or posedge RST)
begin: Offset_Reg
   if (RST)
      OFFSET <= 0;
   else 
      case ({1'b0,L4,L3,L2,L1_TO})
         5'd0:
            if (CAP_OFF1)
               OFFSET <= {OFFSET[35:18],FROM_FIFO1[19:18],FROM_FIFO1[16:9],FROM_FIFO1[7:0]};
            else if (CAP_OFF2)
               OFFSET <= {FROM_FIFO1[19:18],FROM_FIFO1[16:9],FROM_FIFO1[7:0],OFFSET[17:0]};
            else
               OFFSET <= OFFSET;
         `Hi_Full_Off:
            OFFSET[35:34] <= DATA_IN1[1:0];
         `Lo_Full_Off:
            OFFSET[33:18] <= DATA_IN1;
         `Hi_Empt_Off:
            OFFSET[17:16] <= DATA_IN1[1:0];
         `Lo_Empt_Off:
            OFFSET[15:0] <= DATA_IN1;
         default:
            OFFSET <= OFFSET;
      endcase
end

/////////////////////////////////////////////////////
//                                                 //
//  FIFO Read related processes                    //
//                                                 //
/////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin: Ext_FF_RD_FSM
   if (RST)
      EXFF_RD_ST <= `FFR_Idle;
   else
      case (EXFF_RD_ST)
         `FFR_Idle:
            if (INT_OUT_RDY && BEG_O_DATA)
               EXFF_RD_ST <= `Flush_BOD;
            else
               case (RFUNCT)
                  `Rd_FF:
                     EXFF_RD_ST <= `Pause;
                  `RT_FF:
                     if(MARK)
                        EXFF_RD_ST <= `ReTrans;
                     else
                        EXFF_RD_ST <= `ReTrans_Err;
                  `SET_MK_FF:
                     if(PAE)
                        EXFF_RD_ST <= `FF_MK_Err;
                     else 
                        EXFF_RD_ST <= `RST_Mark;
                  `RST_MK_FF:
                     EXFF_RD_ST <= `RST_Mark;
                  `Rdbk_Offsets:
                     EXFF_RD_ST <= `Rd_Off;
                  `Rd_Err_Cnts:
                     EXFF_RD_ST <= `FF_Snd_Data2;
                  `Flush_FF:
                     if(FF_OUT_RDY)
                        EXFF_RD_ST <= `Drop_Wrd;
                     else
                        EXFF_RD_ST <= `Flush_Done;
                  `Read_MHVF:
                     EXFF_RD_ST <= `PoP_MHVF;
                  default:
                     EXFF_RD_ST <= `FFR_Idle;
               endcase
         `RST_Mark:
            if (RFUNCT == `SET_MK_FF)
               EXFF_RD_ST <= `Set_Mark;
            else if (RFUNCT != `RST_MK_FF)
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `RST_Mark;
         `Set_Mark:
            if (RFUNCT != `SET_MK_FF)
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `Set_Mark;
         `Pause: 
            if (OUT_RDY)
               EXFF_RD_ST <= `Wait_for_Read;
            else if (RD_TMOUT)
               EXFF_RD_ST <= `FF_MT_Err;
            else
               EXFF_RD_ST <= `Pause;
         `Wait_for_Read:
            if (READ)
               EXFF_RD_ST <= `Read_FF;
            else if ((RFUNCT != `Rd_FF) && (RFUNCT != `RT_FF))
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `Wait_for_Read;
         `Read_FF:
            if (!OUT_RDY)
               EXFF_RD_ST <= `FF_Rd_Err;
            else if ((RFUNCT != `Rd_FF) && (RFUNCT != `RT_FF))
               EXFF_RD_ST <= `FFR_Idle;
            else if (!READ)
               EXFF_RD_ST <= `Wait_for_Read;
            else
               EXFF_RD_ST <= `Read_FF;
         `ReTrans:
               EXFF_RD_ST <= `Pause;
         `ReTrans_Err:
            if (RFUNCT != `RT_FF)
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `ReTrans_Err;
         `FF_MT_Err:
            if ((RFUNCT != `Rd_FF) && (RFUNCT != `RT_FF))
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `FF_MT_Err;
         `FF_MK_Err:
            if (RFUNCT != `SET_MK_FF)
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `FF_MK_Err;
         `FF_Rd_Err:
            if ((RFUNCT != `Rd_FF) && (RFUNCT != `RT_FF))
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `FF_Rd_Err;
         `Rd_Off:
            EXFF_RD_ST <= `Pause_Off1;
         `Pause_Off1:
            EXFF_RD_ST <= `Rd_Off_Upd;
         `Rd_Off_Upd:
            EXFF_RD_ST <= `Pause_Off2;
         `Pause_Off2:
            EXFF_RD_ST <= `Update_Off;
         `Update_Off:
            EXFF_RD_ST <= `W4Capture;
         `W4Capture:
            if (CAP_OFF2)
               EXFF_RD_ST <= `FF_Snd_Data1;
            else
               EXFF_RD_ST <= `W4Capture;
         `FF_Snd_Data1:
            if (TXP_DATA)
               EXFF_RD_ST <= `Send_Offsets;
            else if (RFUNCT != `Rdbk_Offsets)
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `FF_Snd_Data1;
         `Send_Offsets:
            if(L4) 
               EXFF_RD_ST <= `Rbk_Done;
            else
               EXFF_RD_ST <= `Send_Offsets;
         `Rbk_Done:
            if ((RFUNCT != `Rdbk_Offsets) && (RFUNCT != `Rd_Err_Cnts))
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `Rbk_Done;
         `FF_Snd_Data2:
            if (TXP_DATA)
               EXFF_RD_ST <= `Send_Err_Cnts;
            else if (RFUNCT != `Rd_Err_Cnts)
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `FF_Snd_Data2;
         `Send_Err_Cnts:
            if(L4) 
               EXFF_RD_ST <= `Rbk_Done;
            else
               EXFF_RD_ST <= `Send_Err_Cnts;
         `Flush_BOD:
            EXFF_RD_ST <= `W4Vldt1;
         `W4Vldt1:
            if(DRP_DAT_VALID) 
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `W4Vldt1;
         `Drop_Wrd:
            EXFF_RD_ST <= `W4Vldt2;
         `W4Vldt2:
            if(DRP_DAT_VALID)
               if(!INT_OUT_RDY || BEG_O_DATA) 
                  EXFF_RD_ST <= `Flush_Done;
               else 
                  EXFF_RD_ST <= `Drop_Wrd;
            else
               EXFF_RD_ST <= `W4Vldt2;
         `Flush_Done:
            if(RFUNCT != `Flush_FF) 
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `Flush_Done;
         `PoP_MHVF:
            if(MHVF_DONE) 
               EXFF_RD_ST <= `MHVF_Done;
            else
               EXFF_RD_ST <= `PoP_MHVF;
         `MHVF_Done:
            if(RFUNCT != `Read_MHVF) 
               EXFF_RD_ST <= `FFR_Idle;
            else
               EXFF_RD_ST <= `MHVF_Done;
         default:
            EXFF_RD_ST <= `FFR_Idle;
      endcase
end



always @(posedge CLK or posedge RST)
begin: MARK_REG
   if(RST)
      MARK <= 0;
   else
      if (STM)
         MARK <= 1;
      else if (RSM || PU_RSM)
         MARK <= 0;
      else
         MARK <= MARK;
end

always @(posedge CLK)
begin
   RDE1 <= RD_ERR;
   RDE2 <= RDE1;
   RDE3 <= RDE2;
   RDE4 <= RDE3;
   RDE5 <= RDE4;
   RDE6 <= RDE5;
//
   ODV1 <= REN;
   ODV2 <= ODV1;
   ODV3 <= ODV2;
   ODV4 <= ODV3;
   ODV5 <= ODV4;
   ODV6 <= ODV5;
   ODV7 <= ODV6;
//
   FDV1 <= DRP;
   FDV2 <= FDV1;
   FDV3 <= FDV2;
   FDV4 <= FDV3;
   FDV5 <= FDV4;
   FDV6 <= FDV5;
   FDV7 <= FDV6;
//
   RD_END1 <= RD_END;
   RD_END2 <= RD_END1;
   RD_END3 <= RD_END2;
   RD_END4 <= RD_END3;
   RD_END5 <= RD_END4;
   RD_END6 <= RD_END5;
   RD_END7 <= RD_END6;
//
   DCD_DAT_VALID <= ODV6 || FDV6;
   OUT_DAT_VALID <= RD_DATA_VALID;
   DRP_DAT_VALID <= ECC_ENA ? FDV7 : FDV1;
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      RD_TMR <= 12'h000;
   else
      if(ENATMR)
         RD_TMR <= RD_TMR + 1;
      else
         RD_TMR <= 12'h000;
end

endmodule
