`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"
`endif

module flash_ctrl(CLK,RST,CP_RST,MSG_LVL,
                  SEL,RCTRL,RCVDATA,FROM_CNFG,CNFG_SND_REQ,FLC_DV,BG,PREP4SHTDWN,
                  FRFL_DV,RDY4INP,FROM_DATA,FROM_ADDR,FROM_PAGE,
                  BR,HOLD,MAC_REQ,FRAME_REQ,FL_ERRS,
                  WR_RDB,NEW_PAGE,PUSH,PAGE,ADDR,TO_DATA,
                  TXCTRL,TXDATA,TO_CNFG,FL_CNFG_ODV,FL_CNFG_NOW_DONE,RDY4SHTDWN);


    input CLK;
    input RST;
    input CP_RST;
    input [1:0] MSG_LVL;
    input SEL;
    input [2:0] RCTRL;
    input [15:0] RCVDATA;
    input [15:0] FROM_CNFG;
    input CNFG_SND_REQ;
    input FLC_DV;
    input BG;
    input PREP4SHTDWN;
    input FRFL_DV;
    input RDY4INP;
    input [7:0] FROM_DATA;
    input [5:0] FROM_ADDR;
    input [6:0] FROM_PAGE;
    output BR;
    output HOLD;
    output MAC_REQ;
    output FRAME_REQ;
    output [7:0] FL_ERRS;
    output WR_RDB;
    output NEW_PAGE;
    output PUSH;
    output [6:0] PAGE;
    output [5:0] ADDR;
    output [7:0] TO_DATA;
    output [4:0] TXCTRL;
    output [15:0] TXDATA;
    output [15:0] TO_CNFG;
    output FL_CNFG_ODV;
    output FL_CNFG_NOW_DONE;
    output RDY4SHTDWN;

wire BR;
wire HOLD;
reg  MAC_REQ;
reg  FRAME_REQ;
reg  [7:0] FL_ERRS;
reg  WR_RDB;
reg  NEW_PAGE;
reg  PUSH;
reg  [6:0] PAGE;
reg  [5:0] ADDR;
reg  [7:0] TO_DATA;
reg  [4:0] TXCTRL;
reg  [15:0] TXDATA;
reg  [15:0] TO_CNFG;
reg  FL_CNFG_ODV;
reg  FL_CNFG_NOW_DONE;
wire RDY4SHTDWN;


reg  PSH_FL1;
reg  NPG,NPG1;
reg  [6:0] PAGE_REG;
reg  [3:0] FL_CP_ST;
reg  [3:0] FLCI_ST;
reg  [4:0] FL_SD_ST;
wire [3:0] FL_TXP_ST;
reg  VLD1;
reg  CDV;
reg  CD1,CD2;
reg  D2;
reg  DCODE;
reg  READ_INFF;

reg [15:0] FROM_CNFG_1;
reg FLC_DV_1;
reg [7:0] FUNCT;
reg RCV1,RCV2;
reg ACK,ACK1,ACK2;
reg PRIO,PRIO1,PRIO2;
reg FL_DEF;
reg [1:0] CAT_MUX;
reg [2:0] INSTR_MUX;
reg [15:0] DATA_MUX;
reg [2:0]  CTRL;
reg [15:0] DATA;
reg [17:0] INBUS;
reg [15:0] OUTDATA;
reg [15:0] CP_MAC_HDR_SRL_R;
reg [15:0] CI_MAC_HDR_SRL_R;
reg [15:0] SD_MAC_HDR_SRL_R;
reg CP_H_BIT;
reg CI_H_BIT;
reg SD_H_BIT;
reg [15:0] CP_SRL_IN_DAT;
reg [1:0]  CP_SRL_IN_BITS;
reg [15:0] CI_SRL_IN_DAT;
reg [1:0]  CI_SRL_IN_BITS;
reg [15:0] SD_SRL_IN_DAT;
reg [1:0]  SD_SRL_IN_BITS;
reg HDR_DN;
reg VALDAT_R;
reg [7:0] TYPE;
reg [3:0] STATUS;
reg [11:0] ST_TY;
reg [15:0] RCV_ERR_WRD1,RCV_ERR_WRD2;
reg [15:0] CP_ERR_HDR;
reg [15:0] CI_ERR_HDR;
reg [15:0] SD_ERR_HDR;
reg [2:0] RSPNS;
reg [2:0] TXDN;
reg [5:0] TXDN_MSK;
reg MSRL2,MSRL3,MSRL4,MAC_DONE;
reg BC1,BUS_CLR;
reg DATA_DONE;
reg SEL_RCV;
reg RCV_ERR;
reg INTR_ERR,MID_ERR,FATAL_ERR;
reg SEL_ERR_R;
reg SE1,SE2,SE3;
reg DATA_FLAG;
reg TXP_DATA_R;
reg STAT_R;
reg SND_PKT_R;
reg GET_FRAME_R;
reg PUSH_INFF;
reg SRL2FF2,SRL2FF3,SRL2FF4,SRLDONE;
reg FF2SRL2;
reg HFF2SDSRL2,HFF2SDSRL3,HFF2SDSRL4;
reg HFFRD_DN;
reg HDRRD2,HDRRD3,HDRRD4;
reg HDR_RD_DONE;
reg PKT_ERR1,PKT_ERR2;
reg PKT_WARN1,PKT_WARN2;

wire [15:0] CP_MAC_HDR_SRL;
wire [15:0] CI_MAC_HDR_SRL;
wire [15:0] SD_MAC_HDR_SRL;
wire [1:0]  CP_MHBITS_SRL;
wire [1:0]  CI_MHBITS_SRL;
wire [1:0]  SD_MHBITS_SRL;
wire CP_SRL_CE;
wire MBIT;
wire HBIT;
wire RST_CP_ERRS;
wire RST_CI_ERRS;
wire RST_SD_ERRS;
wire RST_INTR_ERR;
wire CLR_INTR_ERR;
wire RCV_ERR1,RCV_ERR2;
wire SEL_ERR;
wire VALDAT;
wire D1;
wire OPCODE;
wire EOP;
wire GET_FUNCT;
wire GET_MAC;
wire GET_FRAME;
wire DMY_GET;
wire SRL2FF;
wire CAP_RSPNS;
wire TXP_INI_STAT;
wire TXP_MID_STAT;
wire TXP_INC_STAT;
wire TXP_FIN_STAT;
wire TXP_DATA;
wire STAT;
wire TXP_SND_PKT;
wire MSRL1;
wire FLUSH;
wire S_ERR;
wire S_ACK;
wire S_DATA;
wire CP_ERR;
wire CI_ERR;
wire SD_ERR;
wire SD_WARN;
wire CP_INP;
wire CI_INP;
wire SD_INP;
wire CP_SND_ERR;
wire CP_SND_WRN;
wire CI_SND_ACK;
wire CI_SND_ERR;
wire SD_SND_ERR;
reg  SD_SND_DATA;
wire CP_RDY4SHTDWN;
wire CI_RDY4SHTDWN;
wire SD_RDY4SHTDWN;
wire LD_TXDN;
wire RST_TXDN;
wire HND_SHK;
wire SE0;
wire MOMENTARY_ERR_CNDT;
wire FATAL_ERR_CNDT;
wire PKT_WARN;
wire PKT_ERR;
wire START_TXP;
wire CNFG_DONE;


wire [17:0] INFF_BUSS;
wire [9:0]  INFF_CNT;
wire [7:0]  INPG_CNT;
wire [6:0]  BYTE_CNT;
wire [9:0]  ACCUM_BUSS;
wire [13:0] ADFF_BUSS;
wire [1:0]  ADMY;
wire [9:0]  ADFF_CNT;
wire [9:0]  TRDS_BUSS;
wire [3:0]  TRDS_FF_CNT;
wire [9:0]  TRDS_CNT;
wire [14:0] PGRD_BUSS;
wire [5:0]  PGRD_FF_CNT;
wire [6:0]  RD_CNT;

wire VLD;
wire PSH_FL;
wire SET_NPG;
wire RST_NPG;
wire INFF_MT;
wire INFF_FULL;
wire INFF_AMT;
wire INFF_AF;
wire INFF_WTERR;
wire INFF_RDERR;
wire DEC_INPG;
wire LD_INPG;
wire LAST_PAGE;
wire LD_BYTE;
wire LAST_BYTE;
wire CLR_ACCUM;
wire CLR_RCV1;
wire CLR_RCV2;

wire READ_ADFF;
wire ADFF_MT;
wire ADFF_FULL;
wire ADFF_AMT;
wire ADFF_AF;
wire ADFF_WTERR;
wire ADFF_RDERR;

wire DMP_HDR;
wire FF2SRL;
wire FF2HFF;
wire RD_TRDS;
wire PSH_TRDS;
wire PSH_EWRAP;
wire TRDS_MT;
wire TRDS_FULL;
wire TRDS_AMT;
wire TRDS_AF;
wire TRDS_WTERR;
wire TRDS_RDERR;
wire DEC_TRDS;
wire LD_TRDS;
wire PKT_DONE;

wire RD_PGRD;
wire PSH_PGRD;
wire PGRD_MT;
wire PGRD_FULL;
wire PGRD_AMT;
wire PGRD_AF;
wire PGRD_WTERR;
wire PGRD_RDERR;
wire DEC_RD;
wire LD_RD;
wire LAST_READ;
wire SEL_PAGE;

wire EWRAP_MT;
wire EWRAP_FULL;
wire EWRAP_AMT;
wire EWRAP_AF;
wire EWRAP_WTERR;
wire EWRAP_RDERR;
wire [4:0]EWRAP_BUSS;
wire [4:0]EWRAP_FF_CNT;

reg  PSH_HFF;
wire RD_HFF;
wire HFF_MT;
wire HFF_FULL;
wire HFF_AMT;
wire HFF_AF;
wire HFF_WTERR;
wire HFF_RDERR;
wire [17:0] HFF_OUT;
wire [6:0]HFF_CNT;

wire DATA_CMPLT;
wire NO_READS;
wire READS;

reg  INFF_AF_R;
reg  INFF_WTERR_R;
reg  INFF_RDERR_R;
reg  ADFF_WTERR_R;
reg  ADFF_RDERR_R;
reg  TRDS_WTERR_R;
reg  TRDS_RDERR_R;
reg  PGRD_WTERR_R;
reg  PGRD_RDERR_R;

assign MOMENTARY_ERR_CNDT = !MID_ERR && SD_ERR && S_DATA;
assign FATAL_ERR_CNDT = 0;
assign SEL_ERR = (FL_TXP_ST == `TxP_Data) && S_ERR;
assign SE0 = SEL_ERR && !SEL_ERR_R;
assign PKT_WARN = SEL_RCV && INFF_AF_R;
assign SD_WARN  = 0;
assign CP_ERR   = SEL_RCV && (INFF_WTERR_R || RCV_ERR) && (MSG_LVL > 2'h0);
assign PKT_ERR  = CP_ERR;
assign CI_ERR   = RCV1 && (INFF_RDERR_R || TRDS_WTERR_R || PGRD_WTERR_R) && (MSG_LVL > 2'h0);
assign SD_ERR   = RCV2 && (TRDS_RDERR_R || PGRD_RDERR_R || ADFF_WTERR_R || ADFF_RDERR_R) && (MSG_LVL > 2'h0);
assign RST_TXDN = !(|(TXDN_MSK & {CP_SND_ERR, CP_SND_WRN, CI_SND_ERR, CI_SND_ACK, SD_SND_ERR, SD_SND_DATA}));
assign S_ERR = CP_SND_ERR || CP_SND_WRN || CI_SND_ERR || SD_SND_ERR;
assign S_ACK = CI_SND_ACK;
assign S_DATA = SD_SND_DATA;
assign START_TXP = (S_ERR || S_ACK || S_DATA);
assign STAT = TXP_INI_STAT || TXP_MID_STAT || TXP_INC_STAT || TXP_FIN_STAT;
assign RDY4SHTDWN = CP_RDY4SHTDWN && CI_RDY4SHTDWN && SD_RDY4SHTDWN;


assign VALDAT     = (CTRL == `Rx_Data);
assign OPCODE     = (CTRL == `Rx_OpCode);
assign EOP        = (CTRL == `Rx_EOP);
assign MBIT       = (CTRL == `Rx_MAC);
assign HBIT       = (CTRL == `Rx_HDR);
assign RCV_ERR1   = (CTRL == `Rx_ErrWrd1);
assign RCV_ERR2   = (CTRL == `Rx_ErrWrd2);

assign FL_RW_CMD  = (FUNCT == `Flash_R_W);

assign IDLE         = (FL_CP_ST  == `FL_CP_Idle);
assign RST_CP_ERRS  = (FL_CP_ST  == `FL_CP_Idle);
assign HOLD         =!(FL_CP_ST  == `FL_CP_RmHold);
assign GET_FUNCT    = (FL_CP_ST  == `FL_CP_Get_Funct);
assign GET_MAC      = (FL_CP_ST  == `FL_CP_Get_MAC);
assign GET_FRAME    = (FL_CP_ST  == `FL_CP_Get_Frame);
assign DMY_GET      = (FL_CP_ST  == `FL_CP_Dmy_Get);
assign SRL2FF       = (FL_CP_ST  == `FL_CP_SRL2FF);
assign CP_SND_ERR   = (FL_CP_ST  == `FL_CP_Snd_Err);
assign CP_SND_WRN   = (FL_CP_ST  == `FL_CP_Snd_Warn);
assign CP_RDY4SHTDWN = (FL_CP_ST  == `FL_CP_Rdy4Shtdwn);
assign RD_CP_SRL    = MSRL1 && (CP_SND_ERR || CP_SND_WRN);
assign CP_SRL_CE    = MBIT || HBIT || SRL2FF || RD_CP_SRL; 
assign D1 = VALDAT && !VALDAT_R;

assign LAST_BYTE   = (BYTE_CNT == 7'd1);
assign LAST_PAGE   = (INPG_CNT == 8'd0);
assign NO_READS    = (ACCUM_BUSS == 10'd0);
assign READS       = !NO_READS;
assign DATA_CMPLT  = (ADFF_CNT >= TRDS_CNT);
assign PKT_DONE    = (TRDS_CNT == 10'd1);
assign LAST_READ   = (RD_CNT == 7'd1);
assign LD_ACCUM    = LD_BYTE && !INFF_BUSS[15];
assign PSH_PGRD    = LD_ACCUM;

assign CAP_RSPNS    = (FL_TXP_ST == `TxP_Idle) && START_TXP;
assign MSRL1        = (FL_TXP_ST == `TxP_MAC);
assign TXP_INI_STAT = (FL_TXP_ST == `TxP_Ini_Stat);
assign TXP_MID_STAT = (FL_TXP_ST == `TxP_Mid_Stat);
assign TXP_INC_STAT = (FL_TXP_ST == `TxP_Inc_Stat);
assign TXP_FIN_STAT = (FL_TXP_ST == `TxP_Fin_Stat);
assign TXP_DATA     = (FL_TXP_ST == `TxP_Data);
assign TXP_SND_PKT  = (FL_TXP_ST == `TxP_Send_Pkt);
assign FLUSH        = (FL_TXP_ST == `TxP_Flush);
assign CLR_INTR_ERR = (FL_TXP_ST == `TxP_Clr_Intr);
assign RST_INTR_ERR = CLR_INTR_ERR || RST;
assign LD_TXDN      = !BG && (FL_TXP_ST == `TxP_Rel_Bus);
assign HND_SHK      = (FL_TXP_ST == `TxP_Done) && (TXDN == `FL_No_Req);

assign CLR_ACCUM   =             (FLCI_ST == `FLCI_Idle);
assign CLR_RCV1    =             (FLCI_ST == `FLCI_Idle);
assign RST_CI_ERRS =             (FLCI_ST == `FLCI_Idle);
assign LD_INPG     =             (FLCI_ST == `Ld_NumPg);
assign LD_BYTE     =             (FLCI_ST == `Ld_WPNB);
assign DEC_INPG    =             (FLCI_ST == `Rd_WPNB);
assign SET_NPG     = DEC_INPG;
assign RST_NPG     =             (FLCI_ST == `Xfer2Fl);
assign PSH_FL      = !INFF_MT && (FLCI_ST == `Xfer2Fl);
assign PSH_TRDS    =             (FLCI_ST == `Push_TRDS);
assign PSH_EWRAP   =             (FLCI_ST == `Push_EWRAP);
assign DMP_HDR     =             (FLCI_ST == `Dmp_Hdr);
assign FF2SRL      =             (FLCI_ST == `FF2SRL);
assign FF2HFF      =             (FLCI_ST == `FF2HFF);
assign CI_SND_ACK  =             (FLCI_ST  == `FLCI_Snd_Ack);
assign CI_SND_ERR  =             (FLCI_ST  == `FLCI_Snd_Err);
assign CI_RDY4SHTDWN =           (FLCI_ST  == `FLCI_Rdy4Shtdwn);
assign RD_CI_SRL   = MSRL1 && (CI_SND_ERR || CI_SND_ACK);
assign CI_SRL_CE   = FF2SRL2 || PSH_HFF || RD_CI_SRL; 


assign CLR_RCV2    = (FL_SD_ST == `FL_SD_Idle);
assign RST_SD_ERRS = (FL_SD_ST == `FL_SD_Idle);
assign RD_TRDS     = (FL_SD_ST == `Rd_Counts);
assign RD_PGRD     = (FL_SD_ST == `Rd_Counts) || (FL_SD_ST == `Rd_Pg_Rd);
assign LD_TRDS     = (FL_SD_ST == `Ld_Counts);
assign LD_RD       = (FL_SD_ST == `Ld_Counts) || (FL_SD_ST == `Ld_Pg_Rd);
assign RD_HFF      = (FL_SD_ST == `HFF2SDSRL);
assign SEL_PAGE    = (FL_SD_ST == `Xmit_Page);
assign DEC_TRDS    = (FL_SD_ST == `Xmit_Reads);
assign SD_RDY4SHTDWN = (FL_SD_ST  == `FL_SD_Rdy4Shtdwn);
assign DEC_RD      = DEC_TRDS;
assign READ_ADFF   = DEC_TRDS;
assign VLD         = DEC_TRDS;
assign SD_SND_ERR  = (FL_SD_ST == `FL_SD_Snd_Err);
assign CNFG_DONE   = (FL_SD_ST == `Cnfg_Done);
assign FL_SD_DATA_DONE = (FL_SD_ST == `Data_Done);
assign RD_SD_SRL   = MSRL1 && (SD_SND_ERR || SD_SND_DATA);
assign SD_SRL_CE   = HFF2SDSRL2 || RD_SD_SRL; 

assign CP_INP      = (RSPNS == `FL_CP_Err) || (RSPNS == `FL_CP_Warn);
assign CI_INP      = (RSPNS == `FL_CI_Err) || (RSPNS == `FL_CI_Ack);
assign SD_INP      = (RSPNS == `FL_SD_Err) || (RSPNS == `FL_SD_Data);

/////////////////////////
// Input Registers     //
/////////////////////////

always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         FUNCT <= 8'h00;
         ACK   <= 0;
         PRIO  <= 0;
      end
   else
      if(SEL && (RCTRL == `Rx_OpCode) && GET_FUNCT) // this is RCTRL not CTRL
         begin
            FUNCT <= RCVDATA[7:0];
            ACK   <= RCVDATA[13];
            PRIO  <= RCVDATA[14];
         end
      else
         begin
            FUNCT <= FUNCT;
            ACK   <= ACK;
            PRIO  <= PRIO;
         end
end
always @(FUNCT)
begin
   case(FUNCT)
      `Flash_R_W:
         FL_DEF <= 1;
      default:
         FL_DEF <= 0;
   endcase
end

always @(posedge CLK)
begin
   FROM_CNFG_1 <= FROM_CNFG;
   FLC_DV_1 <= FLC_DV;
   DATA <= RCVDATA;
   CTRL <= RCTRL;
   VALDAT_R <= VALDAT;
   D2 <= D1;
   HDR_DN <= HBIT;
   ST_TY <= {STATUS,TYPE};
   SRL2FF2 <= SRL2FF;
   SRL2FF3 <= SRL2FF2;
   SRL2FF4 <= SRL2FF3;
   SRLDONE <= SRL2FF4;
   MSRL2 <= MSRL1;
   MSRL3 <= MSRL2;
   MSRL4 <= MSRL3;
   MAC_DONE <= MSRL4;
   CP_MAC_HDR_SRL_R <= CP_MAC_HDR_SRL;
   CI_MAC_HDR_SRL_R <= CI_MAC_HDR_SRL;
   SD_MAC_HDR_SRL_R <= SD_MAC_HDR_SRL;
   CP_H_BIT         <= CP_MHBITS_SRL[0];
   CI_H_BIT         <= CI_MHBITS_SRL[0];
   SD_H_BIT         <= SD_MHBITS_SRL[0];
   GET_FRAME_R <= GET_FRAME;
   CD1 <= CNFG_DONE;
   CD2 <= CD1;
   FL_CNFG_NOW_DONE <= CD2;
   TXP_DATA_R <= DATA_FLAG;
   VLD1 <= VLD;
   CDV <= !RCV2 && (SEL_PAGE || VLD1);
   FL_CNFG_ODV <= CDV;
   BC1 <= FLUSH;
   BUS_CLR <= BC1;
   SEL_ERR_R <= SEL_ERR;
   SE1 <= SE0;
   SE2 <= SE1;
   SE3 <= SE2;
   STAT_R <= STAT;
   SND_PKT_R <= TXP_SND_PKT;
end


always @(posedge CLK or posedge RST_CP_ERRS)
begin
   if(RST_CP_ERRS)
      begin
         RCV_ERR_WRD1 <= 16'h0000;
         RCV_ERR_WRD2 <= 16'h0000;
         RCV_ERR <= 0;
      end
   else
      if(RCV_ERR1 && FL_DEF)
         begin
            RCV_ERR_WRD1 <= DATA;
            RCV_ERR_WRD2 <= RCV_ERR_WRD2;
            RCV_ERR <= 1;
         end
      else if(RCV_ERR2 && FL_DEF)
         begin
            RCV_ERR_WRD1 <= RCV_ERR_WRD1;
            RCV_ERR_WRD2 <= DATA;
            RCV_ERR <= 1;
         end
      else
         begin
            RCV_ERR_WRD1 <= RCV_ERR_WRD1;
            RCV_ERR_WRD2 <= RCV_ERR_WRD2;
            RCV_ERR <= RCV_ERR;
         end
end
always @(posedge CLK or posedge RST_CP_ERRS)
begin
   if(RST_CP_ERRS)
      begin
         INFF_AF_R    <= 0;
         INFF_WTERR_R <= 0;
      end
   else
      begin
         INFF_AF_R    <= INFF_AF    ? 1 : INFF_AF_R;
         INFF_WTERR_R <= INFF_WTERR ? 1 : INFF_WTERR_R;
      end
end
always @(posedge CLK or posedge RST_CI_ERRS)
begin
   if(RST_CI_ERRS)
      begin
         INFF_RDERR_R <= 0;
         TRDS_WTERR_R <= 0;
         PGRD_WTERR_R <= 0;
      end
   else
      begin
         INFF_RDERR_R <= INFF_RDERR ? 1 : INFF_RDERR_R;
         TRDS_WTERR_R <= TRDS_WTERR ? 1 : TRDS_WTERR_R;
         PGRD_WTERR_R <= PGRD_WTERR ? 1 : PGRD_WTERR_R;
      end
end
always @(posedge CLK or posedge RST_SD_ERRS)
begin
   if(RST_SD_ERRS)
      begin
         TRDS_RDERR_R <= 0;
         PGRD_RDERR_R <= 0;
         ADFF_WTERR_R <= 0;
         ADFF_RDERR_R <= 0;
      end
   else
      begin
         TRDS_RDERR_R <= TRDS_RDERR ? 1 : TRDS_RDERR_R;
         PGRD_RDERR_R <= PGRD_RDERR ? 1 : PGRD_RDERR_R;
         ADFF_WTERR_R <= ADFF_WTERR ? 1 : ADFF_WTERR_R;
         ADFF_RDERR_R <= ADFF_RDERR ? 1 : ADFF_RDERR_R;
      end
end
always @(posedge CLK)
begin
   if(!SEL_RCV)
      FL_ERRS[0] <= INFF_WTERR;
   else
      FL_ERRS[0] <= 0;
   if(!RCV1)
      FL_ERRS[2:1] <= {TRDS_WTERR,INFF_RDERR};
   else
      FL_ERRS[2:1] <= 2'b00;
   if(!RCV2)
      FL_ERRS[3] <= TRDS_RDERR;
   else
      FL_ERRS[3] <= 0;
   if(!RCV1)
      FL_ERRS[4] <= PGRD_WTERR;
   else
      FL_ERRS[4] <= 0;
   if(!RCV2)
      FL_ERRS[7:5] <= {ADFF_RDERR,ADFF_WTERR,PGRD_RDERR};
   else
      FL_ERRS[7:5] <= 3'b000;
end

always @(RCV_ERR or FL_DEF or INFF_AF_R or INFF_WTERR_R)
begin
   if(RCV_ERR)
      CP_ERR_HDR <= {`Flash_mod,`HDR_Error,`ER_Rcv_Err};
   else if(!FL_DEF)
      CP_ERR_HDR <= {`Flash_mod,`HDR_Error,`CP_Not_Def};
   else if(INFF_WTERR_R)
      CP_ERR_HDR <= {`Flash_mod,`HDR_Error,`FL_In_WtErr};
   else if(INFF_AF_R)
      CP_ERR_HDR <= {`Flash_mod,`HDR_Warn,`FL_In_AF};
   else
      CP_ERR_HDR <= {`Flash_mod,`HDR_Info,`G_No_Info};
end
always @(INFF_RDERR_R or TRDS_WTERR_R or PGRD_WTERR_R)
begin
   if(INFF_RDERR_R)
      CI_ERR_HDR <= {`Flash_mod,`HDR_Error,`FL_In_RdErr};
   else if(TRDS_WTERR_R)
      CI_ERR_HDR <= {`Flash_mod,`HDR_Error,`FL_TRDS_WtErr};
   else if(PGRD_WTERR_R)
      CI_ERR_HDR <= {`Flash_mod,`HDR_Error,`FL_PgRd_WtErr};
   else
      CI_ERR_HDR <= {`Flash_mod,`HDR_Info,`G_No_Info};
end
always @(TRDS_RDERR_R or PGRD_RDERR_R or ADFF_WTERR_R or ADFF_RDERR_R)
begin
   if(TRDS_RDERR_R)
      SD_ERR_HDR <= {`Flash_mod,`HDR_Error,`FL_TRDS_RdErr};
   else if(PGRD_RDERR_R)
      SD_ERR_HDR <= {`Flash_mod,`HDR_Error,`FL_PgRd_RdErr};
   else if(ADFF_WTERR_R)
      SD_ERR_HDR <= {`Flash_mod,`HDR_Error,`FL_ADFF_WtErr};
   else if(ADFF_RDERR_R)
      SD_ERR_HDR <= {`Flash_mod,`HDR_Error,`FL_ADFF_RdErr};
   else
      SD_ERR_HDR <= {`Flash_mod,`HDR_Info,`G_No_Info};
end


always @(posedge CLK or posedge RST_INTR_ERR)
begin
   if(RST_INTR_ERR)
      INTR_ERR <= 0;
   else
      if(MOMENTARY_ERR_CNDT)
         INTR_ERR <= 1;
      else
         INTR_ERR <= INTR_ERR;
end
always @(posedge CLK or posedge RST_SD_ERRS)
begin
   if(RST_SD_ERRS)
      MID_ERR <= 0;
   else
      if(INTR_ERR)
         MID_ERR <= 1;
      else
         MID_ERR <= MID_ERR;
end
always @(posedge CLK or posedge RST_SD_ERRS)
begin
   if(RST_SD_ERRS)
      FATAL_ERR <= 0;
   else
      if(FATAL_ERR_CNDT)
         FATAL_ERR <= 1;
      else
         FATAL_ERR <= FATAL_ERR;
end

always @(DATA or MBIT or HBIT or CP_MAC_HDR_SRL or CP_MHBITS_SRL)
begin  // mux for SRL input
   if(MBIT || HBIT)
      begin
         CP_SRL_IN_DAT <= DATA;
         CP_SRL_IN_BITS <= {MBIT,HBIT};
      end
   else
      begin
         CP_SRL_IN_DAT <= CP_MAC_HDR_SRL;
         CP_SRL_IN_BITS <= CP_MHBITS_SRL;
      end
end

macsrl  cp_srl(.clk(CLK),.ce(CP_SRL_CE),.mhin(CP_SRL_IN_BITS),.din(CP_SRL_IN_DAT),.mhout(CP_MHBITS_SRL),.dout(CP_MAC_HDR_SRL));

always @(FROM_CNFG_1 or DATA or CP_MAC_HDR_SRL or CP_MHBITS_SRL or SEL_RCV or SRL2FF or FL_RW_CMD or D1 or
         VALDAT or FLC_DV_1 or GET_FRAME or PKT_ERR or PKT_WARN or ACK or PRIO)
begin  // mux for IN_FIFO input
   if(SRL2FF)
      begin
         INBUS <= {CP_MHBITS_SRL,CP_MAC_HDR_SRL};
         PUSH_INFF <= 1;
      end
   else if(SEL_RCV && FL_RW_CMD && D1)
      begin  
         INBUS <= {PKT_ERR,PKT_WARN,1'b1,ACK,PRIO,1'b0,DATA[11:0]};
         PUSH_INFF <= VALDAT && GET_FRAME;
      end
   else if(SEL_RCV && FL_RW_CMD)
      begin  
         INBUS <= {PKT_ERR,PKT_WARN,DATA};
         PUSH_INFF <= VALDAT && GET_FRAME;
      end
   else
      begin
         INBUS <= {2'b00,FROM_CNFG_1};
         PUSH_INFF <= FLC_DV_1;
      end
end

//////////////////////////////////////////////////////////////////
//                                                              //
// Input FIFO for data going to the Flash memory                //
//                                                              //
//////////////////////////////////////////////////////////////////

parameter IN_FIFO_p2depth = 10;
defparam IN_FIFO.p2depth = IN_FIFO_p2depth;
defparam IN_FIFO.width = 18;
defparam IN_FIFO.almostmt = 32;
defparam IN_FIFO.almostfull = (1<<IN_FIFO_p2depth) - 256;
fifo_dpXn_blk  IN_FIFO(.clk(CLK),.rst(RST),.push(PUSH_INFF),.pop(READ_INFF),
               .mt(INFF_MT),.full(INFF_FULL),.amt(INFF_AMT),.af(INFF_AF),.wterr(INFF_WTERR),.rderr(INFF_RDERR),
               .din(INBUS),.dout(INFF_BUSS),.cnt(INFF_CNT));

//////////////////////////////////////////////////////////////////
//                                                              //
// Page/Byte count FIFO.  Stores the total bytes for one page   //
//                                                              //
//////////////////////////////////////////////////////////////////

parameter PG_RdCnt_FIFO_p2depth = 6;
defparam PG_RdCnt_FIFO.p2depth = PG_RdCnt_FIFO_p2depth;
defparam PG_RdCnt_FIFO.width = 15;
defparam PG_RdCnt_FIFO.almostmt = 4;
defparam PG_RdCnt_FIFO.almostfull = (1<<PG_RdCnt_FIFO_p2depth) - 4;
fifo_dpXn_dst  PG_RdCnt_FIFO(.clk(CLK),.rst(RST),.push(PSH_PGRD),.pop(RD_PGRD),
               .mt(PGRD_MT),.full(PGRD_FULL),.amt(PGRD_AMT),.af(PGRD_AF),.wterr(PGRD_WTERR),.rderr(PGRD_RDERR),
               .din(INFF_BUSS[14:0]),.dout(PGRD_BUSS),.cnt(PGRD_FF_CNT));


defparam Read_Accum.in_width = 7;
defparam Read_Accum.out_width = 10;
accum Read_Accum(.clk(CLK),.clr(CLR_ACCUM),.ce(LD_ACCUM),.in(INFF_BUSS[6:0]),.out(ACCUM_BUSS));

defparam In_Pg_Cntr.width = 8;
cnt_dn_l In_Pg_Cntr(.clk(CLK),.dec(DEC_INPG),.r(RST),.l(LD_INPG),.din(INFF_BUSS[7:0]),.count(INPG_CNT));
defparam Byte_Cntr.width = 7;
cnt_dn_l Byte_Cntr(.clk(CLK),.dec(PSH_FL),.r(RST),.l(LD_BYTE),.din(INFF_BUSS[6:0]),.count(BYTE_CNT));

//////////////////////////////////////////////////////////////////
//                                                              //
// Total Reads FIFO.  Stores the total reads in one packet      //
//                                                              //
//////////////////////////////////////////////////////////////////

parameter Tot_Rds_FIFO_p2depth = 4;
defparam Tot_Rds_FIFO.p2depth = Tot_Rds_FIFO_p2depth;
defparam Tot_Rds_FIFO.width = 10;
defparam Tot_Rds_FIFO.almostmt = 2;
defparam Tot_Rds_FIFO.almostfull = (1<<Tot_Rds_FIFO_p2depth) - 2;
fifo_dpXn_dst  Tot_Rds_FIFO(.clk(CLK),.rst(RST),.push(PSH_TRDS),.pop(RD_TRDS),
               .mt(TRDS_MT),.full(TRDS_FULL),.amt(TRDS_AMT),.af(TRDS_AF),.wterr(TRDS_WTERR),.rderr(TRDS_RDERR),
               .din(ACCUM_BUSS),.dout(TRDS_BUSS),.cnt(TRDS_FF_CNT));

//////////////////////////////////////////////////////////////////
//                                                              //
// Err/Warn/Rcv/Ack/Prio FIFO.                                  //
//                                                              //
//////////////////////////////////////////////////////////////////

parameter EWRAP_FIFO_p2depth = 5;
defparam EWRAP_FIFO.p2depth = EWRAP_FIFO_p2depth;
defparam EWRAP_FIFO.width = 5;
defparam EWRAP_FIFO.almostmt = 2;
defparam EWRAP_FIFO.almostfull = (1<<EWRAP_FIFO_p2depth) - 2;
fifo_dpXn_dst  EWRAP_FIFO(.clk(CLK),.rst(RST),.push(PSH_EWRAP),.pop(RD_TRDS),
               .mt(EWRAP_MT),.full(EWRAP_FULL),.amt(EWRAP_AMT),.af(EWRAP_AF),.wterr(EWRAP_WTERR),.rderr(EWRAP_RDERR),
               .din({PKT_ERR1,PKT_WARN1,RCV1,ACK1,PRIO1}),.dout(EWRAP_BUSS),.cnt(EWRAP_FF_CNT));

//////////////////////////////////////////////////////////////////////
//                                                                  //
// MAC Header FIFO.  Stores the MAC and header info for each packet //
//                                                                  //
//////////////////////////////////////////////////////////////////////

parameter HFF_p2depth = 7;
defparam HFF.p2depth = HFF_p2depth;
defparam HFF.width = 18;
defparam HFF.almostmt = 10;
defparam HFF.almostfull = (1<<HFF_p2depth) - 10;
fifo_dpXn_dst  HFF(.clk(CLK),.rst(RST),.push(PSH_HFF),.pop(RD_HFF),
               .mt(HFF_MT),.full(HFF_FULL),.amt(HFF_AMT),.af(HFF_AF),.wterr(HFF_WTERR),.rderr(HFF_RDERR),
               .din(INFF_BUSS),.dout(HFF_OUT),.cnt(HFF_CNT));

defparam Tot_Rds_Cntr.width = 10;
cnt_dn_l Tot_Rds_Cntr(.clk(CLK),.dec(DEC_TRDS),.r(RST),.l(LD_TRDS),.din(TRDS_BUSS),.count(TRDS_CNT));
defparam Rd_Cntr.width = 7;
cnt_dn_l Rd_Cntr(.clk(CLK),.dec(DEC_RD),.r(RST),.l(LD_RD),.din(PGRD_BUSS[6:0]),.count(RD_CNT));


//////////////////////////////////////////////////////////////////
//                                                              //
// Address/Data FIFO for data coming from the Flash memory      //
//                                                              //
//////////////////////////////////////////////////////////////////

parameter AD_FIFO_p2depth = 10;
defparam AD_FIFO.p2depth = AD_FIFO_p2depth;
defparam AD_FIFO.width = 16;
defparam AD_FIFO.almostmt = 32;
defparam AD_FIFO.almostfull = (1<<AD_FIFO_p2depth) - 64;
fifo_dpXn_blk  AD_FIFO(.clk(CLK),.rst(RST),.push(FRFL_DV),.pop(READ_ADFF),
               .mt(ADFF_MT),.full(ADFF_FULL),.amt(ADFF_AMT),.af(ADFF_AF),.wterr(ADFF_WTERR),.rderr(ADFF_RDERR),
               .din({2'b00,FROM_ADDR,FROM_DATA}),.dout({ADMY,ADFF_BUSS}),.cnt(ADFF_CNT));




///////////////////////////////////////////////////////////////
//                                                           //
// Flash Command Processor State Machine                     //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin: FLASH_CP_FSM
   if(RST)
      FL_CP_ST <= `FL_CP_Idle;
   else
      case(FL_CP_ST)
         `FL_CP_Idle:
            if(CNFG_SND_REQ)
               FL_CP_ST <= `FL_CP_RmHold;
            else if(SEL && !CP_RST)
               FL_CP_ST <= `FL_CP_Get_Funct;
            else if(PREP4SHTDWN)
               FL_CP_ST <= `FL_CP_Rdy4Shtdwn;
            else 
               FL_CP_ST <= `FL_CP_Idle;
         `FL_CP_RmHold:
            if(!CNFG_SND_REQ)
               FL_CP_ST <= `FL_CP_Idle;
            else if(INFF_AF)
               FL_CP_ST <= `FL_CP_Hold;
            else 
               FL_CP_ST <= `FL_CP_RmHold;
         `FL_CP_Hold:
            if(!CNFG_SND_REQ)
               FL_CP_ST <= `FL_CP_Idle;
            else if(INFF_AMT)
               FL_CP_ST <= `FL_CP_RmHold;
            else 
               FL_CP_ST <= `FL_CP_Hold;
         `FL_CP_Get_Funct:
            if(OPCODE)
               FL_CP_ST <= `FL_CP_Get_MAC;
            else 
               FL_CP_ST <= `FL_CP_Get_Funct;
         `FL_CP_Get_MAC:
            if(HDR_DN)
               FL_CP_ST <= `FL_CP_isAF;
            else 
               FL_CP_ST <= `FL_CP_Get_MAC;
         `FL_CP_isAF:
            if(!FL_DEF)
               FL_CP_ST <= `FL_CP_Dmy_Get;
            else if(INFF_AF && (MSG_LVL > 2'h1))
               FL_CP_ST <= `FL_CP_Snd_Warn;
            else
               FL_CP_ST <= `FL_CP_Get_Frame;
         `FL_CP_Get_Frame:
            if(EOP)
               FL_CP_ST <= `FL_CP_SRL2FF;
            else 
               FL_CP_ST <= `FL_CP_Get_Frame;
         `FL_CP_SRL2FF:
            begin
               if(SRLDONE && CP_ERR)
                  FL_CP_ST <= `FL_CP_Snd_Err;
               else if(SRLDONE && !CP_ERR)
                  FL_CP_ST <= `FL_CP_Idle;
               else
                  FL_CP_ST <= `FL_CP_SRL2FF;
            end
         `FL_CP_Snd_Warn:
            if(TXDN == `FL_CP_Warn)
               FL_CP_ST <= `FL_CP_isAMT;
            else 
               FL_CP_ST <= `FL_CP_Snd_Warn;
         `FL_CP_isAMT:
            if(INFF_AMT)
               FL_CP_ST <= `FL_CP_isAF;
            else 
               FL_CP_ST <= `FL_CP_isAMT;
         `FL_CP_Dmy_Get:
            if(EOP)
               if(MSG_LVL > 2'h0)
                  FL_CP_ST <= `FL_CP_Snd_Err;
               else
                  FL_CP_ST <= `FL_CP_Idle;
            else 
               FL_CP_ST <= `FL_CP_Dmy_Get;
         `FL_CP_Snd_Err:
            if(TXDN == `FL_CP_Err)
               FL_CP_ST <= `FL_CP_Idle;
            else 
               FL_CP_ST <= `FL_CP_Snd_Err;
         `FL_CP_Rdy4Shtdwn:
            FL_CP_ST <= `FL_CP_Rdy4Shtdwn;
         default:
            FL_CP_ST <= `FL_CP_Idle;
      endcase
end

always @(FL_CP_ST)
begin
   case (FL_CP_ST)
      `FL_CP_Get_Funct,`FL_CP_isAMT,`FL_CP_Get_Frame,`FL_CP_SRL2FF,
      `FL_CP_Snd_Warn,`FL_CP_isAF,`FL_CP_Dmy_Get,`FL_CP_Snd_Err:
         begin
            SEL_RCV <= 1;
         end
      default:
         begin
            SEL_RCV <= 0;
         end
   endcase
end


///////////////////////////////////////////////////////////////
//                                                           //
// Flash Memory Input FIFO Control State Machine             //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin: FLASH_MEM_INP_CTRL_FSM
   if(RST)
      FLCI_ST <= `FLCI_Idle;
   else
      case(FLCI_ST)
         `FLCI_Idle:
            if(!INFF_MT)
               FLCI_ST <= `Rd_NumPg;
            else if(PREP4SHTDWN)
               FLCI_ST <= `FLCI_Rdy4Shtdwn;
            else 
               FLCI_ST <= `FLCI_Idle;
         `Rd_NumPg:
            FLCI_ST <= `Ld_NumPg;
         `Ld_NumPg:
            FLCI_ST <= `Rd_WPNB;
         `Rd_WPNB:
            FLCI_ST <= `Ld_WPNB;
         `Ld_WPNB:
            FLCI_ST <= `W4Rdy;
         `W4Rdy:
            if(RDY4INP)
               FLCI_ST <= `Xfer2Fl;
            else 
               FLCI_ST <= `W4Rdy;
         `Xfer2Fl:
            if(LAST_PAGE && LAST_BYTE && NO_READS && !RCV1)
               FLCI_ST <= `FLCI_Idle;
            else if(LAST_PAGE && LAST_BYTE && NO_READS && RCV1 && (ACK1 || CI_ERR))
               FLCI_ST <= `FF2SRL;
            else if(LAST_PAGE && LAST_BYTE && NO_READS && RCV1)
               FLCI_ST <= `Dmp_Hdr;
            else if(LAST_PAGE && LAST_BYTE && READS)
               FLCI_ST <= `Push_TRDS;
            else if(LAST_BYTE && !LAST_PAGE) 
               FLCI_ST <= `Rd_WPNB;
            else if(!RDY4INP) 
               FLCI_ST <= `W4Rdy;
            else
               FLCI_ST <= `Xfer2Fl;
         `Push_TRDS:
            FLCI_ST <= `Push_EWRAP;
         `Push_EWRAP:
            if(RCV1)
               FLCI_ST <= `FF2HFF;
            else 
               FLCI_ST <= `FLCI_Idle;
         `Dmp_Hdr:
            if(HDR_RD_DONE)
               FLCI_ST <= `FLCI_Idle;
            else 
               FLCI_ST <= `Dmp_Hdr;
         `FF2SRL:
            if(HDR_RD_DONE && ACK1)
               FLCI_ST <= `FLCI_Snd_Ack;
            else if(HDR_RD_DONE && CI_ERR)
               FLCI_ST <= `FLCI_Snd_Err;
            else 
               FLCI_ST <= `FF2SRL;
         `FF2HFF:
            if(HDR_RD_DONE && CI_ERR)
               FLCI_ST <= `FLCI_Snd_Err;
            else if(HDR_RD_DONE)
               FLCI_ST <= `FLCI_Idle;
            else 
               FLCI_ST <= `FF2HFF;
         `FLCI_Snd_Ack:
            if((TXDN == `FL_CI_Ack) && CI_ERR)
               FLCI_ST <= `FLCI_Snd_Err;
            else if(TXDN == `FL_CI_Ack)
               FLCI_ST <= `FLCI_Idle;
            else 
               FLCI_ST <= `FLCI_Snd_Ack;
         `FLCI_Snd_Err:
            if(TXDN == `FL_CI_Err)
               FLCI_ST <= `FLCI_Idle;
            else 
               FLCI_ST <= `FLCI_Snd_Err;
         `FLCI_Rdy4Shtdwn:
            FLCI_ST <= `FLCI_Rdy4Shtdwn;
         default:
            FLCI_ST <= `FLCI_Idle;
      endcase
end


always @(FLCI_ST or INFF_MT)
begin
   case (FLCI_ST)
      `Rd_NumPg,`Rd_WPNB,`Dmp_Hdr,`FF2SRL,`FF2HFF:
         READ_INFF <= 1;
      `Xfer2Fl:
         READ_INFF <= !INFF_MT;
      default:
         READ_INFF <= 0;
   endcase
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      NPG <= 0;
   else
      if(RST_NPG)
         NPG <= 0;
      else if(SET_NPG)
         NPG <= 1;
      else
         NPG <= NPG;
end

always @(posedge CLK)
begin
   PSH_FL1 <= PSH_FL;
   PUSH <= PSH_FL1;
   NPG1 <= NPG & PSH_FL;
   NEW_PAGE <= NPG1;
   PSH_HFF <= FF2HFF;
   TO_DATA <= INFF_BUSS[7:0];
   ADDR <= INFF_BUSS[13:8];
//
   if(CLR_RCV1)
      begin
         PKT_ERR1 <= 0;
         PKT_WARN1 <= 0;
         RCV1 <= 0;
         ACK1 <= 0;
         PRIO1 <= 0;
      end
   else if(LD_INPG)
      begin
         PKT_ERR1 <= INFF_BUSS[17];
         PKT_WARN1 <= INFF_BUSS[16];
         RCV1 <= INFF_BUSS[15];
         ACK1 <= INFF_BUSS[14];
         PRIO1 <= INFF_BUSS[13];
      end
   else if(LD_BYTE || PSH_FL1)
      begin
         PKT_ERR1 <= PKT_ERR1 || INFF_BUSS[17];
         PKT_WARN1 <= PKT_WARN1 || INFF_BUSS[16];
         RCV1 <= RCV1;
         ACK1 <= ACK1;
         PRIO1 <= PRIO1;
      end
   else
      begin
         PKT_ERR1 <= PKT_ERR1 || CI_ERR;
         PKT_WARN1 <= PKT_WARN1;
         RCV1 <= RCV1;
         ACK1 <= ACK1;
         PRIO1 <= PRIO1;
      end
//
   if(LD_BYTE)
      begin
         WR_RDB <= INFF_BUSS[15];
         PAGE <= INFF_BUSS[14:8];
      end
   else
      begin
         WR_RDB <= WR_RDB;
         PAGE <= PAGE;
      end
//
   if(CLR_RCV2)
      begin
         PKT_ERR2 <= 0;
         PKT_WARN2 <= 0;
         RCV2 <= 0;
         ACK2 <= 0;
         PRIO2 <= 0;
      end
   else if(LD_TRDS)
      begin
         PKT_ERR2 <= EWRAP_BUSS[4];
         PKT_WARN2 <= EWRAP_BUSS[3];
         RCV2 <= EWRAP_BUSS[2];
         ACK2 <= EWRAP_BUSS[1];
         PRIO2 <= EWRAP_BUSS[0];
      end
   else
      begin
         PKT_ERR2 <= PKT_ERR2 || SD_ERR;
         PKT_WARN2 <= PKT_WARN2;
         RCV2 <= RCV2;
         ACK2 <= ACK2;
         PRIO2 <= PRIO2;
      end
//
   if(LD_RD)
      begin
         PAGE_REG <= PGRD_BUSS[14:8];
         DCODE <= PGRD_BUSS[7];
      end
   else
      begin
         PAGE_REG <= PAGE_REG;
         DCODE <= DCODE;
      end
//
   HDRRD2      <= DMP_HDR || FF2SRL || FF2HFF;
   HDRRD3      <= HDRRD2;
   HDRRD4      <= HDRRD3;
   HDR_RD_DONE <= HDRRD4;
   FF2SRL2     <= FF2SRL;
   HFF2SDSRL2  <= RD_HFF;
   HFF2SDSRL3  <= HFF2SDSRL2;
   HFF2SDSRL4  <= HFF2SDSRL3;
   HFFRD_DN    <= HFF2SDSRL4;
end

always @(FF2SRL2 or PSH_HFF or INFF_BUSS or CI_MAC_HDR_SRL or CI_MHBITS_SRL)
begin  // mux for SRL input
   if(FF2SRL2 || PSH_HFF)
      begin
         CI_SRL_IN_DAT <= INFF_BUSS[15:0];
         CI_SRL_IN_BITS <= INFF_BUSS[17:16];
      end
   else
      begin
         CI_SRL_IN_DAT <= CI_MAC_HDR_SRL;
         CI_SRL_IN_BITS <= CI_MHBITS_SRL;
      end
end

macsrl  ci_srl(.clk(CLK),.ce(CI_SRL_CE),.mhin(CI_SRL_IN_BITS),.din(CI_SRL_IN_DAT),.mhout(CI_MHBITS_SRL),.dout(CI_MAC_HDR_SRL));




///////////////////////////////////////////////////////////////
//                                                           //
// Flash Memory Transfer to GbE State Machine                //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin: Flash_Send_Data_FSM
   if(RST)
      FL_SD_ST <= `FL_SD_Idle;
   else
      case(FL_SD_ST)
         `FL_SD_Idle:
            if(!TRDS_MT)
               FL_SD_ST <= `Rd_Counts;
            else if(PREP4SHTDWN)
               FL_SD_ST <= `FL_SD_Rdy4Shtdwn;
            else 
               FL_SD_ST <= `FL_SD_Idle;
         `Rd_Counts:
            FL_SD_ST <= `Ld_Counts;
         `Ld_Counts:
            FL_SD_ST <= `Chk_Rcv2;
         `Chk_Rcv2:
            if(RCV2)
               FL_SD_ST <= `HFF2SDSRL;
            else 
               FL_SD_ST <= `W4AllRds;
         `HFF2SDSRL:
            if(HFFRD_DN)
               FL_SD_ST <= `W4AllRds;
            else 
               FL_SD_ST <= `HFF2SDSRL;
         `W4AllRds:
            if(DATA_CMPLT && RCV2)
               FL_SD_ST <= `FL_Snd_Data;
            else if(DATA_CMPLT && !RCV2)
               FL_SD_ST <= `Xmit_Page;
            else 
               FL_SD_ST <= `W4AllRds;
         `FL_Snd_Data:
            if((RSPNS == `FL_SD_Data) && TXP_DATA)
               FL_SD_ST <= `Xmit_Page;
            else 
               FL_SD_ST <= `FL_Snd_Data;
         `Xmit_Page:
            FL_SD_ST <= `Xmit_Reads;
         `Xmit_Reads:
            if(LAST_READ && PKT_DONE && !RCV2)
               FL_SD_ST <= `Cnfg_Done;
            else if(LAST_READ && PKT_DONE && RCV2)
               FL_SD_ST <= `Data_Done;
            else if(LAST_READ && !PKT_DONE)
               FL_SD_ST <= `Rd_Pg_Rd;
            else 
               FL_SD_ST <= `Xmit_Reads;
         `Rd_Pg_Rd:
            FL_SD_ST <= `Ld_Pg_Rd;
         `Ld_Pg_Rd:
            FL_SD_ST <= `Xmit_Page;
         `Cnfg_Done:
            FL_SD_ST <= `W4Cnfg;
         `W4Cnfg:
            if(FL_CNFG_NOW_DONE)
               FL_SD_ST <= `FL_SD_Idle;
            else 
               FL_SD_ST <= `W4Cnfg;
         `Data_Done:
            if((RSPNS == `FL_SD_Data) && !TXP_DATA)
               FL_SD_ST <= `W4TXDone;
            else 
               FL_SD_ST <= `Data_Done;
         `W4TXDone:
            if((TXDN == `FL_SD_Data) && SD_ERR)
               FL_SD_ST <= `FL_SD_Snd_Err;
            else if((TXDN == `FL_SD_Data) && !SD_ERR)
               FL_SD_ST <= `FL_SD_Idle;
            else 
               FL_SD_ST <= `W4TXDone;
         `FL_SD_Snd_Err:
            if(TXDN == `FL_SD_Err)
               FL_SD_ST <= `FL_SD_Idle;
            else 
               FL_SD_ST <= `FL_SD_Snd_Err;
         `FL_SD_Rdy4Shtdwn:
            FL_SD_ST <= `FL_SD_Rdy4Shtdwn;
         default:
            FL_SD_ST <= `FL_SD_Idle;
      endcase
end

always @(FL_SD_ST or RCV2)
begin
   case (FL_SD_ST)
      `FL_Snd_Data,`Data_Done,`W4TXDone:
         SD_SND_DATA <= 1;
      `Xmit_Page,`Xmit_Reads,`Rd_Pg_Rd,`Ld_Pg_Rd:
         SD_SND_DATA <= RCV2;
      default:
         SD_SND_DATA <= 0;
   endcase
end


always @(HFF2SDSRL2 or HFF_OUT or SD_MAC_HDR_SRL or SD_MHBITS_SRL)
begin  // mux for SRL input
   if(HFF2SDSRL2)
      begin
         SD_SRL_IN_DAT <= HFF_OUT[15:0];
         SD_SRL_IN_BITS <= HFF_OUT[17:16];
      end
   else
      begin
         SD_SRL_IN_DAT <= SD_MAC_HDR_SRL;
         SD_SRL_IN_BITS <= SD_MHBITS_SRL;
      end
end

macsrl  sd_srl(.clk(CLK),.ce(SD_SRL_CE),.mhin(SD_SRL_IN_BITS),.din(SD_SRL_IN_DAT),.mhout(SD_MHBITS_SRL),.dout(SD_MAC_HDR_SRL));


/////////////////////////////////////////
// Transmit Processor State Machine    //
/////////////////////////////////////////

trans_proc FL_Txp_FSM(.clk(CLK), .rst(RST), .start(START_TXP), .bg(BG), .mac_done(MAC_DONE),
           .intr_err(INTR_ERR), .fatal_err(FATAL_ERR), .s_err(S_ERR), .data_done(DATA_DONE),
           .bus_clr(BUS_CLR), .hndshk(HND_SHK), .txp_st(FL_TXP_ST), .br(BR));


always @(FL_TXP_ST or S_ERR or S_ACK or S_DATA or INTR_ERR or RCV_ERR or SE0 or SE2 or SEL_PAGE or VLD1 or FL_SD_DATA_DONE)
begin
   case(FL_TXP_ST)
      `TxP_Data:
         begin
            if(S_DATA)
               begin
                  DATA_DONE <= FL_SD_DATA_DONE;
                  DATA_FLAG <= SEL_PAGE || VLD1;
               end
            else if(S_ACK)
               begin
                  DATA_DONE <= 1;
                  DATA_FLAG <= 0;
               end
            else if(S_ERR)
               begin
                  DATA_DONE <= RCV_ERR ? SE2 : SE0;
                  DATA_FLAG <= 1;
               end
            else
               begin
                  DATA_DONE <= 0;
                  DATA_FLAG <= 0;
               end
         end
      default:
         begin
            DATA_DONE <= 0;
            DATA_FLAG <= 0;
         end
   endcase
end
///////////////////////////////////////////////////////
// Prioritize response for packet sending requests   //
///////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         RSPNS <= `FL_No_Req;
         TXDN_MSK <= 6'b000000;
         TYPE <= `Rtn_NoDat_Pkt;
      end
   else
      if(CAP_RSPNS)
         casex ({CP_SND_ERR, CP_SND_WRN, CI_SND_ERR, CI_SND_ACK, SD_SND_ERR, SD_SND_DATA})
            6'b1xxxxx:
               begin
                  RSPNS <= `FL_CP_Err;
                  TXDN_MSK <= 6'b100000;
                  TYPE <= `Rtn_Err_Pkt;
               end
            6'b01xxxx:
               begin
                  RSPNS <= `FL_CP_Warn;
                  TXDN_MSK <= 6'b010000;
                  TYPE <= `Rtn_Warn_Pkt;
               end
            6'b001xxx:
               begin
                  RSPNS <= `FL_CI_Err;
                  TXDN_MSK <= 6'b001000;
                  TYPE <= `Rtn_Err_Pkt;
               end
            6'b0001xx:
               begin
                  RSPNS <= `FL_CI_Ack;
                  TXDN_MSK <= 6'b000100;
                  TYPE <= `Rtn_NoDat_Pkt;
               end
            6'b00001x:
               begin
                  RSPNS <= `FL_SD_Err;
                  TXDN_MSK <= 6'b000010;
                  TYPE <= `Rtn_Err_Pkt;
               end
            6'b000001:
               begin
                  RSPNS <= `FL_SD_Data;
                  TXDN_MSK <= 6'b000001;
                  TYPE <= `Rtn_Flash_Pkt;
               end
            default:
               begin
                  RSPNS <= `FL_No_Req;
                  TXDN_MSK <= 6'b000000;
                  TYPE <= `Rtn_NoDat_Pkt;
               end
         endcase
      else if(RST_TXDN)
         begin
            RSPNS <= `FL_No_Req;
            TXDN_MSK <= 6'b000000;
            TYPE <= `Rtn_NoDat_Pkt;
         end
      else
         begin
            RSPNS <= RSPNS;
            TXDN_MSK <= TXDN_MSK;
            TYPE <= TYPE;
         end
end


always @(posedge CLK or posedge RST)
begin
   if(RST)
      TXDN <= `FL_No_Req;
   else
      if(LD_TXDN)
         TXDN <= RSPNS;
      else if(RST_TXDN)
         TXDN <= `FL_No_Req;
      else
         TXDN <= TXDN;
end




always @(TXP_INI_STAT or TXP_MID_STAT or TXP_INC_STAT or TXP_FIN_STAT or SD_ERR or SD_WARN or
         S_ACK or S_DATA or PKT_WARN or PKT_WARN2 or PKT_ERR2 or CP_ERR or CP_INP or CI_INP or READS)
begin
   if(TXP_INI_STAT)
      STATUS <= `CiP;
   else if (TXP_MID_STAT)
      if(SD_ERR)
         STATUS <= `CiP_E;
      else if(SD_WARN)
         STATUS <= `CiP_W;
      else
         STATUS <= `CiP;
   else if (TXP_INC_STAT)
      STATUS <= `CE_I;
   else if (TXP_FIN_STAT)
      if(PKT_ERR2 && (S_ACK || S_DATA))
         STATUS <= `CC_E;
      else if(PKT_WARN2 && (S_ACK || S_DATA))
         STATUS <= `CC_W;
      else if(S_ACK || S_DATA)
         STATUS <= `CC_S;
      else if((CP_INP && CP_ERR) || (CI_INP && READS))
         STATUS <= `CiP_E;
      else if(CP_INP && PKT_WARN)
         STATUS <= `CiP_W;
      else
         STATUS <= `CC_E;
   else
      STATUS <= `No_Ack;
end


always @(STAT_R or MSRL2 or TXP_DATA_R or CP_INP or CI_INP or SD_INP or 
         ST_TY or CP_MAC_HDR_SRL_R or CI_MAC_HDR_SRL_R or SD_MAC_HDR_SRL_R or
         SE1 or SE2 or SE3 or CP_ERR_HDR or CI_ERR_HDR or SD_ERR_HDR or
         RCV_ERR or RCV_ERR_WRD1 or RCV_ERR_WRD2 or OUTDATA)
begin
   if(STAT_R)
      DATA_MUX <= {4'h0,ST_TY};
   else if (MSRL2 && CP_INP)
      DATA_MUX <= CP_MAC_HDR_SRL_R;
   else if (MSRL2 && CI_INP)
      DATA_MUX <= CI_MAC_HDR_SRL_R;
   else if (MSRL2 && SD_INP)
      DATA_MUX <= SD_MAC_HDR_SRL_R;
   else if (TXP_DATA_R && CP_INP && SE1)
      DATA_MUX <= CP_ERR_HDR;
   else if (TXP_DATA_R && CP_INP && SE2)
      DATA_MUX <= RCV_ERR ? RCV_ERR_WRD1 : 16'h0000;
   else if (TXP_DATA_R && CP_INP && SE3)
      DATA_MUX <= RCV_ERR ? RCV_ERR_WRD2 : 16'h0000;
   else if (TXP_DATA_R && CI_INP && SE1)
      DATA_MUX <= CI_ERR_HDR;
   else if (TXP_DATA_R && SD_INP && SE1)
      DATA_MUX <= SD_ERR_HDR;
   else
      DATA_MUX <= OUTDATA;
end


always @(STAT_R or MSRL2 or CP_INP or CI_INP or SD_INP or
         CP_H_BIT or CI_H_BIT or SD_H_BIT or TXP_DATA_R or SND_PKT_R)
begin
   if(STAT_R)
      INSTR_MUX <= `Tx_AST;
   else if (MSRL2)
      if((CP_INP && CP_H_BIT) || (CI_INP && CI_H_BIT) || (SD_INP && SD_H_BIT))
         INSTR_MUX <= `Tx_Head;
      else
         INSTR_MUX <= `Tx_MAC;
   else if (TXP_DATA_R)
      INSTR_MUX <= `Tx_Data;
   else if (SND_PKT_R)
      INSTR_MUX <= `Tx_Send;
   else
      INSTR_MUX <= `Tx_NoData;
end

always @(S_ERR or CP_INP or CI_INP or SD_INP or PRIO or PRIO1 or PRIO2)
begin
   if(S_ERR)
      CAT_MUX <= `Tx_Spont_Cat;
   else if ((CP_INP && PRIO) || (CI_INP && PRIO1) || (SD_INP && PRIO2))
      CAT_MUX <= `Tx_Prio_Cat;
   else
      CAT_MUX <= `Tx_Norm_Cat;
end

/////////////////////////
// Output Registers    //
/////////////////////////

always @(posedge CLK)
begin
   if(SEL)
      begin
         MAC_REQ   <= GET_MAC;
         FRAME_REQ <= GET_FRAME || DMY_GET;
      end
   else
      begin
         MAC_REQ   <= 1'bZ;
         FRAME_REQ <= 1'bZ;
      end
end

always @ (posedge CLK)
begin
   if (SEL_PAGE)
      OUTDATA <= {DCODE,PAGE_REG,1'b0,RD_CNT};
   else 
      OUTDATA <= {DCODE,1'b0,ADFF_BUSS};
end

always @(posedge CLK)
begin
   if(RCV2)
      TO_CNFG <= 16'h0000;
   else
      TO_CNFG <= OUTDATA;
end
always @(posedge CLK)
begin
   if(BG)
      begin
         TXDATA  <= DATA_MUX;
         TXCTRL  <= {CAT_MUX,INSTR_MUX};
      end
   else
      begin
         TXDATA  <= 16'hZZZZ;
         TXCTRL  <= 5'hZZ;
      end
end
endmodule
