
`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"
`endif

                                        
module flash_intf(CLK,RST,PAGE,TO_DATA,ADDR,WR_RDB,NEW_PAGE,PUSH,FL_DATA,RDY4INP,
                     FROM_DATA,FROM_ADDR,FROM_PAGE,VAL_DAT,FL_ADDR,FL_CTRL);
    input CLK;
    input RST;
    input [6:0] PAGE;
    input [7:0] TO_DATA;
    input [5:0] ADDR;
    input WR_RDB;
    input NEW_PAGE;
    input PUSH;
    inout [7:0] FL_DATA;
    output RDY4INP;
    output [7:0] FROM_DATA;
    output [5:0] FROM_ADDR;
    output [6:0] FROM_PAGE;
    output VAL_DAT;
    output [12:0] FL_ADDR;
    output [2:0] FL_CTRL;

reg  [7:0] FL_DATA_R;
wire [7:0] FL_DATA;
reg  RDY4INP;
reg  [7:0] FROM_DATA;
reg  [5:0] FROM_ADDR;
reg  [6:0] FROM_PAGE;
reg  VAL_DAT;
reg  [12:0] FL_ADDR;
wire [2:0] FL_CTRL;

reg  [11:0] ADDATA1;
wire [11:0] ECC_DATA;
wire [11:0] ECC_DATA_OUT;
wire [11:0] ADDATA_OUT;
reg  [6:0]  PAGE1;
wire [11:0] ECC_PAGE;
wire [11:0] ECC_PAGE_OUT;
wire [6:0] PAGE_OUT;

reg  [7:0]  DPW_DATA1,DPW_DATA2,DPW_DATA3;
reg  [12:0] DPW_ADDR1,DPW_ADDR2,DPW_ADDR3;
reg  [12:0] ADDR_BUS;
reg  [7:0]  DATA_BUS;

reg  PUSH_DA;
reg  PUSH_PG;

reg  POP_PG;
wire PGMT;
wire PGFULL;
wire PGAMT;
wire PGAF;
wire PGWTERR;
wire PGRDERR;
wire [5:0] PG_CNT;
wire [6:0] DCD_PAGE;
reg  [6:0] CUR_PAGE;
wire [4:0] DMY;
wire [11:0] DCD_PG_PARITY;
wire PG_GOOD_WORD;
wire PG_BAD_TX;

reg  POP_DA;
wire DAMT;
wire DAFULL;
wire DAAMT;
wire DAAF;
wire DAWTERR;
wire DARDERR;
wire [8:0] DA_CNT;
wire [7:0] DCD_DATA;
wire [3:0] DCD_ADDR_L;
reg  [1:0] DCD_ADDR_H;
reg  [5:0] CUR_ADDR;
wire [11:0] DCD_DA_PARITY;
wire DA_GOOD_WORD;
wire DA_BAD_TX;
reg  [7:0] CUR_DATA;

reg  [3:0] CTAD1;
wire [3:0] CTAD_A,CTAD_B,CTAD_C;
reg  [3:0] CTAD_DCD;
reg  MT1,MT2,MT3,MT4,MT5,MT6,MT7,MT8;
reg  POP1,POP2,POP3,POP4,POP5,POP6,POP7;
reg  SET_FF_VALID;
reg  FF_VALID;
reg  NW_PG;
reg  WRT;
reg  CUR_WRT;
reg  LD_CUR_DAT;
reg  LD_CUR_PAGE;
reg  LD_FL_OUT;
reg  FL_OE,FL_OE1,FL_OE2,FL_OE3,FL_OE4;
reg  FL_WE,FL_WE1,FL_WE2,FL_WE3,FL_WE4,FL_WE5,FL_WE6,FL_WE7;
reg  FL_CE;
reg  INPENA;

reg [7:0] DATA_BACK;
wire TMR_RST;
reg  RST_TMR;
reg  TMR_ENA;
reg  [12:0] TMR;

reg  [4:0] FLC_ST;
reg  FIRST_WRT;
reg  SET_FIRST_WRT;
reg  CLR_FIRST_WRT;
reg  CMP_D6;
reg  SET_RD_INPRGS;
reg  RD_INPRGS;
reg  SET_OE;
reg  CLR_OE;
reg  SET_WE;
reg  CLR_WE;
reg  SEL_ROM;
reg  SOE1,SOE2,SOE3,SOE4,SOE5,SOE6,SOE7,SOE8,SOE9,SOE10,SOE11,SOE12;
reg  SWE1,SWE2,SWE3,SWE4,SWE5,SWE6,SWE7,SWE8,SWE9,SWE10,SWE11,SWE12;
wire RELTM;
wire CAPTURE;
wire WE_HOLD_ENA;
wire WRT_ACC_ENA;
wire RD_ACC_ENA;
reg  DPW_PHASE1,DPW_PHASE2,DPW_PHASE3;
wire DPW_DONE;
wire TOG;
wire INV;

initial
begin
   FROM_DATA = 8'h00;
   DATA_BACK = 8'h00;
end 


assign FL_CTRL = ~{FL_CE,FL_OE,FL_WE};
assign CAPTURE = CLR_OE;
assign RELTM = !(FL_OE  || FL_OE4);
assign WE_HOLD_ENA = !(FL_WE  || FL_WE7);
assign WRT_ACC_ENA = RELTM && WE_HOLD_ENA;
assign RD_ACC_ENA = !FL_OE && !FL_WE;
assign FL_DATA = FL_WE ? FL_DATA_R : 8'hZZ;

assign INV = (FROM_DATA[7] ^ FL_DATA_R[7]);
assign TOG = (FROM_DATA[6] ^ CMP_D6);
assign TMR_RST = RST_TMR || RST;
assign TM100 = (TMR == 13'h0000); 
assign DPW_DONE = DPW_PHASE1; 



always @(posedge CLK)
begin
   PUSH_DA <= PUSH;
   PUSH_PG <= NEW_PAGE;
   CTAD1 <= {NEW_PAGE, WR_RDB, ADDR[5:4]};
   ADDATA1 <= {ADDR[3:0], TO_DATA};
   PAGE1 <= PAGE;
end

///////////////////////////////////////////////////////////////
//                                                           //
// ENCODERs for Golay(24,12) ECC code                        //
//                                                           //
///////////////////////////////////////////////////////////////

ecc_encode ecc_encode_2(.CLK(CLK),.DATA({ADDR[3:0],TO_DATA}),.PARITY(ECC_DATA));
ecc_encode ecc_encode_3(.CLK(CLK),.DATA({5'b00000,PAGE}),.PARITY(ECC_PAGE));

///////////////////////////////////////////////////////////////
//                                                           //
// FIFO's for Encoded data, address, and page                //
//                                                           //
///////////////////////////////////////////////////////////////
parameter Ad_Data_FIFO_p2depth = 9;
defparam Ad_Data_FIFO.p2depth = Ad_Data_FIFO_p2depth;
defparam Ad_Data_FIFO.width = 36;
defparam Ad_Data_FIFO.almostmt = 32; // 
defparam Ad_Data_FIFO.almostfull = (1<<Ad_Data_FIFO_p2depth) - 64; // 
fifo_dpXn_blk   Ad_Data_FIFO(.clk(CLK),.rst(RST),.push(PUSH_DA),.pop(POP_DA),
                          .mt(DAMT),.full(DAFULL),.amt(DAAMT),.af(DAAF),.wterr(DAWTERR),.rderr(DARDERR),
                          .din({CTAD1,CTAD1,CTAD1,ECC_DATA,ADDATA1}),.dout({CTAD_A,CTAD_B,CTAD_C,ECC_DATA_OUT,ADDATA_OUT}),.cnt(DA_CNT));

parameter Page_FIFO_p2depth = 6;
defparam Page_FIFO.p2depth = Page_FIFO_p2depth;
defparam Page_FIFO.width = 19;
defparam Page_FIFO.almostmt = 4; // 
defparam Page_FIFO.almostfull = (1<<Page_FIFO_p2depth) - 4; // 
fifo_dpXn_dst  Page_FIFO(.clk(CLK),.rst(RST),.push(PUSH_PG),.pop(POP_PG),
                       .mt(PGMT),.full(PGFULL),.amt(PGAMT),.af(PGAF),.wterr(PGWTERR),.rderr(PGRDERR),
                       .din({ECC_PAGE,PAGE1}),.dout({ECC_PAGE_OUT,PAGE_OUT}),.cnt(PG_CNT));

///////////////////////////////////////////////////////////////
//                                                           //
// DECODER for Golay(24,12) ECC code                         //
//                                                           //
///////////////////////////////////////////////////////////////

ecc_decode ecc_decode_FL1(.CLK(CLK),.RCV_DATA(ADDATA_OUT),.RCV_PARITY(ECC_DATA_OUT),.GOOD_WORD(DA_GOOD_WORD),
                        .DCD_DATA({DCD_ADDR_L,DCD_DATA}),.DCD_PARITY(DCD_DA_PARITY),.BAD_TX(DA_BAD_TX));
ecc_decode ecc_decode_FL2(.CLK(CLK),.RCV_DATA({5'b00000,PAGE_OUT}),.RCV_PARITY(ECC_PAGE_OUT),.GOOD_WORD(PG_GOOD_WORD),
                        .DCD_DATA({DMY,DCD_PAGE}),.DCD_PARITY(DCD_PG_PARITY),.BAD_TX(PG_BAD_TX));


///////////////////////////////////////////////////////////////
//                                                           //
// Majority logic for controls and address                   //
//                                                           //
///////////////////////////////////////////////////////////////
always @(CTAD_A or CTAD_B or CTAD_C)
begin
   CTAD_DCD <= (CTAD_A & CTAD_B) | (CTAD_A & CTAD_C) | (CTAD_B & CTAD_C);
end

always @(posedge CLK)
begin
   MT1 <= DAMT;
   MT2 <= MT1;
   MT3 <= MT2;
   MT4 <= MT3;
   MT5 <= MT4;
   MT6 <= MT5;
   MT7 <= MT6;
   MT8 <= MT7;
   NW_PG <= CTAD_DCD[3]; 
   WRT   <= CTAD_DCD[2];
   DCD_ADDR_H <= CTAD_DCD[1:0];
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         CUR_ADDR <= 6'h00;
         CUR_DATA <= 6'h00;
         CUR_WRT <= 0;
      end
   else
      if(LD_CUR_DAT)
         begin
            CUR_ADDR <= {DCD_ADDR_H,DCD_ADDR_L};
            CUR_DATA <= DCD_DATA;
            CUR_WRT <= WRT;
         end
      else
         begin
            CUR_ADDR <= CUR_ADDR;
            CUR_DATA <= CUR_DATA;
            CUR_WRT <= CUR_WRT;
         end
end
always @(posedge CLK or posedge RST)
begin
   if(RST)
      CUR_PAGE <= 7'h00;
   else
      if(LD_CUR_PAGE)
         CUR_PAGE <= DCD_PAGE;
      else
         CUR_PAGE <= CUR_PAGE;
end
always @(posedge CLK or posedge RST)
begin (* IOB = "TRUE" *)
   if(RST)
      begin
         FL_ADDR <= 13'h000;
         FL_DATA_R <= 13'h000;
      end
   else
      if(LD_FL_OUT)
         begin
            FL_ADDR <= ADDR_BUS;
            FL_DATA_R <= DATA_BUS;
         end
      else
         begin
            FL_ADDR <= FL_ADDR;
            FL_DATA_R <= FL_DATA_R;
         end
end

always @(posedge CLK)
begin
   DATA_BACK <= FL_DATA;
   VAL_DAT <= CAPTURE && RD_INPRGS;
end
always @(posedge CLK)
begin
   if(CAPTURE)
      begin
         FROM_DATA <= DATA_BACK;
         CMP_D6    <= FROM_DATA[6];
         FROM_ADDR <= FL_ADDR[5:0];
         FROM_PAGE <= FL_ADDR[12:6];
      end
   else
      begin
         FROM_DATA <= FROM_DATA;
         FROM_ADDR <= FROM_ADDR;
         FROM_PAGE <= FROM_PAGE;
      end
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      RDY4INP <= 0;
   else
      if(INPENA && DAAMT && PGAMT)
         RDY4INP <= 1;
      else if(!INPENA || DAAF || PGAF)
         RDY4INP <= 0;
      else
         RDY4INP <= RDY4INP;
end


///////////////////////////////////////////////////////////////
//                                                           //
// 100 uS timer                                              //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or posedge TMR_RST)
begin
   if (TMR_RST)
`ifdef Simulation
//      TMR <= 13'h003C;          //960 nS for simulation
      TMR <= 13'h0010;        //256 nS for simulation
`else
      TMR <= 13'h186A;          //100 uS for real hardware
`endif
   else
      if(TMR_ENA && !TM100)
         TMR <= TMR - 1;
      else
         TMR <= TMR;
end

always @(posedge CLK or posedge RST)
begin
   if (RST)
      FIRST_WRT <= 1;
   else
      if(SET_FIRST_WRT)
         FIRST_WRT <= 1;
      else if(CLR_FIRST_WRT)
         FIRST_WRT <= 0;
      else
         FIRST_WRT <= FIRST_WRT;
end

always @(posedge CLK)
begin
   POP1 <= POP_DA;
   POP2 <= POP1;
   POP3 <= POP2;
   POP4 <= POP3;
   POP5 <= POP4;
   POP6 <= POP5;
   POP7 <= POP6;
   SET_FF_VALID <= POP7;
   SOE1 <= SET_OE;
   SOE2 <= SOE1;
   SOE3 <= SOE2;
   SOE4 <= SOE3;
   SOE5 <= SOE4;
   SOE6 <= SOE5;
   SOE7 <= SOE6;
   SOE8 <= SOE7;
   SOE9 <= SOE8;
   SOE10 <= SOE9;
   SOE11 <= SOE10;
   SOE12 <= SOE11;
   CLR_OE <= SOE12;
   SWE1 <= SET_WE;
   SWE2 <= SWE1;
   SWE3 <= SWE2;
   SWE4 <= SWE3;
   SWE5 <= SWE4;
   SWE6 <= SWE5;
   SWE7 <= SWE6;
   SWE8 <= SWE7;
   SWE9 <= SWE8;
   SWE10 <= SWE9;
   SWE11 <= SWE10;
   SWE12 <= SWE11;
   CLR_WE <= SWE12;
   FL_OE1 <= FL_OE;
   FL_OE2 <= FL_OE1;
   FL_OE3 <= FL_OE2;
   FL_OE4 <= FL_OE3;
   FL_WE1 <= FL_WE;
   FL_WE2 <= FL_WE1;
   FL_WE3 <= FL_WE2;
   FL_WE4 <= FL_WE3;
   FL_WE5 <= FL_WE4;
   FL_WE6 <= FL_WE5;
   FL_WE7 <= FL_WE6;
end
always @(posedge CLK or posedge RST)
begin
   if (RST)
      FF_VALID <= 1;
   else
      if(SET_FF_VALID)
         FF_VALID <= 1;
      else if(POP_DA)
         FF_VALID <= 0;
      else
         FF_VALID <= FF_VALID;
end

always @(posedge CLK or posedge RST)
begin
   if (RST)
      FL_OE <= 0;
   else
      if(SET_OE)
         FL_OE <= 1;
      else if(CLR_OE)
         FL_OE <= 0;
      else
         FL_OE <= FL_OE;
end

always @(posedge CLK or posedge RST)
begin
   if (RST)
      FL_WE <= 0;
   else
      if(SET_WE)
         FL_WE <= 1;
      else if(CLR_WE)
         FL_WE <= 0;
      else
         FL_WE <= FL_WE;
end

always @(posedge CLK or posedge RST)
begin
   if (RST)
      RD_INPRGS <= 0;
   else
      if(SET_RD_INPRGS)
         RD_INPRGS <= 1;
      else if(VAL_DAT)
         RD_INPRGS <= 0;
      else
         RD_INPRGS <= RD_INPRGS;
end

///////////////////////////////////////////////////////////////
//                                                           //
// Data Write Protection Registers                           //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin: DPW_SHIFT_REG
   if(RST)
      begin
         DPW_ADDR1 <=  13'h1555;   
         DPW_ADDR2 <=  13'h0AAA;
         DPW_ADDR3 <=  13'h1555;
         DPW_DATA1 <=  8'hAA;
         DPW_DATA2 <=  8'h55;
         DPW_DATA3 <=  8'hA0;
         DPW_PHASE1 <=  1;
         DPW_PHASE2 <=  0;
         DPW_PHASE3 <=  0;
      end
   else
      if(SEL_ROM && LD_FL_OUT)
         begin
            DPW_ADDR1 <=  DPW_ADDR2;   
            DPW_ADDR2 <=  DPW_ADDR3;
            DPW_ADDR3 <=  DPW_ADDR1;
            DPW_DATA1 <=  DPW_DATA2;
            DPW_DATA2 <=  DPW_DATA3;
            DPW_DATA3 <=  DPW_DATA1;
            DPW_PHASE1 <=  DPW_PHASE2;
            DPW_PHASE2 <=  DPW_PHASE3;
            DPW_PHASE3 <=  DPW_PHASE1;
         end
      else   
         begin
            DPW_ADDR1 <=  DPW_ADDR1;   
            DPW_ADDR2 <=  DPW_ADDR2;
            DPW_ADDR3 <=  DPW_ADDR3;
            DPW_DATA1 <=  DPW_DATA1;
            DPW_DATA2 <=  DPW_DATA2;
            DPW_DATA3 <=  DPW_DATA3;
            DPW_PHASE1 <=  DPW_PHASE1;
            DPW_PHASE2 <=  DPW_PHASE2;
            DPW_PHASE3 <=  DPW_PHASE3;
         end
end

///////////////////////////////////////////////////////////////
//                                                           //
// Multiplexer for switching to Data Protection Sequence ROM //
//                                                           //
///////////////////////////////////////////////////////////////

always @(SEL_ROM or DPW_ADDR1 or DPW_DATA1 or CUR_PAGE or CUR_ADDR or CUR_DATA)
begin: DA_MUX
   if (SEL_ROM)
      begin
         ADDR_BUS <= DPW_ADDR1; 
         DATA_BUS <= DPW_DATA1;
      end
   else 
      begin
         ADDR_BUS <= {CUR_PAGE,CUR_ADDR}; 
         DATA_BUS <= CUR_DATA;
      end
end

///////////////////////////////////////////////////////////////
//                                                           //
// Flash Memory Control State Machine                        //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin: FLASH_MEM_CTRL_FSM
   if(RST)
      FLC_ST <= `FL_Idle;
   else
      case(FLC_ST)
         `FL_Idle:
            begin
               if(!RST)
                  FLC_ST <= `W100;
               else 
                  FLC_ST <= `FL_Idle;
            end
         `W100:
            begin
               if(TM100)
                  FLC_ST <= `Read1;
               else 
                  FLC_ST <= `W100;
            end
         `Read1:
            FLC_ST <= `RelOE1;
         `RelOE1:
            begin
               if(RELTM)
                  FLC_ST <= `Read2;
               else 
                  FLC_ST <= `RelOE1;
            end
         `Read2:
            FLC_ST <= `Rel_Cmp_D6;
         `Rel_Cmp_D6:
            begin
               if(TOG && RELTM)
                  FLC_ST <= `Read2;
               else if(!TOG && RELTM)
                  FLC_ST <= `W4Data;
               else 
                  FLC_ST <= `Rel_Cmp_D6;
            end
         `W4Data:
            begin
               if(FF_VALID && !FIRST_WRT && CUR_WRT &&(MT8 || !MT8 && (NW_PG || !WRT)))
                  FLC_ST <= `W4WrtAcc3;
               else if(FF_VALID && !MT8)
                  FLC_ST <= `Have_Data;
               else 
                  FLC_ST <= `W4Data;
            end
         `Have_Data:
            begin
               if(FIRST_WRT && WRT)
                  FLC_ST <= `W4WrtAcc2;
               else if(NW_PG)
                  FLC_ST <= `PopPg_n_Ld;
               else 
                  FLC_ST <= `Pop_n_Load;
            end
         `Pop_n_Load:
            begin
               if(WRT)
                  FLC_ST <= `W4WrtAcc1;
               else 
                  FLC_ST <= `W4RdAcc;
            end
         `W4RdAcc:
            begin
               if(RD_ACC_ENA)
                  FLC_ST <= `Ld_FLout_Rd;
               else 
                  FLC_ST <= `W4RdAcc;
            end
         `Ld_FLout_Rd:
            FLC_ST <= `Start_Rd;
         `Start_Rd:
            FLC_ST <= `W4Data;
         `PopPg_n_Ld:
            begin
               if(WRT)
                  FLC_ST <= `W4WrtAcc1;
               else 
                  FLC_ST <= `W4RdAcc;
            end
         `W4WrtAcc1:
            begin
               if(WRT_ACC_ENA)
                  FLC_ST <= `Ld_FLout_Wrt;
               else 
                  FLC_ST <= `W4WrtAcc1;
            end
         `Ld_FLout_Wrt:
            FLC_ST <= `Start_Wrt;
         `Start_Wrt:
            FLC_ST <= `W4Data;
         `W4WrtAcc2:
            begin
               if(WRT_ACC_ENA)
                  FLC_ST <= `Ld_DPW_Seq;
               else 
                  FLC_ST <= `W4WrtAcc2;
            end
         `Ld_DPW_Seq:
            FLC_ST <= `Wrt_DPW_Seq;
         `Wrt_DPW_Seq:
            begin
               if(DPW_DONE)
                  FLC_ST <= `Have_Data;
               else 
                  FLC_ST <= `W4WrtAcc2;
            end
         `W4WrtAcc3:
            begin
               if(WRT_ACC_ENA)
                  FLC_ST <= `Write_Page;
               else 
                  FLC_ST <= `W4WrtAcc3;
            end
         `Write_Page:
            begin
               if(TM100)
                  FLC_ST <= `Poll_D7;
               else 
                  FLC_ST <= `Write_Page;
            end
         `Poll_D7:
            FLC_ST <= `Rel_Cmp_D7;
         `Rel_Cmp_D7:
            begin
               if(INV && RELTM)
                  FLC_ST <= `Poll_D7;
               else if(!INV && RELTM)
                  FLC_ST <= `FL_Ready;
               else 
                  FLC_ST <= `Rel_Cmp_D7;
            end
         `FL_Ready:
            FLC_ST <= `W4Data;
         default:
            FLC_ST <= `FL_Idle;
      endcase
end

always @(FLC_ST)
begin
   case (FLC_ST)
      `W100:
         begin
            RST_TMR <= 0;
            TMR_ENA <= 1;
         end
      `Write_Page:
         begin
            RST_TMR <= 0;
            TMR_ENA <= 1;
         end
      `W4Data:
         begin
            RST_TMR <= 1;
            TMR_ENA <= 0;
         end
      default:
         begin
            RST_TMR <= 0;
            TMR_ENA <= 0;
         end
   endcase
end
always @(FLC_ST)
begin
   case        (FLC_ST)
      `FL_Idle:
         begin
            SET_FIRST_WRT <= 1;
            CLR_FIRST_WRT <= 0;
         end
      `FL_Ready:
         begin
            SET_FIRST_WRT <= 1;
            CLR_FIRST_WRT <= 0;
         end
      `W4WrtAcc2:
         begin
            SET_FIRST_WRT <= 0;
            CLR_FIRST_WRT <= 1;
         end
      default:
         begin
            SET_FIRST_WRT <= 0;
            CLR_FIRST_WRT <= 0;
         end
   endcase
end

always @(FLC_ST)
begin
   case        (FLC_ST)
      `FL_Idle:
         FL_CE <= 0;
      default:
         FL_CE <= 1;
   endcase
end

always @(FLC_ST)
begin
   case        (FLC_ST)
      `Read1,`Read2,`Poll_D7,`Start_Rd:
         begin
            SET_OE <= 1;
            SET_WE <= 0;
         end
      `Start_Wrt,`Wrt_DPW_Seq:
         begin
            SET_OE <= 0;
            SET_WE <= 1;
         end
      default:
         begin
            SET_OE <= 0;
            SET_WE <= 0;
         end
   endcase
end

always @(FLC_ST)
begin
   case        (FLC_ST)
      `Ld_FLout_Rd,`Ld_FLout_Wrt,`Ld_DPW_Seq:
         begin
            LD_FL_OUT <= 1;
         end
      default:
         begin
            LD_FL_OUT <= 0;
         end
   endcase
end

always @(FLC_ST)
begin
   case        (FLC_ST)
      `W4WrtAcc2,`Ld_DPW_Seq,`Wrt_DPW_Seq:
         begin
            SEL_ROM <= 1;
         end
      default:
         begin
            SEL_ROM <= 0;
         end
   endcase
end

always @(FLC_ST)
begin
   case        (FLC_ST)
      `Ld_FLout_Rd:
         begin
            SET_RD_INPRGS <= 1;
         end
      default:
         begin
            SET_RD_INPRGS <= 0;
         end
   endcase
end

always @(FLC_ST)
begin
   case        (FLC_ST)
      `FL_Idle,`W100,`Read1,`Read2,`RelOE1,`Rel_Cmp_D6:
         begin
            INPENA <= 0;
         end
      default:
         begin
            INPENA <= 1;
         end
   endcase
end

always @(FLC_ST)
begin
   case        (FLC_ST)
      `Pop_n_Load:
         begin
            POP_DA <= 1;
            POP_PG <= 0;
            LD_CUR_DAT <= 1;
            LD_CUR_PAGE <= 0;
         end
      `PopPg_n_Ld:
         begin
            POP_DA <= 1;
            POP_PG <= 1;
            LD_CUR_DAT <= 1;
            LD_CUR_PAGE <= 1;
         end
      default:
         begin
            POP_DA <= 0;
            POP_PG <= 0;
            LD_CUR_DAT <= 0;
            LD_CUR_PAGE <= 0;
         end
   endcase
end

endmodule
