module led_drivers(CLK,DV1024CLK,RXSTATUS,ACTIVE,GOOD_FRAME,RX_ERR,
                   TXSTATUS,TX_UPDT,TX_ERR,FIBER_SIG_DET,
		   MON_AS,MON_DS,MON_WRITE,MON_IRQ,MON_BERR,MON_BBSY,MON_SYSRESET,MON_HARD_RESET_B,
                   FF_PAE_B,FF_PAF_B,FF_IN_RDY_B,FF_OUT_RDY_B,FF_TEST_MODE,FF_ECC_ENA,
                   SW1L_BIT,RCVD_CNT,DRPD_CNT, XERR_CNT,XMIT_CNT,USR_LED_REG,
                   SIG_DET_MON,ACTIVITY,RX_PKT,RX_ERR_LED,TX_PKT,TX_ERR_LED,FF_MT,FF_PAE,FF_PAF,FF_FULL,
                   AS_MON,DS_MON,WRITE_MON,IRQ_MON,BERR_MON,BBSY_MON,SYSRESET_MON,HARD_RESET_MON,
                   STATUS);
    input CLK;
    input DV1024CLK;
    input [15:0] RXSTATUS;
    input ACTIVE;
    input GOOD_FRAME;
    input RX_ERR;
    input [15:0] TXSTATUS;
    input TX_UPDT;
    input TX_ERR;
    input FIBER_SIG_DET;
    input MON_AS;
    input [1:0] MON_DS;
    input MON_WRITE;
    input [7:1] MON_IRQ;
    input MON_BERR;
    input MON_BBSY;
    input MON_SYSRESET;
    input MON_HARD_RESET_B;
    input FF_PAE_B;
    input FF_PAF_B;
    input FF_IN_RDY_B;
    input FF_OUT_RDY_B;
    input FF_TEST_MODE;
    input FF_ECC_ENA;
    input [3:0] SW1L_BIT;
    input [31:0] XERR_CNT;
    input [31:0] XMIT_CNT;
    input [31:0] RCVD_CNT;
    input [31:0] DRPD_CNT;
    input [31:0] USR_LED_REG;
//    input [35:0] OFFSET;
    output SIG_DET_MON;
    output ACTIVITY;
    output RX_PKT;
    output RX_ERR_LED;
    output TX_PKT;
    output TX_ERR_LED;
    output FF_MT;
    output FF_PAE;
    output FF_PAF;
    output FF_FULL;
    output AS_MON;
    output DS_MON;
    output WRITE_MON;
    output IRQ_MON;
    output BERR_MON;
    output BBSY_MON;
    output SYSRESET_MON;
    output HARD_RESET_MON;
    output [31:0] STATUS;

reg [31:0] STATUS;
reg [7:0] TIMER_1,TIMER_2,TIMER_3,TIMER_4,TIMER_5,TIMER_6;
reg [7:0] TIMER_7,TIMER_8,TIMER_9,TIMER_10,TIMER_11,TIMER_12;
reg [7:0] TIMER_13,TIMER_14,TIMER_15,TIMER_16;
reg ACTIVITY;
reg RX_PKT;
reg RX_ERR_LED;
reg TX_PKT;
reg TX_ERR_LED;
reg TX_PROC_N;
reg TX_PROC_P;
reg TX_PROC_S;
reg AS_MON;
reg DS_MON;
reg WRITE_MON;
reg IRQ_MON;
reg BERR_MON;
reg BBSY_MON;
reg SYSRESET_MON;
reg HARD_RESET_MON;
wire [3:0] SW1;
wire SIG_DET_MON;
wire FF_MT;
wire FF_PAE;
wire FF_PAF;
wire FF_FULL;
wire DS_SUM;
wire IRQ_SUM;
wire MON_HARD_RESET;

`ifdef HEADER
`else
`include "header.v"
`endif

assign SW1 = ~SW1L_BIT;
assign SIG_DET_MON = FIBER_SIG_DET;
//fix for LED's on Pre-Production boards.
`ifdef PreProduction_Version
   assign FF_MT = FF_IN_RDY_B;
   assign FF_PAE = FF_OUT_RDY_B;
   assign FF_PAF = ~FF_PAE_B;
   assign FF_FULL = ~FF_PAF_B;
`else
   assign FF_MT = FF_OUT_RDY_B;
   assign FF_PAE = ~FF_PAE_B;
   assign FF_PAF = ~FF_PAF_B;
   assign FF_FULL = FF_IN_RDY_B;
`endif
assign DS_SUM = |MON_DS;
assign IRQ_SUM = |MON_IRQ;
assign MON_HARD_RESET = !MON_HARD_RESET_B;

//////////////////////////////////////////////////
// ACTIVITY LED hold timer and register         //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge ACTIVE)
begin
   if(ACTIVE) 
     TIMER_1 <= 8'hFF;
   else
     TIMER_1 <= TIMER_1-1;
end

always @ (posedge CLK)
begin
   if(ACTIVE)
      ACTIVITY <= 1;
   else if (TIMER_1 == 8'h00)
      ACTIVITY <= 0;
   else
      ACTIVITY <= ACTIVITY;
end

//////////////////////////////////////////////////
// RX_PKT LED hold timer and register           //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge GOOD_FRAME)
begin
   if(GOOD_FRAME) 
     TIMER_2 <= 8'hFF;
   else
     TIMER_2 <= TIMER_2-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(GOOD_FRAME)
         TX_PKT <= 1;
      else if (TIMER_2 == 8'h00)
         TX_PKT <= 0;
      else
         TX_PKT <= TX_PKT;
   end
`else
   always @ (posedge CLK)
   begin
      if(GOOD_FRAME)
         RX_PKT <= 1;
      else if (TIMER_2 == 8'h00)
         RX_PKT <= 0;
      else
         RX_PKT <= RX_PKT;
   end
`endif


//////////////////////////////////////////////////
// RX_ERR_LED LED hold timer and register       //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge RX_ERR)
begin
   if(RX_ERR) 
     TIMER_3 <= 8'hFF;
   else
     TIMER_3 <= TIMER_3-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(RX_ERR)
         RX_PKT <= 1;
      else if (TIMER_3 == 8'h00)
         RX_PKT <= 0;
      else
         RX_PKT <= RX_PKT;
   end
`else
   always @ (posedge CLK)
   begin
      if(RX_ERR)
         RX_ERR_LED <= 1;
      else if (TIMER_3 == 8'h00)
         RX_ERR_LED <= 0;
      else
         RX_ERR_LED <= RX_ERR_LED;
   end
`endif

//////////////////////////////////////////////////
// TX_PKT LED hold timer and register           //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge TX_UPDT)
begin
   if(TX_UPDT) 
     TIMER_4 <= 8'hFF;
   else
     TIMER_4 <= TIMER_4-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(TX_UPDT)
         TX_ERR_LED <= 1;
      else if (TIMER_4 == 8'h00)
         TX_ERR_LED <= 0;
      else
         TX_ERR_LED <= TX_ERR_LED;
   end
`else
   always @ (posedge CLK)
   begin
      if(TX_UPDT)
         TX_PKT <= 1;
      else if (TIMER_4 == 8'h00)
         TX_PKT <= 0;
      else
         TX_PKT <= TX_PKT;
   end
`endif


//////////////////////////////////////////////////
// TX_ERR_LED LED hold timer and register       //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge TX_ERR)
begin
   if(TX_ERR) 
     TIMER_5 <= 8'hFF;
   else
     TIMER_5 <= TIMER_5-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(TX_ERR)
         RX_ERR_LED <= 1;
      else if (TIMER_5 == 8'h00)
         RX_ERR_LED <= 0;
      else
         RX_ERR_LED <= RX_ERR_LED;
   end
`else
   always @ (posedge CLK)
   begin
      if(TX_ERR)
         TX_ERR_LED <= 1;
      else if (TIMER_5 == 8'h00)
         TX_ERR_LED <= 0;
      else
         TX_ERR_LED <= TX_ERR_LED;
   end
`endif


//////////////////////////////////////////////////
// AS_MON LED hold timer and register           //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge MON_AS)
begin
   if(MON_AS) 
     TIMER_6 <= 8'hFF;
   else
     TIMER_6 <= TIMER_6-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(MON_AS)
         DS_MON <= 1;
      else if (TIMER_6 == 8'h00)
         DS_MON <= 0;
      else
         DS_MON <= DS_MON;
   end
`else
   always @ (posedge CLK)
   begin
      if(MON_AS)
         AS_MON <= 1;
      else if (TIMER_6 == 8'h00)
         AS_MON <= 0;
      else
         AS_MON <= AS_MON;
   end
`endif


//////////////////////////////////////////////////
// DS_MON LED hold timer and register           //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge DS_SUM)
begin
   if(DS_SUM) 
     TIMER_7 <= 8'hFF;
   else
     TIMER_7 <= TIMER_7-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(DS_SUM)
         IRQ_MON <= 1;
      else if (TIMER_7 == 8'h00)
         IRQ_MON <= 0;
      else
         IRQ_MON <= IRQ_MON;
   end
`else
   always @ (posedge CLK)
   begin
      if(DS_SUM)
         DS_MON <= 1;
      else if (TIMER_7 == 8'h00)
         DS_MON <= 0;
      else
         DS_MON <= DS_MON;
   end
`endif


//////////////////////////////////////////////////
// WRITE_MON LED hold timer and register        //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge MON_WRITE)
begin
   if(MON_WRITE) 
     TIMER_8 <= 8'hFF;
   else
     TIMER_8 <= TIMER_8-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(MON_WRITE)
         AS_MON <= 1;
      else if (TIMER_8 == 8'h00)
         AS_MON <= 0;
      else
         AS_MON <= AS_MON;
   end
`else
   always @ (posedge CLK)
   begin
      if(MON_WRITE)
         WRITE_MON <= 1;
      else if (TIMER_8 == 8'h00)
         WRITE_MON <= 0;
      else
         WRITE_MON <= WRITE_MON;
   end
`endif


//////////////////////////////////////////////////
// IRQ_MON LED hold timer and register          //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge IRQ_SUM)
begin
   if(IRQ_SUM) 
     TIMER_9 <= 8'hFF;
   else
     TIMER_9 <= TIMER_9-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(IRQ_SUM)
         WRITE_MON <= 1;
      else if (TIMER_9 == 8'h00)
         WRITE_MON <= 0;
      else
         WRITE_MON <= WRITE_MON;
   end
`else
   always @ (posedge CLK)
   begin
      if(IRQ_SUM)
         IRQ_MON <= 1;
      else if (TIMER_9 == 8'h00)
         IRQ_MON <= 0;
      else
         IRQ_MON <= IRQ_MON;
   end
`endif


//////////////////////////////////////////////////
// BERR_MON LED hold timer and register         //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge MON_BERR)
begin
   if(MON_BERR) 
     TIMER_10 <= 8'hFF;
   else
     TIMER_10 <= TIMER_10-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(MON_BERR)
         BBSY_MON <= 1;
      else if (TIMER_10 == 8'h00)
         BBSY_MON <= 0;
      else
         BBSY_MON <= BBSY_MON;
   end
`else
   always @ (posedge CLK)
   begin
      if(MON_BERR)
         BERR_MON <= 1;
      else if (TIMER_10 == 8'h00)
         BERR_MON <= 0;
      else
         BERR_MON <= BERR_MON;
   end
`endif


//////////////////////////////////////////////////
// BBSY_MON LED hold timer and register         //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge MON_BBSY)
begin
   if(MON_BBSY) 
     TIMER_11 <= 8'hFF;
   else
     TIMER_11 <= TIMER_11-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(MON_BBSY)
         HARD_RESET_MON <= 1;
      else if (TIMER_11 == 8'h00)
         HARD_RESET_MON <= 0;
      else
         HARD_RESET_MON <= HARD_RESET_MON;
   end
`else
   always @ (posedge CLK)
   begin
      if(MON_BBSY)
         BBSY_MON <= 1;
      else if (TIMER_11 == 8'h00)
         BBSY_MON <= 0;
      else
         BBSY_MON <= BBSY_MON;
   end
`endif


//////////////////////////////////////////////////
// SYSRESET_MON LED hold timer and register     //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge MON_SYSRESET)
begin
   if(MON_SYSRESET) 
     TIMER_12 <= 8'hFF;
   else
     TIMER_12 <= TIMER_12-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(MON_SYSRESET)
         BERR_MON <= 1;
      else if (TIMER_12 == 8'h00)
         BERR_MON <= 0;
      else
         BERR_MON <= BERR_MON;
   end
`else
   always @ (posedge CLK)
   begin
      if(MON_SYSRESET)
         SYSRESET_MON <= 1;
      else if (TIMER_12 == 8'h00)
         SYSRESET_MON <= 0;
      else
         SYSRESET_MON <= SYSRESET_MON;
   end
`endif


//////////////////////////////////////////////////
// HARD_RESET_MON LED hold timer and register   //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge MON_HARD_RESET)
begin
   if(MON_HARD_RESET) 
     TIMER_13 <= 8'hFF;
   else
     TIMER_13 <= TIMER_13-1;
end

`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      if(MON_HARD_RESET)
         SYSRESET_MON <= 1;
      else if (TIMER_13 == 8'h00)
         SYSRESET_MON <= 0;
      else
         SYSRESET_MON <= SYSRESET_MON;
   end
`else
   always @ (posedge CLK)
   begin
      if(MON_HARD_RESET)
         HARD_RESET_MON <= 1;
      else if (TIMER_13 == 8'h00)
         HARD_RESET_MON <= 0;
      else
         HARD_RESET_MON <= HARD_RESET_MON;
   end
`endif

//////////////////////////////////////////////////
// TX_PROC_N (NORM) LED hold timer and register //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge TXSTATUS[11])
begin
   if(TXSTATUS[11]) 
     TIMER_14 <= 8'hFF;
   else
     TIMER_14 <= TIMER_14-1;
end
always @ (posedge CLK)
begin
   if(TXSTATUS[11])
      TX_PROC_N <= 1;
   else if (TIMER_14 == 8'h00)
      TX_PROC_N <= 0;
   else
      TX_PROC_N <= TX_PROC_N;
end
//////////////////////////////////////////////////
// TX_PROC_P (PRIO) LED hold timer and register //
//////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge TXSTATUS[7])
begin
   if(TXSTATUS[7]) 
     TIMER_15 <= 8'hFF;
   else
     TIMER_15 <= TIMER_15-1;
end
always @ (posedge CLK)
begin
   if(TXSTATUS[7])
      TX_PROC_P <= 1;
   else if (TIMER_15 == 8'h00)
      TX_PROC_P <= 0;
   else
      TX_PROC_P <= TX_PROC_P;
end
///////////////////////////////////////////////////
// TX_PROC_S (SPONT) LED hold timer and register //
///////////////////////////////////////////////////
always @ (posedge DV1024CLK or posedge TXSTATUS[3])
begin
   if(TXSTATUS[3]) 
     TIMER_16 <= 8'hFF;
   else
     TIMER_16 <= TIMER_16-1;
end
always @ (posedge CLK)
begin
   if(TXSTATUS[3])
      TX_PROC_S <= 1;
   else if (TIMER_16 == 8'h00)
      TX_PROC_S <= 0;
   else
      TX_PROC_S <= TX_PROC_S;
end


`ifdef PreProduction_Version
   always @ (posedge CLK)
   begin
      case(SW1)
         4'h0:
            begin
               {STATUS[30],STATUS[14],STATUS[28],STATUS[12]} <= USR_LED_REG[31:28];
               {STATUS[26],STATUS[10],STATUS[24], STATUS[8]} <= USR_LED_REG[27:24];
               {STATUS[22], STATUS[6],STATUS[20], STATUS[4]} <= USR_LED_REG[23:20];
               {STATUS[18], STATUS[2],STATUS[16], STATUS[0]} <= USR_LED_REG[19:16];
               {STATUS[31],STATUS[15],STATUS[29],STATUS[13]} <= USR_LED_REG[15:12];
               {STATUS[27],STATUS[11],STATUS[25], STATUS[9]} <= USR_LED_REG[11:8];
               {STATUS[23], STATUS[7],STATUS[21], STATUS[5]} <= USR_LED_REG[7:4];
               {STATUS[19], STATUS[3],STATUS[17], STATUS[1]} <= USR_LED_REG[3:0];
            end
         4'h1:
            begin
               {STATUS[30],STATUS[14],STATUS[28],STATUS[12]} <= XMIT_CNT[15:12];
               {STATUS[26],STATUS[10],STATUS[24], STATUS[8]} <= XMIT_CNT[11:8];
               {STATUS[22], STATUS[6],STATUS[20], STATUS[4]} <= XMIT_CNT[7:4];
               {STATUS[18], STATUS[2],STATUS[16], STATUS[0]} <= XMIT_CNT[3:0];
               {STATUS[31],STATUS[15],STATUS[29],STATUS[13]} <= RCVD_CNT[15:12];
               {STATUS[27],STATUS[11],STATUS[25], STATUS[9]} <= RCVD_CNT[11:8];
               {STATUS[23], STATUS[7],STATUS[21], STATUS[5]} <= RCVD_CNT[7:4];
               {STATUS[19], STATUS[3],STATUS[17], STATUS[1]} <= RCVD_CNT[3:0];
            end
         4'h2:
            begin
               {STATUS[30],STATUS[14],STATUS[28],STATUS[12]} <= RCVD_CNT[31:28];
               {STATUS[26],STATUS[10],STATUS[24], STATUS[8]} <= RCVD_CNT[27:24];
               {STATUS[22], STATUS[6],STATUS[20], STATUS[4]} <= RCVD_CNT[23:20];
               {STATUS[18], STATUS[2],STATUS[16], STATUS[0]} <= RCVD_CNT[19:16];
               {STATUS[31],STATUS[15],STATUS[29],STATUS[13]} <= RCVD_CNT[15:12];
               {STATUS[27],STATUS[11],STATUS[25], STATUS[9]} <= RCVD_CNT[11:8];
               {STATUS[23], STATUS[7],STATUS[21], STATUS[5]} <= RCVD_CNT[7:4];
               {STATUS[19], STATUS[3],STATUS[17], STATUS[1]} <= RCVD_CNT[3:0];
            end
         4'h3:
            begin
               {STATUS[30],STATUS[14],STATUS[28],STATUS[12]} <= XMIT_CNT[31:28];
               {STATUS[26],STATUS[10],STATUS[24], STATUS[8]} <= XMIT_CNT[27:24];
               {STATUS[22], STATUS[6],STATUS[20], STATUS[4]} <= XMIT_CNT[23:20];
               {STATUS[18], STATUS[2],STATUS[16], STATUS[0]} <= XMIT_CNT[19:16];
               {STATUS[31],STATUS[15],STATUS[29],STATUS[13]} <= XMIT_CNT[15:12];
               {STATUS[27],STATUS[11],STATUS[25], STATUS[9]} <= XMIT_CNT[11:8];
               {STATUS[23], STATUS[7],STATUS[21], STATUS[5]} <= XMIT_CNT[7:4];
               {STATUS[19], STATUS[3],STATUS[17], STATUS[1]} <= XMIT_CNT[3:0];
            end
         4'h4:
            begin
               {STATUS[30],STATUS[14],STATUS[28],STATUS[12]} <= TXSTATUS[15:12];
               {STATUS[26],STATUS[10],STATUS[24], STATUS[8]} <= {TX_PROC_N,TXSTATUS[10:8]};
               {STATUS[22], STATUS[6],STATUS[20], STATUS[4]} <= {TX_PROC_P,TXSTATUS[6:4]};
               {STATUS[18], STATUS[2],STATUS[16], STATUS[0]} <= {TX_PROC_S,TXSTATUS[2:0]};
               {STATUS[31],STATUS[15],STATUS[29],STATUS[13]} <= RXSTATUS[15:12];
               {STATUS[27],STATUS[11],STATUS[25], STATUS[9]} <= RXSTATUS[11:8];
               {STATUS[23], STATUS[7],STATUS[21], STATUS[5]} <= RXSTATUS[7:4];
               {STATUS[19], STATUS[3],STATUS[17], STATUS[1]} <= RXSTATUS[3:0];
            end
         4'hE:
            begin
               {STATUS[30],STATUS[14],STATUS[28],STATUS[12]} <= XERR_CNT[31:28];
               {STATUS[26],STATUS[10],STATUS[24], STATUS[8]} <= XERR_CNT[27:24];
               {STATUS[22], STATUS[6],STATUS[20], STATUS[4]} <= XERR_CNT[23:20];
               {STATUS[18], STATUS[2],STATUS[16], STATUS[0]} <= XERR_CNT[19:16];
               {STATUS[31],STATUS[15],STATUS[29],STATUS[13]} <= XERR_CNT[15:12];
               {STATUS[27],STATUS[11],STATUS[25], STATUS[9]} <= XERR_CNT[11:8];
               {STATUS[23], STATUS[7],STATUS[21], STATUS[5]} <= XERR_CNT[7:4];
               {STATUS[19], STATUS[3],STATUS[17], STATUS[1]} <= XERR_CNT[3:0];
            end
         4'hF:
            begin
               {STATUS[30],STATUS[14],STATUS[28],STATUS[12]} <= DRPD_CNT[31:28];
               {STATUS[26],STATUS[10],STATUS[24], STATUS[8]} <= DRPD_CNT[27:24];
               {STATUS[22], STATUS[6],STATUS[20], STATUS[4]} <= DRPD_CNT[23:20];
               {STATUS[18], STATUS[2],STATUS[16], STATUS[0]} <= DRPD_CNT[19:16];
               {STATUS[31],STATUS[15],STATUS[29],STATUS[13]} <= DRPD_CNT[15:12];
               {STATUS[27],STATUS[11],STATUS[25], STATUS[9]} <= DRPD_CNT[11:8];
               {STATUS[23], STATUS[7],STATUS[21], STATUS[5]} <= DRPD_CNT[7:4];
               {STATUS[19], STATUS[3],STATUS[17], STATUS[1]} <= DRPD_CNT[3:0];
            end
         default:
            begin
               {STATUS[30],STATUS[14],STATUS[28],STATUS[12]} <= RCVD_CNT[31:28];
               {STATUS[26],STATUS[10],STATUS[24], STATUS[8]} <= RCVD_CNT[27:24];
               {STATUS[22], STATUS[6],STATUS[20], STATUS[4]} <= RCVD_CNT[23:20];
               {STATUS[18], STATUS[2],STATUS[16], STATUS[0]} <= RCVD_CNT[19:16];
               {STATUS[31],STATUS[15],STATUS[29],STATUS[13]} <= RCVD_CNT[15:12];
               {STATUS[27],STATUS[11],STATUS[25], STATUS[9]} <= RCVD_CNT[11:8];
               {STATUS[23], STATUS[7],STATUS[21], STATUS[5]} <= RCVD_CNT[7:4];
               {STATUS[19], STATUS[3],STATUS[17], STATUS[1]} <= RCVD_CNT[3:0];
            end
      endcase
   end
`else
   always @ (posedge CLK)
   begin
      case(SW1)
         4'h0:
            STATUS <= USR_LED_REG;
         4'h1:
            begin
               STATUS[31:16] <= XMIT_CNT[15:0];
               STATUS[15:0] <= RCVD_CNT[15:0];
            end
         4'h2:
            STATUS <= RCVD_CNT;
         4'h3:
            STATUS <= XMIT_CNT;
         4'h4:
            begin
               STATUS[31:16] <= {TXSTATUS[15:12],TX_PROC_N,TXSTATUS[10:8],TX_PROC_P,TXSTATUS[6:4],TX_PROC_S,TXSTATUS[2:0]};
               STATUS[15:0] <= RXSTATUS;
            end
         4'hE:
            STATUS <= XERR_CNT;
         4'hF:
            STATUS <= DRPD_CNT;
         default:
            STATUS <= RCVD_CNT;
      endcase
   end
`endif
endmodule
