`timescale 1ns / 1ps

// synthesis attribute ram_style of mac_mem is distributed

module mac_mem(CLK, MACBUS, WA_TP, MWE, RCV_ADDR, TX_ADDR, DFLT_ADDR, ALL_MACS, TX_MAC, DFLT_MAC);

    input CLK;
    inout [15:0] MACBUS;
    input [4:0] WA_TP;
    input MWE;
    input [1:0] RCV_ADDR;
    input [1:0] TX_ADDR;
    input [1:0] DFLT_ADDR;
   output [63:0] ALL_MACS;
   output [15:0] TX_MAC;
   output [15:0] DFLT_MAC;

wire [15:0] MACBUS;
reg [15:0] MACBUS_IN_REG;
reg [15:0] MACBUS_OUT_REG;
wire [63:0] ALL_MACS;
reg [15:0] RCV_MAC;   
reg [15:0] MCAST1;   
reg [15:0] MCAST2;   
reg [15:0] MCAST3;   
reg [15:0] TX_MAC;   
reg [15:0] DFLT_MAC;
   
reg [15:0] device_mac_ram [2:0];
reg [15:0] mcast1_mac_ram [2:0];
reg [15:0] mcast2_mac_ram [2:0];
reg [15:0] mcast3_mac_ram [2:0];
reg [15:0] dflt_srv_mac_ram [2:0];

reg MWE1;
reg [1:0] ADDR;
reg [2:0] MTYPE;

`ifdef HEADER
`else
`include "header.v"
`endif

assign MACBUS = MWE ? 16'hZZZZ : MACBUS_OUT_REG;
assign ALL_MACS = {MCAST3,MCAST2,MCAST1,RCV_MAC};

// Input registers //
always @(posedge CLK)
begin
   MACBUS_IN_REG <= MACBUS;
   MWE1 <= MWE;
   ADDR <= WA_TP[1:0];
   MTYPE <= WA_TP[4:2];
end

// Dual and Triple Port synchronous RAM inference with registered output for MAC addresses
always @(posedge CLK)
begin
   case(MTYPE)
      `Device_MAC:
         begin
            if (MWE1)
               device_mac_ram[ADDR] <= MACBUS_IN_REG;
            MACBUS_OUT_REG <= device_mac_ram[ADDR];
         end
      `Mcast1_MAC:
         begin
            if (MWE1)
               mcast1_mac_ram[ADDR] <= MACBUS_IN_REG;
            MACBUS_OUT_REG <= mcast1_mac_ram[ADDR];
         end
      `Mcast2_MAC:
         begin
            if (MWE1)
               mcast2_mac_ram[ADDR] <= MACBUS_IN_REG;
            MACBUS_OUT_REG <= mcast2_mac_ram[ADDR];
         end
      `Mcast3_MAC:
         begin
            if (MWE1)
               mcast3_mac_ram[ADDR] <= MACBUS_IN_REG;
            MACBUS_OUT_REG <= mcast3_mac_ram[ADDR];
         end
      `Dflt_Srv_MAC:
         begin
            if (MWE1)
               dflt_srv_mac_ram[ADDR] <= MACBUS_IN_REG;
            MACBUS_OUT_REG <= dflt_srv_mac_ram[ADDR];
         end
      default:
         begin
            MACBUS_OUT_REG <= device_mac_ram[ADDR];
         end
   endcase

   RCV_MAC  <= device_mac_ram[RCV_ADDR];
   MCAST1   <= mcast1_mac_ram[RCV_ADDR];
   MCAST2   <= mcast2_mac_ram[RCV_ADDR];
   MCAST3   <= mcast3_mac_ram[RCV_ADDR];

   TX_MAC   <= device_mac_ram[TX_ADDR];
   DFLT_MAC <= dflt_srv_mac_ram[DFLT_ADDR];

end
endmodule
