`timescale 1ns / 1ps

module main_tsm(VME_A,VME_B, VME_C, 
                FF_A, FF_B, FF_C, 
                TX_A, TX_B, TX_C, 
                RCV, RCTRL, MODENA, FRQ, MRQ, TXCTRL, TRNS, TCK, TMS, TDI, TDO,
                SW2,
                A, B, C);

    input [15:0] VME_A;
    input [15:0] VME_B;
    input [15:0] VME_C;
    input [15:0] FF_A;
    input [15:0] FF_B;
    input [15:0] FF_C;
    input [15:0] TX_A;
    input [15:0] TX_B;
    input [15:0] TX_C;
    input [15:0] RCV;
    input [2:0]  RCTRL;
    input [5:0]  MODENA;
    input FRQ;
    input MRQ;
    input TCK;
    input TMS;
    input TDI;
    input TDO;
    input [4:0]  TXCTRL;
    input [15:0] TRNS;
    input [3:0]  SW2;
   output [15:0] A;
   output [15:0] B;
   output [15:0] C;

reg [15:0] A;
reg [15:0] B;
reg [15:0] C;

always @(SW2 or VME_A or VME_B or VME_C or 
                    TX_A or TX_B or TX_C or
                    RCV or RCTRL or MODENA or FRQ or MRQ or TXCTRL or TRNS or
                    FF_A or FF_B or FF_C )
begin
   case (SW2)
      4'h2:
         begin
            A <= VME_A;
            B[10:0] <= VME_B[10:0];
            B[11] <= TCK;
            B[12] <= TMS;
            B[13] <= TDI;
            B[14] <= TDO;
            B[15] <= VME_B[15];
            C <= VME_C;
         end
      4'hA, 4'hB:
         begin
            A <= FF_A;
            B <= FF_B;
            C <= FF_C;
         end
      4'hC:
         begin
            A <= FF_A;
            B[7:0] <= FF_B[7:0];
            B[11:8] <= VME_A[15:12];
            B[15:12] <= FF_B[15:12];
            C <= FF_C;
         end
      4'hD:
         begin
            A <= VME_A;
            B[7:0] <= FF_B[7:0];
            B[11:8] <= VME_A[15:12];
            B[15:12] <= FF_B[15:12];
            C <= FF_C;
         end
      4'hE:
         begin
            A        <= RCV;
            B[2:0]   <= RCTRL;
            B[8:3]   <= MODENA;
            B[9]     <= FRQ;
            B[10]    <= MRQ;
            B[15:11] <= TXCTRL;
            C        <= TRNS;
         end
      4'hF:
         begin
            A <= TX_A;
            B <= TX_B;
            C <= TX_C;
         end
      default:
         begin
            A <= VME_A;
            B <= VME_B;
            C <= VME_C;
         end
   endcase
end
endmodule
