`timescale 1ns / 1ps

module multi_gigabit_xcvr(
      REFCLK,
      RXN,
      RXP,
      RXRESET,
      RXUSRCLK,
      RXUSRCLK2,
      TXCHARISK,
      TXDATA,
      TXRESET,
      TXUSRCLK,
      TXUSRCLK2,
      RXBUFSTATUS,
      RXCHARISCOMMA,
      RXCHARISK,
      RXCHECKINGCRC,
      RXCLKCORCNT,
      RXCOMMADET,
      RXCRCERR,
      RXDATA,
      RXDISPERR,
      RXLOSSOFSYNC,
      RXNOTINTABLE,
      RXREALIGN,
      RXRUNDISP,
      TXBUFERR,
      TXKERR,
      TXN,
      TXP,
      TXRUNDISP);

input REFCLK;
input RXN;
input RXP;
input RXRESET;
input RXUSRCLK;
input RXUSRCLK2;
input [1:0] TXCHARISK;
input [15:0] TXDATA;
input TXRESET;
input TXUSRCLK;
input TXUSRCLK2;

output [1:0] RXBUFSTATUS;
output [1:0] RXCHARISCOMMA;
output [1:0] RXCHARISK;
output RXCHECKINGCRC;
output [2:0] RXCLKCORCNT;
output RXCOMMADET;
output RXCRCERR;
output [15:0] RXDATA;
output [1:0] RXDISPERR;
output [1:0] RXLOSSOFSYNC;
output [1:0] RXNOTINTABLE;
output RXREALIGN;
output [1:0] RXRUNDISP;
output TXBUFERR;
output [1:0] TXKERR;
output TXN;
output TXP;
output [1:0] TXRUNDISP;

wire [3:2] RXCHARISCOMMA_float;
wire [3:2] RXCHARISK_float;
wire [31:16] RXDATA_float;
wire [3:2] RXDISPERR_float;
wire [3:2] RXNOTINTABLE_float;
wire [3:2] RXRUNDISP_float;
wire [3:2] TXKERR_float;
wire [3:2] TXRUNDISP_float;
wire       CONFIGOUT_float;
wire       RXRECCLK_float;

GT_CUSTOM #(
    .ALIGN_COMMA_MSB("TRUE"),
    .CHAN_BOND_LIMIT(1),
    .CHAN_BOND_MODE("OFF"),
    .CHAN_BOND_OFFSET(0),
    .CHAN_BOND_ONE_SHOT("FALSE"),
    .CHAN_BOND_SEQ_1_1(11'b00000000000),
    .CHAN_BOND_SEQ_1_2(11'b00000000000),
    .CHAN_BOND_SEQ_1_3(11'b00000000000),
    .CHAN_BOND_SEQ_1_4(11'b00000000000),
    .CHAN_BOND_SEQ_2_1(11'b00000000000),
    .CHAN_BOND_SEQ_2_2(11'b00000000000),
    .CHAN_BOND_SEQ_2_3(11'b00000000000),
    .CHAN_BOND_SEQ_2_4(11'b00000000000),
    .CHAN_BOND_SEQ_2_USE("FALSE"),
    .CHAN_BOND_SEQ_LEN(1),
    .CHAN_BOND_WAIT(7),
    .CLK_CORRECT_USE("TRUE"),
    .CLK_COR_INSERT_IDLE_FLAG("FALSE"),
    .CLK_COR_KEEP_IDLE("FALSE"),
    .CLK_COR_REPEAT_WAIT(1),
    .CLK_COR_SEQ_1_1(11'b00110111100),
    .CLK_COR_SEQ_1_2(11'b00001010000),
    .CLK_COR_SEQ_1_3(11'b00000000000),
    .CLK_COR_SEQ_1_4(11'b00000000000),
    .CLK_COR_SEQ_2_1(11'b00000000000),
    .CLK_COR_SEQ_2_2(11'b00000000000),
    .CLK_COR_SEQ_2_3(11'b00000000000),
    .CLK_COR_SEQ_2_4(11'b00000000000),
    .CLK_COR_SEQ_2_USE("FALSE"),
    .CLK_COR_SEQ_LEN(2),
    .COMMA_10B_MASK(10'b1111111000),
    .CRC_END_OF_PKT("K29_7"),
    .CRC_FORMAT("ETHERNET"),
    .CRC_START_OF_PKT("K27_7"),
    .DEC_MCOMMA_DETECT("TRUE"),
    .DEC_PCOMMA_DETECT("TRUE"),
    .DEC_VALID_COMMA_ONLY("TRUE"),
    .MCOMMA_10B_VALUE(10'b1100000000),
    .MCOMMA_DETECT("TRUE"),
    .PCOMMA_10B_VALUE(10'b0011111000),
    .PCOMMA_DETECT("TRUE"),
    .RX_BUFFER_USE("TRUE"),
    .RX_CRC_USE("TRUE"),
    .RX_DATA_WIDTH(2),
    .RX_DECODE_USE("TRUE"),
    .RX_LOSS_OF_SYNC_FSM("TRUE"),
    .RX_LOS_INVALID_INCR(1),
    .RX_LOS_THRESHOLD(4),
    .TERMINATION_IMP(50),
    .SERDES_10B("FALSE"),
    .TX_BUFFER_USE("TRUE"),
    .TX_CRC_FORCE_VALUE(8'b11010110),
    .TX_CRC_USE("TRUE"),
    .TX_DATA_WIDTH(2),
    .TX_DIFF_CTRL(500),
    .TX_PREEMPHASIS(0),
    .REF_CLK_V_SEL(0)
 ) MGT1(
    .CHBONDI (4'b0000),
    .CONFIGENABLE (1'b0),
    .CONFIGIN (1'b0),
    .ENMCOMMAALIGN (1'b1),
    .ENPCOMMAALIGN (1'b1),
    .ENCHANSYNC (1'b0),
    .LOOPBACK (2'b00),
    .POWERDOWN (1'b0),
    .REFCLK (REFCLK),
    .REFCLK2 (1'b0),
    .REFCLKSEL (1'b0),
    .BREFCLK (1'b0),
    .BREFCLK2 (1'b0),
    .RXN (RXN),
    .RXP (RXP),
    .RXPOLARITY (1'b0),
    .RXRESET (RXRESET),
    .RXUSRCLK (RXUSRCLK),
    .RXUSRCLK2 (RXUSRCLK2),
    .TXBYPASS8B10B (4'b0000),
    .TXCHARDISPMODE (4'b0000),
    .TXCHARDISPVAL (4'b0000),
    .TXCHARISK ( {2'b00, TXCHARISK[1:0]} ),
    .TXDATA ( {16'b0, TXDATA[15:0]} ),
    .TXFORCECRCERR (1'b0),
    .TXINHIBIT (1'b0),
    .TXPOLARITY (1'b0),
    .TXRESET (TXRESET),
    .TXUSRCLK (TXUSRCLK),
    .TXUSRCLK2 (TXUSRCLK2),
    .CHBONDDONE (),
    .CHBONDO (),
    .CONFIGOUT (CONFIGOUT_float),
    .RXBUFSTATUS (RXBUFSTATUS[1:0]),
    .RXCHARISCOMMA ( {RXCHARISCOMMA_float[3:2], RXCHARISCOMMA[1:0]} ),
    .RXCHARISK ( {RXCHARISK_float[3:2], RXCHARISK[1:0]} ),
    .RXCHECKINGCRC (RXCHECKINGCRC),
    .RXCLKCORCNT (RXCLKCORCNT[2:0]),
    .RXCOMMADET (RXCOMMADET),
    .RXCRCERR (RXCRCERR),
    .RXDATA ( {RXDATA_float[31:16], RXDATA[15:0]} ),
    .RXDISPERR ( {RXDISPERR_float[3:2], RXDISPERR[1:0]} ),
    .RXLOSSOFSYNC (RXLOSSOFSYNC[1:0]),
    .RXNOTINTABLE ( {RXNOTINTABLE_float[3:2], RXNOTINTABLE[1:0]} ),
    .RXREALIGN (RXREALIGN),
    .RXRECCLK (RXRECCLK_float),
    .RXRUNDISP ( {RXRUNDISP_float[3:2], RXRUNDISP[1:0]} ),
    .TXBUFERR (TXBUFERR),
    .TXKERR ( {TXKERR_float[3:2], TXKERR[1:0]} ),
    .TXN (TXN),
    .TXP (TXP),
    .TXRUNDISP ( {TXRUNDISP_float[3:2], TXRUNDISP[1:0]} )
  );

endmodule
