`timescale 1ns / 1ps

`ifndef HEADER
`include "header.v"
`endif

module pkt_bldr(CLK, TXRESET, PB_ENA, ACTIVE, DFLT_MAC, DATAIN, TXINSTR, POP, POPMH, SW2,
               DFLT_ADDR, DATAOUT, DATA_LEN, MAC_HDR, MHBITS, TYPE_STAT, FRAG_NUM,
               SEND, FRAG, NEW_PKT, MH_MT, MT, AF, FULL,
               TEST);

    input CLK;
    input TXRESET;
    input PB_ENA;
    input ACTIVE;
    input [15:0] DFLT_MAC;
    input [15:0] DATAIN;
    input [2:0] TXINSTR;
    input POP;
    input POPMH;
    input [3:0] SW2;
   output [1:0]  DFLT_ADDR;
   output [15:0] DATAOUT;
   output [12:0] DATA_LEN;
   output [15:0] MAC_HDR;
   output [1:0]  MHBITS;
   output [11:0] TYPE_STAT;
   output [31:0] FRAG_NUM;
   output SEND;  
   output FRAG;  
   output NEW_PKT;  
   output MH_MT;
   output MT;
   output AF;
   output FULL;
   output [15:0] TEST;


reg  [1:0]  DFLT_ADDR;
wire [15:0] DATAOUT;
wire [12:0] DATA_LEN;
reg  [15:0] MAC_HDR;
reg  [1:0]  MHBITS;
reg  [11:0] TYPE_STAT;
reg  [31:0] FRAG_NUM;
reg  SEND;
reg  FRAG;  
reg  NEW_PKT;  
wire MH_MT;
wire MT;
wire AF;
wire FULL;
reg  [15:0] TEST;


reg  POP_R;
reg  TLSF_PUSH;
reg  TLSF_POP;
reg  TLSF_LOAD;
reg  DMAC_PUSH;
reg  DHDR_PUSH;
reg  [2:0] TX_RD_ST;
reg  [1:0] TX_WRT_ST;
reg  [1:0] DFLT_HDR_ST;
reg  [2:0] DFLT_MAC_ST;
reg  NW_PKT;  
reg  FRGMNT;
reg  FRG_INC;
reg  FRG_RST;
reg  RTN_DAT;
reg  [15:0] DATAIN_R;
reg  [15:0] MH_DATA;
reg  [2:0]  TXINSTR_R;
wire [31:0] FRAG_CNT;
reg  [11:0] TP_ST;
wire [12:0] PKT_LEN;

wire GET_DFLT;
wire ZERO_HDR;
wire M_H_PUSH;
wire FORCE_SEND;
wire TLSF_MT, TLSF_FULL, TLSF_AMT, TLSF_AF;
wire PKT_PUSH;
wire PKT_LEN_RST;
wire MAX_SEND;
wire AMT;
wire PF_WERR,PF_RERR;
wire TLSF_WERR,TLSF_RERR;
wire [9:0]MH_CNT;
wire MH_FULL;
wire MH_AMT;
wire MH_AF;
wire MH_WTERR;
wire MH_RDERR;
reg  MBIT,HBIT;
wire PMHFF;
reg  PMHSRL;
reg  [15:0] SRL_IN_DAT;
reg  [1:0] SRL_IN_BITS;
wire [1:0] MHBITS_FF;
wire [15:0] MAC_HDR_FF;
wire [1:0] MHBITS_SRL;
wire [15:0] MAC_HDR_SRL;


wire [12:0] TXF_CNT;
wire [8:0] TLSF_CNT;
wire DMY1,DMY2;
wire [3:0] DMY4;
wire [6:0] DMY7;
wire RD_NW_PKT;
wire RD_FRGMNT;
wire [31:0] RD_FRAG_CNT;
wire [11:0] RD_TP_ST;
wire [12:0] RD_PKT_LEN;
wire OE;
wire WITH_DATA;

assign OE           = PB_ENA && ACTIVE;
assign GET_DFLT     = PB_ENA && ACTIVE && (TXINSTR_R == `Tx_NoMAC);
assign ZERO_HDR     = PB_ENA && ACTIVE && (TXINSTR_R == `Tx_NoHead);
assign M_H_PUSH     = PB_ENA && ACTIVE && ((TXINSTR_R == `Tx_MAC) || (TXINSTR_R == `Tx_Head));
assign MH_PUSH      = M_H_PUSH || DMAC_PUSH || DHDR_PUSH;
assign AST_CAP      = PB_ENA && ACTIVE && (TXINSTR_R == `Tx_AST);
assign PKT_PUSH     = PB_ENA && ACTIVE && (TXINSTR_R == `Tx_Data);
assign FORCE_SEND   = PB_ENA && ACTIVE && (TXINSTR_R == `Tx_Send);
assign MAX_SEND     = (PKT_LEN == `Max_Payload);
assign PKT_LEN_RST  = TXRESET || MAX_SEND || FORCE_SEND;
assign PMHFF        = POPMH && NEW_PKT;
assign RST_RTN_DAT  = FORCE_SEND || TXRESET;

// Test point signals /////////////////////////////////////////////////////////////////////////////
always @(posedge CLK)
begin
   case (SW2)
      4'hF:
         begin
            TEST[2:0] <= TX_RD_ST;
            TEST[6:3] <= DATA_LEN[3:0];
            TEST[7]   <= SEND;
            TEST[8]   <= NEW_PKT;
            TEST[9]   <= MH_MT;
            TEST[10]  <= MT;
            TEST[11]  <= TLSF_POP;
            TEST[12]  <= TLSF_LOAD;
            TEST[13]  <= TLSF_PUSH;
            TEST[14]  <= DMAC_PUSH;
            TEST[15]  <= TLSF_LOAD;
         end
      default: 
         begin
            TEST <= 16'h0000;
         end
   endcase
end


always @(posedge CLK)
begin
   DATAIN_R <= DATAIN;
   TXINSTR_R <= TXINSTR;
   POP_R    <= POP;
   PMHSRL <= POPMH;
end


defparam frag_cntr.width = 32;
cnt_up   frag_cntr(.clk(CLK),.inc(FRG_INC),.r(FRG_RST),.count(FRAG_CNT));

defparam pkt_len_cnt.width = 13;
cnt_up_r10   pkt_len_cnt(.clk(CLK),.inc(PKT_PUSH),.r(PKT_LEN_RST),.count(PKT_LEN));

defparam pkt_fifo.almostmt = 32; 
defparam pkt_fifo.almostfull = `Pb_AF_Cnt;
fifo_8Kx16 pkt_fifo(.clk(CLK),.rst(TXRESET),.push(PKT_PUSH),.pop(POP_R),
                       .mt(MT),.full(FULL),.amt(AMT),.af(AF),
                       .wterr(PF_WERR),.rderr(PF_RERR),
                       .din(DATAIN_R),.dout(DATAOUT),.cnt(TXF_CNT));

defparam mh_ff.p2depth = 10; // Depth 2^10 = 1024
defparam mh_ff.width = 18; 
defparam mh_ff.almostmt = 5;  
defparam mh_ff.almostfull = 1019;

fifo_dpXn_blk mh_ff(.clk(CLK),.rst(TXRESET),.push(MH_PUSH),.pop(PMHFF),
     .mt(MH_MT),.full(MH_FULL),.amt(MH_AMT),.af(MH_AF),.wterr(MH_WTERR),.rderr(MH_RDERR),
     .din({MBIT,HBIT,MH_DATA}),.dout({MHBITS_FF,MAC_HDR_FF}),.cnt(MH_CNT));
always @(SEND or NEW_PKT or MAC_HDR_FF or MHBITS_FF or MAC_HDR_SRL or MHBITS_SRL)
begin  // mux for SRL input
   if(SEND && NEW_PKT)
      begin
         SRL_IN_DAT <= MAC_HDR_FF;
         SRL_IN_BITS <= MHBITS_FF;
      end
   else
      begin
         SRL_IN_DAT <= MAC_HDR_SRL;
         SRL_IN_BITS <= MHBITS_SRL;
      end
end
macsrl  mh_srl(.clk(CLK),.ce(PMHSRL),.mhin(SRL_IN_BITS),.din(SRL_IN_DAT),.mhout(MHBITS_SRL),.dout(MAC_HDR_SRL));
always @(posedge CLK)
begin // Fifo/SRL mux
   if(SEND && !NEW_PKT)
      begin
         MHBITS  <= MHBITS_SRL;
         MAC_HDR <= MAC_HDR_SRL;
      end
   else
      begin
         MHBITS  <= MHBITS_FF;
         MAC_HDR <= MAC_HDR_FF;
      end
end

defparam tlsf_fifo.p2depth = 9;
defparam tlsf_fifo.width = 72;
defparam tlsf_fifo.almostmt = 32;
defparam tlsf_fifo.almostfull = 479;
fifo_dpXn_blk tlsf_fifo(.clk(CLK),.rst(TXRESET),.push(TLSF_PUSH),.pop(TLSF_POP),
                       .mt(TLSF_MT),.full(TLSF_FULL),.amt(TLSF_AMT),
                       .af(TLSF_AF),.wterr(TLSF_WERR),.rderr(TLSF_RERR),
                       .din({7'h00,PKT_LEN,1'b0,NW_PKT,FRGMNT,1'b0,TP_ST,4'h0,FRAG_CNT}),
                       .dout({DMY7,RD_PKT_LEN,DMY1,RD_NW_PKT,RD_FRGMNT,DMY2,RD_TP_ST,DMY4,RD_FRAG_CNT}),
                       .cnt(TLSF_CNT));

defparam dlen_cnt.width = 13;
cnt_dn_l dlen_cnt(.clk(CLK),.dec(POP),.r(TXRESET),.l(TLSF_LOAD),.din(RD_PKT_LEN),.count(DATA_LEN));

always @(posedge CLK or posedge TXRESET)
begin: TLSF_out_reg
   if(TXRESET)
      begin
         FRAG_NUM <= 32'h00000000;
         TYPE_STAT <= 12'h000;
         FRAG <= 0;  
         NEW_PKT <= 0;  
      end
   else
      if(TLSF_LOAD)
         begin
            FRAG_NUM <= RD_FRAG_CNT;
            TYPE_STAT <= RD_TP_ST;
            FRAG <= RD_FRGMNT;  
            NEW_PKT <= RD_NW_PKT;  
         end
      else
         begin
            FRAG_NUM <= FRAG_NUM;
            TYPE_STAT <= TYPE_STAT;
            FRAG <= FRAG;  
            NEW_PKT <= NEW_PKT;  
         end
end

always @ (posedge CLK or posedge TXRESET)
begin: TX_FIFO_Read_control
 if (TXRESET)
    TX_RD_ST <= `Wait_for_Payload;
 else
    case (TX_RD_ST)
       `Wait_for_Payload:
          if (!TLSF_MT)
             TX_RD_ST <= `Load_Data_Len;
          else
             TX_RD_ST <= `Wait_for_Payload;
       `Load_Data_Len:
          TX_RD_ST <= `With_Data; 
       `With_Data:
          if (DATA_LEN != 13'h0000)
             TX_RD_ST <= `Issue_Send1;
          else
             TX_RD_ST <= `Issue_Send2;
       `Issue_Send1:
          if (DATA_LEN == 13'h0000)
             TX_RD_ST <= `Wait_for_Payload;
          else
             TX_RD_ST <= `Issue_Send1;
       `Issue_Send2:
          if (POPMH)
             TX_RD_ST <= `Issue_Send3;
          else
             TX_RD_ST <= `Issue_Send2;
       `Issue_Send3:
          if (!POPMH)
             TX_RD_ST <= `Wait_for_Payload;
          else
             TX_RD_ST <= `Issue_Send3;
       default 
          TX_RD_ST <= `Wait_for_Payload;
    endcase
end

always @ (TX_RD_ST or TLSF_MT or DATA_LEN)
begin  
 case (TX_RD_ST) 
    `Wait_for_Payload:
       begin
          TLSF_POP <= !TLSF_MT;
          TLSF_LOAD <= 1'b0;
          SEND <= 1'b0;
       end
    `Load_Data_Len:
       begin
          TLSF_POP <= 1'b0;
          TLSF_LOAD <= 1'b1;
          SEND <= 1'b0;
       end
    `Issue_Send1:
       begin
          TLSF_POP <= 1'b0;
          TLSF_LOAD <= 1'b0;
          SEND <= (DATA_LEN != 13'h0000);
       end
    `Issue_Send2,`Issue_Send3:
       begin
          TLSF_POP <= 1'b0;
          TLSF_LOAD <= 1'b0;
          SEND <= 1'b1;
       end
    default:
       begin
          TLSF_POP <= 1'b0;
          TLSF_LOAD <= 1'b0;
          SEND <= 1'b1;
       end
endcase
end 

always @ (posedge CLK or posedge TXRESET)
begin: TX_FIFO_write_control
 if (TXRESET)
    TX_WRT_ST <= `Frag_Rst;
 else
    case (TX_WRT_ST)
       `Frag_Rst: 
          TX_WRT_ST <= `New_Pkts;
       `New_Pkts:
          if (MAX_SEND)
             TX_WRT_ST <= `Cont_Pkts;
          else
             TX_WRT_ST <= `New_Pkts;
       `Cont_Pkts:
          if (FORCE_SEND)
             TX_WRT_ST <= `New_Pkts;
          else
             TX_WRT_ST <= `Cont_Pkts;
       default 
          TX_WRT_ST <= `Frag_Rst;
    endcase
end
always @ (TX_WRT_ST or MAX_SEND or FORCE_SEND)
begin  
   case (TX_WRT_ST) 
      `Frag_Rst: 
         begin
            TLSF_PUSH <= 1'b0;
            NW_PKT  <= 1'b0;
            FRGMNT  <= 1'b0;
            FRG_INC <= 1'b0;
            FRG_RST <= 1'b1;
         end
      `New_Pkts:
         begin
            TLSF_PUSH <= MAX_SEND || FORCE_SEND;
            NW_PKT  <= MAX_SEND || FORCE_SEND;
            FRGMNT  <= MAX_SEND;
            FRG_INC <= MAX_SEND;
            FRG_RST <= 1'b0;
         end
      `Cont_Pkts:
         begin
            TLSF_PUSH <= MAX_SEND || FORCE_SEND;
            NW_PKT  <= 1'b0;
            FRGMNT  <= MAX_SEND || FORCE_SEND;
            FRG_INC <= MAX_SEND;
            FRG_RST <= FORCE_SEND;
         end
      default 
         begin
            TLSF_PUSH <= 1'b0;
            NW_PKT  <= 1'b0;
            FRGMNT  <= 1'b0;
            FRG_INC <= 1'b0;
            FRG_RST <= 1'b0;
         end
   endcase
end
always @(DMAC_PUSH or DHDR_PUSH or DFLT_MAC or DATAIN_R or TXINSTR_R)
begin: MH_FIFO_MUX
   if(DMAC_PUSH)
      begin
         MH_DATA <= DFLT_MAC;
         MBIT   <= 1;
         HBIT   <= 0;
      end
   else if(DHDR_PUSH)
      begin
         MH_DATA <= 16'h0000;
         MBIT   <= 0;
         HBIT   <= 1;
      end
   else
      begin
         MH_DATA <= DATAIN_R;
         MBIT   <= (TXINSTR_R == `Tx_MAC);
         HBIT   <= (TXINSTR_R == `Tx_Head);
      end
end
always @(posedge CLK)
begin: return_data_reg
   if(RST_RTN_DAT)
      RTN_DAT <= 0;
   else
      if(PKT_PUSH)
         RTN_DAT <= 1;
      else
         RTN_DAT <= RTN_DAT;
end
always @(posedge CLK or posedge TXRESET)
begin: Type_Status_reg
   if(TXRESET)
      TP_ST <= 12'h000;
   else
      if(AST_CAP)
         TP_ST <= {RTN_DAT,DATAIN_R[10:0]};
      else
         TP_ST <= {RTN_DAT,TP_ST[10:0]};
end
always @(posedge CLK or posedge TXRESET)
begin: TX_FIFO_DFLT_MAC
   if(TXRESET)
      DFLT_MAC_ST <= `DMACA0;
   else
      case(DFLT_MAC_ST)
         `DMACA0:
            if(GET_DFLT)
               DFLT_MAC_ST <= `DMACA1;
            else
               DFLT_MAC_ST <= `DMACA0;
         `DMACA1:
            DFLT_MAC_ST <= `DMACA2;
         `DMACA2:
            DFLT_MAC_ST <= `DMACP2;
         `DMACP2:
            DFLT_MAC_ST <= `DMACA0;
         default:
            DFLT_MAC_ST <= `DMACA0;
      endcase
end
always @(DFLT_MAC_ST or OE)
begin
   if(OE)
      case (DFLT_MAC_ST) 
         `DMACA1:
            DFLT_ADDR <= 2'd1;
         `DMACA2:
            DFLT_ADDR <= 2'd2;
         default:
            DFLT_ADDR <= 2'd0;
      endcase
   else
      DFLT_ADDR <= 2'bzz;
end
always @(DFLT_MAC_ST)
begin
   case (DFLT_MAC_ST) 
      `DMACA1,`DMACA2,`DMACP2:
         DMAC_PUSH <= 1'b1;
      default:
         DMAC_PUSH <= 1'b0;
   endcase
end
always @(posedge CLK or posedge TXRESET)
begin: TX_FIFO_DFLT_HDR
   if(TXRESET)
      DFLT_HDR_ST <= `DHDR00;
   else
      case(DFLT_HDR_ST)
         `DHDR00:
            if(ZERO_HDR)
               DFLT_HDR_ST <= `DHDRP0;
            else
               DFLT_HDR_ST <= `DHDR00;
         `DHDRP0:
            if(DFLT_MAC_ST == `DMACA0)
               DFLT_HDR_ST <= `DHDRP1;
            else
               DFLT_HDR_ST <= `DHDRP0;
         `DHDRP1:
            DFLT_HDR_ST <= `DHDR00;
         default:
            DFLT_HDR_ST <= `DHDR00;
      endcase
end
always @(DFLT_HDR_ST or DFLT_MAC_ST)
begin
   case (DFLT_HDR_ST) 
      `DHDRP0:
         DHDR_PUSH <= (DFLT_MAC_ST == `DMACA0);
      `DHDRP1:
         DHDR_PUSH <= 1'b1;
      default:
         DHDR_PUSH <= 1'b0;
   endcase
end

endmodule
