`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"
`endif

module reset_handler(CLK,DV1024CLK,POW_ON_RST,SHDWN,RESET_CNFG,FRC_RLD,
                     RST_ENAS, INT_RESET_BAR, PREP4SHTDWN);

    input CLK;
    input DV1024CLK;
    input POW_ON_RST;
    input [2:0] SHDWN;
    input [4:0] RESET_CNFG;
    input FRC_RLD;
    output [4:0] RST_ENAS;
    output INT_RESET_BAR;           
    output PREP4SHTDWN;

reg [4:0] RST_ENAS;
wire INT_RESET_BAR;           
reg PREP4SHTDWN;



reg [15:0] RST_TIMER;

wire HOLD_OFF_ENAS;


assign INT_RESET_BAR = !FRC_RLD;
assign HOLD_OFF_ENAS = !(RST_TIMER == `RST_hold_off);

always @(posedge CLK)
begin
   PREP4SHTDWN <= &SHDWN;
end

always @ (posedge DV1024CLK)
begin: RST_holdoff_timer
   if(POW_ON_RST) 
      RST_TIMER <= 0;
   else if(HOLD_OFF_ENAS)
      RST_TIMER <= RST_TIMER+1;
   else
      RST_TIMER <= RST_TIMER;
end

// Reset Enable Signals:
//
//      Internal 5'b00001
//   Front_Panel 5'b00010
//  System_Reset 5'b00100
//    Hard_Reset 5'b01000
// External_JTAG 5'b10000
 
always @ (posedge CLK)
begin
   if (POW_ON_RST || HOLD_OFF_ENAS)
      RST_ENAS <= 0;
   else
      RST_ENAS <= RESET_CNFG;
end
   

endmodule
