`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"
`endif

module rx_frame_intf(CLK, RXRESET, DATAIN, FRAME_LEN, MAC,
      FF_RDY, MAC_REQ, FRAME_REQ, PASS_THRU, RST_SEQ, MT,
      BUSY, READ, MAC_POP, DATAOUT, RCTRL, MOD_ENA);

    input CLK;
    input RXRESET;
    input [15:0] DATAIN;
    input [12:0] FRAME_LEN;
    input [15:0] MAC;
    input FF_RDY;
    inout MAC_REQ;
    inout FRAME_REQ;
    input PASS_THRU;
    input RST_SEQ;
    input MT;
   output BUSY;
   output READ;
   output MAC_POP;
   output [15:0] DATAOUT;
   output [2:0] RCTRL;
   output [5:0] MOD_ENA;
   

reg  BUSY;
reg  READ;
reg  MAC_POP;  
reg  [15:0] DATAOUT;
reg  [2:0] RCTRL; 
wire [5:0] MOD_ENA; 

reg [15:0] DATA_MUX;
reg [4:0] MON_SIGS;
reg [4:0] SIGS_AT_ERR;
reg [4:0] ERR_MUX;
reg [15:0] MAC_MUX;
reg [15:0] HDR;
reg [15:0] HDR_MUX;
reg [15:0] MUX_OUT;
reg [2:0] RCMD;
reg [2:0] RCMS;
reg [2:0] MUX_SEL;

reg [15:0] CTRL;
reg [15:0] SEQ_PKT_ID;
reg [5:0] MOD_SEL;
reg [3:0] FF_READ_ST;
reg [12:0] LEN1,LEN2,LEN3,LEN_MUX;
reg LOAD_CTRL;
reg SEL_SEQ;
reg SLM;
reg MAC_DONE;
reg IN_PRGS;
reg BUSS_CLR;
reg DRV_FRAME_REQ; 

wire [15:0] CS_MUX;
wire LPBCK;

assign MAC_REQ   = DRV_FRAME_REQ ? 1'b0 : 1'bZ;
assign FRAME_REQ = DRV_FRAME_REQ ? 1'b0 : 1'bZ;
assign MOD_ENA   = BUSY ? MOD_SEL : 6'h00;
assign CS_MUX = (SEL_SEQ) ? SEQ_PKT_ID : CTRL; 
assign LPBCK = (CTRL == `Loopback);



always @(posedge CLK)
begin
   DATA_MUX    <= DATAIN;
   LEN1        <= FRAME_LEN;
   LEN2        <= LEN1;
   LEN3        <= LEN2;
   LEN_MUX     <= LEN3;
   MON_SIGS    <= {READ,FRAME_REQ,MAC_REQ,FF_RDY,MT};
   SIGS_AT_ERR <= MON_SIGS;
   ERR_MUX     <= SIGS_AT_ERR;
   MAC_MUX     <= MAC;
   HDR         <= CS_MUX;
   HDR_MUX     <= HDR;
   DATAOUT     <= MUX_OUT;
   RCMS        <= RCMD;
   MUX_SEL     <= RCMS;
   RCTRL       <= MUX_SEL;
   SLM         <= MAC_POP;
   MAC_DONE    <= SLM;
   BUSY        <= IN_PRGS;
   BUSS_CLR    <= !BUSY;
end
always @(posedge CLK or posedge RXRESET)
begin
   if (RXRESET)
      CTRL <= 16'h0000;
   else
      if (LOAD_CTRL)
         CTRL <= DATAIN;
      else
         CTRL <= CTRL;
end    


always @(posedge CLK or posedge RXRESET)
begin
   if(RXRESET)
      SEQ_PKT_ID <= 16'h0000;
   else
      if (RST_SEQ)
         SEQ_PKT_ID <= 16'h0000;
      else if (LOAD_CTRL)
         SEQ_PKT_ID <= SEQ_PKT_ID + 1;
      else
         SEQ_PKT_ID <= SEQ_PKT_ID;
end

always @(posedge CLK or posedge RXRESET)
begin: Cmd_Parser
   if(RXRESET)
      MOD_SEL <= 6'b000000;
   else
      if(PASS_THRU)
         MOD_SEL <= 6'b100000;
      else
         casex(CTRL[7:0])
            8'h0X,8'h1X:
               MOD_SEL <= 6'b000001; //Config Module Commands 00 - 1F
            8'b00100001,8'b0010001x,8'b001001xx,8'b00101xxx:
               MOD_SEL <= 6'b000010; //VME Direct Module Commands 21 -2F
            8'h3X:
               MOD_SEL <= 6'b000100; //JTAG Module Commands 30-3F
            8'h4X:
               MOD_SEL <= 6'b001000; //Flash Module Commands 40-4F
            8'hEX,8'h20:
               MOD_SEL <= 6'b010000; //External FIFO Module Commands E0-EF and buffered VME commands
            default:
               MOD_SEL <= 6'b100000; //Ethernet Module Commands F0-FF and all others;
         endcase
end

always @(MUX_SEL or DATA_MUX or ERR_MUX or MAC_MUX or HDR_MUX or LEN_MUX)
begin
   case (MUX_SEL)
      `Rx_ErrWrd1:
         MUX_OUT <= {11'h000,ERR_MUX};// 1st error word
      `Rx_ErrWrd2:
         MUX_OUT <= {3'o0,LEN_MUX};// 2nd error word
      `Rx_MAC:
         MUX_OUT <= MAC_MUX;
      `Rx_HDR:
         MUX_OUT <= HDR_MUX;
      default:
         MUX_OUT <= DATA_MUX;
   endcase
end

always @(posedge CLK or posedge RXRESET)
begin: FF_READ_FSM
   if (RXRESET)
      FF_READ_ST <= `RxFr_Idle;
   else
      case (FF_READ_ST)
         `RxFr_Idle:
            if (FF_RDY)
               FF_READ_ST <= `Store_Ctrl_Wrd;
            else
               FF_READ_ST <= `RxFr_Idle; 
         `Store_Ctrl_Wrd:
            FF_READ_ST <= `Wait_4_MAC_Req; 
         `Wait_4_MAC_Req:
            if (MAC_REQ)
               FF_READ_ST <= `RxFr_Send_MAC;
            else
               FF_READ_ST <= `Wait_4_MAC_Req; 
         `RxFr_Send_MAC:
            if (MAC_DONE)
               FF_READ_ST <= `Send_Ctrl;
            else
               FF_READ_ST <= `RxFr_Send_MAC; 
         `Send_Ctrl: 
               FF_READ_ST <= `Send_Seq;
         `Send_Seq: 
            if (FRAME_REQ)
               FF_READ_ST <= `Read_FIFO;
            else
               FF_READ_ST <= `Wait_4_Frame_Req; 
         `Wait_4_Frame_Req:
            if (FRAME_REQ)
               FF_READ_ST <= `Read_FIFO;
            else
               FF_READ_ST <= `Wait_4_Frame_Req; 
         `Read_FIFO: 
            if (FRAME_LEN == 13'h0000)
               FF_READ_ST <= `End_of_Pkt;
//               FF_READ_ST <= `Rpt_Error;
            else if (MT)
               FF_READ_ST <= `Rpt_Error; 
            else
               FF_READ_ST <= `Read_FIFO; 
         `Rpt_Error: 
               FF_READ_ST <= `Err_Wrd_2;
         `Err_Wrd_2: 
               FF_READ_ST <= `End_of_Pkt;
         `End_of_Pkt: 
               FF_READ_ST <= `Clr_Buss;
         `Clr_Buss: 
            if (BUSS_CLR)
               FF_READ_ST <= `RxFr_Idle;
            else
               FF_READ_ST <= `Clr_Buss; 
         default: 
            FF_READ_ST <= `RxFr_Idle;
   endcase
end

always @(FF_READ_ST or MT or FRAME_LEN or PASS_THRU or LPBCK)
begin: FSM_OUTS
   case (FF_READ_ST)
      `Store_Ctrl_Wrd:
         begin
            READ <= 0;
            LOAD_CTRL <= 1;
            MAC_POP <= 0;
            SEL_SEQ <= 0;
         end
      `RxFr_Send_MAC: 
         begin
            READ <= 0;
            LOAD_CTRL <= 0;
            MAC_POP <= 1;
            SEL_SEQ <= 0;
         end
      `Send_Seq: 
         begin
            READ <= !(PASS_THRU || LPBCK || MT); //Drop the first word
            LOAD_CTRL <= 0;
            MAC_POP <= 0;
            SEL_SEQ <= 1;
         end
      `Read_FIFO: 
         begin
            READ <= !MT && (FRAME_LEN != 13'h0000);
            LOAD_CTRL <= 0;
            MAC_POP <= 0;
            SEL_SEQ <= 0;
         end
      default: 
         begin
            READ <= 0;
            LOAD_CTRL <= 0;
            MAC_POP <= 0;
            SEL_SEQ <= 0;
         end
   endcase
end
always @(FF_READ_ST)
begin: FSM_OUTS1
   case (FF_READ_ST)
      `Wait_4_MAC_Req,`RxFr_Send_MAC,`Send_Ctrl,`Send_Seq,`Wait_4_Frame_Req,
      `Read_FIFO,`Rpt_Error,`Err_Wrd_2,`End_of_Pkt:
         IN_PRGS <= 1;
      default: 
         IN_PRGS <= 0;
   endcase
end

always @(FF_READ_ST or READ)
begin: FSM_OUTS2
   case (FF_READ_ST)
      `Wait_4_MAC_Req:
         RCMD <= `Rx_OpCode;
      `RxFr_Send_MAC:
         RCMD <= `Rx_MAC;
      `Send_Ctrl,`Send_Seq: 
         RCMD <= `Rx_HDR;
      `Read_FIFO: 
         RCMD <= READ?`Rx_Data:`Rx_NoData;
      `Rpt_Error: 
         RCMD <= `Rx_ErrWrd1;
      `Err_Wrd_2: 
         RCMD <= `Rx_ErrWrd2;
      `End_of_Pkt: 
         RCMD <= `Rx_EOP;
      default: 
         RCMD <= `Rx_NoData;
   endcase
end

always @(posedge CLK)
begin
   DRV_FRAME_REQ = ~|MOD_ENA ;
end
        
endmodule
