`timescale 1ns / 1ps

`ifndef HEADER
`include "header.v"
`endif


// synthesis attribute ram_style of strtup_shtdwn is distributed
// synthesis attribute rom_style of strtup_shtdwn is distributed

module strtup_shtdwn(CLK, BRAWCLK, RW_INI, DCM_RDY, BG,
         FIBER_SIG_DET, MRST_DONE, PH2_DONE, HRDW_INI_DONE, VALID_CNUM,
         PREP4SHTDWN, WARN_ON_SHTDWN, ENA_STRT_PKT, TX_INPRGS,
         ETH_RDY4SHTDWN, CNFG_RDY4SHTDWN, FLASH_RDY4SHTDWN, JTAG_RDY4SHTDWN, EXFF_RDY4SHTDWN, VME_RDY4SHTDWN,
         RXLOSSOFSYNC, VME_READY,
         RAW_POW_ON_RST, POW_ON_RST, RXRESET, TXRESET, MAC_RXRESET, MAC_TXRESET,
         CP_RST, FF_RST,
         PU_RSTR_MACS, PU_RSTR_DFLT, PU_RSTR_CNFG, HRDW_INI,
         BR, TXDATA, TXCTRL, RDY4SHTDWN);


   input CLK;
   input BRAWCLK;
   input RW_INI;
   input DCM_RDY;
   input BG;
   input FIBER_SIG_DET;
   input MRST_DONE;
   input PH2_DONE;
   input HRDW_INI_DONE;
   input VALID_CNUM;
   input PREP4SHTDWN;
   input WARN_ON_SHTDWN;
   input ENA_STRT_PKT;
   input TX_INPRGS;
   input ETH_RDY4SHTDWN;
   input CNFG_RDY4SHTDWN;
   input FLASH_RDY4SHTDWN;
   input JTAG_RDY4SHTDWN;
   input EXFF_RDY4SHTDWN;
   input VME_RDY4SHTDWN;
   input [1:0] RXLOSSOFSYNC;
   input VME_READY;
   
   output RAW_POW_ON_RST;
   output POW_ON_RST;
   output RXRESET;
   output TXRESET;
   output MAC_RXRESET;
   output MAC_TXRESET;
   output CP_RST;
   output FF_RST;
   output PU_RSTR_MACS;
   output PU_RSTR_DFLT;
   output PU_RSTR_CNFG;
   output HRDW_INI;
   output BR;
   output [15:0] TXDATA;
   output [4:0] TXCTRL;
   output RDY4SHTDWN;


wire RAW_POW_ON_RST;
reg  POW_ON_RST;
reg  RXRESET;
reg  TXRESET;
reg  MAC_RXRESET;
reg  MAC_TXRESET;
wire CP_RST;
reg  FF_RST;
wire PU_RSTR_MACS;
wire PU_RSTR_DFLT;
wire PU_RSTR_CNFG;
wire HRDW_INI;
wire BR;
reg  [15:0] TXDATA;
reg  [4:0] TXCTRL;
wire RDY4SHTDWN;


reg [4:0] SYNC_CNT;
reg [15:0] OPL_CNT;
reg [3:0] ETH_STUP_ST;
reg [3:0] PUC_ST;
reg [2:0] POR_ST;
reg [3:0] POR_TIMER;
reg [1:0] SHTDWN_ST;
reg [3:0] RTXP_ST;
reg [23:0] SHTDWN_CNT;
reg [15:0] DATA_MUX;
reg [2:0] INSTR_MUX;
reg ALL_READY;
reg NOMAC_DONE;
reg NOHDR_DONE;
reg NMD;
reg FLSHD;


wire SYNC;
wire WTIME;
wire OPL_ENA;
wire OPL_GO;

wire RAW_FF_RST;
wire POR_CNT;
wire POR_DONE;

wire PU_CNFG_DONE;

wire SEND_STRT_PKT;
wire XMIT_RST;
wire MAC_XMIT_RST;
wire RCV_RST;
wire MAC_RCV_RST;
wire SYNC_CNT_RST;

wire SEND_WARN_PKT;
wire SHTDWN_TMO;

wire RTXP_NO_MAC;
wire RTXP_NO_HDR;
wire RTXP_DATA;
wire RTXP_STAT;
wire RTXP_SEND;
wire RTXP_FLUSH;         
wire RTXP_DONE;

wire START;
wire START_PKT_SENT;
wire WARN_PKT_SENT;

assign SYNC     = (RXLOSSOFSYNC == 2'b00);
assign WTIME    = (SYNC_CNT == `Sync_Wait_Time);
assign OPL_ENA = (ETH_STUP_ST == `W4OpLink);
assign OPL_GO   = (OPL_CNT == `OpLink_Holdoff);

//assign RAW_POW_ON_RST = !((POR_ST == `Run_State) || (POR_ST == `W4Sclk));
assign RAW_POW_ON_RST = !(POR_ST == `Run_State);
assign RAW_FF_RST = (POR_ST == `W4Clks);
assign POR_CNT    = (POR_ST == `Pow_on_Rst);
assign POR_DONE   = POR_CNT && (POR_TIMER == `POR_TMO);

assign HRDW_INI     = (PUC_ST == `Hrdw_Ini);
assign PU_RSTR_DFLT = (PUC_ST == `Get_Dflt_Cnfg);
assign PU_RSTR_MACS = (PUC_ST == `Rstr_MACs);
assign PU_RSTR_CNFG = (PUC_ST == `Rstr_Cnfg);
assign PU_CNFG_DONE = (PUC_ST == `PU_Cnfg_Done);

assign SEND_STRT_PKT = (ETH_STUP_ST == `Snd_Start_Pkt);
assign XMIT_RST     = (ETH_STUP_ST == `Wait_for_Fiber);
assign MAC_XMIT_RST = (ETH_STUP_ST == `Wait_for_Fiber) || (ETH_STUP_ST == `Start_RIO_TX);
assign RCV_RST      = (ETH_STUP_ST == `Wait_for_Fiber) || (ETH_STUP_ST == `Start_RIO_TX) || (ETH_STUP_ST == `Start_TX);
assign MAC_RCV_RST  =!(ETH_STUP_ST == `Running);
assign SYNC_CNT_RST =!((ETH_STUP_ST == `Wait_Time_1)   || (ETH_STUP_ST == `Wait_Time_2));
assign CP_RST       =!((ETH_STUP_ST == `Running) || (ETH_STUP_ST == `Wait_for_Sync) || (ETH_STUP_ST == `Wait_Time_2));

assign SEND_WARN_PKT = (SHTDWN_ST == `SD_Send_Warn);
assign RDY4SHTDWN    = (SHTDWN_ST == `SD_Rdy4Shtdwn);
assign SHTDWN_TMO    = (SHTDWN_CNT >= `Shutdown_Time_Out);

assign BR          = !((RTXP_ST == `rTxP_Idle) || (RTXP_ST == `rTxP_Rel_Bus) || (RTXP_ST == `rTxP_Done));
assign RTXP_NO_MAC = (RTXP_ST == `rTxP_No_MAC);
assign RTXP_NO_HDR = (RTXP_ST == `rTxP_No_Hdr);
assign RTXP_DATA   = (RTXP_ST == `rTxP_Data);
assign RTXP_STAT   = (RTXP_ST == `rTxP_Stat);
assign RTXP_SEND   = (RTXP_ST == `rTxP_Send);
assign RTXP_FLUSH  = (RTXP_ST == `rTxP_Flush);         
assign RTXP_DONE   = (RTXP_ST == `rTxP_Done);

assign START          = SEND_WARN_PKT || SEND_STRT_PKT;
assign START_PKT_SENT = RTXP_DONE && SEND_STRT_PKT;
assign WARN_PKT_SENT  = RTXP_DONE && SEND_WARN_PKT;

always @ (posedge CLK)
begin
   POW_ON_RST <= RAW_POW_ON_RST;        //Synchronization register
   FF_RST <= RAW_FF_RST;                //Synchronization register
   RXRESET <= RCV_RST || POW_ON_RST;
   TXRESET <= XMIT_RST || POW_ON_RST;
   MAC_RXRESET <= MAC_RCV_RST || POW_ON_RST;
   MAC_TXRESET <= MAC_XMIT_RST || POW_ON_RST;
end



////////////////////////////////////////////////////////////////
//                                                            //
// Power on Reset signal State machine        (Uses BRawClk)  //
//                                                            //
////////////////////////////////////////////////////////////////

always @(posedge BRAWCLK or posedge RW_INI)
begin:  POW_on_Rst_FSM
   if (RW_INI)
      POR_ST <= `W4Clks;
   else
      case(POR_ST)
         `W4Clks:
            if(DCM_RDY)
               POR_ST <= `FIFO_Startup;
            else
               POR_ST <= `W4Clks;
         `FIFO_Startup:
            if(MRST_DONE)
               POR_ST <= `Pow_on_Rst;
            else
               POR_ST <= `FIFO_Startup;
         `Pow_on_Rst:
            if(!DCM_RDY)
               POR_ST <= `W4Uclk;
            else if(POR_DONE)
               POR_ST <= `Run_State;
            else
               POR_ST <= `Pow_on_Rst;
         `W4Uclk:
            if(DCM_RDY)
               POR_ST <= `Pow_on_Rst;
            else
               POR_ST <= `W4Uclk;
         `Run_State:
            if(!DCM_RDY)
               POR_ST <= `W4Uclk;
            else
               POR_ST <= `Run_State;
         default:
            POR_ST <= `W4Clks;
      endcase
end

always @(posedge BRAWCLK)
begin:  POW_on_Reset_Timer
   if(POR_CNT)
      if(POR_DONE)
         POR_TIMER <= POR_TIMER;
      else
         POR_TIMER <= POR_TIMER + 1;
   else
      POR_TIMER <= 4'h0;
end



//////////////////////////////////////////////////////////////
//                                                          //
// State Machine for Power Up Configuration                 //
//                                                          //
//////////////////////////////////////////////////////////////

always @ (posedge CLK or posedge POW_ON_RST)
begin: PU_Config_FSM
   if (POW_ON_RST)
      PUC_ST <= `PUC;
   else
      case (PUC_ST)
         `PUC:
            PUC_ST <= `Get_Dflt_Cnfg;
         `Get_Dflt_Cnfg:
            if (PH2_DONE && VALID_CNUM)
               PUC_ST <= `HndShk1;
            else if (PH2_DONE && !VALID_CNUM)
               PUC_ST <= `Hrdw_Ini;
            else
               PUC_ST <= `Get_Dflt_Cnfg;
         `Hrdw_Ini:
            if (HRDW_INI_DONE)
               PUC_ST <= `PU_Cnfg_Done;
            else
               PUC_ST <= `Hrdw_Ini;
         `HndShk1:
            if (!PH2_DONE)
               PUC_ST <= `Rstr_MACs;
            else
               PUC_ST <= `HndShk1;
         `Rstr_MACs:
            if (PH2_DONE)
               PUC_ST <= `HndShk2;
            else
               PUC_ST <= `Rstr_MACs;
         `HndShk2:
            if (!PH2_DONE)
               PUC_ST <= `Rstr_Cnfg;
            else
               PUC_ST <= `HndShk2;
         `Rstr_Cnfg:
            if (PH2_DONE)
               PUC_ST <= `HndShk3;
            else
               PUC_ST <= `Rstr_Cnfg;
         `HndShk3:
            if (!PH2_DONE)
               PUC_ST <= `PU_Cnfg_Done;
            else
               PUC_ST <= `HndShk3;
         `PU_Cnfg_Done:
            PUC_ST <= `PU_Cnfg_Done;
         default:
            PUC_ST<= `PUC;
      endcase
end


//////////////////////////////////////////////////////////////
//                                                          //
// State Machine for Ethernet Startup                       //
//                                                          //
//////////////////////////////////////////////////////////////

always @ (posedge CLK or posedge POW_ON_RST)
begin: Eth_Startup_FSM
   if (POW_ON_RST)
      ETH_STUP_ST <= `Wait_for_Fiber;
   else if (!FIBER_SIG_DET)
      ETH_STUP_ST <= `Wait_for_Fiber;
   else
      case (ETH_STUP_ST)
         `Wait_for_Fiber:
            if (FIBER_SIG_DET)
               ETH_STUP_ST <= `Start_RIO_TX;
            else
               ETH_STUP_ST <= `Wait_for_Fiber;
         `Start_RIO_TX:
            if (PU_CNFG_DONE)
               ETH_STUP_ST <= `Start_TX;
            else
               ETH_STUP_ST <= `Start_RIO_TX;
         `Start_TX:
               ETH_STUP_ST <= `Start_RIO_RX;
         `Start_RIO_RX:
            if (SYNC)
               ETH_STUP_ST <= `Wait_Time_1;
            else
               ETH_STUP_ST <= `Start_RIO_RX;
         `Wait_Time_1:
            if (!SYNC)
               ETH_STUP_ST <= `Start_RIO_RX;
            else if (SYNC && WTIME && VME_READY)
               ETH_STUP_ST <= `W4OpLink;
            else
               ETH_STUP_ST <= `Wait_Time_1;
         `W4OpLink:
            if (OPL_GO)
               if (ENA_STRT_PKT)
                  ETH_STUP_ST <= `Snd_Start_Pkt;
               else
                  ETH_STUP_ST <= `Running;
            else
               ETH_STUP_ST <= `W4OpLink;
         `Snd_Start_Pkt:
            if (START_PKT_SENT)
               ETH_STUP_ST <= `Running;
            else
               ETH_STUP_ST <= `Snd_Start_Pkt;
         `Running:
            if (!SYNC)
               ETH_STUP_ST <= `Wait_for_Sync;
            else
               ETH_STUP_ST <= `Running;
         `Wait_for_Sync:
            if (SYNC)
               ETH_STUP_ST <= `Wait_Time_2;
            else
               ETH_STUP_ST <= `Wait_for_Sync;
         `Wait_Time_2:
            if (!SYNC)
               ETH_STUP_ST <= `Wait_for_Sync;
            else if (SYNC && WTIME)
               ETH_STUP_ST <= `Running;
            else
               ETH_STUP_ST <= `Wait_Time_2;
         default:
            ETH_STUP_ST<= `Wait_for_Fiber;
      endcase
end

always @ (posedge CLK or posedge POW_ON_RST)
begin
   if (POW_ON_RST)
      OPL_CNT <= 16'h0000;
   else
      if(OPL_ENA)
         OPL_CNT <= OPL_CNT + 1;
      else
         OPL_CNT <= OPL_CNT;
end
always @ (posedge CLK)
begin
   if (SYNC_CNT_RST)
      SYNC_CNT <= 4'h0;
   else
      if(!WTIME)
         SYNC_CNT <= SYNC_CNT + 1;
      else
         SYNC_CNT <= SYNC_CNT;
end

///////////////////////////////////////////////////////
//                                                   //
//  Shutdown State Machine                           //
//                                                   //
///////////////////////////////////////////////////////

always @ (posedge CLK or posedge POW_ON_RST)
begin: Shutdown_FSM
   if (POW_ON_RST)
      SHTDWN_ST <= `SD_Wait4Shtdwn;
   else
      case (SHTDWN_ST)
         `SD_Wait4Shtdwn:
            if(PREP4SHTDWN)
               if(WARN_ON_SHTDWN)
                  SHTDWN_ST <= `SD_Send_Warn;
               else
                  SHTDWN_ST <= `SD_Wait4Ready;
            else
               SHTDWN_ST <= `SD_Wait4Shtdwn;
         `SD_Send_Warn:
            if(WARN_PKT_SENT)
               SHTDWN_ST <= `SD_Wait4Ready;
            else
               SHTDWN_ST <= `SD_Send_Warn;
         `SD_Wait4Ready:         
            if(ALL_READY || SHTDWN_TMO)
               SHTDWN_ST <= `SD_Rdy4Shtdwn;
            else
               SHTDWN_ST <= `SD_Wait4Ready;
         `SD_Rdy4Shtdwn:
            SHTDWN_ST <= `SD_Rdy4Shtdwn;
         default:
            SHTDWN_ST <= `SD_Wait4Shtdwn;
      endcase
end


always @(posedge CLK or posedge POW_ON_RST)
begin
   if(POW_ON_RST)
      SHTDWN_CNT <= 24'h000000;
   else
      if(PREP4SHTDWN && !SHTDWN_TMO)
         SHTDWN_CNT <= SHTDWN_CNT + 1;
      else
         SHTDWN_CNT <= SHTDWN_CNT;
end

always @ (posedge CLK)
begin
   ALL_READY  <= !TX_INPRGS && ETH_RDY4SHTDWN && CNFG_RDY4SHTDWN && FLASH_RDY4SHTDWN && JTAG_RDY4SHTDWN && EXFF_RDY4SHTDWN && VME_RDY4SHTDWN;
   NMD        <= RTXP_NO_MAC;
   NOMAC_DONE <= NMD;
   NOHDR_DONE <= RTXP_NO_HDR;
   FLSHD      <= RTXP_FLUSH;
end


///////////////////////////////////////////////////////
//                                                   //
//  Reduced Transmit Packet State Machine            //
//                                                   //
///////////////////////////////////////////////////////

always @ (posedge CLK or posedge POW_ON_RST)
begin: rTxP_FSM
   if (POW_ON_RST)
      RTXP_ST <= `rTxP_Idle;
   else
      case (RTXP_ST)
         `rTxP_Idle:
            if(START)
               RTXP_ST <= `rTxP_BR;
            else
               RTXP_ST <= `rTxP_Idle;
         `rTxP_BR:
            if(BG)
               RTXP_ST <= `rTxP_No_MAC;
            else
               RTXP_ST <= `rTxP_BR;
         `rTxP_No_MAC:
            if(NOMAC_DONE)
               RTXP_ST <= `rTxP_No_Hdr;
            else
               RTXP_ST <= `rTxP_No_MAC;
         `rTxP_No_Hdr:
            if(NOHDR_DONE)
               RTXP_ST <= `rTxP_Data;
            else
               RTXP_ST <= `rTxP_No_Hdr;
         `rTxP_Data:
            RTXP_ST <= `rTxP_Stat;
         `rTxP_Stat:
            RTXP_ST <= `rTxP_Send;
         `rTxP_Send:
            RTXP_ST <= `rTxP_Flush;
         `rTxP_Flush:
            if(FLSHD)
               RTXP_ST <= `rTxP_Rel_Bus;
            else
               RTXP_ST <= `rTxP_Flush;
         `rTxP_Rel_Bus:
            if(!BG)
               RTXP_ST <= `rTxP_Done;
            else
               RTXP_ST <= `rTxP_Rel_Bus;
         `rTxP_Done:
            if(!START)
               RTXP_ST <= `rTxP_Idle;
            else
               RTXP_ST <= `rTxP_Done;
         default:
            RTXP_ST <= `rTxP_Idle;
      endcase
end


always @(RTXP_STAT or RTXP_DATA or SEND_STRT_PKT or SEND_WARN_PKT)
begin
   if(RTXP_STAT)
      if(SEND_STRT_PKT)
         DATA_MUX <= {4'h0,`No_Ack,`Rtn_Info_Pkt};
      else if(SEND_WARN_PKT)
         DATA_MUX <= {4'h0,`No_Ack,`Rtn_Warn_Pkt};
      else
         DATA_MUX <= 16'h0000;
   else if (RTXP_DATA)
      if(SEND_STRT_PKT)
         DATA_MUX <= {`Strtup_Shtdwn,`HDR_Info,`SS_Sys_Up};
      else if(SEND_WARN_PKT)
         DATA_MUX <= {`Strtup_Shtdwn,`HDR_Warn,`SS_Rld_Pndg};
      else
         DATA_MUX <= 16'h0000;
   else
      DATA_MUX <= 16'h0000;
end

always @(RTXP_NO_MAC or RTXP_NO_HDR or RTXP_DATA or RTXP_STAT or RTXP_SEND)
begin
   if(RTXP_NO_MAC)
      INSTR_MUX <= `Tx_NoMAC;
   else if(RTXP_NO_HDR)
      INSTR_MUX <= `Tx_NoHead;
   else if (RTXP_DATA)
      INSTR_MUX <= `Tx_Data;
   else if(RTXP_STAT)
      INSTR_MUX <= `Tx_AST;
   else if (RTXP_SEND)
      INSTR_MUX <= `Tx_Send;
   else
      INSTR_MUX <= `Tx_NoData;
end

always @(posedge CLK)
begin
   if(BG)
      begin
         TXDATA  <= DATA_MUX;
         TXCTRL  <= {`Tx_Spont_Cat,INSTR_MUX};
      end
   else
      begin
         TXDATA  <= 16'hZZZZ;
         TXCTRL  <= 5'hZZ;
      end
end

endmodule
