`timescale 1ns / 1ps

module test_ports(SYSCLK, USRCLK,
                  IN_A, IN_B, IN_C, 
                  CK_TPA, CK_TPB, CK_TPC, 
                  TEST_PORT_A, TEST_PORT_B, TEST_PORT_C);

    input SYSCLK;
    input USRCLK;
    input [15:0] IN_A;
    input [15:0] IN_B;
    input [15:0] IN_C;
   output CK_TPA;
   output CK_TPB;
   output CK_TPC;
   output [15:0] TEST_PORT_A;
   output [15:0] TEST_PORT_B;
   output [15:0] TEST_PORT_C;
   
wire CK_TPA;
wire CK_TPB;
wire CK_TPC;
 reg [15:0] TEST_PORT_A;
 reg [15:0] TEST_PORT_B;
 reg [15:0] TEST_PORT_C;


// Instansiate the external clock drivers as double data rate output flip flops.

OFDDRRSE Ext_TPA_clk (.Q(CK_TPA),.C0(USRCLK),.C1(!USRCLK),.CE(1'b1),.D0(1'b0),.D1(1'b1),.R(1'b0),.S(1'b0));
OFDDRRSE Ext_TPB_clk (.Q(CK_TPB),.C0(USRCLK),.C1(!USRCLK),.CE(1'b1),.D0(1'b0),.D1(1'b1),.R(1'b0),.S(1'b0));
OFDDRRSE Ext_TPC_clk (.Q(CK_TPC),.C0(SYSCLK),.C1(!SYSCLK),.CE(1'b1),.D0(1'b0),.D1(1'b1),.R(1'b0),.S(1'b0));
   

always @(posedge SYSCLK)
begin
      TEST_PORT_A <= IN_A;
      TEST_PORT_B <= IN_B;
      TEST_PORT_C <= IN_C;
end

endmodule
