`timescale 1ns / 1ps

module test_sig_mux(ARB_TA, ARB_TB, ARB_TC, 
                    CTRL_TA, CTRL_TB, CTRL_TC,
                    IH_REQ_TA, IH_REQ_TB, IH_REQ_TC, 
                    IH_TA, IH_TB, IH_TC, 
                    MSTR_REQ_TA, MSTR_REQ_TB, MSTR_REQ_TC, 
                    MSTR_TA, MSTR_TB, MSTR_TC, 
                    SW2,
                    A, B, C);

    input [15:0] ARB_TA;
    input [15:0] ARB_TB;
    input [15:0] ARB_TC;
    input [15:0] CTRL_TA;
    input [15:0] CTRL_TB;
    input [15:0] CTRL_TC;
    input [15:0] IH_REQ_TA;
    input [15:0] IH_REQ_TB;
    input [15:0] IH_REQ_TC;
    input [15:0] IH_TA;
    input [15:0] IH_TB;
    input [15:0] IH_TC;
    input [15:0] MSTR_REQ_TA;
    input [15:0] MSTR_REQ_TB;
    input [15:0] MSTR_REQ_TC;
    input [15:0] MSTR_TA;
    input [15:0] MSTR_TB;
    input [15:0] MSTR_TC;
    input [3:0] SW2;
   output [15:0] A;
   output [15:0] B;
   output [15:0] C;

reg [15:0] A;
reg [15:0] B;
reg [15:0] C;

always @(SW2 or ARB_TA or ARB_TB or ARB_TC or 
                    CTRL_TA or CTRL_TB or CTRL_TC or
                    IH_REQ_TA or IH_REQ_TB or IH_REQ_TC or 
                    IH_TA or IH_TB or IH_TC or 
                    MSTR_REQ_TA or MSTR_REQ_TB or MSTR_REQ_TC or 
                    MSTR_TA or MSTR_TB or MSTR_TC )
begin
   case (SW2)
      4'h0, 4'h2, 4'h3:
         begin
            A <= CTRL_TA;
            B <= CTRL_TB;
            C <= {MSTR_TC[15:8],CTRL_TC[7:0]};
         end
      4'h1:
         begin
            A <= CTRL_TA;
            B <= CTRL_TB;
            C <= MSTR_TC;
         end
      4'h4:
         begin
            A <= IH_TA;
            B <= IH_TB;
            C <= IH_TC;
         end
      4'h5:
         begin
            A <= MSTR_REQ_TA;
            B <= ARB_TB;
            C <= {MSTR_TC[15:8],ARB_TC[7:0]};
         end
      4'h6:
         begin
            A <= 16'h0000;
            B <= {2'b00,MSTR_REQ_TB[13:0]};
            C <= MSTR_TC;
         end
      4'h7:
         begin
            A <= IH_REQ_TA;
            B <= ARB_TB;
            C <= {MSTR_TC[15:8],ARB_TC[7:0]};
         end
      4'h8:
         begin
            A <= 16'h0000;
            B <= {2'b00,IH_REQ_TB[13:0]};
            C <= {MSTR_TC[15:8],3'b000,MSTR_TC[4:0]};
         end
      4'h9:
         begin
            A <= MSTR_TA;
            B <= MSTR_TB;
            C <= MSTR_TC;
         end
      default:
         begin
            A <= 16'h0000;
            B <= 16'h0000;
            C <= 16'h0000;
         end
   endcase
end
endmodule
