`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"                             
`endif


module traffic_ctrl(CLK, RST,
      ETH_RCV_BR, CNFG_BR, FLASH_BR, JTAG_BR, EX_FIFO_BR,
      VCP_BR, VME_BR, SS_BR,
      
      ETH_RCV_BG, CNFG_BG, FLASH_BG, JTAG_BG, EX_FIFO_BG,
      VCP_BG, VME_BG, SS_BG, TXDATA, TXCTRL);


   input CLK;
   input RST;

   input ETH_RCV_BR;
   input CNFG_BR;
   input FLASH_BR;
   input JTAG_BR;
   input EX_FIFO_BR;
   input VCP_BR;
   input VME_BR;
   input SS_BR;

  output ETH_RCV_BG;
  output CNFG_BG;
  output FLASH_BG;
  output JTAG_BG;
  output EX_FIFO_BG;
  output VCP_BG;
  output VME_BG;
  output SS_BG;
  output [15:0] TXDATA;
  output [4:0] TXCTRL;

wire ETH_RCV_BG;
wire CNFG_BG;
wire FLASH_BG;
wire JTAG_BG;
wire EX_FIFO_BG;
wire VCP_BG;
wire VME_BG;
wire SS_BG;
reg [15:0] TXDATA;
reg [4:0] TXCTRL;


reg [3:0] TRNSB_ST;

wire PL_DWN;

assign PL_DWN     = (TRNSB_ST == `TB_Free);
assign SS_BG      = (TRNSB_ST == `SS_BG);
assign VME_BG     = (TRNSB_ST == `VME_BG);
assign VCP_BG     = (TRNSB_ST == `VCP_BG);
assign ETH_RCV_BG = (TRNSB_ST == `ETH_RCV_BG);
assign EX_FIFO_BG = (TRNSB_ST == `EX_FIFO_BG);
assign JTAG_BG    = (TRNSB_ST == `JTAG_BG);
assign CNFG_BG    = (TRNSB_ST == `CNFG_BG);
assign FLASH_BG   = (TRNSB_ST == `FLASH_BG);

///////////////////////////////////////////////
//                                           //
// Transmit bus traffic control              //
//                                           //
///////////////////////////////////////////////



always @(posedge CLK or posedge RST)
begin: Transmit_Buss_Ctrl_FSM
   if(RST)
      TRNSB_ST <= `TB_Free;
   else
      case(TRNSB_ST)
         `TB_Free:
            if(SS_BR)
               TRNSB_ST  <= `SS_BG;
            else if(VME_BR)
               TRNSB_ST  <= `VME_BG;
            else if(VCP_BR)
               TRNSB_ST  <= `VCP_BG;
            else if(ETH_RCV_BR)
               TRNSB_ST  <= `ETH_RCV_BG;
            else if(EX_FIFO_BR)
               TRNSB_ST  <= `EX_FIFO_BG;
            else if(JTAG_BR)
               TRNSB_ST  <= `JTAG_BG;
            else if(CNFG_BR)
               TRNSB_ST  <= `CNFG_BG;
            else if(FLASH_BR)
               TRNSB_ST  <= `FLASH_BG;
            else
               TRNSB_ST  <= `TB_Free;
         `SS_BG:
            if(!SS_BR)
               TRNSB_ST  <= `TB_Free;
            else
               TRNSB_ST  <= `SS_BG;
         `VME_BG:
            if(!VME_BR)
               TRNSB_ST  <= `TB_Free;
            else
               TRNSB_ST  <= `VME_BG;
         `VCP_BG:
            if(!VCP_BR)
               TRNSB_ST  <= `TB_Free;
            else
               TRNSB_ST  <= `VCP_BG;
         `ETH_RCV_BG:
            if(!ETH_RCV_BR)
               TRNSB_ST  <= `TB_Free;
            else
               TRNSB_ST  <= `ETH_RCV_BG;
         `EX_FIFO_BG:
            if(!EX_FIFO_BR)
               TRNSB_ST  <= `TB_Free;
            else
               TRNSB_ST  <= `EX_FIFO_BG;
         `JTAG_BG:
            if(!JTAG_BR)
               TRNSB_ST  <= `TB_Free;
            else
               TRNSB_ST  <= `JTAG_BG;
         `CNFG_BG:
            if(!CNFG_BR)
               TRNSB_ST  <= `TB_Free;
            else
               TRNSB_ST  <= `CNFG_BG;
         `FLASH_BG:
            if(!FLASH_BR)
               TRNSB_ST  <= `TB_Free;
            else
               TRNSB_ST  <= `FLASH_BG;
         default:
               TRNSB_ST  <= `TB_Free;
      endcase
end
always @(posedge CLK)
begin
   if(PL_DWN)
      begin
         TXDATA  <= 16'h0000;
         TXCTRL  <= 5'h00;
      end
   else
      begin
         TXDATA  <= 16'hZZZZ;
         TXCTRL  <= 5'hZZ;
      end
end


endmodule
