`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"                             
`endif

module tx_decoder(CLK,NE,PE,SE,CAT,NV,PV,SV,ADDR);

 input CLK;
 input NE;
 input PE;
 input SE;
 input [1:0] CAT;
output NV;
output PV;
output SV;
output [1:0] ADDR;

reg NV,PV,SV;
wire [1:0] ADDR;

reg [1:0] CAT_R;

assign ADDR = ((NE && NV) || (PE && PV) || (SE && SV)) ? 2'bZZ : 2'b00;

always @(posedge CLK)
begin
   CAT_R <= CAT;
end
always @(CAT_R)
begin
   case (CAT_R)
      `Tx_Norm_Cat:
         begin
            NV <= 1;
            PV <= 0;
            SV <= 0;
         end
      `Tx_Prio_Cat:
         begin
            NV <= 0;
            PV <= 1;
            SV <= 0;
         end
      `Tx_Spont_Cat:
         begin
            NV <= 0;
            PV <= 0;
            SV <= 1;
         end
      default:
         begin
            NV <= 0;
            PV <= 0;
            SV <= 0;
         end
   endcase
end
endmodule
