`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"
`endif

// synthesis attribute ram_style of tx_mac_frame is distributed
// synthesis attribute rom_style of tx_mac_frame is distributed

module tx_mac_frame(CLK, TXRESET, TX_ERR, PROT_ENA, XTEND,
      NORM_MHBITS, NORM_DATAIN, NORM_LEN, NORM_TYPE_STAT, NORM_MAC_HDR, NORM_FRAG_NUM, NORM_NEW, NORM_FRAG, NORM_RDY, NORM_MH_MT,
      PRIO_MHBITS, PRIO_DATAIN, PRIO_LEN, PRIO_TYPE_STAT, PRIO_MAC_HDR, PRIO_FRAG_NUM, PRIO_NEW, PRIO_FRAG, PRIO_RDY, PRIO_MH_MT,
      SPONT_MHBITS, SPONT_DATAIN, SPONT_LEN, SPONT_TYPE_STAT, SPONT_MAC_HDR, SPONT_FRAG_NUM, SPONT_NEW, SPONT_FRAG, SPONT_RDY, SPONT_MH_MT,
      TX_MAC, SW2,
      TX_ADDR, NORM_POP, PRIO_POP, SPONT_POP, NORM_POPMH, PRIO_POPMH, SPONT_POPMH,
      TXCHARISK, TXDATA, UPD_STATS, TX_ERR_RST, TX_PROC_N, TX_PROC_P, TX_PROC_S, TX_MAC_DEST_ERR,
      TEST_A, TEST_B, PRIO, SPONT);

    input CLK;
    input TXRESET;
    input TX_ERR;
    input PROT_ENA;
    input XTEND;
    input [1:0] NORM_MHBITS;
    input [15:0] NORM_DATAIN;
    input [12:0] NORM_LEN;
    input [11:0] NORM_TYPE_STAT;
    input [15:0] NORM_MAC_HDR;
    input [31:0] NORM_FRAG_NUM;
    input NORM_NEW;
    input NORM_FRAG;
    input NORM_RDY;
    input NORM_MH_MT;
    input [1:0] PRIO_MHBITS;
    input [15:0] PRIO_DATAIN;
    input [12:0] PRIO_LEN;
    input [11:0] PRIO_TYPE_STAT;
    input [15:0] PRIO_MAC_HDR;
    input [31:0] PRIO_FRAG_NUM;
    input PRIO_NEW;
    input PRIO_FRAG;
    input PRIO_RDY;
    input PRIO_MH_MT;
    input [1:0] SPONT_MHBITS;
    input [15:0] SPONT_DATAIN;
    input [12:0] SPONT_LEN;
    input [11:0] SPONT_TYPE_STAT;
    input [15:0] SPONT_MAC_HDR;
    input [31:0] SPONT_FRAG_NUM;
    input SPONT_NEW;
    input SPONT_FRAG;
    input SPONT_RDY;
    input SPONT_MH_MT;
    input [15:0] TX_MAC;
    input [3:0] SW2;
   output [1:0] TX_ADDR;
   output NORM_POP;
   output PRIO_POP;
   output SPONT_POP;
   output NORM_POPMH;
   output PRIO_POPMH;
   output SPONT_POPMH;
   output [1:0] TXCHARISK;
   output [15:0] TXDATA;
   output UPD_STATS;
   output TX_ERR_RST;
   output TX_PROC_N;
   output TX_PROC_P;
   output TX_PROC_S;
   output TX_MAC_DEST_ERR;
   output [15:0] TEST_A;
   output [15:0] TEST_B;
   output PRIO;
   output SPONT;
   
reg  [15:0] TEST_A;
reg  [15:0] TEST_B;

reg NORM_POP;
reg PRIO_POP;
reg SPONT_POP;
wire NORM_POPMH;
wire PRIO_POPMH;
wire SPONT_POPMH;
reg [1:0] TX_ADDR;

reg [2:0] TX_CON_ST;
reg [3:0] FR_BD_ST;
reg [3:0] ROM_ST;
reg [2:0] MAC_ST;
reg [2:0] HDR_ST;
reg [2:0] ROM_ADDR;
reg [15:0] CNST,CNST1,CNST2;
reg [1:0] KCNST,KCNST1,KCNST2;
reg [2:0] FR_SEL,FR_SEL1,FR_SEL2,FR_SEL3;
reg SOF;
reg W2_WRDS;
reg PAY_INC;
reg PAY_RST;
reg PAY_ENA;
reg SPC_INC;
reg SPC_RST;
reg XMIT;
reg MACD_DONE;
reg MACS_DONE;
reg PROT_DONE;
reg XLIMIT;
reg TRY_INC;
reg TRY_RST;
reg TX_ERR_RST;
reg UPD_STATS;

reg SPONT,PRIO,NORM;
reg SET_SPONT,SET_PRIO,SET_NORM;
reg RST_SPONT,RST_PRIO,RST_NORM;
reg POPMH;
reg LD_LEN;
reg [1:0] HDR_SEL;
reg HDR_LD;
reg HDR_RD;
reg SRC_MAC_RD;
reg DEST_MAC_RD;
reg [15:0] MAC_SRC1,MAC_SRC2;
reg [15:0] MAC_DEST1,MAC_DEST2,MAC_DEST3;
reg [15:0] HEADR1,HEADR2,HEADR3;
reg [13:0] PKT_LEN1,PKT_LEN2;
reg [15:0] HDR_MUX;
reg SLOT_RST;
reg SLOT_INC;
reg RST_TXA1,RST_TXA2;
reg MHV1, MHV2;
reg MH_VALID;
reg MHDONE;
reg HDR_SV_R1;

wire [13:0] PKT_LEN;
wire [13:0] PKT_BYTE_CNT;
wire [17:0] FR_MUX;
wire [15:0] DATA1;
wire [12:0] GEN_LEN;
wire [12:0] DATA_LEN;
wire [11:0] GEN_TYPE_STAT;
wire [31:0] GEN_FRAG_NUM;
wire [15:0] NP_HDR1,NP_HDR2;
wire GEN_FRAG;
wire GEN_NEW;
wire [15:0] HEADR;
wire [15:0] MAC_DEST_SAV;
wire [15:0] MAC_DEST_SHFT;
wire LD_PKT_LEN;
wire HDRSDONE;
wire MBIT;
wire HBIT;
wire MAC_SV;
wire HDR_SV;
wire LD_NPK1,LD_NPK2;
wire MH_ERROR;

wire LAST_DATA;
wire FILL_DONE;
wire TX_DONE;
wire [12:0] D_CNT;
wire [3:0] SPC_CNT;
wire [1:0] TRY;
wire TRST;
wire SLOTRST;
wire [7:0] SLOT_CNT;
wire TXA_RST;
wire TX_MAC_DEST_ERR;
wire NO_DATA;

assign NO_DATA         = (FR_BD_ST == `Proto_Encoder) && ((SPONT && (SPONT_LEN == 13'h0000)) || (PRIO && (PRIO_LEN == 13'h0000)) || (NORM && (NORM_LEN == 13'h0000)));
assign TX_PROC_N       = (TX_CON_ST != `Wait_4_TX_Ready) && NORM;
assign TX_PROC_P       = (TX_CON_ST != `Wait_4_TX_Ready) && PRIO;
assign TX_PROC_S       = (TX_CON_ST != `Wait_4_TX_Ready) && SPONT;
assign TX_MAC_DEST_ERR = (SPONT_POPMH && SPONT_MH_MT) || (PRIO_POPMH && PRIO_MH_MT) || (NORM_POPMH && NORM_MH_MT); 
assign TXA_RST         = TXRESET || RST_TXA1 || RST_TXA2;
assign PKT_BYTE_CNT    = (PROT_ENA) ? 2*(DATA_LEN + `Header_Size) : 2*(DATA_LEN);
assign LAST_DATA       = PAY_ENA && ((SPONT && (SPONT_LEN == 13'd1)) || (PRIO && (PRIO_LEN == 13'd1)) || (NORM && (NORM_LEN == 13'd1)));
assign MAC_SV          = MH_VALID && MBIT;
assign HDR_SV          = MH_VALID && HBIT;
assign LD_NPK1         = HDR_SV && !HDR_SV_R1;
assign LD_NPK2         = HDR_SV && HDR_SV_R1;
assign MH_ERROR        = MH_VALID && MBIT && HBIT;
assign NORM_POPMH      = NORM && POPMH;
assign PRIO_POPMH      = PRIO && POPMH;
assign SPONT_POPMH     = SPONT && POPMH;
assign LD_PKT_LEN      = HDR_LD && (HDR_SEL == 2'd0);
assign HDRSDONE        = (HDR_SEL == 2'd3);


// Test point signals /////////////////////////////////////////////////////////////////////////////
always @(posedge CLK)
begin
   case (SW2)
      4'hF:
         begin
            TEST_A[2:0] <= TX_CON_ST;
            TEST_A[6:3] <= FR_BD_ST;
            TEST_A[9:7] <= MAC_ST;
            TEST_A[12:10] <= HDR_ST;
            TEST_A[13] <= SPONT;
            TEST_A[14] <= PRIO;
            TEST_A[15] <= NORM;
            TEST_B[0] <= SET_SPONT;
            TEST_B[1] <= RST_SPONT;
            TEST_B[2] <= SET_PRIO;
            TEST_B[3] <= RST_PRIO;
            TEST_B[4] <= SET_NORM;
            TEST_B[5] <= RST_NORM;
            TEST_B[6] <= POPMH;
            TEST_B[7] <= SPONT_POP;
            TEST_B[8] <= PRIO_POP;
            TEST_B[9] <= NORM_POP;
            TEST_B[11:10] <= TRY;
            TEST_B[12] <= TRY_INC;
            TEST_B[13] <= TRY_RST;
            TEST_B[14] <= XMIT;
            TEST_B[15] <= 1'b0;
         end
      default: 
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
         end
   endcase
end



//////////////////////////////////////////////////////////////
//                                                          //
// DATA input registers                                     //
//                                                          //
//////////////////////////////////////////////////////////////

defparam     data1_reg.width = 16;
defparam      type_mux.width = 12;
defparam       len_mux.width = 13;
defparam data_len_hold.width = 13;
defparam  pkt_len_hold.width = 14;
defparam      frag_mux.width = 34;


mux3to1_reg data1_reg (.clk(CLK),.sela(SPONT),.selb(PRIO),.selc(NORM),.ain(SPONT_DATAIN),.bin(PRIO_DATAIN),.cin(NORM_DATAIN),.out(DATA1));
mux3to1     type_mux (.sela(SPONT),.selb(PRIO),.selc(NORM),.ain(SPONT_TYPE_STAT),.bin(PRIO_TYPE_STAT),.cin(NORM_TYPE_STAT),.out(GEN_TYPE_STAT));
mux3to1     len_mux (.sela(SPONT),.selb(PRIO),.selc(NORM),.ain(SPONT_LEN),.bin(PRIO_LEN),.cin(NORM_LEN),.out(GEN_LEN));
reg_ce  data_len_hold (.clk(CLK),.ce(LD_LEN),.r(TXRESET),.din(GEN_LEN),.dout(DATA_LEN));
reg_ce  pkt_len_hold (.clk(CLK),.ce(LD_PKT_LEN),.r(TXRESET),.din(PKT_BYTE_CNT),.dout(PKT_LEN));
mux3to1     frag_mux (.sela(SPONT),.selb(PRIO),.selc(NORM),.ain({SPONT_NEW,SPONT_FRAG,SPONT_FRAG_NUM}),.bin({PRIO_NEW,PRIO_FRAG,PRIO_FRAG_NUM}),.cin({NORM_NEW,NORM_FRAG,NORM_FRAG_NUM}),.out({GEN_NEW,GEN_FRAG,GEN_FRAG_NUM}));

defparam     try_cntr.width = 2;
assign TRST = TXRESET || TRY_RST;
cnt_up try_cntr(.clk(CLK),.inc(TRY_INC),.r(TRST),.count(TRY));
defparam     slot_cntr.width = 8;
assign SLOTRST = TXRESET || SLOT_RST;
cnt_up slot_cntr(.clk(CLK),.inc(SLOT_INC),.r(SLOTRST),.count(SLOT_CNT));

always @(posedge CLK)
begin
   if(SLOTRST)
      XLIMIT <= 1'b0;
   else
      if (SLOT_CNT >= `Min_Time_Slot)
         XLIMIT <= 1'b1;
      else
         XLIMIT <= XLIMIT;
end

defparam      mac_mux.width = 18;
defparam mac_shft_reg.width = 16;
defparam         NPK1.width = 16;
defparam         NPK2.width = 16;

mux3to1   mac_mux (.sela(SPONT),.selb(PRIO),.selc(NORM),
                   .ain({SPONT_MHBITS,SPONT_MAC_HDR}),
                   .bin({PRIO_MHBITS,PRIO_MAC_HDR}),
                   .cin({NORM_MHBITS,NORM_MAC_HDR}),
                   .out({MBIT,HBIT,MAC_DEST_SAV}));
shft_3_reg  mac_shft_reg (.c(CLK),.s(DEST_MAC_RD),.l(MAC_SV),.d(MAC_DEST_SAV),.q(MAC_DEST_SHFT));

reg_ce  NPK1(.clk(CLK),.ce(LD_NPK1),.r(TXRESET),.din(MAC_DEST_SAV),.dout(NP_HDR1));
reg_ce  NPK2(.clk(CLK),.ce(LD_NPK2),.r(TXRESET),.din(MAC_DEST_SAV),.dout(NP_HDR2));

always @ (HDR_SEL or PRIO or GEN_NEW or GEN_FRAG or SPONT or GEN_TYPE_STAT or GEN_FRAG_NUM or NP_HDR1 or NP_HDR2 or DATA_LEN)
begin: Header_Mux
   casex ({GEN_NEW,HDR_SEL})
      3'bx00:
         HDR_MUX <= {PRIO,GEN_NEW,GEN_FRAG,SPONT,GEN_TYPE_STAT};
      3'b001:
         HDR_MUX <= GEN_FRAG_NUM[31:16];
      3'b101:
         HDR_MUX <= NP_HDR1;
      3'b010:
         HDR_MUX <= GEN_FRAG_NUM[15:0];
      3'b110:
         HDR_MUX <= NP_HDR2;
      3'bx11:
         HDR_MUX <= {3'b000,DATA_LEN};
      default:
         HDR_MUX <= {PRIO,GEN_NEW,GEN_FRAG,SPONT,GEN_TYPE_STAT};
   endcase
end

defparam hdr_shft_reg.width = 16;

shft_4_reg  hdr_shft_reg (.c(CLK),.s(HDR_RD),.l(HDR_LD),.d(HDR_MUX),.q(HEADR));


//////////////////////////////////////////////////////////////
//                                                          //
// Pipeline Registers for Data Alignment                    //
//                                                          //
//////////////////////////////////////////////////////////////

always @ (posedge CLK)
begin
   FR_SEL1 <= FR_SEL;
   FR_SEL2 <= FR_SEL1;
   FR_SEL3 <= FR_SEL2;
   CNST1 <= CNST;
   CNST2 <= CNST1;
   KCNST1 <= KCNST;
   KCNST2 <= KCNST1;
   HEADR1 <= HEADR;
   HEADR2 <= HEADR1;
   HEADR3 <= HEADR2;
   MAC_DEST1 <= MAC_DEST_SHFT;
   MAC_DEST2 <= MAC_DEST1;
   MAC_DEST3 <= MAC_DEST2;
   MAC_SRC1 <= TX_MAC;
   MAC_SRC2 <= MAC_SRC1;
   PKT_LEN1 <= PKT_LEN;
   PKT_LEN2 <= PKT_LEN1;
end

//////////////////////////////////////////////////////////////
//                                                          //
// Frame Multiplexer 6-to-1                                 //
//                                                          //
//////////////////////////////////////////////////////////////

defparam     frame_mux.width = 18;

mux8to1     frame_mux (.sel(FR_SEL3),.ain({KCNST2,CNST2}),.bin({2'b00,MAC_DEST3}),
                                    .cin({2'b00,MAC_SRC2}),.din({4'b0000,PKT_LEN2}),
                                    .ein({2'b00,HEADR3}),.fin({2'b00,DATA1}),
                                    .gin(18'h00000),.hin(18'h00000),
                                    .out(FR_MUX));

//////////////////////////////////////////////////////////////
//                                                          //
// DATA ouput register                                      //
//                                                          //
//////////////////////////////////////////////////////////////

defparam     out_reg.width = 18;

reg_ce  out_reg (.clk(CLK),.ce(1'b1),.r(1'b0),.din(FR_MUX),.dout({TXCHARISK,TXDATA}));

always @ (posedge CLK)
begin
   HDR_SV_R1 <= HDR_SV;
end


//////////////////////////////////////////////////////////////
//                                                          //
// State Machine for Transmit Control                       //
//                                                          //
//////////////////////////////////////////////////////////////

always @ (posedge CLK or posedge TXRESET)
begin: TX_CONTROL
   if (TXRESET)
      TX_CON_ST <= `Wait_4_TX_Ready;
   else
      case (TX_CON_ST)
         `Wait_4_TX_Ready:
             if (SPONT_RDY || PRIO_RDY || NORM_RDY)
                TX_CON_ST <= `Rst_Addr_Cntr;
             else
                TX_CON_ST <= `Wait_4_TX_Ready;
         `Rst_Addr_Cntr:
             TX_CON_ST <= `Read_MH;
         `Read_MH:
             if (MHDONE)
                TX_CON_ST <= `Read_HDRs;
             else
                TX_CON_ST <= `Read_MH;
         `Read_HDRs:
             if (HDRSDONE)
                TX_CON_ST <= `Transmit_Packet;
             else
                TX_CON_ST <= `Read_HDRs;
         `Transmit_Packet:
             TX_CON_ST <= `Wait_TX_Done;
         `Wait_TX_Done:
             if (TX_DONE)
                TX_CON_ST <= `Upd_TX_Stats;
             else
                TX_CON_ST <= `Wait_TX_Done;
         `Upd_TX_Stats:
             if (TX_ERR && (TRY < `Attempts))
                TX_CON_ST <= `Transmit_Packet;
             else
                TX_CON_ST <= `Wait_4_TX_Ready;
         default:
             TX_CON_ST <= `Wait_4_TX_Ready;
      endcase
end
always @ (posedge CLK)
begin
   if(SET_SPONT)
      SPONT <= 1;
   else if (RST_SPONT)
      SPONT <= 0;
   else
      SPONT <= SPONT;
end
always @ (posedge CLK)
begin
   if(SET_PRIO)
      PRIO <= 1;
   else if (RST_PRIO)
      PRIO <= 0;
   else
      PRIO <= PRIO;
end
always @ (posedge CLK)
begin
   if(SET_NORM)
      NORM <= 1;
   else if (RST_NORM)
      NORM <= 0;
   else
      NORM <= NORM;
end

always @ (TX_CON_ST or SPONT_RDY or PRIO_RDY or NORM_RDY)
begin: TX_CONTROL_OUTPUTS_0
   case (TX_CON_ST)
      `Wait_4_TX_Ready:
         casex({SPONT_RDY,PRIO_RDY,NORM_RDY})
            3'b1xx:
               begin
                  SET_SPONT <= 1;
                  SET_PRIO <= 0;
                  SET_NORM <= 0;
                  RST_SPONT <= 0;
                  RST_PRIO <= 1;
                  RST_NORM <= 1;
               end
            3'b01x:
               begin
                  SET_SPONT <= 0;
                  SET_PRIO <= 1;
                  SET_NORM <= 0;
                  RST_SPONT <= 1;
                  RST_PRIO <= 0;
                  RST_NORM <= 1;
               end
            3'b001:
               begin
                  SET_SPONT <= 0;
                  SET_PRIO <= 0;
                  SET_NORM <= 1;
                  RST_SPONT <= 1;
                  RST_PRIO <= 1;
                  RST_NORM <= 0;
               end
            default:
               begin
                  SET_SPONT <= 0;
                  SET_PRIO <= 0;
                  SET_NORM <= 0;
                  RST_SPONT <= 1;
                  RST_PRIO <= 1;
                  RST_NORM <= 1;
               end
         endcase
      default:
         begin
            SET_SPONT <= 0;
            SET_PRIO <= 0;
            SET_NORM <= 0;
            RST_SPONT <= 0;
            RST_PRIO <= 0;
            RST_NORM <= 0;
         end
   endcase
end

always @ (TX_CON_ST )
begin: TX_CONTROL_OUTPUTS_2
   case (TX_CON_ST )
      `Rst_Addr_Cntr:
         begin
            LD_LEN <= 1;
            RST_TXA2 <= 1;
         end
      default:
         begin
            LD_LEN <= 0;
            RST_TXA2 <= 0;
         end
   endcase
end

always @ (TX_CON_ST)
begin: TX_CONTROL_OUTPUTS_3
   case (TX_CON_ST)
      `Read_MH:
         POPMH <= 1;
      default:
         POPMH <= 0;
   endcase
end
always @(posedge CLK)
begin
   MHV1 <= POPMH;
   MH_VALID <= MHV1;
   MHV2 <= MH_VALID;
   MHDONE <= MHV2;
end
always @ (TX_CON_ST or MH_VALID)
begin
   case (TX_CON_ST)
      `Read_HDRs:
         HDR_LD <= !MH_VALID;
      default:
         HDR_LD <= 0;
   endcase
end
always @(posedge CLK or posedge TXRESET)
begin
   if(TXRESET)
      HDR_SEL <= 2'd0;
   else
      if(HDR_LD)
         HDR_SEL <= HDR_SEL + 1;
      else
         HDR_SEL <= HDR_SEL;
end


always @ (TX_CON_ST)
begin: TX_CONTROL_OUTPUTS_4
   case (TX_CON_ST)
      `Wait_4_TX_Ready:
         begin
            XMIT <= 0;
            TX_ERR_RST <= 0;
            UPD_STATS <= 0;
            TRY_INC <= 0;
            TRY_RST <= 1;
            SLOT_RST <= 0;
         end
      `Transmit_Packet:
         begin
            XMIT <= 1;
            TX_ERR_RST <= 1;
            UPD_STATS <= 0;
            TRY_INC <= 1;
            TRY_RST <= 0;
            SLOT_RST <= 1;
         end
      `Wait_TX_Done:
         begin
            XMIT <= 0;
            TX_ERR_RST <= 0;
            UPD_STATS <= 0;
            TRY_INC <= 0;
            TRY_RST <= 0;
            SLOT_RST <= 0;
         end
      `Upd_TX_Stats:
         begin
            XMIT <= 0;
            TX_ERR_RST <= 0;
            UPD_STATS <= 1;
            TRY_INC <= 0;
            TRY_RST <= 0;
            SLOT_RST <= 0;
         end
      default:
         begin
            XMIT <= 0;
            TX_ERR_RST <= 0;
            UPD_STATS <= 0;
            TRY_INC <= 0;
            TRY_RST <= 0;
            SLOT_RST <= 0;
         end
   endcase
end

//////////////////////////////////////////////////////////////
//                                                          //
// State Machine for MAC frame building                     //
//                                                          //
//////////////////////////////////////////////////////////////

always @ (posedge CLK or posedge TXRESET)
begin: TX_MAC_FR_FSM
   if (TXRESET)
      FR_BD_ST <= `Xmit_Idle;
   else
      case (FR_BD_ST)
         `Xmit_Idle:
            if (XMIT)
               FR_BD_ST <= `TX_Preamble;
            else
               FR_BD_ST <= `Xmit_Idle;
         `TX_Preamble:
            if (SOF)
               FR_BD_ST <= `TX_MAC_Dest;
            else
               FR_BD_ST <= `TX_Preamble;
         `TX_MAC_Dest:
            if (MACD_DONE)
               FR_BD_ST <= `TX_MAC_Source;
            else
               FR_BD_ST <= `TX_MAC_Dest;
         `TX_MAC_Source:
            if (MACS_DONE)
               FR_BD_ST <= `Length;
            else
               FR_BD_ST <= `TX_MAC_Source;
         `Length:
            if (PROT_ENA)
               FR_BD_ST <= `Proto_Encoder;
            else
               FR_BD_ST <= `Payload_Data;
         `Proto_Encoder:
            if (PROT_DONE && !NO_DATA)
               FR_BD_ST <= `Payload_Data;
            else if (PROT_DONE && NO_DATA)
               FR_BD_ST <= `Min_Pkt_Fill;
            else
               FR_BD_ST <= `Proto_Encoder;
         `Payload_Data:
            if (LAST_DATA && (D_CNT < `Min_Pkt_Size))
               FR_BD_ST <= `Min_Pkt_Fill;
            else if (LAST_DATA && (D_CNT >= `Min_Pkt_Size))
               FR_BD_ST <= `CRC_Space;
            else
               FR_BD_ST <= `Payload_Data;
         `Min_Pkt_Fill:
            if (FILL_DONE)
               FR_BD_ST <= `CRC_Space;
            else
               FR_BD_ST <= `Min_Pkt_Fill;
         `CRC_Space:
            if (W2_WRDS)
               FR_BD_ST <= `EOP;
            else
               FR_BD_ST <= `CRC_Space;
         `EOP:
            if (XTEND)
               FR_BD_ST <= `Byte_Extnd;
            else
               FR_BD_ST <= `Int_Pkt_Space;
         `Byte_Extnd:
            if (XLIMIT)
               FR_BD_ST <= `Int_Pkt_Space;
            else
               FR_BD_ST <= `Byte_Extnd;
         `Int_Pkt_Space:
            if (TX_DONE)
               FR_BD_ST <= `Xmit_Idle;
            else
               FR_BD_ST <= `Int_Pkt_Space;
            default:
            FR_BD_ST <= `Xmit_Idle;
      endcase
end

always @ (FR_BD_ST)
begin: TX_MAC_FR_OUTPUTS
   case (FR_BD_ST)
      `Xmit_Idle:
         begin
            FR_SEL <= `Sel_Constants;
            PAY_INC <= 0;
            PAY_RST <= 1;
            PAY_ENA <= 0;
            SLOT_INC <= 0;
         end
      `TX_Preamble:
         begin
            FR_SEL <= `Sel_Constants;
            PAY_INC <= 0;
            PAY_RST <= 0;
            PAY_ENA <= 0;
            SLOT_INC <= 0;
         end
      `TX_MAC_Dest:
         begin
            FR_SEL <= `Sel_Destination;
            PAY_INC <= 0;
            PAY_RST <= 0;
            PAY_ENA <= 0;
            SLOT_INC <= 1;
         end
      `TX_MAC_Source:
         begin
            FR_SEL <= `Sel_Source;
            PAY_INC <= 0;
            PAY_RST <= 0;
            PAY_ENA <= 0;
            SLOT_INC <= 1;
         end
      `Length:
         begin
            FR_SEL <= `Sel_Length;
            PAY_INC <= 1;
            PAY_RST <= 0;
            PAY_ENA <= 0;
            SLOT_INC <= 1;
         end
      `Proto_Encoder:
         begin
            FR_SEL <= `Sel_Protocol;
            PAY_INC <= 1;
            PAY_RST <= 0;
            PAY_ENA <= 0;
            SLOT_INC <= 1;
         end
      `Payload_Data:
         begin
            FR_SEL <= `Sel_Data;
            PAY_INC <= 1;
            PAY_RST <= 0;
            PAY_ENA <= 1;
            SLOT_INC <= 1;
         end
      `Min_Pkt_Fill:
         begin
            FR_SEL <= `Sel_Constants;
            PAY_INC <= 1;
            PAY_RST <= 0;
            PAY_ENA <= 0;
            SLOT_INC <= 1;
         end
      `CRC_Space:
         begin
            FR_SEL <= `Sel_Constants;
            PAY_INC <= 0;
            PAY_RST <= 0;
            PAY_ENA <= 0;
            SLOT_INC <= 1;
         end
      `EOP:
         begin
            FR_SEL <= `Sel_Constants;
            PAY_INC <= 0;
            PAY_RST <= 0;
            PAY_ENA <= 0;
            SLOT_INC <= 1;
         end
      `Byte_Extnd:
         begin
            FR_SEL <= `Sel_Constants;
            PAY_INC <= 0;
            PAY_RST <= 0;
            PAY_ENA <= 0;
            SLOT_INC <= 1;
         end
      `Int_Pkt_Space:
         begin
            FR_SEL <= `Sel_Constants;
            PAY_INC <= 0;
            PAY_RST <= 0;
            PAY_ENA <= 0;
            SLOT_INC <= 1;
         end
      default:
         begin
            FR_SEL <= `Sel_Constants;
            PAY_INC <= 0;
            PAY_RST <= 1;
            PAY_ENA <= 0;
            SLOT_INC <= 0;
         end
   endcase
end
always @ (FR_BD_ST)
begin: TX_MAC_FR_OUTPUTS_2
   case (FR_BD_ST)
      `Xmit_Idle:
         begin
            SPC_INC <= 0;
            SPC_RST <= 1;
         end
      `Int_Pkt_Space:
         begin
            SPC_INC <= 1;
            SPC_RST <= 0;
         end
      default:
         begin
            SPC_INC <= 0;
            SPC_RST <= 0;
         end
   endcase
end
always @ (FR_BD_ST or SPONT or SPONT_RDY or PRIO or PRIO_RDY or NORM or NORM_RDY)
begin: TX_MAC_FR_OUTPUTS_3
   case (FR_BD_ST)
      `Payload_Data:
         casex({SPONT,PRIO,NORM})
            3'b1xx:
               begin
                  SPONT_POP <= SPONT_RDY;
                  PRIO_POP <= 0;
                  NORM_POP <= 0;
               end
            3'b01x:
               begin
                  SPONT_POP <= 0;
                  PRIO_POP <= PRIO_RDY;
                  NORM_POP <= 0;
               end
            3'b001:
               begin
                  SPONT_POP <= 0;
                  PRIO_POP <= 0;
                  NORM_POP <= NORM_RDY;
               end
            default:
               begin
                  SPONT_POP <= 0;
                  PRIO_POP <= 0;
                  NORM_POP <= 0;
               end
         endcase
      default:
         begin
            SPONT_POP <= 0;
            PRIO_POP <= 0;
            NORM_POP <= 0;
         end
   endcase
end

//////////////////////////////////////////////////////////////
//                                                          //
// ROM for Idles, Preamble, Data Fill, Carrier Extend,      //
// and inter packet spacing.                                //
//                                                          //
//////////////////////////////////////////////////////////////

always @(posedge CLK)
begin: Frame_ROM
   case(ROM_ADDR)
      3'o0: CNST <= `IDLE2;
      3'o1: CNST <= `PREAMBLE1;
      3'o2: CNST <= `PREAMBLE2;
      3'o3: CNST <= `PREAMBLE3;
      3'o4: CNST <= `PREAMBLE4;
      3'o5: CNST <= 16'h0000;
      3'o6: CNST <= `End_of_Packet;
      3'o7: CNST <= `Carrier_Extend;
      default: CNST <= `IDLE2;
   endcase
end
// Matching ROM for CHAR_IS_K tags. 
always @(posedge CLK)
begin: Frame_ROM_KWORD
   case(ROM_ADDR)
      3'o0: KCNST <= 2'b10;
      3'o1: KCNST <= 2'b10;
      3'o2: KCNST <= 2'b00;
      3'o3: KCNST <= 2'b00;
      3'o4: KCNST <= 2'b00;
      3'o5: KCNST <= 2'b00;
      3'o6: KCNST <= 2'b11;
      3'o7: KCNST <= 2'b11;
      default: KCNST <= 2'b10;
   endcase
end 

//////////////////////////////////////////////////////////////
//                                                          //
// State Machine for ROM address                            //
//                                                          //
//////////////////////////////////////////////////////////////

always @ (posedge CLK or posedge TXRESET)
begin: ROM_ADDR_FSM
   if (TXRESET)
      ROM_ST <= `Wait_for_Sig;
   else
      case (ROM_ST)
         `Wait_for_Sig:
            if (XMIT)
               ROM_ST <= `Preamble1;
            else if((PROT_DONE && NO_DATA) || (LAST_DATA && (D_CNT < `Min_Pkt_Size)))
               ROM_ST <= `M_P_F;
            else if(LAST_DATA && (D_CNT >= `Min_Pkt_Size))
               ROM_ST <= `CRC_1;
            else
               ROM_ST <= `Wait_for_Sig;
         `Preamble1:
             ROM_ST <= `Preamble2;
         `Preamble2:
             ROM_ST <= `Preamble3;
         `Preamble3:
             ROM_ST <= `Preamble4;
         `Preamble4:
             ROM_ST <= `Wait_for_Sig;
         `M_P_F:
            if (FILL_DONE)
               ROM_ST <= `CRC_1;
            else
               ROM_ST <= `M_P_F;
         `CRC_1:
             ROM_ST <= `CRC_2;
         `CRC_2:
             ROM_ST <= `E_O_P;
         `E_O_P:
            if (XTEND)
               ROM_ST <= `B_Ext;
            else
               ROM_ST <= `I_P_S;
         `B_Ext:
            if (XLIMIT)
               ROM_ST <= `I_P_S;
            else
               ROM_ST <= `B_Ext;
         `I_P_S:
            if (TX_DONE)
               ROM_ST <= `Wait_for_Sig;
            else
               ROM_ST <= `I_P_S;
            default:
            ROM_ST <= `Wait_for_Sig;
      endcase
end
always @ (ROM_ST)
begin: ROM_ADDR_OUTPUTS
   case (ROM_ST)
      `Wait_for_Sig:
         begin
            ROM_ADDR <= 3'o0;
            SOF <= 0;
            W2_WRDS <= 0;
         end
      `Preamble1:
         begin
            ROM_ADDR <= 3'o1;
            SOF <= 0;
            W2_WRDS <= 0;
         end
      `Preamble2:
         begin
            ROM_ADDR <= 3'o2;
            SOF <= 0;
            W2_WRDS <= 0;
         end
      `Preamble3:
         begin
            ROM_ADDR <= 3'o3;
            SOF <= 0;
            W2_WRDS <= 0;
         end
      `Preamble4:
         begin
            ROM_ADDR <= 3'o4;
            SOF <= 1;
            W2_WRDS <= 0;
         end
      `M_P_F:
         begin
            ROM_ADDR <= 3'o5;
            SOF <= 0;
            W2_WRDS <= 0;
         end
      `CRC_1:
         begin
            ROM_ADDR <= 3'o5;
            SOF <= 0;
            W2_WRDS <= 0;
         end
      `CRC_2:
         begin
            ROM_ADDR <= 3'o5;
            SOF <= 0;
            W2_WRDS <= 1;
         end
      `E_O_P:
         begin
            ROM_ADDR <= 3'o6;
            SOF <= 0;
            W2_WRDS <= 0;
         end
      `B_Ext:
         begin
            ROM_ADDR <= 3'o7;
            SOF <= 0;
            W2_WRDS <= 0;
         end
      `I_P_S:
         begin
            ROM_ADDR <= 3'o0;
            SOF <= 0;
            W2_WRDS <= 0;
         end
      default:
         begin
            ROM_ADDR <= 3'o0;
            SOF <= 0;
            W2_WRDS <= 0;
         end
   endcase
end

//////////////////////////////////////////////////////////////
//                                                          //
// Counters for payload words and inter packet space        //
//                                                          //
//////////////////////////////////////////////////////////////

defparam payload_cnt.width = 13;
defparam space_cnt.width = 4;

assign FILL_DONE = (D_CNT == `Min_Pkt_Size);
assign TX_DONE = (SPC_CNT == `Pkt_Space);
cnt_up payload_cnt (.clk(CLK),.inc(PAY_INC),.r(PAY_RST),.count(D_CNT));
cnt_up space_cnt (.clk(CLK),.inc(SPC_INC),.r(SPC_RST),.count(SPC_CNT));
//cnt_up_ar space_cnt (.clk(DV1024CLK),.inc(SPC_INC),.r(SPC_RST),.count(SPC_CNT));

//////////////////////////////////////////////////////////////
//                                                          //
// State Machine for MAC recall                             //
//                                                          //
//////////////////////////////////////////////////////////////

always @ (posedge CLK or posedge TXRESET)
begin: MAC_RECALL_FSM
   if (TXRESET)
      MAC_ST <= `Wait_for_SOF;
   else
      case (MAC_ST)
         `Wait_for_SOF:
            if (SOF)
               MAC_ST <= `MP1;
            else
               MAC_ST <= `Wait_for_SOF;
         `MP1:
            MAC_ST <= `MP2;
         `MP2:
            MAC_ST <= `MP3;
         `MP3:
            MAC_ST <= `MS1;
         `MS1:
            MAC_ST <= `MS2;
         `MS2:
            MAC_ST <= `MS3;
         `MS3:
            MAC_ST <= `Wait_for_SOF;
         default:
            MAC_ST <= `Wait_for_SOF;
      endcase
end
always @ (MAC_ST)
begin: MAC_RECALL_OUTPUTS_0
   case (MAC_ST)
      `MP1,`MP2,`MP3:
         begin
            DEST_MAC_RD <= 1;
            SRC_MAC_RD <= 0;
         end
      `MS1,`MS2,`MS3:
         begin
            DEST_MAC_RD <= 0;
            SRC_MAC_RD <= 1;
         end
      default:
         begin
            DEST_MAC_RD <= 0;
            SRC_MAC_RD <= 0;
         end
   endcase
end
always @ (MAC_ST)
begin: MAC_RECALL_OUTPUTS_1
   case (MAC_ST)
      `MP3:
         begin
            MACD_DONE <= 1;
            MACS_DONE <= 0;
         end
      `MS3:
         begin
            MACD_DONE <= 0;
            MACS_DONE <= 1;
         end
      default:
         begin
            MACD_DONE <= 0;
            MACS_DONE <= 0;
         end
   endcase
end
always @ (MAC_ST)
begin: MAC_RECALL_OUTPUTS_2
   case (MAC_ST)
      `MP3:
         RST_TXA1 <= 1;
      default:
         RST_TXA1 <= 0;
   endcase
end

always @ (posedge CLK or posedge TXA_RST)
begin: TX_ADDR_CNTR
   if(TXA_RST)
      TX_ADDR <= 2'b00;
   else
      if(SRC_MAC_RD && (TX_ADDR == 2'b10))
         TX_ADDR <= 2'b00;
      else if(SRC_MAC_RD)
         TX_ADDR <= TX_ADDR + 1;
      else
         TX_ADDR <= TX_ADDR;
end


//////////////////////////////////////////////////////////////
//                                                          //
// State Machine for Protocol Header Recall                 //
//                                                          //
//////////////////////////////////////////////////////////////

always @ (posedge CLK or posedge TXRESET)
begin: HDR_RECALL_FSM
   if (TXRESET)
      HDR_ST <= `Wait_for_Len;
   else
      case (HDR_ST)
         `Wait_for_Len:
            if ((FR_BD_ST == `Length) && PROT_ENA)
               HDR_ST <= `HDR1;
            else
               HDR_ST <= `Wait_for_Len;
         `HDR1:
            HDR_ST <= `HDR2;
         `HDR2:
            HDR_ST <= `HDR3;
         `HDR3:
            HDR_ST <= `HDR4;
         `HDR4:
            HDR_ST <= `Wait_for_Len;
            default:
            HDR_ST <= `Wait_for_Len;
      endcase
end
always @ (HDR_ST)
begin: HDR_RECALL_OUTPUTS
   case (HDR_ST)
      `Wait_for_Len:
         begin
            HDR_RD <= 0;
            PROT_DONE <= 0;
         end
      `HDR1,`HDR2,`HDR3:
         begin
            HDR_RD <= 1;
            PROT_DONE <= 0;
         end
      `HDR4:
         begin
            HDR_RD <= 1;
            PROT_DONE <= 1;
         end
      default:
         begin
            HDR_RD <= 0;
            PROT_DONE <= 0;
         end
   endcase
end


endmodule
