
`timescale 1ns / 1ps

module txstat_err_mon(CLK,TXRESET,TXBUFFERR,TXKERR,TXRUNDISP,
                      NORM_PB_MT,NORM_PB_AF,NORM_PB_FULL,
                      PRIO_PB_MT,PRIO_PB_AF,PRIO_PB_FULL,
                      SPONT_PB_MT,SPONT_PB_AF,SPONT_PB_FULL,
		      UPD_STATS,TX_ERR_RST,TX_PROC_N,TX_PROC_P,TX_PROC_S,TX_MAC_DEST_ERR,TX_ERR,TX_INPRGS,TXSTATUS,XMIT_CNT,XERR_CNT);

    input CLK;
    input TXRESET;
    input TXBUFFERR;
    input [1:0] TXKERR;
    input [1:0] TXRUNDISP;
    input NORM_PB_MT;
    input NORM_PB_AF;
    input NORM_PB_FULL;
    input PRIO_PB_MT;
    input PRIO_PB_AF;
    input PRIO_PB_FULL;
    input SPONT_PB_MT;
    input SPONT_PB_AF;
    input SPONT_PB_FULL;
    input UPD_STATS;
    input TX_ERR_RST;
    input TX_PROC_N;
    input TX_PROC_P;
    input TX_PROC_S;
    input TX_MAC_DEST_ERR;
    output TX_ERR;
    output TX_INPRGS;
    output [15:0] TXSTATUS;
    output [31:0] XMIT_CNT;
    output [31:0] XERR_CNT;

reg TBERR;
reg TKERR;
reg TMERR;
reg [15:0] TXSTATUS;
wire [31:0] XMIT_CNT;
wire [31:0] XERR_CNT;
wire XERR_INC;
wire TX_ERR;
wire TX_INPRGS;

assign XERR_INC = UPD_STATS & TX_ERR;
assign TX_INPRGS = TX_PROC_N || TX_PROC_P || TX_PROC_S || !NORM_PB_MT || !PRIO_PB_MT || !SPONT_PB_MT;

defparam transmit_cntr.width = 32;
defparam xmit_err_cntr.width = 32;

cnt_up transmit_cntr (.clk(CLK),.inc(UPD_STATS),.r(TXRESET),.count(XMIT_CNT));
cnt_up xmit_err_cntr (.clk(CLK),.inc(XERR_INC),.r(TXRESET),.count(XERR_CNT));

always @(posedge CLK)
begin
   if(TXRESET || TX_ERR_RST)
      TBERR <= 0;
   else if(TXBUFFERR)
      TBERR <= 1;
   else
      TBERR <= TBERR;
end

always @(posedge CLK)
begin
   if(TXRESET || TX_ERR_RST)
      TKERR <= 0;
   else if(TXKERR != 2'b00)
      TKERR <= 1;
   else
      TKERR <= TKERR;
end

always @(posedge CLK)
begin
   if(TXRESET || TX_ERR_RST)
      TMERR <= 0;
   else if(TX_MAC_DEST_ERR)
      TMERR <= 1;
   else
      TMERR <= TMERR;
end

assign  TX_ERR = (TBERR || TKERR || TMERR);


always @(posedge CLK or posedge TXRESET)
begin
   if(TXRESET)
      TXSTATUS <= 0;
   else
      TXSTATUS <= {TX_ERR,TBERR,TKERR,TMERR, TX_PROC_N, NORM_PB_FULL, NORM_PB_AF, NORM_PB_MT, TX_PROC_P, PRIO_PB_FULL, PRIO_PB_AF, PRIO_PB_MT, TX_PROC_S, SPONT_PB_FULL, SPONT_PB_AF, SPONT_PB_MT};
end

endmodule
