// Verilog model  - Wed Oct 13 17:49:58 2004

`timescale 1ns / 1ps

module vme_bus_timer(BTO_ENA, DS0, DS1, DTACK, MON_BERR, USRCLK, SYSRESET,
      SYSCLK, TIME_OUT, BERR);

    input BTO_ENA;
    input DS0;
    input DS1;
    input DTACK;
    input MON_BERR;
    input USRCLK;
    input SYSRESET;
    input SYSCLK;
    input [15:0] TIME_OUT;
   output BERR;

wire START, STOP;
wire DSA;
wire SET_BTO;
wire SET_BERR;
wire CLR_BERR;

reg BTO;
reg DD0,DD1,DD2;
reg DDS_OR,DDS_AND;
reg TM_ENA;
reg DTACK_AT_BTO;
reg BERR_AT_BTO;
reg BERR;
reg [15:0] TIMER;
   
`ifdef HEADER
`else
`include "header.v"
`endif


// TIMER is 16 bits running on a 16nS clock.
// So the TIME_OUT can be set from 0 to 1.04856 mS.
assign SET_BTO = (TIMER == TIME_OUT);
assign SET_BERR = BTO && !DTACK_AT_BTO && !BERR_AT_BTO && BTO_ENA;
assign DSA = DS0 | DS1;
assign CLR_BERR = SYSRESET || STOP;
assign START = DSA & !DDS_OR;
assign STOP = !DSA & DDS_AND;

always @(posedge SYSCLK)
begin
   DD0 <= DSA;
   DD1 <= DD0;
   DD2 <= DD1;
   DDS_OR <= |{DD2,DD1,DD0};  // to eliminate false starts on trailing edge
   DDS_AND <= &{DD2,DD1,DD0}; // to eliminate false stops on leading edge
end


always @(posedge SYSCLK or posedge CLR_BERR)
begin
   if(CLR_BERR)
      begin
         DTACK_AT_BTO <= 0;
         BERR_AT_BTO  <= 0;
         BTO <= 0;
      end
   else
      if(SET_BTO)
         begin
            DTACK_AT_BTO <= DTACK;
            BERR_AT_BTO  <= MON_BERR;
            BTO <= 1;
         end
      else
         begin
            DTACK_AT_BTO <= DTACK_AT_BTO;
            BERR_AT_BTO  <= BERR_AT_BTO;
            BTO <= BTO;
         end
end

always @(posedge SYSCLK or posedge CLR_BERR)
begin
   if(CLR_BERR)
      BERR  <= 0;
   else
      if(SET_BERR)
         BERR <= 1;
      else
         BERR <= BERR;
end

always @(posedge SYSCLK or posedge CLR_BERR)
begin
   if(CLR_BERR)
      TM_ENA  <= 0;
   else
      if(START)
         TM_ENA <= 1;
      else
         TM_ENA <= TM_ENA;
end

always @(posedge USRCLK or posedge CLR_BERR)
begin
   if(CLR_BERR)
      TIMER <= 16'h0000;
   else
      if(TM_ENA && !BERR)
         TIMER <= TIMER + 1;
      else
         TIMER <= TIMER;   
end
   
endmodule
