// Verilog model  - Thu Oct 28 11:16:55 2004

`timescale 1ns / 1ps
`ifndef HEADER
`include "header.v"
`endif

module vme_config(MON_SYSRESET, BG3IN, DV1024CLK, CK_3P9MS,
      GA, GAP, POW_ON_RST, USRCLK,
      VME_CNFG, VME_BTO, VME_BGTO,
      VME_READY, ACFAIL, ARB_ENA, ARB_TYP, BTO_ENA, ENA_AHIGH,
      ENA_ALOW, ENA_BCLR, ENA_BGIN, ENA_BGOUT, ENA_DHIGH, ENA_DLOW,
      ENA_IACKOUT, ENA_LI, ENA_MON_BGIN, ENA_MON_IACKIN, ENA_MON_RTP,
      ENA_SYSCLK, ENA_USER_DEF, ENA_VCTRL, INTR_ENA, INTR_HNDL_ENA, UPD_IRQ_MSK, IH_LVLS, IH_DT_SZ,
      IH_REQ_LVL, IH_REQ_TYP, LI_O, LOC_MON_ENA, MASTER_ENA, MREQ_LVL,
      MREQ_TYP, MASK_BERR, SYSCLK_ENA, SYSFAIL,
      SYSRST_OUT_ENA, SYSRST_IN_ENA, SYSRESET, DRV_SYSRESET, SYS_CTRL_ENA,
      BTO_TIME_OUT, BG_TIME_OUT, VME64X_ENA);

    input MON_SYSRESET;
    input BG3IN;
    input DV1024CLK;
    input CK_3P9MS;
    input [4:0] GA;
    input GAP;
    input POW_ON_RST;
    input USRCLK;
    input [31:0] VME_CNFG;
    input [15:0] VME_BTO;
    input [15:0] VME_BGTO;
   output VME_READY;
   output ACFAIL;
   output ARB_ENA;
   output [1:0] ARB_TYP;
   output BTO_ENA;
   output ENA_AHIGH;
   output ENA_ALOW;
   output ENA_BCLR;
   output ENA_BGIN;
   output ENA_BGOUT;
   output ENA_DHIGH;
   output ENA_DLOW;
   output ENA_IACKOUT;
   output ENA_LI;
   output ENA_MON_BGIN;
   output ENA_MON_IACKIN;
   output ENA_MON_RTP;
   output ENA_SYSCLK;
   output ENA_USER_DEF;
   output ENA_VCTRL;
   output INTR_ENA;
   output INTR_HNDL_ENA;
   output UPD_IRQ_MSK;
   output [7:1] IH_LVLS;
   output [1:0] IH_DT_SZ;
   output [1:0] IH_REQ_LVL;
   output [1:0] IH_REQ_TYP;
   output LI_O;
   output LOC_MON_ENA;
   output MASTER_ENA;
   output [1:0] MREQ_LVL;
   output [1:0] MREQ_TYP;
   output MASK_BERR;
   output SYSCLK_ENA;
   output SYSFAIL;
   output SYSRST_OUT_ENA;
   output SYSRST_IN_ENA;
   output SYSRESET;
   output DRV_SYSRESET;
   output SYS_CTRL_ENA;
   output [15:0] BTO_TIME_OUT;
   output [15:0] BG_TIME_OUT;
   output VME64X_ENA;

reg [2:0] VSTRT_ST;
reg BG3IN_AT_STRTUP;
reg CAP_BG3IN;
reg VME_READY;
reg VI_RST;
reg ENO, ENO1, ENO2, ENO3;

wire USR_ARB_ENA;
wire USR_SYSCLK_ENA;
wire SYSRST_OUT_ENA;
wire SYSRST_IN_ENA;
wire D40MS;
   
`ifdef Simulation
   SRL16E DLY40MS (.CLK(DV1024CLK),.CE(!POW_ON_RST),.D(1'b1),.Q(D40MS),.A3(1'b0),.A2(1'b0),.A1(1'b1),.A0(1'b1)); // 10 Clocks
`else
   SRL16E DLY40MS (.CLK(CK_3P9MS),.CE(!POW_ON_RST),.D(1'b1),.Q(D40MS),.A3(1'b1),.A2(1'b0),.A1(1'b1),.A0(1'b0)); // 10 Clocks
`endif

always @(posedge USRCLK or posedge POW_ON_RST)          
begin: VME_Pwr_Up_FSM
   if(POW_ON_RST)
      VSTRT_ST <= `Vstrt_hold;
   else
      case (VSTRT_ST)
         `Vstrt_hold:
            VSTRT_ST <= `W40ms;
         `W40ms:
            begin
               if(D40MS)
                  VSTRT_ST <= `Cap_BG3;
               else
                  VSTRT_ST <= `W40ms;
            end
         `Cap_BG3:
            VSTRT_ST <= `V_Ena_Outs;
         `V_Ena_Outs:
            begin
               if(ENO3)
                  VSTRT_ST <= `VME_Rdy;
               else
                  VSTRT_ST <= `V_Ena_Outs;
            end
         `VME_Rdy:
            VSTRT_ST <= `VME_Rdy;
         default:
            VSTRT_ST <= `Vstrt_hold;
      endcase
end

always @(VSTRT_ST)
begin
   case (VSTRT_ST)
      `Cap_BG3:
         begin
            VI_RST = 1'b1;
            ENO = 1'b0;
            VME_READY = 1'b0;
            CAP_BG3IN = 1'b1;
         end
      `V_Ena_Outs:
         begin
            VI_RST = 1'b1;
            ENO = 1'b1;
            VME_READY = 1'b0;
            CAP_BG3IN = 1'b0;
         end
      `VME_Rdy:
         begin
            VI_RST = 1'b0;
            ENO = 1'b1;
            VME_READY = 1'b1;
            CAP_BG3IN = 1'b0;
         end
      default:
         begin
            VI_RST = 1'b1;
            ENO = 1'b0;
            VME_READY = 1'b0;
            CAP_BG3IN = 1'b0;
         end
   endcase
end

always @(posedge USRCLK)          
begin
   ENO1 <= ENO;
   ENO2 <= ENO1;
   ENO3 <= ENO2;
end


always @(posedge USRCLK or posedge POW_ON_RST)          
begin //Supposed to wait 40 mSec after power in spec. before capturing state of BG3IN.
   if(POW_ON_RST)
      BG3IN_AT_STRTUP <= 1'b0;
   else
      if(CAP_BG3IN)
         BG3IN_AT_STRTUP <= BG3IN;
      else
         BG3IN_AT_STRTUP <= BG3IN_AT_STRTUP;
end


////////////////////////////////////////////////////////////////////////////////////////
//
// VME_CNFG(31:0)
// Configuration bits for the VME module:
// Bit  Signal          Function
//  0   VME_MSTR_ENA    Enables the VME master.
//  1   VME_SYSCLK_ENA  Enables the VME SYSCLK on the backplane (if it's a System Controller ie. slot 1)
//  2   BTO_ENA         Enables the Bus Timer module.
//  3   ARB_ENA         Enables the Arbiter module for controlling bus arbitration (if System Controller).
//  4   MASK_BERR       Mask off monitoring of BERR signal. 
//  5   LOC_MON_ENA     Enables the Location Monitor features.
//  6   INTR_HNDLR_ENA  Enables interrupt handling.
//  7   USER_DEFS_ENA   Enables user defined buffers on J2.
// 8,9  MSTR_REQ_TYPE   Specifies the requester type for the master module.
//                          0: Release On Request (ROR)
//                          1: Release When Done (RWD)
//                          2: Fair ROR requester
//                          3: Fair RWD requester
//10,11 MSTR_REQ_LVL    Specifies the request level for the master module.
//12,13 ARB_TYPE        Specifies the Arbiter type.
//                          0: No Arbitration (disabled)
//                          1: SinGLe Level Arbiter (SGL)
//                          2: PRIoritized Arbiter (PRI)
//                          3: Round Robin Select (RRS)
// 14   ENA_HI_ORDER    Enable the high order bits of Address and Data Buses.
// 15   FRC_SYSRST      Force a SYSRESET.
//16-22 IH_LVLS         Specifies the Levels (1-7) the Interrupt Handler will service (7 bits).
// 23   UPD_IRQ_MSK     Update IRQ mask - restores the mask to IH_LVLS set in this register and auto resets itself to 0.
//24,25 IH_REQ_TYPE     Specifies the requester type for the Interrupt Handler.
//26,27 IH_REQ_LVL      Specifies the request level for the Interrupt Handler.
//28,29 IH_DT_SZ        Specifies the data transfer capability of the Interrupt Handler.
//30    SYSRST_OUT_ENA  Enable SYSRESETs out to backplane.
//31    SYSRST_IN_ENA   Enable Monitoring SYSRESETs on the backplane
//
//////////////////////////////////////////////////////////////////////////////////////
   
assign SYS_CTRL_ENA = !POW_ON_RST && BG3IN_AT_STRTUP;

assign ACFAIL = 0;
assign USR_ARB_ENA = VME_CNFG[3];
assign ARB_ENA = ENO ? (SYS_CTRL_ENA && USR_ARB_ENA) : 0;
assign ARB_TYP = VME_CNFG[13:12]; //Single level arbiter
assign BTO_ENA = VME_CNFG[2];
assign ENA_AHIGH = ENO ? VME_CNFG[14] : 0;
assign ENA_ALOW = ENO ? 1 : 0;
assign ENA_BCLR = ENO ? 1 : 0;
assign ENA_BGIN = ENO ? (SYS_CTRL_ENA && USR_ARB_ENA) : 0;
assign ENA_BGOUT = ENO ? 1 : 0;
assign ENA_DHIGH = ENO ? VME_CNFG[14] : 0;
assign ENA_DLOW = ENO ? 1 : 0;
assign ENA_IACKOUT = ENO ? 1 : 0;
assign ENA_LI = 0;
assign ENA_MON_BGIN = 1;
assign ENA_MON_IACKIN = 1;
assign ENA_MON_RTP = 0;
assign ENA_SYSCLK = ENO ? SYS_CTRL_ENA : 0;
assign ENA_USER_DEF = ENO ? VME_CNFG[7] : 0;
assign ENA_VCTRL = ENO ? (MASTER_ENA || LOC_MON_ENA || INTR_ENA || INTR_HNDL_ENA || BTO_ENA) : 0;
assign INTR_ENA = 0;
assign INTR_HNDL_ENA = ENO ? VME_CNFG[6] : 0;
assign IH_LVLS = VME_CNFG[22:16];
assign IH_DT_SZ = VME_CNFG[29:28];
assign IH_REQ_LVL = VME_CNFG[27:26];
assign IH_REQ_TYP = VME_CNFG[25:24];
assign UPD_IRQ_MSK = VME_CNFG[23];
assign LI_O = 0;
assign LOC_MON_ENA = ENO ? VME_CNFG[5] : 0;
assign MASTER_ENA = ENO ? VME_CNFG[0] : 0;
assign MREQ_LVL = VME_CNFG[11:10];
assign MREQ_TYP = VME_CNFG[9:8];
assign MASK_BERR = VME_CNFG[4];
assign USR_SYSCLK_ENA = VME_CNFG[1];
assign SYSCLK_ENA = SYS_CTRL_ENA && USR_SYSCLK_ENA;
assign SYSFAIL = 0;
assign BTO_TIME_OUT = VME_BTO;    //Default is 12,500 (16'h30D4)(200 uS in 16 nS units)
assign BG_TIME_OUT = VME_BGTO;    //Default is  3,125 (16'h0C35)(50 uS in 16 nS units)
assign VME64X_ENA = ({GAP,GA}!= 6'b111111);
assign SYSRST_OUT_ENA = ENO ? VME_CNFG[30] : 0;
assign SYSRST_IN_ENA = ENO ? VME_CNFG[31] : 0;
assign SYSRESET = POW_ON_RST | VI_RST | VME_CNFG[15] | MON_SYSRESET;
assign DRV_SYSRESET = ENO ? VME_CNFG[15] : 0;

endmodule
