`timescale 1ns / 1ps

`ifndef HEADER
`include "header.v"
`endif

module vme_cp(CLK, RST, CP_RST, MSG_LVL,
      SEL, RCTRL, RCVDATA, BG, READ, RFUNCT, PREP4SHTDWN, VW_RDY4SHTDWN,
//
      FRAME_REQ, MAC_REQ, BR, TXDATA, TXCTRL,
      TO_VME, ODV, RHOLD, CP2V_OUT_RDY, FLSHD, CP2V_RD_ERR, RDY4SHTDWN);

    input CLK;
    input RST;
    input CP_RST;
    input [1:0] MSG_LVL;
    input SEL;
    input [2:0] RCTRL;
    input [15:0] RCVDATA;
    input BG;
    input READ;
    input [3:0]RFUNCT;
    input PREP4SHTDWN;
    input VW_RDY4SHTDWN;
//
   output FRAME_REQ;
   output MAC_REQ;
   output BR;
   output [15:0] TXDATA;
   output [4:0] TXCTRL;
   output [17:0] TO_VME;
   output ODV;
   output RHOLD;
   output CP2V_OUT_RDY;
   output FLSHD;
   output CP2V_RD_ERR;
   output RDY4SHTDWN;
//
   

reg  FRAME_REQ;
reg  MAC_REQ;
wire BR;
reg  [15:0] TXDATA;
reg  [4:0] TXCTRL;
reg  [17:0] TO_VME;
reg  ODV;
wire RHOLD;
reg  CP2V_OUT_RDY;
wire FLSHD;
wire CP2V_RD_ERR;
wire RDY4SHTDWN;

//////////////////////////////////////////////////////////////////////////////


reg [3:0] VCP_ST;
reg [3:0] VCPF_RD_ST;
reg [11:0] RD_TMR;
reg [7:0] FUNCT;
reg [1:0] CAT_MUX;
reg [2:0] INSTR_MUX;
reg [15:0] DATA_MUX;
reg [2:0]  CTRL;
reg [15:0] RXDATA;
reg [15:0] MAC_HDR_SRL_R;
reg [15:0] SRL_IN_DAT;
reg [1:0]  SRL_IN_BITS;
reg [7:0] TYPE;
reg [3:0] STATUS;
reg [11:0] ST_TY;
reg [15:0] RCV_ERR_WRD1,RCV_ERR_WRD2;
reg [15:0] ERR_HDR;

reg ACK;
reg PRIO;
reg V_DEF;
reg RCV_ERR;
reg H_BIT;
reg HDR_DN;
reg MSRL2,MSRL3,MSRL4,MAC_DONE;
reg BC1,BUS_CLR;
reg DATA_DONE;
reg INTR_ERR,MID_ERR,FATAL_ERR;
reg SEL_ERR_R;
reg SE1,SE2,SE3;
reg DATA_FLAG;
reg TXP_DATA_R;
reg STAT_R;
reg SND_PKT_R;
reg GET_FRAME_R;
reg SRL2FF1,SRL2FF2,SRL2FF3,SRL2FF4,SRLDONE;
reg VVD_R;
reg D2;
reg ODV1;
reg MH_DONE;
reg DRP_DAT_VALID;
reg MHCF_AF_R;
reg MHCF_WTERR_R;
reg VCPF_AF_R;
reg VCPF_WTERR_R;
reg PPMHCF1;
reg PPMHCF2;
reg PPMHCF3;
reg PPMHCF4;
reg OUT_RDY;

///////////////////////////////////////////
// Signals for instansiated modules.
///////////////////////////////////////////
wire [3:0] VCP_TXP_ST;
wire [15:0] MAC_HDR_SRL;
wire [1:0]  MHBITS_SRL;
wire MHCF_MT;
wire MHCF_AMT;
wire MHCF_AF;
wire MHCF_FULL;
wire MHCF_WTERR;
wire MHCF_RDERR;
wire [17:0] MHCF_OUT;
wire [4:0] MHCF_CNT;
wire VCPF_MT;
wire VCPF_AMT;
wire VCPF_AF;
wire VCPF_FULL;
wire VCPF_WTERR;
wire VCPF_RDERR;
wire [17:0] VCPF_OUT;
wire [9:0] VCPF_CNT;

///////////////////////////////////////////
wire CMD_PROC_RST;
wire RD_TMOUT;
wire [17:0] VCPF_IN;

///////////////////////////////////////////

wire MOMENTARY_ERR_CNDT;
wire FATAL_ERR_CNDT;
wire WARN;
wire ERR;
wire S_DATA;
wire S_ACK;
wire S_ERR;
wire SEL_ERR;
wire SE0;

wire VVD;
wire OPCODE;
wire EOP;
wire MBIT;
wire HBIT;
wire RCV_ERR1,RCV_ERR2;
wire D1;
wire RD_DATA_VALID;

wire IDLE;
wire RST_ERRS;
wire GET_FUNCT;
wire GET_MAC;
wire DMY_GET;
wire LOAD_BOD;
wire GET_FRAME;
wire SND_WARN;
wire SND_ERR;
wire SRL2FF;
wire VCP_RDY4SHTDWN;

wire MSRL1;
wire TXP_INI_STAT;
wire TXP_MID_STAT;
wire TXP_INC_STAT;
wire TXP_FIN_STAT;
wire TXP_DATA;
wire TXP_SND_PKT;
wire FLUSH;
wire DONE;
wire CLR_INTR_ERR;

wire START_TXP;
wire HND_SHK;
wire STAT;
wire RD_SRL;
wire SRL_CE;
wire ERWRAP;
wire [17:0]MHCF_IN;
wire RST_INTR_ERR;
wire ERR_RST;

///////////////////////////////////////////
///////////////////////////////////////////
wire VCPF_IDLE;
wire MT_ERR;
wire RD_ERR;
wire ENATMR;
wire REN;
wire DRP;
wire POP_MHCF;

///////////////////////////////////////////

wire VME_DIR_CMD;
wire PUSH_VCPF;
wire POP_VCPF;
wire RD_MHCF;
wire INT_OUT_RDY;
wire BEG_O_DATA;



// Assignments for output signals to FIFO ////////////////////////////////////////////////////////
   
assign  RHOLD = !((VCPF_RD_ST == `VCPF_W4Rd) || (VCPF_RD_ST == `VCPF_Rd_FF));
assign  FLSHD = (VCPF_RD_ST == `VCPF_Flush_Done);
assign CP2V_RD_ERR = MT_ERR || RD_ERR;
assign RDY4SHTDWN = VCP_RDY4SHTDWN && VW_RDY4SHTDWN;

// Assignments for internal signals ////////////////////////////////////////////////////////

assign CMD_PROC_RST = RST || CP_RST;
assign   RD_TMOUT   = (RD_TMR == `VCP_FF_Rd_TmOut);
assign    VCPF_IN   = LOAD_BOD ? 18'h20B0D : {2'b00,RXDATA};

// Command Processor state signals /////////////////////////////////////////////////////////////////////

assign MOMENTARY_ERR_CNDT = 0;
assign FATAL_ERR_CNDT = 0;
assign WARN    = (VCPF_AF_R || MHCF_AF_R) && (MSG_LVL > 2'h1);
assign ERR     = (VCPF_WTERR_R || MHCF_WTERR_R || RCV_ERR || !V_DEF) && (MSG_LVL > 2'h0);
assign S_DATA  = 0;
assign S_ACK   = 0;
assign S_ERR   = SND_ERR || SND_WARN;
assign SEL_ERR = (VCP_TXP_ST == `TxP_Data) && S_ERR;
assign SE0     = SEL_ERR && !SEL_ERR_R;

assign VVD        = (CTRL == `Rx_Data);
assign OPCODE     = (CTRL == `Rx_OpCode);
assign EOP        = (CTRL == `Rx_EOP);
assign MBIT       = (CTRL == `Rx_MAC);
assign HBIT       = (CTRL == `Rx_HDR);
assign RCV_ERR1   = (CTRL == `Rx_ErrWrd1);
assign RCV_ERR2   = (CTRL == `Rx_ErrWrd2);
assign D1         = VVD && !VVD_R;
assign RD_DATA_VALID = ODV1 && !RD_ERR;

assign IDLE         = (VCP_ST  == `VCP_Idle);
assign RST_ERRS     = (VCP_ST  == `VCP_Idle);
assign GET_FUNCT    = (VCP_ST  == `VCP_Get_Funct);
assign GET_MAC      = (VCP_ST  == `VCP_Get_MAC);
assign DMY_GET      = (VCP_ST  == `VCP_Dmy_Get);
assign LOAD_BOD     = (VCP_ST  == `VCP_Ld_BOD);
assign GET_FRAME    = (VCP_ST  == `VCP_Get_Frame);
assign SND_WARN     = (VCP_ST  == `VCP_Snd_Warn);
assign SND_ERR      = (VCP_ST  == `VCP_Snd_Err);
assign SRL2FF       = (VCP_ST  == `VCP_SRL2FF);
assign VCP_RDY4SHTDWN = (VCP_ST  == `VCP_Rdy4Shtdwn);


assign MSRL1        = (VCP_TXP_ST == `TxP_MAC);
assign TXP_INI_STAT = (VCP_TXP_ST == `TxP_Ini_Stat);
assign TXP_MID_STAT = (VCP_TXP_ST == `TxP_Mid_Stat);
assign TXP_INC_STAT = (VCP_TXP_ST == `TxP_Inc_Stat);
assign TXP_FIN_STAT = (VCP_TXP_ST == `TxP_Fin_Stat);
assign TXP_DATA     = (VCP_TXP_ST == `TxP_Data);
assign TXP_SND_PKT  = (VCP_TXP_ST == `TxP_Send_Pkt);
assign FLUSH        = (VCP_TXP_ST == `TxP_Flush);
assign DONE         = (VCP_TXP_ST == `TxP_Done);
assign CLR_INTR_ERR = (VCP_TXP_ST == `TxP_Clr_Intr);


assign START_TXP = S_ERR;
assign HND_SHK = !START_TXP;
assign STAT = TXP_INI_STAT || TXP_MID_STAT || TXP_INC_STAT || TXP_FIN_STAT;
assign RD_SRL = MSRL1; 
assign SRL_CE = MBIT || HBIT || (SRL2FF && !ERWRAP) || RD_SRL; 
assign ERWRAP = SRL2FF && !SRL2FF1;
assign MHCF_IN = ERWRAP ? {14'h0000,ERR,WARN,ACK,PRIO} : {MHBITS_SRL,MAC_HDR_SRL};
assign RST_INTR_ERR = CLR_INTR_ERR || RST;
assign ERR_RST  = RST_ERRS || RST;

// Read state signals /////////////////////////////////////////////////////////////////////////////

assign VCPF_IDLE = (VCPF_RD_ST == `VCPF_Idle);
assign    MT_ERR = (VCPF_RD_ST == `VCPF_MT_Err);
assign    RD_ERR = (VCPF_RD_ST == `VCPF_Rd_Err);
assign    ENATMR = (VCPF_RD_ST == `VCPF_Pause);
assign       REN = (VCPF_RD_ST == `VCPF_Rd_FF);
assign       DRP = (VCPF_RD_ST == `VCPF_Drop_Wrd) || (VCPF_RD_ST == `VCPF_Flush_BOD);
assign  POP_MHCF = (VCPF_RD_ST == `VCPF_PoP_MH);

// Function Decodes /////////////////////////////////////////////////////////////////////////////

assign VME_DIR_CMD  = (FUNCT == `VME_Dir_Cmds);
assign PUSH_VCPF    = (VVD && VME_DIR_CMD && GET_FRAME) || LOAD_BOD;
assign POP_VCPF     = REN || DRP;
assign RD_MHCF      = (RFUNCT == `Read_MHCF);
assign INT_OUT_RDY  = !VCPF_MT;
assign BEG_O_DATA   = (VCPF_OUT == 18'h20B0D);


/////////////////////////
// Input Registers     //
/////////////////////////

always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         FUNCT <= 8'h00;
         ACK   <= 0;
         PRIO  <= 0;
      end
   else
      if(SEL && (RCTRL == `Rx_OpCode) && GET_FUNCT) // this is RCTRL not CTRL
         begin
            FUNCT <= RCVDATA[7:0];
            ACK   <= RCVDATA[13];
            PRIO  <= RCVDATA[14];
         end
      else
         begin
            FUNCT <= FUNCT;
            ACK   <= ACK;
            PRIO  <= PRIO;
         end
end
always @(FUNCT)
begin
   case(FUNCT)
      `VME_Dir_Cmds:
         V_DEF <= 1;
      default:
         V_DEF <= 0;
   endcase
end


always @(posedge CLK)
begin
   RXDATA <= RCVDATA;
   CTRL <= RCTRL;
   HDR_DN <= HBIT;
   ST_TY <= {STATUS,TYPE};
   H_BIT <= MHBITS_SRL[0];
   SRL2FF1 <= SRL2FF;
   SRL2FF2 <= SRL2FF1;
   SRL2FF3 <= SRL2FF2;
   SRL2FF4 <= SRL2FF3;
   SRLDONE <= SRL2FF4;
   MSRL2 <= MSRL1;
   MSRL3 <= MSRL2;
   MSRL4 <= MSRL3;
   MAC_DONE <= MSRL4;
   MAC_HDR_SRL_R <= MAC_HDR_SRL;
   GET_FRAME_R <= GET_FRAME;
   TXP_DATA_R <= DATA_FLAG;
   BC1 <= FLUSH;
   BUS_CLR <= BC1;
   SEL_ERR_R <= SEL_ERR;
   SE1 <= SE0;
   SE2 <= SE1;
   SE3 <= SE2;
   STAT_R <= STAT;
   SND_PKT_R <= TXP_SND_PKT;
   VVD_R <= VVD;
   D2 <= D1;
end

always @(posedge CLK or posedge RST_ERRS)
begin
   if(RST_ERRS)
      begin
         RCV_ERR_WRD1 <= 16'h0000;
         RCV_ERR_WRD2 <= 16'h0000;
         RCV_ERR <= 0;
      end
   else
      if(RCV_ERR1 && V_DEF)
         begin
            RCV_ERR_WRD1 <= RXDATA;
            RCV_ERR_WRD2 <= RCV_ERR_WRD2;
            RCV_ERR <= 1;
         end
      else if(RCV_ERR2 && V_DEF)
         begin
            RCV_ERR_WRD1 <= RCV_ERR_WRD1;
            RCV_ERR_WRD2 <= RXDATA;
            RCV_ERR <= 1;
         end
      else
         begin
            RCV_ERR_WRD1 <= RCV_ERR_WRD1;
            RCV_ERR_WRD2 <= RCV_ERR_WRD2;
            RCV_ERR <= RCV_ERR;
         end
end
always @(posedge CLK or posedge RST_ERRS)
begin
   if(RST_ERRS)
      begin
         MHCF_AF_R    <= 0;
         MHCF_WTERR_R <= 0;
         VCPF_AF_R     <= 0;
         VCPF_WTERR_R  <= 0;
      end
   else
      begin
         MHCF_AF_R    <= MHCF_AF    ? 1 : MHCF_AF_R;
         MHCF_WTERR_R <= MHCF_WTERR ? 1 : MHCF_WTERR_R;
         VCPF_AF_R    <= VCPF_AF    ? 1 : VCPF_AF_R;
         VCPF_WTERR_R <= VCPF_WTERR ? 1 : VCPF_WTERR_R;
      end
end
always @(RCV_ERR or V_DEF or VCPF_AF_R or VCPF_WTERR_R or MHCF_AF_R or MHCF_WTERR_R)
begin
   if(RCV_ERR)
      ERR_HDR <= {`VME_Ctrl,`HDR_Error,`ER_Rcv_Err};
   else if(!V_DEF)
      ERR_HDR <= {`VME_Ctrl,`HDR_Error,`CP_Not_Def};
   else if(VCPF_WTERR_R)
      ERR_HDR <= {`VME_Ctrl,`HDR_Error,`VD_Dat_WtErr};
   else if(VCPF_AF_R)
      ERR_HDR <= {`VME_Ctrl,`HDR_Warn,`VD_Dat_AF};
   else if(MHCF_WTERR_R)
      ERR_HDR <= {`VME_Ctrl,`HDR_Error,`VD_Hdr_WtErr};
   else if(MHCF_AF_R)
      ERR_HDR <= {`VME_Ctrl,`HDR_Warn,`VD_Hdr_AF};
   else
      ERR_HDR <= {`VME_Ctrl,`HDR_Info,`G_No_Info};
end

always @(posedge CLK or posedge RST_INTR_ERR)
begin
   if(RST_INTR_ERR)
      INTR_ERR <= 0;
   else
      if(MOMENTARY_ERR_CNDT)
         INTR_ERR <= 1;
      else
         INTR_ERR <= INTR_ERR;
end
always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      MID_ERR <= 0;
   else
      if(INTR_ERR)
         MID_ERR <= 1;
      else
         MID_ERR <= MID_ERR;
end
always @(posedge CLK or posedge ERR_RST)
begin
   if(ERR_RST)
      FATAL_ERR <= 0;
   else
      if(FATAL_ERR_CNDT)
         FATAL_ERR <= 1;
      else
         FATAL_ERR <= FATAL_ERR;
end


//////////////////////////////////////////////////////////////////
// MAC/Header SRL for Command Processor                         //
//////////////////////////////////////////////////////////////////
always @(RXDATA or MBIT or HBIT or MAC_HDR_SRL or MHBITS_SRL)
begin  // mux for SRL input
   if(MBIT || HBIT)
      begin
         SRL_IN_DAT <= RXDATA;
         SRL_IN_BITS <= {MBIT,HBIT};
      end
   else
      begin
         SRL_IN_DAT <= MAC_HDR_SRL;
         SRL_IN_BITS <= MHBITS_SRL;
      end
end

macsrl  vcp_srl(.clk(CLK),.ce(SRL_CE),.mhin(SRL_IN_BITS),.din(SRL_IN_DAT),.mhout(MHBITS_SRL),.dout(MAC_HDR_SRL));

//////////////////////////////////////////////////////////////////
// MAC/Header FIFO for passing packet info to VME controller    //
//////////////////////////////////////////////////////////////////
parameter MH_VCP_FF_p2depth = 5;
defparam MH_VCP_FF.p2depth = MH_VCP_FF_p2depth;
defparam MH_VCP_FF.width = 18;
defparam MH_VCP_FF.almostmt = 6;
defparam MH_VCP_FF.almostfull = (1<<MH_VCP_FF_p2depth) - 14;
fifo_dpXn_dst  MH_VCP_FF(.clk(CLK),.rst(RST),.push(SRL2FF),.pop(POP_MHCF),
               .mt(MHCF_MT),.full(MHCF_FULL),.amt(MHCF_AMT),.af(MHCF_AF),.wterr(MHCF_WTERR),.rderr(MHCF_RDERR),
               .din(MHCF_IN),.dout(MHCF_OUT),.cnt(MHCF_CNT));



//////////////////////////////////////////////////////////////////
// FIFO for storing Direct VME commands                         //
//////////////////////////////////////////////////////////////////
parameter VCP_FF_p2depth = 10;
defparam VCP_FF.p2depth = VCP_FF_p2depth;
defparam VCP_FF.width = 18;
defparam VCP_FF.almostmt = 64;
defparam VCP_FF.almostfull = (1<<VCP_FF_p2depth) - 32;
fifo_dpXn_blk  VCP_FF(.clk(CLK),.rst(RST),.push(PUSH_VCPF),.pop(POP_VCPF),
               .mt(VCPF_MT),.full(VCPF_FULL),.amt(VCPF_AMT),.af(VCPF_AF),.wterr(VCPF_WTERR),.rderr(VCPF_RDERR),
               .din(VCPF_IN),.dout(VCPF_OUT),.cnt(VCPF_CNT));
///////////////////////////////////////////////////////////////
//                                                           //
// VME Interface Command Processor State Machine             //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or posedge CMD_PROC_RST)
begin: VCP_FSM
   if(CMD_PROC_RST)
      VCP_ST <= `VCP_Idle;
   else
      case(VCP_ST)
         `VCP_Idle:
            if(SEL)
               VCP_ST <= `VCP_Get_Funct;
            else if(PREP4SHTDWN)
               VCP_ST <= `VCP_Rdy4Shtdwn;
            else 
               VCP_ST <= `VCP_Idle;
         `VCP_Get_Funct:
            if(OPCODE)
               VCP_ST <= `VCP_Get_MAC;
            else 
               VCP_ST <= `VCP_Get_Funct;
         `VCP_Get_MAC:
            if(HDR_DN)
               VCP_ST <= `VCP_isAF;
            else 
               VCP_ST <= `VCP_Get_MAC;
         `VCP_isAF:
            if(!V_DEF)
               VCP_ST <= `VCP_Dmy_Get;
            else if(VCPF_AF_R || MHCF_AF_R)
               if(WARN)
                  VCP_ST <= `VCP_Snd_Warn;
               else
                  VCP_ST <= `VCP_isAMT;
            else if(VME_DIR_CMD)
               VCP_ST <= `VCP_Ld_BOD;
            else
               VCP_ST <= `VCP_Get_Frame;
         `VCP_Ld_BOD:
            VCP_ST <= `VCP_Get_Frame;
         `VCP_Get_Frame:
            if(EOP)
               VCP_ST <= `VCP_SRL2FF;
            else 
               VCP_ST <= `VCP_Get_Frame;
         `VCP_SRL2FF:
            begin
               if(SRLDONE && ERR)
                  VCP_ST <= `VCP_Snd_Err;
               else if(SRLDONE && !ERR)
                  VCP_ST <= `VCP_Idle;
               else
                  VCP_ST <= `VCP_SRL2FF;
            end
         `VCP_Snd_Warn:
            if(DONE)
               VCP_ST <= `VCP_isAMT;
            else 
               VCP_ST <= `VCP_Snd_Warn;
         `VCP_isAMT:
            if(VCPF_AMT && MHCF_AMT)
               VCP_ST <= `VCP_isAF;
            else 
               VCP_ST <= `VCP_isAMT;
         `VCP_Dmy_Get:
            if(EOP)
               if(MSG_LVL > 2'h0)
                  VCP_ST <= `VCP_Snd_Err;
               else
                  VCP_ST <= `VCP_Idle;
            else 
               VCP_ST <= `VCP_Dmy_Get;
         `VCP_Snd_Err:
            if(DONE)
               VCP_ST <= `VCP_Idle;
            else 
               VCP_ST <= `VCP_Snd_Err;
         `VCP_Rdy4Shtdwn:
            VCP_ST <= `VCP_Rdy4Shtdwn;
         default:
            VCP_ST <= `VCP_Idle;
      endcase
end

/////////////////////////////////////////
// Transmit Processor State Machine    //
/////////////////////////////////////////

trans_proc VCP_Txp_FSM(.clk(CLK), .rst(RST), .start(START_TXP), .bg(BG), .mac_done(MAC_DONE),
           .intr_err(INTR_ERR), .fatal_err(FATAL_ERR), .s_err(S_ERR), .data_done(DATA_DONE),
           .bus_clr(BUS_CLR), .hndshk(HND_SHK), .txp_st(VCP_TXP_ST), .br(BR));


always @(VCP_TXP_ST or S_ERR or RCV_ERR or SE0 or SE2)
begin
   case(VCP_TXP_ST)
      `TxP_Data:
         begin
            if(S_ERR)
               begin
                  DATA_DONE <= RCV_ERR ? SE2 : SE0;
                  DATA_FLAG <= 1;
               end
            else
               begin
                  DATA_DONE <= 0;
                  DATA_FLAG <= 0;
               end
         end
      default:
         begin
            DATA_DONE <= 0;
            DATA_FLAG <= 0;
         end
   endcase
end

always @(ERR or WARN or S_ACK)
begin
   if (S_ACK) //Acknowledge packets with no data
      TYPE <= `Rtn_NoDat_Pkt;
   else if(ERR)
      TYPE <= `Rtn_Err_Pkt;
   else if(WARN)
      TYPE <= `Rtn_Warn_Pkt;
   else
      TYPE <= `Rtn_NoDat_Pkt; // No Data types returned;
end


always @(TXP_INI_STAT or TXP_MID_STAT or TXP_INC_STAT or TXP_FIN_STAT or ERR or WARN or S_ACK or S_DATA)
begin
   if(TXP_INI_STAT)
      STATUS <= `CiP;
   else if (TXP_MID_STAT)
      if(ERR)
         STATUS <= `CiP_E;
      else if(WARN)
         STATUS <= `CiP_W;
      else
         STATUS <= `CiP;
   else if (TXP_INC_STAT)
      STATUS <= `CE_I;
   else if (TXP_FIN_STAT)
      if(ERR && (S_ACK || S_DATA))
         STATUS <= `CC_E;
      else if(WARN && (S_ACK || S_DATA))
         STATUS <= `CC_W;
      else if(S_ACK || S_DATA)
         STATUS <= `CC_S;
      else
         STATUS <= `No_Ack;
   else
      STATUS <= `No_Ack;
end


always @(STAT_R or MSRL2 or TXP_DATA_R or 
         ST_TY or MAC_HDR_SRL_R or
         SE1 or SE2 or SE3 or ERR_HDR or
         RCV_ERR or RCV_ERR_WRD1 or RCV_ERR_WRD2)
begin
   if(STAT_R)
      DATA_MUX <= {4'h0,ST_TY};
   else if (MSRL2)
      DATA_MUX <= MAC_HDR_SRL_R;
   else if (TXP_DATA_R && SE1)
      DATA_MUX <= ERR_HDR;
   else if (TXP_DATA_R && SE2)
      DATA_MUX <= RCV_ERR ? RCV_ERR_WRD1 : 16'h0000;
   else if (TXP_DATA_R && SE3)
      DATA_MUX <= RCV_ERR ? RCV_ERR_WRD2 : 16'h0000;
   else
      DATA_MUX <= 16'h0000;
end


always @(STAT_R or MSRL2 or H_BIT or TXP_DATA_R or SND_PKT_R)
begin
   if(STAT_R)
      INSTR_MUX <= `Tx_AST;
   else if (MSRL2)
      if(H_BIT)
         INSTR_MUX <= `Tx_Head;
      else
         INSTR_MUX <= `Tx_MAC;
   else if (TXP_DATA_R)
      INSTR_MUX <= `Tx_Data;
   else if (SND_PKT_R)
      INSTR_MUX <= `Tx_Send;
   else
      INSTR_MUX <= `Tx_NoData;
end

always @(S_ERR or PRIO)
begin
   if(S_ERR)
      CAT_MUX <= `Tx_Spont_Cat;
   else if (PRIO)
      CAT_MUX <= `Tx_Prio_Cat;
   else
      CAT_MUX <= `Tx_Norm_Cat;
end

/////////////////////////
// Output Registers    //
/////////////////////////

always @(posedge CLK)
begin
   if(SEL)
      begin
         MAC_REQ   <= GET_MAC;
         FRAME_REQ <= GET_FRAME || DMY_GET;
      end
   else
      begin
         MAC_REQ   <= 1'bZ;
         FRAME_REQ <= 1'bZ;
      end
end

always @(posedge CLK)
begin
   if(BG)
      begin
         TXDATA  <= DATA_MUX;
         TXCTRL  <= {CAT_MUX,INSTR_MUX};
      end
   else
      begin
         TXDATA  <= 16'hZZZZ;
         TXCTRL  <= 5'hZZ;
      end
end


////////////////////////////////////////////////////////////////////////////////////////////////////////
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //
// ======================== Readout control of FIFO ================================================= //
// -------------------------------------------------------------------------------------------------- //
////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////
//                                                 //
//  VCP FIFO Read related processes                //
//                                                 //
/////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin: VCP_FF_RD_FSM
   if (RST)
      VCPF_RD_ST <= `VCPF_Idle;
   else
      case (VCPF_RD_ST)
         `VCPF_Idle:
            if (INT_OUT_RDY && BEG_O_DATA)
               VCPF_RD_ST <= `VCPF_Flush_BOD;
            else
               case (RFUNCT)
                  `Rd_FF:
                     VCPF_RD_ST <= `VCPF_Pause;
                  `Flush_FF:
                     if(INT_OUT_RDY)
                        VCPF_RD_ST <= `VCPF_Drop_Wrd;
                     else
                        VCPF_RD_ST <= `VCPF_Flush_Done;
                  `Read_MHCF:
                     VCPF_RD_ST <= `VCPF_PoP_MH;
                  default:
                     VCPF_RD_ST <= `VCPF_Idle;
               endcase
         `VCPF_Pause: 
            if (OUT_RDY)
               VCPF_RD_ST <= `VCPF_W4Rd;
            else if (RD_TMOUT)
               VCPF_RD_ST <= `VCPF_MT_Err;
            else
               VCPF_RD_ST <= `VCPF_Pause;
         `VCPF_W4Rd:
            if (READ)
               VCPF_RD_ST <= `VCPF_Rd_FF;
            else if (RFUNCT != `Rd_FF)
               VCPF_RD_ST <= `VCPF_Idle;
            else
               VCPF_RD_ST <= `VCPF_W4Rd;
         `VCPF_Rd_FF:
            if (!INT_OUT_RDY)
               VCPF_RD_ST <= `VCPF_Rd_Err;
            else if (RFUNCT != `Rd_FF)
               VCPF_RD_ST <= `VCPF_Idle;
            else if (!READ)
               VCPF_RD_ST <= `VCPF_W4Rd;
            else
               VCPF_RD_ST <= `VCPF_Rd_FF;
         `VCPF_MT_Err:
            if (RFUNCT != `Rd_FF)
               VCPF_RD_ST <= `VCPF_Idle;
            else
               VCPF_RD_ST <= `VCPF_MT_Err;
         `VCPF_Rd_Err:
            if (RFUNCT != `Rd_FF)
               VCPF_RD_ST <= `VCPF_Idle;
            else
               VCPF_RD_ST <= `VCPF_Rd_Err;
         `VCPF_Flush_BOD:
            VCPF_RD_ST <= `VCPF_W4Vldt1;
         `VCPF_W4Vldt1:
            if(DRP_DAT_VALID) 
               VCPF_RD_ST <= `VCPF_Idle;
            else
               VCPF_RD_ST <= `VCPF_W4Vldt1;
         `VCPF_Drop_Wrd:
            VCPF_RD_ST <= `VCPF_W4Vldt2;
         `VCPF_W4Vldt2:
            if(DRP_DAT_VALID)
               if(!INT_OUT_RDY || BEG_O_DATA) 
                  VCPF_RD_ST <= `VCPF_Flush_Done;
               else 
                  VCPF_RD_ST <= `VCPF_Drop_Wrd;
            else
               VCPF_RD_ST <= `VCPF_W4Vldt2;
         `VCPF_Flush_Done:
            if(RFUNCT != `Flush_FF) 
               VCPF_RD_ST <= `VCPF_Idle;
            else
               VCPF_RD_ST <= `VCPF_Flush_Done;
         `VCPF_PoP_MH:
            if(MH_DONE) 
               VCPF_RD_ST <= `VCPF_MH_Done;
            else
               VCPF_RD_ST <= `VCPF_PoP_MH;
         `VCPF_MH_Done:
            if(RFUNCT != `Read_MHCF) 
               VCPF_RD_ST <= `VCPF_Idle;
            else
               VCPF_RD_ST <= `VCPF_MH_Done;
         default:
            VCPF_RD_ST <= `VCPF_Idle;
      endcase
end




always @(posedge CLK)
begin
   PPMHCF1 <= POP_MHCF;
   PPMHCF2 <= PPMHCF1;
   PPMHCF3 <= PPMHCF2;
   PPMHCF4 <= PPMHCF3;
   MH_DONE <= PPMHCF4;
   ODV1 <= REN;
   DRP_DAT_VALID <= DRP;
   TO_VME <= RD_MHCF ? MHCF_OUT : VCPF_OUT;
   ODV <= RD_MHCF ? PPMHCF1 : RD_DATA_VALID;
   CP2V_OUT_RDY <= INT_OUT_RDY && !BEG_O_DATA && !MHCF_MT;
   OUT_RDY <= INT_OUT_RDY && !BEG_O_DATA;
end


always @(posedge CLK or posedge RST)
begin
   if(RST)
      RD_TMR <= 12'h000;
   else
      if(ENATMR)
         RD_TMR <= RD_TMR + 1;
      else
         RD_TMR <= 12'h000;
end

endmodule
