`timescale 1ns / 1ps

`ifndef HEADER
`include "header.v"
`endif


module vme_ctrlr(CLK, RST, SW2, MSG_LVL, BG,
      EXF_DIN, EXF_RD_ERR, EXF_RHOLD, EXF_ODV, EXF_HAS_DATA, EXF_FLSHD,
      VCP_DIN, VCP_RD_ERR, VCP_RHOLD, VCP_ODV, VCP_HAS_DATA, VCP_FLSHD,
      IH_WARN, IH_ERR, IH_ERR_REG, IH_DT_SZ, IH_IRQ, IH_A, IH_BUSY, IH_DAV, ARB_ERR,
      MSTR_FADDR, MSTR_AM, MSTR_WRT_RDB, MSTR_DATA_SZ, MSTR_TT, MSTR_ERR, MSTR_ERR_REG,
      RSLT_DATA, MSTR_DAV, MSTR_BUSY, NEXT_WRD, PREP4SHTDWN,
//
      BR, TXCTRL, TXDATA, EXF_READ, EXF_RFUNCT, VCP_READ, VCP_RFUNCT, TEST_A, TEST_B, TEST_C,
      ADDR_SZ, DATA_SZ, TRNS_TYP, DLY_TYP, AD_MOD, FULL_ADDR, FULL_DATA, WRT_RDB, 
      VRD_IDLE, EXECUTE, NEXT_RDY, LAST_WORD, ACKN, CLR_MSTR_ERR, RDY4SHTDWN);

    input CLK;
    input RST;
    input [3:0] SW2;
    input [1:0] MSG_LVL;
    input BG;
    input [17:0] EXF_DIN;
    input EXF_RD_ERR;
    input EXF_RHOLD;
    input EXF_ODV;
    input EXF_HAS_DATA;
    input EXF_FLSHD;
    input [17:0] VCP_DIN;
    input VCP_RD_ERR;
    input VCP_RHOLD;
    input VCP_ODV;
    input VCP_HAS_DATA;
    input VCP_FLSHD;
    input IH_WARN;
    input IH_ERR;
    input [7:0] IH_ERR_REG;
    input [1:0] IH_DT_SZ;
    input [7:1] IH_IRQ;
    input [3:1] IH_A;
    input IH_BUSY;
    input IH_DAV;
    input ARB_ERR;
    input [63:0] MSTR_FADDR;
    input [5:0] MSTR_AM;
    input MSTR_WRT_RDB;
    input [1:0] MSTR_DATA_SZ;
    input [1:0] MSTR_TT;
    input MSTR_ERR;
    input [7:0] MSTR_ERR_REG;
    input [63:0] RSLT_DATA;
    input MSTR_DAV;
    input MSTR_BUSY;
    input NEXT_WRD;
    input PREP4SHTDWN;
//
   output BR;
   output [4:0] TXCTRL;
   output [15:0] TXDATA;
   output EXF_READ;
   output [3:0] EXF_RFUNCT;
   output VCP_READ;
   output [3:0] VCP_RFUNCT;
   output [15:0] TEST_A;
   output [15:0] TEST_B;
   output [15:0] TEST_C;
   output [2:0] ADDR_SZ;
   output [1:0] DATA_SZ;
   output [1:0] TRNS_TYP;
   output [2:0] DLY_TYP;
   output [5:0] AD_MOD;
   output [63:0] FULL_ADDR;
   output [63:0] FULL_DATA;
   output WRT_RDB;
   output VRD_IDLE;
   output EXECUTE;
   output NEXT_RDY;
   output LAST_WORD;
   output [3:0] ACKN;
   output CLR_MSTR_ERR;
   output RDY4SHTDWN;
   
wire BR;
reg  [4:0] TXCTRL;
reg  [15:0] TXDATA;
reg  EXF_READ;
reg  [3:0] EXF_RFUNCT;
reg  VCP_READ;
reg  [3:0] VCP_RFUNCT;
reg [15:0] TEST_A;
reg [15:0] TEST_B;
reg [15:0] TEST_C;
reg [2:0] ADDR_SZ;
reg [1:0] DATA_SZ;
reg [1:0] TRNS_TYP;
reg [2:0] DLY_TYP;
reg [5:0] AD_MOD;
reg [63:0] FULL_ADDR;
reg [63:0] FULL_DATA;
reg WRT_RDB;
wire VRD_IDLE;
wire EXECUTE;   
wire NEXT_RDY;
wire LAST_WORD;
reg [3:0] ACKN;
reg CLR_MSTR_ERR;
wire RDY4SHTDWN;


//////////////////////////////////////////////////////////////////////////////

reg [1:0]  EXD_ST;
reg [5:0]  VWRT_ST;
reg [4:0]  VFFW_ST;
reg [3:0]  VFFR_ST;
reg [4:0]  ACCS_TYP;
reg [5:0]  UD_AM;
reg [15:0] UNITS;
reg [15:0] DCNT;
reg [15:0] DATA_IN;
reg [63:0] DATA_REG;
reg [3:0]  RSPD;
reg [7:0]  ACKN_MSK;
reg [1:0]  DATA_SIZE;
reg [1:0]  CUR_MSTR_DS;
reg [1:0]  CUR_IH_DS;
reg [2:0]  PKT_TYP;
reg [2:0]  PKT_TYP_WR;
reg [2:0]  PKT_TYP_CUR;
reg [15:0] DATA_OUT;
reg [15:0] VFF_IN;
reg [15:0] MER_REG;
reg [15:0] VSTATE_REG;
reg [2:0]  FTCH_WRDS;
reg [9:0]  CTRL_ERR_REG;
reg [9:0]  RBK_ERR_REG;
reg [3:0]  RFUNCT;
reg [1:0]  MHBITS;
reg [15:0] SRL_IN_DAT;
reg [1:0]  SRL_IN_BITS;
reg [15:0] MAC_HDR_SRL_R;
reg [16:0] RBK_TIMER;
reg [3:0] STATUS;
reg [7:0] TYPE;
reg [11:0] ST_TY;
reg [15:0] DATA_MUX;
reg [2:0] INSTR_MUX;
reg [1:0] CAT_MUX;

reg H_BIT;
reg FF_RD_ERR;
reg FF_RHOLD;
reg FF_ODV;
reg FF_HAS_DATA;
reg FF_READ;
reg FLSHD;
reg PUSH;
reg ANY_DATA;
reg VME_EOP;
reg EOP_WR;
reg VLDT;
reg VD1;
reg BIP;
reg CIF;
reg UAM;
reg PRG;
reg FF_ODV_D1;
reg FF_ODV_D2;
reg FF_ODV_D3;
reg FF_ODV_D4;
reg FF_ODV_D5;
reg FF_ODV_D6;
reg ADDR_PHASE;
reg DATA_PHASE;
reg AM_CAP;
reg MSRL2;
reg MSRL3;
reg MSRL4;
reg MAC_DONE;
reg STAT_R;
reg TXP_DATA_R;
reg SND_PKT_R;
reg FLUSH_DONE;
reg SOP_WR;
reg SET_DAV_SOP;
reg DAV_SOP;
reg NORM_PKT_CUR;
reg ERR_PKT_CUR;
reg ERR_PKT_CUR_1;
reg WARN_PKT_CUR;
reg WARN_PKT_CUR_1;
reg EONP;
reg WITH_ERRS;
reg WITH_WARNS;
reg PRIO;
reg ACK;
reg FF_WARN;
reg FF_ERR;

////////////////// Outputs from instanciated modules /////////////

wire [15:0] VFF_OUT; 
wire [3:0] VFF_CNT;
wire [2:0] PKT_TYP_RD;
wire EOP_RD;
wire SOP_RD;
wire VLDT_RD;
wire VFF_MT;
wire VFF_AMT;
wire VFF_AF;
wire VFF_FULL;
wire VFF_WTERR;
wire VFF_RDERR;
wire [15:0] MAC_HDR_SRL;
wire [1:0]  MHBITS_SRL;

/////////////// Signals for assign statements ////////////////////

wire LAST_UNIT;
wire FFODV1;
wire FFODV2;
wire FFODV3;
wire FFODV4;
wire FFODV5;
wire FFODV6;
wire DAT_CAP;
wire CAP_ACK;
wire TPI_DONE;
wire FILL_SRL;
wire SRL_CE;
wire BAD_DLY;

/////// ExD State Machine Signal assignments ////////////////////////
wire V_DIRECT;

/////// VWRT State Machine Signal assignments ////////////////////////
wire VW_IDLE;
wire CLR_ANY_DATA;
wire LOAD_UNITS;
wire LOAD_TYPE;
wire LOAD_DCNT;
wire DEC_UNITS;
wire DEC_DCNT;
wire SET_BIP;
wire RST_BIP;
wire CTRL_ERR;
wire SET_CIF;
wire SEND;
wire VW_HNDSHK;
   
wire ANY_DAV;
wire ANY_MSG;
wire ANY_ERR;
wire ANY_WRN;
wire ANY_INF;
wire RST_ACKN;

/////// VFFW FIFO Write State Machine Signal assignments ////////////////////////
wire SET_VLDT;
wire SET_EOP;
wire LOAD_DATA_REG;
wire LD_ACKN;
wire RD_CMPLT;
wire SENT;
wire CLR_DAV_SOP;
wire PNSOP2;

/////// VFFR FIFO Read State Machine Signal assignments ////////////////////////
wire VR_HNDSHK;
wire MSRL1;
wire VR_INI_STAT;
wire VR_FIN_STAT;
wire VR_SND_PKT;
wire VR_FLUSH;
wire VR_POP_SOP;
wire VR_POP_VFF;
wire VFF_ERR;

/////// Control signals for FIFO Readout ////////////////////////
wire RD_SRL;
wire DATA_FLAG;
wire SET_WITH_ERRS;
wire SET_WITH_WARNS;
wire TIME_OUT;
wire POP;
wire NORM_PKT_NXT;
wire UPDT_CUR;
wire TMO;

/////// Direct Output signals /////////////////////
assign BR        = !((VFFR_ST == `VR_Idle) || (VFFR_ST == `VR_Rel_Bus));
assign VRD_IDLE  = (VFFW_ST == `VRd_Idle);
assign EXECUTE   = (VWRT_ST == `Execute) || (VWRT_ST == `Execute_Blk);
assign NEXT_RDY  = (VWRT_ST == `Execute_Blk);
assign LAST_WORD = (DCNT == 16'h0001);



/////// Signal assignments ////////////////////////
assign LAST_UNIT = (UNITS == 16'h0001);
assign FFODV1    = FF_ODV & !FF_ODV_D1;
assign FFODV2    = FF_ODV & FF_ODV_D1 & !FF_ODV_D2;
assign FFODV3    = FF_ODV & FF_ODV_D2 & !FF_ODV_D3;
assign FFODV4    = FF_ODV & FF_ODV_D3 & !FF_ODV_D4;
assign FFODV5    = FF_ODV & FF_ODV_D4 & !FF_ODV_D5;
assign FFODV6    = FF_ODV & FF_ODV_D5 & !FF_ODV_D6;
assign DAT_CAP   = !FF_ODV & FF_ODV_D1;
assign CAP_ACK   = FFODV1 && (RFUNCT == `Read_MHVF);
assign TPI_DONE  = FFODV6 && (RFUNCT == `Read_MHVF);
assign FILL_SRL  = FF_ODV && FF_ODV_D1 && (RFUNCT == `Read_MHVF);
assign SRL_CE    = FILL_SRL || RD_SRL;
assign BAD_DLY   = (DLY_TYP > 3'd6);

/////// ExD State Machine Signal assignments ////////////////////////
assign V_DIRECT     = (EXD_ST == `ExD_Dir_Cmds);

/////// VWRT State Machine Signal assignments ////////////////////////
assign VW_IDLE      = (VWRT_ST == `VW_idle);
assign CLR_ANY_DATA = (VWRT_ST == `VW_idle);
assign LOAD_UNITS   = FF_ODV && (VWRT_ST == `Ld_units);
assign LOAD_TYPE    = FF_ODV && (VWRT_ST == `Ld_type);
assign LOAD_DCNT    = FF_ODV && (VWRT_ST == `Ld_Dcnt);
assign DEC_UNITS    = (VWRT_ST == `Dec_Units);
assign DEC_DCNT     = (VWRT_ST == `Dec_Dcnt);
assign SET_BIP      = (VWRT_ST == `Execute_Blk);
assign RST_BIP      = (VWRT_ST == `Dec_Units);
assign CTRL_ERR     = (VWRT_ST == `Rpt_Vctrl_Err);
assign SET_CIF      = (VWRT_ST == `Flush2BOD);
assign SEND         = (VWRT_ST == `Send_Data);
assign VW_HNDSHK    = (VWRT_ST == `VW_Hnd_Shk);
assign RDY4SHTDWN   = (VWRT_ST  == `VW_Rdy4Shtdwn);


//assign ANY_DAV  = MSTR_DAV || MSTR_ERR || IH_DAV || IH_ERR || IH_WARN || CTRL_ERR || VFF_ERR || ARB_ERR; //Add  warnings, info, and interrupts
//assign ANY_MSG  = MSTR_ERR || IH_ERR || IH_WARN || CTRL_ERR || VFF_ERR || ARB_ERR;  //Add other errors, warnings, info
assign ANY_DAV  = MSTR_DAV || IH_DAV;
assign ANY_ERR  = MSTR_ERR || IH_ERR || CTRL_ERR || VFF_ERR || ARB_ERR;  //Add other errors
assign ANY_WRN  = IH_WARN;  //Add other warnings
assign ANY_INF  = 0;        //Add other info's
assign ANY_MSG  = ANY_ERR || ANY_WRN || ANY_INF;
assign RST_ACKN = !(|(ACKN_MSK & {IH_ERR, MSTR_ERR, CTRL_ERR, VFF_ERR, ARB_ERR, IH_DAV, MSTR_DAV, IH_WARN}));

/////// VFFW FIFO Write State Machine Signal assignments ////////////////////////
assign SET_VLDT      = (VFFW_ST == `VRd_Idle) && (ANY_DAV || ANY_MSG);
assign SET_EOP       = (VFFW_ST == `VRd_Idle) && (ANY_MSG || IH_DAV);
assign LOAD_DATA_REG = (VFFW_ST == `Ld_Drbk);
assign LD_ACKN       = (VFFW_ST == `Ackn) || (VFFW_ST == `Ackn_No_Wrt);
assign RD_CMPLT      = (VFFW_ST == `Rd_Cmplt);
assign SENT          = (VFFW_ST == `Data_Pkt_Sent);
assign CLR_DAV_SOP   = (VFFW_ST == `Data_Pkt_Sent);
assign PNSOP2        = (VFFW_ST == `Push_N_SOP2);
/////// VFFR FIFO Read State Machine Signal assignments ////////////////////////
assign VR_HNDSHK     = (VFFR_ST == `VR_Hnd_Shk);
assign MSRL1         = (VFFR_ST == `VR_MAC);
assign VR_INI_STAT   = (VFFR_ST == `VR_Ini_Stat);
assign VR_FIN_STAT   = (VFFR_ST == `VR_Fin_Stat);
assign VR_SND_PKT    = (VFFR_ST == `VR_Snd_Pkt);
assign VR_FLUSH      = (VFFR_ST == `VR_Flush);
assign VR_POP_SOP    = (VFFR_ST == `VR_Pop_SOP);
assign VR_POP_VFF    = (VFFR_ST == `VR_Pop_VFF);
assign VFF_ERR       = (VFFR_ST == `VR_Rpt_VFF_Err);

/////// Control signals for FIFO Readout ////////////////////////
assign RD_SRL         = MSRL1; 
assign DATA_FLAG      = VD1 && VLDT_RD;
assign SET_WITH_ERRS  = ERR_PKT_CUR && !ERR_PKT_CUR_1;
assign SET_WITH_WARNS = WARN_PKT_CUR && !WARN_PKT_CUR_1;
assign TIME_OUT       = (RBK_TIMER == 17'h1FFFF);
assign POP            = VR_POP_SOP || (VR_POP_VFF && !VFF_MT && !(VD1 && EOP_RD) && !(VD1 && SOP_RD));
assign NORM_PKT_NXT   = !VFF_MT && (PKT_TYP_RD == `VC_Norm_Pkt);
assign UPDT_CUR       = VFF_ERR && (ACKN == `V_VRbk_Err) && !VFF_MT && !SOP_RD;
assign TMO            = (RBK_ERR_REG == `VR_Rd_TMO); 


always @(posedge CLK)
begin
   case (SW2)
      4'h0:
         begin
            TEST_A[5:0] <= VWRT_ST[5:0];
            TEST_A[10:6] <= VFFW_ST[4:0];
            TEST_A[15:11] <= DCNT[4:0];
            TEST_B[1:0] <= DATA_SZ[1:0];
            TEST_B[4:2] <= ADDR_SZ[2:0];
            TEST_B[6:5] <= TRNS_TYP[1:0];
            TEST_B[11:7] <= ACCS_TYP[4:0];
            TEST_B[12] <= NEXT_WRD;
            TEST_B[13] <= NEXT_RDY;
            TEST_B[14] <= LAST_WORD;
            TEST_B[15] <= (ACKN == `V_Mstr_Dav);
            TEST_C[5:0] <= AD_MOD[5:0];
            TEST_C[6] <= BIP;
            TEST_C[7] <= EXECUTE;
            TEST_C[15:8] <= 8'h00; // Sourced by Master
         end
      4'h1:
         begin
            TEST_A[5:0] <= VWRT_ST[5:0];
            TEST_A[10:6] <= VFFW_ST[4:0];
            TEST_A[13:11] <= VFFR_ST[2:0];
            TEST_A[14] <= SEND;
            TEST_A[15] <= ANY_MSG;
            TEST_B[2:0] <= PKT_TYP[2:0];
            TEST_B[5:3] <= PKT_TYP_WR[2:0];
            TEST_B[8:6] <= PKT_TYP_RD[2:0];
            TEST_B[11:9] <= PKT_TYP_CUR[2:0];
            TEST_B[15:12] <= TYPE[3:0];
            TEST_C <= 16'h0000; // Sourced by Master
         end
      4'h2:
         begin
            TEST_A[5:0] <= VWRT_ST[5:0];
            TEST_A[10:6] <= VFFW_ST[4:0];
            TEST_A[13:11] <= VFFR_ST[2:0];
            TEST_A[14] <= SEND;
            TEST_A[15] <= ANY_MSG;
            TEST_B[2:0] <= PKT_TYP[2:0];
            TEST_B[5:3] <= PKT_TYP_WR[2:0];
            TEST_B[8:6] <= PKT_TYP_RD[2:0];
            TEST_B[11:9] <= PKT_TYP_CUR[2:0];
            TEST_B[15:12] <= TYPE[3:0];
            TEST_C[0] <= EOP_WR;
            TEST_C[1] <= EOP_RD;
            TEST_C[2] <= VLDT_RD;
            TEST_C[3] <= VFF_MT;
            TEST_C[7:4] <= TXCTRL[3:0];
            TEST_C[15:8] <= 8'h00; // Sourced by Master
         end
      4'h3:
         begin
            TEST_A[5:0] <= VWRT_ST[5:0];
            TEST_A[10:6] <= VFFW_ST[4:0];
            TEST_A[13:11] <= VFFR_ST[2:0];
            TEST_A[14] <= SEND;
            TEST_A[15] <= ANY_MSG;
            TEST_B[0] <= CTRL_ERR;
            TEST_B[1] <= MSTR_ERR;
            TEST_B[2] <= ACKN_MSK[5]; //control
            TEST_B[3] <= ACKN_MSK[6]; //master
            TEST_B[7:4] <= ACKN[3:0];
            TEST_B[11:8] <= RSPD[3:0];
            TEST_B[12] <= RST_ACKN;
            TEST_B[13] <= SET_VLDT;
            TEST_B[14] <= CLR_MSTR_ERR;
            TEST_B[15] <= CLR_ANY_DATA;
            TEST_C[0] <= EOP_WR;
            TEST_C[1] <= EOP_RD;
            TEST_C[2] <= VLDT_RD;
            TEST_C[3] <= VFF_MT;
            TEST_C[7:4] <= TXCTRL[3:0];
            TEST_C[15:8] <= 8'h00; // Sourced by Master
         end
      4'hC, 4'hD:
         begin
            TEST_A[5:0] <= VWRT_ST[5:0];
            TEST_A[7:6] <= EXD_ST[1:0];
            TEST_A[8] <= FF_RHOLD;
            TEST_A[9] <= FF_ODV;
            TEST_A[10] <= FF_HAS_DATA;
            TEST_A[14:11] <= RFUNCT;
            TEST_A[15] <= FF_READ;
            TEST_B <= 16'h0000;
            TEST_C <= 16'h0000;
         end
      default:       //SW2 == 4 is used by Interrupt Handler.
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
            TEST_C <= 16'h0000;
         end
   endcase
end

//////////////////////////////////////////////////////////////
//  Input mux for External or VME Direct FIFO's
//////////////////////////////////////////////////////////////

always @(posedge CLK)
begin
   if(V_DIRECT)
      begin
         MHBITS      <= VCP_DIN[17:16];
         DATA_IN     <= VCP_DIN[15:0];
         FF_RD_ERR   <= VCP_RD_ERR;
         FF_RHOLD    <= VCP_RHOLD;
         FF_ODV      <= VCP_ODV;
         FF_HAS_DATA <= VCP_HAS_DATA;
         FLSHD       <= VCP_FLSHD;
      end
   else
      begin
         MHBITS      <= EXF_DIN[17:16];
         DATA_IN     <= EXF_DIN[15:0];
         FF_RD_ERR   <= EXF_RD_ERR;
         FF_RHOLD    <= EXF_RHOLD;
         FF_ODV      <= EXF_ODV;
         FF_HAS_DATA <= EXF_HAS_DATA;
         FLSHD       <= EXF_FLSHD;
      end
end

always @(posedge CLK)
begin
   FF_ODV_D1 <= FF_ODV;
   FF_ODV_D2 <= FF_ODV_D1;
   FF_ODV_D3 <= FF_ODV_D2;
   FF_ODV_D4 <= FF_ODV_D3;
   FF_ODV_D5 <= FF_ODV_D4;
   FF_ODV_D6 <= FF_ODV_D5;
   AM_CAP    <= DAT_CAP;
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         PRIO    <= 0;
         ACK     <= 0;
         FF_WARN <= 0;
         FF_ERR  <= 0;
      end
   else
      if(CAP_ACK)
         begin
            PRIO    <= DATA_IN[0];
            ACK     <= DATA_IN[1];
            FF_WARN <= DATA_IN[2];
            FF_ERR  <= DATA_IN[3];
         end
      else
         begin
            PRIO    <= PRIO;
            ACK     <= ACK;
            FF_WARN <= FF_WARN;
            FF_ERR  <= FF_ERR;
         end
end


always @(DATA_IN or FILL_SRL or MHBITS or MAC_HDR_SRL or MHBITS_SRL)
begin  // mux for SRL input
   if(FILL_SRL)
      begin
         SRL_IN_DAT <= DATA_IN;
         SRL_IN_BITS <= MHBITS;
      end
   else
      begin
         SRL_IN_DAT <= MAC_HDR_SRL;
         SRL_IN_BITS <= MHBITS_SRL;
      end
end

macsrl  mh_srl(.clk(CLK),.ce(SRL_CE),.mhin(SRL_IN_BITS),.din(SRL_IN_DAT),.mhout(MHBITS_SRL),.dout(MAC_HDR_SRL));

//`define   VC_Norm_Pkt       3'd0  //Normal data packet
//`define   VC_INFO_Pkt       3'd1  //Informational packet
//`define   VC_WARN_Pkt       3'd2  //Warning packet
//`define   VC_ERR_Pkt        3'd3  //Error packet
//`define   VC_INTR_Pkt       3'd4  //Interrupt Status/ID packet
//`define   VC_INFO_NoMAC_Pkt 3'd5  //Informational packet not associated with the packet in progress
//`define   VC_WARN_NoMAC_Pkt 3'd6  //Warning packet not associated with the packet in progress
//`define   VC_ERR_NoMAC_Pkt  3'd7  //Error packet not associated with the packet in progress

always @(posedge CLK)
begin
   if(LOAD_DATA_REG)
      case(RSPD)
         `V_IH_Err,`V_IH_Warn:
            begin
               MER_REG <= 16'h0000;
               VSTATE_REG <= 16'h0000;
               DATA_REG[63:32] <= 32'h00000000;
               DATA_REG[31:28] <= `VME_IH;
               if(IH_ERR)
                  casex(IH_ERR_REG[5:4])
                     2'b01:
                        DATA_REG[27:0] <= {`HDR_Error,`VI_BERR_Slv,IH_ERR_REG[3:0],1'b0,IH_A,1'b0,IH_IRQ};
                     2'b1x:
                        DATA_REG[27:0] <= {`HDR_Error,`VI_BTO,IH_ERR_REG[3:0],1'b0,IH_A,1'b0,IH_IRQ};
                     default:
                        DATA_REG[27:0] <= {`HDR_Error,`G_No_Info,IH_ERR_REG[3:0],1'b0,IH_A,1'b0,IH_IRQ};
                  endcase
               else
                  DATA_REG[27:0] <= {`HDR_Warn,`VI_Msk_Chg,9'h000,IH_ERR_REG[6:0]};
               CUR_MSTR_DS <= CUR_MSTR_DS;
               CUR_IH_DS <= IH_DT_SZ;
               DATA_SIZE <= `LWord;
               PKT_TYP <= (IH_ERR) ? `VC_ERR_NoMAC_Pkt : `VC_WARN_NoMAC_Pkt;
            end
         `V_IH_Dav:
            begin
               MER_REG <= 16'h0000;
               VSTATE_REG <= 16'h0000;
               DATA_REG <= RSLT_DATA;
               CUR_MSTR_DS <= CUR_MSTR_DS;
               CUR_IH_DS <= IH_DT_SZ;
               DATA_SIZE <= IH_DT_SZ;
               PKT_TYP <= `VC_INTR_Pkt;
            end
         `V_Mstr_Err:
            begin
               casex(MSTR_ERR_REG[7:5])
                  3'b000:
                     MER_REG[9:0] <= `G_No_Info;
                  3'b001:
                     MER_REG[9:0] <= `VM_BERR_Slv;
                  3'b01x:
                     MER_REG[9:0] <= `VM_BTO;
                  3'b1xx:
                     MER_REG[9:0] <= `VM_Not_Sup;
                  default:
                     MER_REG[9:0] <= `G_No_Info;
               endcase
               MER_REG[15:10] <= {`VME_Master,`HDR_Error};
               VSTATE_REG <= {MSTR_ERR_REG[4:0],MSTR_AM,MSTR_WRT_RDB,MSTR_DATA_SZ,MSTR_TT};
               DATA_REG <= MSTR_FADDR;
               CUR_MSTR_DS <= MSTR_DATA_SZ;
               CUR_IH_DS <= CUR_IH_DS;
               DATA_SIZE <= MSTR_DATA_SZ;
               PKT_TYP <= `VC_ERR_Pkt;
            end
         `V_Mstr_Dav:
            begin
               MER_REG <= 16'h0000;
               VSTATE_REG <= 16'h0000;
               DATA_REG <= RSLT_DATA;
               CUR_MSTR_DS <= MSTR_DATA_SZ;
               CUR_IH_DS <= CUR_IH_DS;
               DATA_SIZE <= MSTR_DATA_SZ;
               PKT_TYP <= `VC_Norm_Pkt;
            end
         `V_Ctrl_Err:
            begin
               MER_REG <= 16'h0000;
               VSTATE_REG <= 16'h0000;
               CUR_MSTR_DS <= CUR_MSTR_DS;
               CUR_IH_DS <= CUR_IH_DS;
               PKT_TYP <= `VC_ERR_Pkt;
               if((CTRL_ERR_REG == `VC_MTEr_Fifo) || (CTRL_ERR_REG == `VC_RdEr_Units) || (CTRL_ERR_REG == `VC_RdEr_CtrlWrd))
                  begin
                     DATA_REG <= {48'h00000000,`VME_Ctrl,`HDR_Error,CTRL_ERR_REG};
                     DATA_SIZE <= `Word;
                  end
               else
                  begin
                     DATA_REG <= {32'h0000,`VME_Ctrl,`HDR_Error,CTRL_ERR_REG,ACCS_TYP,DLY_TYP,ADDR_SZ,WRT_RDB,DATA_SZ,TRNS_TYP};
                     DATA_SIZE <= `LWord;
                  end
            end
         `V_VRbk_Err:
            begin
               MER_REG <= 16'h0000;
               VSTATE_REG <= 16'h0000;
               DATA_REG <= {48'h00000000,`VME_Rdbk,`HDR_Error,RBK_ERR_REG};
               CUR_MSTR_DS <= CUR_MSTR_DS;
               CUR_IH_DS <= CUR_IH_DS;
               DATA_SIZE <= `Word;
               PKT_TYP <= (!VW_IDLE) ? `VC_ERR_Pkt : `VC_ERR_NoMAC_Pkt;
            end
         `V_Arb_Err:
            begin
               MER_REG <= 16'h0000;
               VSTATE_REG <= 16'h0000;
               DATA_REG <= {48'h00000000,`VME_Arb,`HDR_Error,`VA_BGTO};
               CUR_MSTR_DS <= CUR_MSTR_DS;
               CUR_IH_DS <= CUR_IH_DS;
               DATA_SIZE <= `Word;
               PKT_TYP <= (EXECUTE) ? `VC_ERR_Pkt : `VC_ERR_NoMAC_Pkt;
            end
         default:
            begin
               MER_REG <= 16'h0000;
               VSTATE_REG <= 16'h0000;
               DATA_REG <= 64'h0000000000000000;
               CUR_MSTR_DS <= CUR_MSTR_DS;
               CUR_IH_DS <= CUR_IH_DS;
               DATA_SIZE <= `Word;
               PKT_TYP <= `VC_ERR_Pkt;
            end
      endcase
   else if(PNSOP2)
      begin
         MER_REG <= MER_REG;
         VSTATE_REG <= VSTATE_REG;
         DATA_REG <= DATA_REG;
         CUR_MSTR_DS <= MSTR_DATA_SZ;
         CUR_IH_DS <= CUR_IH_DS;
         DATA_SIZE <= DATA_SIZE;
         PKT_TYP <= PKT_TYP;
      end
   else
      begin
         MER_REG <= MER_REG;
         VSTATE_REG <= VSTATE_REG;
         DATA_REG <= DATA_REG;
         CUR_MSTR_DS <= CUR_MSTR_DS;
         CUR_IH_DS <= CUR_IH_DS;
         DATA_SIZE <= DATA_SIZE;
         PKT_TYP <= PKT_TYP;
      end
end


always @(posedge CLK)
begin
   if(LOAD_TYPE)
      begin
         DLY_TYP <= DATA_IN[10:8];
         ADDR_SZ <= DATA_IN[7:5];
         WRT_RDB <= DATA_IN[4];
         DATA_SZ <= DATA_IN[3:2];
         TRNS_TYP <= DATA_IN[1:0];
         ACCS_TYP <= DATA_IN[15:11];
         UAM <= DATA_IN[15];
         PRG <= DATA_IN[11];
         if(DATA_IN[10:8] == 3'd0) // Delay type is zero
            case(DATA_IN[7:5])     // Address Size
               `ASZ_A16:           //A16        (1 word to read)
                  FTCH_WRDS <= 3'd1;
               `ASZ_A24,`ASZ_A32:  //A24,A32 (2 words to read)
                  FTCH_WRDS <= 3'd2;
               `ASZ_A40:           //A40        (3 words to read)
                  FTCH_WRDS <= 3'd3;
               `ASZ_A64:           //A64        (4 words to read)
                  FTCH_WRDS <= 3'd4;
               default:            // no addr to read
                  FTCH_WRDS <= 3'd0;
            endcase
         else  // Delay type is not zero
            case(DATA_IN[10:8])            // Delay Type
               `D4nsX16,`D16nsX16,`D16usX16: // (1 delay word to read)
                  FTCH_WRDS <= 3'd1;
               `D4nsX32,`D16nsX32,`D16usX32: // (2 words to read)
                  FTCH_WRDS <= 3'd2;
               default:                         // (nothing to read)
                  FTCH_WRDS <= 3'd0;
            endcase
      end
   else
      begin
         DLY_TYP <= DLY_TYP;
         ADDR_SZ <= ADDR_SZ;
         WRT_RDB <= WRT_RDB;
         DATA_SZ <= DATA_SZ;
         TRNS_TYP <= TRNS_TYP;
         ACCS_TYP <= ACCS_TYP;
         UAM <= UAM;
         PRG <= PRG;
         FTCH_WRDS <= FTCH_WRDS;
      end
end
always @(posedge CLK)
begin
   if(ADDR_PHASE && FFODV1 && UAM) 
      UD_AM <= DATA_IN[5:0];
   else
      UD_AM <= UD_AM;
end

always @(posedge CLK)
begin
   if(ADDR_PHASE && DAT_CAP) 
      casex ({ADDR_SZ,ACCS_TYP})
         `Usr_AM:     //AM = user defined (UD_AM)
            AD_MOD <= UD_AM;
         `CR_CSR_AM:  //AM = 2F
            AD_MOD <= 6'h2F;
         `A16LCK_AM:  //AM = 2C
            if(TRNS_TYP == `BLOCK || DATA_SZ == `Eight)
               AD_MOD <= 6'h02;
            else
               AD_MOD <= 6'h2C;
         `A16SUP_AM:  //AM = 2D
            if(TRNS_TYP == `BLOCK || DATA_SZ == `Eight)
               AD_MOD <= 6'h02;
            else
               AD_MOD <= 6'h2D;
         `A16non_AM:  //AM = 29
            if(TRNS_TYP == `BLOCK || DATA_SZ == `Eight)
               AD_MOD <= 6'h02;
            else
               AD_MOD <= 6'h29;
         `A24LCK_AM:  //AM = 32
            AD_MOD <= 6'h32;
         `A24SUP_AM:  //AM = 3C-3F
            if(TRNS_TYP == `BLOCK)
               if(DATA_SZ == `Eight)
                  AD_MOD <= 6'h3C;
               else
                  AD_MOD <= 6'h3F;
            else
               if(PRG)
                  AD_MOD <= 6'h3E;
               else
                  AD_MOD <= 6'h3D;
         `A24non_AM:  //AM = 38-3B
            if(TRNS_TYP == `BLOCK)
               if(DATA_SZ == `Eight)
                  AD_MOD <= 6'h38;
               else
                  AD_MOD <= 6'h3B;
            else
               if(PRG)
                  AD_MOD <= 6'h3A;
               else
                  AD_MOD <= 6'h39;
         `A32LCK_AM:  //AM = 05
            AD_MOD <= 6'h05;
         `A32SUP_AM:  //AM = 0C-0F
            if(TRNS_TYP == `BLOCK)
               if(DATA_SZ == `Eight)
                  AD_MOD <= 6'h0C;
               else
                  AD_MOD <= 6'h0F;
            else
               if(PRG)
                  AD_MOD <= 6'h0E;
               else
                  AD_MOD <= 6'h0D;
         `A32non_AM:  //AM = 08-0B
            if(TRNS_TYP == `BLOCK)
               if(DATA_SZ == `Eight)
                  AD_MOD <= 6'h08;
               else
                  AD_MOD <= 6'h0B;
            else
               if(PRG)
                  AD_MOD <= 6'h0A;
               else
                  AD_MOD <= 6'h09;
         `A40LCK_AM:  //AM = 35
            if(DATA_SZ == `Eight)
               AD_MOD <= 6'h02;
            else
               AD_MOD <= 6'h35;
         `A40_AM:     //AM = 34,37
            if(DATA_SZ == `Eight)
               AD_MOD <= 6'h02;
            else if(TRNS_TYP == `BLOCK)
               AD_MOD <= 6'h37;
            else
               AD_MOD <= 6'h34;
         `A64LCK_AM:  //AM = 04
            AD_MOD <= 6'h04;
         `A64_AM:     //AM = 00,01,03
            if(TRNS_TYP == `BLOCK)
               if(DATA_SZ == `Eight)
                  AD_MOD <= 6'h00;
               else
                  AD_MOD <= 6'h03;
            else
               AD_MOD <= 6'h01;
         default:
            AD_MOD <= 6'h02;
      endcase
   else
      AD_MOD <= AD_MOD;
end

always @(posedge CLK)
begin
   if(ADDR_PHASE)
      if(DLY_TYP == `No_Dly)
         case(ADDR_SZ)
            `ASZ_A16: //A16
               if(FFODV1&&!UAM || FFODV2&&UAM) 
                  FULL_ADDR <= {48'h000000000000,DATA_IN};
               else
                  FULL_ADDR <= FULL_ADDR;
            `ASZ_A24:        //A24
               if(FFODV1&&!UAM || FFODV2&&UAM)
                  FULL_ADDR <= {40'h0000000000,DATA_IN[7:0],FULL_ADDR[15:0]};
               else if(FFODV2&&!UAM || FFODV3&&UAM)
                  FULL_ADDR <= {40'h0000000000,FULL_ADDR[23:16],DATA_IN};
               else
                  FULL_ADDR <= FULL_ADDR;
            `ASZ_A32: //A32
               if(FFODV1&&!UAM || FFODV2&&UAM)
                  FULL_ADDR <= {32'h00000000,DATA_IN,FULL_ADDR[15:0]};
               else if(FFODV2&&!UAM || FFODV3&&UAM)
                  FULL_ADDR <= {32'h00000000,FULL_ADDR[31:16],DATA_IN};
               else
                  FULL_ADDR <= FULL_ADDR;
            `ASZ_A40:        //A40
               if(FFODV1&&!UAM || FFODV2&&UAM)
                  FULL_ADDR <= {24'h000000,DATA_IN[7:0],FULL_ADDR[31:0]};
               else if(FFODV2&&!UAM || FFODV3&&UAM)
                  FULL_ADDR <= {24'h000000,FULL_ADDR[39:32],DATA_IN[15:0],FULL_ADDR[15:0]};
               else if(FFODV3&&!UAM || FFODV4&&UAM)
                  FULL_ADDR <= {24'h000000,FULL_ADDR[39:16],DATA_IN};
               else
                  FULL_ADDR <= FULL_ADDR;
            `ASZ_A64:        //A64
               if(FFODV1&&!UAM || FFODV2&&UAM)
                  FULL_ADDR <= {DATA_IN,FULL_ADDR[47:0]};
               else if(FFODV2&&!UAM || FFODV3&&UAM)
                  FULL_ADDR <= {FULL_ADDR[63:48],DATA_IN,FULL_ADDR[31:0]};
               else if(FFODV3&&!UAM || FFODV4&&UAM)
                  FULL_ADDR <= {FULL_ADDR[63:32],DATA_IN,FULL_ADDR[15:0]};
               else if(FFODV4&&!UAM || FFODV5&&UAM)
                  FULL_ADDR <= {FULL_ADDR[63:16],DATA_IN};
               else
                  FULL_ADDR <= FULL_ADDR;
            default:                  // no addr to read
               FULL_ADDR <= FULL_ADDR;
         endcase
      else
         case(DLY_TYP)
            `D4nsX16,`D16nsX16,`D16usX16: //16 Bit range
               if(FFODV1)
                  FULL_ADDR <= {48'h000000000000,DATA_IN};
               else
                  FULL_ADDR <= FULL_ADDR;
            `D4nsX32,`D16nsX32,`D16usX32:        //32 Bit range
               if(FFODV1)
                  FULL_ADDR <= {32'h00000000,DATA_IN,FULL_ADDR[15:0]};
               else if(FFODV2)
                  FULL_ADDR <= {32'h00000000,FULL_ADDR[31:16],DATA_IN};
               else
                  FULL_ADDR <= FULL_ADDR;
            default:                  // no addr to read
               FULL_ADDR <= FULL_ADDR;
         endcase
   else
      FULL_ADDR <= FULL_ADDR;
end
always @(posedge CLK)
begin
   if(DATA_PHASE)
      case(DATA_SZ)
         `Byte:
            if(FFODV1)
               FULL_DATA <= {56'h00000000000000,DATA_IN[7:0]};
            else
               FULL_DATA <= FULL_DATA;
         `Word:
            if(FFODV1)
               FULL_DATA <= {48'h000000000000,DATA_IN};
            else
               FULL_DATA <= FULL_DATA;
         `LWord:
            if(FFODV1)
               FULL_DATA <= {32'h00000000,DATA_IN,FULL_DATA[15:0]};
            else if(FFODV2)
               FULL_DATA <= {32'h00000000,FULL_DATA[31:16],DATA_IN};
            else
               FULL_DATA <= FULL_DATA;
         `Eight:
            if(FFODV1)
               FULL_DATA <= {DATA_IN,FULL_DATA[47:0]};
            else if(FFODV2)
               FULL_DATA <= {FULL_DATA[63:48],DATA_IN,FULL_DATA[31:0]};
            else if(FFODV3)
               FULL_DATA <= {FULL_DATA[63:32],DATA_IN,FULL_DATA[15:0]};
            else if(FFODV4)
               FULL_DATA <= {FULL_DATA[63:16],DATA_IN};
            else
               FULL_DATA <= FULL_DATA;
         default:
               FULL_DATA <= FULL_DATA;
      endcase
   else
      FULL_DATA <= FULL_DATA;
end

always @(posedge CLK or posedge RST)
begin: ExFF_Dir_Sel_FSM
   if(RST)
      EXD_ST <= `ExD_Idle;
   else
      case(EXD_ST)
         `ExD_Idle:
            if(VCP_HAS_DATA)
               EXD_ST <= `ExD_Dir_Cmds;
            else if(EXF_HAS_DATA)
               EXD_ST <= `ExD_ExFF_Wait;
            else
               EXD_ST <= `ExD_Idle;
         `ExD_Dir_Cmds:
            if(VW_IDLE && !VCP_HAS_DATA && !EXF_HAS_DATA)
               EXD_ST <= `ExD_Idle;
            else if(VW_IDLE && !VCP_HAS_DATA && EXF_HAS_DATA)
               EXD_ST <= `ExD_ExFF_Wait;
            else
               EXD_ST <= `ExD_Dir_Cmds;
         `ExD_ExFF_Wait:
            if(!VW_IDLE)
               EXD_ST <= `ExD_ExFF_Cmds;
            else
               EXD_ST <= `ExD_ExFF_Wait;
         `ExD_ExFF_Cmds:
            if(VW_IDLE)
               EXD_ST <= `ExD_Idle;
            else
               EXD_ST <= `ExD_ExFF_Cmds;
         default:
            EXD_ST <= `ExD_Idle;
      endcase
end
    
always @(posedge CLK or posedge RST)
begin: VME_WRT_CTRL_FSM
   if(RST)
      VWRT_ST <= `VW_idle;
   else
      case(VWRT_ST)
         `VW_idle:
            begin
               if(FF_HAS_DATA)
                  VWRT_ST <= `Trns_Pkt_Inf;
               else if(PREP4SHTDWN)
                  VWRT_ST <= `VW_Rdy4Shtdwn;
               else 
                  VWRT_ST <= `VW_idle;
            end
         `Trns_Pkt_Inf:
            begin
               if(TPI_DONE)
                  VWRT_ST <= `Rd_FIFO;
               else 
                  VWRT_ST <= `Trns_Pkt_Inf;
            end
         `Rd_FIFO:
            begin
               if(FF_RD_ERR)
                  VWRT_ST <= `MT_Err_FIFO;
               else if(!FF_RHOLD)
                  VWRT_ST <= `Rd_units;
               else 
                  VWRT_ST <= `Rd_FIFO;
            end
         `Rd_units:
            VWRT_ST <= `Ld_units;
         `Ld_units:
            begin
               if(FF_RD_ERR)
                  VWRT_ST <= `Rd_Err_Units;
               else if(FF_ODV)
                  VWRT_ST <= `Rd_type;
               else 
                  VWRT_ST <= `Ld_units;
            end
         `Rd_type:
            VWRT_ST <= `Ld_type;
         `Ld_type:
            begin
               if(FF_RD_ERR)
                  VWRT_ST <= `Rd_Err_CtrlWrd;
               else if(DAT_CAP)
                  if(BAD_DLY)
                     VWRT_ST <= `Unkn_Dly_Typ;
                  else if(UAM && (DLY_TYP == `No_Dly))
                     VWRT_ST <= `Rd_UAM;
                  else
                     case(FTCH_WRDS)
                        3'd1:          //(1 word to read)
                           VWRT_ST <= `Rd_Wrd_1a;
                        3'd2:          //(2 words to read)
                           VWRT_ST <= `Rd_Wrd_1b;
                        3'd3:          //(3 words to read)
                           VWRT_ST <= `Rd_Wrd_1c;
                        3'd4:          //(4 words to read)
                           VWRT_ST <= `Rd_Wrd_1d;
                        default:       // no addr to read
                           VWRT_ST <= `Unkn_Addr_Sz;
                     endcase
               else 
                  VWRT_ST <= `Ld_type;
            end
         `Rd_UAM:
            case(FTCH_WRDS)
               3'd1:          //(1 word to read)
                  VWRT_ST <= `Rd_Wrd_1a;
               3'd2:          //(2 words to read)
                  VWRT_ST <= `Rd_Wrd_1b;
               3'd3:          //(3 words to read)
                  VWRT_ST <= `Rd_Wrd_1c;
               3'd4:          //(4 words to read)
                  VWRT_ST <= `Rd_Wrd_1d;
               default:       // no addr to read
                  VWRT_ST <= `Unkn_Addr_Sz;
            endcase
         `Rd_Wrd_1a:
            VWRT_ST <= `Ld_Add_Pause;
         `Rd_Wrd_1b:
            VWRT_ST <= `Rd_Wrd_2b;
         `Rd_Wrd_2b:
            VWRT_ST <= `Ld_Add_Pause;
         `Rd_Wrd_1c:
            VWRT_ST <= `Rd_Wrd_2c;
         `Rd_Wrd_2c:
            VWRT_ST <= `Rd_Wrd_3c;
         `Rd_Wrd_3c:
            VWRT_ST <= `Ld_Add_Pause;
         `Rd_Wrd_1d:
            VWRT_ST <= `Rd_Wrd_2d;
         `Rd_Wrd_2d:
            VWRT_ST <= `Rd_Wrd_3d;
         `Rd_Wrd_3d:
            if(FF_RD_ERR)
               VWRT_ST <= `Rd_Err_Addr;
            else
               VWRT_ST <= `Rd_Wrd_4d;
         `Rd_Wrd_4d:
            if(FF_RD_ERR)
               VWRT_ST <= `Rd_Err_Addr;
            else
               VWRT_ST <= `Ld_Add_Pause;
         `Ld_Add_Pause:
            begin
               if(FF_RD_ERR)
                  VWRT_ST <= `Rd_Err_Addr;
               else if(AM_CAP)
                  if((AD_MOD == 6'h02) && (DLY_TYP == `No_Dly))
                     VWRT_ST <= `Incomp_Opt;
                  else if((TRNS_TYP == `BLOCK) && (DLY_TYP == `No_Dly))
                     VWRT_ST <= `Rd_Dcnt;
                  else
                     VWRT_ST <= `Continue;
               else 
                  VWRT_ST <= `Ld_Add_Pause;
            end
         `Rd_Dcnt:
            VWRT_ST <= `Ld_Dcnt;
         `Ld_Dcnt:
            begin
               if(FF_RD_ERR)
                  VWRT_ST <= `Rd_Err_Dcnt;
               else if(FF_ODV)
                  VWRT_ST <= `Continue;
               else 
                  VWRT_ST <= `Ld_Dcnt;
            end
         `Continue:
            begin
               if(WRT_RDB && (DLY_TYP == `No_Dly))
                  case(DATA_SZ)
                     `LWord:          //D32 Quad byte (2 words to read)
                        VWRT_ST <= `Rd_Dat_1b;
                     `Eight:          //D64        Eight bytes (4 words to read)
                        VWRT_ST <= `Rd_Dat_1d;
                     default:         // D08, & D16; Byte, & Word (1 word to read)
                        VWRT_ST <= `Rd_Dat_1a;
                  endcase
               else 
                  VWRT_ST <= `VPause;
            end
         `Rd_Dat_1a:
            if(MSTR_ERR && BIP)
               if(LAST_WORD)
                  VWRT_ST <= `Clr_Mstr_Err1;
               else
                  VWRT_ST <= `Dec_Dcnt;
            else
               VWRT_ST <= `Ld_Dat_Pause;
         `Rd_Dat_1b:
            VWRT_ST <= `Rd_Dat_2b;
         `Rd_Dat_2b:
            if(MSTR_ERR && BIP)
               if(LAST_WORD)
                  VWRT_ST <= `Clr_Mstr_Err1;
               else
                  VWRT_ST <= `Dec_Dcnt;
            else
               VWRT_ST <= `Ld_Dat_Pause;
         `Rd_Dat_1d:
            VWRT_ST <= `Rd_Dat_2d;
         `Rd_Dat_2d:
            VWRT_ST <= `Rd_Dat_3d;
         `Rd_Dat_3d:
            if(FF_RD_ERR)
               VWRT_ST <= `Rd_Err_Data;
            else
               VWRT_ST <= `Rd_Dat_4d;
         `Rd_Dat_4d:
            if(FF_RD_ERR)
               VWRT_ST <= `Rd_Err_Data;
            else if(MSTR_ERR && BIP)
               if(LAST_WORD)
                  VWRT_ST <= `Clr_Mstr_Err1;
               else
                  VWRT_ST <= `Dec_Dcnt;
            else
               VWRT_ST <= `Ld_Dat_Pause;
         `Ld_Dat_Pause:
            begin
               if(FF_RD_ERR)
                  VWRT_ST <= `Rd_Err_Data;
               else if(DAT_CAP)
                  VWRT_ST <= `VPause;
               else 
                  VWRT_ST <= `Ld_Dat_Pause;
            end
         `VPause:
            begin
               if(MSTR_ERR)
                  if(BIP && LAST_WORD)
                     VWRT_ST <= `Clr_Mstr_Err1;
                  else if(BIP && !LAST_WORD)
                     VWRT_ST <= `Dec_Dcnt;
                  else 
                     VWRT_ST <= `Clr_Mstr_Err2;
               else
                  if((TRNS_TYP == `BLOCK) && (DLY_TYP == `No_Dly) && ((!MSTR_BUSY && !BIP) || (BIP && NEXT_WRD)))
                     VWRT_ST <= `Execute_Blk;
                  else if(!MSTR_BUSY && ((TRNS_TYP != `BLOCK) || (DLY_TYP != `No_Dly)))
                     VWRT_ST <= `Execute;
                  else 
                     VWRT_ST <= `VPause;
            end
         `Execute_Blk:
            begin
               if(MSTR_BUSY && !NEXT_WRD && !LAST_WORD)
                  VWRT_ST <= `Dec_Dcnt;
               else if(MSTR_BUSY && !NEXT_WRD && LAST_WORD)
                  VWRT_ST <= `Dec_Units;
               else if(ARB_ERR)
                  VWRT_ST <= `Flush2BOD;
               else 
                  VWRT_ST <= `Execute_Blk;
            end
         `Dec_Dcnt:
            VWRT_ST <= `Continue;
         `Execute:
            begin
               if(MSTR_BUSY)
                  VWRT_ST <= `Dec_Units;
               else if(ARB_ERR)
                  VWRT_ST <= `Flush2BOD;
               else 
                  VWRT_ST <= `Execute;
            end
         `Dec_Units:
            begin
               if(LAST_UNIT)
                  VWRT_ST <= `Wait4VRd_Idle;
               else 
                  VWRT_ST <= `Rd_type;
            end
         `Wait4VRd_Idle:
            begin
               if(!MSTR_BUSY && VRD_IDLE)
                  if(ANY_DATA || ACK)
                     VWRT_ST <= `Send_Data;
                  else
                     VWRT_ST <= `VW_idle;
               else 
                  VWRT_ST <= `Wait4VRd_Idle;
            end
         `Send_Data:
            begin
               if(SENT)
                  VWRT_ST <= `VW_Hnd_Shk;
               else 
                  VWRT_ST <= `Send_Data;
            end
         `Unkn_Addr_Sz:
            VWRT_ST <= `Rpt_Vctrl_Err;
         `Unkn_Dly_Typ:
            VWRT_ST <= `Rpt_Vctrl_Err;
         `Incomp_Opt:
            VWRT_ST <= `Rpt_Vctrl_Err;
         `Rpt_Vctrl_Err:
            if(ACKN == `V_Ctrl_Err)
               VWRT_ST <= `Flush2BOD;
            else
               VWRT_ST <= `Rpt_Vctrl_Err;
         `Flush2BOD:
            if(FLSHD)
               VWRT_ST <= `Wait4VRd_Idle;
            else
               VWRT_ST <= `Flush2BOD;
         `Clr_Mstr_Err1:
            if(!MSTR_BUSY)
               VWRT_ST <= `Dec_Units;
            else
               VWRT_ST <= `Clr_Mstr_Err1;
         `Clr_Mstr_Err2:
            if(!MSTR_BUSY)
               if((TRNS_TYP == `BLOCK) && (DLY_TYP == `No_Dly))
                  VWRT_ST <= `Execute_Blk;
               else
                  VWRT_ST <= `Execute;
            else
               VWRT_ST <= `Clr_Mstr_Err2;
         `MT_Err_FIFO:
            VWRT_ST <= `Rpt_Vctrl_Err;
         `Rd_Err_Units:
            VWRT_ST <= `Rpt_Vctrl_Err;
         `Rd_Err_CtrlWrd:
            VWRT_ST <= `Rpt_Vctrl_Err;
         `Rd_Err_Addr:
            VWRT_ST <= `Rpt_Vctrl_Err;
         `Rd_Err_Dcnt:
            VWRT_ST <= `Rpt_Vctrl_Err;
         `Rd_Err_Data:
            VWRT_ST <= `Rpt_Vctrl_Err;
         `VW_Hnd_Shk:
            if(VR_HNDSHK)
               VWRT_ST <= `VW_idle;
            else
               VWRT_ST <= `VW_Hnd_Shk;
         `VW_Rdy4Shtdwn:
            VWRT_ST <= `VW_Rdy4Shtdwn;
         default:
            VWRT_ST <= `VW_idle;
      endcase
end


always @(VWRT_ST)
begin
   case (VWRT_ST)
      `VW_idle,`Wait4VRd_Idle,`Send_Data,`VW_Hnd_Shk,`VW_Rdy4Shtdwn:
         RFUNCT <= `RNoOp;
      `Trns_Pkt_Inf:
         RFUNCT <= `Read_MHVF;
      `Flush2BOD:
         RFUNCT <= `Flush_FF;
      default:
         RFUNCT <= `Rd_FF;
   endcase
end

always @(VWRT_ST or MSTR_ERR)
begin
   case (VWRT_ST)
      `Rpt_Vctrl_Err,`Wait4VRd_Idle:
         CLR_MSTR_ERR <= MSTR_ERR;
      `Clr_Mstr_Err1,`Clr_Mstr_Err2:
         CLR_MSTR_ERR <= 1;
      default:
         CLR_MSTR_ERR <= 0;
   endcase
end


always @(VWRT_ST)
begin
   case (VWRT_ST)
      `Rd_units,`Rd_type,`Rd_Dcnt:
         begin
            FF_READ <= 1;
            ADDR_PHASE <= 0;
            DATA_PHASE <= 0;
         end
      `Rd_UAM,`Rd_Wrd_1a,`Rd_Wrd_1b,`Rd_Wrd_2b,`Rd_Wrd_1c,`Rd_Wrd_2c,`Rd_Wrd_3c,`Rd_Wrd_1d,`Rd_Wrd_2d,`Rd_Wrd_3d,`Rd_Wrd_4d:
         begin
            FF_READ <= 1;
            ADDR_PHASE <= 1;
            DATA_PHASE <= 0;
         end
      `Ld_Add_Pause:
         begin
            FF_READ <= 0;
            ADDR_PHASE <= 1;
            DATA_PHASE <= 0;
         end
      `Rd_Dat_1a,`Rd_Dat_1b,`Rd_Dat_2b,`Rd_Dat_1d,`Rd_Dat_2d,`Rd_Dat_3d,`Rd_Dat_4d:
         begin
            FF_READ <= 1;
            ADDR_PHASE <= 0;
            DATA_PHASE <= 1;
         end
      `Ld_Dat_Pause:
         begin
            FF_READ <= 0;
            ADDR_PHASE <= 0;
            DATA_PHASE <= 1;
         end
      default:  
         begin
            FF_READ <= 0;
            ADDR_PHASE <= 0;
            DATA_PHASE <= 0;
         end
   endcase
end


always @(posedge CLK)
begin
   if(RST)
      UNITS <= 0;
   else
      if (LOAD_UNITS)
         UNITS <= DATA_IN;
      else if (DEC_UNITS)
         UNITS <= UNITS -1;
      else
         UNITS <= UNITS;
end
always @(posedge CLK)
begin
   if(RST)
      DCNT <= 16'h0001;
   else
      if (LOAD_DCNT)
         DCNT <= DATA_IN;
      else if (DEC_DCNT)
         DCNT <= DCNT -1;
      else
         DCNT <= DCNT;
end
always @(posedge CLK)
begin
   if (RST || RST_BIP)
      BIP <= 0;
   else if(SET_BIP)
      BIP <= 1;
   else
      BIP <= BIP;
end
always @(posedge CLK)
begin
   if (RST || CLR_ANY_DATA)
      CIF <= 0;
   else if(SET_CIF)
      CIF <= 1;
   else
      CIF <= CIF;
end

always @(posedge CLK)
begin         // VME Controller Error Register
   if (ACKN == `V_Ctrl_Err)
      CTRL_ERR_REG <= `G_No_Info;
   else
      case (VWRT_ST)
         `Unkn_Addr_Sz:
            CTRL_ERR_REG <= `VC_Unkn_Addr; 
         `Unkn_Dly_Typ:
            CTRL_ERR_REG <= `VC_Unkn_Dly; 
         `Incomp_Opt:
            CTRL_ERR_REG <= `VC_Incomp_Opt; 
         `MT_Err_FIFO:
            CTRL_ERR_REG <= `VC_MTEr_Fifo; 
         `Rd_Err_Units:
            CTRL_ERR_REG <= `VC_RdEr_Units; 
         `Rd_Err_CtrlWrd:
            CTRL_ERR_REG <= `VC_RdEr_CtrlWrd; 
         `Rd_Err_Addr:
            CTRL_ERR_REG <= `VC_RdEr_Addr; 
         `Rd_Err_Dcnt:
            CTRL_ERR_REG <= `VC_RdEr_Dcnt; 
         `Rd_Err_Data:
            CTRL_ERR_REG <= `VC_RdEr_Data; 
         default:
            CTRL_ERR_REG <= CTRL_ERR_REG;
      endcase
end

always @(posedge CLK)
begin         // VME Readback FIFO Error Register
   if (ACKN == `V_VRbk_Err)
      RBK_ERR_REG <= `G_No_Info;
   else
      case (VFFR_ST)
         `VR_Err_SOP:
            RBK_ERR_REG <= `VR_Mis_SOP; 
         `VR_Err_Typ:
            RBK_ERR_REG <= `VR_Wrng_Typ; 
         `VR_Err_TMO:
            RBK_ERR_REG <= `VR_Rd_TMO; 
         default:
            RBK_ERR_REG <= RBK_ERR_REG;
      endcase
end


//////////////////////////////////////////////////////////////
//  Output mux for External or VME Direct FIFO's
//////////////////////////////////////////////////////////////

always @(V_DIRECT or RFUNCT or FF_READ)
begin
   if(V_DIRECT)
      begin
         VCP_RFUNCT <= RFUNCT;
         VCP_READ   <= FF_READ;
         EXF_RFUNCT <= 4'h0;
         EXF_READ   <= 1'b0;
      end
   else
      begin
         VCP_RFUNCT <= 4'h0;
         VCP_READ   <= 1'b0;
         EXF_RFUNCT <= RFUNCT;
         EXF_READ   <= FF_READ;
      end
end
///////////////////////////////////////////////////////////////
//                                                           //
// VME Read control                                          //
//                                                           //
///////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////
//                                                           //
// Read FIFO write control                                   //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin
   if(RST)
      begin
         RSPD <= `V_No_Req;
         ACKN_MSK <= 8'b0000000;
      end
   else
      if(SET_VLDT)
         casex ({IH_ERR, MSTR_ERR, CTRL_ERR, VFF_ERR, ARB_ERR, IH_DAV, MSTR_DAV, IH_WARN})
            8'b1xxxxxxx:
               begin
                  RSPD <= `V_IH_Err;
                  ACKN_MSK <= 8'b10000000;
               end
            8'b01xxxxxx:
               begin
                  RSPD <= `V_Mstr_Err;
                  ACKN_MSK <= 8'b01000000;
               end
            8'b001xxxxx:
               begin
                  RSPD <= `V_Ctrl_Err;
                  ACKN_MSK <= 8'b00100000;
               end
            8'b0001xxxx:
               begin
                  RSPD <= `V_VRbk_Err;
                  ACKN_MSK <= 8'b00010000;
               end
            8'b00001xxx:
               begin
                  RSPD <= `V_Arb_Err;
                  ACKN_MSK <= 8'b00001000;
               end
            8'b000001xx:
               begin
                  RSPD <= `V_IH_Dav;
                  ACKN_MSK <= 8'b00000100;
               end
            8'b0000001x:
               begin
                  RSPD <= `V_Mstr_Dav;
                  ACKN_MSK <= 8'b00000010;
               end
            8'b00000001:
               begin
                  RSPD <= `V_IH_Warn;
                  ACKN_MSK <= 8'b00000001;
               end
            default:
               begin
                  RSPD <= `V_No_Req;
                  ACKN_MSK <= 8'b00000000;
               end
         endcase
      else if(VRD_IDLE)
         begin
            RSPD <= `V_No_Req;
            ACKN_MSK <= 8'b00000000;
         end
      else
         begin
            RSPD <= RSPD;
            ACKN_MSK <= ACKN_MSK;
         end
end

always @(posedge CLK or posedge RST)
begin
   if(RST)
      ACKN <= `V_No_Req;
   else
      if(LD_ACKN)
         ACKN <= RSPD;
      else if(RST_ACKN)
         ACKN <= `V_No_Req;
      else
         ACKN <= ACKN;
end

always @(posedge CLK or posedge RST)
begin: VME_RD_FFWRT_CTRL_FSM
   if(RST)
      VFFW_ST <= `VRd_Idle;
   else
      case(VFFW_ST)
         `VRd_Idle:
            begin
               if(ANY_DAV || (ANY_ERR && (MSG_LVL > 2'h0)) || (ANY_WRN && (MSG_LVL > 2'h1)) || (ANY_INF && (MSG_LVL == 2'h3)))
                  VFFW_ST <= `Ld_Drbk;
               else if(ANY_MSG)
                  VFFW_ST <= `Ackn_No_Wrt;
               else if(SEND && DAV_SOP)
                  VFFW_ST <= `Push_EOP;
               else if(SEND && !DAV_SOP)
                  VFFW_ST <= `Push_N_SOP2;
               else 
                  VFFW_ST <= `VRd_Idle;
            end
         `Ld_Drbk:
            begin
               if(MSTR_WRT_RDB==0 && MSTR_ERR)
                  if(DAV_SOP)
                     case (MSTR_DATA_SZ)
                        `Byte:
                           VFFW_ST <= `Dummy8;
                        `Word:
                           VFFW_ST <= `Dummy16;
                        `LWord:
                           VFFW_ST <= `Dummy32A;
                        `Eight:
                           VFFW_ST <= `Dummy64A;
                        default:
                           VFFW_ST <= `Dummy16;
                     endcase
                  else
                     VFFW_ST <= `Push_N_SOP;
               else if(MSTR_DAV && DAV_SOP)
                  VFFW_ST <= `Ackn;
               else
                  VFFW_ST <= `Push_SOP;
            end
         `Push_N_SOP:
            begin
               case (MSTR_DATA_SZ)
                  `Byte:
                     VFFW_ST <= `Dummy8;
                  `Word:
                     VFFW_ST <= `Dummy16;
                  `LWord:
                     VFFW_ST <= `Dummy32A;
                  `Eight:
                     VFFW_ST <= `Dummy64A;
                  default:
                     VFFW_ST <= `Dummy16;
               endcase
            end
         `Dummy8:
            VFFW_ST <= `Push_SOP;
         `Dummy16:
            VFFW_ST <= `Push_SOP;
         `Dummy32A:
            VFFW_ST <= `Dummy32B;
         `Dummy32B:
            VFFW_ST <= `Push_SOP;
         `Dummy64A:
            VFFW_ST <= `Dummy64B;
         `Dummy64B:
            VFFW_ST <= `Dummy64C;
         `Dummy64C:
            VFFW_ST <= `Dummy64D;
         `Dummy64D:
            VFFW_ST <= `Push_SOP;
         `Push_SOP:
            VFFW_ST <= `Ackn;
         `Ackn:
            if(RSPD == `V_Mstr_Err)
               VFFW_ST <= `Push_MER;
            else
               case(DATA_SIZE)
                  `Byte:
                     VFFW_ST <= `Push8;
                  `Word:
                     VFFW_ST <= `Push16;
                  `LWord:
                     VFFW_ST <= `Push32A;
                  `Eight:
                     VFFW_ST <= `Push64A;
                  default:
                     VFFW_ST <= `Push16;
               endcase
         `Ackn_No_Wrt:
            VFFW_ST <= `Rd_Cmplt;
         `Push8:
            VFFW_ST <= `Rd_Cmplt;
         `Push16:
            VFFW_ST <= `Rd_Cmplt;
         `Push32A:
            VFFW_ST <= `Push32B;
         `Push32B:
            VFFW_ST <= `Rd_Cmplt;
         `Push64A:
            VFFW_ST <= `Push64B;
         `Push64B:
            VFFW_ST <= `Push64C;
         `Push64C:
            VFFW_ST <= `Push64D;
         `Push64D:
            VFFW_ST <= `Rd_Cmplt;
         `Push_MER:
            VFFW_ST <= `Push_VState;
         `Push_VState:
            VFFW_ST <= `Push64A;
         `Rd_Cmplt:
            if(ACKN == `V_No_Req)
               VFFW_ST <= `VRd_Idle;
            else
               VFFW_ST <= `Rd_Cmplt;
         `Push_N_SOP2:
            VFFW_ST <= `Push_EOP;
         `Push_EOP:
            VFFW_ST <= `Data_Pkt_Sent;
         `Data_Pkt_Sent:
            if(!SEND)
               VFFW_ST <= `VRd_Idle;
            else
               VFFW_ST <= `Data_Pkt_Sent;
         default:
            VFFW_ST <= `VRd_Idle;
      endcase
end

always @(posedge CLK)
begin
   if (RST || CLR_DAV_SOP)
      DAV_SOP <= 0;
   else if(SET_DAV_SOP)
      DAV_SOP <= 1;
   else
      DAV_SOP <= DAV_SOP;
   if (RST || RD_CMPLT)
      VME_EOP <= 0;
   else if(SET_EOP)
      VME_EOP <= 1;
   else
      VME_EOP <= VME_EOP;
   if (RST || RD_CMPLT)
      VLDT <= 0;
   else if(SET_VLDT)
      VLDT <= 1;
   else
      VLDT <= VLDT;
   if (CLR_ANY_DATA)
      ANY_DATA <= 0;
   else if(PUSH && (PKT_TYP_WR == `VC_Norm_Pkt) && !SOP_WR && !EOP_WR)
      ANY_DATA <= 1;
   else
      ANY_DATA <= ANY_DATA;
end

always @(VFFW_ST)
begin
   case (VFFW_ST)
      `Dummy8,`Dummy16,`Dummy32A,`Dummy32B,`Dummy64A,`Dummy64B,`Dummy64C,`Dummy64D,
      `Push_MER,`Push_VState,`Push_EOP,`Push_SOP,`Push_N_SOP,`Push_N_SOP2,
      `Push8,`Push16,`Push32A,`Push32B,`Push64A,`Push64B,`Push64C,`Push64D:
         PUSH <= 1;
      default:
         PUSH <= 0;
   endcase
end
always @(VFFW_ST)
begin
   case (VFFW_ST)
      `Push_SOP,`Push_N_SOP,`Push_N_SOP2:
         SOP_WR <= 1;
      default:
         SOP_WR <= 0;
   endcase
end
always @(VFFW_ST or MSTR_DAV)
begin
   case (VFFW_ST)
      `Push_SOP:
         SET_DAV_SOP <= MSTR_DAV;
      `Push_N_SOP:
         SET_DAV_SOP <= 1;
      default:
         SET_DAV_SOP <= 0;
   endcase
end
always @(VFFW_ST or VME_EOP or RSPD)
begin
   case (VFFW_ST)
      `Push8,`Push16,`Push32B,`Push64D:
         EOP_WR <= VME_EOP;
      `Push_VState:
         EOP_WR <= VME_EOP && (RSPD == `V_Ctrl_Err);
      `Push_EOP:
         EOP_WR <= 1;
      default:
         EOP_WR <= 0;
   endcase
end

always @(VFFW_ST or PKT_TYP)
begin
   case (VFFW_ST)
      `Push_EOP,`Push_N_SOP,`Push_N_SOP2,
      `Dummy8,`Dummy16,`Dummy32A,`Dummy32B,`Dummy64A,`Dummy64B,`Dummy64C,`Dummy64D:
         PKT_TYP_WR <= `VC_Norm_Pkt;
      `Push_MER,`Push_VState,`Push_SOP,
      `Push8,`Push16,`Push32A,`Push32B,`Push64A,`Push64B,`Push64C,`Push64D:
         PKT_TYP_WR <= PKT_TYP;
      default:
         PKT_TYP_WR <= PKT_TYP;
   endcase
end

always @(VFFW_ST or DATA_REG or MER_REG or VSTATE_REG)
begin
   case (VFFW_ST)
      `Dummy8:
         VFF_IN <= 16'h00BD;
      `Dummy16:
         VFF_IN <= 16'hBAAD;
      `Dummy32A:
         VFF_IN <= 16'hBAAD;
      `Dummy32B:
         VFF_IN <= 16'hBEEF;
      `Dummy64A:
         VFF_IN <= 16'hBADC;
      `Dummy64B:
         VFF_IN <= 16'h0DEC;
      `Dummy64C:
         VFF_IN <= 16'h0FFE;
      `Dummy64D:
         VFF_IN <= 16'hEBAD;
      `Push8:
         VFF_IN <= {8'h00,DATA_REG[7:0]};
      `Push16,`Push32B,`Push64D:
         VFF_IN <= DATA_REG[15:0];
      `Push32A,`Push64C:
         VFF_IN <= DATA_REG[31:16];
      `Push64B:
         VFF_IN <= DATA_REG[47:32];
      `Push64A:
         VFF_IN <= DATA_REG[63:48];
      `Push_MER:
         VFF_IN <= MER_REG;
      `Push_VState:
         VFF_IN <= VSTATE_REG;
      default:
         VFF_IN <= DATA_REG[15:0];
   endcase
end


///////////////////////////////////////////////////////////////
//                                                           //
// FIFO for Readback data from VME                           //
//                                                           //
///////////////////////////////////////////////////////////////
parameter VME_fifo_p2depth = 4;
defparam VME_fifo.p2depth = VME_fifo_p2depth; // Default depth in words expressed as a power of 2 (ie 2^6 = 64)
defparam VME_fifo.width = 22; // Default width in bits
defparam VME_fifo.almostmt = 2; // 
defparam VME_fifo.almostfull = (1<<VME_fifo_p2depth) - 4; // 
 
// Adding three bits for data type 
//`define   VC_Norm_Pkt       3'd0  //Normal data packet
//`define   VC_INFO_Pkt       3'd1  //Informational packet
//`define   VC_WARN_Pkt       3'd2  //Warning packet
//`define   VC_ERR_Pkt        3'd3  //Error packet
//`define   VC_INTR_Pkt       3'd4  //Interrupt Status/ID packet
//`define   VC_INFO_NoMAC_Pkt 3'd5  //Informational packet not associated with the packet in progress
//`define   VC_WARN_NoMAC_Pkt 3'd6  //Warning packet not associated with the packet in progress
//`define   VC_ERR_NoMAC_Pkt  3'd7  //Error packet not associated with the packet in progress
//
fifo_dpXn_dst VME_fifo(.clk(CLK),.rst(RST),.push(PUSH),.pop(POP),
                       .mt(VFF_MT),.full(VFF_FULL),.amt(VFF_AMT),.af(VFF_AF),
                       .wterr(VFF_WTERR),.rderr(VFF_RDERR),
                       .din({PKT_TYP_WR,SOP_WR,EOP_WR,(VLDT&&!SOP_WR),VFF_IN}),
                       .dout({PKT_TYP_RD,SOP_RD,EOP_RD,VLDT_RD,VFF_OUT}),
                       .cnt(VFF_CNT));

///////////////////////////////////////////////////////////////
//                                                           //
// Readback Timer (approximatly 2mS -- 2x max BTO            //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or negedge VFF_MT)
begin
   if(!VFF_MT)
      RBK_TIMER <= 17'h0000;
   else
      if(VR_POP_VFF && VFF_MT)
         RBK_TIMER <= RBK_TIMER + 1;
      else
         RBK_TIMER <= RBK_TIMER;   
end

///////////////////////////////////////////////////////////////
//                                                           //
// Read FIFO read control                                    //
//                                                           //
///////////////////////////////////////////////////////////////

always @(posedge CLK or posedge RST)
begin: VME_RD_FFRD_CTRL_FSM
   if(RST)
      VFFR_ST <= `VR_Idle;
   else
      case(VFFR_ST)
         `VR_Idle:
            if(!VFF_MT)
               VFFR_ST <= `VR_Req_Bus;
            else 
               VFFR_ST <= `VR_Idle;
         `VR_Req_Bus:
            if(BG)
               VFFR_ST <= `VR_Pop_SOP;
            else 
               VFFR_ST <= `VR_Req_Bus;
         `VR_Pop_SOP:
            VFFR_ST <= `VR_Cap_Pkt_Typ;
         `VR_Cap_Pkt_Typ:
            if(SOP_RD)
               VFFR_ST <= `VR_Ini_Stat;
            else 
               VFFR_ST <= `VR_Err_SOP;
         `VR_Ini_Stat:
            VFFR_ST <= `VR_MAC;
         `VR_MAC:
            if(MAC_DONE)
               VFFR_ST <= `VR_Pop_VFF;
            else 
               VFFR_ST <= `VR_MAC;
         `VR_Pop_VFF:
            if(VD1 && SOP_RD)
               VFFR_ST <= `VR_Ini_Stat;
            else if(VD1 && EOP_RD)
               VFFR_ST <= `VR_Fin_Stat;
            else if(TIME_OUT)
               VFFR_ST <= `VR_Err_TMO;
            else 
               VFFR_ST <= `VR_Pop_VFF;
         `VR_Fin_Stat:
            VFFR_ST <= `VR_Snd_Pkt;
         `VR_Snd_Pkt:
            if(EONP)
               VFFR_ST <= `VR_Hnd_Shk;
            else
               if(VFF_MT && VW_IDLE)
                  VFFR_ST <= `VR_Flush;
               else if (!VFF_MT && SOP_RD)
                  VFFR_ST <= `VR_Pop_SOP;
               else if (!VFF_MT && !SOP_RD && VW_IDLE)
                  VFFR_ST <= `VR_Err_SOP;
               else if (!VFF_MT && !SOP_RD && !VW_IDLE && !NORM_PKT_NXT)
                  VFFR_ST <= `VR_Err_Typ;
               else
                  VFFR_ST <= `VR_Pop_VFF;
         `VR_Hnd_Shk:
            if(VW_IDLE)
               if(VFF_MT)
                  VFFR_ST <= `VR_Flush;
               else 
                  VFFR_ST <= `VR_Pop_SOP;
            else
               VFFR_ST <= `VR_Hnd_Shk;
         `VR_Flush:
            if(FLUSH_DONE)
               VFFR_ST <= `VR_Rel_Bus;
            else 
               VFFR_ST <= `VR_Flush;
         `VR_Rel_Bus:
            if(!BG)
               VFFR_ST <= `VR_Idle;
            else 
               VFFR_ST <= `VR_Rel_Bus;
         `VR_Err_SOP:
            VFFR_ST <= `VR_Rpt_VFF_Err;
         `VR_Err_Typ:
            VFFR_ST <= `VR_Rpt_VFF_Err;
         `VR_Err_TMO:
            VFFR_ST <= `VR_Rpt_VFF_Err;
         `VR_Rpt_VFF_Err:
               if(ACKN == `V_VRbk_Err)
                  if(EONP || VW_HNDSHK)
                     VFFR_ST <= `VR_Hnd_Shk;
                  else
                     if(VFF_MT)
                        if(!VW_IDLE && !TMO)
                           VFFR_ST <= `VR_Pop_VFF;
                        else
                           VFFR_ST <= `VR_Rel_Bus;
                     else
                        if (SOP_RD)
                           VFFR_ST <= `VR_Pop_SOP;
                        else
                           VFFR_ST <= `VR_Ini_Stat;
               else 
                  VFFR_ST <= `VR_Rpt_VFF_Err;
         default:
            VFFR_ST <= `VR_Idle;
      endcase
end


always @(posedge CLK)
begin
   VD1        <= POP;
   H_BIT      <= MHBITS_SRL[0];
   MSRL2      <= MSRL1;
   MSRL3      <= MSRL2;
   MSRL4      <= MSRL3;
   MAC_DONE   <= MSRL4;
   ST_TY      <= {STATUS,TYPE};
   STAT_R     <= VR_INI_STAT || VR_FIN_STAT;
   TXP_DATA_R <= DATA_FLAG;
   DATA_OUT   <= VFF_OUT;
   SND_PKT_R  <= VR_SND_PKT;
   FLUSH_DONE <= VR_FLUSH;
   MAC_HDR_SRL_R <= MAC_HDR_SRL;
end

always @(posedge CLK)
begin
   if(VD1 || UPDT_CUR)
      begin
         NORM_PKT_CUR <= (PKT_TYP_RD == `VC_Norm_Pkt);
         ERR_PKT_CUR  <= (PKT_TYP_RD == `VC_ERR_Pkt);
         WARN_PKT_CUR <= (PKT_TYP_RD == `VC_WARN_Pkt);
         EONP         <= EOP_RD && (PKT_TYP_RD == `VC_Norm_Pkt);
         PKT_TYP_CUR  <= PKT_TYP_RD;
      end
   else
      begin
         NORM_PKT_CUR <= NORM_PKT_CUR;
         ERR_PKT_CUR  <= ERR_PKT_CUR;
         WARN_PKT_CUR <= WARN_PKT_CUR;
         EONP <= EONP;
         PKT_TYP_CUR <= PKT_TYP_CUR ;
      end
end
always @(posedge CLK)
begin
   ERR_PKT_CUR_1  <= ERR_PKT_CUR;
   WARN_PKT_CUR_1 <= WARN_PKT_CUR;
   if (CLR_ANY_DATA)
      WITH_ERRS <= 0;
   else if(SET_WITH_ERRS)
      WITH_ERRS <= 1;
   else
      WITH_ERRS <= WITH_ERRS;
   if (CLR_ANY_DATA)
      WITH_WARNS <= 0;
   else if(SET_WITH_WARNS)
      WITH_WARNS <= 1;
   else
      WITH_WARNS <= WITH_WARNS;
end

always @(PKT_TYP_CUR or VR_FIN_STAT or CIF or WITH_ERRS or WITH_WARNS or VW_IDLE)
begin
   case(PKT_TYP_CUR)
      `VC_Norm_Pkt:
         if(VR_FIN_STAT)
            if(CIF)
               STATUS <= `CE_I; //Command Execution finished Incomplete
            else if(WITH_ERRS)
               STATUS <= `CC_E; //Command Completed with Errors
            else if(WITH_WARNS)
               STATUS <= `CC_W; //Command Completed with Warnings
            else
               STATUS <= `CC_S; //Command Completed Sucessfully
         else
            STATUS <= `CiP; //Command in Progress no warnings no errors
      `VC_INFO_Pkt:
         STATUS <= `CiP; //Command in Progress no warnings no errors
      `VC_WARN_Pkt:
         STATUS <= !VW_IDLE ? `CiP_W : `No_Ack; //Command in Progress with Warnings
      `VC_ERR_Pkt:
         STATUS <= !VW_IDLE ? `CiP_E : `No_Ack; //Command in Progress with Errors
      `VC_INTR_Pkt,`VC_INFO_NoMAC_Pkt,`VC_WARN_NoMAC_Pkt,`VC_ERR_NoMAC_Pkt:
         STATUS <= `No_Ack; //No Acknowledgement Requested or not implemented
      default:
         STATUS <= `CiP;
   endcase
end
always @(PKT_TYP_CUR or VR_FIN_STAT or ANY_DATA or CUR_MSTR_DS or CUR_IH_DS)
begin  //Return packet types
   case (PKT_TYP_CUR)
      `VC_Norm_Pkt:
         if(VR_FIN_STAT && !ANY_DATA)
            TYPE <= `Rtn_NoDat_Pkt;
         else
            TYPE <= `Rtn_VMED08_Pkt | CUR_MSTR_DS;
      `VC_INFO_Pkt,`VC_INFO_NoMAC_Pkt:
         TYPE <= `Rtn_Info_Pkt;
      `VC_WARN_Pkt,`VC_WARN_NoMAC_Pkt:
         TYPE <= `Rtn_Warn_Pkt;
      `VC_ERR_Pkt,`VC_ERR_NoMAC_Pkt:
         TYPE <= `Rtn_Err_Pkt;
      `VC_INTR_Pkt:
         TYPE <= `Rtn_Intr08_Pkt | CUR_IH_DS;
      default:
         TYPE <= `Rtn_VMED08_Pkt | CUR_MSTR_DS;
   endcase
end


always @(STAT_R or ST_TY or MSRL2 or PKT_TYP_CUR or
         MAC_HDR_SRL_R or
         DATA_OUT)
begin
   if(STAT_R)
      DATA_MUX <= {4'h0,ST_TY};
   else if (MSRL2)
      if(PKT_TYP_CUR[2])
         DATA_MUX <= 16'h0000;
      else
         DATA_MUX <= MAC_HDR_SRL_R;
   else
      DATA_MUX <= DATA_OUT;
end


always @(STAT_R or MSRL2 or PKT_TYP_CUR or H_BIT or TXP_DATA_R or SND_PKT_R)
begin
   if(STAT_R)
      INSTR_MUX <= `Tx_AST;
   else if (MSRL2)
      if(PKT_TYP_CUR[2])
         INSTR_MUX <= H_BIT ? `Tx_NoHead : `Tx_NoMAC;
      else
         INSTR_MUX <= H_BIT ? `Tx_Head : `Tx_MAC;
   else if (TXP_DATA_R)
      INSTR_MUX <= `Tx_Data;
   else if (SND_PKT_R)
      INSTR_MUX <= `Tx_Send;
   else
      INSTR_MUX <= `Tx_NoData;
end


always @(PKT_TYP_CUR or PRIO)
begin
   if(PKT_TYP_CUR == `VC_Norm_Pkt)
      if (PRIO)
         CAT_MUX <= `Tx_Prio_Cat;
      else
         CAT_MUX <= `Tx_Norm_Cat;
   else
      CAT_MUX <= `Tx_Spont_Cat;
end

always @(posedge CLK)
begin
   if(BG)
      begin
         TXDATA  <= DATA_MUX;
         TXCTRL  <= {CAT_MUX,INSTR_MUX};
      end
   else
      begin
         TXDATA  <= 16'hZZZZ;
         TXCTRL  <= 5'hZZ;
      end
end

endmodule
