// Verilog model  - Tue Oct 12 16:51:33 2004

`timescale 1ns / 1ps

module vme_iack_dsychn(SYSCLK, AS, DS0, DS1, IACK_IN, SYSRESET, SYS_CTRL_ENA,
                       IACK_OUT);

    input SYSCLK;
    input AS;
    input DS0;
    input DS1;
    input IACK_IN;
    input SYSRESET;
    input SYS_CTRL_ENA;
   output IACK_OUT;

wire IACK_OUT;

reg IACKIN_REG;
reg IACKIN_D40;
reg DLY_IN0,DLY_IN1,DLY_IN2,DLY_IN3;   
reg DLY_OUT0,DLY_OUT1,DLY_OUT2;   
reg IACKOUT;
reg IACKOUT_D30;
reg DSA_D1;
reg AS_D1;

wire DSA;
wire LEAD_EDG_DS;
wire TRAIL_EDG_AS;
wire ENA;

assign DSA = DS0 | DS1;
assign LEAD_EDG_DS = DSA & !DSA_D1;
assign TRAIL_EDG_AS = !AS & AS_D1;
assign ENA = IACKOUT | !IACKOUT_D30;
assign IACK_OUT = SYS_CTRL_ENA ? IACKOUT : IACK_IN;


always @(posedge SYSCLK)
begin
   DSA_D1 <= DSA;
   AS_D1 <= AS;
   IACKOUT <= IACKIN_D40 & AS & ENA;
end

always @(posedge SYSCLK or posedge SYSRESET)
begin
   if(SYSRESET)
      IACKIN_REG <= 0;
   else
      if(LEAD_EDG_DS)
         IACKIN_REG <= IACK_IN;
      else if(TRAIL_EDG_AS)
         IACKIN_REG <= 0;
      else
         IACKIN_REG <= IACKIN_REG;
end

always @(posedge SYSCLK) // 40ns delay
begin
   DLY_IN0 <= IACKIN_REG;
   DLY_IN1 <= DLY_IN0;
   DLY_IN2 <= DLY_IN1;
   DLY_IN3 <= DLY_IN2;
   IACKIN_D40 <= DLY_IN3;
end
   
always @(posedge SYSCLK) // 32ns delay
begin
   DLY_OUT0 <= IACKOUT;
   DLY_OUT1 <= DLY_OUT0;
   DLY_OUT2 <= DLY_OUT1;
   IACKOUT_D30 <= DLY_OUT2;
end
   
endmodule
