// Verilog model  - Thu Oct 28 11:33:16 2004

`timescale 1ns / 1ps

module vme_intr_hndlr(SYSCLK, RST, ACKN, BERR, BTO, BUS_GRANTED, DTACK,
      INTR_HNDL_ENA, UPD_IRQ_MSK, IH_LVLS, IH_DT_SZ, IRQ, MON_IACK, MON_AS, SW2,
      A, AS, DAV, DRV_ADDR,
      DRV_AS, DRV_DS, DRV_IACK, DRV_LWORD, DS0, DS1, IH_WARN, IH_ERR, ERR_REG, IH_IRQ,
      BUSY, IACK, LWORD, REQ_BUS, TEST_A, TEST_B, TEST_C);

    input SYSCLK;
    input RST;
    input [3:0] ACKN;
    input BERR;
    input BTO;
    input BUS_GRANTED;
    input DTACK;
    input INTR_HNDL_ENA;
    input UPD_IRQ_MSK;
    input [7:1] IH_LVLS;
    input [1:0] IH_DT_SZ;
    input [7:1] IRQ;
    input MON_IACK;
    input MON_AS;
    input [3:0] SW2;
   output [3:1] A;
   output AS;
   output DAV;
   output DRV_ADDR;
   output DRV_AS;
   output DRV_DS;
   output DRV_IACK;
   output DRV_LWORD;
   output DS0;
   output DS1;
   output IH_WARN;
   output IH_ERR;
   output [7:0] ERR_REG;
   output [7:1] IH_IRQ;
   output BUSY;
   output IACK;
   output LWORD;
   output REQ_BUS;
   output [15:0] TEST_A;
   output [15:0] TEST_B;
   output [15:0] TEST_C;

reg [15:0] TEST_A;
reg [15:0] TEST_B;
reg [15:0] TEST_C;
   
`ifdef HEADER
`else
`include "header.v"
`endif

reg [3:1] A;
reg AS;
reg DAV;
reg DRV_ADDR;
reg DRV_AS;
reg DRV_DS;
reg DRV_IACK;
reg DRV_LWORD;
reg DS0;
reg DS1;
reg IH_WARN;
reg IH_ERR;
reg [7:0] COND_REG;
reg [7:0] ERR_REG;
reg [7:1] IH_IRQ;
reg BUSY;
reg LWORD;
reg REQ_BUS;

reg [3:0] IH_ST;
reg START,START1;
reg CAP_IRQ;
reg LOAD_ET;
reg LOAD_WN;
reg MASK_CUR_LVL;
reg [7:1] IRQ_MSK;
reg [7:1] RSPD_LVL;
reg [7:1] IRQ_PIPE1, IRQ_PIPE2, IRQ_PIPE3, IRQ_PIPE4;
reg [7:1] STBL_IRQ;
reg [7:1] MIRQ;

reg DS_ENA;
reg ESDS1;
reg ENA_SDAS1;
reg SET_AS;
reg RST_AS;
reg RELEASE_AS;
reg RELEASE_DS;
reg RST_DRV_AS;
reg END;
reg END_D;
reg END_ADDR;
reg ED0;
reg ED1;
reg AD0,AD1,AD2,AD3,AD4;
reg AD5,AD6,AD7;
reg DA0,DA1,DA2,DA3,DA4;
reg DA5,DA6,DA7,DA8;
reg DT0,DT1,DT2;
reg BED0,BED1;
reg DSAD0,DSAD1,DSAD2,DSAD3,DSAD4;
reg [6:0] IACK_TMR;
reg IACK_TMR_ENA;
reg ACKN_DAV;
reg ACKN_ERR;
reg ACKN_WARN;
reg GEN_DS;

reg DONE1;
reg RSPD_INTR_1, RSPD_INTR_2;
reg DSR1, DSR2;
reg DTACKR1, DTACKR2;
reg DTACK_D25;
reg DTACK_D25R1, DTACK_D25R2;

wire ANY_INTR;
wire RSPD_INTR;
wire START_PULSE;
wire RST;
wire RST_DS_ENA;
wire DSA;
wire ENA_SDAS0;
wire AS_HIGH_60;
wire AS_DRV_35;
wire AS_HOLD_40;
wire RST_END;
wire SET_DRV_AS;
wire RASD;
wire DS_HIGH_40;
wire SET_DS_ENA;
wire ESDS0;

wire TRAIL_EDG_DS;
wire LEAD_EDG_DTACK;
wire TRAIL_EDG_DTACK;
wire TRAIL_EDG_RSPD_INTR;
wire LEAD_EDG_DTACK_D25;
wire LEAD_EDG_BERR;

wire IACK;
wire IACK_TMO;


assign ANY_INTR    = |MIRQ;   
assign RSPD_INTR   = |(MIRQ & RSPD_LVL);   
assign DSA         = DS0 || DS1;
assign START_PULSE = START && !START1;
assign AS_HOLD_40  = AD4;
assign AS_HIGH_60  = ~|{AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};
assign AS_DRV_35   = DA4;
assign ENA_SDAS0   = START && AS_HIGH_60 && AS_DRV_35;
assign SET_DRV_AS  = ENA_SDAS0 && !ENA_SDAS1;
assign RASD        = END && AS_HOLD_40;

assign DS_HIGH_40  = ~|{DSAD4,DSAD3,DSAD2,DSAD1,DSAD0};
assign ESDS0       = GEN_DS && DS_HIGH_40 && MON_AS && !DTACK && !BERR;
assign SET_DS_ENA  = ESDS0 && !ESDS1;
assign RST_DS_ENA  = ACKN_DAV || BERR;
assign RST_END     = DONE1 || RST;

// Leading edges
// and mask off false leading edges at the trailing edge
assign LEAD_EDG_DTACK = DTACK & !DTACKR1 & !DTACKR2;
assign LEAD_EDG_DTACK_D25 = DTACK_D25 & !DTACK_D25R1 & !DTACK_D25R2;
assign LEAD_EDG_BERR = BERR & !BED0 & !BED1;

// Trailing edges
// and mask off false trailing edges at the leading edge
assign TRAIL_EDG_DS = !DSA & DSR1 & DSR2;
assign TRAIL_EDG_DTACK = !DTACK & DTACKR1 & DTACKR2;
assign TRAIL_EDG_RSPD_INTR = !RSPD_INTR & RSPD_INTR_1 & RSPD_INTR_2;

assign IACK_TMO =  (IACK_TMR == `IACK_Time_Out);

assign IACK =  1;


always @(posedge SYSCLK or posedge TRAIL_EDG_DTACK)
begin
   if(TRAIL_EDG_DTACK)
      begin
         DT0 <= 0;
         DT1 <= 0;
         DT2 <= 0;
         DTACK_D25 <= 0;
      end
   else
      begin
         DT0 <= DTACK;
         DT1 <= DT0;
         DT2 <= DT1;
         DTACK_D25 <= DT2; //Delayed DTACK for 32 ns for reads (rule is min. 25ns)
      end
end
always @(posedge SYSCLK)
begin
   DSR1 <= DSA;
   DSR2 <= DSR1;
   DTACKR1 <= DTACK;
   DTACKR2 <= DTACKR1;
   DTACK_D25R1 <= DTACK_D25;
   DTACK_D25R2 <= DTACK_D25R1;
   START1 <= START;
   AD0 <= MON_AS;
   AD1 <= AD0;
   AD2 <= AD1;
   AD3 <= AD2;
   AD4 <= AD3;
   AD5 <= AD4;
   AD6 <= AD5;
   AD7 <= AD6;
   DA0 <= DRV_ADDR;
   DA1 <= DA0;
   DA2 <= DA1;
   DA3 <= DA2;
   DA4 <= DA3;
   DSAD0 <= DSA;
   DSAD1 <= DSAD0;
   DSAD2 <= DSAD1;
   DSAD3 <= DSAD2;
   DSAD4 <= DSAD3;
   BED0 <= BERR;
   BED1 <= BED0;
   RSPD_INTR_1 <= RSPD_INTR;
   RSPD_INTR_2 <= RSPD_INTR_1;
   ESDS1 <= ESDS0;
   ENA_SDAS1 <= ENA_SDAS0;
end

always @(posedge SYSCLK)
begin
   SET_AS <= SET_DRV_AS;
   RST_AS <= RELEASE_AS;
   RST_DRV_AS <= RST_AS || RST;
end


always @(posedge SYSCLK)
begin
   case (SW2)
      4'h4:
         begin
            TEST_A[6:0] <= IRQ[7:1];
            TEST_A[13:7] <= RSPD_LVL[7:1];
            TEST_A[14] <= REQ_BUS;
            TEST_A[15] <= BUS_GRANTED;
            TEST_B[6:0] <= IRQ_MSK[7:1];
            TEST_B[13:7] <= MIRQ[7:1];
            TEST_B[14] <= ANY_INTR;
            TEST_B[15] <= RSPD_INTR;
            TEST_C[3:0] <= IH_ST[3:0];
            TEST_C[4] <= DRV_IACK;
            TEST_C[5] <= IACK;
            TEST_C[6] <= ACKN_DAV;
            TEST_C[7] <= ACKN_ERR;
            TEST_C[8] <= ACKN_WARN;
            TEST_C[9] <= DAV;
            TEST_C[10] <= IH_WARN;
            TEST_C[11] <= IH_ERR;
            TEST_C[12] <= BUSY;
            TEST_C[13] <= IACK_TMO;
            TEST_C[14] <= START_PULSE;
            TEST_C[15] <= INTR_HNDL_ENA;
         end
      default:
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
            TEST_C <= 16'h0000;
         end
   endcase
end

always @(posedge SYSCLK)
begin
   IRQ_PIPE1 <= IRQ;
   IRQ_PIPE2 <= IRQ_PIPE1;
   IRQ_PIPE3 <= IRQ_PIPE2;
   IRQ_PIPE4 <= IRQ_PIPE3;
   STBL_IRQ <= IRQ_PIPE1 & IRQ_PIPE2 & IRQ_PIPE3 & IRQ_PIPE4;
   MIRQ <= STBL_IRQ & IRQ_MSK;
end

always @(posedge SYSCLK or posedge RST)
begin
   if(RST)
      IACK_TMR <= 7'h00;
   else
      if(IACK_TMR_ENA)
         IACK_TMR <= IACK_TMR + 1;
      else
         IACK_TMR <= 7'h00;
end

always @(posedge SYSCLK)
begin
   ED0 <= END_D;
   ED1 <= ED0;
   RELEASE_DS <= ED1 || RST;
   RELEASE_AS <= RASD || RST;
   DONE1 <= RELEASE_AS;
end

always @(posedge SYSCLK or posedge RST)
begin
   if(RST)
      IH_IRQ <= 7'h00;
   else
      if(CAP_IRQ)        // Capture current state on IRQ lines
         IH_IRQ <= IRQ;
      else
         IH_IRQ <= IH_IRQ;
end

always @(posedge SYSCLK or posedge RST)
begin
   if(RST)
      RSPD_LVL <= 7'h00;
   else
      if(CAP_IRQ)        // Prioritized Interrupts. IRQ 7 is highest priority
         casex (MIRQ)
            7'b1xxxxxx:
               RSPD_LVL <= 7'h40;
            7'b01xxxxx:
               RSPD_LVL <= 7'h20;
            7'b001xxxx:
               RSPD_LVL <= 7'h10;
            7'b0001xxx:
               RSPD_LVL <= 7'h08;
            7'b00001xx:
               RSPD_LVL <= 7'h04;
            7'b000001x:
               RSPD_LVL <= 7'h02;
            7'b0000001:
               RSPD_LVL <= 7'h01;
            7'b0000000:
               RSPD_LVL <= 7'h00;
            default:
               RSPD_LVL <= 7'h00;
         endcase
      else if(TRAIL_EDG_RSPD_INTR)
         RSPD_LVL <= 7'h00;
      else
         RSPD_LVL <= RSPD_LVL;
end

always @(RSPD_LVL)
begin
   case (RSPD_LVL)
      7'b1000000:
         A <= 3'd7;
      7'b0100000:
         A <= 3'd6;
      7'b0010000:
         A <= 3'd5;
      7'b0001000:
         A <= 3'd4;
      7'b0000100:
         A <= 3'd3;
      7'b0000010:
         A <= 3'd2;
      7'b0000001:
         A <= 3'd1;
      7'b0000000:
         A <= 3'd0;
      default:
         A <= 3'd0;
   endcase
end

always @(IH_DT_SZ)
begin
   case (IH_DT_SZ)
      `LWord:
         LWORD <= 1;
      default:
         LWORD <= 0;
   endcase
end


always @(posedge SYSCLK or posedge RST)
begin
   if(RST)
      IRQ_MSK <= IH_LVLS;
   else
      if(UPD_IRQ_MSK)
         IRQ_MSK <= IH_LVLS;
      else if(MASK_CUR_LVL)
         IRQ_MSK <= IRQ_MSK & ~(RSPD_LVL);
      else
         IRQ_MSK <= IRQ_MSK;
end


always @(posedge SYSCLK or posedge RST)
begin: VME_Int_Handler_FSM
   if(RST)
      IH_ST <= `IH_Idle;
   else
      case(IH_ST)
         `IH_Idle:
            if(ANY_INTR && INTR_HNDL_ENA)
               IH_ST <= `IH_Cap_IRQ;
            else
               IH_ST <= `IH_Idle;
         `IH_Cap_IRQ:
            IH_ST <= `IH_Req_DTB;
         `IH_Req_DTB:
            begin
               if(BUS_GRANTED)
                  IH_ST <= `IH_Wait4DTB;
               else
                  IH_ST <= `IH_Req_DTB;
            end
         `IH_Wait4DTB:
            begin
               if(!MON_AS)
                  IH_ST <= `IH_Start;
               else
                  IH_ST <= `IH_Wait4DTB;
            end
         `IH_Start:
            begin
               if(DRV_AS && MON_IACK)
                  IH_ST <= `IACK_Cycle;
               else
                  IH_ST <= `IH_Start;
            end
         `IACK_Cycle:
            begin
               if(DTACK_D25)
                  IH_ST <= `Status_ID;
               else if(BERR)
                  IH_ST <= `IH_Ld_Err;
               else
                  IH_ST <= `IACK_Cycle;
            end
         `Status_ID:
            begin
               if(!DSA)
                  IH_ST <= `IACK_Done;
               else
                  IH_ST <= `Status_ID;
            end
         `IACK_Done:
            begin
               if(!DRV_ADDR && !MON_IACK)
                  IH_ST <= `IH_Rel_BR;
               else
                  IH_ST <= `IACK_Done;
            end
         `IH_Ld_Err:
            begin
               IH_ST <= `IH_Bus_Err;
            end
         `IH_Bus_Err:
            begin
               if(ACKN_ERR && !DRV_ADDR & !MON_IACK)
                  IH_ST <= `IH_Rel_BR;
               else
                  IH_ST <= `IH_Bus_Err;
            end
         `IH_Rel_BR:
            begin
               if(!RSPD_INTR)
                  IH_ST <= `IH_Idle;
               else if(IACK_TMO)
                  IH_ST <= `Mask_Intr;
               else
                  IH_ST <= `IH_Rel_BR;
            end
         `Mask_Intr:
            begin
               IH_ST <= `IH_Ld_Warn;
            end
         `IH_Ld_Warn:
            begin
               IH_ST <= `IH_Warn;
            end
         `IH_Warn:
            begin
               if(ACKN_WARN)
                  IH_ST <= `IH_Rel_BR;
               else
                  IH_ST <= `IH_Warn;
            end
         default:
            begin
               IH_ST <= `IH_Idle;
            end
      endcase
end

always @(IH_ST)
begin
   case (IH_ST)
      `IACK_Cycle:
         GEN_DS <= 1;
      default:
         GEN_DS <= 0;
   endcase
end

always @(IH_ST)
begin
   case (IH_ST)
      `IH_Cap_IRQ:
         CAP_IRQ <= 1;
      default:
         CAP_IRQ <= 0;
   endcase
end

always @(IH_ST)
begin
   case (IH_ST)
      `IH_Rel_BR:
         IACK_TMR_ENA <= 1;
      default:
         IACK_TMR_ENA <= 0;
   endcase
end

always @(IH_ST)
begin
   case (IH_ST)
      `IH_Start:
         begin
            START <= 1;
         end
      default:
         begin
            START <= 0;
         end
   endcase
end


always @(IH_ST)
begin
   case (IH_ST)
      `IH_Idle,`IH_Cap_IRQ:
         begin
            BUSY <= 0;
            REQ_BUS <= 0;
         end
      `IH_Req_DTB:
         begin
            BUSY <= 0;
            REQ_BUS <= 1;
         end
      `IH_Rel_BR,`Mask_Intr,`IH_Ld_Warn,`IH_Warn:
         begin
            BUSY <= 1;
            REQ_BUS <= 0;
         end
      default:
         begin
            BUSY <= 1;
            REQ_BUS <= 1;
         end
   endcase
end

always @(IH_ST)
begin
   case (IH_ST)
      `Status_ID:
         begin
            DAV <= 1;
         end
      default:
         begin
            DAV <= 0;
         end
   endcase
end

always @(IH_ST)
begin
   case (IH_ST)
      `IH_Ld_Err:
         begin
            LOAD_ET <= 1;
            LOAD_WN <= 0;
            MASK_CUR_LVL <= 0;
            IH_ERR <= 0;
            IH_WARN <= 0;
         end
      `Mask_Intr:
         begin
            LOAD_ET <= 0;
            LOAD_WN <= 0;
            MASK_CUR_LVL <= 1;
            IH_ERR <= 0;
            IH_WARN <= 0;
         end
      `IH_Ld_Warn:
         begin
            LOAD_ET <= 0;
            LOAD_WN <= 1;
            MASK_CUR_LVL <= 0;
            IH_ERR <= 0;
            IH_WARN <= 0;
         end
      `IH_Bus_Err:
         begin
            LOAD_ET <= 0;
            LOAD_WN <= 0;
            MASK_CUR_LVL <= 0;
            IH_ERR <= 1;
            IH_WARN <= 0;
         end
      `IH_Warn:
         begin
            LOAD_ET <= 0;
            LOAD_WN <= 0;
            MASK_CUR_LVL <= 0;
            IH_ERR <= 0;
            IH_WARN <= 1;
         end
      default:
         begin
            LOAD_ET <= 0;
            LOAD_WN <= 0;
            MASK_CUR_LVL <= 0;
            IH_ERR <= 0;
            IH_WARN <= 0;
         end
   endcase
end

always @(posedge SYSCLK or posedge RST)
begin         // IH Condition Register
   if (RST)
      COND_REG <= 8'h00;
   else
      COND_REG <= {2'b00,BTO,BERR,IH_ST}; 
end
always @(posedge SYSCLK or posedge RST)
begin         // IH Error/Warning Register
   if (RST)
      ERR_REG <= 8'h00;
   else
      if(LOAD_ET)
         ERR_REG <= COND_REG; 
      else if(LOAD_WN)
         ERR_REG <= {1'b1,IRQ_MSK}; 
      else if(ACKN_ERR || ACKN_WARN)
         ERR_REG <= 8'h00;
      else
         ERR_REG <= ERR_REG;
end

always @(IH_DT_SZ or DS_ENA)
begin
   if(DS_ENA)
      case (IH_DT_SZ)
         `Byte:
            begin
               DS1 <= 0;
               DS0 <= 1;
            end
         `Word:
            begin
               DS1 <= 1;
               DS0 <= 1;
            end
         `LWord:
            begin
               DS1 <= 1;
               DS0 <= 1;
            end
         default:
            begin
               DS1 <= 0;
               DS0 <= 0;
            end
      endcase
   else
      begin
         DS1 <= 0;
         DS0 <= 0;
      end
end


always @(posedge SYSCLK)
begin
   if (RST_DS_ENA)
      DS_ENA <= 0;
   else if (SET_DS_ENA)
      DS_ENA <= 1;
   else
      DS_ENA <= DS_ENA;
end

always @(posedge SYSCLK)
begin
   if (RELEASE_DS)
      DRV_DS <= 0;
   else if (START_PULSE)
      DRV_DS <= 1;
   else
      DRV_DS <= DRV_DS;
end

always @(posedge SYSCLK)
begin
   if (END_ADDR || RELEASE_AS)
      begin
         DRV_ADDR <= 0;
         DRV_LWORD <= 0;
         DRV_IACK <= 0;
      end
   else if (START_PULSE)
      begin
         DRV_ADDR <= 1;
         DRV_LWORD <= 1;
         DRV_IACK <= 1;
      end
   else
      begin
         DRV_ADDR <= DRV_ADDR;
         DRV_LWORD <= DRV_LWORD;
         DRV_IACK <= DRV_IACK;
      end
end

//
always @(posedge SYSCLK)
begin: DRV_AS_REG
   if (RST_DRV_AS)
      DRV_AS <= 0;
   else if (SET_DRV_AS)
      DRV_AS <= 1;
   else
      DRV_AS <= DRV_AS;
end
//
always @(posedge SYSCLK)
begin: AS_REG
   if (RST_AS)
      AS <= 0;
   else if (SET_AS)
      AS <= 1;
   else
      AS <= AS;
end


always @(posedge SYSCLK or negedge DRV_ADDR)
begin
   if (!DRV_ADDR)
      END_ADDR <= 0;
   else 
      if(TRAIL_EDG_DS || LEAD_EDG_BERR) 
         END_ADDR <= 1;
      else
         END_ADDR <= END_ADDR;
end
always @(posedge SYSCLK or posedge RST_END)
begin
   if (RST_END)
      END <= 0;
   else 
      if(TRAIL_EDG_DS || LEAD_EDG_BERR) 
         END <= 1;
      else
         END <= END;
end

always @(posedge SYSCLK or posedge RST_END)
begin
   if (RST_END)
      END_D <= 0;
   else 
      if(TRAIL_EDG_DS ||  LEAD_EDG_BERR) 
         END_D <= 1;
      else
         END_D <= END_D;
end


always @(posedge SYSCLK)
begin
   ACKN_DAV <= (ACKN == `V_IH_Dav);
   ACKN_ERR <= (ACKN == `V_IH_Err);
   ACKN_WARN <= (ACKN == `V_IH_Warn);
end
   
endmodule
