// Verilog model  - Tue Oct 12 13:10:00 2004

`timescale 1ns / 1ps

   
`ifdef HEADER
`else
`include "header.v"
`endif


module vme_outputs(ACFAIL, BCLR, BGIN, BTO_BERR, IACKOUT, IH_BBSY,
      IH_BR, IRQ, LI_O, MSTR_BBSY, MSTR_BGOUT, MSTR_BR,
      SLAVE_BERR, SYSFAIL, SYSRESET, SYSRST_OUT_ENA,
      DRV_ACFAIL_B, DRV_BBSY_B, DRV_BCLR_B,
      DRV_BERR_B, DRV_BG_IN_B, DRV_BG_OUT_B, DRV_BR_B, DRV_IACK_OUT_B,
      DRV_IRQ_B, DRV_LI_O_B, DRV_SYSFAIL_B, DRV_SYSRESET_B);

    input ACFAIL;
    input BCLR;
    input [3:0] BGIN;
    input BTO_BERR;
    input IACKOUT;
    input IH_BBSY;
    input [3:0] IH_BR;
    input [7:1] IRQ;
    input LI_O;
    input MSTR_BBSY;
    input [3:0] MSTR_BGOUT;
    input [3:0] MSTR_BR;
    input SLAVE_BERR;
    input SYSFAIL;
    input SYSRESET;
    input SYSRST_OUT_ENA;
   output DRV_ACFAIL_B;
   output DRV_BBSY_B;
   output DRV_BCLR_B;
   output DRV_BERR_B;
   output [3:0] DRV_BG_IN_B;
   output [3:0] DRV_BG_OUT_B;
   output [3:0] DRV_BR_B;
   output DRV_IACK_OUT_B;
   output [7:1] DRV_IRQ_B;
   output DRV_LI_O_B;
   output DRV_SYSFAIL_B;
   output DRV_SYSRESET_B;
   

assign         DRV_BBSY_B = !(MSTR_BBSY || IH_BBSY);
assign         DRV_BCLR_B = !BCLR;
assign         DRV_BERR_B = !(BTO_BERR || SLAVE_BERR);
assign        DRV_BG_IN_B = ~BGIN;
assign       DRV_BG_OUT_B = ~MSTR_BGOUT;
assign           DRV_BR_B = ~(MSTR_BR | IH_BR);
assign     DRV_IACK_OUT_B = !IACKOUT;
assign          DRV_IRQ_B = ~IRQ;
assign     DRV_SYSRESET_B = (SYSRST_OUT_ENA) ? !SYSRESET : 1;
assign      DRV_SYSFAIL_B = !SYSFAIL;
assign       DRV_ACFAIL_B = !ACFAIL;
assign         DRV_LI_O_B = !LI_O;
   
endmodule

module vme_inputs(SYSCLK, GAP_B, GA_B, MON_ACFAIL_B, MON_BBSY_B, MON_BCLR, MON_BERR_B,
      MON_BGIN_B, MON_BR_B, MON_IACK_IN_B, MON_IRQ_B, MON_LI_I_B, MON_RESP_B,
      MON_RETRY_B, MON_SYSFAIL_B, MON_SYSRESET_B, SYSRST_IN_ENA, MASK_BERR,
      GA, GAP, MON_ACFAIL,
      MON_BBSY, MON_BCLR_B, MON_BERR, MON_BGIN, MON_BR, MON_IACK_IN,
      MON_IRQ, MON_LI_I, MON_RESP, MON_RETRY, MON_SYSFAIL, MON_SYSRESET);

    input SYSCLK;
    input GAP_B;
    input [4:0] GA_B;
    input MON_ACFAIL_B;
    input MON_BBSY_B;
    input MON_BCLR_B;
    input MON_BERR_B;
    input [3:0] MON_BGIN_B;
    input [3:0] MON_BR_B;
    input MON_IACK_IN_B;
    input [7:1] MON_IRQ_B;
    input MON_LI_I_B;
    input MON_RESP_B;
    input MON_RETRY_B;
    input MON_SYSFAIL_B;
    input MON_SYSRESET_B;
    input SYSRST_IN_ENA;
    input MASK_BERR;
   output [4:0] GA;
   output GAP;
   output MON_ACFAIL;
   output MON_BBSY;
   output MON_BCLR;
   output MON_BERR;
   output [3:0] MON_BGIN;
   output [3:0] MON_BR;
   output MON_IACK_IN;
   output [7:1] MON_IRQ;
   output MON_LI_I;
   output MON_RESP;
   output MON_RETRY;
   output MON_SYSFAIL;
   output MON_SYSRESET;
   
reg MON_ACFAIL_B_SR;
reg MON_BBSY_B_SR;
reg MON_BCLR_B_SR;
reg MON_BERR_B_SR;
reg [3:0] MON_BGIN_B_SR;
reg [3:0] MON_BR_B_SR;
reg MON_IACK_IN_B_SR;
reg [7:1] MON_IRQ_B_SR;
reg MON_LI_I_B_SR;
reg MON_RESP_B_SR;
reg MON_RETRY_B_SR;
reg MON_SYSFAIL_B_SR;
reg MON_SYSRESET_B_SR;
reg MON_ACFAIL;
reg MON_BBSY;
reg MON_BCLR;
reg MON_BERR;
reg [3:0] MON_BGIN;
reg [3:0] MON_BR;
reg MON_IACK_IN;
reg [7:1] MON_IRQ;
reg MON_LI_I;
reg MON_RESP;
reg MON_RETRY;
reg MON_SYSFAIL;
reg MON_SYSRESET;

assign            GA = ~GA_B;
assign           GAP = !GAP_B;

always @(posedge SYSCLK)
begin (* IOB = "TRUE" *)
// Syncronizing registers
   MON_ACFAIL_B_SR   <= MON_ACFAIL_B;
   MON_BBSY_B_SR     <= MON_BBSY_B;
   MON_BCLR_B_SR     <= MON_BCLR_B;
   MON_BERR_B_SR     <= MON_BERR_B;
   MON_BGIN_B_SR     <= MON_BGIN_B;
   MON_BR_B_SR       <= MON_BR_B;
   MON_IACK_IN_B_SR  <= MON_IACK_IN_B;
   MON_IRQ_B_SR      <= MON_IRQ_B;
   MON_LI_I_B_SR     <= MON_LI_I_B;
   MON_RESP_B_SR     <= MON_RESP_B;
   MON_RETRY_B_SR    <= MON_RETRY_B;
   MON_SYSFAIL_B_SR  <= MON_SYSFAIL_B;
   MON_SYSRESET_B_SR <= MON_SYSRESET_B;
end
always @(posedge SYSCLK)
begin
// Synchronized signals
   MON_ACFAIL   <= !MON_ACFAIL_B_SR;
   MON_BBSY     <= !MON_BBSY_B_SR;
   MON_BCLR     <= !MON_BCLR_B_SR;
   MON_BERR     <= !(MASK_BERR || MON_BERR_B_SR);
   MON_BGIN     <= ~MON_BGIN_B_SR;
   MON_BR       <= ~MON_BR_B_SR;
   MON_IACK_IN  <= !MON_IACK_IN_B_SR;
   MON_IRQ      <= ~MON_IRQ_B_SR;
   MON_LI_I     <= !MON_LI_I_B_SR;
   MON_RESP     <= !MON_RESP_B_SR;
   MON_RETRY    <= !MON_RETRY_B_SR;
   MON_SYSFAIL  <= !MON_SYSFAIL_B_SR;
   MON_SYSRESET <= (SYSRST_IN_ENA) ? !MON_SYSRESET_B_SR : 0;
end
   
endmodule

module vme_bidirs(SYSCLK, IH_A, IH_AS, IH_DRV_ADDR, IH_DRV_AS, IH_DRV_DS,
      IH_DRV_IACK, IH_DRV_LWORD, IH_DS, IH_IACK,
      IH_LWORD, MSTR_A, MSTR_AM, MSTR_AS, MSTR_D, MSTR_DRV_ADDR,
      MSTR_DRV_AM, MSTR_DRV_AS, MSTR_DRV_DATA, MSTR_DRV_DS, MSTR_DRV_LWORD,
      MSTR_DRV_WRITE, MSTR_DS, MSTR_LWORD, MSTR_WRITE, SLAVE_A, SLAVE_D,
      SLAVE_DRV_ADDR, SLAVE_DRV_DATA, SLAVE_DRV_DTACK, SLAVE_DTACK,
      DRV_ADDR, DRV_AM, DRV_AS, DRV_DATA, DRV_DS, DRV_DTACK, DRV_IACK, DRV_LWORD,
      DRV_WRITE, DRV_UD, MON_A, MON_AM, MON_AS, MON_D, MON_DS, MON_DTACK, MON_IACK,
      MON_LWORD, MON_WRITE, ERR_A, ERR_AS, ERR_D, ERR_DS, ERR_LWORD,
      UD, VME_ADDRESS, VME_AM, VME_AS_B, VME_DATA, VME_DS_B,
      VME_DTACK_B, VME_IACK_B, VME_LWORD_B, VME_WRITE_B);

    input SYSCLK;
    input [3:1] IH_A;
    input IH_AS;
    input IH_DRV_ADDR;
    input IH_DRV_AS;
    input IH_DRV_DS;
    input IH_DRV_IACK;
    input IH_DRV_LWORD;
    input [1:0] IH_DS;
    input IH_IACK;
    input IH_LWORD;
    input [31:1] MSTR_A;
    input [5:0] MSTR_AM;
    input MSTR_AS;
    input [31:0] MSTR_D;
    input MSTR_DRV_ADDR;
    input MSTR_DRV_AM;
    input MSTR_DRV_AS;
    input MSTR_DRV_DATA;
    input MSTR_DRV_DS;
    input MSTR_DRV_LWORD;
    input MSTR_DRV_WRITE;
    input [1:0] MSTR_DS;
    input MSTR_LWORD;
    input MSTR_WRITE;
    input [31:1] SLAVE_A;
    input [31:0] SLAVE_D;
    input SLAVE_DRV_ADDR;
    input SLAVE_DRV_DATA;
    input SLAVE_DRV_DTACK;
    input SLAVE_DTACK;
   output DRV_ADDR;
   output DRV_AM;
   output DRV_AS;
   output DRV_DATA;
   output DRV_DS;
   output DRV_DTACK;
   output DRV_IACK;
   output DRV_LWORD;
   output DRV_WRITE;
   output [4:1] DRV_UD;
   output [31:1] MON_A;
   output [5:0] MON_AM;
   output MON_AS;
   output [31:0] MON_D;
   output [1:0] MON_DS;
   output MON_DTACK;
   output MON_IACK;
   output MON_LWORD;
   output MON_WRITE;
   output ERR_A;
   output ERR_AS;
   output ERR_D;
   output ERR_DS;
   output ERR_LWORD;
    inout [32:1] UD;
    inout [31:1] VME_ADDRESS;
    inout [5:0] VME_AM;
    inout VME_AS_B;
    inout [31:0] VME_DATA;
    inout [1:0] VME_DS_B;
//    inout VME_DTACK_B;
    input VME_DTACK_B;
    inout VME_IACK_B;
    inout VME_LWORD_B;
    inout VME_WRITE_B;

reg DRV_ADDR;
reg DRV_AS;
reg DRV_DATA;
reg DRV_DS;
reg DRV_LWORD;
reg [31:1] MUX_A;
reg MUX_AS;
reg [31:0] MUX_D;
reg [1:0] MUX_DS;
reg MUX_LWORD;
reg ERR_A;
reg ERR_AS;
reg ERR_D;
reg ERR_DS;
reg ERR_LWORD;
wire [32:1] UD_OUT;

reg [31:1] MON_A_SR;
reg [5:0] MON_AM_SR;
reg MON_AS_B_SR;
reg [31:0] MON_D_SR;
reg [1:0] MON_DS_B_SR;
reg MON_DTACK_B_SR;
reg MON_IACK_B_SR;
reg MON_LWORD_B_SR;
reg MON_WRITE_B_SR;
reg [32:1] UD_SR;

reg [31:1] MON_A;
reg [5:0] MON_AM;
reg MON_AS;
reg [31:0] MON_D;
reg [1:0] MON_DS;
reg MON_DTACK;
reg MON_IACK;
reg MON_LWORD;
reg MON_WRITE;
reg [32:1] UD_IN;

// Assign VME inputs to logic 
   
always @(posedge SYSCLK)
begin (* IOB = "TRUE" *)
// Syncronizing registers
   MON_A_SR     <= VME_ADDRESS;
   MON_AM_SR    <= VME_AM;
   MON_AS_B_SR    <= VME_AS_B;
   MON_D_SR     <= VME_DATA;
   MON_DS_B_SR    <= VME_DS_B;
   MON_DTACK_B_SR <= VME_DTACK_B;
   MON_IACK_B_SR  <= VME_IACK_B;
   MON_LWORD_B_SR <= VME_LWORD_B;
   MON_WRITE_B_SR <= VME_WRITE_B;
   UD_SR        <= UD;
end
always @(posedge SYSCLK)
begin
// Synchronized signals
   MON_A     <= MON_A_SR;
   MON_AM    <= MON_AM_SR;
   MON_AS    <= !MON_AS_B_SR;
   MON_D     <= MON_D_SR;
   MON_DS    <= ~MON_DS_B_SR;
   MON_DTACK <= !MON_DTACK_B_SR;
   MON_IACK  <= !MON_IACK_B_SR;
   MON_LWORD <= !MON_LWORD_B_SR;
   MON_WRITE <= !MON_WRITE_B_SR;
   UD_IN     <= UD_SR;
end

assign DRV_UD = 4'h0;
assign UD_OUT = 32'h00000000;
assign {UD[15],UD[13],UD[11],UD[9],UD[7],UD[5],UD[3],UD[1]} = DRV_UD[1] ? {UD_OUT[15],UD_OUT[13],UD_OUT[11],UD_OUT[9],UD_OUT[7],UD_OUT[5],UD_OUT[3],UD_OUT[1]} : 8'hZZ;
assign {UD[16],UD[14],UD[12],UD[10],UD[8],UD[6],UD[4],UD[2]} = DRV_UD[2] ? {UD_OUT[16],UD_OUT[14],UD_OUT[12],UD_OUT[10],UD_OUT[8],UD_OUT[6],UD_OUT[4],UD_OUT[2]} : 8'hZZ;
assign {UD[31],UD[29],UD[27],UD[25],UD[23],UD[21],UD[19],UD[17]} = DRV_UD[3] ? {UD_OUT[31],UD_OUT[29],UD_OUT[27],UD_OUT[25],UD_OUT[23],UD_OUT[21],UD_OUT[19],UD_OUT[17]} : 8'hZZ;
assign {UD[32],UD[30],UD[28],UD[26],UD[24],UD[22],UD[20],UD[18]} = DRV_UD[4] ? {UD_OUT[32],UD_OUT[30],UD_OUT[28],UD_OUT[26],UD_OUT[24],UD_OUT[22],UD_OUT[20],UD_OUT[18]} : 8'hZZ;

// Multiplex address line sources for VME output drive
// Sources are Master, Interrupt handler, and Slave

always @(MSTR_DRV_ADDR or IH_DRV_ADDR or SLAVE_DRV_ADDR or  MSTR_A or IH_A or SLAVE_A)
begin
   case ({MSTR_DRV_ADDR,IH_DRV_ADDR,SLAVE_DRV_ADDR})
      3'b000:
         begin
            MUX_A <= 31'h7FFFFFFF;
            DRV_ADDR <= 0;
            ERR_A <= 0;
         end
      3'b100:
         begin
            MUX_A <= MSTR_A;
            DRV_ADDR <= 1;
            ERR_A <= 0;
         end
      3'b010:
         begin
            MUX_A <= {28'hFFFFFFF,IH_A};
            DRV_ADDR <= 1;
            ERR_A <= 0;
         end
      3'b001:
         begin
            MUX_A <= SLAVE_A;
            DRV_ADDR <= 1;
            ERR_A <= 0;
         end
      default:
         begin
            MUX_A <= 31'hFFFF;
            DRV_ADDR <= 0;
            ERR_A <= 1;
         end
   endcase
end

// Multiplex Address Strobe (AS) line sources for VME output drive
// Sources are Master, and Interrupt handler

always @(MSTR_DRV_AS or IH_DRV_AS or MSTR_AS or IH_AS)
begin
   case ({MSTR_DRV_AS,IH_DRV_AS})
      2'b00:
         begin
            MUX_AS <= 1'b0;
            DRV_AS <= 0;
            ERR_AS <= 0;
         end
      2'b10:
         begin
            MUX_AS <= MSTR_AS;
            DRV_AS <= 1;
            ERR_AS <= 0;
         end
      2'b01:
         begin
            MUX_AS <= IH_AS;
            DRV_AS <= 1;
            ERR_AS <= 0;
         end
      default:
         begin
            MUX_AS <= 1'b0;
            DRV_AS <= 0;
            ERR_AS <= 1;
         end
   endcase
end

// Multiplex data line sources for VME output drive
// Sources are Master, and Slave

always @(MSTR_DRV_DATA or SLAVE_DRV_DATA or MSTR_D or SLAVE_D)
begin
   case ({MSTR_DRV_DATA,SLAVE_DRV_DATA})
      2'b00:
         begin
            MUX_D <= 32'hFFFF;
            DRV_DATA <= 0;
            ERR_D <= 0;
         end
      2'b10:
         begin
            MUX_D <= MSTR_D;
            DRV_DATA <= 1;
            ERR_D <= 0;
         end
      2'b01:
         begin
            MUX_D <= SLAVE_D;
            DRV_DATA <= 1;
            ERR_D <= 0;
         end
      default:
         begin
            MUX_D <= 32'hFFFF;
            DRV_DATA <= 0;
            ERR_D <= 1;
         end
   endcase
end

// Multiplex Data Strobe (DS) line sources for VME output drive
// Sources are Master, and Interrupt handler

always @(MSTR_DRV_DS or IH_DRV_DS or MSTR_DS or IH_DS)
begin
   case ({MSTR_DRV_DS,IH_DRV_DS})
      2'b00:
         begin
            MUX_DS <= 2'b00;
            DRV_DS <= 0;
            ERR_DS <= 0;
         end
      2'b10:
         begin
            MUX_DS <= MSTR_DS;
            DRV_DS <= 1;
            ERR_DS <= 0;
         end
      2'b01:
         begin
            MUX_DS <= IH_DS;
            DRV_DS <= 1;
            ERR_DS <= 0;
         end
      default:
         begin
            MUX_DS <= 2'b00;
            DRV_DS <= 0;
            ERR_DS <= 1;
         end
   endcase
end

// Multiplex LWORD sources for VME output drive
// Sources are Master, Interrupt handler

always @(MSTR_DRV_LWORD or IH_DRV_LWORD or MSTR_LWORD or IH_LWORD)
begin
   case ({MSTR_DRV_LWORD,IH_DRV_LWORD})
      2'b00:
         begin
            MUX_LWORD <= 1'b0;
            DRV_LWORD <= 0;
            ERR_LWORD <= 0;
         end
      2'b10:
         begin
            MUX_LWORD <= MSTR_LWORD;
            DRV_LWORD <= 1;
            ERR_LWORD <= 0;
         end
      2'b01:
         begin
            MUX_LWORD <= IH_LWORD;
            DRV_LWORD <= 1;
            ERR_LWORD <= 0;
         end
      default:
         begin
            MUX_LWORD <= 1'b0;
            DRV_LWORD <= 0;
            ERR_LWORD <= 1;
         end
   endcase
end

PULLUP pu1 (.O(VME_AS_B));
PULLUP pu2 (.O(VME_DS_B[1]));
PULLUP pu3 (.O(VME_DS_B[0]));
//PULLUP pu4 (.O(VME_DTACK_B));
PULLUP pu5 (.O(VME_IACK_B));
PULLUP pu6 (.O(VME_LWORD_B));
PULLUP pu7 (.O(VME_WRITE_B));

assign    DRV_AM = MSTR_DRV_AM;
//assign DRV_DTACK = SLAVE_DRV_DTACK;
assign DRV_DTACK = 0;
assign  DRV_IACK = IH_DRV_IACK;
assign DRV_WRITE = MSTR_DRV_WRITE;

   
assign VME_ADDRESS = DRV_ADDR  ?  MUX_A       : 31'hZZZZ;
assign      VME_AM = DRV_AM    ?  MSTR_AM     : 6'hZZ;
assign    VME_AS_B = DRV_AS    ? !MUX_AS      : 1'bZ;
assign    VME_DATA = DRV_DATA  ?  MUX_D       : 32'hZZZZ;
assign    VME_DS_B = DRV_DS    ? ~MUX_DS      : 2'bZZ;
//assign VME_DTACK_B = DRV_DTACK ? !SLAVE_DTACK : 1'bZ;
assign  VME_IACK_B = DRV_IACK  ? !IH_IACK     : 1'bZ;
assign VME_LWORD_B = DRV_LWORD ? !MUX_LWORD   : 1'bZ;
assign VME_WRITE_B = DRV_WRITE ? !MSTR_WRITE  : 1'bZ;

endmodule
