// Verilog model  - Mon Oct 18 13:53:11 2004

`timescale 1ns / 1ps

module vme_master(RST, ACFAIL, ACKN, VRD_IDLE, AD_MOD, A_FROM, BCLR, BERR, BTO, BUS_GRANTED, ARB_ERR,
      DTACK, D_FROM,
      EXECUTE, IN_ADDR, IN_DATA, LAST_WORD, LWORD_FROM, MASTER_ENA, MON_AS, MON_IACK, NEXT_RDY, RETRY,
      SYSCLK, USRCLK, DV1024CLK,
      SYSFAIL, UDAM_SZ, DATA_SZ, IH_DT_SZ, TRNS_TYP, DLY_TYP, WRT_RDB, CLR_ERR, SW2,
      A, AM, AS, BUSY,
      D, DAV, BUS_ERR, TR_TP, DT_SZ, DRV_ADDR, DRV_AM, DRV_AS, DRV_DATA, DRV_DS,
      DRV_LWORD, DRV_WRITE, DS0, DS1, ERR_REG, LWORD, NEXT_WRD, OUT_DATA, FULL_ADDR, REQ_BUS, WRITE,
      TEST_OUT, TEST_A, TEST_B, TEST_C);

    input RST;
    input ACFAIL;
    input [3:0] ACKN;
    input VRD_IDLE;
    input [5:0] AD_MOD;
    input [31:1] A_FROM;
    input BCLR;
    input BERR;
    input BTO;
    input BUS_GRANTED;
    input ARB_ERR;
    input DTACK;
    input [31:0] D_FROM;
    input EXECUTE;
    input [63:0] IN_ADDR;
    input [63:0] IN_DATA;
    input LAST_WORD;
    input LWORD_FROM;
    input MASTER_ENA;
    input MON_AS;
    input MON_IACK;
    input NEXT_RDY;
    input RETRY;
    input SYSCLK;
    input USRCLK;
    input DV1024CLK;
    input SYSFAIL;
    input [2:0] UDAM_SZ;
    input [1:0] DATA_SZ;
    input [1:0] IH_DT_SZ;
    input [1:0] TRNS_TYP;
    input [2:0] DLY_TYP;
    input WRT_RDB;
    input CLR_ERR;
    input [3:0] SW2;
   output [31:1] A;
   output [5:0] AM;
   output AS;
   output BUSY;
   output [31:0] D;
   output DAV;
   output BUS_ERR;
   output [1:0] TR_TP;
   output [1:0] DT_SZ;
   output DRV_ADDR;
   output DRV_AM;
   output DRV_AS;
   output DRV_DATA;
   output DRV_DS;
   output DRV_LWORD;
   output DRV_WRITE;
   output DS0;
   output DS1;
   output [7:0] ERR_REG;
   output LWORD;
   output NEXT_WRD;
   output [63:0] OUT_DATA;
   output [63:0] FULL_ADDR;
   output REQ_BUS;
   output WRITE;
   output [15:0] TEST_A;
   output [15:0] TEST_B;
   output [15:0] TEST_C;
   output [7:0] TEST_OUT;

reg [31:1] A;
reg [5:0] AM;
reg AS;
reg BUSY;
reg [31:0] D;
reg DAV;
reg BUS_ERR;
reg [1:0] TR_TP;
reg [1:0] DT_SZ;
reg DRV_ADDR;
reg DRV_AM;
reg DRV_AS;
reg DRV_DATA;
reg DRV_DS;
reg DRV_LWORD;
reg DRV_WRITE;
reg DS0;
reg DS1;
reg [7:0] ERR_REG;
reg LWORD;
reg NEXT_WRD;
reg [63:0] OUT_DATA;
reg [63:0] FULL_ADDR;
reg REQ_BUS;
reg WRITE;
reg [15:0] TEST_A;
reg [15:0] TEST_B;
reg [15:0] TEST_C;
reg [7:0] TEST_OUT;



reg [4:0] MSTR_ST;
reg [7:0] COND_REG;
reg [63:0] FULL_DATA;
reg [31:0] DLY_CNT;
reg [2:0] A_SZ;
reg [2:0] DL_TP;
reg [20:0] R;

reg NOT_SUP;
reg EXT_3U;
reg EXT_6U;
reg RSVD;
reg UD;
reg BLT;
reg MBLT;
reg LCK;
reg CR;
reg A64;
reg A40;
reg A32;
reg A24;
reg A16;

reg DLY_ENA;
reg LOAD_DLY;
reg DCK_DV1024_CLR_1;
reg DCK_DV1024_ENA;

reg LOAD_ET;
reg LOAD_DNA;
reg LOAD_DATA;
reg LOADED;
reg DATA_LOADED;
reg CLR_DATA_LOADED;
reg ADD_PHASE;
reg END_ADDR;
reg END_A;
reg END_B;
reg END_D;
reg END;
reg ED0;
reg LAST_CYCLE;
reg LAST_WORD_REG;
reg NEXT_RDY1;
reg ENA_END_ADDR;
reg EOLC;

reg INT_DS1;
reg INT_DS0;
reg AD0,AD1,AD2,AD3,AD4;
reg AD5,AD6,AD7;
reg DA0,DA1,DA2,DA3,DA4;
reg DA5,DA6,DA7,DA8;
reg DT0,DT1,DT2;
reg BED0,BED1;
reg DDD0,DDD1,DDD2,DDD3,DDD4;
reg DDL0,DDL1,DDL2,DDL3;
reg DDL5,DDL6,DDL7,DDL8;
reg DWD0,DWD1,DWD2,DWD3,DWD4;
reg DSAD0,DSAD1,DSAD2,DSAD3,DSAD4;

reg ENA_SDAS1;
reg SET_AS;
reg RST_AS;
reg RST_DRV_AS;
reg ENA_SDWR1;
reg RELEASE_WRT;
reg ESDS1;
reg DS_ENA;
reg RST_DS_ENA;

reg START,START1;
reg GEN_DS;
reg RELEASE_AM;
reg RELEASE_DS;
reg RELEASE_DATA;
reg RELEASE_ADDR;
reg DS_LDDAT_35;
reg DONE1;
reg DSR1,DSR2;
reg DTACKR1,DTACKR2;
reg DTACK_D25,DTACK_D25R1,DTACK_D25R2;

reg ACKN_IH_DAV;
reg ACKN_DAV;
reg ACKN_ERR;

reg INC_PRBS, INC_PRBS_1;

wire GSR_DMY;
wire PRBS;
wire PRBS_ENA;
wire DLY_END;
wire DCK_DV1024_CLR;

wire DSA;
wire START_PULSE;
wire AS_HOLD_40;
wire AS_HIGH_40;
wire AS_HIGH_60;
wire AS_DRV_35;
wire ENA_SDAS0;
wire SET_DRV_AS;
wire RAMD;

wire ENA_SDWR0;
wire SET_DRV_WRITE;

wire DS_DRVDAT_35;
wire DS_FIRST_35;
wire DS_VALDAT_35;
wire DS_HIGH_40;
wire ESDS0;
wire SET_DS_ENA;

wire DONE;
wire RST_END;

wire LEAD_EDG_DTACK;
wire LEAD_EDG_DTACK_D25;
wire LEAD_EDG_BERR;

wire TRAIL_EDG_DS;
wire TRAIL_EDG_DTACK;

wire MD32;


`ifdef HEADER
`else
`include "header.v"
`endif

initial
begin
   AS = 0;
   DRV_ADDR = 0;
   DRV_AM = 0;
   DRV_AS = 0;
   DRV_DATA = 0;
   DRV_DS = 0;
   DRV_LWORD = 0;
   DRV_WRITE = 0;
   DS_ENA = 0;
   DS0 = 0;
   DS1 = 0;
   LWORD = 0;
   ADD_PHASE = 0;
   END_ADDR = 0;
   END_A = 0;
   END_B = 0;
   END_D = 0;
   END = 0;
end            

assign PRBS           = R[20];
assign PRBS_ENA       = INC_PRBS && !INC_PRBS_1;
assign DLY_END        = (DLY_CNT == 32'h00000000);
assign DCK_DV1024_CLR = DCK_DV1024_ENA || RST;

assign DSA           = DS0 || DS1;
assign START_PULSE   = START && !START1;
assign AS_HOLD_40    = AD4;
assign AS_HIGH_40    = ~|{AD4,AD3,AD2,AD1,AD0};
assign AS_HIGH_60    = ~|{AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};
assign AS_DRV_35     = DA4;
assign ENA_SDAS0     = START && AS_HIGH_60 && AS_DRV_35;
assign SET_DRV_AS    = ENA_SDAS0 && !ENA_SDAS1;
assign RAMD          = END && AS_HOLD_40;

assign ENA_SDWR0     = START && !DTACK && !BERR;
assign SET_DRV_WRITE = ENA_SDWR0 && !ENA_SDWR1;

assign DS_DRVDAT_35  = DDD4;
assign DS_FIRST_35   = DWD4;
assign DS_VALDAT_35  = DS_DRVDAT_35 && DS_LDDAT_35;
assign DS_HIGH_40    = ~|{DSAD4,DSAD3,DSAD2,DSAD1,DSAD0};
assign ESDS0         = GEN_DS && DS_HIGH_40 && DS_FIRST_35 && (DS_VALDAT_35 || !WRITE) && MON_AS && !DTACK && !BERR;
assign SET_DS_ENA    = ESDS0 && !ESDS1;

assign DONE          = RELEASE_AM && RELEASE_WRT;
assign RST_END       = DONE1 || RST;


// Leading edges
// and mask off false leading edges at the trailing edge
assign LEAD_EDG_DTACK     = DTACK & !DTACKR1 & !DTACKR2;
assign LEAD_EDG_DTACK_D25 = DTACK_D25 & !DTACK_D25R1 & !DTACK_D25R2;
assign LEAD_EDG_BERR      = BERR & !BED0 & !BED1;

// Trailing edges
// and mask off false trailing edges at the leading edge
assign TRAIL_EDG_DS       = !DSA & DSR1 & DSR2;
assign TRAIL_EDG_DTACK    = !DTACK & DTACKR1 & DTACKR2;

assign MD32 = A40 && (DT_SZ==`LWord);


always @(posedge SYSCLK)
begin              
   ENA_SDWR1    <= ENA_SDWR0;
   ENA_SDAS1    <= ENA_SDAS0;
   ESDS1        <= ESDS0;
   SET_AS       <= SET_DRV_AS;
   RST_AS       <= RELEASE_AM;
   RST_DRV_AS   <= RST_AS || RST;
   ED0          <= END_D;
   RELEASE_WRT  <= ED0 || RST; // 10nS holdoff from trailing edge of DSB to release of WRITE
   RELEASE_DS   <= ED0 || RST;
   RELEASE_AM   <= RAMD || RST;
   RELEASE_ADDR <= (MBLT || MD32) && !WRITE && END_ADDR;  //Rel. after address phase for D64 and MD32 reads only
   RELEASE_DATA <= (!WRITE && END_ADDR) || RAMD || RST;  //Rel. after address phase for all reads and after last cycle otherwise
   DONE1        <= DONE;
   NEXT_RDY1    <= NEXT_RDY;
   INC_PRBS_1   <= INC_PRBS;
end

always @(posedge SYSCLK)
begin
   DSR1 <= DSA;
   DSR2 <= DSR1;
   DTACKR1 <= DTACK;
   DTACKR2 <= DTACKR1;
   DTACK_D25R1 <= DTACK_D25;
   DTACK_D25R2 <= DTACK_D25R1;
   START1 <= START;
   AD0 <= MON_AS;
   AD1 <= AD0;
   AD2 <= AD1;
   AD3 <= AD2;
   AD4 <= AD3;
   AD5 <= AD4;
   AD6 <= AD5;
   AD7 <= AD6;
   DA0 <= DRV_ADDR;
   DA1 <= DA0;
   DA2 <= DA1;
   DA3 <= DA2;
   DA4 <= DA3;
   DDD0 <= DRV_DATA;
   DDD1 <= DDD0;
   DDD2 <= DDD1;
   DDD3 <= DDD2;
   DDD4 <= DDD3;
   DWD0 <= DRV_WRITE;
   DWD1 <= DWD0;
   DWD2 <= DWD1;
   DWD3 <= DWD2;
   DWD4 <= DWD3;
   DSAD0 <= DSA;
   DSAD1 <= DSAD0;
   DSAD2 <= DSAD1;
   DSAD3 <= DSAD2;
   DSAD4 <= DSAD3;
   BED0 <= BERR;
   BED1 <= BED0;
end

always @(posedge SYSCLK or posedge TRAIL_EDG_DTACK)
begin
   if(TRAIL_EDG_DTACK)
      begin
         DT0 <= 0;
         DT1 <= 0;
         DT2 <= 0;
         DTACK_D25 <= 0;
      end
   else
      begin
         DT0 <= DTACK;
         DT1 <= DT0;
         DT2 <= DT1;
         DTACK_D25 <= DT2; //Delayed DTACK for 32 ns for reads (rule is min. 25ns)
      end
end
always @(posedge SYSCLK or posedge CLR_DATA_LOADED)
begin
   if(CLR_DATA_LOADED)
      begin
         DDL0 <= 0;
         DDL1 <= 0;
         DDL2 <= 0;
         DDL3 <= 0;
         DS_LDDAT_35 <= 0;
      end
   else
      begin
         DDL0 <= DATA_LOADED;
         DDL1 <= DDL0;
         DDL2 <= DDL1;
         DDL3 <= DDL2;
         DS_LDDAT_35 <= DDL3; //Delayed DATA_LOADED for 40 ns for writes (rule is data valid for min. 35ns before data strobe)
      end
end


always @(posedge SYSCLK)
begin
   TEST_OUT[7] <= EXECUTE;
   TEST_OUT[6] <= RST;
   TEST_OUT[5] <= BUSY;
   TEST_OUT[4:0] <= MSTR_ST;
end

always @(posedge SYSCLK)
begin
   case (SW2)
      4'h0, 4'h2:
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
            TEST_C[7:0] <= 8'h00;
            TEST_C[12:8] <= MSTR_ST;
            TEST_C[13] <= BUSY;
            TEST_C[14] <= RST;
            TEST_C[15] <= EXECUTE;
         end
      4'h1:
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
            TEST_C[0] <= RELEASE_WRT;
            TEST_C[1] <= RELEASE_AM;
            TEST_C[2] <= DRV_WRITE;
            TEST_C[3] <= DRV_AS;
            TEST_C[4] <= AS_HOLD_40;
            TEST_C[5] <= RST_END;
            TEST_C[6] <= END_D;
            TEST_C[7] <= END;
            TEST_C[12:8] <= MSTR_ST;
            TEST_C[13] <= LEAD_EDG_BERR;
            TEST_C[14] <= BERR;
            TEST_C[15] <= DTACK;
         end
      4'h3:
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
            TEST_C[7:0] <= 8'h00;
            TEST_C[12:8] <= MSTR_ST;
            TEST_C[13] <= LEAD_EDG_BERR;
            TEST_C[14] <= BERR;
            TEST_C[15] <= DTACK;
         end
      4'h5:
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
            TEST_C[7:0] <= 8'h00;
            TEST_C[12:8] <= MSTR_ST;
            TEST_C[13] <= REQ_BUS;
            TEST_C[14] <= BUS_GRANTED;
            TEST_C[15] <= EXECUTE;
         end
      4'h6:
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
            TEST_C[0] <= BUS_GRANTED;
            TEST_C[1] <= REQ_BUS;
            TEST_C[2] <= ACKN_DAV;
            TEST_C[3] <= DAV;
            TEST_C[4] <= EXECUTE;
            TEST_C[5] <= PRBS;
            TEST_C[6] <= PRBS_ENA;
            TEST_C[7] <= INC_PRBS_1;
            TEST_C[12:8] <= MSTR_ST;
            TEST_C[13] <= RST_DS_ENA;
            TEST_C[14] <= SET_DS_ENA;
            TEST_C[15] <= DS_ENA;
         end
      4'h9:
         begin
            TEST_A[0] <= RELEASE_AM;
            TEST_A[1] <= RELEASE_WRT;
            TEST_A[2] <= DONE;
            TEST_A[3] <= TRAIL_EDG_DS;
            TEST_A[4] <= LEAD_EDG_DTACK ;
            TEST_A[5] <= TRAIL_EDG_DTACK;
            TEST_A[6] <= LEAD_EDG_DTACK_D25;
            TEST_A[7] <= LEAD_EDG_BERR;
            TEST_A[8] <= DRV_DATA;
            TEST_A[9] <= LAST_WORD;
            TEST_A[10] <= LAST_CYCLE;
            TEST_A[11] <= DRV_DS;
            TEST_A[12] <= DRV_ADDR;
            TEST_A[13] <= DRV_AS;
            TEST_A[14] <= EOLC;
            TEST_A[15] <= END_D;
            TEST_B[0] <= GEN_DS;
            TEST_B[1] <= DS_HIGH_40;
            TEST_B[2] <= DS_FIRST_35;
            TEST_B[3] <= DS_VALDAT_35;
            TEST_B[4] <= WRITE;
            TEST_B[5] <= MON_AS;
            TEST_B[6] <= INT_DS0;
            TEST_B[7] <= INT_DS1;
            TEST_B[8] <= DS0;
            TEST_B[9] <= DS1;
            TEST_B[10] <= DATA_LOADED;
            TEST_B[11] <= DS_LDDAT_35;
            TEST_B[12] <= DS_DRVDAT_35;
            TEST_B[13] <= AS_HOLD_40;
            TEST_B[14] <= END;
            TEST_B[15] <= RAMD;
            TEST_C[0] <= START_PULSE;
            TEST_C[1] <= AS_HIGH_60;
            TEST_C[2] <= AS_DRV_35;
            TEST_C[3] <= ENA_SDAS0;
            TEST_C[4] <= SET_DRV_AS;
            TEST_C[5] <= ENA_SDWR0;
            TEST_C[6] <= DTACK;
            TEST_C[7] <= BERR;
            TEST_C[12:8] <= MSTR_ST;
            TEST_C[13] <= RST_DS_ENA;
            TEST_C[14] <= SET_DS_ENA;
            TEST_C[15] <= DS_ENA;
         end
      default:       //SW2 == 4 is used by Interrupt Handler.
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
            TEST_C <= 16'h0000;
         end
   endcase
end


////////////////////////////////////////
//                                    //
// Counter for 'DELAY' commands       //
//                                    //
////////////////////////////////////////

always @(posedge USRCLK)
begin
   LOADED <= LOAD_DLY;
   DCK_DV1024_CLR_1 <= DCK_DV1024_CLR;
end

always @(posedge DV1024CLK or posedge DCK_DV1024_CLR_1)
begin
   if(DCK_DV1024_CLR_1)
      DCK_DV1024_ENA <= 0;
   else
      DCK_DV1024_ENA <= 1;
end

always @(posedge USRCLK or posedge RST)
begin
   if(RST)
      DLY_CNT <= 32'h00000000;
   else
      if(LOAD_DLY)
         case(DL_TP)
            `No_Dly:
               DLY_CNT <= 32'h00000000;
            `D16nsX16,`D16nsX32,`D16usX16,`D16usX32:
               DLY_CNT <= FULL_ADDR[31:0];
            `D4nsX16,`D4nsX32:
               DLY_CNT <= {2'b00,FULL_ADDR[31:2]};
            default:
               DLY_CNT <= FULL_ADDR[31:0];
         endcase
      else if(DLY_ENA && !DLY_END)
         case(DL_TP)
            `No_Dly:
               DLY_CNT <= 32'h00000000;
            `D4nsX16,`D4nsX32:
               DLY_CNT <= DLY_CNT -1;
            `D16nsX16,`D16nsX32:
               DLY_CNT <= DLY_CNT -1;
            `D16usX16,`D16usX32:
               if(DCK_DV1024_ENA)
                  DLY_CNT <= DLY_CNT -1;
               else
                  DLY_CNT <= DLY_CNT;
            default:
               DLY_CNT <= DLY_CNT -1;
         endcase
      else
         DLY_CNT <= DLY_CNT;
end



always @(INT_DS0 or INT_DS1 or DS_ENA)
begin
   if(DS_ENA)
      begin
         DS0 <= INT_DS0;
         DS1 <= INT_DS1;
      end
   else
      begin
         DS0 <= 0;
         DS1 <= 0;
      end
end

always @(posedge SYSCLK)
begin
   if(LOAD_DNA)
      begin
         FULL_ADDR <= IN_ADDR;
         AM <= AD_MOD;
         WRITE <= WRT_RDB;
         A_SZ  <= UDAM_SZ;
         DT_SZ <= DATA_SZ;
         TR_TP <= TRNS_TYP;
         DL_TP <= DLY_TYP;
      end
   else
      begin
         FULL_ADDR <= FULL_ADDR;
         AM <= AM;
         WRITE <= WRITE;
         A_SZ  <= A_SZ;
         DT_SZ <= DT_SZ;
         TR_TP <= TR_TP;
         DL_TP <= DL_TP;
      end
end

always @(posedge SYSCLK or posedge CLR_DATA_LOADED)
begin
   if(CLR_DATA_LOADED)
      DATA_LOADED <= 0;
   else
      if(LOAD_DNA || LOAD_DATA)
         DATA_LOADED <= 1;
      else if(RST)
         DATA_LOADED <= 0;
      else
         DATA_LOADED <= DATA_LOADED;
end
always @(posedge SYSCLK)
begin
   if(LOAD_DNA || LOAD_DATA)
      begin
         FULL_DATA <= IN_DATA;
         LAST_WORD_REG <= LAST_WORD;
      end
   else
      begin
         FULL_DATA <= FULL_DATA;
         LAST_WORD_REG <= LAST_WORD_REG;
      end
end


always @(posedge SYSCLK or posedge RST)
begin: VME_MASTER_FSM
   if(RST)
      MSTR_ST <= `M_idle;
   else
      case(MSTR_ST)
         `M_idle:
            begin
               if(EXECUTE && !ACFAIL && !SYSFAIL && !BCLR && MASTER_ENA)
                  MSTR_ST <= `Capture1;
               else 
                  MSTR_ST <= `M_idle;
            end
         `Capture1:
            begin
               if(DLY_TYP != `No_Dly)
                  MSTR_ST <= `Load_Delay;
               else
                  MSTR_ST <= `Req_DTB;
            end
         `Req_DTB:          
            begin
               if(BUS_GRANTED)
                  if(PRBS)
                     MSTR_ST <= `R1;
                  else
                     MSTR_ST <= `Wait_4_DTB;
               else if(ARB_ERR)
                  MSTR_ST <= `No_Exe;
               else
                  MSTR_ST <= `Req_DTB;
            end
         `Load_Delay:
            begin
               if(LOADED)
                  MSTR_ST <= `Delay;
               else
                  MSTR_ST <= `Load_Delay;
            end
         `Delay:
            begin
               if(DLY_END)
                  MSTR_ST <= `M_idle;
               else
                  MSTR_ST <= `Delay;
            end
         `R1:
            MSTR_ST <= `Wait_4_DTB;
         `No_Exe:
            begin
               if(!EXECUTE)
                  MSTR_ST <= `M_idle;
               else
                  MSTR_ST <= `No_Exe;
            end
         `Wait_4_DTB:
            begin
               if(NOT_SUP)
                  MSTR_ST <= `Ld_Err_Typ;
               else if(!MON_AS)
                  MSTR_ST <= `Start;
               else
                  MSTR_ST <= `Wait_4_DTB;
            end
         `Start:                   
            begin
               if(DRV_AS && DRV_WRITE)
                  if(A64 || A40 || MBLT)
                     MSTR_ST <= `Add_Phase;
                  else if (TR_TP == `SNGL || TR_TP == `BLOCK || TR_TP == `UNALG) // Single, Block, or Unaligned transfers (SNGL,BLOCK,UNALG)              
                     MSTR_ST <= `Sngl_Block;
                  else if (TR_TP == `RMW) // Read-Modify-Write transfer (RMW)
                     MSTR_ST <= `RMW_1;
                  else              
                     MSTR_ST <= `Sngl_Block;
               else
                  MSTR_ST <= `Start;
            end
         `Add_Phase:
            begin
               if(BERR)
                  MSTR_ST <= `Ld_Err_Typ;
               else if(DTACK)
                  MSTR_ST <= `Wait_4_DTACK_Rel;
               else
                  MSTR_ST <= `Add_Phase;
            end
         `Wait_4_DTACK_Rel:
            begin
               if(!DTACK)
                  MSTR_ST <= `Sngl_Block;
               else
                  MSTR_ST <= `Wait_4_DTACK_Rel;
            end
         `Sngl_Block:
            begin
               if(BERR && VRD_IDLE)
                  MSTR_ST <= `Ld_Err_Typ;
               else if(DTACK && WRITE)
                  MSTR_ST <= `M_Write;
               else if(DTACK_D25 && !WRITE && VRD_IDLE)
                  MSTR_ST <= `M_Read;
               else
                  MSTR_ST <= `Sngl_Block;
            end
         `M_Write:
            begin
               if(!DSA)
                  MSTR_ST <= `Cycle_Done;
               else
                  MSTR_ST <= `M_Write;
            end
         `M_Read:
            begin
               if(!DSA)
                  MSTR_ST <= `Cycle_Done;
               else
                  MSTR_ST <= `M_Read;
            end
         `RMW_1:
            begin
               if(BERR)
                  MSTR_ST <= `Ld_Err_Typ;
               else if(DTACK_D25)
                  MSTR_ST <= `RMW_Read;
               else
                  MSTR_ST <= `RMW_1;
            end
         `RMW_Read:
            begin
               if(!DSA)
                  MSTR_ST <= `RMW_2;
               else
                  MSTR_ST <= `RMW_Read;
            end
         `RMW_2:
            begin
               if(BERR)
                  MSTR_ST <= `Ld_Err_Typ;
               else if(DTACK)
                  MSTR_ST <= `RMW_Write;
               else
                  MSTR_ST <= `RMW_2;
            end
         `RMW_Write:
            begin
               if(!DSA)
                  MSTR_ST <= `Cycle_Done;
               else
                  MSTR_ST <= `RMW_Write;
            end
         `Cycle_Done:
            begin
               if(LAST_CYCLE)
                  if(!DTACK)
                     MSTR_ST <= `Xfer_Done;
                  else
                     MSTR_ST <= `Cycle_Done;
               else
                  MSTR_ST <= `Next_Cycle;
            end
         `Next_Cycle:
            begin
               if(NEXT_RDY1 && !DTACK)
                  MSTR_ST <= `Sngl_Block;
               else
                  MSTR_ST <= `Next_Cycle;
            end
         `Xfer_Done:                    
            begin
               if(!DRV_ADDR && !DRV_WRITE)
                  MSTR_ST <= `M_idle;
               else
                  MSTR_ST <= `Xfer_Done;
            end
         `Ld_Err_Typ:
            MSTR_ST <= `Bus_Error;
         `Bus_Error:
            begin
               if(ACKN_ERR && !DRV_ADDR && !DRV_WRITE && CLR_ERR)
                  MSTR_ST <= `M_idle;
               else 
                  MSTR_ST <= `Bus_Error;
            end
         default:
            MSTR_ST <= `M_idle;
      endcase
end


always @(MSTR_ST)
begin
   case (MSTR_ST)
      `Wait_4_DTB:
         INC_PRBS <= 1;
      default:
         INC_PRBS <= 0;
   endcase
end

always @(MSTR_ST)
begin
   case (MSTR_ST)
      `Start:
         begin
            START <= 1;
         end
      default:
         begin
            START <= 0;
         end
   endcase
end

always @(MSTR_ST)
begin
   case (MSTR_ST)
      `Load_Delay:
         begin
            DLY_ENA <= 0;
            LOAD_DLY <= 1;
         end
      `Delay:
         begin
            DLY_ENA <= 1;
            LOAD_DLY <= 0;
         end
      default:
         begin
            DLY_ENA <= 0;
            LOAD_DLY <= 0;
         end
   endcase
end

always @(MSTR_ST)
begin
   case (MSTR_ST)
      `M_idle,`Capture1,`No_Exe:
         begin
            BUSY <= 0;
            REQ_BUS <= 0;
         end
      `Req_DTB:
         begin
            BUSY <= 0;
            REQ_BUS <= 1;
         end
      `Load_Delay,`Delay:
         begin
            BUSY <= 1;
            REQ_BUS <= 0;
         end
      default:
         begin
            BUSY <= 1;
            REQ_BUS <= 1;
         end
   endcase
end
always @(MSTR_ST or NEXT_RDY)
begin
   case (MSTR_ST)
      `Capture1:
         begin
            LOAD_DNA <= 1;
            LOAD_DATA <= 0;
         end
      `Next_Cycle:
         begin
            LOAD_DNA <= 0;
            LOAD_DATA <= NEXT_RDY;
         end
      default:
         begin
            LOAD_DNA <= 0;
            LOAD_DATA <= 0;
         end
   endcase
end
always @(MSTR_ST)
begin
   case (MSTR_ST)
      `Add_Phase,`Sngl_Block,`RMW_1,`RMW_2:
         GEN_DS <= 1;
      default:
         GEN_DS <= 0;
   endcase
end

always @(MSTR_ST or TRAIL_EDG_DS)
begin
   case (MSTR_ST)
      `M_Read,`M_Write,`RMW_Write:
         begin
            CLR_DATA_LOADED <= TRAIL_EDG_DS;
         end
      default:
         begin
            CLR_DATA_LOADED <= 0;
         end
   endcase
end

always @(MSTR_ST)
begin
   case (MSTR_ST)
      `M_Read,`RMW_Read:
         begin
            DAV <= 1;
         end
      default:
         begin
            DAV <= 0;
         end
   endcase
end
always @(MSTR_ST)
begin
   case (MSTR_ST)
      `Next_Cycle:
         begin
            NEXT_WRD <= 1;
         end
      default:
         begin
            NEXT_WRD <= 0;
         end
   endcase
end

always @(posedge SYSCLK or posedge RST)
begin
   if(RST)
      LAST_CYCLE <= 0;
   else
      case (MSTR_ST)
         `Start:
            case(TR_TP)
               `BLOCK:
                  LAST_CYCLE <= LAST_WORD_REG;
               default:
                  LAST_CYCLE <= 1;
            endcase
         `Next_Cycle:
            LAST_CYCLE <= LAST_WORD_REG;
//         `Xfer_Done,`Bus_Error:
         `M_idle:
            LAST_CYCLE <= 0;
         default:
            LAST_CYCLE <= LAST_CYCLE;
      endcase
end

always @(MSTR_ST or LAST_CYCLE)
begin
   case (MSTR_ST)
      `Add_Phase:
         begin
            ENA_END_ADDR <= 1;
            EOLC <= 0;
         end
      `Sngl_Block,`M_Read,`M_Write,`Cycle_Done,`RMW_2,`RMW_Write,`Xfer_Done:
         begin
            ENA_END_ADDR <= 0;
            EOLC <= LAST_CYCLE;
         end
      default:
         begin
            ENA_END_ADDR <= 0;
            EOLC <= 0;
         end
   endcase
end

always @(MSTR_ST)
begin
   case (MSTR_ST)
      `Ld_Err_Typ:
         begin
            LOAD_ET <= 1;
            BUS_ERR <= 0;
         end
      `Bus_Error:
         begin
            LOAD_ET <= 0;
            BUS_ERR <= 1;
         end
      default:
         begin
            LOAD_ET <= 0;
            BUS_ERR <= 0;
         end
   endcase
end

always @(posedge SYSCLK)
begin
   if (END_ADDR)
      ADD_PHASE <= 0;
   else if ((MSTR_ST == `Wait_4_DTB)&&(A64 || A40 || MBLT))
      ADD_PHASE <= 1;
   else
      ADD_PHASE <= ADD_PHASE;
end

always @(posedge SYSCLK)
begin: AM_DCode // Address Modifier Decode
   case(AM[5:3])
      3'd0:
          begin
             case(AM[2:0])
                3'd0: // A64 64-bit block transfer MBLT
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000010010000; 
                3'd1: // A64 single transfer access
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000000010000;
                3'd2,3'd6,3'd7:        // Reserved
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b10010000000000;
                3'd3: // A64  block transfer BLT
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000100010000;
                3'd4: // A64  lock command LCK
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000001010000;
                3'd5: // A32  lock command LCK
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000001000100;
                default:
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b10000000000000;
             endcase
          end
      3'd1:
          begin
             {A64,A40,A32,A24,A16} <= 5'b00100;
             {EXT_3U,EXT_6U,RSVD,UD} <= 4'h0; 
             case(AM[2:0])
                3'd0,3'd4: // A32 non-priv./supvrsy 64-bit block transfer MBLT
                   {NOT_SUP,BLT,MBLT,LCK,CR} <= 5'b00100; 
                3'd1,3'd2,3'd5,3'd6:        // A32 non-priv./supvrsy , prg/data
                   {NOT_SUP,BLT,MBLT,LCK,CR} <= 5'b00000; 
                3'd3,3'd7: // A32  non-priv./supvrsy block transfer BLT
                   {NOT_SUP,BLT,MBLT,LCK,CR} <= 5'b01000; 
                default:
                   {NOT_SUP,BLT,MBLT,LCK,CR} <= 5'b00000; 
             endcase
          end
      3'd2,3'd3:   // User defined: implemented as A24 for default.
         begin
            {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR} <= 9'b000010000; 
             case(A_SZ)
                `ASZ_A16:
                   {A64,A40,A32,A24,A16} <= 5'b00001;
                `ASZ_A24:
                   {A64,A40,A32,A24,A16} <= 5'b00010;
                `ASZ_A32:
                   {A64,A40,A32,A24,A16} <= 5'b00100;
                `ASZ_A40:
                   {A64,A40,A32,A24,A16} <= 5'b01000;
                `ASZ_A64:
                   {A64,A40,A32,A24,A16} <= 5'b10000;
                default:
                   {A64,A40,A32,A24,A16} <= 5'b00010;
             endcase
          end
      3'd4:
          begin
             {A64,A40,A32,A24,A16} <= 5'b00000;
             {UD,BLT,MBLT,LCK,CR} <= 5'b00000; 
             case(AM[2:0])
                3'd0: // Extended AM codes for 6U boards
                   {NOT_SUP,RSVD,EXT_3U,EXT_6U} <= 4'b1001;
                3'd1: // Extended AM codes for 3U boards
                   {NOT_SUP,RSVD,EXT_3U,EXT_6U} <= 4'b1010;
                default:
                   {NOT_SUP,RSVD,EXT_3U,EXT_6U} <= 4'b1100;
             endcase
          end
      3'd5:
          begin
             case(AM[2:0])
                3'd0,3'd2,3'd3,3'd6: // Reserved
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b10010000000000;
                3'd1,3'd5: // A16 non-priv./supvrsy access
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000000000001;
                3'd4: // A16  lock command LCK
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000001000001;
                3'd7: // Configuration ROM/Control & Status Register
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b10000000100000;
                default:
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b10000000000000;
             endcase
          end
      3'd6:
          begin
             case(AM[2:0])
                3'd0,3'd1,3'd3,3'd6: // Reserved
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b10010000000000;
                3'd2: // A24  lock command LCK
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000001000010;
                3'd4: // A40  access
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000000001000;
                3'd5: // A40  lock command LCK
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000001001000;
                3'd7: // A40BLT 
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b00000100001000;
                default:
                   {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b10000000000000;
             endcase
          end
      3'd7:
          begin
             {A64,A40,A32,A24,A16} <= 5'b00010;
             {EXT_3U,EXT_6U,RSVD,UD} <= 4'h0; 
             case(AM[2:0])
                3'd0,3'd4: // A24 non-priv./supvrsy 64-bit block transfer MBLT
                   {NOT_SUP,BLT,MBLT,LCK,CR} <= 5'b00100; 
                3'd1,3'd2,3'd5,3'd6:        // A24 non-priv./supvrsy , prg/data
                   {NOT_SUP,BLT,MBLT,LCK,CR} <= 5'b00000; 
                3'd3,3'd7: // A24  non-priv./supvrsy block transfer BLT
                   {NOT_SUP,BLT,MBLT,LCK,CR} <= 5'b01000; 
                default:
                   {NOT_SUP,BLT,MBLT,LCK,CR} <= 5'b00000; 
             endcase
          end
      default:
         {NOT_SUP,EXT_3U,EXT_6U,RSVD,UD,BLT,MBLT,LCK,CR,A64,A40,A32,A24,A16} <= 14'b10000000000000;
   endcase
end

always @(FULL_ADDR or ADD_PHASE or FULL_DATA or A64 or A40 or A32 or A24 or A16 or MBLT or MD32 or DT_SZ)
begin         // VME address lines
   if(MBLT && (DT_SZ==`Eight))
      if(ADD_PHASE)
         A <= {FULL_ADDR[31:3],2'b00};
      else
         A <= FULL_DATA[63:33];
   else if(MD32)
      if(ADD_PHASE)
         A <= {8'h00,FULL_ADDR[23:1]};
      else
         A <= {16'h0000,FULL_DATA[31:17]};  // MD32
   else 
      begin
         case({A64,A40,A32,A24,A16})
            5'b00001:
               A <= {16'h0000,FULL_ADDR[15:1]};
            5'b00010:
               A <= {8'h00,FULL_ADDR[23:1]};
            5'b00100:
               A <= FULL_ADDR[31:1];
            5'b01000:
               A <= {8'h00,FULL_ADDR[23:1]};
            5'b10000:
               A <= FULL_ADDR[31:1];
            default:
               A <= 32'h00000000;
         endcase
      end
   
end

      
always @(FULL_DATA or FULL_ADDR or A64 or A40 or ADD_PHASE or DT_SZ)
begin         // VME data lines
   if(ADD_PHASE)
      begin
         case({A64,A40})
            2'b01:
               D <= {16'h0000,FULL_ADDR[31:24],FULL_ADDR[39:32]};
            2'b10:
               D <= FULL_ADDR[63:32];
            default:
               D <= 32'h00000000;
         endcase
      end
   else
      begin
         casex({DT_SZ,FULL_ADDR[0]})
           3'B000: // BYTE (even) D08(E)
              D <= {16'h0000,FULL_DATA[7:0],8'h00};
           3'B001: // BYTE (odd) D08(O)
              D <= {24'h000000,FULL_DATA[7:0]};
           3'B01x: // WORD  D16
              D <= {16'h0000,FULL_DATA[15:0]};
           3'B10x: // LWORD  D32
              if(A40)
                 D <= {16'h0000,FULL_DATA[15:0]}; // MD32
              else
                 D <= FULL_DATA[31:0];
           3'B11x: // EIGHT  D64
              D <= FULL_DATA[31:0];
           default:
              D <= 32'h00000000;
         endcase
      end
end

// Data size mismatch error if EIGHT and not MBLT or MBLT and not Eight
// D64 transfers are specified by specific AM codes.  So data size must match the AM.

always @(DT_SZ or FULL_ADDR[0] or FULL_DATA or MBLT or ADD_PHASE or DL_TP or A40)
begin
   if(DL_TP == `No_Dly)
      case (DT_SZ)
         `Byte:
            begin
               LWORD <= 0;
               INT_DS1 <= !FULL_ADDR[0];
               INT_DS0 <= FULL_ADDR[0];
            end
         `Word:
            begin
               LWORD <= 0;
               INT_DS1 <= 1;
               INT_DS0 <= 1;
            end
         `LWord:
            if(A40)
               if(ADD_PHASE)
                  begin
                     LWORD <= 1;
                     INT_DS1 <= 1;
                     INT_DS0 <= 1;
                  end
               else 
                  begin
                     LWORD <= FULL_DATA[16];
                     INT_DS1 <= 1;
                     INT_DS0 <= 1;
                  end
            else
               begin
                  LWORD <= 1;
                  INT_DS1 <= 1;
                  INT_DS0 <= 1;
               end
         `Eight:
            if(MBLT)
               if(ADD_PHASE)
                  begin
                     LWORD <= 1;
                     INT_DS1 <= 1;
                     INT_DS0 <= 1;
                  end
               else 
                  begin
                     LWORD <= FULL_DATA[32];
                     INT_DS1 <= 1;
                     INT_DS0 <= 1;
                  end
            else
               begin
                  LWORD <= 0;
                  INT_DS1 <= 0;
                  INT_DS0 <= 0;
               end
         default:
            begin
               LWORD <= 0;
               INT_DS1 <= 0;
               INT_DS0 <= 0;
            end
      endcase
   else
      begin
         LWORD <= 0;
         INT_DS1 <= 0;
         INT_DS0 <= 0;
      end
end


always @(posedge SYSCLK)
begin
   if (RELEASE_AM)
      DRV_AM <= 0;
   else if (START_PULSE)
      DRV_AM <= 1;
   else
      DRV_AM <= DRV_AM;
end

always @(posedge SYSCLK)
begin
   if (RELEASE_DS)
      DRV_DS <= 0;
   else if (START_PULSE)
      DRV_DS <= 1;
   else
      DRV_DS <= DRV_DS;
end

always @(posedge SYSCLK)
begin
   if (RELEASE_ADDR || RELEASE_AM)
      begin
         DRV_ADDR <= 0;
         DRV_LWORD <= 0;
      end
   else if (START_PULSE)
      begin
         DRV_ADDR <= 1;
         DRV_LWORD <= 1;
      end
   else
      begin
         DRV_ADDR <= DRV_ADDR;
         DRV_LWORD <= DRV_LWORD;
      end
end

//
always @(posedge SYSCLK)
begin: DRV_AS_REG
   if (RST_DRV_AS)
      DRV_AS <= 0;
   else if (SET_DRV_AS)
      DRV_AS <= 1;
   else
      DRV_AS <= DRV_AS;
end
//
always @(posedge SYSCLK)
begin: AS_REG
   if (RST_AS)
      AS <= 0;
   else if (SET_AS)
      AS <= 1;
   else
      AS <= AS;
end

//////////////////////////////////////////////////////////////////
// Temporary fix for Slaves that rely on raw address lines      //
// in order to maintain the DATA on the bus after DTACK         //
// and before the trailing edge of the data strobes.            // 
//////////////////////////////////////////////////////////////////

// Should use leading edge of DTACK to release the address lines 

always @(posedge SYSCLK or negedge DRV_ADDR)
begin
   if (!DRV_ADDR)
      END_ADDR <= 0;
   else 
      if((LEAD_EDG_DTACK && ENA_END_ADDR) || LEAD_EDG_BERR) 
         END_ADDR <= 1;
      else
         END_ADDR <= END_ADDR;
end

// Alternative is to use trailing edge of data strobes to release the address lines

//always @(posedge SYSCLK or negedge DRV_ADDR)
//begin
//   if (!DRV_ADDR)
//      END_ADDR <= 0;
//   else
//      if(TRAIL_EDG_DS) 
//         END_ADDR <= (MSTR_ST == `M_Read) || (MSTR_ST == `M_Write) || (MSTR_ST == `RMW_Write);
//      else if(LEAD_EDG_BERR) 
//         END_ADDR <= 1;
//      else
//         END_ADDR <= END_ADDR;
//end

//////////////////////////////////////////////////////////////////
//         
//always @(posedge SYSCLK or posedge RST_END)
//begin
//   if (RST_END)
//      END_A <= 0;
//   else 
//      if((LEAD_EDG_DTACK && EOLC) || LEAD_EDG_BERR) 
//         END_A <= 1;
//      else
//         END_A <= END_A;
//end
always @(posedge SYSCLK or posedge RST_END)
begin
   if (RST_END)
      END_A <= 0;
   else 
      if((TRAIL_EDG_DS && EOLC) || LEAD_EDG_BERR) 
         END_A <= 1;
      else
         END_A <= END_A;
end

//always @(posedge SYSCLK or posedge RST_END)
//begin
//   if (RST_END)
//      END_B <= 0;
//   else 
//      if((TRAIL_EDG_DTACK && EOLC) || LEAD_EDG_BERR) 
//         END_B <= 1;
//      else
//         END_B <= END_B;
//end
always @(posedge SYSCLK or posedge RST_END)
begin
   if (RST_END)
      END_B <= 0;
   else 
      if((TRAIL_EDG_DS && EOLC) || LEAD_EDG_BERR) 
         END_B <= 1;
      else
         END_B <= END_B;
end
//
////////////////////////////////////////////////////////////////

always @(END_A or END_B or MBLT or MD32 or WRITE)
begin
   if((MBLT || MD32) && !WRITE)
      END <= END_B;
   else
      END <= END_A;
end

always @(posedge SYSCLK or posedge RST_END)
begin
   if (RST_END)
      END_D <= 0;
   else 
      if((TRAIL_EDG_DS && EOLC) || LEAD_EDG_BERR) 
         END_D <= 1;
      else
         END_D <= END_D;
end


always @(posedge SYSCLK)
begin
   if (RELEASE_WRT)
      DRV_WRITE <= 0;
   else if (SET_DRV_WRITE)
      DRV_WRITE <= 1;
   else
      DRV_WRITE <= DRV_WRITE;
end
         

always @(posedge SYSCLK)
begin
   if (RELEASE_DATA)
      DRV_DATA <= 0;
   else if (SET_DRV_WRITE)
      if(WRITE || ADD_PHASE)
         DRV_DATA <= 1;
      else
         DRV_DATA <= 0;
   else
      DRV_DATA <= DRV_DATA;
end

always @(posedge SYSCLK)
begin
   if (RST_DS_ENA)
      DS_ENA <= 0;
   else if (SET_DS_ENA)
      DS_ENA <= 1;
   else
      DS_ENA <= DS_ENA;
end

always @(DTACK or BERR or ADD_PHASE or ACKN_DAV or WRITE)
begin
   if(WRITE || ADD_PHASE)
      RST_DS_ENA <= DTACK || BERR;
   else
      RST_DS_ENA <= ACKN_DAV || BERR;
end

always @(posedge SYSCLK)
begin
   ACKN_IH_DAV <= (ACKN == `V_IH_Dav);
   ACKN_DAV <= (ACKN == `V_Mstr_Dav);
   ACKN_ERR <= (ACKN == `V_Mstr_Err);
end
      
always @(posedge SYSCLK or posedge RST)
begin         // VME data lines
   if (RST)
      OUT_DATA <= 64'h0000000000000000;
   else
      if(LEAD_EDG_DTACK_D25 && !MON_IACK) 
         casex({DT_SZ,FULL_ADDR[0]})
            3'B000: // BYTE (even) D08(E)
               OUT_DATA <= {56'h00000000000000,D_FROM[15:8]};
            3'B001: // BYTE (odd) D08(O)
               OUT_DATA <= {56'h00000000000000,D_FROM[7:0]};
            3'B01x: // WORD  D16
               OUT_DATA <= {48'h000000000000,D_FROM[15:0]};
            3'B10x: // LWORD  D32
               if(A40)
                  OUT_DATA <= {32'h00000000,A_FROM[15:1],LWORD_FROM,D_FROM[15:0]};   //MD32
               else
                  OUT_DATA <= {32'h00000000,D_FROM[31:0]};
            3'B11x: // EIGHT  D64
               OUT_DATA <= {A_FROM,LWORD_FROM,D_FROM};
            default:
               OUT_DATA <= 64'h0000000000000000;
         endcase
      else if(LEAD_EDG_DTACK_D25 && MON_IACK) 
         case(IH_DT_SZ)
            `Byte: // BYTE (odd) D08(O)
               OUT_DATA <= {56'h00000000000000,D_FROM[7:0]};
            `Word: // WORD  D16
               OUT_DATA <= {48'h000000000000,D_FROM[15:0]};
            `LWord: // LWORD  D32
               OUT_DATA <= {32'h00000000,D_FROM[31:0]};
            default:
               OUT_DATA <= 64'h0000000000000000;
         endcase
      else if(ACKN_DAV || ACKN_IH_DAV) 
         OUT_DATA <= 64'h0000000000000000;
      else
         OUT_DATA <= OUT_DATA;
end
always @(posedge SYSCLK or posedge RST)
begin         // VME Condition Register
   if (RST)
      COND_REG <= 8'h00;
   else
      COND_REG <= {NOT_SUP,BTO,BERR,MSTR_ST}; 
end
always @(posedge SYSCLK or posedge RST)
begin         // VME Error Register
   if (RST)
      ERR_REG <= 8'h00;
   else
      if(LOAD_ET)
         ERR_REG <= COND_REG; 
      else if(ACKN_ERR)
         ERR_REG <= 8'h00;
      else
         ERR_REG <= ERR_REG;
end
   
// Linear feedback shift register [21, 19] Galois implementation
always @(posedge SYSCLK or posedge RST)
begin
   if(RST)
      R <= `PRBS_seed;
   else
      if(PRBS_ENA)
        R <= {R[19],R[20]^R[18],R[17:0],R[20]};
      else
         R <= R;
end
endmodule
