// Verilog model  - Thu Oct 14 07:47:07 2004

`timescale 1ns / 1ps

module vme_requester(BUS_REQ, ENA, MON_BBSY, MON_BGIN, MON_BR,RST,
      REQ_LVL, REQ_TYP, SYSCLK, SW2, BBSY, BGOUT, BR, BUS_GRANTED, TEST_A, TEST_B, TEST_C);

    input BUS_REQ;
    input ENA;
    input MON_BBSY;
    input [3:0] MON_BGIN;
    input [3:0] MON_BR;
    input RST;
    input [1:0] REQ_LVL;
    input [1:0] REQ_TYP;
    input SYSCLK;
    input [3:0] SW2;
   output BBSY;
   output [3:0] BGOUT;
   output [3:0] BR;
   output BUS_GRANTED;
   output [15:0] TEST_A;
   output [15:0] TEST_B;
   output [15:0] TEST_C;

wire FAIR_ENA;
wire RDY_4_REL;

reg BBSY;
reg [3:0] BGOUT;
reg [3:0] BR;
reg [15:0] TEST_A;
reg [15:0] TEST_B;
reg [15:0] TEST_C;
reg BUS_GRANTED;
reg LOCAL_GRANT;
reg [4:0] DMBR;
reg MY_BR;
reg MY_BGIN;
reg DRV_BGOUT;
reg BUS_REQ_1;
reg S_BUS_REQ;
reg L_BUS_REQ;
reg D_BUS_REQ;
reg S_BGIN;
reg D_BGIN;
wire BBSY_HOLD_90;
wire BR_REL_D30;
reg SET_BR;
reg RELEASE_BBSY;
reg D32_BR;
reg D32_BBSY;
reg D96_BBSY;
reg DR0,DR1,DR2;
reg DB0,DB1,DB2;
reg DH0,DH1,DH2,DH3,DH4,DH5;
reg DH6,DH7,DH8,DH9,DH10;
//reg [13:0] RQR_TST;
   
`ifdef HEADER
`else
`include "header.v"
`endif

always @(posedge SYSCLK)
begin
   case (SW2)
      4'h5:
         begin
            TEST_A[1:0] <= REQ_LVL;
            TEST_A[3:2] <= REQ_TYP;
            TEST_A[7:4] <= BGOUT;
            TEST_A[8] <= MY_BR;
            TEST_A[9] <= MY_BGIN;
            TEST_A[10] <= DRV_BGOUT;
            TEST_A[11] <= SET_BR;
            TEST_A[12] <= S_BUS_REQ;
            TEST_A[13] <= FAIR_ENA;
            TEST_A[14] <= RDY_4_REL;
            TEST_A[15] <= LOCAL_GRANT;
            TEST_B <= 16'h0000;
            TEST_C <= 16'h0000;
         end
      4'h6:
         begin
            TEST_A <= 16'h0000;
            TEST_B[0] <= BBSY;
            TEST_B[1] <= RDY_4_REL;
            TEST_B[2] <= BBSY_HOLD_90;
            TEST_B[3] <= BR_REL_D30;
            TEST_B[4] <= RELEASE_BBSY;
            TEST_B[5] <= LOCAL_GRANT;
            TEST_B[6] <= DRV_BGOUT;
            TEST_B[7] <= S_BUS_REQ;
            TEST_B[8] <= D_BUS_REQ;
            TEST_B[9] <= L_BUS_REQ;
            TEST_B[10] <= SET_BR;
            TEST_B[11] <= BR[3];
            TEST_B[12] <= S_BGIN;
            TEST_B[13] <= D_BGIN;
            TEST_B[14] <= 0;
            TEST_B[15] <= 0;
            TEST_C <= 16'h0000;
         end
      default:
         begin
            TEST_A <= 16'h0000;
            TEST_B <= 16'h0000;
            TEST_C <= 16'h0000;
         end
   endcase
end

always @(posedge SYSCLK)
begin
   BUS_REQ_1 <= BUS_REQ;
   D_BUS_REQ <= BUS_REQ_1;
end

always @(posedge SYSCLK)
begin
   case(REQ_LVL)
      2'b00:
         MY_BGIN <= MON_BGIN[0];
      2'b01:
         MY_BGIN <= MON_BGIN[1];
      2'b10:
         MY_BGIN <= MON_BGIN[2];
      2'b11:
         MY_BGIN <= MON_BGIN[3];
      default:
         MY_BGIN <= MON_BGIN[3];
   endcase
end

always @(posedge SYSCLK)
begin
   case(REQ_LVL)
      2'b00:
         MY_BR <= MON_BR[0];
      2'b01:
         MY_BR <= MON_BR[1];
      2'b10:
         MY_BR <= MON_BR[2];
      2'b11:
         MY_BR <= MON_BR[3];
      default:
         MY_BR <= MON_BR[3];
   endcase
end

always @(posedge SYSCLK)
begin
   DMBR[0] <= MY_BR;
   DMBR[1] <= DMBR[0];
   DMBR[2] <= DMBR[1];
   DMBR[3] <= DMBR[2];
   DMBR[4] <= DMBR[3];  // 40ns pipeline
end

assign FAIR_ENA = !(|DMBR);  // wait 40ns before new request;
   
// Bus Request Set Logic and local "BUS_GRANTED" logic   
always @(posedge SYSCLK)
begin
   if(ENA)
      begin
         BUS_GRANTED <= D_BUS_REQ && BBSY;
         if(REQ_TYP[1])          // Fair Requester
            SET_BR <= FAIR_ENA && D_BUS_REQ && !BBSY && !D32_BBSY;
         else                    // Not a Fair Requester
            SET_BR <= D_BUS_REQ && !BBSY && !D32_BBSY;
      end
   else
      begin
         SET_BR <= 0;
         BUS_GRANTED <= 0;
      end
end   

// Bus Request Logic  

always @(posedge SYSCLK or posedge RST)
begin
   if(RST)
      BR <= 4'h0;
   else
      if (SET_BR)
         case(REQ_LVL)
            2'b00:
               BR <= 4'h1;
            2'b01:
               BR <= 4'h2;
            2'b10:
               BR <= 4'h4;
            2'b11:
               BR <= 4'h8;
            default:
               BR <= 4'h8;
         endcase
      else if (D32_BBSY && (|BR))
         BR <= 4'h0;
      else
         BR <= BR; 
end


// Bus Grant Out Logic 

always @(posedge SYSCLK)
begin
   S_BGIN <= MY_BGIN;
   D_BGIN <= S_BGIN;
end

always @(posedge SYSCLK or posedge RST)
begin
   if(RST)
      S_BUS_REQ <= 0;
   else
      if (BBSY && !D_BGIN)
         S_BUS_REQ <= 0;
      else if (BUS_REQ_1 && !DRV_BGOUT && !S_BGIN)
         S_BUS_REQ <= 1;
      else
         S_BUS_REQ <= S_BUS_REQ;
end

always @(posedge SYSCLK or posedge RST)
begin
   if(RST)
      L_BUS_REQ <= 0;
   else
      if (S_BUS_REQ && S_BGIN)
         L_BUS_REQ <= 1;
      else if (BBSY && !D_BGIN)
         L_BUS_REQ <= 0;
      else
         L_BUS_REQ <= L_BUS_REQ; 
end
  
always @(posedge SYSCLK)
begin
   if(ENA)
      begin
         if(L_BUS_REQ)
            begin
               DRV_BGOUT <= 0;
               LOCAL_GRANT <= D_BGIN;
            end
         else
            begin
               DRV_BGOUT <= D_BGIN;
               LOCAL_GRANT <= 0;
            end
      end
   else
      begin
         DRV_BGOUT <= MY_BGIN;
         LOCAL_GRANT <= 0;
      end
end   

always @(posedge SYSCLK)
begin
   case(REQ_LVL)
      2'b00:
         begin
            BGOUT[0] <= DRV_BGOUT;
            BGOUT[1] <= MON_BGIN[1];
            BGOUT[2] <= MON_BGIN[2];
            BGOUT[3] <= MON_BGIN[3];
         end
      2'b01:
         begin
            BGOUT[0] <= MON_BGIN[0];
            BGOUT[1] <= DRV_BGOUT;
            BGOUT[2] <= MON_BGIN[2];
            BGOUT[3] <= MON_BGIN[3];
         end
      2'b10:
         begin
            BGOUT[0] <= MON_BGIN[0];
            BGOUT[1] <= MON_BGIN[1];
            BGOUT[2] <= DRV_BGOUT;
            BGOUT[3] <= MON_BGIN[3];
         end
      2'b11:
         begin
            BGOUT[0] <= MON_BGIN[0];
            BGOUT[1] <= MON_BGIN[1];
            BGOUT[2] <= MON_BGIN[2];
            BGOUT[3] <= DRV_BGOUT;
         end
      default:
         begin
            BGOUT[0] <= MON_BGIN[0];
            BGOUT[1] <= MON_BGIN[1];
            BGOUT[2] <= MON_BGIN[2];
            BGOUT[3] <= DRV_BGOUT;
         end
   endcase
end



// Bus Busy Logic
   
always @(posedge SYSCLK)
begin
   if(ENA)
      begin
         if (LOCAL_GRANT)
            BBSY <= 1;
         else if (RELEASE_BBSY)
            BBSY <= 0;
         else
            BBSY <= BBSY;
      end
   else
      BBSY <= 0;
end

// Ensure timing requirements of release of BBSY
assign RDY_4_REL = BBSY_HOLD_90 && BR_REL_D30 && !MY_BGIN && !BUS_REQ_1;
assign BR_REL_D30 = !(|BR) && !D32_BR;
assign BBSY_HOLD_90 =  BBSY && D96_BBSY;

  
always @(REQ_TYP or RDY_4_REL or MON_BR or RST)
begin
   if(RST)
      RELEASE_BBSY <= 1;
   else
      if(REQ_TYP[0])                  // Release When Done (RWD) Requester
         RELEASE_BBSY <= RDY_4_REL;
      else                         // Release On Request (ROR) Requester
         RELEASE_BBSY <= RDY_4_REL && (|MON_BR);
end   

always @(posedge SYSCLK)
begin
   DR0 <= (|BR);
   DR1 <= DR0;
   DR2 <= DR1;
   D32_BR <= DR2; // 32ns delay
	DB0 <= BBSY;
   DB1 <= DB0;
   DB2 <= DB1;
   D32_BBSY <= DB2;  // 32ns delay
   DH0 <= BBSY;
   DH1 <= DH0;
   DH2 <= DH1;
   DH3 <= DH2;
   DH4 <= DH3;
   DH5 <= DH4;
   DH6 <= DH5;
   DH7 <= DH6;
   DH8 <= DH7;
   DH9 <= DH8;
   DH10 <= DH9;
   D96_BBSY <= DH10; // 96ns Delay
end


endmodule
