// Verilog model  - Thu Oct 28 11:40:04 2004

`timescale 1ns / 1ps

module vme_slave(A, AM, AS, D, DIN, DS0, DS1, ENA_OUT, GA, GAP, IACK, LWORD,
      READ_CNT, SEL, SLAVE_ENA, SYSCLK, SYSRESET, VME64X_ENA, WRITE, WRTCTRL,
      A_TO_VME, BERR, DRV_A, DRV_D, DRV_DTACK, DTACK, D_TO_VME);

    input [31:1] A;
    input [5:0] AM;
    input AS;
    input [31:0] D;
    input [15:0] DIN;
    input DS0;
    input DS1;
    input ENA_OUT;
    input [4:0] GA;
    input GAP;
    input IACK;
    input LWORD;
    input READ_CNT;
    input [3:0] SEL;
    input SLAVE_ENA;
    input SYSCLK;
    input SYSRESET;
    input VME64X_ENA;
    input WRITE;
    input WRTCTRL;
   output [31:1] A_TO_VME;
   output BERR;
   output DRV_A;
   output DRV_D;
   output DRV_DTACK;
   output DTACK;
   output [31:0] D_TO_VME;
//   output [7:0] TEST_OUT; 
   
`ifdef HEADER
`else
`include "header.v"
`endif

reg DSAD_8,DSAD_16,DSAD_24,DSAD_32,DSAD_40,DSAD_48;
reg   SET_DTACK;
reg   RST_DRV_DTACK;
reg   DRV_DTACK;
reg   DTACK;
reg   [31:0] D_TO_VME;
reg   [31:1] VADDR;
reg   [5:0] VAM;

reg [15:0] REG1;
reg [15:0] REG2;
reg [15:0] REG3;
reg [15:0] RND4REG;
reg SLT1_MTCH;
reg A24_NON;
reg  [9:0] VMEM_ADDR;
reg  [15:0] ram [1023:0]; 
reg  [15:0] VMEM_DATA; 
reg  [15:0] WRT_REG;
reg DTACKD1;
reg ASD1; 
reg VMEM_SEL;
reg VRND_RBN;
//wire  [7:0] TEST_OUT; 

wire DSA;
wire LEAD_EDG_AS;
wire TRAIL_EDG_DTACK;
wire SET_DRV_DTACK;
wire RST_DTACK;
wire DRV_D;
wire VMEM_WE;

initial
begin
   DTACK = 0;
   DRV_DTACK = 0;
end 
   
assign A_TO_VME = 31'h00000000;
assign BERR = 0;
assign DRV_A = 0;
assign LEAD_EDG_AS = AS & !ASD1;
assign TRAIL_EDG_DTACK = !DTACK & DTACKD1;

assign DSA = (DS0 | DS1);
assign SET_DRV_DTACK = SLT1_MTCH && DSAD_40 && !DSAD_48;
assign RST_DTACK     = SLT1_MTCH && !DSA && DSAD_8;
assign DRV_D         = SLT1_MTCH && DSAD_8 && !WRITE;
assign VMEM_WE       = VMEM_SEL && WRITE && DSAD_16 && !DSAD_24;

//assign TEST_OUT = {SLT1_MTCH,A24_NON,VMEM_WE,VMEM_SEL,VRND_RBN,SET_DRV_DTACK,RST_DTACK,DSA};
//assign TEST_OUT = {SLT1_MTCH,A24_NON,VAM};
//assign TEST_OUT = {SLT1_MTCH,A24_NON,VMEM_WE,VADDR[23:19]};
//assign TEST_OUT = {SLT1_MTCH,A24_NON,VMEM_WE,GA};

always @(posedge SYSCLK)
begin
   DSAD_8 <= DSA;
   DSAD_16 <= DSAD_8;
   DSAD_24 <= DSAD_16;
   DSAD_32 <= DSAD_24;
   DSAD_40 <= DSAD_32;
   DSAD_48 <= DSAD_40;
   ASD1 <= AS;
   DTACKD1 <= DTACK;
   VMEM_SEL <= SLT1_MTCH && A24_NON && (VADDR[18:11]==8'h05);
   VRND_RBN <= SLT1_MTCH && A24_NON && (VADDR[18:11]==8'h00);
   SET_DTACK <= SET_DRV_DTACK;
   RST_DRV_DTACK <= RST_DTACK;
end

always @(posedge SYSCLK)
begin
   if(LEAD_EDG_AS)
      begin
         VADDR <= A;
         VAM   <= AM;
         SLT1_MTCH <= (A[23:19]==GA) && (^{GAP,GA} == 1);
         A24_NON <= (AM == 6'h39);
      end
   else
      begin
         VADDR <= VADDR;
         VAM   <= VAM;
         SLT1_MTCH <= SLT1_MTCH;
         A24_NON <= A24_NON;
      end
end

always @(posedge SYSCLK)
begin
//
   if (RST_DRV_DTACK)
      DRV_DTACK <= 0;
   else if (SET_DRV_DTACK)
      DRV_DTACK <= 1;
   else
      DRV_DTACK <= DRV_DTACK;
//
   if (RST_DTACK)
      DTACK <= 0;
   else if (SET_DTACK)
      DTACK <= 1;
   else
      DTACK <= DTACK;
//
end

always @(posedge SYSCLK or posedge SYSRESET)
begin
   if(SYSRESET)
      begin
         REG1 <= 16'h1111;   
         REG2 <=  16'h2222;
         REG3 <=  16'h3333;
         RND4REG <=  16'h4444;
      end
   else
      if(TRAIL_EDG_DTACK && !WRITE && VRND_RBN)
         begin
            REG1 <= RND4REG;
            REG2 <= REG1;
            REG3 <= REG2;
            RND4REG <= REG3;
	 end
      else   
         begin
            REG1 <= REG1;
            REG2 <= REG2;
            REG3 <= REG3;
            RND4REG <= RND4REG;
	 end
end

always @(posedge SYSCLK)
begin
   if(!WRITE && VRND_RBN)
      D_TO_VME <= {16'h0000,RND4REG};
   else if(!WRITE && VMEM_SEL)
      D_TO_VME  <= {16'h0000,VMEM_DATA};
   else
      D_TO_VME  <= 32'h0000DEAD;
//
   if (VMEM_SEL)
      VMEM_ADDR <= VADDR[10:1];
   else
      VMEM_ADDR <= VMEM_ADDR;
end

always @(posedge SYSCLK)
begin
   if (DSAD_8 && !DSAD_16 && VMEM_SEL && WRITE)
      WRT_REG <= D;
   else
      WRT_REG <= WRT_REG;
end
 always @(posedge SYSCLK)
 begin 
    if (VMEM_WE) 
       ram[VMEM_ADDR] <= WRT_REG;
    else 
       VMEM_DATA <= ram[VMEM_ADDR];
 end  

endmodule
